(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17941,        645]
NotebookOptionsPosition[     14063,        512]
NotebookOutlinePosition[     15355,        549]
CellTagsIndexPosition[     15270,        544]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks" :> Documentation`HelpLookup["paclet:ref/Notebooks"],
           "EvaluationNotebook" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationNotebook"], 
          "SelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SelectedNotebook"], 
          "InputNotebook" :> 
          Documentation`HelpLookup["paclet:ref/InputNotebook"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Notebooks\"\>", 
       2->"\<\"EvaluationNotebook\"\>", 3->"\<\"SelectedNotebook\"\>", 
       4->"\<\"InputNotebook\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButtonNotebook", "ObjectName",
 CellID->24607],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ButtonNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ButtonNotebook"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the notebook, if any, that contains the button \
which initiated the current evaluation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ButtonNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonNotebook"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26013],

Cell[TextData[{
 "If a button in a palette initiates evaluation in another notebook, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ButtonNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonNotebook"], "[", "]"}]], "InlineFormula"],
 " will be the palette, but ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EvaluationNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationNotebook"], "[", "]"}]], 
  "InlineFormula"],
 " will be the other notebook. "
}], "Notes",
 CellID->10674],

Cell[TextData[{
 "If the current evaluation was not initiated by a button, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ButtonNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonNotebook"], "[", "]"}]], "InlineFormula"],
 " will return ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28855]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20950394],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->495749718],

Cell[TextData[{
 "Make a button that sets ",
 Cell[BoxData["nb"], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " for the button's notebook:"
}], "ExampleText",
 CellID->168394797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Set nb\>\"", ",", 
   RowBox[{"nb", "=", 
    RowBox[{"ButtonNotebook", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914699132],

Cell[BoxData[
 ButtonBox["\<\"Set nb\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Set nb",
  ButtonFrame->"DialogBox",
  ButtonFunction:>($CellContext`nb = ButtonNotebook[]),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{45, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263280852]
}, Open  ]],

Cell["After the button is clicked the variable is assigned:", "ExampleText",
 CellID->90733094],

Cell[CellGroupData[{

Cell[BoxData["nb"], "Input",
 CellLabel->"In[2]:=",
 CellID->114487187],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["ivm_shm", 3, 3]], 26]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       TagBox[
        TooltipBox["26",
         "\"C:\\\\Code\\\\CVS_HEAD\\\\Mathematica\\\\Documentation\\\\English\
\\\\System\\\\ReferencePages\\\\Symbols\\\\ButtonNotebook.nb\""],
        Annotation[#, 
         "C:\\Code\\CVS_HEAD\\Mathematica\\Documentation\\English\\System\\\
ReferencePages\\Symbols\\ButtonNotebook.nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["ivm_shm", 3, 3]], 26],
  Editable->False]], "Output",
 ImageSize->{171, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355358297]
}, Open  ]],

Cell["Use the object for further processing:", "ExampleText",
 CellID->162454590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"nb", ",", "WindowSize"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21973443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WindowSize", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"720", ",", "734"}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->128182918]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->712626884],

Cell["\<\
Create a palette button that writes to the input notebook and then closes the \
palette:\
\>", "ExampleText",
 CellID->85518964],

Cell[BoxData[
 RowBox[{
  RowBox[{"pal", "=", 
   RowBox[{"CreatePalette", "[", 
    RowBox[{"{", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Test\>\"", ",", 
       RowBox[{
        RowBox[{"NotebookWrite", "[", 
         RowBox[{
          RowBox[{"InputNotebook", "[", "]"}], ",", "\"\<Done\>\""}], "]"}], 
        ";", 
        RowBox[{"NotebookClose", "[", " ", 
         RowBox[{"ButtonNotebook", "[", "]"}], "]"}]}]}], "]"}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357790862]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->173086620],

Cell["\<\
The button notebook is sometimes not the same as the current input notebook:\
\>", "ExampleText",
 CellID->765026304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<New notebook\>\"", ",", 
   RowBox[{
    RowBox[{"CreateDocument", "[", "]"}], ";", 
    RowBox[{"bnb", "=", 
     RowBox[{"ButtonNotebook", "[", "]"}]}], ";", " ", 
    RowBox[{"inb", "=", 
     RowBox[{"InputNotebook", "[", "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23822718],

Cell[BoxData[
 ButtonBox["\<\"New notebook\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/New notebook",
  ButtonFrame->"DialogBox",
  ButtonFunction:>(
   CreateDocument[]; $CellContext`bnb = ButtonNotebook[]; $CellContext`inb = 
    InputNotebook[]),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{83, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->818041783]
}, Open  ]],

Cell["\<\
After clicking the button, these two notebooks are different: \
\>", "ExampleText",
 CellID->100319238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WindowTitle\>\"", "/.", 
  RowBox[{"(", 
   RowBox[{"NotebookInformation", "/@", 
    RowBox[{"{", 
     RowBox[{"bnb", ",", "inb"}], "}"}]}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24647440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ButtonNotebook.nb\"\>", ",", "\<\"Untitled-6\"\>"}], 
  "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27442013]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7942],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2456]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21132],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->30292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->118433423]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButtonNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 52.6780554}", "context" -> "System`", 
    "keywords" -> {"palette notebook"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ButtonNotebook[] gives the notebook, if any, that contains the button \
which initiated the current evaluation. ", "synonyms" -> {"button notebook"}, 
    "title" -> "ButtonNotebook", "type" -> "Symbol", "uri" -> 
    "ref/ButtonNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5242, 174, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20950394]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15128, 537}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 82, 52, 1, 70, "ObjectName",
 CellID->24607],
Cell[2910, 85, 527, 16, 70, "Usage",
 CellID->31619]
}, Open  ]],
Cell[CellGroupData[{
Cell[3474, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3952, 123, 328, 12, 70, "Notes",
 CellID->26013],
Cell[4283, 137, 510, 16, 70, "Notes",
 CellID->10674],
Cell[4796, 155, 409, 14, 70, "Notes",
 CellID->28855]
}, Closed]],
Cell[CellGroupData[{
Cell[5242, 174, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20950394],
Cell[CellGroupData[{
Cell[5626, 188, 148, 5, 70, "ExampleSection",
 CellID->495749718],
Cell[5777, 195, 297, 10, 70, "ExampleText",
 CellID->168394797],
Cell[CellGroupData[{
Cell[6099, 209, 201, 6, 28, "Input",
 CellID->914699132],
Cell[6303, 217, 376, 12, 46, "Output",
 CellID->263280852]
}, Open  ]],
Cell[6694, 232, 95, 1, 70, "ExampleText",
 CellID->90733094],
Cell[CellGroupData[{
Cell[6814, 237, 71, 2, 28, "Input",
 CellID->114487187],
Cell[6888, 241, 1355, 39, 60, "Output",
 CellID->355358297]
}, Open  ]],
Cell[8258, 283, 81, 1, 70, "ExampleText",
 CellID->162454590],
Cell[CellGroupData[{
Cell[8364, 288, 135, 4, 70, "Input",
 CellID->21973443],
Cell[8502, 294, 272, 9, 36, "Output",
 CellID->128182918]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8823, 309, 227, 7, 70, "ExampleSection",
 CellID->712626884],
Cell[9053, 318, 138, 4, 70, "ExampleText",
 CellID->85518964],
Cell[9194, 324, 518, 16, 70, "Input",
 CellID->357790862]
}, Closed]],
Cell[CellGroupData[{
Cell[9749, 345, 237, 7, 70, "ExampleSection",
 CellID->173086620],
Cell[9989, 354, 127, 3, 70, "ExampleText",
 CellID->765026304],
Cell[CellGroupData[{
Cell[10141, 361, 351, 10, 70, "Input",
 CellID->23822718],
Cell[10495, 373, 452, 14, 70, "Output",
 CellID->818041783]
}, Open  ]],
Cell[10962, 390, 113, 3, 70, "ExampleText",
 CellID->100319238],
Cell[CellGroupData[{
Cell[11100, 397, 231, 7, 70, "Input",
 CellID->24647440],
Cell[11334, 406, 247, 8, 36, "Output",
 CellID->27442013]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11642, 421, 310, 9, 70, "SeeAlsoSection",
 CellID->7942],
Cell[11955, 432, 988, 35, 70, "SeeAlso",
 CellID->2456]
}, Open  ]],
Cell[CellGroupData[{
Cell[12980, 472, 314, 9, 70, "TutorialsSection",
 CellID->21132],
Cell[13297, 483, 186, 4, 70, "Tutorials",
 CellID->30292]
}, Open  ]],
Cell[CellGroupData[{
Cell[13520, 492, 299, 8, 70, "MoreAboutSection"],
Cell[13822, 502, 169, 3, 70, "MoreAbout",
 CellID->118433423]
}, Open  ]],
Cell[14006, 508, 27, 0, 70, "History"],
Cell[14036, 510, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

