(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16862,        553]
NotebookOptionsPosition[     13414,        444]
NotebookOutlinePosition[     14809,        482]
CellTagsIndexPosition[     14724,        477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
         "ButtonFunction" :> 
         Documentation`HelpLookup["paclet:ref/ButtonFunction"], "ButtonData" :> 
         Documentation`HelpLookup["paclet:ref/ButtonData"], "NotebookRead" :> 
         Documentation`HelpLookup["paclet:ref/NotebookRead"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Button\"\>", 
      2->"\<\"ButtonFunction\"\>", 3->"\<\"ButtonData\"\>", 
      4->"\<\"NotebookRead\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButtonSource", "ObjectName",
 CellID->6698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ButtonSource",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonSource"]], "InlineFormula"],
     "\[LineSeparator]is an option for the low-level function ",
     Cell[BoxData[
      ButtonBox["ButtonBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
     " which specifies the first argument to give to the ",
     Cell[BoxData[
      ButtonBox["ButtonFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonFunction"]], "InlineFormula"],
     " for the button when the button is active and is clicked. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14927]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{"ButtonSource", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18756],

Cell["Possible settings are: ", "Notes",
 CellID->10787],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ButtonData",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonData"]], "InlineFormula"],
     " if it is set, otherwise ",
     Cell[BoxData["ButtonContents"], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "ButtonContents", Cell[TextData[{
     "the first argument of the ",
     Cell[BoxData[
      ButtonBox["ButtonBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButtonData",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ButtonData"], Cell[TextData[{
     "the setting for the ",
     Cell[BoxData[
      ButtonBox["ButtonData",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonData"]], "InlineFormula"],
     " option "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Cell",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cell"], Cell[
    "the whole cell in which the button appears ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "CellContents", Cell[
    "the contents of the cell in which the button appears ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Notebook",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Notebook"], Cell[
    "the whole notebook in which the button appears ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "the expression ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " levels up from the button in the notebook "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->2687]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->370236969],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->73322904],

Cell[TextData[{
 "Create a button that prints out the value of its ",
 Cell[BoxData[
  ButtonBox["ButtonData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->46883684],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<Click for button data\>\"", ",", 
       RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ButtonFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Print", "[", "#", "]"}], "&"}], ")"}]}], ",", 
       RowBox[{"ButtonSource", "\[Rule]", "ButtonData"}], ",", 
       RowBox[{"ButtonData", "\[Rule]", "\"\<data\>\""}], ",", 
       RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}]}], "]"}], 
     "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"FontColor", "\[Rule]", "Blue"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285850362],

Cell[TextData[ButtonBox["Click for button data",
 Evaluator->Automatic,
 ButtonFunction:>(Print[#]& ),
 ButtonSource->ButtonData,
 ButtonData->"paclet:ref/Click for button data",
 ButtonFrame->"DialogBox"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontColor->RGBColor[0, 0, 1],
 CellID->69271689],

Cell[BoxData["\<\"data\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->59171079],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61079505],

Cell["Create a button that prints out the button contents:", "ExampleText",
 CellID->816012570],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<Click for button contents\>\"", ",", 
       RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ButtonFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Print", "[", "#", "]"}], "&"}], ")"}]}], ",", 
       RowBox[{"ButtonSource", "\[Rule]", "ButtonContents"}], ",", 
       RowBox[{"ButtonData", "\[Rule]", "\"\<data\>\""}]}], "]"}], "]"}], 
    ",", "\"\<Text\>\"", ",", 
    RowBox[{"FontColor", "\[Rule]", "Blue"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488860003],

Cell[TextData[ButtonBox["Click for button contents",
 Evaluator->Automatic,
 ButtonFunction:>(Print[#]& ),
 ButtonSource->ButtonContents,
 ButtonData->"paclet:ref/Click for button contents"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontColor->RGBColor[0, 0, 1],
 CellID->102438416],

Cell[BoxData["\<\"Click for button contents\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->374029237],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->499808517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ButtonSource", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " means the button function acts on ",
 Cell[BoxData[
  ButtonBox["ButtonData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonData"]], "InlineFormula"],
 " if it is set:"
}], "ExampleText",
 CellID->714133157],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<Click for data or contents\>\"", ",", 
       RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ButtonFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Print", "[", "#", "]"}], "&"}], ")"}]}], ",", 
       RowBox[{"ButtonSource", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ButtonData", "\[Rule]", "\"\<data\>\""}]}], "]"}], "]"}], 
    ",", "\"\<Text\>\"", ",", 
    RowBox[{"FontColor", "\[Rule]", "Blue"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34369789],

Cell[TextData[ButtonBox["Click for data or contents",
 Evaluator->Automatic,
 ButtonFunction:>(Print[#]& ),
 ButtonSource->Automatic,
 ButtonData->"paclet:ref/Click for data or contents"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontColor->RGBColor[0, 0, 1],
 CellID->607447548],

Cell[BoxData["\<\"data\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->237793713],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->982814051],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["ButtonData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonData"]], "InlineFormula"],
 " is not set, ",
 Cell[BoxData[
  RowBox[{"ButtonSource", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " lets the button act on its contents:"
}], "ExampleText",
 CellID->200603597],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<Click for data or contents\>\"", ",", 
       RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ButtonFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Print", "[", "#", "]"}], "&"}], ")"}]}], ",", 
       RowBox[{"ButtonSource", "\[Rule]", "Automatic"}]}], "]"}], "]"}], ",", 
    "\"\<Text\>\"", ",", 
    RowBox[{"FontColor", "\[Rule]", "Blue"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419876534],

Cell[TextData[ButtonBox["Click for data or contents",
 Evaluator->Automatic,
 ButtonFunction:>(Print[#]& ),
 ButtonSource->Automatic,
 ButtonData->"paclet:ref/Click for data or contents"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 FontColor->RGBColor[0, 0, 1],
 CellID->88836380],

Cell[BoxData["\<\"Click for data or contents\"\>"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->278662995]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26100],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30953]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButtonSource - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 58.6938344}", "context" -> "System`", 
    "keywords" -> {"source data for button function", "button options"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ButtonSource is an option for the low-level function ButtonBox which \
specifies the first argument to give to the ButtonFunction for the button \
when the button is active and is clicked. ", "synonyms" -> {"button source"}, 
    "title" -> "ButtonSource", "type" -> "Symbol", "uri" -> 
    "ref/ButtonSource"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5499, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->370236969]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14581, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 890, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1513, 46, 49, 1, 70, "ObjectName",
 CellID->6698],
Cell[1565, 49, 842, 23, 70, "Usage",
 CellID->14927]
}, Open  ]],
Cell[CellGroupData[{
Cell[2444, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2922, 94, 229, 9, 70, "Notes",
 CellID->18756],
Cell[3154, 105, 56, 1, 70, "Notes",
 CellID->10787],
Cell[3213, 108, 2249, 61, 70, "2ColumnTableMod",
 CellID->2687]
}, Closed]],
Cell[CellGroupData[{
Cell[5499, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->370236969],
Cell[CellGroupData[{
Cell[5884, 188, 147, 5, 70, "ExampleSection",
 CellID->73322904],
Cell[6034, 195, 235, 8, 70, "ExampleText",
 CellID->46883684],
Cell[6272, 205, 759, 18, 70, "Input",
 CellID->285850362],
Cell[7034, 225, 313, 9, 70, "Text",
 CellID->69271689],
Cell[7350, 236, 101, 2, 70, "Print",
 CellID->59171079],
Cell[7454, 240, 124, 3, 70, "ExampleDelimiter",
 CellID->61079505],
Cell[7581, 245, 95, 1, 70, "ExampleText",
 CellID->816012570],
Cell[7679, 248, 696, 17, 70, "Input",
 CellID->488860003],
Cell[8378, 267, 299, 8, 70, "Text",
 CellID->102438416],
Cell[8680, 277, 123, 2, 70, "Print",
 CellID->374029237],
Cell[8806, 281, 125, 3, 70, "ExampleDelimiter",
 CellID->499808517],
Cell[8934, 286, 394, 13, 70, "ExampleText",
 CellID->714133157],
Cell[9331, 301, 691, 17, 70, "Input",
 CellID->34369789],
Cell[10025, 320, 296, 8, 70, "Text",
 CellID->607447548],
Cell[10324, 330, 102, 2, 70, "Print",
 CellID->237793713],
Cell[10429, 334, 125, 3, 70, "ExampleDelimiter",
 CellID->982814051],
Cell[10557, 339, 405, 14, 70, "ExampleText",
 CellID->200603597],
Cell[10965, 355, 628, 16, 70, "Input",
 CellID->419876534],
Cell[11596, 373, 295, 8, 70, "Text",
 CellID->88836380],
Cell[11894, 383, 124, 2, 70, "Print",
 CellID->278662995]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12067, 391, 311, 9, 70, "SeeAlsoSection",
 CellID->26100],
Cell[12381, 402, 961, 35, 70, "SeeAlso",
 CellID->30953]
}, Open  ]],
Cell[13357, 440, 27, 0, 70, "History"],
Cell[13387, 442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

