(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9481,        357]
NotebookOptionsPosition[      6666,        261]
NotebookOutlinePosition[      7879,        297]
CellTagsIndexPosition[      7795,        292]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinaryRead" :> 
          Documentation`HelpLookup["paclet:ref/BinaryRead"], "BinaryWrite" :> 
          Documentation`HelpLookup["paclet:ref/BinaryWrite"], "Character" :> 
          Documentation`HelpLookup["paclet:ref/Character"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BinaryRead\"\>", 
       2->"\<\"BinaryWrite\"\>", 3->"\<\"Character\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Byte", "ObjectName",
 CellID->28145],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Byte",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Byte"]], "InlineFormula"],
     "\[LineSeparator]represents a single byte of data in ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5672]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->301713521],

Cell["Create a file with a sequence of bytes:", "ExampleText",
 CellID->817451210],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->963183574],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "[", 
   RowBox[{"file", ",", " ", 
    RowBox[{"{", 
     RowBox[{"8", ",", "97", ",", "255"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1449596611],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1359588613],

Cell["Read each byte in the file:", "ExampleText",
 CellID->224833898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"file", ",", "Byte"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1379814611],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->173757842]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"file", ",", "Byte"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1362087608],

Cell[BoxData["97"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->233882908]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"file", ",", "Byte"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->458565215],

Cell[BoxData["255"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->92068677]
}, Open  ]],

Cell["Close the file:", "ExampleText",
 CellID->954459324],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1866941297]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->220],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Character",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Character"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9894]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13311],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->9143]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Byte - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 59.5844822}", "context" -> "System`", 
    "keywords" -> {
     "binary data", "byte of data", "half-word", "double-nibble"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Byte represents a single byte of data in Read. ", "synonyms" -> {}, 
    "title" -> "Byte", "type" -> "Symbol", "uri" -> "ref/Byte"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2633, 87, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7661, 285}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1380, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2003, 61, 42, 1, 70, "ObjectName",
 CellID->28145],
Cell[2048, 64, 548, 18, 70, "Usage",
 CellID->5672]
}, Open  ]],
Cell[CellGroupData[{
Cell[2633, 87, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3010, 101, 148, 5, 70, "ExampleSection",
 CellID->301713521],
Cell[3161, 108, 82, 1, 70, "ExampleText",
 CellID->817451210],
Cell[3246, 111, 182, 6, 70, "Input",
 CellID->963183574],
Cell[3431, 119, 222, 7, 70, "Input",
 CellID->1449596611],
Cell[3656, 128, 123, 4, 70, "Input",
 CellID->1359588613],
Cell[3782, 134, 70, 1, 70, "ExampleText",
 CellID->224833898],
Cell[CellGroupData[{
Cell[3877, 139, 130, 4, 70, "Input",
 CellID->1379814611],
Cell[4010, 145, 158, 5, 36, "Output",
 CellID->173757842]
}, Open  ]],
Cell[CellGroupData[{
Cell[4205, 155, 130, 4, 70, "Input",
 CellID->1362087608],
Cell[4338, 161, 159, 5, 36, "Output",
 CellID->233882908]
}, Open  ]],
Cell[CellGroupData[{
Cell[4534, 171, 129, 4, 70, "Input",
 CellID->458565215],
Cell[4666, 177, 159, 5, 36, "Output",
 CellID->92068677]
}, Open  ]],
Cell[4840, 185, 58, 1, 70, "ExampleText",
 CellID->954459324],
Cell[4901, 188, 123, 4, 70, "Input",
 CellID->1866941297]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5073, 198, 309, 9, 70, "SeeAlsoSection",
 CellID->220],
Cell[5385, 209, 707, 26, 70, "SeeAlso",
 CellID->9894]
}, Open  ]],
Cell[CellGroupData[{
Cell[6129, 240, 314, 9, 70, "TutorialsSection",
 CellID->13311],
Cell[6446, 251, 148, 3, 70, "Tutorials",
 CellID->9143]
}, Open  ]],
Cell[6609, 257, 27, 0, 70, "History"],
Cell[6639, 259, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

