(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14547,        544]
NotebookOptionsPosition[     10660,        414]
NotebookOutlinePosition[     12020,        451]
CellTagsIndexPosition[     11935,        446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$ByteOrdering" :> 
          Documentation`HelpLookup["paclet:ref/$ByteOrdering"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "BinaryRead" :> 
          Documentation`HelpLookup["paclet:ref/BinaryRead"], "BinaryWrite" :> 
          Documentation`HelpLookup["paclet:ref/BinaryWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$ByteOrdering\"\>", 
       2->"\<\"IntegerDigits\"\>", 3->"\<\"BinaryRead\"\>", 
       4->"\<\"BinaryWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Binary Data\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ByteOrdering", "ObjectName",
 CellID->4199],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ByteOrdering",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ByteOrdering"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BinaryRead",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["BinaryWrite",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
     " and related functions that specifies what ordering of bytes should be \
assumed for your computer system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6003]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["ByteOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteOrdering"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->802],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " corresponds to big endian (appropriate for PowerPC and many other \
processors); ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " corresponds to little endian (appropriate for x86 processors). "
}], "Notes",
 CellID->31654],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " corresponds to having the most significant byte first; ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " to having the least significant byte first. "
}], "Notes",
 CellID->28317],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " is the order obtained from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", "256"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25505]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78519788],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->452767388],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ByteOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ByteOrdering"]], "InlineFormula"],
 " gives the byte ordering on this machine:"
}], "ExampleText",
 CellID->756920706],

Cell[CellGroupData[{

Cell[BoxData["$ByteOrdering"], "Input",
 CellLabel->"In[1]:=",
 CellID->1104304842],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103685674]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2020664561],

Cell["Create a file with a 32-bit integer:", "ExampleText",
 CellID->817451210],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->963183574],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "[", 
   RowBox[{"file", ",", "12345", ",", "\"\<Integer32\>\""}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1449596611],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1359588613],

Cell["Read the data from the file:", "ExampleText",
 CellID->224833898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", 
  RowBox[{"file", ",", "\"\<Integer32\>\"", ",", " ", 
   RowBox[{"ByteOrdering", "->", "$ByteOrdering"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1379814611],

Cell[BoxData["12345"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->8963832]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1479005872],

Cell["Read the data with reverse byte ordering:", "ExampleText",
 CellID->528476679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", 
  RowBox[{"file", ",", "\"\<Integer32\>\"", ",", " ", 
   RowBox[{"ByteOrdering", "->", 
    RowBox[{"-", "$ByteOrdering"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->762904058],

Cell[BoxData["959447040"], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->656528225]
}, Open  ]],

Cell[TextData[{
 "Recreate the correct interpretation using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions: "
}], "ExampleText",
 CellID->14689485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"%", ",", "256"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->31196343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"57", ",", "48", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->410202567]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{
   RowBox[{"Reverse", "[", "%", "]"}], ",", "256"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->368518621],

Cell[BoxData["12345"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->368208278]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1422687241]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31728],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ByteOrdering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ByteOrdering"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryWrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25668]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->546519849],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->3437797]
}, Open  ]],

Cell["New in 5.2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ByteOrdering - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 59.7876124}", "context" -> "System`", 
    "keywords" -> {"big endian", "little endian", "ordering of bytes"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ByteOrdering is an option for BinaryRead, BinaryWrite and related \
functions that specifies what ordering of bytes should be assumed for your \
computer system.", "synonyms" -> {"byte ordering"}, "title" -> "ByteOrdering",
     "type" -> "Symbol", "uri" -> "ref/ByteOrdering"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4794, 167, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->78519788]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11793, 439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1487, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2110, 63, 49, 1, 70, "ObjectName",
 CellID->4199],
Cell[2162, 66, 814, 24, 70, "Usage",
 CellID->6003]
}, Open  ]],
Cell[CellGroupData[{
Cell[3013, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3491, 112, 334, 14, 70, "Notes",
 CellID->802],
Cell[3828, 128, 311, 9, 70, "Notes",
 CellID->31654],
Cell[4142, 139, 266, 8, 70, "Notes",
 CellID->28317],
Cell[4411, 149, 346, 13, 70, "Notes",
 CellID->25505]
}, Closed]],
Cell[CellGroupData[{
Cell[4794, 167, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78519788],
Cell[CellGroupData[{
Cell[5178, 181, 148, 5, 70, "ExampleSection",
 CellID->452767388],
Cell[5329, 188, 228, 7, 70, "ExampleText",
 CellID->756920706],
Cell[CellGroupData[{
Cell[5582, 199, 83, 2, 28, "Input",
 CellID->1104304842],
Cell[5668, 203, 175, 6, 36, "Output",
 CellID->103685674]
}, Open  ]],
Cell[5858, 212, 126, 3, 70, "ExampleDelimiter",
 CellID->2020664561],
Cell[5987, 217, 79, 1, 70, "ExampleText",
 CellID->817451210],
Cell[6069, 220, 182, 6, 70, "Input",
 CellID->963183574],
Cell[6254, 228, 186, 6, 70, "Input",
 CellID->1449596611],
Cell[6443, 236, 123, 4, 70, "Input",
 CellID->1359588613],
Cell[6569, 242, 71, 1, 70, "ExampleText",
 CellID->224833898],
Cell[CellGroupData[{
Cell[6665, 247, 212, 5, 70, "Input",
 CellID->1379814611],
Cell[6880, 254, 160, 5, 36, "Output",
 CellID->8963832]
}, Open  ]],
Cell[7055, 262, 123, 4, 70, "Input",
 CellID->1479005872],
Cell[7181, 268, 84, 1, 70, "ExampleText",
 CellID->528476679],
Cell[CellGroupData[{
Cell[7290, 273, 231, 6, 70, "Input",
 CellID->762904058],
Cell[7524, 281, 166, 5, 36, "Output",
 CellID->656528225]
}, Open  ]],
Cell[7705, 289, 165, 6, 70, "ExampleText",
 CellID->14689485],
Cell[CellGroupData[{
Cell[7895, 299, 133, 4, 70, "Input",
 CellID->31196343],
Cell[8031, 305, 225, 7, 36, "Output",
 CellID->410202567]
}, Open  ]],
Cell[CellGroupData[{
Cell[8293, 317, 166, 5, 70, "Input",
 CellID->368518621],
Cell[8462, 324, 162, 5, 36, "Output",
 CellID->368208278]
}, Open  ]],
Cell[8639, 332, 123, 4, 70, "Input",
 CellID->1422687241]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8811, 342, 311, 9, 70, "SeeAlsoSection",
 CellID->31728],
Cell[9125, 353, 971, 35, 70, "SeeAlso",
 CellID->25668]
}, Open  ]],
Cell[CellGroupData[{
Cell[10133, 393, 319, 9, 70, "MoreAboutSection",
 CellID->546519849],
Cell[10455, 404, 131, 3, 70, "MoreAbout",
 CellID->3437797]
}, Open  ]],
Cell[10601, 410, 29, 0, 70, "History"],
Cell[10633, 412, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

