(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13846,        514]
NotebookOptionsPosition[     10534,        404]
NotebookOutlinePosition[     11910,        443]
CellTagsIndexPosition[     11825,        438]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equations: Basics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DifferentialEquations-Basics"], 
          "Differential Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DifferentialEquations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Differential Equations: Basics\"\>", 
       2->"\<\"Differential Equations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GeneratedParameters" :> 
          Documentation`HelpLookup["paclet:ref/GeneratedParameters"], 
          "Unique" :> Documentation`HelpLookup["paclet:ref/Unique"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"GeneratedParameters\"\>", 
       2->"\<\"Unique\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["C", "ObjectName",
 CellID->25605],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["C",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/C"], "[", 
       StyleBox["i", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the default form for the ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["i", "TI"], "\[Null]"}]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " parameter or constant generated in representing the results of various \
symbolic computations. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " are often used to parameterize families of solutions to equations. "
}], "Notes",
 CellID->2750],

Cell[TextData[{
 "In functions like ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " can be thought of as corresponding to constants of integration. "
}], "Notes",
 CellID->15822],

Cell[TextData[{
 "In cases such as partial differential equations, the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " represent functions rather than variables. "
}], "Notes",
 CellID->7351],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["C",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/C"]], "InlineFormula"],
 " is the default setting for the option ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " in such functions as ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32029]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2491952],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->7877561],

Cell[TextData[{
 "Parameters generated by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->98583389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220188661],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["\[Pi]", "2"], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}]}]], "Output",
 ImageSize->{220, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568720696]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->419292650],

Cell[TextData[{
 "Parameters generated by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->675977102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"-", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1023515919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444697265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160951741],

Cell[TextData[{
 "Parameters generated by ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->59675261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"f", "[", "k", "]"}], "+", 
     RowBox[{"f", "[", 
      RowBox[{"k", "-", "1"}], "]"}]}]}], ",", 
   RowBox[{"f", "[", "k", "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113090165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "k", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Fibonacci", "[", "k", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LucasL", "[", "k", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348505429]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16144],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27673]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29753],

Cell[TextData[ButtonBox["Differential Equations: Basics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DifferentialEquations-Basics"]], "Tutorials",
 CellID->22247],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DifferentialEquations"]], "Tutorials",
 CellID->25610]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"C - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 52.8061306}", "context" -> "System`", 
    "keywords" -> {
     "differential equations", "undetermined coefficients", "free parameters",
       "free constant", "arbitrary constant"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "C[i] is the default form for the i\\[Null]\\[Null]^th parameter or \
constant generated in representing the results of various symbolic \
computations. ", "synonyms" -> {}, "title" -> "C", "type" -> "Symbol", "uri" -> 
    "ref/C"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5218, 185, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2491952]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11684, 431}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1491, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2114, 63, 39, 1, 70, "ObjectName",
 CellID->25605],
Cell[2156, 66, 769, 24, 70, "Usage",
 CellID->16947]
}, Open  ]],
Cell[CellGroupData[{
Cell[2962, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3440, 112, 280, 10, 70, "Notes",
 CellID->2750],
Cell[3723, 124, 418, 15, 70, "Notes",
 CellID->15822],
Cell[4144, 141, 305, 10, 70, "Notes",
 CellID->7351],
Cell[4452, 153, 729, 27, 70, "Notes",
 CellID->32029]
}, Closed]],
Cell[CellGroupData[{
Cell[5218, 185, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2491952],
Cell[CellGroupData[{
Cell[5601, 199, 146, 5, 70, "ExampleSection",
 CellID->7877561],
Cell[5750, 206, 202, 8, 70, "ExampleText",
 CellID->98583389],
Cell[CellGroupData[{
Cell[5977, 218, 191, 7, 28, "Input",
 CellID->220188661],
Cell[6171, 227, 401, 13, 49, "Output",
 CellID->568720696]
}, Open  ]],
Cell[6587, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->419292650],
Cell[6715, 248, 203, 8, 70, "ExampleText",
 CellID->675977102],
Cell[CellGroupData[{
Cell[6943, 260, 299, 10, 70, "Input",
 CellID->1023515919],
Cell[7245, 272, 473, 16, 36, "Output",
 CellID->444697265]
}, Open  ]],
Cell[7733, 291, 125, 3, 70, "ExampleDelimiter",
 CellID->160951741],
Cell[7861, 296, 202, 8, 70, "ExampleText",
 CellID->59675261],
Cell[CellGroupData[{
Cell[8088, 308, 365, 12, 70, "Input",
 CellID->113090165],
Cell[8456, 322, 482, 16, 36, "Output",
 CellID->348505429]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8999, 345, 311, 9, 70, "SeeAlsoSection",
 CellID->16144],
Cell[9313, 356, 469, 17, 70, "SeeAlso",
 CellID->27673]
}, Open  ]],
Cell[CellGroupData[{
Cell[9819, 378, 314, 9, 70, "TutorialsSection",
 CellID->29753],
Cell[10136, 389, 169, 3, 70, "Tutorials",
 CellID->22247],
Cell[10308, 394, 154, 3, 70, "Tutorials",
 CellID->25610]
}, Open  ]],
Cell[10477, 400, 27, 0, 70, "History"],
Cell[10507, 402, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

