(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54028,       1838]
NotebookOptionsPosition[     43932,       1483]
NotebookOutlinePosition[     45299,       1522]
CellTagsIndexPosition[     45213,       1517]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Discrete Distributions\"\>", 
       2->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PDF" :> Documentation`HelpLookup["paclet:ref/PDF"], 
          "InverseCDF" :> Documentation`HelpLookup["paclet:ref/InverseCDF"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"], 
          "Sum" :> Documentation`HelpLookup["paclet:ref/Sum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PDF\"\>", 2->"\<\"InverseCDF\"\>", 
       3->"\<\"Integrate\"\>", 4->"\<\"Sum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"Statistical Distributions\"\>", 3->"\<\"Statistics\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CDF", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CDF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CDF"], "[", 
       RowBox[{
        StyleBox["dist", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cumulative distribution function for the \
symbolic distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     " evaluated at ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CDF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CDF"], "[", 
       StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the CDF as a pure function."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives the probability that an observed value will be less than or equal to \
",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12382],

Cell[TextData[{
 "For continuous distributions, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is the integral of the probability density function from the lowest value \
in the domain to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26500],

Cell[TextData[{
 "For discrete distributions, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is the sum of the probability density function from the lowest value in \
the domain to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19169]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->196803166],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->43202983],

Cell["The CDF of a continuous distribution:", "Notes",
 CellID->431130830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617514039],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"BetaRegularized", "[", 
      RowBox[{
       FractionBox["\[Nu]", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "\[Nu]"}]], ",", "1", ",", 
       FractionBox["\[Nu]", "2"], ",", 
       FractionBox["1", "2"]}], "]"}], " ", 
     RowBox[{"Sign", "[", "x", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{322, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344657597]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266931418],

Cell["The CDF of a discrete distribution:", "Notes",
 CellID->376452893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53095017],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"Floor", "[", "k", "]"}]}], ",", "\[Mu]"}], "]"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373699358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64351119],

Cell["The CDF of a normal distribution as a pure function:", "Notes",
 CellID->44097542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->806604733],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Erf", "[", 
      FractionBox[
       RowBox[{"#1", "-", "\[Mu]"}], 
       RowBox[{
        SqrtBox["2"], " ", "\[Sigma]"}]], "]"}], "+", "1"}], ")"}]}], 
  "&"}]], "Output",
 ImageSize->{136, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163420426]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Obtain exact numeric results:", "ExampleText",
 CellID->659006259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "10", "]"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191583331],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"5", ",", "0", ",", "2"}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394328402]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"HypergeometricDistribution", "[", 
    RowBox[{"10", ",", "20", ",", "50"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359728176],

Cell[BoxData[
 FractionBox["631093476", "733734155"]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->889425885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15255080],

Cell["Obtain a machine-precision result:", "ExampleText",
 CellID->416017623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "10", "]"}], ",", "7.5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610607049],

Cell[BoxData["0.3224523638954564`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58908286]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19374803],

Cell["\<\
Obtain a result at any precision for a continuous distribution:\
\>", "ExampleText",
 CellID->157989833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "10", "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"30", "/", "4"}], ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235751636],

Cell[BoxData["0.32245236389545634118276611764`18.729009156373785"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322805085]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457132839],

Cell["\<\
Obtain an exact result for a discrete distribution with exact parameters:\
\>", "ExampleText",
 CellID->576110967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"20", ",", 
     RowBox[{"1", "/", "4"}]}], "]"}], ",", ".75"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191591077],

Cell[BoxData[
 FractionBox["3486784401", "1099511627776"]], "Output",
 ImageSize->{108, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528451489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13432999],

Cell["\<\
Obtain a result at any precision for a discrete distribution with inexact \
parameters:\
\>", "ExampleText",
 CellID->737502524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"20", ",", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "4"}], ",", "30"}], "]"}]}], "]"}], ",", ".75"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229388],

Cell[BoxData["0.003171211938933993224054574966430693868174264787`29.\
066282609714833"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43128123]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Plot the CDF for a standard normal distribution:", "ExampleText",
 CellID->526665614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->346682293],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241348641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331526780],

Cell["Plot the CDF for a binomial distribution:", "ExampleText",
 CellID->57844831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"BinomialDistribution", "[", 
      RowBox[{"20", ",", ".5"}], "]"}], ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224981200],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiCgkGIPs/kAXG
W/7/B9KYpCmQZAYqUIbSTECaCUgrQPkMLGBlUAASZUFSxQyWtACRIMX/wYBB
EUSwIPgQ9cgq5ND4zNjkWSF8OAk2BeQ9RhBNI5vlsZpAa1sVkPjYfWoGDXEV
4uxCqIDqUybKBmRzlImziRXZJpDJ4NBgQ9aHKxzNoW5T+o9ITbC0xwRNesh8
5v/IqQ45FQuguWwhHlFeILkU5huEmvPnngIRAyuIIIY/f94ZIGJgARHM06Ye
Bwrl521mYAURIPmTJx6BgwfNDQPNZ6Gx+cxYQ14FxgeGDiiA2MCh9Pz5J6i8
DC71UL4qCbb8/PkHGldsQKKEQPoApadFWNXogPlAI+xtZwIRAyuIYHZ1nvPw
4XuQVBYBk0kRxe0KUswzAfMPH7qP4uJA/8XAIAFJJVHoCmiwgwFyCQbmw6oK
TF0oZQgrmj5i9LBhi30CetjR1IByO4hLrFpC5oPdjSmCN8zYoGGMnmewx6YN
mP/580+Ukuf2rTdQ+SiUeLMFq96+7QY0h0HKodKSbdC4j8JqB3mplZZpmFJb
MNIoRv2EPfQpT3Gg+GeB0rhSGnIaweYWl//QHAytXVjBtcvqVZeg8kFYzGT9
jz1VQcwCJhoUs4AphAyzMMMWPc9gD6HBky4GKPUhlypEpj3CJYsPmA8sCVBK
Bki1BJLyosDUyZOOoZQgS5ecJ9lUfKmfmchQINRuwZ4imbD4a2ikHEpEQ8D8
9rYDKDGHKDWcUFwR+h9b6kG0xZzw2Eyf9E09XcjlGd4ymXbuIan+JzWVxID5
4aHLUFp8wIIeKm9Fgln0SavJYD6wVQNsmiB6AsAaDypvhOKKVLDqq1deoKRV
oG4M1djiCxHymH1X3PGArpKZYExng/nA8hfYOQBFABs4FoBOhcprkWluMcxc
lHydk71p546bsP6NLAlmgxRAzET0kSAhumjB2dycTQg7YmNWovd6UPheHgtQ
+EBNyDaT4Vdywx53LlsJFsIc8WJgBACdmQvl\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265250074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19696651],

Cell[TextData[{
 "Compute the probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "<", "3.5"}], TraditionalForm]], "InlineMath"],
 " for a ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with 20 degrees of freedom:"
}], "ExampleText",
 CellID->591295648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "20", "]"}], ",", "3.5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440899455],

Cell[BoxData["0.9988724384234714`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116918164]
}, Open  ]],

Cell[TextData[{
 "Compute the probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", ">", "3.5"}], TraditionalForm]], "InlineMath"],
 " for the same distribution:"
}], "ExampleText",
 CellID->192845226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"CDF", "[", 
   RowBox[{
    RowBox[{"StudentTDistribution", "[", "20", "]"}], ",", "3.5"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556479428],

Cell[BoxData["0.0011275615765286018`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->232071201]
}, Open  ]],

Cell[TextData[{
 "Compute the probability of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "t", "\[RightBracketingBar]"}], ">", 
    "3.5`"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->397633568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", 
  RowBox[{"CDF", "[", 
   RowBox[{
    RowBox[{"StudentTDistribution", "[", "20", "]"}], ",", 
    RowBox[{"-", "3.5"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54834225],

Cell[BoxData["0.002255123153057161`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->93624048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232864721],

Cell["\<\
Define a general survival distribution function (SDF) as used in actuarial \
science: \
\>", "ExampleText",
 CellID->458937523],

Cell[BoxData[
 RowBox[{
  RowBox[{"SDF", "[", 
   RowBox[{"dist_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{"CDF", "[", 
    RowBox[{"dist", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63385103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", ".05", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->349390459],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VMFqAjEQHTeJqxZc6cF6KYiCFizF/kR76kcsUlgPUlF/wC+PM9mJhsli
qoUKyWQyk3lvntl8lYfqe1Me1qty/Lkrt9V6tR9//OxwS7UA4IjjaQS4trhy
42gt2iHOCt3q7AG51v3+ebeNk0G3YPuKNkObsW2L/A5zV43VOsLvBz7OsCSr
L3FwJwgnJ9ecI5yf1VaxS0scgwSq4V60QH9nrAe25gqmEjULPtNLdEjLN87t
/qI3iaOZu9S9m8DNRHwRKZ2LjFtYFQk2FNfccbgvWaV8FbH2/5W/j4MbWKfu
yZBZ1xfFSxnqJJUFvjXEZPIHJjnXeBa1Jba2sT50bmrDrzCFNkugeG1NpP6L
Mz7+eEfdMN99/dGbMW/QJmDBnTafve/9u7y99XsMrRNo2dfj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{129, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92101821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->491852100],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Xs0lHkYB/D3TLJs04odl+qk4dQ2FWG32lQ8v5JbMRjMjFttIpNoZozO
cN5Ws3JJZ4xL2U4yEso9qY2x1VDZadvckj3WRtgSGszsSmkY9n3/eM5zPud7
vs8/j00knxVNwTCMSQy5bXP0ZcXWL1xL9/Lzl5Y0UMawpn3kXQP55SpawowG
mow2r4/n1cP8rOjcxDsNPEq6Vc7gtcBEzpL1WIcGVI7CGENeF4jDqFbrijTw
u7THazZmCDa3u0cnOGvg2e5zzZMxGngtrba/J56GP/JeCcdjlsBjVjz+HWUK
pihb8w0iViGO96T5Tdp7iEzb7V3pZ4U6ul6HOcvHYLYqkeW0ko5W+utpTnGj
MFg2tMPScwPS56YPsjzewH6/ueZnuxiIkVDHxMQj8FxaPmNw1g59VfIh+tGx
Iajf1d1yg+uIBiaXDwjcBqBp2UZ2ve+3SOFyb+t0ST/0XHbz1MdtR+XhZ2TH
qH1QY9B83om3Ewm6LUJHh3rB2J0tOhmyCxXtCY4I+rcHkpkPFROJu5EA3m4L
o76ACkecyYzbi7DVAUWhY50w/ooCn7JdUeXgX5SCp8+BbR8y2cNCiP5ULLJZ
/gwsQ8KPyn32Ian74y/qGlQQeaJt2YWw/cguQOW5L7YNqO84nSe4bijXNsjv
dspjAE9/1cnYA4hrUjtnWdwK2/MH8gVidyRgiUqT1Q8hy/tSJi/BAzm+l73b
Sb8PMaO3q1JTPVFur6lq4ZgCyqfmZnIkXmh4/PwWK4tGKBvqNStJ9kZafoS5
2vgX2NpofqQn8yBaBa9kZkZ34OvPP738dO4QMpI1Hrbg3IY0euBpKPBB9DtP
OGuO1EGTk0Kddd0XYRNWdbqEavCu97rw9CoTaeeVNvyFCogydWVvqvFDgt+E
LS/zb4CW77DRJcgfYVJh7ZkLZWDSnmXM6/ZHyOPjTcqD6yAq/NlgAycADac0
yHsnr4Hh+uaL/b0BCDNThgVpi+C1ucyZHsFCJdpDahuDQhh9nCT6YYCFWvN1
wsHsy9AZVWdpGxKIJBlvaG8jCmA+6VJP4nAgGm7tOkx3vghctzybR4eDEOan
jlfG5sHnsyizeIzwniydg28O4A3OHH18MJKk44Ol26Rgf8XrfrA6GGF4iEdJ
dhZsmDHeCSI2al2+uK5UlwEHl40csP2PjbCacdPTXWkQYERRZpziIEw9jVv8
kwrys3/6npkl/M1cG3dRAqvrlMKTIi7C2k1m4jtSoN8ntFY9z0WSX9+IO+px
sDsRpZ8njA20WosIp6SfYlIXiPxFm8qKsK0yVWtHmrFvTdQtHGIdarafIoyt
W9Glq8VBZ7rwQEv672E+oxqHNX3yjlk9YXayLK0ch7iZCmvDRaJfsTl0C2Gl
yR2+BekgbFN3GQ6RXirT70k30NvWEq5ung5OIm1qT717HYc9xAt0hLH1wpcj
xTjIFN4OK5YIx6Q3ZBIe7g2UrCXd2ZJrTzhtJc92L2HJ5E1WshyH9pTc4z+S
XnR5u6oIB+urhU3ZpPtTnzdexUHQVG5UTPYbp+6GE6ZpFdVK0tE7zlcW4nCc
+mS+k7SjWSKTsILR4TNEeop29MMVHL5075NrSF9x8SskHH50ZHqJvO8odUWE
/wdHKE5m
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->529084168]
}, Open  ]],

Cell["Define force of mortality (FM): ", "ExampleText",
 CellID->27392962],

Cell[BoxData[
 RowBox[{
  RowBox[{"FM", "[", 
   RowBox[{"dist_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"SDF", "[", 
       RowBox[{"dist", ",", "x"}], "]"}], ",", "x"}], "]"}]}], "/", 
   RowBox[{"SDF", "[", 
    RowBox[{"dist", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->580289555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FM", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->224414870],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWEtuFDEQ9bTdM/kxCSIKQUrIQPgFEhDiv0WIbOAOGUVIyQKBQsQCkOYI
QVwgC7LMHWaZY+Qoxu52TXteV7s/hKGlaY/t+rwql8vlft8/3PvwsX+4v9vv
bR/0P+/t737pvf10YIZkSwhxan7vloX5r82/5HeqtWmfmLc03a+jnrBdnTwT
Hm2bV2y6865dNW1k2si1baCfcth7rLQp6He9vnmLG7ZV2bxIOKyeju3GoxlH
v5a0qw7b5RJtsaNToPWm0zHr2jigaw1kLjiemRLLpJNgaacr2IR6CDv6e7pE
bwTzKzkPd4CiDqqFEjQ2apRbxXGtiMv3P8XWQg0kZWu/5JCQbC4GmurqOJnX
dRY/tl3X/l4ok3In56MYKN4kw6TlCsw+YqlxB2457m12tlm+yHLVae6drvNw
OBTpc2J+rcFg0DLjrQKe9J1Yr87OzobJc35+/jsbl8fHxw4HZah0gh4CG7nZ
yK2/cnilFw8Jt8y4sS9LpUuQes/r03wEUn1EeaswfhM/5uIzMAq5Q3SAytHi
7peexIxK6eZoZED7Fqc90I8Y69qT8V8AFTt/8T4MIHhQxY+ldv4bT8YF+IvG
m3qO9l6Rro3GPhrVDJV8M4rR3HkXFfqpGhbKIqqyl3gsvHS+6uG8hhjGvZUf
DfhO+bSYIRWMkVWYWakfZcpESi4D3Jw2TvL9Ar+Oa/LrFuKMi+325F2CPs4/
5PrBWmqJ1Uvn5JxDeRe4XpuXTdPLLPfJREdfATasbZ6zXC+B6jH0n/13rhdA
hTXVU5aL6kmKWhsxdiWvAfeM5u8IdHfAilOB3Bk9Hsd4rtnqPovrNN+YssxU
cxri1m4KvImsgLQ56CNqrNAXA/TCeSV/s7F2JMgKspICX9PdjHaL1GEr6HxA
XynN3zXRCsLYhTVoN8DM3TkxRup6XTJxg5indFU/mzp+Z2dHu1gtwiWYnHb1
L+1AefPQx6w7qzGauC8dVc86vBfbWK1+L8YaHW3vaq/yKZWGdQJajlmAv4VX
s3NRh2/dqBstWyrgw92Gcno1MFM005ctyrZoC/llGejQnyTvlg5VAbdza4U2
4aqvl3LgavNnENYTqGezkdRNnX1D86k3CrzEn+CTrTLqjFovWfjf9fjuwCiJ
dWjV+axuZdb56snHMS/7hydphPdCJIa/YtaRmLcfTwf+tuHpUEdHR4PkMUcM
f5P5pqvntS479zPAYc8TC/iX9tc//ZIlWn8AdEl2Yw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{172, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->121815542]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->324721185],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Vr1OwzAQdu04SSEFJIqExNKNBfEOLDDxClShQmoHBCoZeAZg6Bsb27lL
nIvjtE3BUnO5v8+f7y5WH/Ni+fKaF6tFPntY5+/L1eJjdv+21iYxYoxt9O/q
kul3pd/sb6OUlu5T6KfQLqklZ6Vu5BNIDtL4mQlUdrEx5MUViutNHF0/WW5k
VPuZjTC4qVFl5YF46UVNIecZ5BHIeABGqnbnMSb6vHW62LPrvui0E2cDsIod
crFDnyrU6S9rRW4/lebGfAesfrwhVsNT1seChUEcvEaalkVwOgE6+kvYclFd
9KILgnpMejh1/P4ZdXXu7VrA6uRamgmJgtiExAoHsY6KBrARgd3tHLe+GlFt
iSvp3u/vK0er0+c/fPUCDE5VOU0X/1gh2cGry75vRfDL6dprAmc303H4mcFv
tTmfDc923fJGcaS7VW38XPzo0mvNWtnTnvoYCmkzC5i492BEbMgYbzZ6E/Jm
n7BzHdm+3XzImWrereeBs52Q+k56ZuGW6DcB7Ax4IZ9rknun3Du//PfFRr85
C8XB\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{144, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->140181751]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " is the integral of ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " for continuous distributions:"
}], "ExampleText",
 CellID->101458639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "y"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Lambda]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->815734516],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "y"}], " ", "\[Lambda]"}]]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269484526]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->498810307],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVM0KwjAMrms7nfhzUbaDh4keBMU3EG968gE8jTEEPYiivn/NukxHCNtw
Fpr0S9N8aVJ6iF/n0zV+XZI43D/i+/mSPMPd7QEm2RJCRDD9QMDawMrOyBjQ
EqQEePwgkUJjxx+sGxAKYMDubgn2WS8XhAY4QD0l+5pgD+8k2WgdgvsFDFLM
QTug26itv/74o5dTK7bGjCXhmBHsIZdbwuWgT7cif1nI3dZTfX0zhqpbOUw9
yxipv0vwiOWiXWuSUfoyFNaxaKfn0pv3TPY6hEIKO4YNujxG9jxiJhXX85oM
ef8mJIZG+9yUvfD8BeO24Kq9YE+ua3mtMP6S3f3tz/j+QVGWdOsNj1BdKw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{95, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->683560941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12189208],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " is the sum of ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " for discrete distributions:"
}], "ExampleText",
 CellID->107144637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"GeometricDistribution", "[", "p", "]"}], ",", "m"}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", 
      RowBox[{"Floor", "[", "n", "]"}]}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325017733],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], 
   RowBox[{"1", "+", 
    RowBox[{"Floor", "[", "n", "]"}]}]]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218151150]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"GeometricDistribution", "[", "p", "]"}], ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->429809195],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1VlFLwzAQztKkraKbMmUDFQaKiD9CQUGf/Af6UIawPYgy92982i+N13rt
0q9nW9cZaC/fJbn7LrkLeUqWs9e3ZDmfJpPHRfIxm08/Jw/vC1IFPaXUir7R
WFHfUS/7Vs6RDOgfEPwqkEqhy9oWtGeAh+zPgv5FXH0K+BgwWnkWrYT0swQP
QK9ZPyBpBE43zFWZzCw3w6siHg1EnzFg9G0AD7JwCswOcdatOAt5x+Is3Yqn
5ejCBr75PNuBd+pDk6zjq3nO7r/s5yVbj1j2xVUxj4YNPH3LOxvw1apqBzGe
1wngCPDeL3ZNy73vElOffXCJqCJXje/PCuzyusql9qT29KWdyu2srVNnX+CA
ud2lXg6ROeBRwx5Zj1sxLnPhVUqMs2Zdad75H2LNq+KocmapdoyR4HmInuT7
YnvxXbi6W/le4liJDM8ov4P8DDRSTQlZedWKR1iJA21jnmGdy37u3Pp+8zMt
bUNXvvuuRQubvQDWL4qfV4bqfQO4q2tv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{161, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->582810558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152805149],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseCDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseCDF"]], "InlineFormula"],
 " are inverses for continuous distributions:"
}], "ExampleText",
 CellID->203272416],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410116367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"\[Lambda]", ">", "0"}]}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"InverseCDF", "[", 
      RowBox[{"dist", ",", 
       RowBox[{"CDF", "[", 
        RowBox[{"dist", ",", "x"}], "]"}]}], "]"}], "\[Equal]", "x"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142961085],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->460187563]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", ">", "q", ">", "0"}], "&&", 
    RowBox[{"\[Lambda]", ">", "0"}]}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"CDF", "[", 
      RowBox[{"dist", ",", 
       RowBox[{"InverseCDF", "[", 
        RowBox[{"dist", ",", "q"}], "]"}]}], "]"}], "\[Equal]", "q"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66031175],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->243297108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26722913],

Cell[TextData[{
 "Compositions of ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseCDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseCDF"]], "InlineFormula"],
 " give step functions for a discrete distribution:"
}], "ExampleText",
 CellID->558267465],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"PoissonDistribution", "[", "2", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286444275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{"dist", ",", 
     RowBox[{"InverseCDF", "[", 
      RowBox[{"dist", ",", "q"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->398800],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1rFEEUf9nZuxQakEtyKlqk8/wLbAwWoqksxXpziJdCE+LZaKloY6MW
EhBFAoJgZ4jYiYKVaCtaSApJYxAMFlbre7Mz6+TN3O3MRjcrZNl9uzPvvd++
r52PPZP0e+cvJv25bjI1s5gs9Oa6l6dOzy9ilxgBgBW8Fg4APqf4JK+VNMW7
TY8ijVBAUEuQJPWCfJw0eY2Mlx3AuSLnQlTAa+MDdUUOnpSHDtH4Dwegwayb
sCSaDK1lScRWz7iHTJvhCktC+gH7mNxkoYXut8eedlVr+6hfdIdmyMcHyjPV
wf5Qy+cvPccTWkTie3ffbm7+MuQMpEZa5Im2we2B8PQtOPYf3n/FE1pE4u7s
M7y7PYgsJNuewT5w//92HUV5XjEVmQ+qt6nubXXnNTVu9GvbXXq6LbbGz8yn
yN8Nt2stNYZ0Wce8UIdHjOeSt8dYe6JA/nAg/l4Xf4dindddDbK661t1Vqth
QB7udYpzxLdxhs7VfB3jg6Fn87ikrjmbkg/UzHVv3Xz16OE76BARnz99U5qJ
A0vPBe44oBGIQTBHJNa1qy8Rm1izAVjHZfvF6setukZu+NjFI+pG4DWwXSmy
fbqSN+1aXSffrFGC7Ts867lgncS/9PIoBFKtDaJkFLiO5/vZyBB5W16DyrrS
X6VFeoeIWFv7rvjHhmihlNqhdIiIUycfDNW6INsnppcsKfKqN5Drh1FXqWp8
Cx0LBqAEfofVoZhzNKn+B/YbGdG7O78s/Lvawh04CuIJB4nQF7ux8ZNYh5xa
12X73Nkn6+s/dlqKfL1RI3tCrcYhUsV+j459NsxmO1oL847WUivqECm19VaH
658kr0Q3Dte0/5HwbyHDwSlH+SokwbpT/NGSuPdTVeW4nsfZKgiHBKR+/Ob1
F9TPprpmSUseb0vPNSo8lV32X2wY+Q3nQY1y\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->554877254]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseCDF", "[", 
    RowBox[{"dist", ",", 
     RowBox[{"CDF", "[", 
      RowBox[{"dist", ",", "y"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->388428965],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1IVFEUfvpmxkhsE0XQn+bYpp9FapuyFqYRJhFlLcxgGgyl1NCxRX+r
so0UlFSC5CKL/hZBYgQFURAJkRAFUUEYhC2SIGkhBK9zzr1v7rtn7oyvGuf1
mLlv7jvf+b/n3DuvPpZoaW6LJVrjseKtnbEjLa3xruLajk54ZOdZljUM36OL
LPjtwC/6DjsO3FPHdTDaAIjKez7c8+FeIudWiGDywqchD8omYiWOCHboslbg
EFJzgfcilrO5baKHxTw5khR0Lw/vs6S52ChhtrWWeOZmT8tlxMv86VIIyRf1
pcErJ+pPU9irCSVTNCJevnRxrJC2lTpqNblrL18uPe/cdryrzruKi5hlQxme
zoXxpuuNwoy9+gIfK4wDzicmfpB7TEbQ88h/Zg+f28bIC9TehhsyqksZvYzN
V85A96dlIBuoixeeD159aYVxsO/cfi3pfUkuXJEiK8+efgKUQtdtG5Q6+ow6
ipglOUQ9fvRRrfa3b75Keq/m1TxCXx8a62i/Dx8rjINdUz0gdfQadSxglgSJ
Qi8WEvX4sYebq/rhY4VxQC/Gx78j6bRRplih4DBEKGgUerHM9SJ+4K7KRXdi
ZHLyJ5JOZJA5NTWtdTcQIXWYucqYJQKFFYEgXvFm9ByG4nvHP3Kd7XmCJRah
OhNpR1JXWim2u3faH95/06oUovFg5B2SEsQdkRHnfq6hOShOQXtRIV9cBY7a
4WZG8/wkUf1XRjGhEcrq9PQvST+krZy1hB598Vmr4p07rkkdh406KpklQaLQ
i/VEhf4rqzhCVSygSIobZVYhN2S5OQdUtHKTayU0IwxzhGIN+4LkajTKQq4C
yqFY1vhsnxFZI7U2ZYWKFtcSCnq8ZjHUiOTalVYWrTitryjrdxu56qUFDUTV
/1m4/yh41ek81A8ynkn5PBv8lg0CIC6mjlP3B3JxKuQBv9aDoK9D8JC0/S/t
JP+wHmZFjjxw0eWewnmmzJx8DSRRsHWZeld1kgt17CE0nE+03tXUeAtOZUja
YtTRxCwJEoVe7CcqOKr1LuECkjYYZTa7XOAz/twYIAq9OOjmAo61qlOoE3G5
UWaSS3aKEOUbuKSOCiNXG7Mkhyjog6Y6X6XFop3QsGqhcaoqhuRLHauNOrqZ
JQIlCsm9XBZeXWZeXr38vQKnZ1mKOEjKGhYHUSSV+paKUyENuKEjqBpvbbkH
0pEUVdJS3mrwKJ2kOWQNssh4U95T8JObmdfb+dz3EfzUZubk2U+PQpmniAon
dagu1SNEmpC02CjzDJO5JEAUetHj5hL+XqkeoTrdfKNMwQVnDu00AQHIyHWO
5oGgtL1bnUELtVicJzRQNbTSUWjUcYlZkkOUFn11AlTvWtCry/QIMqrtyGLb
09F+38dZeb8B5sjAVQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->248133078]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Substitution of invalid values into symbolic outputs gives results that are \
not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDF", "[", 
   RowBox[{
    RowBox[{"ChiSquareDistribution", "[", "3", "]"}], ",", "y"}], "]"}], "/.",
   
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"1.", "+", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29801],

Cell[BoxData[
 RowBox[{"0.20710251037772368`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.2585814913177707`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->839186336]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseCDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseCDF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with CDF",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=CDF"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->54325793],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->374735148],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->813591361],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->58250849],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->432372678]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CDF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 17.1630572}", "context" -> "System`", 
    "keywords" -> {
     "cumulative distribution function", "distribution function", "prob", 
      "probability function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CDF[dist, x] gives the cumulative distribution function for the symbolic \
distribution dist evaluated at x. CDF[dist] gives the CDF as a pure \
function.", "synonyms" -> {}, "title" -> "CDF", "type" -> "Symbol", "uri" -> 
    "ref/CDF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7866, 238, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->196803166]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45070, 1510}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2807, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3430, 88, 1568, 37, 70, "ObjectNameGrid"],
Cell[5001, 127, 1018, 33, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6056, 165, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6534, 182, 398, 15, 70, "Notes",
 CellID->12382],
Cell[6935, 199, 449, 16, 70, "Notes",
 CellID->26500],
Cell[7387, 217, 442, 16, 70, "Notes",
 CellID->19169]
}, Closed]],
Cell[CellGroupData[{
Cell[7866, 238, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->196803166],
Cell[CellGroupData[{
Cell[8251, 252, 147, 5, 70, "ExampleSection",
 CellID->43202983],
Cell[8401, 259, 74, 1, 70, "Notes",
 CellID->431130830],
Cell[CellGroupData[{
Cell[8500, 264, 177, 6, 28, "Input",
 CellID->617514039],
Cell[8680, 272, 550, 18, 52, "Output",
 CellID->344657597]
}, Open  ]],
Cell[9245, 293, 125, 3, 70, "ExampleDelimiter",
 CellID->266931418],
Cell[9373, 298, 72, 1, 70, "Notes",
 CellID->376452893],
Cell[CellGroupData[{
Cell[9470, 303, 175, 6, 70, "Input",
 CellID->53095017],
Cell[9648, 311, 286, 9, 36, "Output",
 CellID->373699358]
}, Open  ]],
Cell[9949, 323, 124, 3, 70, "ExampleDelimiter",
 CellID->64351119],
Cell[10076, 328, 88, 1, 70, "Notes",
 CellID->44097542],
Cell[CellGroupData[{
Cell[10189, 333, 179, 5, 70, "Input",
 CellID->806604733],
Cell[10371, 340, 417, 16, 58, "Output",
 CellID->163420426]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10837, 362, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11061, 371, 72, 1, 70, "ExampleText",
 CellID->659006259],
Cell[CellGroupData[{
Cell[11158, 376, 175, 6, 70, "Input",
 CellID->191583331],
Cell[11336, 384, 234, 7, 36, "Output",
 CellID->394328402]
}, Open  ]],
Cell[CellGroupData[{
Cell[11607, 396, 214, 6, 70, "Input",
 CellID->359728176],
Cell[11824, 404, 194, 6, 51, "Output",
 CellID->889425885]
}, Open  ]],
Cell[12033, 413, 124, 3, 70, "ExampleDelimiter",
 CellID->15255080],
Cell[12160, 418, 77, 1, 70, "ExampleText",
 CellID->416017623],
Cell[CellGroupData[{
Cell[12262, 423, 177, 6, 70, "Input",
 CellID->610607049],
Cell[12442, 431, 175, 5, 36, "Output",
 CellID->58908286]
}, Open  ]],
Cell[12632, 439, 124, 3, 70, "ExampleDelimiter",
 CellID->19374803],
Cell[12759, 444, 114, 3, 70, "ExampleText",
 CellID->157989833],
Cell[CellGroupData[{
Cell[12898, 451, 254, 8, 70, "Input",
 CellID->235751636],
Cell[13155, 461, 208, 5, 36, "Output",
 CellID->322805085]
}, Open  ]],
Cell[13378, 469, 125, 3, 70, "ExampleDelimiter",
 CellID->457132839],
Cell[13506, 474, 124, 3, 70, "ExampleText",
 CellID->576110967],
Cell[CellGroupData[{
Cell[13655, 481, 224, 7, 70, "Input",
 CellID->191591077],
Cell[13882, 490, 200, 6, 51, "Output",
 CellID->528451489]
}, Open  ]],
Cell[14097, 499, 124, 3, 70, "ExampleDelimiter",
 CellID->13432999],
Cell[14224, 504, 138, 4, 70, "ExampleText",
 CellID->737502524],
Cell[CellGroupData[{
Cell[14387, 512, 285, 10, 70, "Input",
 CellID->229388],
Cell[14675, 524, 228, 6, 36, "Output",
 CellID->43128123]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14952, 536, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[15182, 545, 91, 1, 70, "ExampleText",
 CellID->526665614],
Cell[CellGroupData[{
Cell[15298, 550, 334, 11, 70, "Input",
 CellID->346682293],
Cell[15635, 563, 2356, 43, 70, "Output",
 Evaluatable->False,
 CellID->241348641]
}, Open  ]],
Cell[18006, 609, 125, 3, 70, "ExampleDelimiter",
 CellID->331526780],
Cell[18134, 614, 83, 1, 70, "ExampleText",
 CellID->57844831],
Cell[CellGroupData[{
Cell[18242, 619, 318, 10, 70, "Input",
 CellID->224981200],
Cell[18563, 631, 1286, 25, 70, "Output",
 Evaluatable->False,
 CellID->265250074]
}, Open  ]],
Cell[19864, 659, 124, 3, 70, "ExampleDelimiter",
 CellID->19696651],
Cell[19991, 664, 290, 10, 70, "ExampleText",
 CellID->591295648],
Cell[CellGroupData[{
Cell[20306, 678, 176, 6, 70, "Input",
 CellID->440899455],
Cell[20485, 686, 176, 5, 36, "Output",
 CellID->116918164]
}, Open  ]],
Cell[20676, 694, 207, 7, 70, "ExampleText",
 CellID->192845226],
Cell[CellGroupData[{
Cell[20908, 705, 202, 7, 70, "Input",
 CellID->556479428],
Cell[21113, 714, 179, 5, 36, "Output",
 CellID->232071201]
}, Open  ]],
Cell[21307, 722, 251, 9, 70, "ExampleText",
 CellID->397633568],
Cell[CellGroupData[{
Cell[21583, 735, 212, 7, 70, "Input",
 CellID->54834225],
Cell[21798, 744, 177, 5, 36, "Output",
 CellID->93624048]
}, Open  ]],
Cell[21990, 752, 125, 3, 70, "ExampleDelimiter",
 CellID->232864721],
Cell[22118, 757, 137, 4, 70, "ExampleText",
 CellID->458937523],
Cell[22258, 763, 233, 8, 70, "Input",
 CellID->63385103],
Cell[CellGroupData[{
Cell[22516, 775, 178, 6, 70, "Input",
 CellID->349390459],
Cell[22697, 783, 625, 14, 70, "Output",
 Evaluatable->False,
 CellID->92101821]
}, Open  ]],
Cell[CellGroupData[{
Cell[23359, 802, 234, 7, 70, "Input",
 CellID->491852100],
Cell[23596, 811, 2093, 42, 137, "Output",
 CellID->529084168]
}, Open  ]],
Cell[25704, 856, 74, 1, 70, "ExampleText",
 CellID->27392962],
Cell[25781, 859, 373, 13, 70, "Input",
 CellID->580289555],
Cell[CellGroupData[{
Cell[26179, 876, 183, 6, 70, "Input",
 CellID->224414870],
Cell[26365, 884, 1476, 28, 70, "Output",
 Evaluatable->False,
 CellID->121815542]
}, Open  ]],
Cell[CellGroupData[{
Cell[27878, 917, 111, 3, 70, "Input",
 CellID->324721185],
Cell[27992, 922, 765, 17, 70, "Output",
 Evaluatable->False,
 CellID->140181751]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28806, 945, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[29047, 954, 331, 12, 70, "ExampleText",
 CellID->101458639],
Cell[CellGroupData[{
Cell[29403, 970, 392, 12, 70, "Input",
 CellID->815734516],
Cell[29798, 984, 270, 9, 36, "Output",
 CellID->269484526]
}, Open  ]],
Cell[CellGroupData[{
Cell[30105, 998, 184, 6, 70, "Input",
 CellID->498810307],
Cell[30292, 1006, 577, 14, 70, "Output",
 Evaluatable->False,
 CellID->683560941]
}, Open  ]],
Cell[30884, 1023, 124, 3, 70, "ExampleDelimiter",
 CellID->12189208],
Cell[31011, 1028, 324, 12, 70, "ExampleText",
 CellID->107144637],
Cell[CellGroupData[{
Cell[31360, 1044, 373, 13, 70, "Input",
 CellID->325017733],
Cell[31736, 1059, 312, 11, 36, "Output",
 CellID->218151150]
}, Open  ]],
Cell[CellGroupData[{
Cell[32085, 1075, 174, 6, 70, "Input",
 CellID->429809195],
Cell[32262, 1083, 732, 16, 70, "Output",
 Evaluatable->False,
 CellID->582810558]
}, Open  ]],
Cell[33009, 1102, 125, 3, 70, "ExampleDelimiter",
 CellID->152805149],
Cell[33137, 1107, 343, 12, 70, "ExampleText",
 CellID->203272416],
Cell[33483, 1121, 175, 6, 70, "Input",
 CellID->410116367],
Cell[CellGroupData[{
Cell[33683, 1131, 420, 14, 70, "Input",
 CellID->142961085],
Cell[34106, 1147, 161, 5, 36, "Output",
 CellID->460187563]
}, Open  ]],
Cell[CellGroupData[{
Cell[34304, 1157, 429, 14, 70, "Input",
 CellID->66031175],
Cell[34736, 1173, 161, 5, 36, "Output",
 CellID->243297108]
}, Open  ]],
Cell[34912, 1181, 124, 3, 70, "ExampleDelimiter",
 CellID->26722913],
Cell[35039, 1186, 370, 13, 70, "ExampleText",
 CellID->558267465],
Cell[35412, 1201, 160, 5, 70, "Input",
 CellID->286444275],
Cell[CellGroupData[{
Cell[35597, 1210, 308, 10, 70, "Input",
 CellID->398800],
Cell[35908, 1222, 1164, 23, 70, "Output",
 Evaluatable->False,
 CellID->554877254]
}, Open  ]],
Cell[CellGroupData[{
Cell[37109, 1250, 312, 10, 70, "Input",
 CellID->388428965],
Cell[37424, 1262, 1636, 31, 70, "Output",
 Evaluatable->False,
 CellID->248133078]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39109, 1299, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[39343, 1308, 140, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[39508, 1316, 275, 10, 70, "Input",
 CellID->29801],
Cell[39786, 1328, 274, 7, 36, "Output",
 CellID->839186336]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40121, 1342, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[40440, 1353, 931, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[41408, 1393, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[41729, 1404, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[41885, 1409, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[42079, 1417, 305, 8, 70, "RelatedLinksSection"],
Cell[42387, 1427, 346, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42770, 1443, 299, 8, 70, "MoreAboutSection"],
Cell[43072, 1453, 154, 3, 70, "MoreAbout",
 CellID->54325793],
Cell[43229, 1458, 161, 3, 70, "MoreAbout",
 CellID->374735148],
Cell[43393, 1463, 132, 3, 70, "MoreAbout",
 CellID->813591361],
Cell[43528, 1468, 178, 3, 70, "MoreAbout",
 CellID->58250849],
Cell[43709, 1473, 151, 3, 70, "MoreAbout",
 CellID->432372678]
}, Open  ]],
Cell[43875, 1479, 27, 0, 70, "History"],
Cell[43905, 1481, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

