(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25211,        990]
NotebookOptionsPosition[     18554,        752]
NotebookOutlinePosition[     19826,        789]
CellTagsIndexPosition[     19741,        784]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generating C and Fortran Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneratingCAndFortranExpressions"], 
          "Forms of Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FormsOfInputAndOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Generating C and Fortran Expressions\"\>", 
       2->"\<\"Forms of Input and Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FortranForm" :> 
          Documentation`HelpLookup["paclet:ref/FortranForm"], "Compile" :> 
          Documentation`HelpLookup["paclet:ref/Compile"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FortranForm\"\>", 
       2->"\<\"Compile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"C/C++ Language Interface\"\>", 
       2->"\<\"Display of Numbers\"\>", 
       3->"\<\"Numerical Evaluation & Precision\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CForm", "ObjectName",
 CellID->1078],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a C language version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Standard arithmetic functions and certain control structures are translated. \
\
\>", "Notes",
 CellID->28362],

Cell["No declarations are generated. ", "Notes",
 CellID->11145],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->2867]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68303497],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->259623316],

Cell["A C language version of a polynomial:", "ExampleText",
 CellID->551017233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->608693877],

Cell["1 + 2*x + 3*Power(x,2)", "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//CForm=",
 CellID->44548937]
}, Open  ]],

Cell["A mixed numeric and symbolic expression:", "ExampleText",
 CellID->120247557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{"1.2", " ", "x"}], "+", 
   RowBox[{"Exp", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140853911],

Cell["Power(E,y) + 1.2*x", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//CForm=",
 CellID->567160202]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->123711963],

Cell["C formatting for an arbitrary function:", "ExampleText",
 CellID->458199205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751320023],

Cell["f(x)", "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//CForm=",
 CellID->26879196]
}, Open  ]],

Cell["A composite power:", "ExampleText",
 CellID->430667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"f", "^", 
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "x", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14082873],

Cell["Power(f,g(h(x)))", "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//CForm=",
 CellID->94272193]
}, Open  ]],

Cell["A vector:", "ExampleText",
 CellID->873919339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->440347332],

Cell["List(1,2,3)", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//CForm=",
 CellID->196252799]
}, Open  ]],

Cell["A matrix:", "ExampleText",
 CellID->246775398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->322419301],

Cell["List(List(1,2,3),List(4,5,6))", "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//CForm=",
 CellID->381149118]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14942],

Cell["\<\
Compute the analytic Hessian for a multivariate function for use in C code:\
\>", "ExampleText",
 CellID->58930910],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{
     RowBox[{"y", "^", "3"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408934974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621847130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "-", 
      RowBox[{
       SuperscriptBox["y", "3"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
     RowBox[{"3", " ", 
      SuperscriptBox["y", "2"], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["y", "2"], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], ",", 
     RowBox[{"6", " ", "y", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131344100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->194585093],

Cell["\<\
List(List(2 - Power(y,3)*Sin(x),3*Power(y,2)*Cos(x)),
   List(3*Power(y,2)*Cos(x),6*y*Sin(x)))\
\>", "Output",
 ImageSize->{371, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//CForm=",
 CellID->478161420]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8253608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " formats expressions like C code:"
}], "ExampleText",
 CellID->57980832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653451490],

Cell["1 + 2*x + 3*Power(x,2)", "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//CForm=",
 CellID->455327110]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " formats expressions like Fortran code:"
}], "ExampleText",
 CellID->71117676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->130576372],

Cell["1 + 2*x + 3*x**2", "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FortranForm=",
 CellID->84017683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->559730002],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " can be used to convert expressions in a file: "
}], "ExampleText",
 CellID->636006957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "5"}], ",", " ", "x"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329129734],

Cell["(-5*Cos(x))/8. + (5*Cos(3*x))/48. - Cos(5*x)/80.", "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//CForm=",
 CellID->78282176]
}, Open  ]],

Cell["The following C file contains the unevaluated integral:", "ExampleText",
 CellID->5218386],

Cell[BoxData[
 RowBox[{
  RowBox[{"ifile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"\"\<ExampleData\>\"", ",", "\"\<splicefile.mc\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->374697122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "ifile", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->641697745],

Cell["\<\
#include \"mdefs.h\"

double f(double x)
{
double y;

y = <* Integrate[Sin[x]^5, x] *> ;

return(2*y - 1) ;
}\
\>", "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"During evaluation of In[2]:=",
 CellID->77431791]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " inserts the result of the integral:"
}], "ExampleText",
 CellID->35240128],

Cell[BoxData[
 RowBox[{
  RowBox[{"ofile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<spliceoutput.c\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25086988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Splice", "[", 
  RowBox[{"ifile", ",", "ofile"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->499700900],

Cell[BoxData["\<\"ExampleData\\\\splicefile.mc\"\>"], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->196468913]
}, Open  ]],

Cell["The spliced file:", "ExampleText",
 CellID->323774926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "ofile", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->738229338],

Cell["\<\
#include \"mdefs.h\"

double f(double x)
{
double y;

y = (-5*Cos(x))/8. + (5*Cos(3*x))/48. - Cos(5*x)/80. ;

return(2*y - 1) ;
}\
\>", "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"During evaluation of In[4]:=",
 CellID->336126476]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->764867],

Cell["\<\
Additional C function definitions may be needed to run the code:\
\>", "ExampleText",
 CellID->41702638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"BesselJ", "[", 
   RowBox[{"x", ",", "7"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114469161],

Cell["BesselJ(x,7)", "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//CForm=",
 CellID->285449068]
}, Open  ]],

Cell["\<\
Here is a template for such an include file (shown on a typical Windows \
installation):\
\>", "ExampleText",
 CellID->105142260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"{", 
     RowBox[{
     "$InstallationDirectory", ",", "\"\<SystemFiles\>\"", ",", 
      "\"\<IncludeFiles\>\"", ",", "\"\<C\>\""}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73897531],

Cell[BoxData[
 RowBox[{"{", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\IncludeFiles\\\\C\\\\mdefs.h\
\"\>", "}"}]], "Output",
 ImageSize->{445, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121162366]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24441],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FortranForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FortranForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13670]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15026],

Cell[TextData[ButtonBox["Generating C and Fortran Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneratingCAndFortranExpressions"]], "Tutorials",\

 CellID->20525],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->13700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->67730507],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout",
 CellID->65441110],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->38283159],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->250961059]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 7.8362294}", "context" -> "System`", 
    "keywords" -> {
     "C language", "code generation", "output", "programs", 
      "language conversion", "splicing C code"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CForm[expr] prints as a C language version of expr. ", "synonyms" -> {}, 
    "title" -> "CForm", "type" -> "Symbol", "uri" -> "ref/CForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4645, 149, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68303497]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19599, 777}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2412, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3035, 84, 42, 1, 70, "ObjectName",
 CellID->1078],
Cell[3080, 87, 550, 18, 70, "Usage",
 CellID->948]
}, Open  ]],
Cell[CellGroupData[{
Cell[3667, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4145, 127, 120, 4, 70, "Notes",
 CellID->28362],
Cell[4268, 133, 64, 1, 70, "Notes",
 CellID->11145],
Cell[4335, 136, 273, 8, 70, "Notes",
 CellID->2867]
}, Closed]],
Cell[CellGroupData[{
Cell[4645, 149, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68303497],
Cell[CellGroupData[{
Cell[5029, 163, 148, 5, 70, "ExampleSection",
 CellID->259623316],
Cell[5180, 170, 80, 1, 70, "ExampleText",
 CellID->551017233],
Cell[CellGroupData[{
Cell[5285, 175, 197, 7, 28, "Input",
 CellID->608693877],
Cell[5485, 184, 177, 5, 50, "Output",
 CellID->44548937]
}, Open  ]],
Cell[5677, 192, 83, 1, 70, "ExampleText",
 CellID->120247557],
Cell[CellGroupData[{
Cell[5785, 197, 181, 6, 28, "Input",
 CellID->140853911],
Cell[5969, 205, 174, 5, 50, "Output",
 CellID->567160202]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6192, 216, 220, 7, 70, "ExampleSection",
 CellID->123711963],
Cell[6415, 225, 82, 1, 70, "ExampleText",
 CellID->458199205],
Cell[CellGroupData[{
Cell[6522, 230, 129, 4, 70, "Input",
 CellID->751320023],
Cell[6654, 236, 158, 5, 50, "Output",
 CellID->26879196]
}, Open  ]],
Cell[6827, 244, 58, 1, 70, "ExampleText",
 CellID->430667],
Cell[CellGroupData[{
Cell[6910, 249, 182, 6, 70, "Input",
 CellID->14082873],
Cell[7095, 257, 171, 5, 50, "Output",
 CellID->94272193]
}, Open  ]],
Cell[7281, 265, 52, 1, 70, "ExampleText",
 CellID->873919339],
Cell[CellGroupData[{
Cell[7358, 270, 158, 5, 70, "Input",
 CellID->440347332],
Cell[7519, 277, 166, 5, 50, "Output",
 CellID->196252799]
}, Open  ]],
Cell[7700, 285, 52, 1, 70, "ExampleText",
 CellID->246775398],
Cell[CellGroupData[{
Cell[7777, 290, 270, 9, 70, "Input",
 CellID->322419301],
Cell[8050, 301, 185, 5, 50, "Output",
 CellID->381149118]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8284, 312, 223, 7, 70, "ExampleSection",
 CellID->14942],
Cell[8510, 321, 125, 3, 70, "ExampleText",
 CellID->58930910],
Cell[8638, 326, 243, 9, 70, "Input",
 CellID->408934974],
Cell[CellGroupData[{
Cell[8906, 339, 222, 8, 70, "Input",
 CellID->621847130],
Cell[9131, 349, 685, 23, 39, "Output",
 CellID->131344100]
}, Open  ]],
Cell[CellGroupData[{
Cell[9853, 377, 101, 3, 70, "Input",
 CellID->194585093],
Cell[9957, 382, 258, 8, 66, "Output",
 CellID->478161420]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10264, 396, 235, 7, 70, "ExampleSection",
 CellID->8253608],
Cell[10502, 405, 203, 7, 70, "ExampleText",
 CellID->57980832],
Cell[CellGroupData[{
Cell[10730, 416, 197, 7, 70, "Input",
 CellID->653451490],
Cell[10930, 425, 178, 5, 50, "Output",
 CellID->455327110]
}, Open  ]],
Cell[11123, 433, 221, 7, 70, "ExampleText",
 CellID->71117676],
Cell[CellGroupData[{
Cell[11369, 444, 203, 7, 70, "Input",
 CellID->130576372],
Cell[11575, 453, 177, 5, 50, "Output",
 CellID->84017683]
}, Open  ]],
Cell[11767, 461, 125, 3, 70, "ExampleDelimiter",
 CellID->559730002],
Cell[11895, 466, 220, 7, 70, "ExampleText",
 CellID->636006957],
Cell[CellGroupData[{
Cell[12140, 477, 227, 8, 70, "Input",
 CellID->329129734],
Cell[12370, 487, 203, 5, 50, "Output",
 CellID->78282176]
}, Open  ]],
Cell[12588, 495, 96, 1, 70, "ExampleText",
 CellID->5218386],
Cell[12687, 498, 218, 7, 70, "Input",
 CellID->374697122],
Cell[CellGroupData[{
Cell[12930, 509, 109, 3, 70, "Input",
 CellID->641697745],
Cell[13042, 514, 247, 15, 70, "Print",
 CellID->77431791]
}, Open  ]],
Cell[13304, 532, 208, 7, 70, "ExampleText",
 CellID->35240128],
Cell[13515, 541, 215, 7, 70, "Input",
 CellID->25086988],
Cell[CellGroupData[{
Cell[13755, 552, 133, 4, 70, "Input",
 CellID->499700900],
Cell[13891, 558, 194, 5, 36, "Output",
 CellID->196468913]
}, Open  ]],
Cell[14100, 566, 60, 1, 70, "ExampleText",
 CellID->323774926],
Cell[CellGroupData[{
Cell[14185, 571, 109, 3, 70, "Input",
 CellID->738229338],
Cell[14297, 576, 268, 15, 70, "Print",
 CellID->336126476]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14614, 597, 227, 7, 70, "ExampleSection",
 CellID->764867],
Cell[14844, 606, 114, 3, 70, "ExampleText",
 CellID->41702638],
Cell[CellGroupData[{
Cell[14983, 613, 159, 5, 70, "Input",
 CellID->114469161],
Cell[15145, 620, 167, 5, 50, "Output",
 CellID->285449068]
}, Open  ]],
Cell[15327, 628, 139, 4, 70, "ExampleText",
 CellID->105142260],
Cell[CellGroupData[{
Cell[15491, 636, 326, 10, 70, "Input",
 CellID->73897531],
Cell[15820, 648, 300, 8, 54, "Output",
 CellID->121162366]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16181, 663, 311, 9, 70, "SeeAlsoSection",
 CellID->24441],
Cell[16495, 674, 455, 17, 70, "SeeAlso",
 CellID->13670]
}, Open  ]],
Cell[CellGroupData[{
Cell[16987, 696, 314, 9, 70, "TutorialsSection",
 CellID->15026],
Cell[17304, 707, 181, 4, 70, "Tutorials",
 CellID->20525],
Cell[17488, 713, 157, 3, 70, "Tutorials",
 CellID->13700]
}, Open  ]],
Cell[CellGroupData[{
Cell[17682, 721, 318, 9, 70, "MoreAboutSection",
 CellID->67730507],
Cell[18003, 732, 153, 3, 70, "MoreAbout",
 CellID->65441110],
Cell[18159, 737, 145, 3, 70, "MoreAbout",
 CellID->38283159],
Cell[18307, 742, 175, 3, 70, "MoreAbout",
 CellID->250961059]
}, Open  ]],
Cell[18497, 748, 27, 0, 70, "History"],
Cell[18527, 750, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

