(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    276227,       5627]
NotebookOptionsPosition[    266974,       5309]
NotebookOutlinePosition[    268475,       5350]
CellTagsIndexPosition[    268388,       5345]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "Hue" :> Documentation`HelpLookup["paclet:ref/Hue"], "Opacity" :> 
          Documentation`HelpLookup["paclet:ref/Opacity"], "Cyan" :> 
          Documentation`HelpLookup["paclet:ref/Cyan"], "Magenta" :> 
          Documentation`HelpLookup["paclet:ref/Magenta"], "Yellow" :> 
          Documentation`HelpLookup["paclet:ref/Yellow"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RGBColor\"\>", 2->"\<\"Hue\"\>", 
       3->"\<\"Opacity\"\>", 4->"\<\"Cyan\"\>", 5->"\<\"Magenta\"\>", 
       6->"\<\"Yellow\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CMYKColor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CMYKColor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CMYKColor"], "[", 
       RowBox[{
        StyleBox["cyan", "TI"], ",", 
        StyleBox["magenta", "TI"], ",", 
        StyleBox["yellow", "TI"], ",", 
        StyleBox["black", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that graphical \
objects which follow are to be displayed in the color given. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CMYKColor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CMYKColor"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["k", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies opacity ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Color and opacity levels outside the range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " will be clipped.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->318150803]
}], "Notes",
 CellID->21519],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 " can be used to specify colors for color printing. "
}], "Notes",
 CellID->14716],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["y", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->599462901],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 " specifications are automatically converted to ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " when simulated lighting calculations are done. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23349739]
}], "Notes",
 CellID->21640],

Cell[TextData[{
 "The alternative forms ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["k", "TI"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["k", "TI"], ",", 
     StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can also be used."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23764]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246249139],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->118136369],

Cell["Specify the color of graphics primitives:", "ExampleText",
 CellID->149026781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CMYKColor", "[", 
     RowBox[{"0", ",", "1", ",", "1", ",", ".25"}], "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64769354],

Cell[BoxData[
 GraphicsBox[
  {CMYKColor[0, 1, 1, 0.25], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->531746997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165758003],

Cell["Specify the color with opacity:", "ExampleText",
 CellID->263465182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CMYKColor", "[", 
     RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", ".5"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152479682],

Cell[BoxData[
 Graphics3DBox[
  {CMYKColor[1, 0, 1, 0], Opacity[0.5], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->166571302,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62699745],

Cell["Specify the output color of expressions:", "ExampleText",
 CellID->53708190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"CMYKColor", "[", 
    RowBox[{"1", ",", ".8", ",", "0", ",", ".25"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195861199],

Cell[BoxData[
 StyleBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}],
  StripOnInput->False,
  FrontFaceColor->CMYKColor[1, 0.8, 0, 0.25],
  BackFaceColor->CMYKColor[1, 0.8, 0, 0.25],
  GraphicsColor->CMYKColor[1, 0.8, 0, 0.25],
  FontColor->CMYKColor[1, 0.8, 0, 0.25]]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->382062553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20732203],

Cell["Specify the color of plots:", "ExampleText",
 CellID->580206808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"CMYKColor", "[", 
     RowBox[{"0.3", ",", "1", ",", "0", ",", ".25"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211868938],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106841461]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14718],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Colors in 3D",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23349739],

Cell["Use diffuse surface color:", "ExampleText",
 CellID->404625886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CMYKColor", "[", 
     RowBox[{"0", ",", "0.4", ",", "1", ",", "0"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->907978],

Cell[BoxData[
 Graphics3DBox[
  {CMYKColor[0, 0.4, 1, 0], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6864743,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJycvQV8Fcm2t/18AUbOOfec9/q9cQIhCRFiRIm7u7sLJJAgQYO7wwwMDDMw
MDAwMLi7u3twl6BBAiTh971VvXdC2GHmMC+/2t27umr37vX0f61V1b3ThGX1
KswryepVlJNlGFCe1aOwKKenoX/3crGp1f8HrBWvPf+DeP//i3fKq+/79+9p
lZeX9175h7Nc0FssW4uNrkqtp1hqiVor9dpF2VqmrrVptgexVO+hVCzlxi8/
2dpN/dm/yFrrpm8Xb5yU9iL1p//2O+0F6s//Q9baNLWrv8NR6ZOn7vOvGhZq
adTtld7Z6m/898/qnane939ptLbSqNspvdPU+/7ff7JvVe8U9b51/8m+bZXe
Sere+hqtrTXqNkrvePWRGH5W71j1vttptLbRqFsrvaPVvY01Wr/QqHdSekeo
j8Tks3qHqffdUaP1S426ldI7WL1vi8/qHajedyeN1q806pZKb391bxuN1q81
6sp346M+ErvP6u2l3reDRutfNOrmSm8PdW+nz+rdRX0kLhqtf9WoK4RxUe/b
TaP1bxp1M6W3o3rfHp/Vu7N6394arf+iUTdVetupe/v9k96KjhQlyo0Bn9Xb
Sr3vYI3Wv2vUOyi9zdX7Dv2s3mbqfUdotP5Do654i3I8sneURuv/0ai3V3q3
Vx9JzGf1NlLvO16jVTMuKl6Oobp34mf11lMfSbJG679p1I2U3jrqfadptGrG
3LZK7/9R7zvjs3r/l3rf2Rqt/6FRVyKfslX2ztVo/U+NuoHS+1/VR5L/Wb01
z0KBRl0zZyiRW9GFPKKiz+7dPKv+s0/pffjUR9nURzm1Sdqka5OtTZ42RdqU
aFOmTU9temtToU0/bfprM1CbSm0GazNIm3JtWnD9b4267odvbJGf3ZRDjNEm
UZs05YvztSlWvriHNr2Ub+2vfNMQbYZpM0KbkdqM1masNuO1majNJG0ma6Ml
VlqiRiuxVf29mp7+B8f1B5lYicD/G65NpDax2jQBKtCmmzbdFQR9FDQDFSji
IEdpM0abcdpMUA5vijbTtPlGmxnazBSHqPWdWHw5S5vZ2nyvlDnafKf0aBEn
/0ejrqMcs2ac0czZynhAXxxzhDZRnzrslmyHK4c99lPH/J1ypD9oM1ebedr8
JEjPF4f61QJtflbKQmW5QGkS3TQz2ufZoDmSUDJyhzBtVOiFROKbmaFSSalC
//fMmNzCBsH5R8WG+Y3HvUibX7RZos2v2izVZpmw7Tdh2xfLlOqvStNixXLN
0YjmCE77k1ZpfkpmDi1hFCbNbRLKz2p0uaaz0+93Ts1UxSYhpFmKdlTn5SeF
/8JGa1SmCEuWa7NCm5XarNJmjfja1mt0oI14t1rZtFz5QAv9aH/K1ha2aY6h
ZJZuJW0zU9mWoE2KNhna5Ciy66p4S8/G8yVCyFDFn0crrjKxUXPfKifrDwwT
Vq3QYaUOq3UR1qzVYb0OG7TZqM0m6V2bdMRLV1nTWmxZrxgrKGh69udZqTn2
k1m6tWKl8Ky43z99wsoBipVNAWF8s9M3Qzl9c/7ARNUpU9mnywY9NuqxWY8t
umzVFVZu16XVDmHlDj3xEhvabNNli7bkIE6ujKx6n/LCFtZp+mq7RussI5qd
w0xtcpvlA2FdX8W6wY3iVJ3Ayc1OoCpizPsD07RZJ45Xh406bBbHrsdWfbbr
s8OAnfrs1mePKAbC0r0GtN6nLyzcq2zYpceOP7JQM+prjmpl1m8jLbQTgSVa
8cDmFpYqFvZuDOgq92su0enNJPpjo4UijCzW4VddlumyXJeVulKca3Xlmduo
K83bqsc2ceB6jbYZsNeQ/YYcEKUtB0Ux4pAobTncVth82FDEoEOGskF0Ege/
R0cS0pwH/vcnLdbMIfqNFjuoLE5oYXHzFPZJi2c0s/inRovlCdXhN11W6LFK
jzX6rNNngz6b9NmizzbVqTRgtyF72rJPWNJo5WEjjrTjqCjtOSaKMcdFac+J
9mgdbycsP2YkbRYkDgpOeghv1tGw6b8+ablmXafRcntVEmlufN7vG98kaA1f
VRn/c6PxIsIu11HOtR5r9Vivz0YDNhuy1ZDthuw0ZHdbxXIj9rfjYHsOtedw
e44aqw0+0YGTHTjVAa3TJmLccsaUMyayiHoHwUBYcUp0Er2NOCj2ZdAiXn2a
gaaH/2+jRztHNDLQ8OvCRr/u3WwY0xzDlGYZpylk/dzo1MtUHq3DGl3W6clI
JQVgwDZDdrRllxF7jNjXrpGBMYc7cNSEYyacMOWkKadMOW3GGTPOmnFOlI6c
7yhwXBCLr8Q7YYjcaspZU8lKyEX4iCaJ//wkCc2R3X835qcu4c1IxH2cqAo/
zsDNYYxt5hAShg5zdJirw086/KzLIl2WNPr/KpGZ9BRvMGCTIVsM2daWHUbs
asdeQaI9B4w51KGRhCknzDhpxumOnDHnrDnnzDlvwQULLopiSZUllyxpddkS
vhbWXLKgShRzLphLYKdMpJ5EHG0xIvmPT1LRnJP8ZyMV56bxYrQyZBRUkpXh
lkb67tuCimqsNb3JU3T4UZef9FigxyI9luixVJ/l+qzUV2KEARsM2dSWLUZs
a8fO9uxuz15j9nfgYAcOmXDElKNmHBdIOnLKnDMWnLXgvCUXrLhoRZUVlzoJ
H7ksFq2uWHPVmmvWoi4X0qpr6vpV0d5GYBMIz5tz2pSD7WgxElUR0oyXmjPW
f2/0ILcm3cQpE5bkj0ejTaObAY0TgZGNeX/yx0ObH4VodNV4Fuuz1IDlBqw0
YI0h6wzZ0JbNRmxtx/b27DRmdwf2mrDfhIOmHDbjaEeOdeSEOSctOG3BGUvO
WXG+Exc7UWXNJWsu23DFhqu2XLPlui037ASYm3YqOmJ901bQkYsvbthIegKk
EJjQ2xHjFnz+/ZN8NGfd/9oYZd0iGz0qUfGopnFR8cd5dVCzod/4j8e06qSq
wwJdBY6ind8EHENWt2VdWzZ+Eo4ZBztyuCNHzTluwQlLTllyxoqznSSZC9ZU
2XDJliu2XLXjmh3X7blhz017bnXmdmcxTLzjoOJzpzOioCUXX9wWXUR3gdNa
yu64aYsZ5Kf5aM6H/9HIxyOimXhUfJoicFPQ6fv7WXhm82GVDgt1JZ9fm/gY
Sj4bjNjcjq3t2W7Mzg7sNmGvaSMfc45acNySk1ac7sQZa85Zc96Gi7ZU2XLZ
jiv2XOvM9c7c6MxNB245cNuRO47cdeKekwB030lFSazlWy25+PKeaHeQ1ATO
63ZctpZO24LUv32SlOZVE9n+pUKq+ewo9Q8nEcM+GYUaY/N8gUmPX/T51YBl
hqxoyyoj1hqxvh2b2rPFmO0d2GnCblP2mrG/IwfNOWzBUUuOW3GyE6etOWPD
OVsu2HLRjkv2XOnMVcHIgRuO3HTklhO3nbjjzF1n7jlz34UHLoLMQ1dBqtpV
Zq9q+faRWHxV7cJD0cVZwrzrKLUnBHnWsgWrf/0kK83rOHJc+4Vk5RXeOMlX
5bGmkFT0cV5XeZ0MSTqM12GSDlN1+FaX73T5XlcdsX8WIUmfJQYsNWS5ESvb
saY969uz0ZgtHdhmwg5TdpmxpyP7zDlgwWFLjgrP6MRJa07bcNaWc3ZcsOei
PZeEeQ5cdeS6IzecuOXMbRfuuHDXlXuu3HflQRcedqHajUdugthjsfi7sO6J
G6ry1F0uH3fhkejkykMXSU7o8Zo9561b0Pg0M02yXzfqyyuicezfNH37pBsO
bnJDHSbqMkWX6XrM0GOWHnP0mKfPAn0JbLEhS9vymwJsdXvWdWCDCZtN2GrK
DjN2dWSPOfssOGDJISuOdOKYNSdsOCXOvh3n7LnQmYsOXHLgiiNXnbjuzE1n
bglartztwr0u3HfjgRsP3XnkzmMPnnjw1EMwe+qp8sdnnohC6+di8dUz0S56
uUluQoZCl0KsB81aEPs/nySmmQHkHP8rScxTdfkrUXHHzBbu2KfZnH6kyh11
mKzLNF2+1eM7fb434EcDfjLgZwN+MeTXtiwzYoXAZcxaBdcmU7aasb0ju8zZ
Y8E+Sw5YcagTR6w5ZsMJW07Zccaec5254ECVI5ecuOLEVWGeCzddueXKnS7c
deO+Ow/ceehBtQePPHnsyRMvnnmh9dxb0Krxlj5ZI9++EIu/vPRGrEW9xovn
CkYBV2hSSPSm0+8w05xRao5G5ZWsrxWVffIKQfM5dPNILzOh8EldvtFlph6z
9fnBgHmGLDBkUVuWKMCWt2eVMWs6sN6EjaZs6cg2c3ZasNuSvVYc6MQha47Y
cMyWE3acsudMZ845cMGRKicuOXPFhWsuXBe2deGWG3eEne7c9+CBJw89eeTF
Yy+eePPUm2c+PPehxleo7IVYyCvFr3x55SeL1ms/QU5UX6qKDy98JEIhx0ce
UqjC1zXJ/eOT5DRnda0b1ebVNDdPbnbh8g/UJnOkDtN1maGrOKc+cw2Yb8jC
tiw2Ymk7fmvPSmNWm7DOlA1mbO7IVnN2WLLLir2d2G/NQRsO23LUjuP2nOzM
aQfOOnLeiYvOXHLhiitXu3C9CzeFee7c8eCeB/cFNi+qvXnkzWMfnvjwzJfn
vtT48UIgavXSX+WfrwKoDRAQ34hFq1p/XvvzSjRpCZa0EQSFMoVMhXsLz29B
7u+fJKd5JUCrSXN/cN2m9yc1J4amqjygx/dNmmvLIiOWtGeZMSs6sMqEtaas
78gmc7ZYsN2SnVbssWafDQdsOWTHEXuOdeaEA6ccOePEeWcuunDJlctduOrG
dTduuHPLgzue3PXivhcPvan24bEvT3x56sczP577U+PPiwBeSUivA1HuFbwO
ojaIN0G8DRK83olF67dKvTZQFi2JtY3AKIQqdFvtKUNCi1HFpwnqadT/Iul5
RzRGuaabEZ8ccTSFOLXo9JllwBxD5rZlvhEL27G4PUuNWd6BlaasMWNdRzaY
s9mSrVbs6MQua/basN+Og/Yc6cwxB044csqJM86cc+GCK1VduOzGVXeuuXPD
g1ue3PZS0HnzwIdqXx778cSPp/488+d5AC8CeRnIqyAksGC03gSr+NWGIMrb
EN6FCHR1YvG1ePc2WBYVxdcBUqtPfWQAaKG9f/kkuabfFwhiEprisf6qUUh8
41T6k9cVhugwXIfROozTZZKuEuv0mWnAbEN+MGJeOxa0Z5ExSzqwzIQVpqwy
Y6056y3YZMkWK7Zbs9OGPbbsU8gd7sxRB447ctKJ086cdeG8Kxe7cMmNK4Kc
Bzc8uenFbW/uenPPhwe+VPvxyJ8n/jwN4FkgzwOpCeJFEK+CeS2ICDShvAuV
S2Feq7dhQorvwqgLoz5cvK0X9a9F5Z2qUwgCs5DnywAp4Huf4Pe3T/IzaIxy
fqoZd2QzzWVpTCZ16K9DpQ5DdRmpyxhdJugxWY/p+swwYJYhc9oytx3z27PQ
mMUm/GrKb2as7Mgac9ZZsNGKzZ3YZs0OG3bbsdeeA5055MARR445ccKZUy6c
ceVcFy64UeXOFQ+ueXLdi5ve3Pbhjg/3fHngx0N/HgXwJICngTwL4nkQNcG8
COZlCK9CqQ3ljYASJj00XBXx6iJ4FyHrERJbBPWR1Kvf8nVDhMRZFy4xC+RC
r0K4Qs23PVr6roqg5u8Ymgj6N79mocoWGpdxZMzTYaAug/UYrscoPcbpM1Gf
qfp8Y8BMQ2a35Yd2zGvPAmMWmbDElGVmrDBntQVrLdlgxSZrttqw3ZZdduyx
Z58YTTly2Imjzhx34aQrZ7pwzo0L7lR5cNmTq15c9+amD7d8uePLPT/u+/Mw
gOpAHgfyNIhnwTwPoSaEF6G8DOVVGK/DeCNwhEtoWnWRaoaCWZRkJhcN0TRE
KXUtsdAS7/myIRLJWXxQfFzsKohHIqEoVyvEx//ld8kpswbPJu01XfBRje2y
WlwaFQocpCsVOEKPMfqMN2CyAdMMmWHIrLbMMWJue+Yb83MHfjHlVzN+M2el
BWusWNeJjdZstmGbLTvs2d2ZvQ7sd+SQE0dcOObKiS6ccuOsO+c9uOjJJS+u
eHPNhxu+Et5tP+76cz+AB4FUB/FYiCSYZ4JcqCSn9TJMjkLCeR1BbQRvInkn
eCiM6qKl+4qlVn2MYCVfscqav4oNDUp5L4BGy84CuQAvBCwiwUM/1f1gCUzz
N1Z//SRP/UaePs2VGKPwjPud0Yu8QqTDYF2G6Uo9jhV6NGCKId8YMrMts434
oT3zjFlgwiJTFpux1JzlFqyyYm0n1luzyZYtdmy3Z2dndjuwz4kDzhx24agr
x7tw0o3T7pz14IInVV5c9uaqD9d9uSn8y587AdwLlDwfCrEE8ySEp6E8D+NF
GC/DeRUhYYqsKhX4Joq3gk60VGCMagRYF0u9KHGCpXi9j6eNWPPV+zjex/I+
hvpoeQLEaagNk2Hib2qSmvdAP01S5mNlbhakcR0yrsXV6ibPlrNaHYYIZeoy
Wo/x+kwyYKoh37blu3Z8354fjfnJhJ9N+aUjS8xZZsEKK1Z3Yp0NG2zZbMdW
e3Y4sMuRPU7sd+agC0e6cMyNE+6c8uCMJ+e8uOjNJR+u+HLNjxv+3ArgTiB3
A7kvBBNMdQiPQyXGZ0JC4byM4GUkryJ5HUVtFG+ieRvDuxhU7BRyCsv6eFRF
qyFBjHvFS6wFy3hUOIVihYAFy9fhPA1W7kJKWJr36/4JSy8Nlhq3m4ube7m2
zDNCkiMVL58gvNyQaUbMaMes9szpwFwT5puysCOLzfnVkt+sWNmJNTast2Wj
PVs6s82BnY7sdmKvMwdcOdSFo24cd+ekB6c9OevFeW+qfLjsy1U/rvtzM4Db
AmQQ94J5EEJ1KI9CeSKkE87zCF4oFF/JiPdaiPDvtTG8ieWdwBInJdggQCUg
mAmrxbIhkfpEuWxIEvOvJBEwkyTNRNlJlngE+LoYKWkRMtq8b/ab0s+n6dlE
U3VtKvEPrpArDi4Tjj5jDZnYlilGTG/HTGNmd+AHE+aZsaAji8xZYslSK5Zb
s8qGtbZssGdTZ7Y6sN2JXc7scWG/Kwe7cNiNYx6c8OSUF2e8OefDBV+q/Lji
z7UAbgRyK4g7wdwN4X4oDwXKMB4L5UTwPJKaSF5GIShqvRaxsFbIsM2bON7F
UycUqLAT3pyoyjqCW0OyTDjJYu6fIiJmQwrvkxFIZVF4CvRCzSI+CNE3otK8
16IiqalWvca87dH0o464xhsNqS1vR+nQT0k9Q/QYoc9oQ8a1ZZIRU9vzjTHf
deB7E34046eO/GzBL5b8asVv1qywYbUd6+zZ2JnNjmxzYoczu13Y68oBNw65
c8SD456c9OK0N2d9OO/LRT8u+XM1gOuB3AzitoLxXigPwqgO51EETyJ5JjBG
8SKaVzGoGH5VG4fA+Caetwm8S6BOSDBJ6q/V+2QVS8Hvfar0+VQhxTTBOFVq
solnopqkiBSis+Zdh39C0DPiY59O+Xj4WKpDuQ59dOmvS6UeQ/UZacCYtow3
YnJ7phnzrQmzTJljxtyOzLdgoSWLO7HUmuU2rLRjjT3rHdjkyBYntjuz05U9
XdjnxgF3Dntw1IsT3pzy4Ywv5/y44E9VAJcDuRrE9WBuhnA7lHth3A/nYYTE
9ziSp1E8j+ZFDC+FvbEIdFoCHF8JdG8TZXmXRF0S9clIvaWoWCl2pyGKyCXp
KBDFdllSJEHh929jeRre4o7Np9nJObMyRw5qug6vkl5a0wVmHbrq0F2XnrpU
6DFAj8H6DDNglCFjjZjQjinGTO/ATFNmm/GDOfMsWGDJok4ssWaZLcvtWGXP
Wgc2OLLZia0ubHdlVxf2uLHfnYOeHPbimDcnfDjty1k/zvtzMYBLgVwJ4low
N0K4FcqdMO6F8yCC6kgeRfEkmmcx1MTwIpZXcdTG8yYBNbUkSe1dMnWipFCf
SoOEJnEpVqfzPkN6doYgkamstSTFNpKiIkLh+yIgtLif85c/pvdBeU30pOPq
UKhLNz166NFLj776DNRniAHDDRndlnHtmNSeqR34xoTvzPi+Iz9a8JMlP3fi
F2t+tWWZHSvsWe3AOkc2OLPZhW2u7OjCbjf2erDfk0NeHPHmuA8n/Tjtz9kA
zgdSFcTlYK6GcD2Um2HcDuduBPcjeRhFdRSPo3kaw7NYauJ4Gc/reGoVbloC
HK3fKdBkSRXjRMGsTYMApjATRf6+REtQa/0+iy/eZwuqWUpdVDJQyzBZer0I
DZrq+zQ/ea1LucYQENHiDqvMxjoU6VKiR5kevfXpZ8AgA4YaMrItY4wY357J
xkwz4VszvuvIHAvmWjK/Ewut+cWWX+34zZ6VDqxxZJ0zG13Y4so2N3a6s9uD
fZ4c8OKQN0d9Oe7HKX/OBHAukAtBVAVzOYSroVwP42Y4tyO4F8mDKB5G8yiG
J8K34ngex4t4XgmpJPImSYrubTJvU3inkKtLQ7CrT5dRLkNFSKKSZmdJ7WUL
YDliU654L9fZkmAWop9ErTiyiAh/kqDmfbQM1bUaHYp1KdWlXI8++vQ3oNKQ
YW0ZacTYdkwwZrIJ00yZ0ZFZFsyxZG4nFliz0JbFdiy1Z7kDKx1Z48x6Fza5
stWN7e7s8mCPJ/u8OejDYV+O+XHCn1MBnA3ifDAXQ7gUypUwroVzI4JbkdyJ
4l40D2KojuFxLE/ieBZPTQIvE3mVSK3CTsyKU6T+UnmXJvnVpQv9ZciUK6Bk
0chNZXkOoij8vn4vFaniKHw4W2GoaFFI+s8SDNK4/5HZFP50lfCnR4U+AwwY
bMhwI0a1Y6wxE02YYsr0jswwZ7YlP3RinjULbFlkx5LOLHNguSOrnFnrwgZX
Nrux1Z0dHuzyYq83+3046MsRP475czKQ00GcDeZCCFWhXA7jajjXI7gZye0o
7kZzP4aHsTyK43E8TxN4nkBNIi+TeJ3MmxRFegq6d+kSXV0GdZnUi5JFg6CX
jYqQRCYNz5X1PCG6fOHLBWJzvlIXG3JlZwk8Q4bOmvgWv2tXMdT8/Z9k+NdG
FcZ87MRy9KJDNx166CpB0ICBhgw2Yng7RhszrgMTTZnakW/MmWnJbCt+tOYn
W36245fO/OrAMkdWOLPahXWubHBjszvbPNnpxW5v9vpwwJdD/hwN4HggJ4M4
E8y5EC6EUhXG5XCuRnA9kptR3InmXgwPYqmO41E8TxJ4lsjzJF4k8yqZ2hTe
KPTQqpMZVYVPlizqs2kQRZGcVJoAlqcwzEeUVoLeX94XipYCxNBQbMtDMsxR
GKZTm8yfJeijQVB921KHEl0lDBrQ15CBRgxpxwhjxnRgvCmTzJhqzreWfGfF
99b8aMNPdizszGIHfnXkN2dWurCmC+vc2OjOFk+2e7HTmz0+7PPjgD+HAzga
yPEgTgVzJpTzYVwM51IEVyK5FsWNaG7FcCeWe3E8iKc6gceJPE3kWRI1ybxM
4XUqtcLh0jSVJzxYemx9Dg25siga0xKQVL+xL0CAE6XN+yLxKhZgiyRDsa2A
DySzlPPyJxlq3inJUgVCHUpFKjGgtyH9jBjUjqHGjOjAGFMmmDHZnGkWfGvF
d9bMsWGuHfPtWejAYkeWOrPchZWurHFjvTubPNnixXZvdvmwx499/hwM4HAg
R4M4EcypUM6GcT6cixFciuRKFNeiuRHDrVjuxHEvngcJVCfyOImnyTxPoUYE
+1Rep/Emnbct6H0h6NXnytKQR4OiOUVrrQQnaXiRpFokqsWCSVfxvlh6cREf
MIrPZ7SIhF//Ey8O/zgSZuuQryvDYKk+5Yb0aUv/dgwyZmgHRpoy1owJ5kyx
YLoVMzoxy4Y5dsyzZ4EDixxZ4sxSF5a7ssqNte6s92CTF1u92e7DLj/2+LM/
gIOBHAniWAgnQjkdxtlwzkdQFcnlKK5Gcz2Gm7HcjuNuPPcTeJjIoySeJPM0
heepvEjjVRqv03mTwbtm5FqryDUo5LQEOpFLGiWnMFNZXoxEpiXYtX7fTeiw
RLy6SR12lQ0fMGbzNr2lDj/NUd77/Fvj3Fh9u1OHdF2ydSnQo6s+3Q3o2ZYK
I/q3p7IDw0wYZcZYcyZaMMWK6Z2YacNsW36wZ15nFjiyyJklLixzZYUbq9xZ
68EGLzZ5s9WHHX7s9mdvAPsDORTMkRCOhXIyjNPhnI3gQhRV0VyO4Wos1+O4
Gc/tBO4mcj+Jh8k8SuFJCs9EoE/jRTqvMqjN5G0m75S4JwBq1cuIV69IT5YC
QbJQoacoTfFjAaqbLK0Fu6/fl4qWEslPbFMhLFIQ5sqd/gl+/6LoMEqHeB2S
dUnXI0ePAn26GdDDkJ5GVLRjgDGDTRhuyqiOjLNgoiVTO/GNDTNtmW3PD52Z
58gCJ35x4VdXlrmxwp3VHqz1YoM3m33Y5scOf3YHsDeQA8EcCuFIKMfDOBnO
mQjORXEhmqoYLsdyNY4b8dxK4E4i95J4kEx1Co9TeZLGszRq0nmZwatMarN4
m01dDirpCXoip7apV7gJbLIo/lqs6E0RnDS6BFFaC3Kt33cXntxDWWuJuvDk
EtQgFYpiv58mqPlXBzqNCnSXniwg6pKiR4Y+OfoUGtDNkB5t6dWOvu0Z2IHB
pgw3Y7Q54yyZ1Imp1nxjy0w7ZnfmRwd+cuJnF35x5Vc3fnNnhQervVjnzUYf
NvuxzZ+dAewOYl8wB0I4HMrRMI6HcyqSM1Gci+ZiDJdiuRLHtXhuJHArkTtJ
3EvmQQrVqTxO42k6zzOoyeRlJq+zeCM8LYe6XBW91mp6CkAtia9VQ7ECpKsk
2U1GwhKFYql8212w6yH0VCbaekgs3RENspQoHyqUvvwnGP612RUugTFBwZip
T64BhYaUtKXMiN4CozEDTRhixnBzRlsw3opJ1ky15Vs7vuvM9w786MRPzvzs
yi9d+NWd3zxY6cUab9b5sNGPLf5sC2BnEHuC2RfCwVAOh3E0ghORnIriTDTn
Y7gYy6U4rsRzLYEbidxK4m4y91N4mMqjNJ6k8zSD55m8yOJVNq9zeJPDu1zq
FM/VEvhorZKfLEJ/DV0lrm6oxKdSm+LNAlgPFA2WiYxSLlrKJBqxrXsjRyUs
Pk9v+Zd8v89RdR+56e5KjIIytRFlkYKyvB29jenXgYGmDOnICAtGWzG+E5Nt
mGbHt/Z858D3jvzozE8uLOzCYneWerDck5XerPFhvS8b/dkSwPZAdgWzJ4T9
oRwM43AExyI5EcWpaM7GcD6Wi3FcSuBqIteTuJnM7RTupnI/jYfpPMrgSQbP
MnmexYtsXuVQm8ubPN7l0+TGigq/EBAFQ1m60aBA1FJiX3c1RwGsTJZWgmHr
9z3FupfILD1lsCtXN8k+pYp/F8mT9vk0v268txLZ7N5KogI0S588BWipEeXt
6dOBfqYMMmOIOSMsGdOJ8TZMtmWaPd86MMuROc7MdWF+Fxa6sdiDpZ4s92aV
D2t8We/PpgC2BLI9mF0h7AllfxgHIzgcybEoTkRzKoazsZyPoyqBy4lcTeJ6
MjdTuJ3K3TTup/Mwg0eZPMniWRbPs3mRw6tcavN4m887Ecw+REQBkzZNLGUp
RWGpeLGUogQguJULjiqWX7/vLadyvRB1WcqbEe0qv6GFl3/1SZ7ajTz9Ij7m
Ke/96ZCmqyA1pKgtpe0oN6aPCf3MGGTOUAtGWDHGmgm2TLZnemdmODLLiTku
zO3CfDcWerDYk6XeLPdhlS9r/FgfwKZAtgaxPYRdoewNY38EByM5EsWxaE7E
cDqWs3GcT6AqkctJXE3mego3U7mdxt107mfwMJNHWTzJ5lkONTm8yOVVHrX5
vC2grpD6Rv+W7q0laAqvV2DKoqKppcTGcrVKBbhesrQSNP/yvo9o6S0RNVEt
U9y+RO77z/L0buLZdONPDILShEQNyGtLcTtKjSk3oY8p/TsyyIKhVoy0ZowN
E+yY0pnpjsxwYpYLc1yZ68Z8dxZ6stiLpT4s92WVH2sDWB/IpiC2hrA9lF1h
7I1gfyQHozgSzbEYTsZyOo6zCVxIpCqJy8lcTeF6KjfTuJ3O3QzuZ/Iwi0fZ
PMnhWS41ebzM51U+tQW8LaSuiHp1pPyyuTAFyAYlRKpiYxspPRWtXsoVMsmy
lWD51/cVokcfmcV7o0aq8BR7/TRLzXuCTb7uHf7xTWkxJkrSJU2fLEPyjShu
T2kHyk2p6Eh/cyotGdqJkTaMtWOCPVMcmO7EDGdmuTKnC3Pdme/BQi+WeLPM
l+V+rPJnbSAbgtgUzNZQdoSxK5y9keyP4lA0R2I4FsvJOE4ncDaRC0lUJXM5
haupXE/jZjq3M7ibyYMsqrN5nMOTXJ7lUZPPywJeF1JbyNsi6hRJKor86gNF
BWSDKhbKTNNTvHpJf++t+HsfRGklKLZ+31ew6Sda+4pXhQQl2lRQFb8X+/2T
RD+6Mx2rDJCS9EgzILst+e0oNqbUhHIzKswZYEmlFcOsGWnLWHsmdGaKI9Od
meHCrC7McWOeBws8WeTNEh+W+bHCn1WBrA1iQzCbQtkaxo5wdkWwN4oD0RyK
4Ugsx+M4mcDpRM4lcSGZqhQup3I1jRvp3MrgTib3sniQTXUOj3N5msezfGoK
eFnI6yJqi3lbTF1jtBRUS2X0VMFUeDaU00RT8ejWgpeEUIEorQTFVoLml+/7
K2tJVai44gNRudfP5/mXZt4uxkhxuiTokaxPuiHZRuS3p7gDpab07EiFBQOs
qLRmmA0j7RjbmQkOTHFiugszuzDbjR88mOfJAi8W+bDEl2X+rAhgdRBrg9kQ
wuYwtoazI4LdUeyN5kAMh2I5EsfxBE4mcjqJc8lcSOFSKlfSuJbOjQxuZXIn
i3vZPMihOpfHeTzN53kBNYW8LOJ1MW9EruhGXTe1b2sJjIJlI0VZevKBYxup
OwWiRNAXhV8rwfHr9wNEj/7i1U/26osaZ08p8j/LUl4BEhOfGF3i9Ug0INmQ
9LZktyPfmGITupvR05wKSwZ0otKGYbaMtGesAxOcmOLMdFdmujHbnR88mefF
Ah8W+bLEn2UBrAhidTBrQ9gQxuZwtkawI5Ld0eyN4UAsh+I4msDxRE4mcSaZ
cylcSKUqjSvpXMvgRia3sriTw71cHuRRnc/jAp4W8LyQmiJeFvO6K2+68U6k
ilLqG4Ok4Fkmc5CCsUGJkJKjEhUVxfWVRSLoh8KxleD49fuByloA6o9okJ36
yI+Kff1pkrpE6xGrT7wBSYaktCXdiOz25HegqyndO9LTggorBlhTacswe0Z2
ZqwjE5yZ4sL0Lsx0Z7YHP3gxz5sFvizyY0kAywJZEczqENaGsiGczRFsjWRH
FLtj2BvLgTgOxXMkkeNJnEzmdArnUrmQRlU6VzK5lsWNbG7lcCeXe3k8yKe6
gMeFPBUD6iJqinnZldfdeFPCu1LqRKpoDJGCpMzZEqMA0ZtGiq2aKKq0p1AQ
2AbIutTkQJGHBilrgWkAzZGKPf7JqOkbpkO4DlEK0gRDktuSakR6O7KNKTCh
qxndzelpSUUnBthQacewzox0YKwTE1yY4sp0N2Z6MNuTH7yZ58MCPxb5sySQ
ZUGsCGF1KGvD2BDB5ki2RrEjht2x7I3jQDyHEjiSxPFkTqZwOpVzaVxIpyqD
K1lcy+ZGDrdyuZPHvXweFFBdyOMinhbxvJiarrzsxusS3pTyrjt1PahvdG4t
6dqtVTgblFyj5BaZbCSifpKVliqhC24DZRFvB4m4WSl7DUasVUVLbBXQBvIB
cIWUu+ZVty9/l668e91KwMU7Uo8YIVdDkgTbdmS0J7sD+aYUd6S7BT2tqLBm
gC2V9gxzYKQjY52Z4MoUN6a7M9OT2d784MM8Xxb4syiAJUEsC2ZFKKvDWBvO
hkg2R7E1mh2x7IpjbzwHEjiUxJFkjqdwMpXTaZxL50IGVVlcyeZaDjdyuZXH
nXzuFfCgkOoiHhfztJjnXanpxssSXpfypjvvelBXRn2ZOmRqCawijipgG5SA
2ajQVs2Iqu4nDhLVShEOBov1EAWsglhs/0C0r5T97/Bso7FVV81TS/L0CdMl
Qo9ofeIMSWxLikBqTLYJ+WYUm1NqSXkn+tjQ347KzgxzZKQzY12Y0IUp7kz3
YKYXs334wZd5fiwIYFEgS4JZFsKKMFaHszaCDVFsjmZrDDvi2BXP3gQOJHIo
mSMpHE/lZBqn0zmXwYVMqrK5nMO1XG7kcSufOwXcK+RBEdXFPO7K024860ZN
CS9Led2dNz14W0ZdOfWiKE4vmPaWVz9UQPuqBvBaqjg5UKGlFMmhUpAcLEhK
mkOVtUCl0msT1H5S9n+C6JeNCvUQRMP1iNIn1pAEQbQ9GR3INiW/I8UWlFpR
bk0fW/rbU+nAMCdGuTDWlQluTPFguiczvBWifszzZ0Egi4JYEsKyUFaEszqC
tZFsiGZTDFtj2RHPrgT2JnIgiUMpHEnleBon0zmdwblMLmRRlcPlXK7lcSOf
WwXcKeReEQ+Kqe7K4248LeFZCTWlvOzO6x68KeOtHBfVSa+vb/R6URRFtlb5
uyQzoDFaDvrg4ZLFYLF9iGAjiQ5TyApcQ/gIbH+5wz9JVeq0lYCKW6SKqREp
xmSYkG1GvjnFlpR2otyGPnb070ylI8OcGenK2C5McGeyJ9O9mOHDLF9+8Gde
AAuCWBTM4lCWhrE8glWRrI1iQwybYtkax44EdiWyN4n9yRxK5Ugax9M5mcHp
TM5lcSGbqlwu53E1nxsF3CrkThH3innQlepuPC7haSnPSqnpzssevC7jTTlv
5fiorpe8U6GM2lX/GoTD9lNGRM2jpzpOVirMVGWI8pvyJqbDlbUANpSP0A6Q
ov9/4KolubqH6RFpQGxbEtqR0oEMU7I7km9BsRWl1pTb0see/g5UOjHMhZFd
GOPGBA8FrTczfJnlx5wA5gYyP5iFISwOY2k4yyNZFcXaaDbEsimOrfHsSGRX
EnuT2Z/CoTSOpHMsg5OZnM7ibDYXcqjK43I+Vwu4XsjNIu4Uc68rD7pRXcLj
Up5051l3anrwsozX5dT25G0vlTbb1Its0hcV04b+qswuuDZ6vajLHKTSp5bU
pUJjGBKliukIZS2AiY1DlaJCO0Du9f8lCrgKsGH6RBgSY0RCewWrGdnm5FtS
3IlSG8rt6NOZ/o4McmaoKyPdGOPOBE8mezHNhxl+zPJnTiBzg5gfwsJQFoez
NILlUayKZm0MG+LYFM/WBLYnsSuZvSnsT+VQOkcyOJbJySxOZ3M2h/O5VOVz
uYCrhVwv4mYxt7tytxv3S3hYyqPuCtYe1JSp4iVfvetDnSgV1Pelvp+aaKPP
t2ry+Y94akmQrQRACWM4ap4jlbWANZwPWCul0Os+m6leM63iJHQabkB4W6Lb
EW9MsgnpHcm2IN+KYmtKbSmzp7cD/ZwY5MLQLgpTD8Z7Mdmbab5868+sAOYE
MTeY+aEsDGNxBEsjWR7NqhjWxrI+nk0JbElUmKawJ5X9aRwUTDM5lsWJbE7n
cDaX83mNTIu4XszNrtzuxt0S7pfysDuPeqhU+bcXPXnVi9revO3DuwqJtE5B
Wt9fIm1QvF5LGXtWoiQk6dFDaCKqJcBpSYIKj5GIIuojxWuU4DRS1fbFB7qD
pdbfVrT4ZZYynmrxtCZ9NVkcBVqZsvQJNyTCiMj2xHYgyZQ0c7IsyetEkQ0l
dpR1prcj/ZwZ5MqQLoxwZ4wn472Z5MM0P74N4LtA5gQzN4T5YSwMZ3EkS6P4
LZqVsayJY30CmxLZksT2ZHamsieNfekczOBwFseyOZHDqVzO5nE+n4sFXCrk
ysdsVUz/8aSMp+U878mLXrzqTW0f3lQocPtSp5CtHyDJNgz8yO+VgZNKgB+R
lTRVTEYhiphZjVJt+0I0qsEOkXt6/aep2suZgCLXiLZEtCPSmBgTEsxIsSDT
ilxrimwpsafMgV5O9HVhYBeGuDHCg9FejPdhki/T/Pk2kO+C+D6EuaHMD+fn
CH6J4tdofothZRxr4iXVjUlsSWZbCjvT2JPOvgwOZkqqR3M4kcupPM7kc76A
i4VcKuJKMde6qlj+/X53HvaguozH5TztyfNevOjNqz7S2Dd9eduMqJbgKWYC
Tfle5fnItKSOos2JtpIoFSajEUXMmUYrmhXIhIhHqOXaUMmLP03VWlJVoqpK
qJEdiDYlvqOkmtGJXBsK7ejWmR6O9HKmr6tC1Z3hnoz2Zrwvk/yYGsA3gmow
34fyYxg/RfBzpEI1ht9iWRnP6gTWJbIxmc0pbEuVVHdnsC+TA1kczuZoLsfz
OJXPmQLOFapi5n/cKOFWKXe6c68HD8qoLudxT5724nlvavrwsoLXfRWk/Xin
8KwfKBWq4qnos3WTPjXUKVm2khAVGmMQRTAaI9rUTGWYlUodSn1li2dI/D5N
5a9PrFSeH9bM8yNNiDIj3pxkS9I7kWNDgT3dHOjhRC8XKlwZ4MZgD4Z7MdqH
cb5M9GdqIN8EMTOE2QJouAI0ikXRLIllWRwrBNBE1iWxMYXNqWxLY0c6uzPZ
l8WBbA7lKEDzVYr87wvFXOrKlW5cK+FGKbe6c6cH98p4UE51Tx734mlvnvWh
poKXfXndj9p+vO3PuwHUDaR+kATaoM5MLYkKjCNoiqIqqq0lToXMWEQRUXWs
aFPRVZFV1PruT5M1l2T1Gsm2I8JYko02I86CJCvSrcm2lWS7OtDdmZ6CbBcG
uDPYk2HejPJlnB8TA5gSyPRgZoYyO4wfIpgXyYJoFsWwJI5l8axIYHUS65LZ
IMimsTWdHRnszmJvNgdy1PFS+2Qhp4s4V8yFrlR143IJV0u53p1bPbhTxr1y
HvSkuhePevOkD88qqOnLy34K2v68GcA7kasHKWgraVB7fesmr2+mUy0lco4W
VMeI11hJe5wyGhgnPzBOtKnICsSjZahVxdc3g1o+B/TTZOVfoKmen9ek2TAD
wtoSrsCNMiWmI3GWJHUizYYsO/I7U+yowHWlwo3+HlR6SbgjfRnrz4RApgQx
PYQZocwK54dI5kWxIIZFsRLu0gSWJ7IqmbUpbEhlUzpbM9iRqWaqdyiPI/kc
K0DCLeZsVy50o6qEy6Vc7c71Htws43Y5d3tyvxcPe/OoD08qeNaX5/140Y9X
/akdwJuBvB1EXaV024bBTXlfGd5Lfx6OBlktNVlJU0VmPKKI7eMV2FoqAY9R
6I6kfhivf5eu5l+pGTbS7dCk2zDDRrodFLrmkm6iNam2ZNmT50CxE6UulHeh
jzv9PRnkxVAfRvoxJoAJQUwOZlooM8KYFcGcSOZGMz+GhXEsjmdpIsuTFLqp
rE9TMTXYlc2eHPbncTCfwwUcK+REEacUuOdLuFjKpe5c6cG1Mm6Wc7snd3tx
vzcP+1BdweO+PFXB7c+rAbweSK0YB1VKt60fTMMfklXCgDquSrqSZGuJtRnh
VmKhJanL8CD7jpaA64a1/MvdNn9M1+gjukaEqxKYGbHmxFup6WZ2Js+RImdK
XClzo7cH/QRdb4b4MsKf0YGMF3RDJN1vw/kuku+jmBvD/FgWxrM4gV8TVTnJ
aGMGWzLZls3OHPbksk+gLeBwIUeLOFHMqa6c6cY5gbY7l3pwpYxr5dzoya1e
3OnNvT48qGhE249n/akZwMuBUlG1lbwRaAdTN4QG9ci/tYqpKr4216vK68cp
BNu8n6C+pzoBVZFbxeZxMvSKDzSM5O2fZ2rwIR4oig1rT4QSaWMtSLAiyYYU
O8k015FCZ7q50sONXh709WKgD4P9GK4wHRfMpFCmhvFNhMI0mh9j+ClO7fGm
v6WwIpXVaazLYGMmm7Mk1x257M5jXz4HCjhUxNFijnflZDfOlHCulAvdqerB
5TKufsz1fgUP+/KoH0/682wANQN5MYhXlQrXwbwdQt1Q6bsNTdFVlYeU8Wkz
qiqPl54/QRCaqNbrRIlVbJ8gBwlCvCq0Y6gfyZthn0lWPg1bq3HGpfMh1BoR
ZkyYCZEdibEgrhOJAq09GQ7kOFHgQtcudHenpycV3gzwlWiHBTAqiHEhTAxj
ajjfRDIzSk2044IEFiWxJJllAm0aq9NZm8GGLDZnszWHHXnsymdvAQcKJdoj
XTnWjZMlnC7lbHcu9KCqjMvlXO3J9V7c7M3tPtyt4H5fHvbjUX+eDODpQJ4P
4kUlLyt5PZjaIbwdyrthCloNrqPRUGtzrlrvJ8k/xZ+IGq9CuAltwxjejeTV
0M9V7Uds/0ey1WvG1pRwc6IsibUm3pZke9IdyXYm35ViN0o9KPeiwof+vlT6
MyyQkcGMDWFCmIqo5awY5sQxL54FiRLt4hSWprI8jVUZrM1kQzabctiay3aB
toA9hewv4mCxGu2JUk5352wPzpdxsZxLPbnSi2u9udmH2xXc7cu9fjzoT/UA
Hg/k6SCJtkagHczrIdQOldoSaOuGUz8C9ZyqCawq68vQKpGNo4luK8HyK0n3
q5Zo68fwdkSL5zD9PlPlSYT/qY4EHyMNMyfCimhr4mxJ6kyaI1nO5LlS5EaJ
B2Ve9BFI/RgUoL7+YTs5gmlRfBvDd7HMiWduAvOTWJisAE3jt3RWZrImi/UC
aC5b8tiez04BtIh9xRzsyuFuHC2RQE9150wZ58u52JNLvbjSm2t9uFHBrb7c
6ce9/jwYQPVAHg3kySCeVVIzmBdDpJZqh0mgb4dTN0I6boOiUmVEKgdX6pGq
lmpgNZ6maKolALYWPL94P1lOZCcpip30AWvDOOrGUDui5VPWPs3VSK1V/u0D
VxFh2xHWgTAzyTXciigb4uwk11QnMl3I7UKhO908KfNWqbLzkCCGhzA6jHHh
TIpkarRCNo7v4/kxkZ+S+DmFX1L5NZ3fMiTZ1dmsy2FjLpvz2VbAjkJ2K2QP
dONQCUdLOd6dkz04Xca5ci70pKoXl3tztYLrfbnZj9v9uNuf+wN4KMgO4kkl
TwfzfAgvhvJSDIgE2eFSWcJpJdlRfJprqyauikpbCYytBVWt91OUNV82R1s3
jnejeTzk97hqPj+6XaNe/67m2hyqBWGdiLQh1o5EBwk1w4UcNxVLl16+VPgz
IJDBwQwLZVQYYyOYGMWUaL6JZWYcsxP4IZF5ySxIZVEaS9JZlsmKLAl1bS4b
8iTUrQJqEbuK2duV/d04WMKR7hzrwYkyTpdztifne3GxN5f6cKWCa3250Y9b
/bkzgHsDeTCI6koeD+bJEJ4NpUaB+mq4FNWbkRJq3SjqFa9XR1MlTTWNU1Ua
1VLT/ErQ5EvxRi3VidSP591Y3oxu+cTNT5Ns36jQv36SZHgnImyJtide/ZhG
3PI9KPai1IdyP/oE0D+IyhCGhjIynDGRTIhicgzT45gRz6xE5iQxN0VBmc7i
DJZmsjybVTmsyWV9PpsK2FLI9iJ2dmVPN/aVcLCUw905KlCWc6onZ3pxrjcX
+lBVwZW+XOvHjf7cGsDtgdwdxP1KHg7m0RCJ8ulQng/jxXBejuD1SGrFOGiU
1JSIgg1jmlSppYxCPzDUEuj+KhjKtQCkQKwbz9uxPBvR8qmurX+XoKLFLz7g
MyGso8SnREOvRGfSXMlyI8+TIm9KfCnzo3cA/YIYJNCFMSKC0ZGMj2ZSLNPi
+DaB7xL5PpkfU/gpjZ/T+SWTX7P4LZuVuazOY10+GwvZXMS2YnZ0ZXcJ+0o5
0J1DPThSxvFyTvbkdC/O9uFCBVV9udyPq/25PoCbA7k9SKK7V8mDwVQP4fFQ
ngzj2XBqRkh0rwS6UVI+Ap2IdA1jZchrzDhKylFlGYVeK0GtlaD31fupil8L
gooS65VM/0Yw13w+2z8h2KqJoEprvhHCkW2J6ky0IwnOpHQhw50cTwq96eZL
D396BdI3mIGhDA5juKAYxbgYJsYyNZ5vEpiZxOxkfkhlXhoLMliUyZJsluWw
QlDMZ20BGxSKW7uyoxu7Sthbyv4eHCzjSDnHenKiF6d7S4rnK7jYl0v9uNKf
awO4MZBbg7hTyb3BPBjCw6E8GsaT4TwdzvMRvBjJy1G8Hk3taN6Okd4oolu9
0F5DS4JaaoJfC4J81TAVsRZVsbV+EnUKxmejP5OisdqTFXJBKgmGWxJh/QFh
nAtJXUhzJ9uTfG+K/egeQHkgfYLpH0plOMMiGRXF2BgmxDElnumJzEhiVgpz
UpmbzvwMFmaxOJuluSzPY1U+awpZX8SmYrZ0ZXsJO0vZ0519CsLDPTnai+O9
OdWHMxWc68uFflT15/IArg7k+iBuVnJ7MHeHcH8oD4ZRPYzHw3kygmcjqRnF
i1G8Gs3rMQgZCXd8JxLveBnc6uXYvGHiR/RaCWpfvJ8mn280jSaIDZN5N4m3
E3mlXET5M1qU3aOkFg0ag6HwZkvCrWUwlCidiHEhwY1UDzK9yPWhyI+SAMqC
6B1CvzAGRTA0khHRjIllfByTEpiWyLfJfJfK92n8mM5PmfycxS85/JrLb/ms
LGB1IeuK2diVzd3YVsKOUnb3YG8ZB8o51JMjvTjWm5N9ON2Xs/0435+LA7g0
kCuDuFbJjcHcGsKdIdxTUD4czqMRPBnJ01E8H0XNaF6O4dVYakViGMdbkSHG
UzdB6kt4qhBawyQJS4ZALTVNLUFTS8BsJdatxFpx8YYp1E3m7STeTODJGPn8
ibyW/5uaiqoyEFJtVMZAql8RiEqIfHCZjibYMGvC7YjoTJQCNt6NZA/Svcjx
ocCPbgH0CKJXCH3DGBDB4CiGRzMqlnHxTExgShLfpDAzldnp/JDBvCwWZLMo
hyV5LMtnRQGrilhbzIaubCphaynbu7OrB3vK2NeTg7043JujfThRwam+nOnH
uf5cGEDVQC4P4mol1wdzcwi3h3J3GPeG82AE1SN5PJInoxB++XwML8bwciyv
x1E7njcicUh1vhPO3aZukiRbP1mSFeAUqpKmgrNhuiyC8nSpWVGZ1limUjeF
t5N5M4ma8S3Hk5ozpJa0Dd43e/JP+AfaRs1GR9aE2RHuQGQj7SQP0rzI8iXf
n+JASoPpGUqfcPpHUBnF0BhGxjEmngmJTE5iWgoz0piVzpxM5mYxP4eFuSzO
Y2kBvxWysog1XVnfjY0lbCllWw92lrG7nL09OdCLQ705UsHxvpzsx+n+nB3A
+YFcHMSlSq4M5toQbgzl1jDuDOPucO6P4OFIHo3i8WiejuHZGGrG8mIcr8bz
ejy1E3gzUbq3EKTwcy0hTVrXT6F+qjoESNpfCbhSx+J8TOXtFGon83Ii1WNb
XhvVfPpZS7K6arLKX4UGS7L6jTOkxkGnwBrmQIQT0a7EuZHoQao3mb7k+lMY
SEkwZaH0DqdvJAOjGBLD8DhGJzAukUnJTE3l2zS+y+D7TH7M5qccfs7ll3yW
FLCsiBXFrO7K2m5sKGVTd7b2YHsZu3qypxf7e3OwD4crONqXE/041Z8zAzg3
kAuDqKrk8mCuDuH6UG4O49Zw7ozg3kgejOLhKB6JEfcYno7l+ThqxvFyPK8m
8HoCtSK6Cv3RSujwnShT5G8vpkq6U6VGBVah2zZSwK0avmnSsly0qZvG26nU
TuHVJJ6Mb3kn+pP/U+NHlP9XTfnvKsq6yuUo1SRUhdhWIg53IqoRcYo36b5k
+1MQSNdguofSM5yKSAZEUxnLsDhGJTA2iYnJTEllejozMpiVxZxs5uYwP4+F
+SwuZGkRy4tZ2Y01JawvZWN3tpSxrZydPdndi729OVDBob4c6cex/pwcwOmB
nB3E+UouDubSEK4M5dowrg/n5ghuj+DuSO6P4sFoqsfwaCxPxvJ0HM/HUzOB
lxN4NZHXk6gVmn0jNPuFkKVA/G6qLIJf/TRaKyzrBdtvEMs6ZYlWvdj6hejx
Zhq1U3k1hacTuT+uxS/9NJXckvF/qiPyvzZFZAN5yU810Vcz7iwZR7gS7Uac
J0nepPmSFUBeEEUhlIRRFk7vSPpFMyiWIfGMSGRMEuNTmJTKtHS+zeC7LL7P
5sdcfsrj5wJ+KeTXYpb938bOA0au47zjP5OSHMcIEsQBHBhwYLnEim3ZkeMi
y2qkKFE0tVd4vN57L7t3u3vbe++7x95777333nvvvYiiRNGKAxjIm3dLinpH
F2Bud2ffd7Mzv/nPN/PmzXvTzKIWlrayop1VHaxVs17Dpi62aNmmY6ee3d3s
NbDfyCETR8wcs3LCxikbZ+ycc3DByUUXl91c9XDdyw0ft/zc9osGfT8oBPcg
xMMwn0Z4FBUSfBwTLV7iLI3wJV1KrJP8Kcn/pUSQcEp8+wu0//inJ5Sl8KcU
f0zyWCKc4JMot0N97hxVXg/oS/hf0yqW9a4SZ/3fl08KJLw//wrerLcY9i55
AykaRNlgqodQP5RmFe2ZdGajz8E0HFsezgK8RQSKiZQSLyNVwchKxlYzoYbJ
dUyrZ0Yjs5uY18zCVpa0saydlWpWa1jXyYYuNmvZqmN7N7sM7DGyz8QBM4cs
HLVy3MZJO6cdnHVyzsUFN5c8XPFy1ct1Hzf93ApwJ8jdIPdDfBwWmnsY4dMo
n8X4PMbjuGjtkhy/SAjOSfGU2JRAKAWJaD9B95vSBwnw/8qvvZ//mOLzJI8S
PIxzJ9L3uV/KK9pPCH/5zZNnBX6nV8Pfk53ET2S8rz3B+4bAm/UuOQPJf5+S
wVQMoXYojSpaM1Fno83BmIslD0cB7iL8xYRKiZaTrGBEFaOrGVfLxDqmNDC9
kVlNzG1hQSuL2ljawXI1qzSs6WS9lo06tujZ1s0OA7uM7DWx38xBC4etHLVx
3M5JB6ednHVx3s1FD5e8XPFxzc/1ADcD3A5yJ8TdMPelcVWEB1EeSr1/jM/i
PIoLFT4WbCVN9v9C+IWnHHtRStR7xNOcevhC5vooxWdJPolzN8qlQJ8noCpX
DPUl++TZgd8VkY+EB/6B7Bpelcn+CtVvyXiDTJls9kBy36dwMGVDqBpKvYrm
TNqz6cpBn4spH1sBziK8JQRKiZQTryRVxcgaxtYyoZ7JDUxrZEYzs1uY18rC
dhZ3sEzNik5Wd7FWywYdm/Rs6Wa7kZ0mdpvZa2G/lUM2jtg55uCEk1MuTrs5
6+G8l4teLvu44udagBtBboZE870T5m6E+xE+jvIgxicxobpPE3yW4FFS6LD/
Y9GXPZbwyRAlXyF8whdP4tLr5z2C66dJPk5wN8aV8N/cuaQv12+kub7c6xO+
Jw/IfpoejUlQVW+Q8RaZ75A1kJxB5A+mZAgVQ6lV0ZhJWzbqHLS5GPKxFGIv
wl2Cr4xQOdFKktWMqGF0HePqmdjAlCamNzOrlTltzG9nUQdLNCzvZGUXa7Ss
07Oxm80GthrZYWKXmT0W9lk5YOOQnSMOjjk54eKUmzMeznk57+Oin8sBrgS4
FuRGiJthbkdEw5U0di/K/RgP4kJyDxMy16TgKvH6XIwLJHQCbb/HIySVPpZR
ftbDpykeprif4E6c69E+Oycp7xjoS/PFdB8mznqls90fyoOwn6dHYKrfoXqT
jCco8wZTOISyoVSpqM+kOZv2HDpz0edjKsRajLMEbxmBCiKVxKtJ1TCyjjH1
jG9kUhNTm5nRyuw25nawQM1iDUs7WaFllY61etZ3s9HAFiPbzOywsMvKXhv7
7Rx0cNjJURfH3ZzwcMrDGS/nfJz3czHA5SBXQlwLcT3MTakbj3InKpR1L879
uFDZA6nzSfJQcqj9PhXq/CwlsD3qEc82l2g+EjQFxx4+SfEgxb0kt+JcjXLC
32f3pefuvY3yGxH9Se+o68fyYEv2o6rXUf0e1TtkDmCYhPIDgbJkKBUqajJp
zKY1B3Uu2ny6CzEXYy/BXYavglAl0WoStfTUMaqesY1MaGJyC9NamdnGnA7m
qVmoYUkXy7Ss1LFazzoDG4xsMrHVzHYLO63strHXzn4HB50cdnHUzXEPJ72c
8nHGzzk/5wNcDHI5JJrktTDXI9yIcivG7ZhQ1t049xJCZR8neZAUmCRYLz4U
rfvhCKR3KXzSw8c93E9xJ8nNBFdinA71Iaa8a/qrBMV0gbiHQ9438wPRC/0i
7SgFurfJGEDmIHI+IO9DioZSpqIqk7psmnJoy0WTj64QYzHWUpxleCrwVxGu
JlZLso4RDYxuZFwzE1uY0sr0dmZ1MFfD/E4WdbFUy3IdK7tZY2CdkY0mNpvZ
amG7lZ02dtvZ6+CAk0MuDrs56uG4l5M+Tvs5E+BckPNBLoa4FOZKhKsRrkW5
EeNmTCjpttQ0JV+XFMLqd18o8OOUAPVAKFB66S995qV7PdxJcSvJjQSXJXLh
Pj33c/d45ene3YNFy/1ZelQveUDVW2S8S+Z7ZH9AzofkD6VIRXkm1dnU59CS
S0c+XYV0F2MuxVaGqwJvFcFqIrXE60g1MLKRMc1MaGFyG1PbmdHBbA1zO1nQ
xWItS/Ws6GaVgTVG1pvYaGazla02ttvZ5WCPk30uDrg56OGwl6M+jvs46ed0
gDNBzoU4H+ZCmEsRLkdFW7sW43qcG3EhnFsJbieFiO4Ir3dXOu+8J1Dd7+Ge
HKTvBLE7PdxKcSPJtQQXY5wMP/+Z+c/R2pejS5nce6KV9ursdeHtRBMdSPb7
DPuQnD+Qr6I4k4psanNozKU1H3Uh2mIMpVjKsFfgrsJXTaiWaD2JBnqaGN3M
uFYmtDG5nWlqZmqY3cm8LhbqWKxnWTcrDKwystbMegsbrWy2sc3ODge7nOxx
sc/NAQ8HvRz2cdTP8QAnApwKcibE2bBMLsJFaUwSE23sapxrkudPCBL0uylp
TKLCC7dT3JYkJYd+0ie+fquHmz3cSHEtyeUE5+OciPyFnRr6qkzxrdiXnAFi
LPPaE7m9jWoAGYPIGkz2Hxj+EQUZlGZTmUNdLk35tBfSWYyuFGMZ1gocVXiq
8dcSrifWQLKJEc2MbmVcGxPbmaJmuoaZnczRMl/HQj1LullmZIWJ1WbWWlhv
ZZONLXa2OdjhZJeLPW72edjv5aCPw36OBjgW5ESQUyHRmM5GOBfhfJQLMSGW
S3EuSz5ejAaviZH29STXU4KNFF64IWhd7+FaiqspLie5kOBMjGORvleClPvS
9dISAnvaLgcIdf2PLK23UL2L6j1UH5AxhOyPyM2gKIuyYVTnUp9PSyEdxXSV
oC/DVIGtCmc13loC9UQaiDeRamZkK2PaGN/OJDVTNEzvZJaWOTrm61lkYImR
5SZWmlltYa2VDTY22dniYJuTHS52udnjYa+X/T4O+jkc4EhQUDoeEq3nVIQz
Uc5GORfjfIwLcS4muJQQAOh3JcmLEgz+4WoPVyQoKS4luZjkbIKTMQ6F+8wJ
K0d1vWSUsxiyjn4vOsc3RLNTDUT1PqoPyRjKMBX5WRQPo2I4NXk0FNBSREcJ
XWV0V2Cuwl6NqxZfPcEGIk3Em0m1MrKNMR2MVzNJw9QuZmiZpWOunvkGFhlZ
YmK5mZUWVltZa2O9g01OtrjY5maHh11ednvZ62O/nwMBDgU5HOJoiGNh0VJO
RjkdFTo4K86Dz4mJyPMJIY2Lgo9E44VLEp+vX0xxIcV5mcypOMdi7A/TZ6cT
5blEL52XntXN26LTe1NWzCBUg1H9gayPyMmkIJuS4VTmUVtAYxGtJajL0FZg
qMRSjb0Wdx2+BoJNRJtJtNLTxqgOxqqZoGFyF1O1zNAxS89cA/ONLDKxxMwy
CyutrLax1sF6JxtdbHaz1cN2LzslKj72+NkX4ECQgyEOhTgS5miE49IYKSrq
/5TUYcU5I4WEKPfXz0lIXjqb5HSSkwmOxzkUZVfoyz03/gKFr8kUlHMEvxAv
bwoasovpFUimJJAMcrMoyKE0l8p8agtpKqatFE05ukqM1VhqcdThbsDXSKiZ
aAuJNno6GKVmrIYJXUzSMlXHDD2zDMw1Mt/EIjNLLCyzssLOKgdrnax3sdHN
Zg9bvGzzssPHLj97AuwNsj/EgRAHwxyOcCTC0aio7eMxTsQ5GRcF73dK+pMY
9D8leJxMcjzB0TiHY+yNsCUgzzD/bR7fSKviv59yeCftRCRJZKqEJPKGUTic
0nwqC6krpqmUtnI0leiqMdZgqcPRgLsRfzOhFqJtJNrpUTNKw9hOJmiZpGOq
nhkGZhmZa2K+mYUWllhZZmeFg1VO1rhY52aDh00yh60+tvvZGWBXkD0h9obY
F+ZAhIMRUdFS8Y7EOBoTRT0mhQT9pXL3k9558WiCw3EOxtkXZYfULr6vKLFy
9qKXgJKLrIhfCwyD0s4iK4Nh2eTmUJBHaQGVRdSV0FRGewWdVehqMNZhqcfR
iLsJfwuhNqLtJDro0TCqk7FaxuuYpGeqgRlGZpmYY2a+hYVWFttY6mCFk5Uu
VrtZ62a9h41eNvnY4mdbgO1BdgaFuneH2RNmX4T9UQ5EJZ9wUHIU/Q9J3jEu
Av0OixUGh+TiH4izP84eCUKEDUHka2XKM9y+HJQ+VebwmzSHIWR8RFYmw4Yx
fDgF+ZQWUllMXSlN5bRXoqlGV4uxHksDjiY8LfhbCbUT7SChoaeTUV2M0TFe
z6RuphiZbmKmmdkW5llZYGORnSUOljlZ4WKVmzUe1nlZ72Ojn80BIeZtQbaH
2BFiZ5hdEXZHRPH2SiFG/31ilcq+uPgshd0xdkXZFmFTCH6sKJOy9feW/J+e
9Yy/TBdXRWYWWTkMyyO/gJIiKkuoK6epkrYqNDXo6jA0YGnC0Yy7FV8bwQ4i
auKdpLoYqWWMnnHdTDQw2cg0MzMszLIy18Z8OwsdLHay1MVyNys9rPKyxsc6
H+v9bAywKcjmIFtCbA2zLcz2iKjHl3ZKlf7idrlkW6RqDbEqAP+lKI/y+Tu9
5VOO7eWafU208mfKmZ1HXiHFxVSUUltOYxWt1ahr0dZjaMTSjL0FVxvedgJq
whriXaS0jNAxWs9YAxOMTDIx1cx0KzNtzLYz18F8JwtdLHGz1MNyDyu8rPKx
2s/aAOsCrA8KdW4MiZraHGaLWDK7RVyT2yxVXpgNYdaFWC6V8qd/Vyn/5dla
fFX0aSpUWWQMJzOf4YUUlVBeRk0FDVW01NBRR1cD3U2Ym7G14mzD04FfTaiT
WBcJHT16RnYzxsA4ExPNTLYw1cp0G7PszHEwz8kCFwvdLPawxMsyL8t9rPSL
WlkdYE2QtVKQFPjCOnF5ZV1YRFaHWBlkqR9+/pwSfU2KipL0lkY5TyX751dU
Q0WRVMPJyGdYEQUllJZRVUldNU21tNWjaUDXhLEFSxv2dtxqfBqCnUS0xHUk
9YwwMMrIGBPjzUy0MNnKVBsz7MxyMtvJXBfz3CzwsNDLYi9LfCK3y/z0k6qh
/4qg9C5W4i0LsNjPAh9TnL35Uqy5/2pJvpWul1+K2I9FpQxDlUdWEbklFJVT
XklNNQ21tNTT0UhXM90tmNqwtuNQ49Hg7yKkJaIn3k3KwAgjo0yMtTDeykQb
k+1MsTPNwQwnM13MdjPXwzwpeJnvFZlcKNZlLpTKsECszZzvY46XmR74lSLn
L/bJufKMTy7rj3rjUh2oCsgqJq+M4goqq6mtpbGe1kbUzWhbMLRh7sCmxqnB
04VPS1BPpJuYgaSRHhMjzYy2MNbKeBsT7UxyCJxTXUxzMd3NDLfI5Cxx/470
3m+GWGc62cV4p7yfxG8UOXuhT96VZ15ym3/5aby3BBlSCUrJLae4iooaautp
bKC1CXULXW10t2NWY9Pg6MKtxacjoCdkIGokbiJppsfCSCujbIy2McbOODvj
xe3GE8QqeSmj45yMddBj442/mdtvpzXyi+fUCd/OKCKngoIqSmuprqehkZZm
2lvRtKHrwKDG3Im1C4cWlw6vHr+BoIGQkYiJqJm4hYRFyldC3HkatxKx4DXC
24rf6t8nV8o1Ez9TxOXxxLdyqyipo7KB2iYaW2htRd1Olxq9BkMnpi4sWqw6
bHrsehxS6MbZjUELgxTp9euTg++kuSh/ueqv/Gff8wFlL1Eto31WC2JmrPd/
v6uwfUURr5Er8Gn86W/+Rzqnf6/99xR2P1LEa5+Jf5m7l9O/orSuS3/fa/UD
xVHlOLD+K7R+mP5fpdVX0/xPxVHl6LpSehFIe2fAleMO5blJ6Z97Z8V7n7Dz
SvqXlFYF6TR7d3j7ieKocmfQ4X9+5mqx3GeKNJVWWWkr2bfxquKocgZiaDoH
ckuQey2RptJqcDpNOf99egSlF30vbS3z7p0j+yvXbN9O50Dmzy/TOVBavZFO
Ux4p9PHsylniX6fTlL2NHOv3hNszVq+l05RT47eKo8qZrFfT1q/L1q8rjipn
cl5J5+BN2fp36RworX6YTnOAbPV7xVHlKP7ltPX7svWb6TSft0eJ+OUhspXS
ByrXKPx7Os0M2fqddJpKq39LWw2TrQYojirXRv1zOgd5svVAxVHlXOA302kX
y9bvpXOgtHopnWa5bPX+M0dr5ce59KYh+yI+kF5fkmINcoyv/T9jQnKp\
\>"]]
}, Open  ]],

Cell["Use diffuse and specular surface color:", "ExampleText",
 CellID->928327454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CMYKColor", "[", 
     RowBox[{"0", ",", "0.4", ",", "1", ",", "0"}], "]"}], ",", 
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "20"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29801507],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121426975,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Use glow color, setting the diffuse surface color to black:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->255057354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Black", ",", 
    RowBox[{"Glow", "[", 
     RowBox[{"CMYKColor", "[", 
      RowBox[{"0", ",", "0.4", ",", "1", ",", "0"}], "]"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93466233],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    RGBColor[1, 0.5, 0]], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->590555239,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Color Operations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->257403165],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 " to mix two or more colors:"
}], "ExampleText",
 CellID->177770353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CMYKColor", "[", 
          RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}], ",", 
         RowBox[{"CMYKColor", "[", 
          RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}]}], "}"}], "]"}], 
      ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->545633765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {CMYKColor[0, 1, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {CMYKColor[0, 
      NCache[
       Rational[1, 2], 0.5], 
      NCache[
       Rational[1, 2], 0.5], 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {CMYKColor[0, 0, 1, 0], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->55293452]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " to mix with white and black respectively:"
}], "ExampleText",
 CellID->180574299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{
        RowBox[{"CMYKColor", "[", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}], ",", ".4"}], 
       "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{
        RowBox[{"CMYKColor", "[", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}], ",", ".4"}], 
       "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->316789779],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1., 1., 0.5020410557516998], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {CMYKColor[0, 0, 1, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0.6, 0.6, 0.10204105575169975`], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->561135788]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->171865235],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["c", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->39646764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0", ",", ".25"}], "}"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", ".25"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345050852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {CMYKColor[1, 0, 0, 0.25], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {CMYKColor[1, 0, 0, 0.25], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->162473882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CMYKColor", "[", "#", "]"}], ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70692759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {CMYKColor[1, 0, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {CMYKColor[0, 1, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {CMYKColor[0, 0, 1, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {CMYKColor[0, 0, 0, 1], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->28442003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213286162],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->73905729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "a", "]"}], ",", 
      RowBox[{"CMYKColor", "[", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155769764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.99], DiskBox[{0, 0}]}}]}], 
  "}"}]], "Output",
 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->134819805]
}, Open  ]],

Cell[TextData[{
 "Use the opacity argument in ",
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 " directly:"
}], "ExampleText",
 CellID->20135033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"CMYKColor", "[", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "a"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280633295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {CMYKColor[1, 0, 0, 0], DiskBox[{1, 0}]}, 
     {CMYKColor[0, 1, 0, 0], Opacity[0.99], DiskBox[{0, 0}]}}]}], 
  "}"}]], "Output",
 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->366015835]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->263321179],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 " is related to ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " in the following way: "
}], "ExampleText",
 CellID->317821917],

Cell[BoxData[
 RowBox[{
  RowBox[{"RGBToCMY", "[", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"r_", ",", "g_", ",", "b_"}], "]"}], "]"}], ":=", 
  RowBox[{"CMYKColor", "[", 
   RowBox[{
    RowBox[{"1", "-", "r"}], ",", 
    RowBox[{"1", "-", "g"}], ",", 
    RowBox[{"1", "-", "b"}], ",", "0"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23265022],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"RGBColor", "@@", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBToCMY", "[", "c", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->356403487],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwPALiNAkGIPs/kAXG
j/7/B9KYJCeQjJ+8cYYglOYaFR0VHRUlSZQFSDIBMxkzmiwzVJwVrArEY2AG
5UUwwFDNiibPNMR1oavmJNsUUBhykaWbDU2cA68pTGiiLEimgNzAicNURrBu
iCPAggxsaCHHDqRBBTNIJSNeuwTx2jEY4nVUF/G6iCsZBkMZNio6Kjo0RDHb
sAyMAHCmk38=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->640763276]
}, Open  ]],

Cell["For economy of printing black is usually separated out: ", "ExampleText",
 CellID->565702108],

Cell[BoxData[
 RowBox[{
  RowBox[{"RGBToCMYK", "[", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"r_", ",", "g_", ",", "b_"}], "]"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"k", "=", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"1", "-", "r"}], ",", 
        RowBox[{"1", "-", "g"}], ",", 
        RowBox[{"1", "-", "b"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"CMYKColor", "[", 
     RowBox[{
      RowBox[{"1", "-", "r", "-", "k"}], ",", 
      RowBox[{"1", "-", "g", "-", "k"}], ",", 
      RowBox[{"1", "-", "b", "-", "k"}], ",", "k"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->76943909],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"RGBColor", "@@", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBToCMYK", "[", "c", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->160881123],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwPALiNAkGIPs/kAXG
j/7/B9KYJCeQjH/qXCkIpblGRUdFR0VJEmUBkkzATMaMJssMFWcFqwLxGJhB
eREMMFSzoskzDXFd6Ko5yTYFFIZcZOlmQxPnwGsKE5ooC5IpIDdw4jCVEawb
4giwIAMbWsixA2lQwQxSyYjXLkG8dgyGeB3VRbwu4kqGwVCGjYqOig4NUcw2
LAMjAKKmZ7U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->148413155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217763201],

Cell[TextData[{
 "By using the same parameters in ",
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " you get complementary colors:"
}], "ExampleText",
 CellID->421639415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "=", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"y", "=", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider2D", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", 
        RowBox[{"{", 
         RowBox[{"m", ",", "y"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CMYKColor", "[", 
            RowBox[{"0", ",", "m", ",", "y", ",", "0"}], "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", "m", ",", "y"}], "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}]}], "}"}], "]"}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11750325],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`m$$ = Rational[1, 2], $CellContext`y$$ = 
  Rational[1, 2]}, 
  RowBox[{"{", 
   RowBox[{
    Slider2DBox[Dynamic[{$CellContext`m$$, $CellContext`y$$}], {{0, 0}, {1, 
     1}}], ",", 
    DynamicBox[ToBoxes[
      Graphics[{{
         CMYKColor[0, $CellContext`m$$, $CellContext`y$$, 0], 
         Rectangle[{0, 0}]}, {
         RGBColor[0, $CellContext`m$$, $CellContext`y$$], 
         Rectangle[{1, 0}]}}], StandardForm],
     ImageSizeCache->{180., {45., 49.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{290, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30917263]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433405789],

Cell["CMY values are complementary to RGB values:", "ExampleText",
 CellID->24318937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280701006],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {CMYKColor[0, 1, 1, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->167850011]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "1", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->83166405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {CMYKColor[1, 0, 1, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->88554038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->874401875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {CMYKColor[1, 1, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->732847096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->472822334],

Cell["Values outside of the 0, 1 range will be clipped:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->318150803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"c", ",", "0", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "c"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453071729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlzsOgzAQRIfAFYhS+iiuQpVDWCgSFFEQobcPlJLeR9uskfOBHIGxtJ/n
kazX+uKm7npzU98604xu6Pr2Yc73Ua/KAsCsZU7QXXRbahbR+dsr7c8QQvUh
lIqyHNQbPr45isSUx8xexKfcZ7YiNuU2M3SmHGuusX7/QAta0IIWtKAFLWhB
C1rQYtcW39/J/+8FxQt7fGvG\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32924722]
}, Open  ]],

Cell[TextData[{
 "In plot functions, use ",
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " to control global scaling of variables:"
}], "ExampleText",
 CellID->22323747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"CMYKColor", "[", 
         RowBox[{"#", ",", "0", ",", "0", ",", "0"}], "]"}], "&"}], ")"}]}], 
     ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->288136242],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3H1kVWEcwPFz3zZbJVJKLU1KSZEUSZH0Jo1IRNKuW9lkmrWIlEiJlEiJ
lEiRiEQkIhGJiEQkmkRKRCL6uj3n2d3+OK1/stjdvo97n3OfF9fveT7nOffc
4zht5d6OPV3l3s5KuXVDT7m7o7NyoHX9/p5QVcglSdIX3nunJeFzNXyK775q
NWwbQ74bGBe2e8K2cbC2EjolhVBVjSlpSntm6kqDvZNCaCGmZFea1cppU3Om
vT3T3jDkt0xPs/m/4Cf8gO/wDb7CZ/gI7+A1vICn8Ajuwx24AVfgApyBE3AE
DkIXhIHthG2wGdbCSlgKC2EOtMBkmAjjoQkaoAi5UJ+kMaYhxICSdH6Scn/h
z5i+wKcY1gd4H4N7C29iiK/gZQz0OTyL4T6BxzHoh/Aghn4P7sYB3IZbcBOu
wzW4CpfhElyE83AOzsJpOAUn4Tgcg6NwGA7FoR6A7jjgfdARh12B9jj4HbA9
TsFW2AJtsAk2wjpYA6thFayA5bAMlsBiWAQLYB7MhdkwC2ZCUJkKU2BSnLUJ
0Bx2GihBPkxTeOXVVVddddVVV1111VVXXXXVVVddddVVV1111VVXXXXVVVdd
ddVVV1111VVXXXXVVVddddVVV1111VVXXXXVVVddddVVV1111VVXXXXVVVdd
ddVVV11160C3GPJ8qEwKsRjndIbC9StcrE1bTP1PR4q0pVCsDqS0rUXl+lUu
Da7jmmZRaaWVVlpppf+jdH7g30AtwAblx5B8+k+hUfExIl7IrPWS8sMgnz2C
DpZH5PWVQm3Ve5z/1+ssWe9c/95Qu96S5sURvQd4bvev8ilx+ujrVDxXh2tf
+eFd8/Xwm6/5WDm7U1pppZVWWmmllVZaaaWVrh9p710aZc5D3Lvk3YejyNd7
S9VVV1111VVXXXXVVVddddVVV1111VVXXXXVVVddddVVV1111VVXXXXVVVdd
ddVVV1111VVXXXXVVVddddVVV1111VVXXXXVVVddddVVV1111R2VursyvZoz
7e1//ZZKqIwy1ZiSppDtztT1P4mlL+ZJ7jcrvFq/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->200403828]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->94384447],

Cell["Visualizing the CMY color space:", "ExampleText",
 CellID->253808967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".7", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CMYKColor", "[", "#", "]"}], ",", 
         RowBox[{"Cuboid", "[", 
          RowBox[{"#", ",", 
           RowBox[{"#", "+", ".1"}]}], "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "1", ",", ".2"}], "]"}], ",", "3"}], "]"}]}]}], 
    "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Cyan\>\"", ",", "\"\<Magenta\>\"", ",", "\"\<Yellow\>\""}], 
     "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99433156],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.7], 
   {CMYKColor[0., 0., 0., 0], CuboidBox[{0., 0., 0.}, {0.1, 0.1, 0.1}]}, 
   {CMYKColor[0., 0., 0.2, 0], 
    CuboidBox[{0., 0., 0.2}, {0.1, 0.1, 0.30000000000000004`}]}, 
   {CMYKColor[0., 0., 0.4, 0], CuboidBox[{0., 0., 0.4}, {0.1, 0.1, 0.5}]}, 
   {CMYKColor[0., 0., 0.6000000000000001, 0], 
    CuboidBox[{0., 0., 0.6000000000000001}, {0.1, 0.1, 
     0.7000000000000001}]}, 
   {CMYKColor[0., 0., 0.8, 0], CuboidBox[{0., 0., 0.8}, {0.1, 0.1, 0.9}]}, 
   {CMYKColor[0., 0., 1., 0], CuboidBox[{0., 0., 1.}, {0.1, 0.1, 1.1}]}, 
   {CMYKColor[0., 0.2, 0., 0], 
    CuboidBox[{0., 0.2, 0.}, {0.1, 0.30000000000000004`, 0.1}]}, 
   {CMYKColor[0., 0.2, 0.2, 0], 
    CuboidBox[{0., 0.2, 0.2}, {0.1, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {CMYKColor[0., 0.2, 0.4, 0], 
    CuboidBox[{0., 0.2, 0.4}, {0.1, 0.30000000000000004`, 0.5}]}, 
   {CMYKColor[0., 0.2, 0.6000000000000001, 0], 
    CuboidBox[{0., 0.2, 0.6000000000000001}, {0.1, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {CMYKColor[0., 0.2, 0.8, 0], 
    CuboidBox[{0., 0.2, 0.8}, {0.1, 0.30000000000000004`, 0.9}]}, 
   {CMYKColor[0., 0.2, 1., 0], 
    CuboidBox[{0., 0.2, 1.}, {0.1, 0.30000000000000004`, 1.1}]}, 
   {CMYKColor[0., 0.4, 0., 0], CuboidBox[{0., 0.4, 0.}, {0.1, 0.5, 0.1}]}, 
   {CMYKColor[0., 0.4, 0.2, 0], 
    CuboidBox[{0., 0.4, 0.2}, {0.1, 0.5, 0.30000000000000004`}]}, 
   {CMYKColor[0., 0.4, 0.4, 0], CuboidBox[{0., 0.4, 0.4}, {0.1, 0.5, 0.5}]}, 
   {CMYKColor[0., 0.4, 0.6000000000000001, 0], 
    CuboidBox[{0., 0.4, 0.6000000000000001}, {0.1, 0.5, 
     0.7000000000000001}]}, 
   {CMYKColor[0., 0.4, 0.8, 0], CuboidBox[{0., 0.4, 0.8}, {0.1, 0.5, 0.9}]}, 
   {CMYKColor[0., 0.4, 1., 0], CuboidBox[{0., 0.4, 1.}, {0.1, 0.5, 1.1}]}, 
   {CMYKColor[0., 0.6000000000000001, 0., 0], 
    CuboidBox[{0., 0.6000000000000001, 0.}, {0.1, 0.7000000000000001, 
     0.1}]}, 
   {CMYKColor[0., 0.6000000000000001, 0.2, 0], 
    CuboidBox[{0., 0.6000000000000001, 0.2}, {0.1, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {CMYKColor[0., 0.6000000000000001, 0.4, 0], 
    CuboidBox[{0., 0.6000000000000001, 0.4}, {0.1, 0.7000000000000001, 
     0.5}]}, 
   {CMYKColor[0., 0.6000000000000001, 0.6000000000000001, 0], 
    CuboidBox[{0., 0.6000000000000001, 0.6000000000000001}, {0.1, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {CMYKColor[0., 0.6000000000000001, 0.8, 0], 
    CuboidBox[{0., 0.6000000000000001, 0.8}, {0.1, 0.7000000000000001, 
     0.9}]}, 
   {CMYKColor[0., 0.6000000000000001, 1., 0], 
    CuboidBox[{0., 0.6000000000000001, 1.}, {0.1, 0.7000000000000001, 
     1.1}]}, 
   {CMYKColor[0., 0.8, 0., 0], CuboidBox[{0., 0.8, 0.}, {0.1, 0.9, 0.1}]}, 
   {CMYKColor[0., 0.8, 0.2, 0], 
    CuboidBox[{0., 0.8, 0.2}, {0.1, 0.9, 0.30000000000000004`}]}, 
   {CMYKColor[0., 0.8, 0.4, 0], CuboidBox[{0., 0.8, 0.4}, {0.1, 0.9, 0.5}]}, 
   {CMYKColor[0., 0.8, 0.6000000000000001, 0], 
    CuboidBox[{0., 0.8, 0.6000000000000001}, {0.1, 0.9, 
     0.7000000000000001}]}, 
   {CMYKColor[0., 0.8, 0.8, 0], CuboidBox[{0., 0.8, 0.8}, {0.1, 0.9, 0.9}]}, 
   {CMYKColor[0., 0.8, 1., 0], CuboidBox[{0., 0.8, 1.}, {0.1, 0.9, 1.1}]}, 
   {CMYKColor[0., 1., 0., 0], CuboidBox[{0., 1., 0.}, {0.1, 1.1, 0.1}]}, 
   {CMYKColor[0., 1., 0.2, 0], 
    CuboidBox[{0., 1., 0.2}, {0.1, 1.1, 0.30000000000000004`}]}, 
   {CMYKColor[0., 1., 0.4, 0], CuboidBox[{0., 1., 0.4}, {0.1, 1.1, 0.5}]}, 
   {CMYKColor[0., 1., 0.6000000000000001, 0], 
    CuboidBox[{0., 1., 0.6000000000000001}, {0.1, 1.1, 
     0.7000000000000001}]}, 
   {CMYKColor[0., 1., 0.8, 0], CuboidBox[{0., 1., 0.8}, {0.1, 1.1, 0.9}]}, 
   {CMYKColor[0., 1., 1., 0], CuboidBox[{0., 1., 1.}, {0.1, 1.1, 1.1}]}, 
   {CMYKColor[0.2, 0., 0., 0], 
    CuboidBox[{0.2, 0., 0.}, {0.30000000000000004`, 0.1, 0.1}]}, 
   {CMYKColor[0.2, 0., 0.2, 0], 
    CuboidBox[{0.2, 0., 0.2}, {0.30000000000000004`, 0.1, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.2, 0., 0.4, 0], 
    CuboidBox[{0.2, 0., 0.4}, {0.30000000000000004`, 0.1, 0.5}]}, 
   {CMYKColor[0.2, 0., 0.6000000000000001, 0], 
    CuboidBox[{0.2, 0., 0.6000000000000001}, {0.30000000000000004`, 0.1, 
     0.7000000000000001}]}, 
   {CMYKColor[0.2, 0., 0.8, 0], 
    CuboidBox[{0.2, 0., 0.8}, {0.30000000000000004`, 0.1, 0.9}]}, 
   {CMYKColor[0.2, 0., 1., 0], 
    CuboidBox[{0.2, 0., 1.}, {0.30000000000000004`, 0.1, 1.1}]}, 
   {CMYKColor[0.2, 0.2, 0., 0], 
    CuboidBox[{0.2, 0.2, 0.}, {0.30000000000000004`, 0.30000000000000004`, 
     0.1}]}, 
   {CMYKColor[0.2, 0.2, 0.2, 0], 
    CuboidBox[{0.2, 0.2, 0.2}, {0.30000000000000004`, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.2, 0.2, 0.4, 0], 
    CuboidBox[{0.2, 0.2, 0.4}, {0.30000000000000004`, 0.30000000000000004`, 
     0.5}]}, 
   {CMYKColor[0.2, 0.2, 0.6000000000000001, 0], 
    CuboidBox[{0.2, 0.2, 0.6000000000000001}, {0.30000000000000004`, 
     0.30000000000000004`, 0.7000000000000001}]}, 
   {CMYKColor[0.2, 0.2, 0.8, 0], 
    CuboidBox[{0.2, 0.2, 0.8}, {0.30000000000000004`, 0.30000000000000004`, 
     0.9}]}, 
   {CMYKColor[0.2, 0.2, 1., 0], 
    CuboidBox[{0.2, 0.2, 1.}, {0.30000000000000004`, 0.30000000000000004`, 
     1.1}]}, 
   {CMYKColor[0.2, 0.4, 0., 0], 
    CuboidBox[{0.2, 0.4, 0.}, {0.30000000000000004`, 0.5, 0.1}]}, 
   {CMYKColor[0.2, 0.4, 0.2, 0], 
    CuboidBox[{0.2, 0.4, 0.2}, {0.30000000000000004`, 0.5, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.2, 0.4, 0.4, 0], 
    CuboidBox[{0.2, 0.4, 0.4}, {0.30000000000000004`, 0.5, 0.5}]}, 
   {CMYKColor[0.2, 0.4, 0.6000000000000001, 0], 
    CuboidBox[{0.2, 0.4, 0.6000000000000001}, {0.30000000000000004`, 0.5, 
     0.7000000000000001}]}, 
   {CMYKColor[0.2, 0.4, 0.8, 0], 
    CuboidBox[{0.2, 0.4, 0.8}, {0.30000000000000004`, 0.5, 0.9}]}, 
   {CMYKColor[0.2, 0.4, 1., 0], 
    CuboidBox[{0.2, 0.4, 1.}, {0.30000000000000004`, 0.5, 1.1}]}, 
   {CMYKColor[0.2, 0.6000000000000001, 0., 0], 
    CuboidBox[{0.2, 0.6000000000000001, 0.}, {0.30000000000000004`, 
     0.7000000000000001, 0.1}]}, 
   {CMYKColor[0.2, 0.6000000000000001, 0.2, 0], 
    CuboidBox[{0.2, 0.6000000000000001, 0.2}, {0.30000000000000004`, 
     0.7000000000000001, 0.30000000000000004`}]}, 
   {CMYKColor[0.2, 0.6000000000000001, 0.4, 0], 
    CuboidBox[{0.2, 0.6000000000000001, 0.4}, {0.30000000000000004`, 
     0.7000000000000001, 0.5}]}, 
   {CMYKColor[0.2, 0.6000000000000001, 0.6000000000000001, 0], 
    CuboidBox[{0.2, 0.6000000000000001, 0.6000000000000001}, {
     0.30000000000000004`, 0.7000000000000001, 0.7000000000000001}]}, 
   {CMYKColor[0.2, 0.6000000000000001, 0.8, 0], 
    CuboidBox[{0.2, 0.6000000000000001, 0.8}, {0.30000000000000004`, 
     0.7000000000000001, 0.9}]}, 
   {CMYKColor[0.2, 0.6000000000000001, 1., 0], 
    CuboidBox[{0.2, 0.6000000000000001, 1.}, {0.30000000000000004`, 
     0.7000000000000001, 1.1}]}, 
   {CMYKColor[0.2, 0.8, 0., 0], 
    CuboidBox[{0.2, 0.8, 0.}, {0.30000000000000004`, 0.9, 0.1}]}, 
   {CMYKColor[0.2, 0.8, 0.2, 0], 
    CuboidBox[{0.2, 0.8, 0.2}, {0.30000000000000004`, 0.9, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.2, 0.8, 0.4, 0], 
    CuboidBox[{0.2, 0.8, 0.4}, {0.30000000000000004`, 0.9, 0.5}]}, 
   {CMYKColor[0.2, 0.8, 0.6000000000000001, 0], 
    CuboidBox[{0.2, 0.8, 0.6000000000000001}, {0.30000000000000004`, 0.9, 
     0.7000000000000001}]}, 
   {CMYKColor[0.2, 0.8, 0.8, 0], 
    CuboidBox[{0.2, 0.8, 0.8}, {0.30000000000000004`, 0.9, 0.9}]}, 
   {CMYKColor[0.2, 0.8, 1., 0], 
    CuboidBox[{0.2, 0.8, 1.}, {0.30000000000000004`, 0.9, 1.1}]}, 
   {CMYKColor[0.2, 1., 0., 0], 
    CuboidBox[{0.2, 1., 0.}, {0.30000000000000004`, 1.1, 0.1}]}, 
   {CMYKColor[0.2, 1., 0.2, 0], 
    CuboidBox[{0.2, 1., 0.2}, {0.30000000000000004`, 1.1, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.2, 1., 0.4, 0], 
    CuboidBox[{0.2, 1., 0.4}, {0.30000000000000004`, 1.1, 0.5}]}, 
   {CMYKColor[0.2, 1., 0.6000000000000001, 0], 
    CuboidBox[{0.2, 1., 0.6000000000000001}, {0.30000000000000004`, 1.1, 
     0.7000000000000001}]}, 
   {CMYKColor[0.2, 1., 0.8, 0], 
    CuboidBox[{0.2, 1., 0.8}, {0.30000000000000004`, 1.1, 0.9}]}, 
   {CMYKColor[0.2, 1., 1., 0], 
    CuboidBox[{0.2, 1., 1.}, {0.30000000000000004`, 1.1, 1.1}]}, 
   {CMYKColor[0.4, 0., 0., 0], CuboidBox[{0.4, 0., 0.}, {0.5, 0.1, 0.1}]}, 
   {CMYKColor[0.4, 0., 0.2, 0], 
    CuboidBox[{0.4, 0., 0.2}, {0.5, 0.1, 0.30000000000000004`}]}, 
   {CMYKColor[0.4, 0., 0.4, 0], CuboidBox[{0.4, 0., 0.4}, {0.5, 0.1, 0.5}]}, 
   {CMYKColor[0.4, 0., 0.6000000000000001, 0], 
    CuboidBox[{0.4, 0., 0.6000000000000001}, {0.5, 0.1, 
     0.7000000000000001}]}, 
   {CMYKColor[0.4, 0., 0.8, 0], CuboidBox[{0.4, 0., 0.8}, {0.5, 0.1, 0.9}]}, 
   {CMYKColor[0.4, 0., 1., 0], CuboidBox[{0.4, 0., 1.}, {0.5, 0.1, 1.1}]}, 
   {CMYKColor[0.4, 0.2, 0., 0], 
    CuboidBox[{0.4, 0.2, 0.}, {0.5, 0.30000000000000004`, 0.1}]}, 
   {CMYKColor[0.4, 0.2, 0.2, 0], 
    CuboidBox[{0.4, 0.2, 0.2}, {0.5, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.4, 0.2, 0.4, 0], 
    CuboidBox[{0.4, 0.2, 0.4}, {0.5, 0.30000000000000004`, 0.5}]}, 
   {CMYKColor[0.4, 0.2, 0.6000000000000001, 0], 
    CuboidBox[{0.4, 0.2, 0.6000000000000001}, {0.5, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {CMYKColor[0.4, 0.2, 0.8, 0], 
    CuboidBox[{0.4, 0.2, 0.8}, {0.5, 0.30000000000000004`, 0.9}]}, 
   {CMYKColor[0.4, 0.2, 1., 0], 
    CuboidBox[{0.4, 0.2, 1.}, {0.5, 0.30000000000000004`, 1.1}]}, 
   {CMYKColor[0.4, 0.4, 0., 0], CuboidBox[{0.4, 0.4, 0.}, {0.5, 0.5, 0.1}]}, 
   {CMYKColor[0.4, 0.4, 0.2, 0], 
    CuboidBox[{0.4, 0.4, 0.2}, {0.5, 0.5, 0.30000000000000004`}]}, 
   {CMYKColor[0.4, 0.4, 0.4, 0], 
    CuboidBox[{0.4, 0.4, 0.4}, {0.5, 0.5, 0.5}]}, 
   {CMYKColor[0.4, 0.4, 0.6000000000000001, 0], 
    CuboidBox[{0.4, 0.4, 0.6000000000000001}, {0.5, 0.5, 
     0.7000000000000001}]}, 
   {CMYKColor[0.4, 0.4, 0.8, 0], 
    CuboidBox[{0.4, 0.4, 0.8}, {0.5, 0.5, 0.9}]}, 
   {CMYKColor[0.4, 0.4, 1., 0], CuboidBox[{0.4, 0.4, 1.}, {0.5, 0.5, 1.1}]}, 
   {CMYKColor[0.4, 0.6000000000000001, 0., 0], 
    CuboidBox[{0.4, 0.6000000000000001, 0.}, {0.5, 0.7000000000000001, 
     0.1}]}, 
   {CMYKColor[0.4, 0.6000000000000001, 0.2, 0], 
    CuboidBox[{0.4, 0.6000000000000001, 0.2}, {0.5, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.4, 0.6000000000000001, 0.4, 0], 
    CuboidBox[{0.4, 0.6000000000000001, 0.4}, {0.5, 0.7000000000000001, 
     0.5}]}, 
   {CMYKColor[0.4, 0.6000000000000001, 0.6000000000000001, 0], 
    CuboidBox[{0.4, 0.6000000000000001, 0.6000000000000001}, {0.5, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {CMYKColor[0.4, 0.6000000000000001, 0.8, 0], 
    CuboidBox[{0.4, 0.6000000000000001, 0.8}, {0.5, 0.7000000000000001, 
     0.9}]}, 
   {CMYKColor[0.4, 0.6000000000000001, 1., 0], 
    CuboidBox[{0.4, 0.6000000000000001, 1.}, {0.5, 0.7000000000000001, 
     1.1}]}, 
   {CMYKColor[0.4, 0.8, 0., 0], CuboidBox[{0.4, 0.8, 0.}, {0.5, 0.9, 0.1}]}, 
   {CMYKColor[0.4, 0.8, 0.2, 0], 
    CuboidBox[{0.4, 0.8, 0.2}, {0.5, 0.9, 0.30000000000000004`}]}, 
   {CMYKColor[0.4, 0.8, 0.4, 0], 
    CuboidBox[{0.4, 0.8, 0.4}, {0.5, 0.9, 0.5}]}, 
   {CMYKColor[0.4, 0.8, 0.6000000000000001, 0], 
    CuboidBox[{0.4, 0.8, 0.6000000000000001}, {0.5, 0.9, 
     0.7000000000000001}]}, 
   {CMYKColor[0.4, 0.8, 0.8, 0], 
    CuboidBox[{0.4, 0.8, 0.8}, {0.5, 0.9, 0.9}]}, 
   {CMYKColor[0.4, 0.8, 1., 0], CuboidBox[{0.4, 0.8, 1.}, {0.5, 0.9, 1.1}]}, 
   {CMYKColor[0.4, 1., 0., 0], CuboidBox[{0.4, 1., 0.}, {0.5, 1.1, 0.1}]}, 
   {CMYKColor[0.4, 1., 0.2, 0], 
    CuboidBox[{0.4, 1., 0.2}, {0.5, 1.1, 0.30000000000000004`}]}, 
   {CMYKColor[0.4, 1., 0.4, 0], CuboidBox[{0.4, 1., 0.4}, {0.5, 1.1, 0.5}]}, 
   {CMYKColor[0.4, 1., 0.6000000000000001, 0], 
    CuboidBox[{0.4, 1., 0.6000000000000001}, {0.5, 1.1, 0.7000000000000001}]},
    
   {CMYKColor[0.4, 1., 0.8, 0], CuboidBox[{0.4, 1., 0.8}, {0.5, 1.1, 0.9}]}, 
   {CMYKColor[0.4, 1., 1., 0], CuboidBox[{0.4, 1., 1.}, {0.5, 1.1, 1.1}]}, 
   {CMYKColor[0.6000000000000001, 0., 0., 0], 
    CuboidBox[{0.6000000000000001, 0., 0.}, {0.7000000000000001, 0.1, 
     0.1}]}, 
   {CMYKColor[0.6000000000000001, 0., 0.2, 0], 
    CuboidBox[{0.6000000000000001, 0., 0.2}, {0.7000000000000001, 0.1, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.6000000000000001, 0., 0.4, 0], 
    CuboidBox[{0.6000000000000001, 0., 0.4}, {0.7000000000000001, 0.1, 
     0.5}]}, 
   {CMYKColor[0.6000000000000001, 0., 0.6000000000000001, 0], 
    CuboidBox[{0.6000000000000001, 0., 0.6000000000000001}, {
     0.7000000000000001, 0.1, 0.7000000000000001}]}, 
   {CMYKColor[0.6000000000000001, 0., 0.8, 0], 
    CuboidBox[{0.6000000000000001, 0., 0.8}, {0.7000000000000001, 0.1, 
     0.9}]}, 
   {CMYKColor[0.6000000000000001, 0., 1., 0], 
    CuboidBox[{0.6000000000000001, 0., 1.}, {0.7000000000000001, 0.1, 
     1.1}]}, 
   {CMYKColor[0.6000000000000001, 0.2, 0., 0], 
    CuboidBox[{0.6000000000000001, 0.2, 0.}, {0.7000000000000001, 
     0.30000000000000004`, 0.1}]}, 
   {CMYKColor[0.6000000000000001, 0.2, 0.2, 0], 
    CuboidBox[{0.6000000000000001, 0.2, 0.2}, {0.7000000000000001, 
     0.30000000000000004`, 0.30000000000000004`}]}, 
   {CMYKColor[0.6000000000000001, 0.2, 0.4, 0], 
    CuboidBox[{0.6000000000000001, 0.2, 0.4}, {0.7000000000000001, 
     0.30000000000000004`, 0.5}]}, 
   {CMYKColor[0.6000000000000001, 0.2, 0.6000000000000001, 0], 
    CuboidBox[{0.6000000000000001, 0.2, 0.6000000000000001}, {
     0.7000000000000001, 0.30000000000000004`, 0.7000000000000001}]}, 
   {CMYKColor[0.6000000000000001, 0.2, 0.8, 0], 
    CuboidBox[{0.6000000000000001, 0.2, 0.8}, {0.7000000000000001, 
     0.30000000000000004`, 0.9}]}, 
   {CMYKColor[0.6000000000000001, 0.2, 1., 0], 
    CuboidBox[{0.6000000000000001, 0.2, 1.}, {0.7000000000000001, 
     0.30000000000000004`, 1.1}]}, 
   {CMYKColor[0.6000000000000001, 0.4, 0., 0], 
    CuboidBox[{0.6000000000000001, 0.4, 0.}, {0.7000000000000001, 0.5, 
     0.1}]}, 
   {CMYKColor[0.6000000000000001, 0.4, 0.2, 0], 
    CuboidBox[{0.6000000000000001, 0.4, 0.2}, {0.7000000000000001, 0.5, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.6000000000000001, 0.4, 0.4, 0], 
    CuboidBox[{0.6000000000000001, 0.4, 0.4}, {0.7000000000000001, 0.5, 
     0.5}]}, 
   {CMYKColor[0.6000000000000001, 0.4, 0.6000000000000001, 0], 
    CuboidBox[{0.6000000000000001, 0.4, 0.6000000000000001}, {
     0.7000000000000001, 0.5, 0.7000000000000001}]}, 
   {CMYKColor[0.6000000000000001, 0.4, 0.8, 0], 
    CuboidBox[{0.6000000000000001, 0.4, 0.8}, {0.7000000000000001, 0.5, 
     0.9}]}, 
   {CMYKColor[0.6000000000000001, 0.4, 1., 0], 
    CuboidBox[{0.6000000000000001, 0.4, 1.}, {0.7000000000000001, 0.5, 
     1.1}]}, 
   {CMYKColor[0.6000000000000001, 0.6000000000000001, 0., 0], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.}, {
     0.7000000000000001, 0.7000000000000001, 0.1}]}, 
   {CMYKColor[0.6000000000000001, 0.6000000000000001, 0.2, 0], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.2}, {
     0.7000000000000001, 0.7000000000000001, 0.30000000000000004`}]}, 
   {CMYKColor[0.6000000000000001, 0.6000000000000001, 0.4, 0], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.4}, {
     0.7000000000000001, 0.7000000000000001, 0.5}]}, 
   {CMYKColor[0.6000000000000001, 0.6000000000000001, 0.6000000000000001, 0], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.6000000000000001}, {
     0.7000000000000001, 0.7000000000000001, 0.7000000000000001}]}, 
   {CMYKColor[0.6000000000000001, 0.6000000000000001, 0.8, 0], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.8}, {
     0.7000000000000001, 0.7000000000000001, 0.9}]}, 
   {CMYKColor[0.6000000000000001, 0.6000000000000001, 1., 0], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 1.}, {
     0.7000000000000001, 0.7000000000000001, 1.1}]}, 
   {CMYKColor[0.6000000000000001, 0.8, 0., 0], 
    CuboidBox[{0.6000000000000001, 0.8, 0.}, {0.7000000000000001, 0.9, 
     0.1}]}, 
   {CMYKColor[0.6000000000000001, 0.8, 0.2, 0], 
    CuboidBox[{0.6000000000000001, 0.8, 0.2}, {0.7000000000000001, 0.9, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.6000000000000001, 0.8, 0.4, 0], 
    CuboidBox[{0.6000000000000001, 0.8, 0.4}, {0.7000000000000001, 0.9, 
     0.5}]}, 
   {CMYKColor[0.6000000000000001, 0.8, 0.6000000000000001, 0], 
    CuboidBox[{0.6000000000000001, 0.8, 0.6000000000000001}, {
     0.7000000000000001, 0.9, 0.7000000000000001}]}, 
   {CMYKColor[0.6000000000000001, 0.8, 0.8, 0], 
    CuboidBox[{0.6000000000000001, 0.8, 0.8}, {0.7000000000000001, 0.9, 
     0.9}]}, 
   {CMYKColor[0.6000000000000001, 0.8, 1., 0], 
    CuboidBox[{0.6000000000000001, 0.8, 1.}, {0.7000000000000001, 0.9, 
     1.1}]}, 
   {CMYKColor[0.6000000000000001, 1., 0., 0], 
    CuboidBox[{0.6000000000000001, 1., 0.}, {0.7000000000000001, 1.1, 
     0.1}]}, 
   {CMYKColor[0.6000000000000001, 1., 0.2, 0], 
    CuboidBox[{0.6000000000000001, 1., 0.2}, {0.7000000000000001, 1.1, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.6000000000000001, 1., 0.4, 0], 
    CuboidBox[{0.6000000000000001, 1., 0.4}, {0.7000000000000001, 1.1, 
     0.5}]}, 
   {CMYKColor[0.6000000000000001, 1., 0.6000000000000001, 0], 
    CuboidBox[{0.6000000000000001, 1., 0.6000000000000001}, {
     0.7000000000000001, 1.1, 0.7000000000000001}]}, 
   {CMYKColor[0.6000000000000001, 1., 0.8, 0], 
    CuboidBox[{0.6000000000000001, 1., 0.8}, {0.7000000000000001, 1.1, 
     0.9}]}, 
   {CMYKColor[0.6000000000000001, 1., 1., 0], 
    CuboidBox[{0.6000000000000001, 1., 1.}, {0.7000000000000001, 1.1, 
     1.1}]}, 
   {CMYKColor[0.8, 0., 0., 0], CuboidBox[{0.8, 0., 0.}, {0.9, 0.1, 0.1}]}, 
   {CMYKColor[0.8, 0., 0.2, 0], 
    CuboidBox[{0.8, 0., 0.2}, {0.9, 0.1, 0.30000000000000004`}]}, 
   {CMYKColor[0.8, 0., 0.4, 0], CuboidBox[{0.8, 0., 0.4}, {0.9, 0.1, 0.5}]}, 
   {CMYKColor[0.8, 0., 0.6000000000000001, 0], 
    CuboidBox[{0.8, 0., 0.6000000000000001}, {0.9, 0.1, 
     0.7000000000000001}]}, 
   {CMYKColor[0.8, 0., 0.8, 0], CuboidBox[{0.8, 0., 0.8}, {0.9, 0.1, 0.9}]}, 
   {CMYKColor[0.8, 0., 1., 0], CuboidBox[{0.8, 0., 1.}, {0.9, 0.1, 1.1}]}, 
   {CMYKColor[0.8, 0.2, 0., 0], 
    CuboidBox[{0.8, 0.2, 0.}, {0.9, 0.30000000000000004`, 0.1}]}, 
   {CMYKColor[0.8, 0.2, 0.2, 0], 
    CuboidBox[{0.8, 0.2, 0.2}, {0.9, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.8, 0.2, 0.4, 0], 
    CuboidBox[{0.8, 0.2, 0.4}, {0.9, 0.30000000000000004`, 0.5}]}, 
   {CMYKColor[0.8, 0.2, 0.6000000000000001, 0], 
    CuboidBox[{0.8, 0.2, 0.6000000000000001}, {0.9, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {CMYKColor[0.8, 0.2, 0.8, 0], 
    CuboidBox[{0.8, 0.2, 0.8}, {0.9, 0.30000000000000004`, 0.9}]}, 
   {CMYKColor[0.8, 0.2, 1., 0], 
    CuboidBox[{0.8, 0.2, 1.}, {0.9, 0.30000000000000004`, 1.1}]}, 
   {CMYKColor[0.8, 0.4, 0., 0], CuboidBox[{0.8, 0.4, 0.}, {0.9, 0.5, 0.1}]}, 
   {CMYKColor[0.8, 0.4, 0.2, 0], 
    CuboidBox[{0.8, 0.4, 0.2}, {0.9, 0.5, 0.30000000000000004`}]}, 
   {CMYKColor[0.8, 0.4, 0.4, 0], 
    CuboidBox[{0.8, 0.4, 0.4}, {0.9, 0.5, 0.5}]}, 
   {CMYKColor[0.8, 0.4, 0.6000000000000001, 0], 
    CuboidBox[{0.8, 0.4, 0.6000000000000001}, {0.9, 0.5, 
     0.7000000000000001}]}, 
   {CMYKColor[0.8, 0.4, 0.8, 0], 
    CuboidBox[{0.8, 0.4, 0.8}, {0.9, 0.5, 0.9}]}, 
   {CMYKColor[0.8, 0.4, 1., 0], CuboidBox[{0.8, 0.4, 1.}, {0.9, 0.5, 1.1}]}, 
   {CMYKColor[0.8, 0.6000000000000001, 0., 0], 
    CuboidBox[{0.8, 0.6000000000000001, 0.}, {0.9, 0.7000000000000001, 
     0.1}]}, 
   {CMYKColor[0.8, 0.6000000000000001, 0.2, 0], 
    CuboidBox[{0.8, 0.6000000000000001, 0.2}, {0.9, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {CMYKColor[0.8, 0.6000000000000001, 0.4, 0], 
    CuboidBox[{0.8, 0.6000000000000001, 0.4}, {0.9, 0.7000000000000001, 
     0.5}]}, 
   {CMYKColor[0.8, 0.6000000000000001, 0.6000000000000001, 0], 
    CuboidBox[{0.8, 0.6000000000000001, 0.6000000000000001}, {0.9, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {CMYKColor[0.8, 0.6000000000000001, 0.8, 0], 
    CuboidBox[{0.8, 0.6000000000000001, 0.8}, {0.9, 0.7000000000000001, 
     0.9}]}, 
   {CMYKColor[0.8, 0.6000000000000001, 1., 0], 
    CuboidBox[{0.8, 0.6000000000000001, 1.}, {0.9, 0.7000000000000001, 
     1.1}]}, 
   {CMYKColor[0.8, 0.8, 0., 0], CuboidBox[{0.8, 0.8, 0.}, {0.9, 0.9, 0.1}]}, 
   {CMYKColor[0.8, 0.8, 0.2, 0], 
    CuboidBox[{0.8, 0.8, 0.2}, {0.9, 0.9, 0.30000000000000004`}]}, 
   {CMYKColor[0.8, 0.8, 0.4, 0], 
    CuboidBox[{0.8, 0.8, 0.4}, {0.9, 0.9, 0.5}]}, 
   {CMYKColor[0.8, 0.8, 0.6000000000000001, 0], 
    CuboidBox[{0.8, 0.8, 0.6000000000000001}, {0.9, 0.9, 
     0.7000000000000001}]}, 
   {CMYKColor[0.8, 0.8, 0.8, 0], 
    CuboidBox[{0.8, 0.8, 0.8}, {0.9, 0.9, 0.9}]}, 
   {CMYKColor[0.8, 0.8, 1., 0], CuboidBox[{0.8, 0.8, 1.}, {0.9, 0.9, 1.1}]}, 
   {CMYKColor[0.8, 1., 0., 0], CuboidBox[{0.8, 1., 0.}, {0.9, 1.1, 0.1}]}, 
   {CMYKColor[0.8, 1., 0.2, 0], 
    CuboidBox[{0.8, 1., 0.2}, {0.9, 1.1, 0.30000000000000004`}]}, 
   {CMYKColor[0.8, 1., 0.4, 0], CuboidBox[{0.8, 1., 0.4}, {0.9, 1.1, 0.5}]}, 
   {CMYKColor[0.8, 1., 0.6000000000000001, 0], 
    CuboidBox[{0.8, 1., 0.6000000000000001}, {0.9, 1.1, 
     0.7000000000000001}]}, 
   {CMYKColor[0.8, 1., 0.8, 0], CuboidBox[{0.8, 1., 0.8}, {0.9, 1.1, 0.9}]}, 
   {CMYKColor[0.8, 1., 1., 0], CuboidBox[{0.8, 1., 1.}, {0.9, 1.1, 1.1}]}, 
   {CMYKColor[1., 0., 0., 0], CuboidBox[{1., 0., 0.}, {1.1, 0.1, 0.1}]}, 
   {CMYKColor[1., 0., 0.2, 0], 
    CuboidBox[{1., 0., 0.2}, {1.1, 0.1, 0.30000000000000004`}]}, 
   {CMYKColor[1., 0., 0.4, 0], CuboidBox[{1., 0., 0.4}, {1.1, 0.1, 0.5}]}, 
   {CMYKColor[1., 0., 0.6000000000000001, 0], 
    CuboidBox[{1., 0., 0.6000000000000001}, {1.1, 0.1, 
     0.7000000000000001}]}, 
   {CMYKColor[1., 0., 0.8, 0], CuboidBox[{1., 0., 0.8}, {1.1, 0.1, 0.9}]}, 
   {CMYKColor[1., 0., 1., 0], CuboidBox[{1., 0., 1.}, {1.1, 0.1, 1.1}]}, 
   {CMYKColor[1., 0.2, 0., 0], 
    CuboidBox[{1., 0.2, 0.}, {1.1, 0.30000000000000004`, 0.1}]}, 
   {CMYKColor[1., 0.2, 0.2, 0], 
    CuboidBox[{1., 0.2, 0.2}, {1.1, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {CMYKColor[1., 0.2, 0.4, 0], 
    CuboidBox[{1., 0.2, 0.4}, {1.1, 0.30000000000000004`, 0.5}]}, 
   {CMYKColor[1., 0.2, 0.6000000000000001, 0], 
    CuboidBox[{1., 0.2, 0.6000000000000001}, {1.1, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {CMYKColor[1., 0.2, 0.8, 0], 
    CuboidBox[{1., 0.2, 0.8}, {1.1, 0.30000000000000004`, 0.9}]}, 
   {CMYKColor[1., 0.2, 1., 0], 
    CuboidBox[{1., 0.2, 1.}, {1.1, 0.30000000000000004`, 1.1}]}, 
   {CMYKColor[1., 0.4, 0., 0], CuboidBox[{1., 0.4, 0.}, {1.1, 0.5, 0.1}]}, 
   {CMYKColor[1., 0.4, 0.2, 0], 
    CuboidBox[{1., 0.4, 0.2}, {1.1, 0.5, 0.30000000000000004`}]}, 
   {CMYKColor[1., 0.4, 0.4, 0], CuboidBox[{1., 0.4, 0.4}, {1.1, 0.5, 0.5}]}, 
   {CMYKColor[1., 0.4, 0.6000000000000001, 0], 
    CuboidBox[{1., 0.4, 0.6000000000000001}, {1.1, 0.5, 
     0.7000000000000001}]}, 
   {CMYKColor[1., 0.4, 0.8, 0], CuboidBox[{1., 0.4, 0.8}, {1.1, 0.5, 0.9}]}, 
   {CMYKColor[1., 0.4, 1., 0], CuboidBox[{1., 0.4, 1.}, {1.1, 0.5, 1.1}]}, 
   {CMYKColor[1., 0.6000000000000001, 0., 0], 
    CuboidBox[{1., 0.6000000000000001, 0.}, {1.1, 0.7000000000000001, 
     0.1}]}, 
   {CMYKColor[1., 0.6000000000000001, 0.2, 0], 
    CuboidBox[{1., 0.6000000000000001, 0.2}, {1.1, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {CMYKColor[1., 0.6000000000000001, 0.4, 0], 
    CuboidBox[{1., 0.6000000000000001, 0.4}, {1.1, 0.7000000000000001, 
     0.5}]}, 
   {CMYKColor[1., 0.6000000000000001, 0.6000000000000001, 0], 
    CuboidBox[{1., 0.6000000000000001, 0.6000000000000001}, {1.1, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {CMYKColor[1., 0.6000000000000001, 0.8, 0], 
    CuboidBox[{1., 0.6000000000000001, 0.8}, {1.1, 0.7000000000000001, 
     0.9}]}, 
   {CMYKColor[1., 0.6000000000000001, 1., 0], 
    CuboidBox[{1., 0.6000000000000001, 1.}, {1.1, 0.7000000000000001, 
     1.1}]}, 
   {CMYKColor[1., 0.8, 0., 0], CuboidBox[{1., 0.8, 0.}, {1.1, 0.9, 0.1}]}, 
   {CMYKColor[1., 0.8, 0.2, 0], 
    CuboidBox[{1., 0.8, 0.2}, {1.1, 0.9, 0.30000000000000004`}]}, 
   {CMYKColor[1., 0.8, 0.4, 0], CuboidBox[{1., 0.8, 0.4}, {1.1, 0.9, 0.5}]}, 
   {CMYKColor[1., 0.8, 0.6000000000000001, 0], 
    CuboidBox[{1., 0.8, 0.6000000000000001}, {1.1, 0.9, 
     0.7000000000000001}]}, 
   {CMYKColor[1., 0.8, 0.8, 0], CuboidBox[{1., 0.8, 0.8}, {1.1, 0.9, 0.9}]}, 
   {CMYKColor[1., 0.8, 1., 0], CuboidBox[{1., 0.8, 1.}, {1.1, 0.9, 1.1}]}, 
   {CMYKColor[1., 1., 0., 0], CuboidBox[{1., 1., 0.}, {1.1, 1.1, 0.1}]}, 
   {CMYKColor[1., 1., 0.2, 0], 
    CuboidBox[{1., 1., 0.2}, {1.1, 1.1, 0.30000000000000004`}]}, 
   {CMYKColor[1., 1., 0.4, 0], CuboidBox[{1., 1., 0.4}, {1.1, 1.1, 0.5}]}, 
   {CMYKColor[1., 1., 0.6000000000000001, 0], 
    CuboidBox[{1., 1., 0.6000000000000001}, {1.1, 1.1, 
     0.7000000000000001}]}, 
   {CMYKColor[1., 1., 0.8, 0], CuboidBox[{1., 1., 0.8}, {1.1, 1.1, 0.9}]}, 
   {CMYKColor[1., 1., 1., 0], CuboidBox[{1., 1., 1.}, {1.1, 1.1, 1.1}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"Cyan\"", TraditionalForm], 
    FormBox["\"Magenta\"", TraditionalForm], 
    FormBox["\"Yellow\"", TraditionalForm]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{229, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->480868368,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->574602496],

Cell["CMYK noise with opacity:", "ExampleText",
 CellID->281618892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}], ",", "40"}], "]"}], ",", 
    RowBox[{"Raster", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"200", ",", "200", ",", "5"}], "}"}]}], "]"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", "CMYKColor"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36518387],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->296169792]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30335],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opacity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cyan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cyan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magenta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magenta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Yellow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Yellow"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7214]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->228641858],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->602648667]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CMYKColor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 51.2279652}", "context" -> "System`", 
    "keywords" -> {
     "CMY", "CMYK", "color model", "color space", "device color model", 
      "diffuse color", "pigment", "subtractive color", 
      "subtractive color model"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CMYKColor[cyan, magenta, yellow, black] is a graphics directive which \
specifies that graphical objects which follow are to be displayed in the \
color given. CMYKColor[c, m, y, k, a] specifies opacity a. ", 
    "synonyms" -> {}, "title" -> "CMYKColor", "type" -> "Symbol", "uri" -> 
    "ref/CMYKColor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10766, 309, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->246249139]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 268244, 5338}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1551, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2174, 62, 4193, 83, 70, "ObjectNameGrid"],
Cell[6370, 147, 1217, 37, 70, "Usage",
 CellID->17435]
}, Open  ]],
Cell[CellGroupData[{
Cell[7624, 189, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8102, 206, 337, 12, 70, "Notes",
 CellID->21519],
Cell[8442, 220, 220, 7, 70, "Notes",
 CellID->14716],
Cell[8665, 229, 605, 22, 70, "Notes",
 CellID->599462901],
Cell[9273, 253, 474, 15, 70, "Notes",
 CellID->21640],
Cell[9750, 270, 979, 34, 70, "Notes",
 CellID->23764]
}, Closed]],
Cell[CellGroupData[{
Cell[10766, 309, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246249139],
Cell[CellGroupData[{
Cell[11151, 323, 148, 5, 70, "ExampleSection",
 CellID->118136369],
Cell[11302, 330, 84, 1, 70, "ExampleText",
 CellID->149026781],
Cell[CellGroupData[{
Cell[11411, 335, 264, 8, 28, "Input",
 CellID->64769354],
Cell[11678, 345, 270, 8, 121, "Output",
 CellID->531746997]
}, Open  ]],
Cell[11963, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->165758003],
Cell[12091, 361, 74, 1, 70, "ExampleText",
 CellID->263465182],
Cell[CellGroupData[{
Cell[12190, 366, 278, 8, 70, "Input",
 CellID->152479682],
Cell[12471, 376, 5981, 103, 129, 104, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->166571302]
}, Open  ]],
Cell[18467, 482, 124, 3, 70, "ExampleDelimiter",
 CellID->62699745],
Cell[18594, 487, 82, 1, 70, "ExampleText",
 CellID->53708190],
Cell[CellGroupData[{
Cell[18701, 492, 283, 9, 70, "Input",
 CellID->195861199],
Cell[18987, 503, 443, 14, 36, "Output",
 CellID->382062553]
}, Open  ]],
Cell[19445, 520, 124, 3, 70, "ExampleDelimiter",
 CellID->20732203],
Cell[19572, 525, 70, 1, 70, "ExampleText",
 CellID->580206808],
Cell[CellGroupData[{
Cell[19667, 530, 399, 13, 28, "Input",
 CellID->211868938],
Cell[20069, 545, 5804, 99, 128, "Output",
 Evaluatable->False,
 CellID->106841461]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25922, 650, 216, 7, 70, "ExampleSection",
 CellID->14718],
Cell[CellGroupData[{
Cell[26163, 661, 280, 8, 70, "ExampleSubsection",
 CellID->23349739],
Cell[26446, 671, 69, 1, 70, "ExampleText",
 CellID->404625886],
Cell[CellGroupData[{
Cell[26540, 676, 266, 8, 70, "Input",
 CellID->907978],
Cell[26809, 686, 28946, 479, 216, 92, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->6864743]
}, Open  ]],
Cell[55770, 1168, 82, 1, 70, "ExampleText",
 CellID->928327454],
Cell[CellGroupData[{
Cell[55877, 1173, 349, 10, 70, "Input",
 CellID->29801507],
Cell[56229, 1185, 32897, 545, 216, 124, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->121426975]
}, Open  ]],
Cell[89141, 1733, 152, 3, 70, "ExampleText",
 CellID->255057354],
Cell[CellGroupData[{
Cell[89318, 1740, 317, 9, 70, "Input",
 CellID->93466233],
Cell[89638, 1751, 3020, 55, 216, 113, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->590555239]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[92707, 1812, 237, 7, 70, "ExampleSubsection",
 CellID->257403165],
Cell[92947, 1821, 207, 8, 70, "ExampleText",
 CellID->177770353],
Cell[CellGroupData[{
Cell[93179, 1833, 994, 30, 70, "Input",
 CellID->545633765],
Cell[94176, 1865, 525, 18, 123, "Output",
 CellID->55293452]
}, Open  ]],
Cell[94716, 1886, 351, 13, 70, "ExampleText",
 CellID->180574299],
Cell[CellGroupData[{
Cell[95092, 1903, 951, 30, 70, "Input",
 CellID->316789779],
Cell[96046, 1935, 481, 15, 123, "Output",
 CellID->561135788]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[96588, 1957, 243, 7, 70, "ExampleSection",
 CellID->171865235],
Cell[96834, 1966, 670, 25, 70, "ExampleText",
 CellID->39646764],
Cell[CellGroupData[{
Cell[97529, 1995, 558, 17, 70, "Input",
 CellID->345050852],
Cell[98090, 2014, 381, 12, 123, "Output",
 CellID->162473882]
}, Open  ]],
Cell[CellGroupData[{
Cell[98508, 2031, 666, 21, 70, "Input",
 CellID->70692759],
Cell[99177, 2054, 512, 16, 123, "Output",
 CellID->28442003]
}, Open  ]],
Cell[99704, 2073, 125, 3, 70, "ExampleDelimiter",
 CellID->213286162],
Cell[99832, 2078, 316, 13, 70, "ExampleText",
 CellID->73905729],
Cell[CellGroupData[{
Cell[100173, 2095, 648, 18, 70, "Input",
 CellID->155769764],
Cell[100824, 2115, 777, 21, 91, "Output",
 CellID->134819805]
}, Open  ]],
Cell[101616, 2139, 221, 8, 70, "ExampleText",
 CellID->20135033],
Cell[CellGroupData[{
Cell[101862, 2151, 610, 17, 70, "Input",
 CellID->280633295],
Cell[102475, 2170, 777, 21, 91, "Output",
 CellID->366015835]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103301, 2197, 237, 7, 70, "ExampleSection",
 CellID->263321179],
Cell[103541, 2206, 341, 12, 70, "ExampleText",
 CellID->317821917],
Cell[103885, 2220, 356, 11, 70, "Input",
 CellID->23265022],
Cell[CellGroupData[{
Cell[104266, 2235, 623, 21, 70, "Input",
 CellID->356403487],
Cell[104892, 2258, 521, 13, 70, "Output",
 Evaluatable->False,
 CellID->640763276]
}, Open  ]],
Cell[105428, 2274, 99, 1, 70, "ExampleText",
 CellID->565702108],
Cell[105530, 2277, 667, 21, 70, "Input",
 CellID->76943909],
Cell[CellGroupData[{
Cell[106222, 2302, 624, 21, 70, "Input",
 CellID->160881123],
Cell[106849, 2325, 521, 13, 70, "Output",
 Evaluatable->False,
 CellID->148413155]
}, Open  ]],
Cell[107385, 2341, 125, 3, 70, "ExampleDelimiter",
 CellID->217763201],
Cell[107513, 2346, 375, 13, 70, "ExampleText",
 CellID->421639415],
Cell[CellGroupData[{
Cell[107913, 2363, 1344, 42, 70, "Input",
 CellID->11750325],
Cell[109260, 2407, 690, 19, 70, "Output",
 CellID->30917263]
}, Open  ]],
Cell[109965, 2429, 125, 3, 70, "ExampleDelimiter",
 CellID->433405789],
Cell[110093, 2434, 85, 1, 70, "ExampleText",
 CellID->24318937],
Cell[CellGroupData[{
Cell[110203, 2439, 514, 16, 70, "Input",
 CellID->280701006],
Cell[110720, 2457, 371, 12, 123, "Output",
 CellID->167850011]
}, Open  ]],
Cell[CellGroupData[{
Cell[111128, 2474, 513, 16, 70, "Input",
 CellID->83166405],
Cell[111644, 2492, 370, 12, 123, "Output",
 CellID->88554038]
}, Open  ]],
Cell[CellGroupData[{
Cell[112051, 2509, 514, 16, 70, "Input",
 CellID->874401875],
Cell[112568, 2527, 371, 12, 123, "Output",
 CellID->732847096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112988, 2545, 230, 7, 70, "ExampleSection",
 CellID->472822334],
Cell[113221, 2554, 140, 2, 70, "ExampleText",
 CellID->318150803],
Cell[CellGroupData[{
Cell[113386, 2560, 681, 21, 70, "Input",
 CellID->453071729],
Cell[114070, 2583, 418, 11, 70, "Output",
 Evaluatable->False,
 CellID->32924722]
}, Open  ]],
Cell[114503, 2597, 268, 8, 70, "ExampleText",
 CellID->22323747],
Cell[CellGroupData[{
Cell[114796, 2609, 773, 23, 70, "Input",
 CellID->288136242],
Cell[115572, 2634, 1342, 26, 70, "Output",
 Evaluatable->False,
 CellID->200403828]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[116963, 2666, 227, 7, 70, "ExampleSection",
 CellID->94384447],
Cell[117193, 2675, 75, 1, 70, "ExampleText",
 CellID->253808967],
Cell[CellGroupData[{
Cell[117293, 2680, 867, 26, 70, "Input",
 CellID->99433156],
Cell[118163, 2708, 66875, 1176, 248, 25211, 488, "CachedBoxData", "BoxData", \
"Output",
 CellID->480868368]
}, Open  ]],
Cell[185053, 3887, 125, 3, 70, "ExampleDelimiter",
 CellID->574602496],
Cell[185181, 3892, 67, 1, 70, "ExampleText",
 CellID->281618892],
Cell[CellGroupData[{
Cell[185273, 3897, 541, 17, 70, "Input",
 CellID->36518387],
Cell[185817, 3916, 78800, 1296, 70, "Output",
 Evaluatable->False,
 CellID->296169792]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[264678, 5219, 311, 9, 70, "SeeAlsoSection",
 CellID->30335],
Cell[264992, 5230, 1404, 53, 70, "SeeAlso",
 CellID->7214]
}, Open  ]],
Cell[CellGroupData[{
Cell[266433, 5288, 319, 9, 70, "MoreAboutSection",
 CellID->228641858],
Cell[266755, 5299, 124, 3, 70, "MoreAbout",
 CellID->602648667]
}, Open  ]],
Cell[266894, 5305, 50, 0, 70, "History"],
Cell[266947, 5307, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

