(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9056,        328]
NotebookOptionsPosition[      6336,        241]
NotebookOutlinePosition[      7714,        280]
CellTagsIndexPosition[      7630,        275]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink Packets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CallPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CallPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CallPacket"], "[", 
       RowBox[{
        StyleBox["integer", "TI"], ",", " ", 
        StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet encapsulating a request to invoke the external function \
numbered ",
     StyleBox["integer", "TI"],
     " with the arguments contained in ",
     StyleBox["list", "TI"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->63122559],

Cell[TextData[{
 "Start a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-compatible external program:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->1817547057],

Cell[BoxData[
 RowBox[{
  RowBox[{"link", " ", "=", " ", 
   RowBox[{"Install", "[", 
    RowBox[{
    "$InstallationDirectory", "<>", " ", 
     "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID", 
     "<>", "\"\</PrebuiltExamples/addtwo\>\""}], "]"}]}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->576167007],

Cell[TextData[{
 "Write a ",
 Cell[BoxData[
  ButtonBox["CallPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CallPacket"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellContext->"Global`",
 CellID->1342059649],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"CallPacket", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->84037609],

Cell["Read the result:", "ExampleText",
 CellContext->"Global`",
 CellID->975776302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->1523338384],

Cell[BoxData["3"], "Output",
 CellContext->"Global`",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->128200817]
}, Open  ]],

Cell["Terminate the external program:", "ExampleText",
 CellContext->"Global`",
 CellID->1705992071],

Cell[BoxData[
 RowBox[{
  RowBox[{"Uninstall", "[", "link", "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->748324558]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["MathLink Packets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkPackets"]], "MoreAbout",
 CellID->533130485]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CallPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 0.0063680}", "context" -> "System`", 
    "keywords" -> {
     "MathLink packet", "input packet", "call packet", 
      "call external program"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CallPacket[integer, list] is a MathLink packet encapsulating a request \
to invoke the external function numbered integer with the arguments contained \
in list.", "synonyms" -> {"call packet"}, "title" -> "CallPacket", "type" -> 
    "Symbol", "uri" -> "ref/CallPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2761, 93, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7496, 268}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1270, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1893, 60, 53, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1949, 63, 775, 25, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2761, 93, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3138, 107, 147, 5, 70, "ExampleSection",
 CellID->63122559],
Cell[3288, 114, 172, 7, 70, "ExampleText",
 CellID->1817547057],
Cell[3463, 123, 361, 10, 70, "Input",
 CellID->576167007],
Cell[3827, 135, 221, 9, 70, "ExampleText",
 CellID->1342059649],
Cell[4051, 146, 271, 9, 70, "Input",
 CellID->84037609],
Cell[4325, 157, 84, 2, 70, "ExampleText",
 CellID->975776302],
Cell[CellGroupData[{
Cell[4434, 163, 133, 4, 70, "Input",
 CellID->1523338384],
Cell[4570, 169, 183, 6, 36, "Output",
 CellID->128200817]
}, Open  ]],
Cell[4768, 178, 100, 2, 70, "ExampleText",
 CellID->1705992071],
Cell[4871, 182, 151, 5, 70, "Input",
 CellID->748324558]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5071, 193, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[5392, 204, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[5800, 220, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[6121, 231, 143, 3, 70, "MoreAbout",
 CellID->533130485]
}, Open  ]],
Cell[6279, 237, 27, 0, 70, "History"],
Cell[6309, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

