(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38552,       1395]
NotebookOptionsPosition[     30403,       1111]
NotebookOutlinePosition[     31907,       1152]
CellTagsIndexPosition[     31821,       1147]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultiplicativeOrder" :> 
          Documentation`HelpLookup["paclet:ref/MultiplicativeOrder"], 
          "EulerPhi" :> Documentation`HelpLookup["paclet:ref/EulerPhi"], 
          "PrimitiveRoot" :> 
          Documentation`HelpLookup["paclet:ref/PrimitiveRoot"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MultiplicativeOrder\"\>", 
       2->"\<\"EulerPhi\"\>", 3->"\<\"PrimitiveRoot\"\>", 
       4->"\<\"RealDigits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumberTheoreticFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Number Theoretic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CarmichaelLambda", "ObjectName",
 CellID->8944],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CarmichaelLambda",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CarmichaelLambda"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Carmichael function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Lambda]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
     
     ", defined as the smallest integer ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " such ",
     "that ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["k", "m"], "\[Congruent]", 
        RowBox[{"1", "mod", " ", "n"}]}], TraditionalForm]], "InlineMath"],
     " for",
     " all ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " relatively prime to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1108]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CarmichaelLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109605947],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->146514837],

Cell[TextData[{
 "The first ten values of ",
 Cell[BoxData[
  ButtonBox["CarmichaelLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->98253434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CarmichaelLambda", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62667681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "2", 
   ",", "6", ",", "4"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54012284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->826716010],

Cell["Plot the Carmichael function:", "ExampleText",
 CellID->602932466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"CarmichaelLambda", "[", "k", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205095220],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdkzlOA0EQRUdEhAQEBASAEEIIIRazL27MvuMBG5MiOeYKdbQ+EkcwiHrB
/yNZred5XVtPL359t+OppmnGv7+/9f/56Tb6FP1/2nimqDdrPFfUm7f3C+Yt
2ftle79i8VbNW7P96+ZtWLxNi7dlvG3eju3vmLdr+/fM37d6D8w7tPqPLM9x
rvRzYvlPLd+ZeV2rr6gXMOdyrvUGzDx6Wk/A5L9QL2DqvbT9MPVdqRcw8a/V
C5j53lh8mHnfqhcw+e8sPsx53Oea8wiY83lQL2D6f9R4AdPfk/oBc57P6gVM
/S/qBcx38ar5Ckw/cPZTYebbV6/0bT+c864w82nVK63WE616Fe7l+pZrzq/A
zAvOfitM/nf1SjLzCzjPrcJ8pwP1ysDqh3MeFeY7Huaa51lg7ttQvQpT/4dy
gXPeAdM/zD0Y5drL/XDe/xipV2Hq/9T4Be6UCbAaemw=
   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
      73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101}]}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 101.}, {0., 96.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139402677]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20725],

Cell["Evaluate for moderately large integers:", "ExampleText",
 CellID->244368892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"10", "^", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103031014],

Cell[BoxData["61374502307593387215614399390927711184898309578085"], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166888801]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CarmichaelLambda", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532446926],

Cell[BoxData["752704820471523284996621112295385544268706966560"], "Output",
 ImageSize->{372, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->888211200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446210747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CarmichaelLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->194856546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CarmichaelLambda", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44822988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->830496938]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27382],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CarmichaelLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFormula"],
 " works for negative integers:"
}], "ExampleText",
 CellID->405071879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CarmichaelLambda", "[", 
    RowBox[{"-", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535290836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "2", 
   ",", "6", ",", "4", ",", "10", ",", "2"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418872340]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24278],

Cell[TextData[{
 "Find Carmichael numbers [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/CarmichaelNumber.html"], None}],
 "]:"
}], "ExampleText",
 CellID->52389426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10000", "]"}], ",", 
   RowBox[{"n_", "/;", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"n", ",", 
        RowBox[{"CarmichaelLambda", "[", "n", "]"}]}], "]"}], "\[Equal]", 
      "1"}], "&&", 
     RowBox[{"!", 
      RowBox[{"PrimeQ", "[", "n", "]"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252918260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "561", ",", "1105", ",", "1729", ",", "2465", ",", "2821", ",", "6601", ",",
    "8911"}], "}"}]], "Output",
 ImageSize->{275, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241999622]
}, Open  ]],

Cell["Find their factorization:", "ExampleText",
 CellID->283316848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385867965],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW9uO0zAQdZO0y0XAlideUPcb+Ah44iOqFdLuAwIt+2vAA/BtJU7qbTqd
7Fw8dhxopUadxB7PHI9vZ9KP2/ubT5+397fX26sPd9uvN7fX367ef7lrb9UL
56q3zrl3b1z7e9f+6r7hs2m/B7GXnvtr/VDKNUB+CuRXRPlnQL7MXB/Kc/MP
ypR/UN/U/kG8Y/uv9hfSS/+8asU1Utvfh/XXRuUxa305Kupy2fuaaW9ufCE+
XHyhXO040UHJq/aybEWq3BOkdV/Pe+VvL430Bn31SH2uXmoumDtOy72+/STR
fWpEz4USL9hebryqvX8rpV7Y32P4W8WXfjT6sc+JTk65zorlg7zrQyO2lXGt
Wl+wermxw71KgyCM4moCDFLGHRxVtVA/9Dt9xJ2OXUoL7MOXBAYviOdQH1Ue
Pr/AvBjIcLdJzXzQH2v/sZUpxn8fYyu3XwAH9+Gum/KbsnPqfoftdf6ejA2q
FoUClBedXmo+olqF5akTEIUNpY+aZ6UnMOpEWpr/vHlTes6mrLZGwUd404pU
OegH7r3UOpudnjUmYa2j+g7TUyEolDYSxnYQUn+72bE5yPOLfjyKNWPBw0Ct
XmmiP3Yem/u6YG2vdM/ymD85VgTr/rcbE0MZcg+UlTZjQ+dLGoR0+wfr0ZLS
dnu0c4yfkmIE+gbPW/h5RBoj+FhCcwnNsC3fsF/TsD0OZNSrQbl6byO3Xu0O
LNDlSD3oA5qBiLI+WCGxPlgddlTrkXrQejQfkRx7iFngbSuiPSqeepo8WL5J
Js0t53rOKR/LP/zlnHNVlufmXH+yUKbk0nJyVrkrakxhqKbwIzX+Yzhpc5bf
d9qoKj8HR7EOkowL1p7u1GLtlXXf8BhB7psgY632a8bc8kex+qB/FLMUm++B
z6UZD2k+SppB+eUvs8uYYGsJh3vPzYilxjH4Ld0v/t5N0evDk2iMHh0jIO37
sD+JtdYkx3DiLeQzpAw5LwJKY8SniwRJ+Sx5gaNsUZ5oKInf+zcjIz+nrFs5
ymE4OfVYDCfQ2yjsbxR+1+7AjXIZ2j9dHwSkN8mk2BP/1CzamSU8lvsTH5yz
qFpn1hAvL2MNpainZPli/qGQmnWjxlwunKZiJ+NYRGmUzZMfs9SP1SuDVZy2
b+JYReyfAlTUD+VYlo11phboi31POTfLaM2yUu9h8lhG6exkzRZIy1szO9LT
ZensS+zbuf1ZUhoVYaaJPWvPLRqs+Egr/Kbp/dLnBKl9miiQlM89J8S+ua2L
ijQconVs/M+cJE+rjo2UnpUC76bhGR97k1LLC0L7UvGTWn412M/lV+P4Sbf4
CyVFCuM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{541, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150993481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->408449800],

Cell[TextData[{
 "Find integers ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      TagBox["\[Phi]",
       EulerPhi], 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox["\[Lambda]",
         CarmichaelLambda,
         Editable->False,
         Selectable->False], "(", "k", ")"}], ")"}]}], "-", 
     RowBox[{
      InterpretationBox["\[Lambda]",
       CarmichaelLambda,
       Editable->False,
       Selectable->False], 
      RowBox[{"(", 
       RowBox[{
        TagBox["\[Phi]",
         EulerPhi], 
        RowBox[{"(", "k", ")"}]}], ")"}]}]}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->124718322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"Range", "[", "100", "]"}], ",", 
   RowBox[{"k_", "/;", 
    RowBox[{
     RowBox[{"EulerPhi", "[", 
      RowBox[{"CarmichaelLambda", "[", "k", "]"}], "]"}], "==", " ", 
     RowBox[{"CarmichaelLambda", "[", 
      RowBox[{"EulerPhi", "[", "k", "]"}], "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274138270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "9", 
   ",", "10", ",", "11", ",", "14", ",", "15", ",", "16", ",", "18", ",", 
   "19", ",", "20", ",", "21", ",", "22", ",", "23", ",", "27", ",", "28", 
   ",", "30", ",", "32", ",", "33", ",", "36", ",", "38", ",", "42", ",", 
   "44", ",", "46", ",", "47", ",", "51", ",", "54", ",", "56", ",", "57", 
   ",", "59", ",", "64", ",", "65", ",", "66", ",", "68", ",", "69", ",", 
   "72", ",", "76", ",", "81", ",", "83", ",", "84", ",", "88", ",", "92", 
   ",", "94"}], "}"}]], "Output",
 ImageSize->{410, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217566651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138102618],

Cell["\<\
Build RSA-like toy encryption scheme. Start with the modulus:\
\>", "ExampleText",
 CellID->4075191],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}], "=", 
   RowBox[{"Prime", "[", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"10", "^", "4"}], ",", 
        RowBox[{"10", "^", "5"}]}], "}"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"p", " ", "q"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->108868620],

Cell[BoxData["321092501453"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->750351901]
}, Open  ]],

Cell[TextData[{
 "Find the universal exponent of the multiplication group modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->160103997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Lambda]", "=", 
  RowBox[{"CarmichaelLambda", "[", "n", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22001018],

Cell[BoxData["160545655470"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333517589]
}, Open  ]],

Cell["Private key:", "ExampleText",
 CellID->267478362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"NestWhile", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "+", "1"}], "&"}], " ", ",", 
    RowBox[{"Round", "[", 
     RowBox[{"n", "/", "3"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{"\[Lambda]", ",", "#1"}], "]"}], "=!=", "1"}], "&"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5807272],

Cell[BoxData["107030833819"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6386591]
}, Open  ]],

Cell["Public key:", "ExampleText",
 CellID->315844209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", " ", "=", 
  RowBox[{"PowerMod", "[", 
   RowBox[{"d", ",", 
    RowBox[{"-", "1"}], ",", "\[Lambda]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->206936620],

Cell[BoxData["72489003139"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->352219758]
}, Open  ]],

Cell["Encrypt a message:", "ExampleText",
 CellID->91140030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{
   RowBox[{"ToCharacterCode", "[", "\"\<RSA in Mathematica\>\"", "]"}], ",", 
   "e", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->272105995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "260652363601", ",", "139923645350", ",", "78492697550", ",", "92588920944",
    ",", "71357448180", ",", "251700860879", ",", "92588920944", ",", 
   "228633397838", ",", "275628471430", ",", "143873394525", ",", 
   "169742845190", ",", "148825865672", ",", "93602793393", ",", 
   "275628471430", ",", "143873394525", ",", "71357448180", ",", 
   "137933141413", ",", "275628471430"}], "}"}]], "Output",
 ImageSize->{508, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->135176152]
}, Open  ]],

Cell["Decrypt it:", "ExampleText",
 CellID->471390063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"PowerMod", "[", 
   RowBox[{"%", ",", "d", ",", "n"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5344228],

Cell[BoxData["\<\"RSA in Mathematica\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->759645620]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26561],

Cell[TextData[{
 "Model the Carmichael function based on the definition [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/CarmichaelFunction.html"], None}],
 "]:"
}], "ExampleText",
 CellID->63012057],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]", "[", 
   RowBox[{"n_Integer", "?", "Positive"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "<=", "2"}], ",", "1", ",", 
    RowBox[{"LCM", " ", "@@", " ", 
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"#1", "==", "2"}], "||", 
           RowBox[{"#2", ">", "2"}]}], ",", 
          RowBox[{"2", "^", 
           RowBox[{"(", 
            RowBox[{"#2", "-", "2"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"#1", "^", 
            RowBox[{"(", 
             RowBox[{"#2", "-", "1"}], ")"}]}], 
           RowBox[{"(", 
            RowBox[{"#1", "-", "1"}], ")"}]}]}], "]"}], "&"}], " ", ",", 
       RowBox[{"FactorInteger", "[", "n", "]"}], ",", 
       RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240805664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"\[Lambda]", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->390295997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "1", ",", "4", ",", "2", ",", "6", ",", "2", 
   ",", "6", ",", "4", ",", "10", ",", "2"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->303712317]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CarmichaelLambda", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->143578256],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "2", 
   ",", "6", ",", "4", ",", "10", ",", "2"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24237772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77441029],

Cell[TextData[{
 "Check Carmichael's theorem [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/CarmichaelsTheorem.html"], None}],
 "]:"
}], "ExampleText",
 CellID->113674923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"a", "^", 
     RowBox[{"CarmichaelLambda", "[", "n", "]"}]}], ",", "n"}], "]"}], "/.", 
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"a", "|", "n"}], ",", "Integers"}], "]"}], "&&", 
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{"a", ",", "n"}], "]"}], "\[Equal]", "1"}], "&&", 
     RowBox[{"n", ">", "1"}], "&&", 
     RowBox[{"a", ">", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "n"}], "}"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444172776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276675320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284611692],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["CarmichaelLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->342233892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"a", "^", 
      RowBox[{"CarmichaelLambda", "[", "n", "]"}]}], ",", "n"}], "]"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"a", "|", "n"}], ",", "Integers"}], "]"}], "&&", 
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{"a", ",", "n"}], "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{"n", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121361892],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213414242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8054],

Cell[TextData[{
 "Curious property of ",
 Cell[BoxData[
  ButtonBox["CarmichaelLambda",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CarmichaelLambda"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6885224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"CarmichaelLambda", "[", 
    RowBox[{"10", "^", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106380432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "20", ",", "100", ",", "500", ",", "5000", ",", "50000",
    ",", "500000", ",", "5000000", ",", "50000000", ",", "500000000"}], 
  "}"}]], "Output",
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196857569]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23803],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimitiveRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimitiveRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8192],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->21559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->32621],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/CarmichaelFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/CarmichaelLambda/"]\
, None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
CarmichaelLambda"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->124384408],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->707311457],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->3961784]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CarmichaelLambda - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 9.1941032}", "context" -> "System`", 
    "keywords" -> {
     "Carmichael lambda", "lambda function", "least universal exponent", 
      "linear congruences", "smallest universal exponent", 
      "universal exponent"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CarmichaelLambda[n] gives the Carmichael function \\[Lambda](n), defined \
as the smallest integer m such that k^m \\[Congruent] 1 mod n for all k \
relatively prime to n. ", "synonyms" -> {"carmichael lambda"}, "title" -> 
    "CarmichaelLambda", "type" -> "Symbol", "uri" -> 
    "ref/CarmichaelLambda"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5084, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->109605947]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31678, 1140}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2379, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3002, 83, 53, 1, 70, "ObjectName",
 CellID->8944],
Cell[3058, 86, 1118, 37, 70, "Usage",
 CellID->1108]
}, Open  ]],
Cell[CellGroupData[{
Cell[4213, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4691, 145, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4826, 151, 221, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5084, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109605947],
Cell[CellGroupData[{
Cell[5469, 177, 148, 5, 70, "ExampleSection",
 CellID->146514837],
Cell[5620, 184, 222, 8, 70, "ExampleText",
 CellID->98253434],
Cell[CellGroupData[{
Cell[5867, 196, 217, 7, 28, "Input",
 CellID->62667681],
Cell[6087, 205, 290, 9, 36, "Output",
 CellID->54012284]
}, Open  ]],
Cell[6392, 217, 125, 3, 70, "ExampleDelimiter",
 CellID->826716010],
Cell[6520, 222, 72, 1, 70, "ExampleText",
 CellID->602932466],
Cell[CellGroupData[{
Cell[6617, 227, 334, 10, 70, "Input",
 CellID->205095220],
Cell[6954, 239, 1425, 31, 167, "Output",
 CellID->139402677]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8428, 276, 216, 7, 70, "ExampleSection",
 CellID->20725],
Cell[8647, 285, 82, 1, 70, "ExampleText",
 CellID->244368892],
Cell[CellGroupData[{
Cell[8754, 290, 134, 4, 70, "Input",
 CellID->103031014],
Cell[8891, 296, 208, 5, 36, "Output",
 CellID->166888801]
}, Open  ]],
Cell[CellGroupData[{
Cell[9136, 306, 112, 3, 70, "Input",
 CellID->532446926],
Cell[9251, 311, 206, 5, 36, "Output",
 CellID->888211200]
}, Open  ]],
Cell[9472, 319, 125, 3, 70, "ExampleDelimiter",
 CellID->446210747],
Cell[9600, 324, 226, 7, 70, "ExampleText",
 CellID->194856546],
Cell[CellGroupData[{
Cell[9851, 335, 168, 5, 70, "Input",
 CellID->44822988],
Cell[10022, 342, 213, 7, 36, "Output",
 CellID->830496938]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10284, 355, 239, 7, 70, "ExampleSection",
 CellID->27382],
Cell[10526, 364, 222, 7, 70, "ExampleText",
 CellID->405071879],
Cell[CellGroupData[{
Cell[10773, 375, 238, 8, 70, "Input",
 CellID->535290836],
Cell[11014, 385, 312, 9, 36, "Output",
 CellID->418872340]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11375, 400, 223, 7, 70, "ExampleSection",
 CellID->24278],
Cell[11601, 409, 226, 8, 70, "ExampleText",
 CellID->52389426],
Cell[CellGroupData[{
Cell[11852, 421, 422, 14, 70, "Input",
 CellID->252918260],
Cell[12277, 437, 281, 9, 36, "Output",
 CellID->241999622]
}, Open  ]],
Cell[12573, 449, 68, 1, 70, "ExampleText",
 CellID->283316848],
Cell[CellGroupData[{
Cell[12666, 454, 109, 3, 70, "Input",
 CellID->385867965],
Cell[12778, 459, 1562, 30, 70, "Output",
 Evaluatable->False,
 CellID->150993481]
}, Open  ]],
Cell[14355, 492, 125, 3, 70, "ExampleDelimiter",
 CellID->408449800],
Cell[14483, 497, 760, 31, 70, "ExampleText",
 CellID->124718322],
Cell[CellGroupData[{
Cell[15268, 532, 386, 11, 70, "Input",
 CellID->274138270],
Cell[15657, 545, 735, 15, 71, "Output",
 CellID->217566651]
}, Open  ]],
Cell[16407, 563, 125, 3, 70, "ExampleDelimiter",
 CellID->138102618],
Cell[16535, 568, 110, 3, 70, "ExampleText",
 CellID->4075191],
Cell[CellGroupData[{
Cell[16670, 575, 480, 17, 70, "Input",
 CellID->108868620],
Cell[17153, 594, 169, 5, 36, "Output",
 CellID->750351901]
}, Open  ]],
Cell[17337, 602, 184, 6, 70, "ExampleText",
 CellID->160103997],
Cell[CellGroupData[{
Cell[17546, 612, 142, 4, 70, "Input",
 CellID->22001018],
Cell[17691, 618, 169, 5, 36, "Output",
 CellID->333517589]
}, Open  ]],
Cell[17875, 626, 55, 1, 70, "ExampleText",
 CellID->267478362],
Cell[CellGroupData[{
Cell[17955, 631, 395, 14, 70, "Input",
 CellID->5807272],
Cell[18353, 647, 167, 5, 36, "Output",
 CellID->6386591]
}, Open  ]],
Cell[18535, 655, 54, 1, 70, "ExampleText",
 CellID->315844209],
Cell[CellGroupData[{
Cell[18614, 660, 194, 6, 70, "Input",
 CellID->206936620],
Cell[18811, 668, 168, 5, 36, "Output",
 CellID->352219758]
}, Open  ]],
Cell[18994, 676, 60, 1, 70, "ExampleText",
 CellID->91140030],
Cell[CellGroupData[{
Cell[19079, 681, 209, 6, 70, "Input",
 CellID->272105995],
Cell[19291, 689, 579, 13, 88, "Output",
 CellID->135176152]
}, Open  ]],
Cell[19885, 705, 54, 1, 70, "ExampleText",
 CellID->471390063],
Cell[CellGroupData[{
Cell[19964, 710, 180, 5, 70, "Input",
 CellID->5344228],
Cell[20147, 717, 184, 5, 36, "Output",
 CellID->759645620]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20380, 728, 233, 7, 70, "ExampleSection",
 CellID->26561],
Cell[20616, 737, 258, 8, 70, "ExampleText",
 CellID->63012057],
Cell[20877, 747, 932, 28, 70, "Input",
 CellID->240805664],
Cell[CellGroupData[{
Cell[21834, 779, 211, 7, 70, "Input",
 CellID->390295997],
Cell[22048, 788, 312, 9, 36, "Output",
 CellID->303712317]
}, Open  ]],
Cell[CellGroupData[{
Cell[22397, 802, 218, 7, 70, "Input",
 CellID->143578256],
Cell[22618, 811, 311, 9, 36, "Output",
 CellID->24237772]
}, Open  ]],
Cell[22944, 823, 124, 3, 70, "ExampleDelimiter",
 CellID->77441029],
Cell[23071, 828, 232, 8, 70, "ExampleText",
 CellID->113674923],
Cell[CellGroupData[{
Cell[23328, 840, 637, 20, 70, "Input",
 CellID->444172776],
Cell[23968, 862, 291, 9, 36, "Output",
 CellID->276675320]
}, Open  ]],
Cell[24274, 874, 125, 3, 70, "ExampleDelimiter",
 CellID->284611692],
Cell[24402, 879, 371, 13, 70, "ExampleText",
 CellID->342233892],
Cell[CellGroupData[{
Cell[24798, 896, 509, 16, 70, "Input",
 CellID->121361892],
Cell[25310, 914, 158, 5, 36, "Output",
 CellID->213414242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25517, 925, 223, 7, 70, "ExampleSection",
 CellID->8054],
Cell[25743, 934, 217, 8, 70, "ExampleText",
 CellID->6885224],
Cell[CellGroupData[{
Cell[25985, 946, 254, 8, 70, "Input",
 CellID->106380432],
Cell[26242, 956, 342, 10, 36, "Output",
 CellID->196857569]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26645, 973, 311, 9, 70, "SeeAlsoSection",
 CellID->23803],
Cell[26959, 984, 977, 35, 70, "SeeAlso",
 CellID->19421]
}, Open  ]],
Cell[CellGroupData[{
Cell[27973, 1024, 313, 9, 70, "TutorialsSection",
 CellID->8192],
Cell[28289, 1035, 198, 4, 70, "Tutorials",
 CellID->21559]
}, Open  ]],
Cell[CellGroupData[{
Cell[28524, 1044, 321, 9, 70, "RelatedLinksSection",
 CellID->32621],
Cell[28848, 1055, 189, 4, 70, "RelatedLinks"],
Cell[29040, 1061, 208, 4, 70, "RelatedLinks"],
Cell[29251, 1067, 394, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29682, 1085, 319, 9, 70, "MoreAboutSection",
 CellID->124384408],
Cell[30004, 1096, 164, 3, 70, "MoreAbout",
 CellID->707311457],
Cell[30171, 1101, 160, 3, 70, "MoreAbout",
 CellID->3961784]
}, Open  ]],
Cell[30346, 1107, 27, 0, 70, "History"],
Cell[30376, 1109, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

