(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37734,       1272]
NotebookOptionsPosition[     31334,       1054]
NotebookOutlinePosition[     32570,       1090]
CellTagsIndexPosition[     32484,       1085]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Glaisher" :> Documentation`HelpLookup["paclet:ref/Glaisher"], 
          "Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"], "PolyLog" :> 
          Documentation`HelpLookup["paclet:ref/PolyLog"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Glaisher\"\>", 2->"\<\"Zeta\"\>", 
       3->"\<\"PolyLog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Catalan", "ObjectName",
 CellID->30729],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Catalan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
     "\[LineSeparator]is Catalan\[CloseCurlyQuote]s constant, with numerical \
value ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[TildeEqual]", "0.915966"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28028]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Mathematical constant treated as numeric by ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and as a constant by ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->930],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 " can be evaluated to any numerical precision using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20640],

Cell[TextData[{
 "Catalan\[CloseCurlyQuote]s constant is given by the sum ",
 Cell[BoxData[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "0"}], "\[Infinity]",
    LimitsPositioning->True], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "k"}], "+", "1"}], ")"}], 
     RowBox[{"-", "2"}]]}]}]], "InlineMath"],
 "."
}], "Notes",
 CellID->8839]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->519664136],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->863310002],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->10377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Catalan", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28488],

Cell[BoxData["0.\
9159655941772190150546035149323841107741493742816721342664981196218`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405429946]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17938],

Cell["Use in an exact numerical computation:", "ExampleText",
 CellID->24281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Catalan", "^", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18700],

Cell[BoxData["6488"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85569530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->591454986],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->481580837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catalan", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->810624226],

Cell[BoxData[
 FormBox[
  TagBox["C",
   Function[{}, Catalan]], TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->268864355]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "The first 20 digits of ",
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 " in base 10:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"Catalan", ",", "10", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "9", ",", "1", ",", "5", ",", "9", ",", "6", ",", "5", ",", "5", ",", "9",
      ",", "4", ",", "1", ",", "7", ",", "7", ",", "2", ",", "1", ",", "9", 
     ",", "0", ",", "1", ",", "5", ",", "0", ",", "5"}], "}"}], ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21975875]
}, Open  ]],

Cell[TextData[{
 "20 digits after the first 1000 digits of ",
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 " in base 10:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"Catalan", ",", "10", ",", "20", ",", " ", 
   RowBox[{"-", "1001"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "4", ",", "9", ",", "5", ",", "6", ",", "5", ",", "3", ",", "7", ",", "5",
      ",", "9", ",", "6", ",", "7", ",", "3", ",", "9", ",", "4", ",", "9", 
     ",", "4", ",", "3", ",", "5", ",", "4", ",", "7"}], "}"}], ",", 
   RowBox[{"-", "1000"}]}], "}"}]], "Output",
 ImageSize->{432, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->292543357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Catalan", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "10", ",", "1", ",", "8", ",", "1", ",", "88", ",", "4",
    ",", "1", ",", "1", ",", "7", ",", "22", ",", "1", ",", "2", ",", "3", 
   ",", "26", ",", "1", ",", "11", ",", "1", ",", "10"}], "}"}]], "Output",
 ImageSize->{413, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->835404039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Frequency of coprime Gaussian integers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Boole", "[", 
       RowBox[{"CoprimeQ", "[", 
        RowBox[{
         RowBox[{"a", "+", 
          RowBox[{"I", " ", "b"}]}], ",", 
         RowBox[{"c", "+", 
          RowBox[{"I", " ", "d"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "]"}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144238090],

Cell[BoxData["0.6642088430232259`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259998058]
}, Open  ]],

Cell["Compare with the exact asymptotic result:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"6", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Pi", "^", "2"}], " ", "Catalan"}], ")"}]}], "//", 
  "N"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0.6637008046138535`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->559112787]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Various symbolic relations are automatically used:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catalan", "<", "1"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321096866]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->601202647],

Cell[TextData[{
 "Many mathematical functions and operations give results involving ",
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->343949296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LerchPhi", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"Zeta", "[", 
     RowBox[{"2", ",", 
      RowBox[{"1", "/", "4"}]}], "]"}], "-", 
    RowBox[{"Zeta", "[", 
     RowBox[{"2", ",", 
      RowBox[{"3", "/", "4"}]}], "]"}]}], ",", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"3", "/", "2"}]}], "}"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186264226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", " ", "Catalan"}], ",", 
   RowBox[{"16", " ", "Catalan"}], ",", "Catalan"}], "}"}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99251660]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "k"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "k"}], "+", "1"}], ")"}], "2"]]}], ",", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     RowBox[{
      SuperscriptBox["4", "k"], " ", 
      SuperscriptBox[
       RowBox[{"k", "!"}], "2"]}], 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", " ", "k"}], ")"}], "!"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "k"}], "+", "1"}], ")"}], "2"]}]]}], ",", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "\[Infinity]"], 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["3", "k"], "-", "1"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"k", "+", "1"}], ")"}], " ", 
      RowBox[{"Zeta", "[", 
       RowBox[{"k", "+", "2"}], "]"}]}], 
     SuperscriptBox["4", "k"]]}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74284246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Catalan", ",", 
   RowBox[{"2", " ", "Catalan"}], ",", 
   RowBox[{"16", " ", "Catalan"}]}], "}"}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3638521]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", " ", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     FractionBox["\[Pi]", "4"]], 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"Tan", "[", "t", "]"}], "]"}], 
     RowBox[{"\[DifferentialD]", "t"}]}]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     FractionBox["\[Pi]", "2"]], 
    RowBox[{
     FractionBox["t", 
      RowBox[{"Sin", "[", "t", "]"}]], 
     RowBox[{"\[DifferentialD]", "t"}]}]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"t", "/", "2"}]], " ", "t"}], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "t"], "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "t"}]}]}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23941909],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "Catalan"}], ",", 
   RowBox[{"2", " ", "Catalan"}], ",", 
   RowBox[{"4", " ", "Catalan"}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99575388]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "It is currently not known if ",
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 " is an algebraic number:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"Catalan", ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Catalan", "\[Element]", "Algebraics"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99627853]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot a random walk corresponding to the binary digits of ",
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", 
    RowBox[{"First", "[", 
     RowBox[{"RealDigits", "[", 
      RowBox[{"Catalan", ",", "2", ",", "200"}], "]"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlktOFkEYRSuOHDJgwIBB+8cYY4jx/VYKRUEUQVREXjYoiCO38C2ld2IN
XUYvwSWo+e8x+S4JqRxObt2q6qbSF45/bJ2cK6X8+vv7b5z+/F7U+FN/qBrb
dDgvPi+eMT9rfs78vPnO/KTm/ovmL1n+snhGfEU8K14Qz4mvmr9m+evmb5i/
af6WzX9bPC++Y/6u5e/Z/PfNPzD/UMz+H5l/bPkn1r9o66vibspRzS+ZXzL/
NM8fMP3P8voCZv3LYj3fWDb/3DzM+/HCPEx+xfyK+VXzq+Zf2vph9rdmfs38
K/Mw87+2fpj9rZtfN/8GP/0JmP/jDfMb5jezr5vZx38/HZv58jb7CuueCFj3
RIO5J7ayr1vZh/lmvryzPEy/+QaTf69R91SFdU8FrHuqmS8fsq/wRHlY91gz
X7azr9vZB0w/TP9H64fJw/SbLzuW38k+zDeY/k8aOT+Y5wdz/ubLbvZ1N/uA
NX8zX/Ysv5d9wOTNl31b/372AbN+8+XA+g+yD5h+mPM71Mj5H2YfMHnz5bPl
4Yny5htMvs++g5WvsN6f3nxYfoA1f4O1/hHm/I6y746yr7DOtzcflh9g+s2P
5stxXn8HT9QPs3/zYfkBph+mH2b/X7LvYOUrrPl7mH7zg/kGa/2j+fI15zuY
fvM9TD+s+QdY32kN1nfaCPOddpJ9BytfYc7ffFh+gDV/g/UdOJovp9l3p9lX
WPP3MP0w+4cn6od1fiPM+/dNI88f5v0338PcDzDPH6Yf5vnDfEefaeT8z7Kv
5ntY5xPmB/PN/Gi+fNe4UP8AkfcelA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{Automatic, Automatic},
  PlotRange->{{0., 200.}, {-8., 14.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->29620053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Terms in the continued fraction:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"ContinuedFraction", "[", 
    RowBox[{"Catalan", ",", "400"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd2EuyFEUYxfHUEcMaOHDgIK0gDMMwjPat+CBVEAWV8spLBSxRFHlICwg6
yyX0EnIJvYRcQi+hltBLMIw+fyK+cycZv3u+zKysyqqu7hdv3D+6+WxKafNM
Sv+3h7/9yRT/Svz/Mfm42sHy5+Ss9nnLX5AvWR3jjFZ/3PxSieO8rPYdta9Y
/aslruO1EtexUntC7evW/40S533T8rdKPM63Lee4RrXv2vzvWf375hPmD8wf
mj8yfyyz/pPmEusrZr2fWG5On1qOue6fWY65bqcsx+yH02p1vevpWJ8+t/6Y
9Z1Rq31Zz8T69IXleFT7pY1vTmctN6dzGlfntZ6z9X1l/c3pa1n7pWLus28s
x6z/vI1/3vIp5mWKebW8Y+6/b9XqehfM8WD6W56OostRrK/mjjn+7+z4se77
annHnP8L0eVCrK9Y83WrTxdtfqznSL0Y67vVP30O6njLpZhXczeny7Lup3I5
5tXczemKzPm/EvOKWb/Vp+9jfcHaDxXT3+rTDzEv5irnR+pPTv8fbX5zxcxv
ebpawjgFs3+vxvqO2X/XVKd9Ua7Z/Fj3a8fsn+t2/Jj1m7vVp5+sv7li5rc8
zbL2T8ZcD6zPgxnrc7tafcPa/x1rvsXGSz/HPGOeJ5bPWJ/L1fKGWS/W8S2Y
z90banU9MuZ8mmdzxTofzcbrWPtpsfr0i82POf+Y+c3V3PCo+c2LjZ9+jf0z
5nmE9byfMdff+jes95xu+WJON+P4Get9qmAd74xZP9b1blj7q2POv42Xfovj
ZXPBGn/GvI9gna+GNV+38RbM/L/b/Pj+oS1Y98OMtV8q5v7D7H8bf8E8v2/Z
/FjXr9yK9TPm+mNdr4bZ/zb+gnl/+MPmx3qPL5bPmOez5Q2Pmh9z/2Pen27b
/LdjXiyfzdXcrH+3fMF8z7ijVvsn34n1BbP/Meu3+mbuWPtnsTzdjc6Y+w8z
v7la/4a5/la/WH26F+sz5n3mXqyfsb7HVcsbHjU/5v7H3H9/qtX5yVj7s2D2
P+b6Y+4/69/Ni9Vznz89/1jf24rlM+b8W94wn7+Y9Vt9WkcP5ozVf2V5MU+Y
56Xla8zzy/INHg9ts3xr/TvW+dhZvlj/vTn9FT2YM9b4K8sL1v6ZsPbnbPVr
rN8JquUbczNvzd28k5velxdy7b895neJB3F9g8z3+Pwg1q8w68fjoZ0w7wtY
nxdrzPW3+Tc2fsPaf1vLu/XfYb0fLpbvrX96GI9neBjzbPnK8mKezDPW/Gs8
HtqKtb6N9W/mLdZ+65bvzAvW/bi39aRHMR8w68e6fivM+ylm/1s+W/+15RWz
fjueZsez5XugfofoVr+z+sW8t/nT33H+wZyx+q8w30+wfveZrH7GXH/Lq3lj
buatjdct3+Hx0C6W72196XHMh8cxz5j9b/XF8gnzfdHq15jrb/nG5m82/tbq
u423s/rFvMf8Xvsk9h/MGXP9zQXrd+DJ8tm8NlfzBut4G9b74dbqO9Z6dpjP
e1vP3vqnf6IHc8Yaf2V5MU/m2bw2V6zPy43lDXP9zR1z/bF+118wzz+rT/+q
PVb+AyKdtCI=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286052001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Weyl\[Hyphen]type sum involving ",
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 ":  "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", " ", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], " ", "/@", " ", "\n", 
   "  ", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", 
      RowBox[{"10.", "^", "4"}], 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Catalan", " ", 
         RowBox[{"Sqrt", "[", "k", "]"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"k", ",", " ", "1", ",", " ", "20000"}], "}"}]}], "]"}]}], 
     "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501093745]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8475],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Glaisher",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glaisher"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyLog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3234],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->20367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->24829],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#18538"], None}]], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/CatalansConstant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/Catalan/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Catalan"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3243464],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->216649018]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Catalan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 10.0378748}", "context" -> "System`", 
    "keywords" -> {"Catalan constant"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Catalan is Catalan\\[CloseCurlyQuote]s constant, with numerical value \
\\[TildeEqual] 0.915966. ", "synonyms" -> {}, "title" -> "Catalan", "type" -> 
    "Symbol", "uri" -> "ref/Catalan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4888, 171, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->519664136]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32341, 1078}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1927, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2550, 75, 45, 1, 70, "ObjectName",
 CellID->30729],
Cell[2598, 78, 576, 19, 70, "Usage",
 CellID->28028]
}, Open  ]],
Cell[CellGroupData[{
Cell[3211, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3689, 119, 348, 13, 70, "Notes",
 CellID->930],
Cell[4040, 134, 327, 12, 70, "Notes",
 CellID->20640],
Cell[4370, 148, 481, 18, 70, "Notes",
 CellID->8839]
}, Closed]],
Cell[CellGroupData[{
Cell[4888, 171, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->519664136],
Cell[CellGroupData[{
Cell[5273, 185, 148, 5, 70, "ExampleSection",
 CellID->863310002],
Cell[5424, 192, 66, 1, 70, "ExampleText",
 CellID->10377],
Cell[CellGroupData[{
Cell[5515, 197, 123, 4, 28, "Input",
 CellID->28488],
Cell[5641, 203, 235, 7, 36, "Output",
 CellID->405429946]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5925, 216, 216, 7, 70, "ExampleSection",
 CellID->17938],
Cell[6144, 225, 77, 1, 70, "ExampleText",
 CellID->24281],
Cell[CellGroupData[{
Cell[6246, 230, 152, 5, 70, "Input",
 CellID->18700],
Cell[6401, 237, 160, 5, 36, "Output",
 CellID->85569530]
}, Open  ]],
Cell[6576, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->591454986],
Cell[6704, 250, 203, 7, 70, "ExampleText",
 CellID->481580837],
Cell[CellGroupData[{
Cell[6932, 261, 113, 3, 70, "Input",
 CellID->810624226],
Cell[7048, 266, 240, 8, 50, "Output",
 CellID->268864355]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7337, 280, 207, 6, 70, "ExampleSection"],
Cell[7547, 288, 195, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7767, 299, 127, 3, 70, "Input"],
Cell[7897, 304, 452, 13, 36, "Output",
 CellID->21975875]
}, Open  ]],
Cell[8364, 320, 213, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8602, 331, 164, 4, 70, "Input"],
Cell[8769, 337, 472, 13, 36, "Output",
 CellID->292543357]
}, Open  ]],
Cell[9256, 353, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[9386, 359, 123, 3, 70, "Input"],
Cell[9512, 364, 401, 10, 36, "Output",
 CellID->835404039]
}, Open  ]],
Cell[9928, 377, 105, 2, 70, "ExampleDelimiter"],
Cell[10036, 381, 62, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10123, 385, 843, 27, 70, "Input",
 CellID->144238090],
Cell[10969, 414, 176, 5, 36, "Output",
 CellID->259998058]
}, Open  ]],
Cell[11160, 422, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11249, 426, 181, 7, 70, "Input"],
Cell[11433, 435, 176, 5, 36, "Output",
 CellID->559112787]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11658, 446, 217, 6, 70, "ExampleSection"],
Cell[11878, 454, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11976, 458, 78, 2, 70, "Input"],
Cell[12057, 462, 161, 5, 36, "Output",
 CellID->321096866]
}, Open  ]],
Cell[12233, 470, 125, 3, 70, "ExampleDelimiter",
 CellID->601202647],
Cell[12361, 475, 247, 8, 70, "ExampleText",
 CellID->343949296],
Cell[CellGroupData[{
Cell[12633, 487, 768, 26, 70, "Input",
 CellID->186264226],
Cell[13404, 515, 280, 9, 36, "Output",
 CellID->99251660]
}, Open  ]],
Cell[CellGroupData[{
Cell[13721, 529, 1257, 44, 70, "Input",
 CellID->74284246],
Cell[14981, 575, 279, 9, 36, "Output",
 CellID->3638521]
}, Open  ]],
Cell[CellGroupData[{
Cell[15297, 589, 870, 28, 70, "Input",
 CellID->23941909],
Cell[16170, 619, 298, 10, 36, "Output",
 CellID->99575388]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16517, 635, 210, 6, 70, "ExampleSection"],
Cell[16730, 643, 213, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16968, 654, 121, 3, 70, "Input"],
Cell[17092, 659, 204, 6, 36, "Output",
 CellID->99627853]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17345, 671, 208, 6, 70, "ExampleSection"],
Cell[17556, 679, 218, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17799, 690, 317, 10, 70, "Input"],
Cell[18119, 702, 1384, 32, 239, "Output",
 CellID->29620053]
}, Open  ]],
Cell[19518, 737, 105, 2, 70, "ExampleDelimiter"],
Cell[19626, 741, 55, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19706, 745, 224, 6, 70, "Input"],
Cell[19933, 753, 2013, 40, 133, "Output",
 CellID->286052001]
}, Open  ]],
Cell[21961, 796, 105, 2, 70, "ExampleDelimiter"],
Cell[22069, 800, 195, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22289, 811, 640, 20, 70, "Input"],
Cell[22932, 833, 4869, 84, 70, "Output",
 Evaluatable->False,
 CellID->501093745]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27862, 924, 310, 9, 70, "SeeAlsoSection",
 CellID->8475],
Cell[28175, 935, 686, 26, 70, "SeeAlso",
 CellID->28703]
}, Open  ]],
Cell[CellGroupData[{
Cell[28898, 966, 313, 9, 70, "TutorialsSection",
 CellID->3234],
Cell[29214, 977, 154, 3, 70, "Tutorials",
 CellID->20367]
}, Open  ]],
Cell[CellGroupData[{
Cell[29405, 985, 321, 9, 70, "RelatedLinksSection",
 CellID->24829],
Cell[29729, 996, 251, 5, 70, "RelatedLinks"],
Cell[29983, 1003, 187, 4, 70, "RelatedLinks"],
Cell[30173, 1009, 189, 4, 70, "RelatedLinks"],
Cell[30365, 1015, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30787, 1033, 317, 9, 70, "MoreAboutSection",
 CellID->3243464],
Cell[31107, 1044, 155, 3, 70, "MoreAbout",
 CellID->216649018]
}, Open  ]],
Cell[31277, 1050, 27, 0, 70, "History"],
Cell[31307, 1052, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

