(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18396,        538]
NotebookOptionsPosition[     14946,        426]
NotebookOutlinePosition[     16619,        473]
CellTagsIndexPosition[     16501,        467]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GeneratedCell" :> 
          Documentation`HelpLookup["paclet:ref/GeneratedCell"], 
          "CellEvaluationDuplicate" :> 
          Documentation`HelpLookup["paclet:ref/CellEvaluationDuplicate"], 
          "Deletable" :> Documentation`HelpLookup["paclet:ref/Deletable"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"GeneratedCell\"\>", 
       2->"\<\"CellEvaluationDuplicate\"\>", 
       3->"\<\"Deletable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Options in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/EvaluationOptionsInNotebooks"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation Options in Notebooks\"\>", 
       2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellAutoOverwrite", "ObjectName",
 CellID->12744],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellAutoOverwrite",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellAutoOverwrite"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether new output obtained by evaluating this cell \
should overwrite old output. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Any sequence of cells with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedCell"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " which follow the given cell are assumed to correspond to output. "
}], "Notes",
 CellID->9979],

Cell["\<\
The output is deleted only when new output is ready to be inserted in its \
place. \
\>", "Notes",
 CellID->30855],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CellAutoOverwrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellAutoOverwrite"]], "InlineFormula"],
 " is typically set for cells in ",
 Cell[BoxData["\"\<Output\>\""], "InlineFormula"],
 " style. "
}], "Notes",
 CellID->32317]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->799028405],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->820659880],

Cell[TextData[{
 "Create an input cell with an output cell that has the setting ",
 Cell[BoxData[
  RowBox[{"CellAutoOverwrite", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->82463444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ExpressionCell", "[", 
       RowBox[{
        RowBox[{"Defer", "[", 
         RowBox[{"2", "+", "2"}], "]"}], ",", "\"\<Input\>\""}], "]"}], ",", 
      RowBox[{"ExpressionCell", "[", 
       RowBox[{"4", ",", "\"\<Output\>\"", ",", 
        RowBox[{"CellAutoOverwrite", "\[Rule]", "False"}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108667192],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1TVFUcx3Gafm/6F/pXevhVp6ZpppopcRKtpnFs+qGZZvqhyZ6sJlNB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   "], {{0, 0}, {458, 86}}, {0, 255}],
  ImageSize->{458 0.75, 86 0.75},
  PlotRange->{{0, 458}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->531793625]
}, Open  ]],

Cell["\<\
When the input is evaluated, it creates a new output cell without overwriting \
the old one:\
\>", "ExampleText",
 CellID->462567428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";", 
  RowBox[{"SelectionEvaluateCreateCell", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13202033],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx3E6fZ7Jv9B/pT+e6ujkiXWmEaciaSd17PSBM5npg0xN2th0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   "], {{0, 0}, {458, 110}}, {0, 255}],
  ImageSize->{458 0.75, 110 0.75},
  PlotRange->{{0, 458}, {0, 110}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->597730541]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28943],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneratedCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEvaluationDuplicate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEvaluationDuplicate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deletable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deletable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25467],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->24655]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->259817091],

Cell[TextData[ButtonBox["Evaluation Options in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationOptionsInNotebooks"]], "MoreAbout",
 CellID->552832575],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->784542464]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellAutoOverwrite - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 20.4756420}", "context" -> "System`", 
    "keywords" -> {
     "cell auto-overwrite", "delete old output", "overwrite old output", 
      "replace output"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellAutoOverwrite is an option for Cell which specifies whether new \
output obtained by evaluating this cell should overwrite old output. ", 
    "synonyms" -> {"cell auto overwrite"}, "title" -> "CellAutoOverwrite", 
    "type" -> "Symbol", "uri" -> "ref/CellAutoOverwrite"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4835, 158, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->799028405]},
 "Notebook Image"->{
  Cell[6193, 209, 2748, 48, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->531793625],
  Cell[9354, 276, 3243, 56, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->597730541]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16130, 453},
 {"Notebook Image", 16271, 457}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2161, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2784, 80, 55, 1, 70, "ObjectName",
 CellID->12744],
Cell[2842, 83, 654, 19, 70, "Usage",
 CellID->26841]
}, Open  ]],
Cell[CellGroupData[{
Cell[3533, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4011, 124, 377, 12, 70, "Notes",
 CellID->9979],
Cell[4391, 138, 124, 4, 70, "Notes",
 CellID->30855],
Cell[4518, 144, 280, 9, 70, "Notes",
 CellID->32317]
}, Closed]],
Cell[CellGroupData[{
Cell[4835, 158, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->799028405],
Cell[CellGroupData[{
Cell[5220, 172, 148, 5, 70, "ExampleSection",
 CellID->820659880],
Cell[5371, 179, 281, 9, 70, "ExampleText",
 CellID->82463444],
Cell[CellGroupData[{
Cell[5677, 192, 513, 15, 70, "Input",
 CellID->108667192],
Cell[6193, 209, 2748, 48, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->531793625]
}, Open  ]],
Cell[8956, 260, 143, 4, 70, "ExampleText",
 CellID->462567428],
Cell[CellGroupData[{
Cell[9124, 268, 227, 6, 70, "Input",
 CellID->13202033],
Cell[9354, 276, 3243, 56, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->597730541]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12658, 339, 311, 9, 70, "SeeAlsoSection",
 CellID->28943],
Cell[12972, 350, 738, 26, 70, "SeeAlso",
 CellID->30869]
}, Open  ]],
Cell[CellGroupData[{
Cell[13747, 381, 314, 9, 70, "TutorialsSection",
 CellID->25467],
Cell[14064, 392, 143, 3, 70, "Tutorials",
 CellID->24655]
}, Open  ]],
Cell[CellGroupData[{
Cell[14244, 400, 319, 9, 70, "MoreAboutSection",
 CellID->259817091],
Cell[14566, 411, 171, 3, 70, "MoreAbout",
 CellID->552832575],
Cell[14740, 416, 134, 3, 70, "MoreAbout",
 CellID->784542464]
}, Open  ]],
Cell[14889, 422, 27, 0, 70, "History"],
Cell[14919, 424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

