(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13812,        475]
NotebookOptionsPosition[     10396,        364]
NotebookOutlinePosition[     11766,        402]
CellTagsIndexPosition[     11681,        397]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellFrame" :> Documentation`HelpLookup["paclet:ref/CellFrame"],
           "Background" :> 
          Documentation`HelpLookup["paclet:ref/Background"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellFrame\"\>", 
       2->"\<\"Background\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellDingbat", "ObjectName",
 CellID->8307],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellDingbat",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellDingbat"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies what dingbat to use to emphasize a cell. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17243]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"CellDingbat", "->", "\"\<\>\""}]], "InlineFormula"],
 " displays no dingbat. "
}], "Notes",
 CellID->28679],

Cell["\<\
Dingbats are placed to the left of the main contents of a cell, aligned with \
the first line of the contents. \
\>", "Notes",
 CellID->12106],

Cell["Dingbats are placed outside of any cell frame. ", "Notes",
 CellID->20825],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["CellDingbat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellDingbat"]], "InlineFormula"],
 " can be any string. A typical setting is \"",
 Cell[TextData[ButtonBox["\\[FilledSquare]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/FilledSquare"]], "InlineCharacterName"],
 "\". "
}], "Notes",
 CellID->31893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CellDingbat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellDingbat"]], "InlineFormula"],
 " is often set for styles of cells rather than for individual cells. "
}], "Notes",
 CellID->29654]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246106632],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->639199932],

Cell["Create a cell with a small circle dingbat:", "ExampleText",
 CellID->6094089],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcd \>\"", ",", 
       RowBox[{"{", "50", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellDingbat", "\[Rule]", "\"\<\[SmallCircle]\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149960684],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd \
\>", "Text",
 CellDingbat->"\[SmallCircle]",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->83049345],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278247527],

Cell["The dingbat goes outside the cell frame if the cell has one:", \
"ExampleText",
 CellID->128786448],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcd \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellDingbat", "\[Rule]", "\"\<\[SmallCircle]\>\""}], ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"80", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78591804],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd \
\>", "Text",
 CellFrame->True,
 CellDingbat->"\[SmallCircle]",
 CellMargins->{{80, 12}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->324659431],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7179041],

Cell["A dingbat can be many characters long:", "ExampleText",
 CellID->153509908],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcd \>\"", ",", 
       RowBox[{"{", "50", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellDingbat", "\[Rule]", "\"\<+++++\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335320775],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd \
\>", "Text",
 CellDingbat->"+++++",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->182245928]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18534],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellFrame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Background",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Background"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11550]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23465],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->21020]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->588892071],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->326130916],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->116458687]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellDingbat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 23.3038394}", "context" -> "System`", 
    "keywords" -> {
     "dingbats", "cell symbols", "cell dingbat", "cell icon", "cell glyph", 
      "cell bullet", "bulleted list", "itemized list"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellDingbat is an option for Cell which specifies what dingbat to use to \
emphasize a cell. ", "synonyms" -> {"cell dingbat"}, "title" -> "CellDingbat",
     "type" -> "Symbol", "uri" -> "ref/CellDingbat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4815, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->246106632]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11538, 390}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1949, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2572, 76, 48, 1, 70, "ObjectName",
 CellID->8307],
Cell[2623, 79, 600, 18, 70, "Usage",
 CellID->17243]
}, Open  ]],
Cell[CellGroupData[{
Cell[3260, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3738, 119, 166, 6, 70, "Notes",
 CellID->28679],
Cell[3907, 127, 152, 4, 70, "Notes",
 CellID->12106],
Cell[4062, 133, 80, 1, 70, "Notes",
 CellID->20825],
Cell[4145, 136, 389, 12, 70, "Notes",
 CellID->31893],
Cell[4537, 150, 241, 7, 70, "Notes",
 CellID->29654]
}, Closed]],
Cell[CellGroupData[{
Cell[4815, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246106632],
Cell[CellGroupData[{
Cell[5200, 176, 148, 5, 70, "ExampleSection",
 CellID->639199932],
Cell[5351, 183, 83, 1, 70, "ExampleText",
 CellID->6094089],
Cell[5437, 186, 392, 11, 70, "Input",
 CellID->149960684],
Cell[5832, 199, 379, 9, 70, "Text",
 CellID->83049345],
Cell[6214, 210, 125, 3, 70, "ExampleDelimiter",
 CellID->278247527],
Cell[6342, 215, 105, 2, 70, "ExampleText",
 CellID->128786448],
Cell[6450, 219, 660, 18, 70, "Input",
 CellID->78591804],
Cell[7113, 239, 278, 9, 70, "Text",
 CellID->324659431],
Cell[7394, 250, 123, 3, 70, "ExampleDelimiter",
 CellID->7179041],
Cell[7520, 255, 81, 1, 70, "ExampleText",
 CellID->153509908],
Cell[7604, 258, 383, 11, 70, "Input",
 CellID->335320775],
Cell[7990, 271, 371, 9, 70, "Text",
 CellID->182245928]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8410, 286, 311, 9, 70, "SeeAlsoSection",
 CellID->18534],
Cell[8724, 297, 457, 17, 70, "SeeAlso",
 CellID->11550]
}, Open  ]],
Cell[CellGroupData[{
Cell[9218, 319, 314, 9, 70, "TutorialsSection",
 CellID->23465],
Cell[9535, 330, 143, 3, 70, "Tutorials",
 CellID->21020]
}, Open  ]],
Cell[CellGroupData[{
Cell[9715, 338, 319, 9, 70, "MoreAboutSection",
 CellID->588892071],
Cell[10037, 349, 150, 3, 70, "MoreAbout",
 CellID->326130916],
Cell[10190, 354, 134, 3, 70, "MoreAbout",
 CellID->116458687]
}, Open  ]],
Cell[10339, 360, 27, 0, 70, "History"],
Cell[10369, 362, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

