(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18938,        607]
NotebookOptionsPosition[     15391,        494]
NotebookOutlinePosition[     16843,        533]
CellTagsIndexPosition[     16758,        528]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"], 
          "NotebookEventActions" :> 
          Documentation`HelpLookup["paclet:ref/NotebookEventActions"], 
          "FrontEndEventActions" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndEventActions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"EventHandler\"\>", 
       2->"\<\"NotebookEventActions\"\>", 
       3->"\<\"FrontEndEventActions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Low-Level Interface Control\"\>", 3->"\<\"Stylesheets\"\>", 
       4->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CellEventActions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellEventActions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellEventActions"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " that gives a list of actions to perform when specified events occur in \
connection with a cell in a notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CellEventActions", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ":>", 
      SubscriptBox[
       StyleBox["action", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ":>", 
      SubscriptBox[
       StyleBox["action", "TI"], 
       StyleBox["2", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["action", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be evaluated whenever ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " occurs in connection with a cell."
}], "Notes",
 CellID->24196],

Cell[TextData[{
 "The possible event specifications are the same as for ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14473],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["CellEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellEventActions"]], "InlineFormula"],
 " are often defined at the level of stylesheets, rather than for individual \
cells or notebooks."
}], "Notes",
 CellID->22683],

Cell[TextData[{
 "By default, any action specified for an event by ",
 Cell[BoxData[
  ButtonBox["CellEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellEventActions"]], "InlineFormula"],
 " will override any default action that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would take for that event."
}], "Notes",
 CellID->563375303],

Cell[TextData[{
 "The default behavior can be changed by including rules for ",
 Cell[BoxData[
  ButtonBox["PassEventsDown",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PassEventsDown"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PassEventsUp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PassEventsUp"]], "InlineFormula"],
 " in the list given as the setting for ",
 Cell[BoxData[
  ButtonBox["CellEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellEventActions"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->141044261]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363027958],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->1012969649],

Cell["\<\
Create a cell that will change color when you click within the cell:\
\>", "ExampleText",
 CellID->18352363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"bgd", "=", "LightRed"}], "}"}], ",", 
    RowBox[{"CellPrint", "[", 
     RowBox[{"TextCell", "[", 
      RowBox[{"\"\<Click within this cell\>\"", ",", "\"\<Output\>\"", ",", 
       RowBox[{"Background", "\[Rule]", 
        RowBox[{"Dynamic", "[", "bgd", "]"}]}], ",", 
       RowBox[{"CellEventActions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<MouseClicked\>\"", "\[RuleDelayed]", 
          RowBox[{"(", 
           RowBox[{"bgd", "=", "LightGreen"}], ")"}]}], "}"}]}]}], "]"}], 
     "]"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57681151],

Cell["Click within this cell", "Output",
 CellEventActions->{"MouseClicked" :> ($CellContext`bgd$104684 = LightGreen)},
 
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Background->Dynamic[$CellContext`bgd$104684],
 CellLabel->"Out[1]=",
 CellID->600978004]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->59553232],

Cell[TextData[{
 "Make an action occur when the ",
 StyleBox["Enter", "KeyEvent"],
 " key is pressed in a cell:"
}], "ExampleText",
 CellID->112206551],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellPrint", "[", 
   RowBox[{"TextCell", "[", 
    RowBox[{
    "\"\<Click in this cell and press Enter\>\"", ",", "\"\<Text\>\"", ",", 
     RowBox[{"CellEventActions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"SelectionMove", "[", 
           RowBox[{
            RowBox[{"InputNotebook", "[", "]"}], ",", "All", ",", 
            "ButtonCell"}], "]"}], ";", 
          RowBox[{"SetOptions", "[", 
           RowBox[{
            RowBox[{"NotebookSelection", "[", 
             RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
            RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "]"}]}], 
         ")"}]}], "}"}]}]}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520577085],

Cell["Click in this cell and press Enter", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellEventActions->{"ReturnKeyDown" :> (SelectionMove[
      InputNotebook[], All, ButtonCell]; SetOptions[
      NotebookSelection[
       InputNotebook[]], Background -> LightGreen])},
 CellID->218660594],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159033537],

Cell["Turn the cell background green when clicking in the cell: ", \
"ExampleText",
 CellID->5406384],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellPrint", "[", 
   RowBox[{"TextCell", "[", 
    RowBox[{"\"\<Click somewhere in the cell\>\"", ",", "\"\<Text\>\"", ",", 
     RowBox[{"CellEventActions", "\[Rule]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"SelectionMove", "[", 
            RowBox[{
             RowBox[{"InputNotebook", "[", "]"}], ",", "All", ",", 
             "ButtonCell"}], "]"}], ";", 
           RowBox[{"SetOptions", "[", 
            RowBox[{
             RowBox[{"NotebookSelection", "[", 
              RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
             RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "]"}]}], 
          ")"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"\"\<MouseUp\>\"", "\[RuleDelayed]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"SelectionMove", "[", 
            RowBox[{
             RowBox[{"InputNotebook", "[", "]"}], ",", "All", ",", 
             "ButtonCell"}], "]"}], ";", 
           RowBox[{"SetOptions", "[", 
            RowBox[{
             RowBox[{"NotebookSelection", "[", 
              RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
             RowBox[{"Background", "\[Rule]", "Inherited"}]}], "]"}]}], 
          ")"}]}]}], "}"}]}]}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264005245],

Cell["Click somewhere in the cell", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellEventActions->{"MouseDown" :> (SelectionMove[
      InputNotebook[], All, ButtonCell]; SetOptions[
      NotebookSelection[
       InputNotebook[]], Background -> LightGreen]), 
   "MouseUp" :> (SelectionMove[
      InputNotebook[], All, ButtonCell]; SetOptions[
      NotebookSelection[
       InputNotebook[]], Background -> Inherited])},
 Background->None,
 CellID->653667328]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17073],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9431]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->50167718],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->15576422],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->181888843],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->3438266],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->768651902]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellEventActions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 30.4915234}", "context" -> "System`", 
    "keywords" -> {
     "cell event handler", "event handler", "context sensitive events", 
      "context sensitive menu", "context dependent actions"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellEventActions is an option for Cell that gives a list of actions to \
perform when specified events occur in connection with a cell in a notebook. \
", "synonyms" -> {"cell event actions"}, "title" -> "CellEventActions", 
    "type" -> "Symbol", "uri" -> "ref/CellEventActions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7798, 241, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->363027958]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16615, 521}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1997, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2620, 73, 1581, 37, 70, "ObjectNameGrid"],
Cell[4204, 112, 665, 19, 70, "Usage",
 CellID->13586]
}, Open  ]],
Cell[CellGroupData[{
Cell[4906, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5384, 153, 910, 29, 70, "Notes",
 CellID->24196],
Cell[6297, 184, 235, 8, 70, "Notes",
 CellID->14473],
Cell[6535, 194, 297, 9, 70, "Notes",
 CellID->22683],
Cell[6835, 205, 361, 11, 70, "Notes",
 CellID->563375303],
Cell[7199, 218, 562, 18, 70, "Notes",
 CellID->141044261]
}, Closed]],
Cell[CellGroupData[{
Cell[7798, 241, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363027958],
Cell[CellGroupData[{
Cell[8183, 255, 149, 5, 70, "ExampleSection",
 CellID->1012969649],
Cell[8335, 262, 118, 3, 70, "ExampleText",
 CellID->18352363],
Cell[CellGroupData[{
Cell[8478, 269, 680, 18, 65, "Input",
 CellID->57681151],
Cell[9161, 289, 299, 8, 36, "Output",
 CellID->600978004]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9509, 303, 219, 7, 70, "ExampleSection",
 CellID->59553232],
Cell[9731, 312, 151, 5, 70, "ExampleText",
 CellID->112206551],
Cell[9885, 319, 848, 22, 70, "Input",
 CellID->520577085],
Cell[10736, 343, 305, 7, 70, "Text",
 CellID->218660594],
Cell[11044, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->159033537],
Cell[11172, 357, 101, 2, 70, "ExampleText",
 CellID->5406384],
Cell[11276, 361, 1448, 35, 70, "Input",
 CellID->264005245],
Cell[12727, 398, 476, 12, 70, "Text",
 CellID->653667328]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13252, 416, 311, 9, 70, "SeeAlsoSection",
 CellID->17073],
Cell[13566, 427, 751, 26, 70, "SeeAlso",
 CellID->9431]
}, Open  ]],
Cell[CellGroupData[{
Cell[14354, 458, 318, 9, 70, "MoreAboutSection",
 CellID->50167718],
Cell[14675, 469, 167, 3, 70, "MoreAbout",
 CellID->15576422],
Cell[14845, 474, 163, 3, 70, "MoreAbout",
 CellID->181888843],
Cell[15011, 479, 132, 3, 70, "MoreAbout",
 CellID->3438266],
Cell[15146, 484, 173, 3, 70, "MoreAbout",
 CellID->768651902]
}, Open  ]],
Cell[15334, 490, 27, 0, 70, "History"],
Cell[15364, 492, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

