(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20179,        572]
NotebookOptionsPosition[     16720,        459]
NotebookOutlinePosition[     18357,        506]
CellTagsIndexPosition[     18239,        500]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>", 
       2->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellGroupData" :> 
          Documentation`HelpLookup["paclet:ref/CellGroupData"], "CellGroup" :> 
          Documentation`HelpLookup["paclet:ref/CellGroup"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellGroupData\"\>", 
       2->"\<\"CellGroup\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controlling Cell Grouping" :> 
          Documentation`HelpLookup[
           "paclet:guide/ControllingCellGrouping"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Controlling Cell Grouping\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellGrouping", "ObjectName",
 CellID->21959],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellGrouping",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellGrouping"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies how cells in the \
notebook should be assembled into groups. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is typically ",
 Cell[BoxData[
  RowBox[{"CellGrouping", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25883],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"CellGrouping", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", cells are automatically grouped in a hierarchical way based on their \
styles. "
}], "Notes",
 CellID->6117],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"CellGrouping", "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 ", cells must be grouped manually, either by setting up explicit ",
 Cell[BoxData[
  ButtonBox["CellGroupData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroupData"]], "InlineFormula"],
 " expressions, or by using the ",
 StyleBox["Group Cells", "MenuName"],
 " menu item in the notebook front end. "
}], "Notes",
 CellID->28900]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131623722],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->366368940],

Cell["Create a notebook with automatic cell grouping:", "ExampleText",
 CellID->781939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<heading\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<text\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"CellGrouping", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467175296],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1T01cex3F29n6n/8L+J84+XKrTTm+6ndmKsyLtTsfZnd7V2YtObXcr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   "], {{0, 0}, {458, 132}}, {0, 255}],
  ImageSize->{458 0.75, 132 0.75},
  PlotRange->{{0, 458}, {0, 132}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->441477420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->316023153],

Cell["Create a notebook with manual cell grouping:", "ExampleText",
 CellID->19401269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<heading\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<text 1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<text 2\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->674011138],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx3E6fd7Jv9D/xOmPh+qYyRObmUaciqSdjJNMnsXpg0xN2kg6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   "], {{0, 0}, {458, 156}}, {0, 255}],
  ImageSize->{458 0.75, 156 0.75},
  PlotRange->{{0, 458}, {0, 156}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->191531319]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1403],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroupData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroupData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroup"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso", " \[EmptyVerySmallSquare] ",
 CellID->49979349]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32579],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->32711],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->21574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Controlling Cell Grouping",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControllingCellGrouping"]], "MoreAbout",
 CellID->26458200]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellGrouping - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 32.7884572}", "context" -> "System`", 
    "keywords" -> {
     "automatic grouping", "grouping", "hierarchy", "manual cell grouping", 
      "automatic cell grouping"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellGrouping is a notebook option which specifies how cells in the \
notebook should be assembled into groups. ", "synonyms" -> {"cell grouping"}, 
    "title" -> "CellGrouping", "type" -> "Symbol", "uri" -> 
    "ref/CellGrouping"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4878, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->131623722]},
 "Notebook Image"->{
  Cell[6002, 204, 3556, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->441477420],
  Cell[10500, 300, 3845, 66, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->191531319]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17867, 486},
 {"Notebook Image", 18008, 490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2092, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2715, 79, 50, 1, 70, "ObjectName",
 CellID->21959],
Cell[2768, 82, 488, 14, 70, "Usage",
 CellID->9600]
}, Open  ]],
Cell[CellGroupData[{
Cell[3293, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3771, 118, 247, 9, 70, "Notes",
 CellID->25883],
Cell[4021, 129, 297, 10, 70, "Notes",
 CellID->6117],
Cell[4321, 141, 520, 16, 70, "Notes",
 CellID->28900]
}, Closed]],
Cell[CellGroupData[{
Cell[4878, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131623722],
Cell[CellGroupData[{
Cell[5263, 176, 148, 5, 70, "ExampleSection",
 CellID->366368940],
Cell[5414, 183, 87, 1, 70, "ExampleText",
 CellID->781939],
Cell[CellGroupData[{
Cell[5526, 188, 473, 14, 70, "Input",
 CellID->467175296],
Cell[6002, 204, 3556, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->441477420]
}, Open  ]],
Cell[9573, 268, 125, 3, 70, "ExampleDelimiter",
 CellID->316023153],
Cell[9701, 273, 86, 1, 70, "ExampleText",
 CellID->19401269],
Cell[CellGroupData[{
Cell[9812, 278, 685, 20, 70, "Input",
 CellID->674011138],
Cell[10500, 300, 3845, 66, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->191531319]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14406, 373, 310, 9, 70, "SeeAlsoSection",
 CellID->1403],
Cell[14719, 384, 495, 17, 70, "SeeAlso",
 CellID->49979349]
}, Open  ]],
Cell[CellGroupData[{
Cell[15251, 406, 314, 9, 70, "TutorialsSection",
 CellID->32579],
Cell[15568, 417, 428, 12, 70, "Tutorials",
 CellID->32711],
Cell[15999, 431, 151, 3, 70, "Tutorials",
 CellID->21574]
}, Open  ]],
Cell[CellGroupData[{
Cell[16187, 439, 299, 8, 70, "MoreAboutSection"],
Cell[16489, 449, 159, 3, 70, "MoreAbout",
 CellID->26458200]
}, Open  ]],
Cell[16663, 455, 27, 0, 70, "History"],
Cell[16693, 457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

