(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47649,       1178]
NotebookOptionsPosition[     41653,        986]
NotebookOutlinePosition[     44193,       1055]
CellTagsIndexPosition[     44073,       1049]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellLabel" :> Documentation`HelpLookup["paclet:ref/CellLabel"],
           "ShowCellLabel" :> 
          Documentation`HelpLookup["paclet:ref/ShowCellLabel"], "CellTags" :> 
          Documentation`HelpLookup["paclet:ref/CellTags"], 
          "CellAutoOverwrite" :> 
          Documentation`HelpLookup["paclet:ref/CellAutoOverwrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellLabel\"\>", 
       2->"\<\"ShowCellLabel\"\>", 3->"\<\"CellTags\"\>", 
       4->"\<\"CellAutoOverwrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Mathematica Session History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellLabelAutoDelete", "ObjectName",
 CellID->27683],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellLabelAutoDelete",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellLabelAutoDelete"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether a label for the cell should be automatically \
deleted if the contents of the cell are modified or the notebook containing \
the cell is saved in a file. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1914]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Cell styles that represent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output typically have ",
 Cell[BoxData[
  RowBox[{"CellLabelAutoDelete", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8765],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CellLabelAutoDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellLabelAutoDelete"]], "InlineFormula"],
 " is more often set for styles of cells than for individual cells. "
}], "Notes",
 CellID->16523]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13705362],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->378353710],

Cell[TextData[{
 "Create a notebook with the setting ",
 Cell[BoxData[
  RowBox[{"CellLabelAutoDelete", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->291822870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ExpressionCell", "[", 
        RowBox[{
         RowBox[{"Defer", "[", 
          RowBox[{"1", "+", "1"}], "]"}], ",", "\"\<Input\>\""}], "]"}], ",", 
       
       RowBox[{"ExpressionCell", "[", 
        RowBox[{
         RowBox[{"Defer", "[", 
          RowBox[{"2", "+", "2"}], "]"}], ",", "\"\<Input\>\""}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"CellLabelAutoDelete", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166381362],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9vU1Ucx/EZnxv/Bf8VfzzVYEwMmggjMlBDCMYHJiY+MAIqYkRg48cY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   "], {{0, 0}, {458, 87}}, {0, 255}],
  ImageSize->{458 0.75, 87 0.75},
  PlotRange->{{0, 458}, {0, 87}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->237814921]
}, Open  ]],

Cell["\<\
When inputs are evaluated, cell labels are attached to the input and output \
cells:\
\>", "ExampleText",
 CellID->19460398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}], ";", 
  RowBox[{"SelectionEvaluate", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177852241],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx3E6fd7Jv9B/pT+e6ujkiXWmEaciaSfD0OkDZzrTB5matDHp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   "], {{0, 0}, {458, 140}}, {0, 255}],
  ImageSize->{458 0.75, 140 0.75},
  PlotRange->{{0, 458}, {0, 140}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->154692385]
}, Open  ]],

Cell["\<\
If you edit a previously evaluated input cell, its cell label is cleared:\
\>", "ExampleText",
 CellID->324742581],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1PVNkdx3Ga/t7sv9B/pQ+/ajT7izXpiqnIttkQmv5g0qQ/bOpuu+42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   "], {{0, 0}, {458, 140}}, {0, 255}],
  ImageSize->{458 0.75, 140 0.75},
  PlotRange->{{0, 458}, {0, 140}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->814087675],

Cell["\<\
When the notebook is saved, cell labels are automatically deleted:\
\>", "ExampleText",
 CellID->55472839],

Cell[BoxData[
 RowBox[{"NotebookSave", "[", 
  RowBox[{"nb", ",", 
   RowBox[{
   "$TemporaryPrefix", "<>", 
    "\"\<mathematica-celllabelautodelete-test.nb\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->391184252],

Cell[BoxData[
 RowBox[{"NotebookClose", "[", "nb", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->93481515],

Cell["When the notebook is reopened, no cell labels are present:", \
"ExampleText",
 CellID->161669632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{
    "$TemporaryPrefix", "<>", 
     "\"\<mathematica-celllabelautodelete-test.nb\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->503419033],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9vFMcdx3FXfV7lX+i/0rRPQaA8IUgNRsU4rSKLqg+QKvVBVJI2JFUJ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   "], {{0, 0}, {458, 140}}, {0, 255}],
  ImageSize->{458 0.75, 140 0.75},
  PlotRange->{{0, 458}, {0, 140}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->191662036]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5191],

Cell[TextData[{
 "Create a notebook with the setting ",
 Cell[BoxData[
  RowBox[{"CellLabelAutoDelete", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20586872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ExpressionCell", "[", 
        RowBox[{
         RowBox[{"Defer", "[", 
          RowBox[{"1", "+", "1"}], "]"}], ",", "\"\<Input\>\""}], "]"}], ",", 
       
       RowBox[{"ExpressionCell", "[", 
        RowBox[{
         RowBox[{"Defer", "[", 
          RowBox[{"2", "+", "2"}], "]"}], ",", "\"\<Input\>\""}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"CellLabelAutoDelete", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60498517],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlFUcx3Ga7pv+hf6VftzW2HRjNSlOotU0jk0XzTTTRZNamU2mgj8Q
kwDTKAWSFAORH+uy4IIsyILsWrA6ofhbHAnodJ49u2fP8+y6rssea3rer/nI
nO95znm8+8wOKj63ZsOra54uKyt7U/4KPVVW5qwrKj4hhBBiIwuLS4QQQkoY
3a4/HD5FCCGkJPG067/+EZoQQv4HydmuAgCwDBXp77XSrgBQQrQrANhAuwKA
DbQrANhAuwKADbQrANhAuwKADbQrANhAuwKADbQrANhAuwKADbQrANhAuwKA
DbQrANhAuwJA0T78uOWll/eorFh5wHxEuwJASciCNUfaFQBKgnYFABv81q5l
bjkPFHcRAEz+bNf8B4q7CAAmv7WreHhPFvKxloIFUCAftqvI25OP/GRLwQIo
hD/bVeT9BFvcRQAw+a1ddTc+bkkWfRGAP9Guti8C8KHJ+Kzf2lUYf3r1xC4C
8BVZreqfxJqbfmhXALBHVevde/O0KwCUiq5W4b/vuwKAJWa1CtoVAEqkqjqw
8aNm/RMI129oNJ/SrgBgA+0KADbQrgBgA+0KADbQrgBgA+0KADbQrgBgA+0K
ADbQrgBgA+0KADbQrgBgA+0KADbQrgBQNPVDs1VWrDxgPqJdAaAk+AmEAGAD
7QoANvitXcuyZB8o7iIAmPzWrkqeesxfm/QqgALRrp7N/B9NaVcABaJdsx8V
dxEATLRr9qPiLgKAiXZ9MhcB+I3f2rXoP/TnbwsAKNxkfNZv7arw2RWAPbJa
1T+JNTd90q4AYImq1rv35mlXACgVXa3Cf993BQBLzGoVtCsAlEhVdWDjR836
JxCu39BoPqVdAcAG2hUAbKBdAcAG2hUAbKBdAcAG2hUAbKBdAcAGs13fe39r
bPL3ppbgl1vrCCGELDMLfy0EgmMbP9he8f422a4y4+NxQgghy4zZruPRaSGW
lpYWCSGELCd/Ly2a7XphdGphYXHu/gOZ+8mk1nPy67we5+ZSB+SmPqzXZu4z
MjIy/kfHx+603dWH97/2fMMrL9S/8mJ25L58Ks+oiw8ezM/Nzet2HT5/6fad
udnrt2ev30p+vZ1e3/Kub5gH9Hm9ecf9lJGRkfE/NRbTac2vvby4Y6f4rlbU
1OTId7XyqTyjLl6/4VzR7To4OHnlz+tTiWtT0zPPPPusmanEzFTiamo9ba6v
yhjHrqUXV/VajZl943zOw5k3Jw+rp2rhveV+ysjIyFjQ6JTYTHJT7cyk99NJ
PZpxbqXfcHFduWg9Lo4eeWhaj8sz6u705WvTiVndrv0DE5OXroxfnFb1JRcq
6TGR2Z/InEkvppKHU2cmXC+ZMkfPyz1P5eg+4Dw1D+d/ysjIyPjIMb1IZDYn
3KOznjLOOG+YqCgXzU3ix0Opv3QlFyp6bG6SZ5JXEhOTiYuxK7pdg33RyOil
85GYajC5GIrEzFEvcm3Gc+4PuV8y5H559tMh91o9NQ/nf8rIyMhY4Hjevc5K
3LwlF952lRqNdbpd1a3hkdjIhT90u8pFfzgaOjemGqxvIBrsj/YNZMb0Ysxc
pxbnon39Y5mxX98aC8nzxuj5DkD2YbUOuk8Gnd/U9VS/WS4YGRkZCx9DA1GZ
vvTXPmc/6uwnG08d1p2m3zBRsVo0HxVH6p14NBwQ9TXi58OyXfvUO89Fw0OT
ul17A6M9gUh3IKIaTC66eyNdgeHU2Ova92x2JTe7e/Xh4cx+IGKO+mLXQw6n
1r3D+q46XMhTRkZGxgLG1I5cZ3ZS+6noTtNvGH97ldOrtftE7V5x0PifCGoq
xf6dYt+3smDH165KXxkOhqKnz5xX7doTGO3oHJRRDdZ+xll3nAmrUe/rmIfT
O2HPwjO2dw62u6+0Oy8J53p5WB1WT/WY/ykjIyNjAWNqpz2174px3vUGp13r
9os928Xu7d7Prju2iW+/Evv3yHbV7+kJjPzSGlTt2t07cqKt7+SpkGowuVBR
44lT/SedhE62heTaGdv6jcPJR85+KHlS38o9eg6bo35h9lPdvQ+7y8jIyPjI
8URmP0enqafZnTa+drWo2bP4zVbdqfNfZ9b3v9giqnZNrF2dvBs60Rbq7Br6
4UhHql17RlpaA8d/DaoGkwsVz+iJ++lZPRr7Z7NHI97R88LHesrIyMj4mGP+
nNVfne+7Vu26s2WzqtN7n2++k4wab27aJHbtlGf03fbT4eqalnS7jh5tOtvU
ErQR1YqlPUkIIU8ssfXlorJy9tNPb276LDtyX1RVxtatVoePNQfbfhvcvuNI
ql27LzT+2PPzTwFCCCGehN95XeytElUylTlSWSn2Vg+8+5Y6/FNj4NfW8Jdb
61S7dnZGag+2N9SdJoQQ4snu6sODa9+Iv7Nmcl15duLry8PryuUZdbj++45j
R4O0KyGElDa0KyGE2AjtSgghNuJp167uSF1t+6GG04QQQpaThvqO5qZMu04n
bsTiV2PxGUIIIcvM5cu3dLsSQggpbWS7/gPQ9HMP
   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->55957527]
}, Open  ]],

Cell["\<\
When inputs are evaluated, cell labels are attached to the input and output \
cells:\
\>", "ExampleText",
 CellID->739722582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}], ";", 
  RowBox[{"SelectionEvaluate", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->516535644],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1TVNcdx3E6/b2Tf6H/Sh9+1dHJL8aZRpyKpJ0MY6Y/ONOZ/pCpSRub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   "], {{0, 0}, {458, 147}}, {0, 255}],
  ImageSize->{458 0.75, 147 0.75},
  PlotRange->{{0, 458}, {0, 147}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->126071168]
}, Open  ]],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  ButtonBox["CellLabelAutoDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellLabelAutoDelete"]], "InlineFormula"],
 " is turned off, editing an input does not reset its cell label:"
}], "ExampleText",
 CellID->268264821],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etvFNcZx3FXfV/lX+i/0stbEChvCFKDUTFOq8gi6gukSn0RlaQNTVUC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   "], {{0, 0}, {458, 147}}, {0, 255}],
  ImageSize->{458 0.75, 147 0.75},
  PlotRange->{{0, 458}, {0, 147}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->276639865],

Cell["Neither does saving and reopening the notebook:", "ExampleText",
 CellID->673603357],

Cell[BoxData[
 RowBox[{"NotebookSave", "[", 
  RowBox[{"nb", ",", 
   RowBox[{
   "$TemporaryPrefix", "<>", 
    "\"\<mathematica-celllabelautodelete-test.nb\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->124307285],

Cell[BoxData[
 RowBox[{"NotebookClose", "[", "nb", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->73554569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{
    "$TemporaryPrefix", "<>", 
     "\"\<mathematica-celllabelautodelete-test.nb\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->385740490],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1vFMcdx3FX/b3Kv9B/pQ+/gkD5hSI1GBXjtIoQVX9AqtQfopK0oalK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   "], {{0, 0}, {458, 147}}, {0, 255}],
  ImageSize->{458 0.75, 147 0.75},
  PlotRange->{{0, 458}, {0, 147}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->73086260]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26258],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowCellLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCellLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellTags",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellTags"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellAutoOverwrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellAutoOverwrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15117],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->10164]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->70656275],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->365343853],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->64366242]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellLabelAutoDelete - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 39.6636332}", "context" -> "System`", 
    "keywords" -> {
     "line numbers", "numbering", "cell label edit behavior", "in out labels",
       "in labels", "out labels", "history list", "tracking input", 
      "input history", "output history", "persistent cell labels", 
      "transient cell labels"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellLabelAutoDelete is an option for Cell which specifies whether a \
label for the cell should be automatically deleted if the contents of the \
cell are modified or the notebook containing the cell is saved in a file. ", 
    "synonyms" -> {"cell label auto delete"}, "title" -> 
    "CellLabelAutoDelete", "type" -> "Symbol", "uri" -> 
    "ref/CellLabelAutoDelete"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4809, 152, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13705362]},
 "Notebook Image"->{
  Cell[6243, 208, 2744, 48, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->237814921],
  Cell[9385, 275, 3731, 64, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->154692385],
  Cell[13258, 347, 3723, 64, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->814087675],
  Cell[17828, 449, 3942, 67, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->191662036],
  Cell[22937, 566, 2771, 48, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->55957527],
  Cell[26107, 633, 3776, 65, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->126071168],
  Cell[30176, 711, 3837, 66, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->276639865],
  Cell[34728, 809, 4336, 74, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->73086260]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43081, 1017},
 {"Notebook Image", 43221, 1021}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2256, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2879, 81, 57, 1, 70, "ObjectName",
 CellID->27683],
Cell[2939, 84, 736, 20, 70, "Usage",
 CellID->1914]
}, Open  ]],
Cell[CellGroupData[{
Cell[3712, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4190, 126, 324, 12, 70, "Notes",
 CellID->8765],
Cell[4517, 140, 255, 7, 70, "Notes",
 CellID->16523]
}, Closed]],
Cell[CellGroupData[{
Cell[4809, 152, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13705362],
Cell[CellGroupData[{
Cell[5193, 166, 148, 5, 70, "ExampleSection",
 CellID->378353710],
Cell[5344, 173, 255, 9, 70, "ExampleText",
 CellID->291822870],
Cell[CellGroupData[{
Cell[5624, 186, 616, 20, 70, "Input",
 CellID->166381362],
Cell[6243, 208, 2744, 48, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->237814921]
}, Open  ]],
Cell[9002, 259, 134, 4, 70, "ExampleText",
 CellID->19460398],
Cell[CellGroupData[{
Cell[9161, 267, 221, 6, 70, "Input",
 CellID->177852241],
Cell[9385, 275, 3731, 64, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->154692385]
}, Open  ]],
Cell[13131, 342, 124, 3, 70, "ExampleText",
 CellID->324742581],
Cell[13258, 347, 3723, 64, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->814087675],
Cell[16984, 413, 116, 3, 70, "ExampleText",
 CellID->55472839],
Cell[17103, 418, 227, 7, 70, "Input",
 CellID->391184252],
Cell[17333, 427, 109, 3, 70, "Input",
 CellID->93481515],
Cell[17445, 432, 103, 2, 70, "ExampleText",
 CellID->161669632],
Cell[CellGroupData[{
Cell[17573, 438, 252, 9, 70, "Input",
 CellID->503419033],
Cell[17828, 449, 3942, 67, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->191662036]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21819, 522, 215, 7, 70, "ExampleSection",
 CellID->5191],
Cell[22037, 531, 256, 9, 70, "ExampleText",
 CellID->20586872],
Cell[CellGroupData[{
Cell[22318, 544, 616, 20, 70, "Input",
 CellID->60498517],
Cell[22937, 566, 2771, 48, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->55957527]
}, Open  ]],
Cell[25723, 617, 135, 4, 70, "ExampleText",
 CellID->739722582],
Cell[CellGroupData[{
Cell[25883, 625, 221, 6, 70, "Input",
 CellID->516535644],
Cell[26107, 633, 3776, 65, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->126071168]
}, Open  ]],
Cell[29898, 701, 275, 8, 70, "ExampleText",
 CellID->268264821],
Cell[30176, 711, 3837, 66, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->276639865],
Cell[34016, 779, 90, 1, 70, "ExampleText",
 CellID->673603357],
Cell[34109, 782, 227, 7, 70, "Input",
 CellID->124307285],
Cell[34339, 791, 109, 3, 70, "Input",
 CellID->73554569],
Cell[CellGroupData[{
Cell[34473, 798, 252, 9, 70, "Input",
 CellID->385740490],
Cell[34728, 809, 4336, 74, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->73086260]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39125, 890, 311, 9, 70, "SeeAlsoSection",
 CellID->26258],
Cell[39439, 901, 971, 35, 70, "SeeAlso",
 CellID->26645]
}, Open  ]],
Cell[CellGroupData[{
Cell[40447, 941, 314, 9, 70, "TutorialsSection",
 CellID->15117],
Cell[40764, 952, 143, 3, 70, "Tutorials",
 CellID->10164]
}, Open  ]],
Cell[CellGroupData[{
Cell[40944, 960, 318, 9, 70, "MoreAboutSection",
 CellID->70656275],
Cell[41265, 971, 150, 3, 70, "MoreAbout",
 CellID->365343853],
Cell[41418, 976, 163, 3, 70, "MoreAbout",
 CellID->64366242]
}, Open  ]],
Cell[41596, 982, 27, 0, 70, "History"],
Cell[41626, 984, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

