(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26281,        916]
NotebookOptionsPosition[     20828,        741]
NotebookOutlinePosition[     22280,        781]
CellTagsIndexPosition[     22195,        776]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellFrameMargins" :> 
          Documentation`HelpLookup["paclet:ref/CellFrameMargins"], 
          "BaselinePosition" :> 
          Documentation`HelpLookup["paclet:ref/BaselinePosition"], 
          "ImageMargins" :> 
          Documentation`HelpLookup["paclet:ref/ImageMargins"], 
          "WindowMargins" :> 
          Documentation`HelpLookup["paclet:ref/WindowMargins"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellFrameMargins\"\>", 
       2->"\<\"BaselinePosition\"\>", 3->"\<\"ImageMargins\"\>", 
       4->"\<\"WindowMargins\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Document Generation\"\>", 3->"\<\"Stylesheets\"\>", 
       4->"\<\"Text Layout Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellMargins", "ObjectName",
 CellID->27236],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellMargins",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies the absolute margins in printer\[CloseCurlyQuote]s \
points to leave around a cell. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21870]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings are: ", "Notes",
 CellID->22578],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["m", "TI"], Cell[
    "the same margins on all sides ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["left", "TI"], ",", 
        StyleBox["right", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["bottom", "TI"], ",", 
        StyleBox["top", "TI"]}], "}"}]}], "}"}], Cell[
    "different margins on different sides ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->4463],

Cell["\<\
The left margin gives the distance from the edge of the window to the left\
\[Hyphen]hand side of the cell. \
\>", "Notes",
 CellID->14727],

Cell["\<\
The right margin gives the distance from the inside of the cell bracket to \
the right\[Hyphen]hand side of the cell. \
\>", "Notes",
 CellID->15495],

Cell[TextData[{
 "The left and right margins can be set interactively in the front end using \
",
 StyleBox["Show Ruler", "MenuName"],
 ". "
}], "Notes",
 CellID->7587],

Cell["\<\
The top and bottom margins determine the amount of space to leave above and \
below the cell. \
\>", "Notes",
 CellID->26663],

Cell["\<\
The margins go to the edge of any cell frame that is present. \
\>", "Notes",
 CellID->31362],

Cell["\<\
Cell dingbats are placed to the left of the left\[Hyphen]hand side of the \
cell, and extend into the left cell margin. \
\>", "Notes",
 CellID->31593]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->919581442],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->634745538],

Cell["Specify cell margins:", "ExampleText",
 CellID->238495581],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->99163833],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 CellMargins->{{200, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->28954917]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17668],

Cell["Put a large margin on the left:", "ExampleText",
 CellID->13535329],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
    RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->407305876],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 PageWidth->WindowWidth,
 CellFrame->True,
 CellMargins->{{200, 12}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->756921435],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48705287],

Cell["Put a large margin on the right:", "ExampleText",
 CellID->146211682],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
    RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->302973553],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 PageWidth->WindowWidth,
 CellFrame->True,
 CellMargins->{{12, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->543357030],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50712544],

Cell["Put the same margins all around:", "ExampleText",
 CellID->579427149],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"20", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "20"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
    RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->29537397],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 PageWidth->WindowWidth,
 CellFrame->True,
 CellMargins->{{20, 20}, {20, 20}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->63397296],

Cell["Using a single number: ", "ExampleText",
 CellID->50287047],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", "20"}], ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
    RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->402231070],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 PageWidth->WindowWidth,
 CellFrame->True,
 CellMargins->20,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->2777758]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12120],

Cell[TextData[{
 "The space between consecutive cells ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["bottom", "TI"], 
    StyleBox["1", "TR"]], "+", 
   SubscriptBox[
    StyleBox["top", "TI"], 
    StyleBox["2", "TR"]]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->88368047],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cell", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"Table", "[", 
        RowBox[{"\"\<abcde \>\"", ",", 
         RowBox[{"{", "10", "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"200", ",", "200"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "0"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"CellFrame", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"Cell", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"Table", "[", 
        RowBox[{"\"\<abcde \>\"", ",", 
         RowBox[{"{", "10", "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"200", ",", "200"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "0"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"CellFrame", "\[Rule]", "True"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->542400663],

Cell["abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde ",
 CellFrame->True,
 CellMargins->{{200, 200}, {5, 0}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->128124262],

Cell["abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde ",
 CellFrame->True,
 CellMargins->{{200, 200}, {5, 0}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->239208248],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10411620],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CellFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellFrame"]], "InlineFormula"],
 " to frame the cell content area: "
}], "ExampleText",
 CellID->180924892],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285616907],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 CellFrame->True,
 CellMargins->{{200, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->76701286],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330420604],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " to style the cell content area: "
}], "ExampleText",
 CellID->637695715],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->290774956],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 CellMargins->{{200, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Background->RGBColor[0.88, 1, 0.88],
 CellID->19998758],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36328070],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["CellDingbat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellDingbat"]], "InlineFormula"],
 " will be placed immediately to left to the cell content area: "
}], "ExampleText",
 CellID->77943844],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"CellFrame", "\[Rule]", "True"}], ",", 
    RowBox[{"CellDingbat", "\[Rule]", "\"\<\[FilledSquare]\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->623304807],

Cell["\<\
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde \
\>",
 CellFrame->True,
 CellDingbat->"\[FilledSquare]",
 CellMargins->{{200, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->420758014]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9102],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellFrameMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellFrameMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowMargins"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4991]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26553],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->20714]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->12047442],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->152038662],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->271344741],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->4372985],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->711248499]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellMargins - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 41.2730494}", "context" -> "System`", 
    "keywords" -> {
     "edges", "leading", "margins", "positioning", "spacing", 
      "paragraph spacing", "equational spacing", "whitespace", "page layout", 
      "document design"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellMargins is an option for Cell which specifies the absolute margins \
in printer\\[CloseCurlyQuote]s points to leave around a cell. ", 
    "synonyms" -> {"cell margins"}, "title" -> "CellMargins", "type" -> 
    "Symbol", "uri" -> "ref/CellMargins"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6253, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->919581442]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22052, 769}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2542, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3165, 87, 49, 1, 70, "ObjectName",
 CellID->27236],
Cell[3217, 90, 643, 19, 70, "Usage",
 CellID->21870]
}, Open  ]],
Cell[CellGroupData[{
Cell[3897, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4375, 131, 56, 1, 70, "Notes",
 CellID->22578],
Cell[4434, 134, 889, 25, 70, "2ColumnTableMod",
 CellID->4463],
Cell[5326, 161, 149, 4, 70, "Notes",
 CellID->14727],
Cell[5478, 167, 159, 4, 70, "Notes",
 CellID->15495],
Cell[5640, 173, 168, 6, 70, "Notes",
 CellID->7587],
Cell[5811, 181, 135, 4, 70, "Notes",
 CellID->26663],
Cell[5949, 187, 103, 3, 70, "Notes",
 CellID->31362],
Cell[6055, 192, 161, 4, 70, "Notes",
 CellID->31593]
}, Closed]],
Cell[CellGroupData[{
Cell[6253, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->919581442],
Cell[CellGroupData[{
Cell[6638, 215, 148, 5, 70, "ExampleSection",
 CellID->634745538],
Cell[6789, 222, 64, 1, 70, "ExampleText",
 CellID->238495581],
Cell[6856, 225, 518, 17, 70, "Input",
 CellID->99163833],
Cell[7377, 244, 243, 7, 70, InheritFromParent,
 CellID->28954917]
}, Open  ]],
Cell[CellGroupData[{
Cell[7657, 256, 216, 7, 70, "ExampleSection",
 CellID->17668],
Cell[7876, 265, 73, 1, 70, "ExampleText",
 CellID->13535329],
Cell[7952, 268, 629, 19, 70, "Input",
 CellID->407305876],
Cell[8584, 289, 286, 9, 70, InheritFromParent,
 CellID->756921435],
Cell[8873, 300, 124, 3, 70, "ExampleDelimiter",
 CellID->48705287],
Cell[9000, 305, 75, 1, 70, "ExampleText",
 CellID->146211682],
Cell[9078, 308, 629, 19, 70, "Input",
 CellID->302973553],
Cell[9710, 329, 286, 9, 70, InheritFromParent,
 CellID->543357030],
Cell[9999, 340, 124, 3, 70, "ExampleDelimiter",
 CellID->50712544],
Cell[10126, 345, 75, 1, 70, "ExampleText",
 CellID->579427149],
Cell[10204, 348, 627, 19, 70, "Input",
 CellID->29537397],
Cell[10834, 369, 284, 9, 70, InheritFromParent,
 CellID->63397296],
Cell[11121, 380, 65, 1, 70, "ExampleText",
 CellID->50287047],
Cell[11189, 383, 458, 13, 70, "Input",
 CellID->402231070],
Cell[11650, 398, 265, 9, 70, InheritFromParent,
 CellID->2777758]
}, Closed]],
Cell[CellGroupData[{
Cell[11952, 412, 233, 7, 70, "ExampleSection",
 CellID->12120],
Cell[12188, 421, 516, 22, 70, "ExampleText",
 CellID->88368047],
Cell[12707, 445, 1135, 34, 70, "Input",
 CellID->542400663],
Cell[13845, 481, 190, 5, 70, InheritFromParent,
 CellID->128124262],
Cell[14038, 488, 190, 5, 70, InheritFromParent,
 CellID->239208248],
Cell[14231, 495, 124, 3, 70, "ExampleDelimiter",
 CellID->10411620],
Cell[14358, 500, 221, 8, 70, "ExampleText",
 CellID->180924892],
Cell[14582, 510, 569, 17, 70, "Input",
 CellID->285616907],
Cell[15154, 529, 261, 8, 70, InheritFromParent,
 CellID->76701286],
Cell[15418, 539, 125, 3, 70, "ExampleDelimiter",
 CellID->330420604],
Cell[15546, 544, 223, 8, 70, "ExampleText",
 CellID->637695715],
Cell[15772, 554, 578, 18, 70, "Input",
 CellID->290774956],
Cell[16353, 574, 281, 8, 70, InheritFromParent,
 CellID->19998758],
Cell[16637, 584, 124, 3, 70, "ExampleDelimiter",
 CellID->36328070],
Cell[16764, 589, 251, 8, 70, "ExampleText",
 CellID->77943844],
Cell[17018, 599, 645, 19, 70, "Input",
 CellID->623304807],
Cell[17666, 620, 295, 9, 70, InheritFromParent,
 CellID->420758014]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18010, 635, 310, 9, 70, "SeeAlsoSection",
 CellID->9102],
Cell[18323, 646, 990, 35, 70, "SeeAlso",
 CellID->4991]
}, Open  ]],
Cell[CellGroupData[{
Cell[19350, 686, 314, 9, 70, "TutorialsSection",
 CellID->26553],
Cell[19667, 697, 143, 3, 70, "Tutorials",
 CellID->20714]
}, Open  ]],
Cell[CellGroupData[{
Cell[19847, 705, 318, 9, 70, "MoreAboutSection",
 CellID->12047442],
Cell[20168, 716, 150, 3, 70, "MoreAbout",
 CellID->152038662],
Cell[20321, 721, 149, 3, 70, "MoreAbout",
 CellID->271344741],
Cell[20473, 726, 132, 3, 70, "MoreAbout",
 CellID->4372985],
Cell[20608, 731, 148, 3, 70, "MoreAbout",
 CellID->711248499]
}, Open  ]],
Cell[20771, 737, 27, 0, 70, "History"],
Cell[20801, 739, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

