(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15688,        466]
NotebookOptionsPosition[     12571,        364]
NotebookOutlinePosition[     14146,        409]
CellTagsIndexPosition[     14028,        403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Visible" :> Documentation`HelpLookup["paclet:ref/Visible"], 
          "CellGroupData" :> 
          Documentation`HelpLookup["paclet:ref/CellGroupData"], 
          "ConversionRules" :> 
          Documentation`HelpLookup["paclet:ref/ConversionRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Visible\"\>", 
       2->"\<\"CellGroupData\"\>", 
       3->"\<\"ConversionRules\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CellOpen", "ObjectName",
 CellID->22313],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CellOpen",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellOpen"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether the contents of a cell should be explicitly \
displayed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15126]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"CellOpen", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", a small cell bracket is still shown to indicate the presence of a cell. "
}], "Notes",
 CellID->4836],

Cell[TextData[{
 "Cells which are not open can still be evaluated automatically if you set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InitializationCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InitializationCell"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4005]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30957028],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11292019],

Cell["Create a notebook with one open cell and one closed cell:", \
"ExampleText",
 CellID->295253256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<text 1\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"CellOpen", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<text 2\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"CellOpen", "\[Rule]", "False"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->856405],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etP01ccx3GWPV/8F/av7PJUssUn25IJZlzcYsyWPVuyB2bqJnMZXkAU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   "], {{0, 0}, {458, 84}}, {0, 255}],
  ImageSize->{458 0.75, 84 0.75},
  PlotRange->{{0, 458}, {0, 84}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->36510364]
}, Open  ]],

Cell["Find data in a closed cell: ", "ExampleText",
 CellID->210064819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<text 2\>\""}], "]"}], ";", 
  RowBox[{"NotebookRead", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3767793],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"\<\"text 2\"\>", ",", "\<\"Text\"\>", ",", 
   RowBox[{"CellOpen", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{246, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196113094],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtPlEccxnGa3jf+C/1XerhrNG29aZtUMAVtG2Pa9K5JL4yHVmojHkA8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   "], {{0, 0}, {458, 84}}, {0, 255}],
  ImageSize->{458 0.75, 84 0.75},
  PlotRange->{{0, 458}, {0, 84}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->216502445]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21436],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Visible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Visible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellGroupData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellGroupData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConversionRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConversionRules"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8210],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->24879]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellOpen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 42.5855830}", "context" -> "System`", 
    "keywords" -> {
     "open cell", "displayed cell", "non-closed cell", "visible cell"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CellOpen is an option for Cell which specifies whether the contents of a \
cell should be explicitly displayed. ", "synonyms" -> {"cell open"}, "title" -> 
    "CellOpen", "type" -> "Symbol", "uri" -> "ref/CellOpen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3889, 134, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30957028]},
 "Notebook Image"->{
  Cell[5050, 177, 2592, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->36510364],
  Cell[8253, 248, 2658, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->216502445]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13659, 389},
 {"Notebook Image", 13799, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1397, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2020, 62, 46, 1, 70, "ObjectName",
 CellID->22313],
Cell[2069, 65, 618, 19, 70, "Usage",
 CellID->15126]
}, Open  ]],
Cell[CellGroupData[{
Cell[2724, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3202, 106, 278, 9, 70, "Notes",
 CellID->4836],
Cell[3483, 117, 369, 12, 70, "Notes",
 CellID->4005]
}, Closed]],
Cell[CellGroupData[{
Cell[3889, 134, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30957028],
Cell[CellGroupData[{
Cell[4273, 148, 147, 5, 70, "ExampleSection",
 CellID->11292019],
Cell[4423, 155, 102, 2, 70, "ExampleText",
 CellID->295253256],
Cell[CellGroupData[{
Cell[4550, 161, 497, 14, 70, "Input",
 CellID->856405],
Cell[5050, 177, 2592, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->36510364]
}, Open  ]],
Cell[7657, 225, 71, 1, 70, "ExampleText",
 CellID->210064819],
Cell[CellGroupData[{
Cell[7753, 230, 207, 6, 70, "Input",
 CellID->3767793],
Cell[7963, 238, 287, 8, 36, "Output",
 CellID->196113094],
Cell[8253, 248, 2658, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->216502445]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10972, 301, 311, 9, 70, "SeeAlsoSection",
 CellID->21436],
Cell[11286, 312, 717, 26, 70, "SeeAlso",
 CellID->4703]
}, Open  ]],
Cell[CellGroupData[{
Cell[12040, 343, 313, 9, 70, "TutorialsSection",
 CellID->8210],
Cell[12356, 354, 143, 3, 70, "Tutorials",
 CellID->24879]
}, Open  ]],
Cell[12514, 360, 27, 0, 70, "History"],
Cell[12544, 362, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

