(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27790,        970]
NotebookOptionsPosition[     21907,        777]
NotebookOutlinePosition[     23336,        816]
CellTagsIndexPosition[     23251,        811]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cells as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CellsAsMathematicaExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Cells as Mathematica Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Print" :> Documentation`HelpLookup["paclet:ref/Print"], 
          "PrintTemporary" :> 
          Documentation`HelpLookup["paclet:ref/PrintTemporary"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Print\"\>", 
       2->"\<\"PrintTemporary\"\>", 
       3->"\<\"NotebookWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelInterfaceControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"Low-Level Interface Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CellPrint", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellPrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellPrint"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a complete cell in the current notebook just below the cell being \
evaluated. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CellPrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CellPrint"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts a sequence of cells. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10631]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " has head ",
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["CellGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroup"]], "InlineFormula"],
 ", it is inserted unchanged into the notebook.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->235552286]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3097],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a string or ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " object, a text cell is created to contain it.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->294524969]
}], "Notes",
 CellID->6226],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is any other type of expression, an expression cell is created to contain \
it.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->200840983]
}], "Notes",
 CellID->25481],

Cell[TextData[{
 "With a text\[Hyphen]based front end, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellPrint"], "[", 
   StyleBox["cell", "TI"], "]"}]], "InlineFormula"],
 " does the same as applying ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " to the contents of ",
 Cell[BoxData[
  StyleBox["cell", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20269],

Cell[TextData[{
 "Cells generated by ",
 Cell[BoxData[
  ButtonBox["CellPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellPrint"]], "InlineFormula"],
 " by default have ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedCell"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", so that they are overwritten if they are regenerated."
}], "Notes",
 CellID->3479]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277668959],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->162629769],

Cell[TextData[{
 "Create a text cell from a ",
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->155350275],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{"\"\<a\>\"", ",", "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16287618],

Cell["a", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->2464622],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72220119],

Cell["Create a sequence of text cells:", "ExampleText",
 CellID->313197770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TextCell", "[", 
    RowBox[{"#", ",", "\"\<Text\>\""}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<a\>\"", ",", " ", "\"\<b\>\"", ",", " ", "\"\<c\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208722522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[Cell["a", "Text"],
    TextCell["a", "Text"]], ",", 
   InterpretationBox[Cell["b", "Text"],
    TextCell["b", "Text"]], ",", 
   InterpretationBox[Cell["c", "Text"],
    TextCell["c", "Text"]]}], "}"}]], "Output",
 ImageSize->{66, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143504077]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CellPrint", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->694355419],

Cell["a", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->1927733],

Cell["b", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->954146005],

Cell["c", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->117685244],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231426955],

Cell["Create a text cell from a string:", "ExampleText",
 CellID->156621846],

Cell[BoxData[
 RowBox[{"CellPrint", "[", "\"\<a\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7145159],

Cell["a",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->359299438]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->219251611],

Cell[TextData[{
 "Strings are converted to ",
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 " objects: "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->294524969],

Cell[BoxData[
 RowBox[{"CellPrint", "[", "\"\<xxx\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149012864],

Cell["xxx",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->318133599],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", "\"\<xxx\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99097627],

Cell["xxx",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->16327094],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132681934],

Cell[TextData[{
 "General expressions are converted to ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 " objects: "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->200840983],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"y", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313896148],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]],
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->142205226],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->708938439],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]],
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->4778543],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76082814],

Cell["Lists are converted to multiple cells: ", "ExampleText",
 CellID->431103698],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<xxx\>\"", ",", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477056186],

Cell["xxx",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->82321984],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]],
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->31961651],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187393138],

Cell["Print cells with specific styles:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->235552286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Pi", ",", "20"}], "]"}], ",", "\"\<Output\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213268373],

Cell[BoxData["3.1415926535897932384626433832795028842`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446391155]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Pi", ",", "20"}], "]"}], ",", "\"\<Input\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183018388],

Cell[BoxData["3.1415926535897932384626433832795028842`20."], "Input",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"In[3]:=",
 CellID->211224219],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{"\"\<xxx\>\"", ",", "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->539325576],

Cell["xxx", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->186177322]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->52479118],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["CellPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellPrint"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->451561557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275158910],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->103901909]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], ",", "\"\<Print\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283166970],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Print",
 CellID->18471207]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24040],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintTemporary",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrintTemporary"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21191],

Cell[TextData[{
 ButtonBox["Cells as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"]
}], "Tutorials",
 CellID->13471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->370300399],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->931432248],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->310966774]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellPrint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 27, 46.5231838}", "context" -> "System`", 
    "keywords" -> {
     "appending", "create cell", "inserting cells", "printing cell", "print", 
      "output", "generating a cell"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CellPrint[expr] inserts expr as a complete cell in the current notebook \
just below the cell being evaluated. CellPrint[{expr_1, expr_2, ...}] inserts \
a sequence of cells. ", "synonyms" -> {"cell print"}, "title" -> "CellPrint", 
    "type" -> "Symbol", "uri" -> "ref/CellPrint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11168, 323, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->277668959]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23107, 804}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2190, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2813, 81, 4193, 83, 70, "ObjectNameGrid"],
Cell[7009, 166, 1155, 36, 70, "Usage",
 CellID->10631]
}, Open  ]],
Cell[CellGroupData[{
Cell[8201, 207, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8679, 224, 779, 27, 70, "Notes",
 CellID->3097],
Cell[9461, 253, 380, 14, 70, "Notes",
 CellID->6226],
Cell[9844, 269, 283, 10, 70, "Notes",
 CellID->25481],
Cell[10130, 281, 497, 18, 70, "Notes",
 CellID->20269],
Cell[10630, 301, 501, 17, 70, "Notes",
 CellID->3479]
}, Closed]],
Cell[CellGroupData[{
Cell[11168, 323, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277668959],
Cell[CellGroupData[{
Cell[11553, 337, 148, 5, 70, "ExampleSection",
 CellID->162629769],
Cell[11704, 344, 216, 8, 70, "ExampleText",
 CellID->155350275],
Cell[11923, 354, 182, 5, 70, "Input",
 CellID->16287618],
Cell[12108, 361, 83, 3, 70, "Text",
 CellID->2464622],
Cell[12194, 366, 124, 3, 70, "ExampleDelimiter",
 CellID->72220119],
Cell[12321, 371, 75, 1, 70, "ExampleText",
 CellID->313197770],
Cell[CellGroupData[{
Cell[12421, 376, 278, 9, 70, "Input",
 CellID->208722522],
Cell[12702, 387, 405, 13, 39, "Output",
 CellID->143504077]
}, Open  ]],
Cell[13122, 403, 105, 3, 70, "Input",
 CellID->694355419],
Cell[13230, 408, 83, 3, 70, "Text",
 CellID->1927733],
Cell[13316, 413, 85, 3, 70, "Text",
 CellID->954146005],
Cell[13404, 418, 85, 3, 70, "Text",
 CellID->117685244],
Cell[13492, 423, 125, 3, 70, "ExampleDelimiter",
 CellID->231426955],
Cell[13620, 428, 76, 1, 70, "ExampleText",
 CellID->156621846],
Cell[13699, 431, 111, 3, 70, "Input",
 CellID->7145159],
Cell[13813, 436, 77, 3, 70, InheritFromParent,
 CellID->359299438]
}, Open  ]],
Cell[CellGroupData[{
Cell[13927, 444, 220, 7, 70, "ExampleSection",
 CellID->219251611],
Cell[14150, 453, 265, 9, 70, "ExampleText",
 CellID->294524969],
Cell[14418, 464, 115, 3, 70, "Input",
 CellID->149012864],
Cell[14536, 469, 79, 3, 70, InheritFromParent,
 CellID->318133599],
Cell[14618, 474, 149, 4, 70, "Input",
 CellID->99097627],
Cell[14770, 480, 78, 3, 70, InheritFromParent,
 CellID->16327094],
Cell[14851, 485, 125, 3, 70, "ExampleDelimiter",
 CellID->132681934],
Cell[14979, 490, 289, 9, 70, "ExampleText",
 CellID->200840983],
Cell[15271, 501, 176, 6, 70, "Input",
 CellID->313896148],
Cell[15450, 509, 156, 6, 70, InheritFromParent,
 CellID->142205226],
Cell[15609, 517, 220, 7, 70, "Input",
 CellID->708938439],
Cell[15832, 526, 154, 6, 70, InheritFromParent,
 CellID->4778543],
Cell[15989, 534, 124, 3, 70, "ExampleDelimiter",
 CellID->76082814],
Cell[16116, 539, 82, 1, 70, "ExampleText",
 CellID->431103698],
Cell[16201, 542, 239, 8, 70, "Input",
 CellID->477056186],
Cell[16443, 552, 78, 3, 70, InheritFromParent,
 CellID->82321984],
Cell[16524, 557, 155, 6, 70, InheritFromParent,
 CellID->31961651],
Cell[16682, 565, 125, 3, 70, "ExampleDelimiter",
 CellID->187393138],
Cell[16810, 570, 124, 2, 70, "ExampleText",
 CellID->235552286],
Cell[CellGroupData[{
Cell[16959, 576, 244, 8, 70, "Input",
 CellID->213268373],
Cell[17206, 586, 201, 5, 36, "Output",
 CellID->446391155]
}, Open  ]],
Cell[17422, 594, 243, 8, 70, "Input",
 CellID->183018388],
Cell[17668, 604, 160, 4, 70, "Input",
 CellID->211224219],
Cell[17831, 610, 185, 5, 70, "Input",
 CellID->539325576],
Cell[18019, 617, 87, 3, 70, "Text",
 CellID->186177322]
}, Closed]],
Cell[CellGroupData[{
Cell[18143, 625, 236, 7, 70, "ExampleSection",
 CellID->52479118],
Cell[18382, 634, 321, 12, 70, "ExampleText",
 CellID->451561557],
Cell[CellGroupData[{
Cell[18728, 650, 124, 4, 70, "Input",
 CellID->275158910],
Cell[18855, 656, 114, 3, 70, "Print",
 CellID->103901909]
}, Open  ]],
Cell[CellGroupData[{
Cell[19006, 664, 207, 6, 70, "Input",
 CellID->283166970],
Cell[19216, 672, 69, 2, 70, "Print",
 CellID->18471207]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19346, 681, 311, 9, 70, "SeeAlsoSection",
 CellID->24040],
Cell[19660, 692, 712, 26, 70, "SeeAlso",
 CellID->15688]
}, Open  ]],
Cell[CellGroupData[{
Cell[20409, 723, 314, 9, 70, "TutorialsSection",
 CellID->21191],
Cell[20726, 734, 412, 12, 70, "Tutorials",
 CellID->13471]
}, Open  ]],
Cell[CellGroupData[{
Cell[21175, 751, 319, 9, 70, "MoreAboutSection",
 CellID->370300399],
Cell[21497, 762, 149, 3, 70, "MoreAbout",
 CellID->931432248],
Cell[21649, 767, 163, 3, 70, "MoreAbout",
 CellID->310966774]
}, Open  ]],
Cell[21827, 773, 50, 0, 70, "History"],
Cell[21880, 775, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

