(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10520,        343]
NotebookOptionsPosition[      7955,        257]
NotebookOutlinePosition[      9213,        294]
CellTagsIndexPosition[      9129,        289]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"], 
          "Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>", 
       2->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinaryRead" :> 
          Documentation`HelpLookup["paclet:ref/BinaryRead"], "BinaryWrite" :> 
          Documentation`HelpLookup["paclet:ref/BinaryWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BinaryRead\"\>", 
       2->"\<\"BinaryWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Character", "ObjectName",
 CellID->30723],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Character",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Character"]], "InlineFormula"],
     "\[LineSeparator]represents a single character in ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4888]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->402284253],

Cell["Read the characters in a stream: ", "ExampleText",
 CellID->358885573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{"StringToStream", "[", "\"\<abcd\>\"", "]"}], ",", "Character"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474341411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1708976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650040047],

Cell["Read the characters in a file: ", "ExampleText",
 CellID->710943341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", " ", "/@", " ", 
  RowBox[{"ReadList", "[", 
   RowBox[{"\"\<ExampleData/textfile\>\"", ",", "Character"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1587793899],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXEtv2zAMdu14W9MkbgcM7ba+DvsVa7dhl+202249BcWA9jBs6Pr/vUi2
HIUibeplO20MNK5okSIpyjG/UP6xfLz79Xv5eH+7vPz+sPx7d3/77/Lbn4cV
KdtLknSeJMnPk2T1f7n6T/6po1j9rZtV61x8Zk2v5CxwO7R8X3kfQDtrvJAm
/PNFoH6vgTZHoJ1K7Q5Xn5MV8QBcna8+coS+IPpDX1D885p/1uF7EUEZwj+r
6clEql8fU0ctC6Iff5ScoIsZmAP6IYyPzhGqOSoQHwr5kD6r6Quiv4oMqMeB
zpfrqzqpfaPHW4H2mrJkdGlGWcqQSl4ttNkQ5yO0dwZG3mfNBIzaU9D+AtoX
oH2F8Ru6vQe9PoP2Gc1lUD9hdhm94Orca6wXXaGVpzUdyhZ00YT60lYK4nV9
xvX3sQqucm1Ojb5CRxEtuG/heDytlMwU0N+i3Nek/aQM3TYlAXwfYbx4rL8S
n5M1tbpVZWqtbFxZGBQ1Vv0lKI+UwWczxpSpR1bL5Yw9QfUsnMfOmXbr9lbe
4njAz1umVTbyUmSGuTpLvrxqNxeMuJw5eX0CpPD0zBEubA1wNBh/H7d4hp7l
3gd0Hs467NMmTp+XBiVOpJo8dFTCiN5HaPMR9eOsSq78RSx918/iNeVFD96K
Zo1Gy8v1N39IuXAdHCB94B2gulTWB4YbhGk9N/QBtqeNF4ZAH9RZPnPLGO/O
dv2ybiy3d0cQKGQg7ChtKEsbnYs4QG15Wsl8gMiLeDl3+9WNbN8RSaCQghCy
KXwE0mcsaRB/OGdxTZs5sM2FYdaHZ9swh+fl6F33HJzrBqUey7Pu00av4Jbm
7N79WOiawVO879j+wbghvnRWatgH0Oim9mZlG44R6NZucyYZOn/3y7fHgTjQ
eIppnQ8GFHNeuZ40V5SpvUSTkXWAZm5blIuGye3j5eTDYRFuNsWatzixjN2N
U31ljjwv9c/y+8jK42ARHKTFx7rh5yxTaiTqkHYCXvnc1YT8DmcIJW/cVQ6H
5fpO9ZRxB6qOgqp8UJ6A/QuCPsIKiK3FItxqIhhjRvGIe71Equg94hZfQRtm
0ejdj6mRT61B9e3TL7qRaW2Y0w9vdz+Yx5W3nfQcuVpA1V3IdbjDUDb6Do+h
0FUgfvUXNtUlz7cOo8K9d3iKvGj0iIenjK3WZExzZ/Kso3SHlAyOlOzqMFh1
GNWvumV97PCQUPK2CQ8RuRyGTdjs3sDofrsy4AxQWAU1OheBadvtoa9KjA+T
FxrlkHwkBtG1e8NtVweFPlywuKkdKDxUpXW3x8b37Ywtzxe5gF5E91po7ZbM
EkrpxDJgho3dqZR323TkZuZ+9jU1FU52qX0kQ9hD5vHMPRisecNjYiOqoW5Q
ji1uYJNrc56DXXIuuj4gbOaKZ8fude3cbDu0j2l5YVAB/dy3bWERAJeMOlaU
b2O2HMt/3XK33yYbBCB0zmiLKITcaTGm3Fnd/Z6KPaH7jQkDgDF4DNpPHRPA
92LAzOOkHAYj2NybAbUS9zT3XD7WeyMUP8QEwlZfcBEKW3zE9m0Y++jMSKp1
Jh/6LRHtlQch6im6MAnKolaNKQ907MCAd9UpyoP+2q61u94LcQnaHzH+zlGh
1C4t4KhvSn7UKQSA+y4IsU4zhN7+LgjYu8siNcoJaQldlWL3xgdcb27tAo42
cKylNTxGbTazmQzlDv1rt3pqNZ5QAo7h9/4HPL+eMPUcx26M0EiIrcZcpMcn
GvAZqWrVY0b7c/5lfdt2V8TCAdz6VLEJ7C/rFeBQyT6mLDPk+x4Gz7KDvu/B
xxpbbGMIjMdvP0Wy9x8vp1aG\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{525, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->503836365]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26018],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryWrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14332],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->17046],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->25574]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Character - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 11.1488142}", "context" -> "System`", 
    "keywords" -> {
     "parsing tokens", "importing structured files", "file reading", 
      "stream reading"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Character represents a single character in Read. ", "synonyms" -> {}, 
    "title" -> "Character", "type" -> "Symbol", "uri" -> "ref/Character"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2756, 89, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8995, 282}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1491, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2114, 63, 47, 1, 70, "ObjectName",
 CellID->30723],
Cell[2164, 66, 555, 18, 70, "Usage",
 CellID->4888]
}, Open  ]],
Cell[CellGroupData[{
Cell[2756, 89, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3133, 103, 148, 5, 70, "ExampleSection",
 CellID->402284253],
Cell[3284, 110, 76, 1, 70, "ExampleText",
 CellID->358885573],
Cell[CellGroupData[{
Cell[3385, 115, 191, 6, 28, "Input",
 CellID->474341411],
Cell[3579, 123, 256, 8, 36, "Output",
 CellID->1708976]
}, Open  ]],
Cell[3850, 134, 125, 3, 70, "ExampleDelimiter",
 CellID->650040047],
Cell[3978, 139, 74, 1, 70, "ExampleText",
 CellID->710943341],
Cell[CellGroupData[{
Cell[4077, 144, 209, 6, 28, "Input",
 CellID->1587793899],
Cell[4289, 152, 2066, 38, 105, "Output",
 Evaluatable->False,
 CellID->503836365]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6416, 197, 311, 9, 70, "SeeAlsoSection",
 CellID->26018],
Cell[6730, 208, 461, 17, 70, "SeeAlso",
 CellID->23811]
}, Open  ]],
Cell[CellGroupData[{
Cell[7228, 230, 314, 9, 70, "TutorialsSection",
 CellID->14332],
Cell[7545, 241, 186, 4, 70, "Tutorials",
 CellID->17046],
Cell[7734, 247, 149, 3, 70, "Tutorials",
 CellID->25574]
}, Open  ]],
Cell[7898, 253, 27, 0, 70, "History"],
Cell[7928, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

