(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49107,       1422]
NotebookOptionsPosition[     41842,       1163]
NotebookOutlinePosition[     43298,       1203]
CellTagsIndexPosition[     43212,       1198]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Character Codes" :> 
          Documentation`HelpLookup["paclet:tutorial/CharacterCodes"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Characters in Strings\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Character Codes\"\>", 
       5->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/FromCharacterCode"], "Range" :> 
          Documentation`HelpLookup["paclet:ref/Range"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Symbol" :> 
          Documentation`HelpLookup["paclet:ref/Symbol"], "Unique" :> 
          Documentation`HelpLookup["paclet:ref/Unique"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromCharacterCode\"\>", 2->"\<\"Range\"\>", 
       3->"\<\"StringExpression\"\>", 4->"\<\"Sort\"\>", 5->"\<\"Symbol\"\>", 
       6->"\<\"Unique\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Special Characters" :> 
          Documentation`HelpLookup["paclet:guide/SpecialCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"Constructing Lists\"\>", 
       3->"\<\"Locale & Internationalization\"\>", 
       4->"\<\"Special Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CharacterRange", "ObjectName",
 CellID->13356],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CharacterRange",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CharacterRange"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"1\"]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"2\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a list of the characters in the range from ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"1\"]\)\>\""], "InlineFormula"],
     " to ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"2\"]\)\>\""], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15133]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"], "[", 
   RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}]], "InlineFormula"],
 " yields the English alphabet. "
}], "Notes",
 CellID->11548],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"], "[", 
   RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"1\"]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"2\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives the list of characters with character codes from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"1\"]\)\>\"", "]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"2\"]\)\>\"", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21408],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"], "[", 
   RowBox[{"\"\<b\>\"", ",", "\"\<a\>\""}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30655]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->719901180],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->311217203],

Cell["Letters a through z:", "ExampleText",
 CellID->30767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"j\"\>", ",", "\<\"k\"\>", ",", "\<\"l\"\>", 
   ",", "\<\"m\"\>", ",", "\<\"n\"\>", ",", "\<\"o\"\>", ",", "\<\"p\"\>", 
   ",", "\<\"q\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"u\"\>", ",", "\<\"v\"\>", ",", "\<\"w\"\>", ",", "\<\"x\"\>", 
   ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], "}"}]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16117]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28587],

Cell["Letters A through Z:", "ExampleText",
 CellID->32556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4207],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>", ",", "\<\"D\"\>", 
   ",", "\<\"E\"\>", ",", "\<\"F\"\>", ",", "\<\"G\"\>", ",", "\<\"H\"\>", 
   ",", "\<\"I\"\>", ",", "\<\"J\"\>", ",", "\<\"K\"\>", ",", "\<\"L\"\>", 
   ",", "\<\"M\"\>", ",", "\<\"N\"\>", ",", "\<\"O\"\>", ",", "\<\"P\"\>", 
   ",", "\<\"Q\"\>", ",", "\<\"R\"\>", ",", "\<\"S\"\>", ",", "\<\"T\"\>", 
   ",", "\<\"U\"\>", ",", "\<\"V\"\>", ",", "\<\"W\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"Y\"\>", ",", "\<\"Z\"\>"}], "}"}]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20768],

Cell["Digits 0 through 9, as strings:", "ExampleText",
 CellID->16622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<0\>\"", ",", "\"\<9\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", 
   ",", "\<\"4\"\>", ",", "\<\"5\"\>", ",", "\<\"6\"\>", ",", "\<\"7\"\>", 
   ",", "\<\"8\"\>", ",", "\<\"9\"\>"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22729],

Cell["Greek alphabet (including \[FinalSigma]):", "ExampleText",
 CellID->27477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<\[Omega]\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26603],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Alpha]\"\>", ",", "\<\"\[Beta]\"\>", ",", "\<\"\[Gamma]\"\>",
    ",", "\<\"\[Delta]\"\>", ",", "\<\"\[CurlyEpsilon]\"\>", 
   ",", "\<\"\[Zeta]\"\>", ",", "\<\"\[Eta]\"\>", ",", "\<\"\[Theta]\"\>", 
   ",", "\<\"\[Iota]\"\>", ",", "\<\"\[Kappa]\"\>", ",", "\<\"\[Lambda]\"\>", 
   ",", "\<\"\[Mu]\"\>", ",", "\<\"\[Nu]\"\>", ",", "\<\"\[Xi]\"\>", 
   ",", "\<\"\[Omicron]\"\>", ",", "\<\"\[Pi]\"\>", ",", "\<\"\[Rho]\"\>", 
   ",", "\<\"\[FinalSigma]\"\>", ",", "\<\"\[Sigma]\"\>", 
   ",", "\<\"\[Tau]\"\>", ",", "\<\"\[Upsilon]\"\>", 
   ",", "\<\"\[CurlyPhi]\"\>", ",", "\<\"\[Chi]\"\>", ",", "\<\"\[Psi]\"\>", 
   ",", "\<\"\[Omega]\"\>"}], "}"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20455]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<\[CapitalAlpha]\>\"", ",", "\"\<\[CapitalOmega]\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[CapitalAlpha]\"\>", ",", "\<\"\[CapitalBeta]\"\>", 
   ",", "\<\"\[CapitalGamma]\"\>", ",", "\<\"\[CapitalDelta]\"\>", 
   ",", "\<\"\[CapitalEpsilon]\"\>", ",", "\<\"\[CapitalZeta]\"\>", 
   ",", "\<\"\[CapitalEta]\"\>", ",", "\<\"\[CapitalTheta]\"\>", 
   ",", "\<\"\[CapitalIota]\"\>", ",", "\<\"\[CapitalKappa]\"\>", 
   ",", "\<\"\[CapitalLambda]\"\>", ",", "\<\"\[CapitalMu]\"\>", 
   ",", "\<\"\[CapitalNu]\"\>", ",", "\<\"\[CapitalXi]\"\>", 
   ",", "\<\"\[CapitalOmicron]\"\>", ",", "\<\"\[CapitalPi]\"\>", 
   ",", "\<\"\[CapitalRho]\"\>", ",", "\<\"\:03a2\"\>", 
   ",", "\<\"\[CapitalSigma]\"\>", ",", "\<\"\[CapitalTau]\"\>", 
   ",", "\<\"\[CapitalUpsilon]\"\>", ",", "\<\"\[CapitalPhi]\"\>", 
   ",", "\<\"\[CapitalChi]\"\>", ",", "\<\"\[CapitalPsi]\"\>", 
   ",", "\<\"\[CapitalOmega]\"\>"}], "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23883],

Cell["Printable ASCII characters:", "ExampleText",
 CellID->19662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\< \>\"", ",", "\"\<~\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\" \"\>", ",", "\<\"!\"\>", ",", "\<\"\\\"\"\>", 
   ",", "\<\"#\"\>", ",", "\<\"$\"\>", ",", "\<\"%\"\>", ",", "\<\"&\"\>", 
   ",", "\<\"'\"\>", ",", "\<\"(\"\>", ",", "\<\")\"\>", ",", "\<\"*\"\>", 
   ",", "\<\"+\"\>", ",", "\<\",\"\>", ",", "\<\"-\"\>", ",", "\<\".\"\>", 
   ",", "\<\"/\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"4\"\>", ",", "\<\"5\"\>", ",", "\<\"6\"\>", 
   ",", "\<\"7\"\>", ",", "\<\"8\"\>", ",", "\<\"9\"\>", ",", "\<\":\"\>", 
   ",", "\<\";\"\>", ",", "\<\"<\"\>", ",", "\<\"=\"\>", ",", "\<\">\"\>", 
   ",", "\<\"?\"\>", ",", "\<\"@\"\>", ",", "\<\"A\"\>", ",", "\<\"B\"\>", 
   ",", "\<\"C\"\>", ",", "\<\"D\"\>", ",", "\<\"E\"\>", ",", "\<\"F\"\>", 
   ",", "\<\"G\"\>", ",", "\<\"H\"\>", ",", "\<\"I\"\>", ",", "\<\"J\"\>", 
   ",", "\<\"K\"\>", ",", "\<\"L\"\>", ",", "\<\"M\"\>", ",", "\<\"N\"\>", 
   ",", "\<\"O\"\>", ",", "\<\"P\"\>", ",", "\<\"Q\"\>", ",", "\<\"R\"\>", 
   ",", "\<\"S\"\>", ",", "\<\"T\"\>", ",", "\<\"U\"\>", ",", "\<\"V\"\>", 
   ",", "\<\"W\"\>", ",", "\<\"X\"\>", ",", "\<\"Y\"\>", ",", "\<\"Z\"\>", 
   ",", "\<\"[\"\>", ",", "\<\"\\\\\"\>", ",", "\<\"]\"\>", ",", "\<\"^\"\>", 
   ",", "\<\"_\"\>", ",", "\<\"`\"\>", ",", "\<\"a\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"f\"\>", 
   ",", "\<\"g\"\>", ",", "\<\"h\"\>", ",", "\<\"i\"\>", ",", "\<\"j\"\>", 
   ",", "\<\"k\"\>", ",", "\<\"l\"\>", ",", "\<\"m\"\>", ",", "\<\"n\"\>", 
   ",", "\<\"o\"\>", ",", "\<\"p\"\>", ",", "\<\"q\"\>", ",", "\<\"r\"\>", 
   ",", "\<\"s\"\>", ",", "\<\"t\"\>", ",", "\<\"u\"\>", ",", "\<\"v\"\>", 
   ",", "\<\"w\"\>", ",", "\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>", 
   ",", "\<\"{\"\>", ",", "\<\"|\"\>", ",", "\<\"}\"\>", ",", "\<\"~\"\>"}], 
  "}"}]], "Output",
 ImageSize->{462, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13284]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4754],

Cell["Give letters as labels:", "ExampleText",
 CellID->32197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", " ", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
       RowBox[{"ImageSize", "->", "Tiny"}]}], "]"}], ",", 
     RowBox[{"\"\<(\>\"", "<>", 
      RowBox[{
       RowBox[{"CharacterRange", "[", 
        RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], "[", 
       RowBox[{"[", "n", "]"}], "]"}], "<>", "\"\<)\>\""}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19192],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{351, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7357],

Cell["Find sequences of upper-case letters:", "ExampleText",
 CellID->25290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<AaBBccDDeefG\>\"", ",", 
   RowBox[{
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], ".."}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->3225],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"BB\"\>", ",", "\<\"DD\"\>", 
   ",", "\<\"G\"\>"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22374],

Cell["Replace every letter by X:", "ExampleText",
 CellID->20772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<this is text\>\"", ",", 
   RowBox[{
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], "\[Rule]", 
    "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26053],

Cell[BoxData["\<\"XXXX XX XXXX\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29162],

Cell["Make random 5-letter \[OpenCurlyDoubleQuote]words\
\[CloseCurlyDoubleQuote]:", "ExampleText",
 CellID->27664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"CharacterRange", "[", 
       RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], ",", "5"}], "]"}], 
    "]"}], ",", 
   RowBox[{"{", "10", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"jvlkc\"\>", ",", "\<\"qvnsf\"\>", ",", "\<\"rvuos\"\>", 
   ",", "\<\"prknv\"\>", ",", "\<\"ztgvm\"\>", ",", "\<\"dooia\"\>", 
   ",", "\<\"wtkyg\"\>", ",", "\<\"ybcyd\"\>", ",", "\<\"fpmpy\"\>", 
   ",", "\<\"akgkk\"\>"}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6827],

Cell["Count the number of occurrences of letters a-z:", "ExampleText",
 CellID->17078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringCount", "[", 
    RowBox[{"\"\<wolfram research\>\"", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"CharacterRange", "[", 
   RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "0", ",", "1", ",", "0", ",", "2", ",", "1", ",", "0", ",", "1", 
   ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
   "0", ",", "0", ",", "3", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
   ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6182]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ToCharacterCode", "[", "\"\<a\>\"", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "+", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", "25"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "97", ",", "98", ",", "99", ",", "100", ",", "101", ",", "102", ",", "103", 
   ",", "104", ",", "105", ",", "106", ",", "107", ",", "108", ",", "109", 
   ",", "110", ",", "111", ",", "112", ",", "113", ",", "114", ",", "115", 
   ",", "116", ",", "117", ",", "118", ",", "119", ",", "120", ",", "121", 
   ",", "122"}], "}"}]], "Output",
 ImageSize->{458, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"j\"\>", ",", "\<\"k\"\>", ",", "\<\"l\"\>", 
   ",", "\<\"m\"\>", ",", "\<\"n\"\>", ",", "\<\"o\"\>", ",", "\<\"p\"\>", 
   ",", "\<\"q\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"u\"\>", ",", "\<\"v\"\>", ",", "\<\"w\"\>", ",", "\<\"x\"\>", 
   ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], "}"}]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"j\"\>", ",", "\<\"k\"\>", ",", "\<\"l\"\>", 
   ",", "\<\"m\"\>", ",", "\<\"n\"\>", ",", "\<\"o\"\>", ",", "\<\"p\"\>", 
   ",", "\<\"q\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"u\"\>", ",", "\<\"v\"\>", ",", "\<\"w\"\>", ",", "\<\"x\"\>", 
   ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], "}"}]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14136]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5719],

Cell["\<\
Not all letters of all types exist as a contiguous block in character space:\
\>", "ExampleText",
 CellID->8789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<\[ScriptCapitalA]\>\"", ",", "\"\<\[ScriptCapitalZ]\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[ScriptCapitalA]\"\>", ",", "\<\"\:f771\"\>", 
   ",", "\<\"\[ScriptCapitalC]\"\>", ",", "\<\"\[ScriptCapitalD]\"\>", 
   ",", "\<\"\:f774\"\>", ",", "\<\"\:f775\"\>", 
   ",", "\<\"\[ScriptCapitalG]\"\>", ",", "\<\"\:f777\"\>", 
   ",", "\<\"\:f778\"\>", ",", "\<\"\[ScriptCapitalJ]\"\>", 
   ",", "\<\"\[ScriptCapitalK]\"\>", ",", "\<\"\:f77b\"\>", 
   ",", "\<\"\:f77c\"\>", ",", "\<\"\[ScriptCapitalN]\"\>", 
   ",", "\<\"\[ScriptCapitalO]\"\>", ",", "\<\"\[ScriptCapitalP]\"\>", 
   ",", "\<\"\[ScriptCapitalQ]\"\>", ",", "\<\"\:f781\"\>", 
   ",", "\<\"\[ScriptCapitalS]\"\>", ",", "\<\"\[ScriptCapitalT]\"\>", 
   ",", "\<\"\[ScriptCapitalU]\"\>", ",", "\<\"\[ScriptCapitalV]\"\>", 
   ",", "\<\"\[ScriptCapitalW]\"\>", ",", "\<\"\[ScriptCapitalX]\"\>", 
   ",", "\<\"\[ScriptCapitalY]\"\>", ",", "\<\"\[ScriptCapitalZ]\"\>"}], 
  "}"}]], "Output",
 ImageSize->{499, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3875]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3578],

Cell["\<\
A block of character space (the detailed output depends on the fonts that are \
loaded):\
\>", "ExampleText",
 CellID->5656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<a\>\"", ",", 
   RowBox[{"FromCharacterCode", "[", 
    RowBox[{
     RowBox[{"ToCharacterCode", "[", "\"\<a\>\"", "]"}], "+", "500"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11362],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{513, 309},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357373123]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->767],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27340]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23758],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->12297],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Character Codes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharacterCodes"]], "Tutorials",
 CellID->17984],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with CharacterRange",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=CharacterRange"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->185040748],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->584653173],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->880470648],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->37776043],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "MoreAbout",
 CellID->352500052]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CharacterRange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 11.4300714}", "context" -> "System`", 
    "keywords" -> {
     "alphabet", "Greek alphabet", "letters", "ranges of characters", 
      "sequences"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "CharacterRange[\"SubscriptBox[ c, \\\"1\\\"]\", \"SubscriptBox[ c, \\\"2\
\\\"]\"] yields a list of the characters in the range from \"SubscriptBox[ c, \
\\\"1\\\"]\" to \"SubscriptBox[ c, \\\"2\\\"]\". ", 
    "synonyms" -> {"character range"}, "title" -> "CharacterRange", "type" -> 
    "Symbol", "uri" -> "ref/CharacterRange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6940, 203, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->719901180]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43069, 1191}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3374, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3997, 100, 52, 1, 70, "ObjectName",
 CellID->13356],
Cell[4052, 103, 856, 23, 70, "Usage",
 CellID->15133]
}, Open  ]],
Cell[CellGroupData[{
Cell[4945, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5423, 148, 280, 9, 70, "Notes",
 CellID->11548],
Cell[5706, 159, 874, 25, 70, "Notes",
 CellID->21408],
Cell[6583, 186, 320, 12, 70, "Notes",
 CellID->30655]
}, Closed]],
Cell[CellGroupData[{
Cell[6940, 203, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->719901180],
Cell[CellGroupData[{
Cell[7325, 217, 148, 5, 70, "ExampleSection",
 CellID->311217203],
Cell[7476, 224, 59, 1, 70, "ExampleText",
 CellID->30767],
Cell[CellGroupData[{
Cell[7560, 229, 144, 4, 28, "Input",
 CellID->3951],
Cell[7707, 235, 672, 13, 36, "Output",
 CellID->16117]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8428, 254, 216, 7, 70, "ExampleSection",
 CellID->28587],
Cell[8647, 263, 59, 1, 70, "ExampleText",
 CellID->32556],
Cell[CellGroupData[{
Cell[8731, 268, 144, 4, 70, "Input",
 CellID->4207],
Cell[8878, 274, 672, 13, 36, "Output",
 CellID->25027]
}, Open  ]],
Cell[9565, 290, 121, 3, 70, "ExampleDelimiter",
 CellID->20768],
Cell[9689, 295, 70, 1, 70, "ExampleText",
 CellID->16622],
Cell[CellGroupData[{
Cell[9784, 300, 145, 4, 70, "Input",
 CellID->16390],
Cell[9932, 306, 368, 9, 36, "Output",
 CellID->32419]
}, Open  ]],
Cell[10315, 318, 121, 3, 70, "ExampleDelimiter",
 CellID->22729],
Cell[10439, 323, 80, 1, 70, "ExampleText",
 CellID->27477],
Cell[CellGroupData[{
Cell[10544, 328, 159, 4, 70, "Input",
 CellID->26603],
Cell[10706, 334, 836, 16, 36, "Output",
 CellID->20455]
}, Open  ]],
Cell[CellGroupData[{
Cell[11579, 355, 176, 5, 70, "Input",
 CellID->20334],
Cell[11758, 362, 999, 19, 36, "Output",
 CellID->30808]
}, Open  ]],
Cell[12772, 384, 121, 3, 70, "ExampleDelimiter",
 CellID->23883],
Cell[12896, 389, 66, 1, 70, "ExampleText",
 CellID->19662],
Cell[CellGroupData[{
Cell[12987, 394, 145, 4, 70, "Input",
 CellID->10971],
Cell[13135, 400, 1991, 31, 88, "Output",
 CellID->13284]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15175, 437, 222, 7, 70, "ExampleSection",
 CellID->4754],
Cell[15400, 446, 62, 1, 70, "ExampleText",
 CellID->32197],
Cell[CellGroupData[{
Cell[15487, 451, 677, 20, 70, "Input",
 CellID->19192],
Cell[16167, 473, 4335, 75, 70, "Output",
 Evaluatable->False,
 CellID->61813]
}, Open  ]],
Cell[20517, 551, 120, 3, 70, "ExampleDelimiter",
 CellID->7357],
Cell[20640, 556, 76, 1, 70, "ExampleText",
 CellID->25290],
Cell[CellGroupData[{
Cell[20741, 561, 251, 8, 70, "Input",
 CellID->3225],
Cell[20995, 571, 257, 8, 36, "Output",
 CellID->16825]
}, Open  ]],
Cell[21267, 582, 121, 3, 70, "ExampleDelimiter",
 CellID->22374],
Cell[21391, 587, 65, 1, 70, "ExampleText",
 CellID->20772],
Cell[CellGroupData[{
Cell[21481, 592, 275, 8, 70, "Input",
 CellID->26053],
Cell[21759, 602, 173, 5, 36, "Output",
 CellID->19391]
}, Open  ]],
Cell[21947, 610, 121, 3, 70, "ExampleDelimiter",
 CellID->29162],
Cell[22071, 615, 115, 2, 70, "ExampleText",
 CellID->27664],
Cell[CellGroupData[{
Cell[22211, 621, 343, 11, 70, "Input",
 CellID->6364],
Cell[22557, 634, 412, 10, 36, "Output",
 CellID->23859]
}, Open  ]],
Cell[22984, 647, 120, 3, 70, "ExampleDelimiter",
 CellID->6827],
Cell[23107, 652, 86, 1, 70, "ExampleText",
 CellID->17078],
Cell[CellGroupData[{
Cell[23218, 657, 275, 8, 70, "Input",
 CellID->26992],
Cell[23496, 667, 454, 11, 36, "Output",
 CellID->6182]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23999, 684, 233, 7, 70, "ExampleSection",
 CellID->25862],
Cell[CellGroupData[{
Cell[24257, 695, 248, 8, 70, "Input",
 CellID->28240],
Cell[24508, 705, 508, 12, 54, "Output",
 CellID->20963]
}, Open  ]],
Cell[CellGroupData[{
Cell[25053, 722, 105, 3, 70, "Input",
 CellID->31555],
Cell[25161, 727, 672, 13, 36, "Output",
 CellID->19333]
}, Open  ]],
Cell[CellGroupData[{
Cell[25870, 745, 145, 4, 70, "Input",
 CellID->23438],
Cell[26018, 751, 672, 13, 36, "Output",
 CellID->14136]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26739, 770, 225, 7, 70, "ExampleSection",
 CellID->5719],
Cell[26967, 779, 122, 3, 70, "ExampleText",
 CellID->8789],
Cell[CellGroupData[{
Cell[27114, 786, 180, 5, 70, "Input",
 CellID->17209],
Cell[27297, 793, 1026, 20, 36, "Output",
 CellID->3875]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28372, 819, 223, 7, 70, "ExampleSection",
 CellID->3578],
Cell[28598, 828, 134, 4, 70, "ExampleText",
 CellID->5656],
Cell[CellGroupData[{
Cell[28757, 836, 267, 8, 70, "Input",
 CellID->11362],
Cell[29027, 846, 8082, 137, 70, "Output",
 Evaluatable->False,
 CellID->357373123]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37170, 990, 309, 9, 70, "SeeAlsoSection",
 CellID->767],
Cell[37482, 1001, 1443, 53, 70, "SeeAlso",
 CellID->27340]
}, Open  ]],
Cell[CellGroupData[{
Cell[38962, 1059, 314, 9, 70, "TutorialsSection",
 CellID->23758],
Cell[39279, 1070, 151, 3, 70, "Tutorials",
 CellID->12297],
Cell[39433, 1075, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[39610, 1081, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[39752, 1086, 140, 3, 70, "Tutorials",
 CellID->17984],
Cell[39895, 1091, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[40110, 1100, 305, 8, 70, "RelatedLinksSection"],
Cell[40418, 1110, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40825, 1127, 319, 9, 70, "MoreAboutSection",
 CellID->185040748],
Cell[41147, 1138, 151, 3, 70, "MoreAbout",
 CellID->584653173],
Cell[41301, 1143, 147, 3, 70, "MoreAbout",
 CellID->880470648],
Cell[41451, 1148, 169, 3, 70, "MoreAbout",
 CellID->37776043],
Cell[41623, 1153, 147, 3, 70, "MoreAbout",
 CellID->352500052]
}, Open  ]],
Cell[41785, 1159, 27, 0, 70, "History"],
Cell[41815, 1161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

