(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38639,       1347]
NotebookOptionsPosition[     30812,       1059]
NotebookOutlinePosition[     32037,       1095]
CellTagsIndexPosition[     31951,       1090]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Characters in Strings\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String" :> Documentation`HelpLookup["paclet:ref/String"], 
          "StringJoin" :> Documentation`HelpLookup["paclet:ref/StringJoin"], 
          "StringLength" :> 
          Documentation`HelpLookup["paclet:ref/StringLength"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "StringToStream" :> 
          Documentation`HelpLookup["paclet:ref/StringToStream"], 
          "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String\"\>", 
       2->"\<\"StringJoin\"\>", 3->"\<\"StringLength\"\>", 
       4->"\<\"ToCharacterCode\"\>", 5->"\<\"StringExpression\"\>", 
       6->"\<\"StringToStream\"\>", 
       7->"\<\"CharacterRange\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Character Operations\"\>", 3->"\<\"Constructing Lists\"\>", 
       4->"\<\"String Manipulation\"\>", 
       5->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Characters", "ObjectName",
 CellID->31700],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Characters",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Characters"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the characters in a string. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Each character is given as a length one string. ", "Notes",
 CellID->9447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 " handles both ordinary and special characters. "
}], "Notes",
 CellID->14657],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27937]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->879673899],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->2016332],

Cell["Break a string into a list of characters:", "ExampleText",
 CellID->5065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<A string.\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\" \"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"i\"\>", ",", "\<\"n\"\>", ",", "\<\"g\"\>", 
   ",", "\<\".\"\>"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17697]
}, Open  ]],

Cell[TextData[{
 "Show in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3691],

Cell["{\"A\", \" \", \"s\", \"t\", \"r\", \"i\", \"n\", \"g\", \".\"}", \
"Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->32641]
}, Open  ]],

Cell["Reassemble the string:", "ExampleText",
 CellID->2821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2902],

Cell[BoxData["\<\"A string.\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9271]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14222],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 " handles special characters just like ordinary ones:"
}], "ExampleText",
 CellID->24602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", 
  "\"\<\[FilledDiamond]\[Alpha]\[Beta]\[Gamma]\[LongLeftRightArrow]\
\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\[ReturnIndicator]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[FilledDiamond]\"\>", ",", "\<\"\[Alpha]\"\>", 
   ",", "\<\"\[Beta]\"\>", ",", "\<\"\[Gamma]\"\>", 
   ",", "\<\"\[LongLeftRightArrow]\"\>", ",", "\<\"\[ScriptCapitalA]\"\>", 
   ",", "\<\"\[ScriptCapitalB]\"\>", ",", "\<\"\[ScriptCapitalC]\"\>", 
   ",", "\<\"\[ReturnIndicator]\"\>"}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30230]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2107],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 " threads itself element-wise over lists:"
}], "ExampleText",
 CellID->21329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<ABC\>\"", ",", "\"\<DEF\>\"", ",", "\"\<XYZ\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"D\"\>", ",", "\<\"E\"\>", ",", "\<\"F\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"X\"\>", ",", "\<\"Y\"\>", ",", "\<\"Z\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10503]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30738],

Cell["Break a string into overlapping trigrams:", "ExampleText",
 CellID->9126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "\"\<this is a string\>\"", "]"}], ",", "3", 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13382],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtu00AQdWznwsVpAw2UB0QKD1wkLl8BT3xEVCG1DwhU+sfwH8Frr0t0
ctZnduNShBqprse7c2Z2Zvbi48/ry7MvX9eX56fr1aeL9fez89Mfq4/fLupH
xSjLRj+zLDs5zur7TX3X/Lnfr/qvvW3v7rlr0bVusjsgHwi5BPnuwHg37d/h
Xx6vwkN/hh7vrL44EXFQLtxlB93JeS0e+v8LouWep+phNQxl78HAfob0Fnv6
eR/ac5GlnGYJozitL+NaLOC5qq0ZGYUFZ1JfylocC3ysVfQ7hGOtYfQ/j8Tr
4hZrpwzgTQJ4oeeW8TC9kN9j71fb0P0wm6lWbehTnwM11nBlu3kybQxePfcG
y82f2YTY7jnWWy5R+m0xG2kez2gry0z8OMLYDIvNWdav6EXFmhkHUEJRpNYI
Hka704/LmdWr/hzabe7WOXqwpFiPoVdlyskLEcs5yE9Axj1pIryYCn2cnQoP
I6ZOcFjBCg/36opGUaHS9h0UGzZ6OGr6Ya27GnEr6SMRn8L3W23a9RmtYfyW
vh/ioB6zw/RUfhhOTL5VfSCeLd8KFdtj8p229x1RLJV9vjc8M/mFkeYe4Pqh
8ss9QpRu98XVwVIt7ARuqRL2plD553gSR9lSHwwHz7x5cn108xZ3idA8Pdnw
kxhbD0pfy+zcF1pvuv5zP3L/SplZZld3xqyIbuX9V5WRE92512U+Weo2pHtA
nqlzNc/ie+EFtmO2XoKsRrUE+diQ3W35tej/IXI8PEo4S96CjLMd23FWK/13
oh2jrPYYXKUx6owv6LPH2Rp3i/xf/J1afW4ZxP4Z+L8ziAqvrUW1+t0yidfL
JIb0SlN2QgyWjeOJ4rPKK3kv7FTOMcRmhfBiOdMQ54g4qVwj40z3iU8Mx3gT
8bGdqlSvfvaqn+dJ5bD6WTqGuj/7mMZkDcufWn1iXwOGi4w1a5wt/ReY5XZf
VV+EUJ5TG4rbsTGLiKJOsYopQH08JSumcRU5KnxTVv4rzg/PBrH+P6VRZl+r
jCtcdB1Y3ss1SveWrZhGVqtOtDIYyGwr7/EtLOSnJSoxfoaYlmbVSMokY5Ji
efPciGPjMFVuOUoae/k8cqRoZRjGl8+o6+RjbfWyzZ11p+us+XX1bmHOuKbL
soUzzKF/7DcK5eGR8CfE3S0S/cEVIn3mbsuKa8OZ+UZEXXGHsVzcvvptlNQJ
xe2abh16KKKHuzPTwR2Xva1vy8iroY1XkT6h/VieD+0pXrM5WzeChdnLRr8B
qbyGjA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{483, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98975510]
}, Open  ]],

Cell["Reassemble into strings:", "ExampleText",
 CellID->5025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"thi\"\>", ",", "\<\"his\"\>", ",", "\<\"is \"\>", 
   ",", "\<\"s i\"\>", ",", "\<\" is\"\>", ",", "\<\"is \"\>", 
   ",", "\<\"s a\"\>", ",", "\<\" a \"\>", ",", "\<\"a s\"\>", 
   ",", "\<\" st\"\>", ",", "\<\"str\"\>", ",", "\<\"tri\"\>", 
   ",", "\<\"rin\"\>", ",", "\<\"ing\"\>"}], "}"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13917],

Cell["Sort the characters in a string:", "ExampleText",
 CellID->798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"Characters", "[", "\"\<this is a string\>\"", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\" \"\>", ",", "\<\" \"\>", ",", "\<\" \"\>", ",", "\<\"a\"\>", 
   ",", "\<\"g\"\>", ",", "\<\"h\"\>", ",", "\<\"i\"\>", ",", "\<\"i\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"n\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", 
   ",", "\<\"s\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", ",", "\<\"t\"\>"}], 
  "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19966]
}, Open  ]],

Cell["Find their frequencies:", "ExampleText",
 CellID->31584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"Split", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "1", ",", "1", ",", "1", ",", "3", ",", "1", ",", "1", ",", "3", 
   ",", "2"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7997],

Cell["Rotate the characters in a string:", "ExampleText",
 CellID->12686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"RotateLeft", "[", 
   RowBox[{"Characters", "[", "\"\<ABCDEFG\>\"", "]"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->31055],

Cell[BoxData["\<\"BCDEFGA\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6879],

Cell["Make an array out of a list of strings:", "ExampleText",
 CellID->5815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"StringReplace", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<A\>\"", "->", "\"\<BA\>\""}], ",", 
         RowBox[{"\"\<B\>\"", "->", "\"\<A\>\""}]}], "}"}]}], "]"}], "&"}], 
    ",", "\"\<A\>\"", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"BA\"\>", ",", "\<\"ABA\"\>", 
   ",", "\<\"BAABA\"\>", ",", "\<\"ABABAABA\"\>", 
   ",", "\<\"BAABAABABAABA\"\>"}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16462],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtOwzAQdZIGWlB/rFiWy8CKQ0QVUrtAoNLj0C6AewY7aaB6jDNjxy5B
IlIajz1/f5I3vS+2q4fHYrteFou7TfG8Wi9fFrdPG92VJUolO6XUzbXS7VK3
qttce33Xzbp1aX6zZrRUI6CngekZMz4A+qKjf5y90P670hhvVs0KRm3oVJMz
4XN+9ETtpl+qf+5or228Ler0O+rBV6++DEvN3FwZSOb6J9dkTvSfQprnOutk
AzM1/JGjfvt/innov4ct6x178+O5bRSbPXTey9Ghpyxmx3Dj2R4vH75e9zOX
8Ub5NYxzZla+UTUmdY7Fo+Y5aeXCnTgmPOlqQ+ZvCB0YDWY7KakT4/icUVZP
Jl5cU4pmpTAO/N6h93QY2yjlEGck3dys0u8BalYHFh+ofoqm+CRz1UW/i79d
5MNl+X/v/PW9g1z0qYuZlXEhTcfBITzZrIax7RdnTN2yrwqsSpje9LBG8oNW
im7w5hT6cS0hHpXomFlsSvm49Vwjf9PEGo17i8syfrV1rbqErtqgvthVKrS3
q7LIoTj0iquu+FZjbHJon6sS2fTs7dE6VmNiVit43byOsCh+FDC636hCvNrn
nX0/xcbwMXW7W+5/pYbyuj7FUmIUT4HueFoi7Y6CJ4SW0Ej7rZTsAkQLYb7V
OS1+GAW14n8WfjjCz/Z7tOz6IFopspZkMCRijZel/zUozS5H++E2TosfXkUp
WXbjILg6uxJc54rEOF4bKkS5qxYbUrT2UUVpmhL8pZJPhPrBpw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{413, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126003528]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"PadLeft", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31862],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl82OwiAQx6nYZP26e/Rpdk+ePTfGRA+bNerb+XBdKDTWlrY4lA7KNCkf
f5ixDMgvs81ux8Nvdjvts83PJTsfT/vr5vvvIiSeMMbu4t2tmWjnolW89zwX
dbVMhTwXLS5qNi0k/Xy1qsPbOHvkj9FEVVqR5UQWXHVkU1oXC8/Lh2lfcamJ
qnsiVcY57fT+2ixXH/1fPqv0peWy1l8Y/S8GsfLpe/K08kIx+DL5njrMc7V/
/up498u08nmtvzSNN36nPgtm5dO3+o+mekSe0pWuZYxsdNt5KrhNtrWVcge4
tu+qobwimmGodjTz9T2hcM/XGmF3Ju7NOmYscKhJu+0/FqGS1ZZibTTFpmsX
dYmgGCouQX2TOWS6+lLf/e4dRn1PBtOZGFfFYnMXA0NjMzBDJhoD1M+jkUt+
HEs0YDnV593Gbpl3zPGg01KqmAS3zcKxCd6adROzAWoslILwnWJDN3O/GjPN
6eQMq45HdlPOHgrZG7k6kR2gEr2I7HQ/U4woRuGp43K+ntFXOc+Sf/EGyq4=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{187, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->610115894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "data", "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<A\>\"", "->", "Yellow"}], ",", 
      RowBox[{"\"\<B\>\"", "->", "Blue"}]}], "}"}]}], ",", 
   RowBox[{"Mesh", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16183],

Cell[BoxData[
 GraphicsBox[{RasterBox[CompressedData["
1:eJxTTMoPSmVmYGBgA2JeIGZhwAU+2OOnCalDlx/s5g929436nzruoJU8OhgN
v8Etjy6ODkbDl77y6GA0/Ae3PCF9A+2+kSMPACE7CJU=
    "], {{0, 0}, {13, 6}}, {0, 1}], {{
     {GrayLevel[-1 + GoldenRatio]}, 
     LineBox[{{{0, 6}, {13, 6}}, {{0, 5}, {13, 5}}, {{0, 4}, {13, 4}}, {{0, 
      3}, {13, 3}}, {{0, 2}, {13, 2}}, {{0, 1}, {13, 1}}, {{0, 0}, {13, 
      0}}}]}, {
     {GrayLevel[-1 + GoldenRatio]}, 
     LineBox[{{{0, 0}, {0, 6}}, {{1, 0}, {1, 6}}, {{2, 0}, {2, 6}}, {{3, 0}, {
      3, 6}}, {{4, 0}, {4, 6}}, {{5, 0}, {5, 6}}, {{6, 0}, {6, 6}}, {{7, 0}, {
      7, 6}}, {{8, 0}, {8, 6}}, {{9, 0}, {9, 6}}, {{10, 0}, {10, 6}}, {{11, 
      0}, {11, 6}}, {{12, 0}, {12, 6}}, {{13, 0}, {13, 6}}}]}}},
  Frame->False,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->28541]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29359],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 " gives a list of strings of length 1:"
}], "ExampleText",
 CellID->28990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<A string.\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\" \"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"i\"\>", ",", "\<\"n\"\>", ",", "\<\"g\"\>", 
   ",", "\<\".\"\>"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1878]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29639],

Cell["{\"A\", \" \", \"s\", \"t\", \"r\", \"i\", \"n\", \"g\", \".\"}", \
"Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->3908]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8402],

Cell["\<\
A string form of an expression must be created before it can be broken into \
characters:\
\>", "ExampleText",
 CellID->27853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", 
  RowBox[{"x", "+", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16602],

Cell[BoxData[
 RowBox[{"Characters", "[", 
  RowBox[{"x", "+", "y"}], "]"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", 
  RowBox[{"ToString", "[", 
   RowBox[{"x", "+", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"x\"\>", ",", "\<\" \"\>", ",", "\<\"+\"\>", ",", "\<\" \"\>", 
   ",", "\<\"y\"\>"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14474],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 " operates on the explicit character form of strings:"
}], "ExampleText",
 CellID->80],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<\!\(\*
StyleBox[\"red\",
FontColor->RGBColor[1, 0, 0]]\)\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\\!\"\>", ",", "\<\"\\(\"\>", ",", "\<\"\\*\"\>", 
   ",", "\<\" \"\>", ",", "\<\"S\"\>", ",", "\<\"t\"\>", ",", "\<\"y\"\>", 
   ",", "\<\"l\"\>", ",", "\<\"e\"\>", ",", "\<\"B\"\>", ",", "\<\"o\"\>", 
   ",", "\<\"x\"\>", ",", "\<\"[\"\>", ",", "\<\"\\\"\"\>", ",", "\<\"r\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"d\"\>", ",", "\<\"\\\"\"\>", ",", "\<\",\"\>", 
   ",", "\<\"\\n\"\>", ",", "\<\"F\"\>", ",", "\<\"o\"\>", ",", "\<\"n\"\>", 
   ",", "\<\"t\"\>", ",", "\<\"C\"\>", ",", "\<\"o\"\>", ",", "\<\"l\"\>", 
   ",", "\<\"o\"\>", ",", "\<\"r\"\>", ",", "\<\"-\"\>", ",", "\<\">\"\>", 
   ",", "\<\"R\"\>", ",", "\<\"G\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>", 
   ",", "\<\"o\"\>", ",", "\<\"l\"\>", ",", "\<\"o\"\>", ",", "\<\"r\"\>", 
   ",", "\<\"[\"\>", ",", "\<\"1\"\>", ",", "\<\",\"\>", ",", "\<\" \"\>", 
   ",", "\<\"0\"\>", ",", "\<\",\"\>", ",", "\<\" \"\>", ",", "\<\"0\"\>", 
   ",", "\<\"]\"\>", ",", "\<\"]\"\>", ",", "\<\"\\)\"\>"}], "}"}]], "Output",\

 ImageSize->{564, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13801],

Cell["\<\
Characters normally treats special characters just like other characters:\
\>", "ExampleText",
 CellID->857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<\[Alpha]\[Beta]\[Gamma]\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->30693],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Alpha]\"\>", ",", "\<\"\[Beta]\"\>", 
   ",", "\<\"\[Gamma]\"\>"}], "}"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9564]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " to get the characters in the full names of special characters:"
}], "ExampleText",
 CellID->22169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", 
  RowBox[{"ToString", "[", 
   RowBox[{"FullForm", "[", "\"\<\[Alpha]\[Beta]\[Gamma]\>\"", "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\\\"\"\>", ",", "\<\"\\\\\"\>", ",", "\<\"[\"\>", 
   ",", "\<\"A\"\>", ",", "\<\"l\"\>", ",", "\<\"p\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"]\"\>", ",", "\<\"\\\\\"\>", ",", "\<\"[\"\>", 
   ",", "\<\"B\"\>", ",", "\<\"e\"\>", ",", "\<\"t\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"]\"\>", ",", "\<\"\\\\\"\>", ",", "\<\"[\"\>", ",", "\<\"G\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"m\"\>", ",", "\<\"m\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"]\"\>", ",", "\<\"\\\"\"\>"}], "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9477]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8564],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["String",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/String"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringJoin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringToStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringToStream"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17362]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8677],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->26849],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Characters",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Characters"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->351656098],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->102445127],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->239193170],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->16377362],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->145507464],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->431250907]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Characters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 12.0238366}", "context" -> "System`", 
    "keywords" -> {"conversion", "explode"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Characters[\"string\"] gives a list of the characters in a string. ", 
    "synonyms" -> {}, "title" -> "Characters", "type" -> "Symbol", "uri" -> 
    "ref/Characters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5962, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->879673899]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31808, 1083}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3611, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4234, 107, 48, 1, 70, "ObjectName",
 CellID->31700],
Cell[4285, 110, 510, 15, 70, "Usage",
 CellID->29900]
}, Open  ]],
Cell[CellGroupData[{
Cell[4832, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5310, 147, 80, 1, 70, "Notes",
 CellID->9447],
Cell[5393, 150, 218, 7, 70, "Notes",
 CellID->14657],
Cell[5614, 159, 311, 12, 70, "Notes",
 CellID->27937]
}, Closed]],
Cell[CellGroupData[{
Cell[5962, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->879673899],
Cell[CellGroupData[{
Cell[6347, 190, 146, 5, 70, "ExampleSection",
 CellID->2016332],
Cell[6496, 197, 79, 1, 70, "ExampleText",
 CellID->5065],
Cell[CellGroupData[{
Cell[6600, 202, 118, 3, 28, "Input",
 CellID->20068],
Cell[6721, 207, 350, 9, 36, "Output",
 CellID->17697]
}, Open  ]],
Cell[7086, 219, 188, 8, 70, "ExampleText",
 CellID->7533],
Cell[CellGroupData[{
Cell[7299, 231, 100, 3, 28, "Input",
 CellID->3691],
Cell[7402, 236, 221, 6, 50, "Output",
 CellID->32641]
}, Open  ]],
Cell[7638, 245, 60, 1, 70, "ExampleText",
 CellID->2821],
Cell[CellGroupData[{
Cell[7723, 250, 101, 3, 70, "Input",
 CellID->2902],
Cell[7827, 255, 169, 5, 36, "Output",
 CellID->9271]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8045, 266, 216, 7, 70, "ExampleSection",
 CellID->14222],
Cell[8264, 275, 229, 7, 70, "ExampleText",
 CellID->24602],
Cell[CellGroupData[{
Cell[8518, 286, 246, 6, 70, "Input",
 CellID->10511],
Cell[8767, 294, 478, 11, 36, "Output",
 CellID->30230]
}, Open  ]],
Cell[9260, 308, 120, 3, 70, "ExampleDelimiter",
 CellID->2107],
Cell[9383, 313, 217, 7, 70, "ExampleText",
 CellID->21329],
Cell[CellGroupData[{
Cell[9625, 324, 192, 6, 70, "Input",
 CellID->26100],
Cell[9820, 332, 462, 14, 36, "Output",
 CellID->10503]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10331, 352, 223, 7, 70, "ExampleSection",
 CellID->30738],
Cell[10557, 361, 79, 1, 70, "ExampleText",
 CellID->9126],
Cell[CellGroupData[{
Cell[10661, 366, 199, 6, 70, "Input",
 CellID->13382],
Cell[10863, 374, 1500, 29, 70, "Output",
 Evaluatable->False,
 CellID->98975510]
}, Open  ]],
Cell[12378, 406, 62, 1, 70, "ExampleText",
 CellID->5025],
Cell[CellGroupData[{
Cell[12465, 411, 98, 3, 70, "Input",
 CellID->11681],
Cell[12566, 416, 476, 11, 36, "Output",
 CellID->27704]
}, Open  ]],
Cell[13057, 430, 121, 3, 70, "ExampleDelimiter",
 CellID->13917],
Cell[13181, 435, 69, 1, 70, "ExampleText",
 CellID->798],
Cell[CellGroupData[{
Cell[13275, 440, 158, 5, 70, "Input",
 CellID->9337],
Cell[13436, 447, 483, 11, 36, "Output",
 CellID->19966]
}, Open  ]],
Cell[13934, 461, 62, 1, 70, "ExampleText",
 CellID->31584],
Cell[CellGroupData[{
Cell[14021, 466, 126, 4, 70, "Input",
 CellID->15702],
Cell[14150, 472, 275, 9, 36, "Output",
 CellID->337]
}, Open  ]],
Cell[14440, 484, 120, 3, 70, "ExampleDelimiter",
 CellID->7997],
Cell[14563, 489, 73, 1, 70, "ExampleText",
 CellID->12686],
Cell[CellGroupData[{
Cell[14661, 494, 193, 6, 70, "Input",
 CellID->31055],
Cell[14857, 502, 167, 5, 36, "Output",
 CellID->7457]
}, Open  ]],
Cell[15039, 510, 120, 3, 70, "ExampleDelimiter",
 CellID->6879],
Cell[15162, 515, 77, 1, 70, "ExampleText",
 CellID->5815],
Cell[CellGroupData[{
Cell[15264, 520, 415, 13, 70, "Input",
 CellID->29159],
Cell[15682, 535, 322, 9, 36, "Output",
 CellID->10847]
}, Open  ]],
Cell[CellGroupData[{
Cell[16041, 549, 105, 3, 70, "Input",
 CellID->16462],
Cell[16149, 554, 996, 20, 70, "Output",
 Evaluatable->False,
 CellID->126003528]
}, Open  ]],
Cell[CellGroupData[{
Cell[17182, 579, 130, 4, 70, "Input",
 CellID->31862],
Cell[17315, 585, 761, 17, 70, "Output",
 Evaluatable->False,
 CellID->610115894]
}, Open  ]],
Cell[CellGroupData[{
Cell[18113, 607, 371, 11, 70, "Input",
 CellID->16183],
Cell[18487, 620, 997, 22, 130, "Output",
 CellID->28541]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19533, 648, 233, 7, 70, "ExampleSection",
 CellID->29359],
Cell[19769, 657, 214, 7, 70, "ExampleText",
 CellID->28990],
Cell[CellGroupData[{
Cell[20008, 668, 118, 3, 70, "Input",
 CellID->20622],
Cell[20129, 673, 349, 9, 36, "Output",
 CellID->1878]
}, Open  ]],
Cell[CellGroupData[{
Cell[20515, 687, 101, 3, 70, "Input",
 CellID->29639],
Cell[20619, 692, 220, 6, 50, "Output",
 CellID->3908]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20888, 704, 225, 7, 70, "ExampleSection",
 CellID->8402],
Cell[21116, 713, 136, 4, 70, "ExampleText",
 CellID->27853],
Cell[CellGroupData[{
Cell[21277, 721, 125, 4, 70, "Input",
 CellID->16602],
Cell[21405, 727, 214, 7, 36, "Output",
 CellID->12008]
}, Open  ]],
Cell[CellGroupData[{
Cell[21656, 739, 161, 5, 70, "Input",
 CellID->12178],
Cell[21820, 746, 273, 8, 36, "Output",
 CellID->28869]
}, Open  ]],
Cell[22108, 757, 121, 3, 70, "ExampleDelimiter",
 CellID->14474],
Cell[22232, 762, 226, 7, 70, "ExampleText",
 CellID->80],
Cell[CellGroupData[{
Cell[22483, 773, 162, 5, 70, "Input",
 CellID->41],
Cell[22648, 780, 1146, 20, 54, "Output",
 CellID->23976]
}, Open  ]],
Cell[23809, 803, 121, 3, 70, "ExampleDelimiter",
 CellID->13801],
Cell[23933, 808, 118, 3, 70, "ExampleText",
 CellID->857],
Cell[CellGroupData[{
Cell[24076, 815, 134, 4, 70, "Input",
 CellID->30693],
Cell[24213, 821, 256, 8, 36, "Output",
 CellID->9564]
}, Open  ]],
Cell[24484, 832, 374, 13, 70, "ExampleText",
 CellID->22169],
Cell[CellGroupData[{
Cell[24883, 849, 206, 6, 70, "Input",
 CellID->17708],
Cell[25092, 857, 668, 13, 36, "Output",
 CellID->9477]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25821, 877, 310, 9, 70, "SeeAlsoSection",
 CellID->8564],
Cell[26134, 888, 1738, 62, 70, "SeeAlso",
 CellID->17362]
}, Open  ]],
Cell[CellGroupData[{
Cell[27909, 955, 313, 9, 70, "TutorialsSection",
 CellID->8677],
Cell[28225, 966, 151, 3, 70, "Tutorials",
 CellID->26849],
Cell[28379, 971, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[28556, 977, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[28698, 982, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[28913, 991, 305, 8, 70, "RelatedLinksSection"],
Cell[29221, 1001, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29623, 1018, 319, 9, 70, "MoreAboutSection",
 CellID->351656098],
Cell[29945, 1029, 169, 3, 70, "MoreAbout",
 CellID->102445127],
Cell[30117, 1034, 151, 3, 70, "MoreAbout",
 CellID->239193170],
Cell[30271, 1039, 146, 3, 70, "MoreAbout",
 CellID->16377362],
Cell[30420, 1044, 149, 3, 70, "MoreAbout",
 CellID->145507464],
Cell[30572, 1049, 145, 3, 70, "MoreAbout",
 CellID->431250907]
}, Open  ]],
Cell[30732, 1055, 50, 0, 70, "History"],
Cell[30785, 1057, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

