(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87735,       2231]
NotebookOptionsPosition[     79865,       1952]
NotebookOutlinePosition[     81214,       1990]
CellTagsIndexPosition[     81128,       1985]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OrthogonalPolynomials"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Orthogonal Polynomials\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChebyshevT" :> 
          Documentation`HelpLookup["paclet:ref/ChebyshevT"], "GegenbauerC" :> 
          Documentation`HelpLookup["paclet:ref/GegenbauerC"], "JacobiP" :> 
          Documentation`HelpLookup["paclet:ref/JacobiP"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ChebyshevT\"\>", 2->"\<\"GegenbauerC\"\>", 
       3->"\<\"JacobiP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ChebyshevU", "ObjectName",
 CellID->11682],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChebyshevU",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChebyshevU"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Chebyshev polynomial of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["U", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Explicit polynomials are given for integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31767],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["U", "n"], "(", 
     RowBox[{"cos", " ", "\[Theta]"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "\[Theta]"}], "]"}], "/", "sin"}], 
     " ", "\[Theta]"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->15347],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ChebyshevU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevU"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->10409698],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevU"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevU"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChebyshevU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevU"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " for non-integer ",
 Cell[BoxData["n"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18217]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92855262],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->260396685],

Cell[TextData[{
 "Compute the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "th"], TraditionalForm]]],
 " ",
 Cell[BoxData[
  ButtonBox["ChebyshevU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevU"]], "InlineFormula"],
 " polynomial:"
}], "ExampleText",
 CellID->18453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{"10", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25677],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"60", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"560", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"1792", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"2304", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"1024", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279878139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53466006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ChebyshevU", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16695],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNW1uIXVcZ3p1z9rnPmTkzmUyamWTSpE1M64P3N1EQm7QitQUTk1jMNAiJ
oi01vuiLvpgXfdEXC2IfvICXh4pQESqIBbEgFsSKqFQqSH2wCBYfAsLxW+tf
e31rf2edPWdwhIb0ZF/W///f//2Xtfbaux/cvXn945/avXnj2u6Jc0/uPnH9
xrXPnLj/8SdxqXVHURQv479bRwocT3Hk/3tiOp0WLXfk/xSfdD9F/uoafpe+
8+0XPyp3L/vz11+//cUvPPfqq/8qxn70xP22X3nln49e+d61x374pz/+44qT
h5j/99aXfl60blx/JugYJTI/+P5vv/bVX/7omZe+8uXnr4itS+6nvH37Pw8/
9C1Y/MADT+O3WE6kP3vz2Rd+9VfguPjh7+alcRuDcPj5z/30+V/8JZUuofa1
1/6NQzsIvtU1LD39zV8XLRw89fUXQEeQX3W/HSB7//u+YYNN/eXgtddU2jUc
/uy5P4OumqxxZbLQC+0560VpTuMQnILZmo7oG/7AEMw9jKM2VJSi6yN+PHyE
p3bJ+Ey1GQq7a+geSbQU87S2IopiyZ+DEhDjDofU3jL6OCr6VTwYMLdEeztc
v+ivW55QHvAAUq0g0X7y7B84Cjn30u/+7g4fEe1qzXxBEiIVKf/4p3/84m/+
plZ4dUmkFrNCVEuCOrVidcRRZOAhTw+1zosMOTYNEIcStYPSQQFxFOP5oall
cwf/tmIkYhYF72Le1LS+591PBSymNeZ7wEasphWEWIMIWkEIaKHWFX81VpzP
jtTKxaxWKzxqtSpRrdY/qJWM5LS6jmDjkARIBdXGqzbKelQlTR4BDPCIjShS
bUTcllzLe8zcakm0Uq1kty0xzGuNnXKG90GilRnaFuyq9YJE0/KXnYNaHdt2
1xpgyuMFyaxSopdiY+4bNut/87GxCkwr+02qlZVro1hxF7JabZ7jeHaSVCsz
w0axExx3jICjd4n2d1Y+hfPj/pw9t5RMTK0Rg42Ks1ax7X460IpLiA3+Yiy4
fUfg/+1eCD7BbfxFkoCMYFt9IFNNthmlrcojDHHztnURDDYyivsCBu18b3M/
XSQNeDY+kLgw7qbxY8JmEzLGu5TIbQnyWGcoPbciuk8QteX8raKvLSi2JJPK
UAVp/TLHS8nWo9N6Pdt9dtdT0/xs68/bGIdLCBy0v6ViHJqRckETjmDcrZaO
Sh11MjhZ0SbNWr2zYg3anPZukL7Xxy/iwh8ggAzge7i+AwZm3lwhwk2XE11/
zt5mNtg3OsJ8Gm92tOhn6E13SmZ2hYez7rwXEcM8ciPkThHyFjaBwWWHYWan
7ElOHvHn7Jwd8ckwj4V7w8QuvSns9sXqm3y0DbPpbs3wDrRW7sW9lTXEwXnc
F4xHRLth5tybYuYsZ5g5X22GDBgIv2emtgpJLWr2xjUG1LlnhLMSs4FUzabc
71S5HmbuJsTsbJvC+kB4OFOhQnhdFNrBk7bU7Bnx2FdQUsNmh325CS2vGlrO
AYfF6lCsnpZq0s6q64/TgnIoObcpmd2p2AgdoAk1a/SwcD4Sju8RL/OogQdW
XS7fI177J6BkZjR77L4dyYEUNbnsyvlGZQWKHBfL1bk9yRZ3V1qByt3vTLnS
TvP8bmHD9LAbbFSVWesDitZdbcVeFKu+cBa7EpUNsdANyNKKc8Xorp0S7jrC
fUdid1dVySWzwhQ6oV7lCzhynBgSzlw5L9xhRBc06Jzm9kHMl4pf9vaNXGXV
nqx8/rTJT+G9SGPUzXrNOjiR6ESeR85Vgjwe8ufsn3P9iiiX7J9WCE6IT36O
T/nQeWNd8tbpbcdH/8Rgbf1aRFYYV/XRztlxdxIf3PbQPFaYicYK+01kJaww
5rEylz3MNSkLXNGtC//dGc1lMsJ5f0JyohcyvSe5EL22NJ/rNavAvGbXjd6E
mex/9ZrrznU5z3ttM7Gli7t6XOKudnsS9+OVVmvhiVabPVkF63J+sJ67lYZx
y14/L844MAcsfkmc+1lvGe/orT1OZJ5XTAM7vHnNp49Fva76dFnlS+gDPcnl
NX/OrtoPcpX8jsRTPexLPO2ZKjSBRI+N40xkfnGVXY3zskmk2M3Hko89Qb5W
iyKrd1tiNKjlF2NjyDk7KfMT8aAvdvoNKLnrsiZ8rgu6bbk/EL4Hwnd8Lq71
B96fVPEI66km1HI1qYTVykpYV5gVrl+2xIthFjW53pIsN31cL03kvuHhvNyE
mtwZal0dsXfaEyufOBT1UDLiqOiPLITZ0VBz7dmXXDDUrqP/PtapZ6aTPmfZ
U4nuEvgaKKNuL5uTtrlbpfOzinuGtvWWVrWOXxL+dc2Vn93ny+tKZK68BWvm
vvZ008+1QBZfjSeLYp7lWD2B5W5jpCy3mau2f8BdhsViQflNkd+Lq5GMX543
PmSpyi+L/GjGT9u18X0T/VW5LRdgh5WtO8PjLBvsLPqsq94ty/3DwqbtRbCT
mT3248qr9DmOs5LVBVf7K2LNtLPbbgiXTp8DayjZhQ2l7vKw0+hTsO4k9LNo
B3KuT5m6/7Uh6DUWY0F5SORNH/vrWLgfyP0m1Jxnlaujwvl6FcEwl6xkUXMu
MtTswoaa8/hYWMijNlScAYeZvHR5pDPhumhXtCvC8Zp4Z/q4U6X7E4aW67kU
rbxBSmYmu8+Z06zwuW8iKFZDHus7qDXxbku4XpbYDiS2TWgZgVHFfVjjbEs1
TATFqnCs709XpS50hTiq7oddgeE+UHM9OhKt25XWsNO0KhxPsqgpvypeb0tG
6jzQhJooh+LrSLg8Jlb1jZSinkhmjcVrfT4cSv42oebVkeTVUM6PidWxcLMW
8nki18firb430zoaSg40oWWvGIjUjljV6lwTjtekymK+Bm93xL72qv2gpq/a
F3cqq2F/eCT317OogQ9hclWnmRb1hXWKxrQJtfYKedeQcGU7M1yPDATVIUG9
LvptPPfwbZ+L/bifrSeuN5pQc50RtYQOdVK80Kc4h9o9025Iddo4PuHcJXbt
PruB4eLc3MuitXOuqXqSOSclM/zuF+bGlVB1uiI2zqEM492uSE8y72Qu8jP1
shhq3T9i/p2qrIS3XHFdHuR1VtF1+UZWnvZt7153xnSuzHnhuBsLJybNdUF8
gwAD7v14fAsNA273R3uIoj+cyCN5wn3EBPJuP/Z0wKHP2IaaK4ccan0vwkj6
d0Zd+6IAqQ/mkALhuwHtH62QPZsVMqQ51BRLkPIIAo/2Hoo9vVuND/PkWJjL
Ia6/QXHX7Q0ishNp7t6Kb+zBp19ltmEC4/EXxXBW7Gp+NOPSdaJJszu+dw88
90v+dCT7xqIvrSHumGgW6lt8h4K7jmqdfaYjvupOTmpdMbLPlILmXLB+Xnxp
C0r91iRvbUUy2xjlLHtefDw3rXcl/ZJqP1bJuH6nlrfKtbFZZcdvssoVge5Z
tCTbzgdmH/DX2TOXRG5V9KbWiMG+L42jptU3Bw+Kb+YruIZ2x7juIuk3nk3W
rLNZPYIdUKXWvG8lVKNXgU94CEsza628Dfv6GDwgN3DVtQ/R7q210VnRV8Af
7C+m+WpgfrdhNOvoqli9KvFaXCr2+gMY7QbnRrG2FtHJmdF9MdrOrCNMi3xL
MyN9KZEq5mphX85r0a+zWwHTxxaS1m/TdU8tj0GfS/Vb/P1o4Rzs+Zh9xz2j
R94/z+ipvnUvk4in3TovtZu1dZBS7Pv7keLV3QX8qY+etUHkbwwpdpT8aObM
fmzsJcXMXUzKzuvvCPNSzp/HFhp9aZr/TrTJFjvKXhU3X4vrZo8uJC3vn6N0
9X/QVPVlo9lp66MVqa4Hm6UXQzpP+nLCMSOTG52udPLR5youleI8mJfi/HnQ
UvTn/2djUSlezUvxWXe+FDPpVv1LjwVtvNGk9vKHWahzcL5CDkKLq4leVtp1
o9xKZm+pdAVTBi1XM1JxiV2bn2f9xNq1Vp035oy2/xvwE3t4baNenvkt7vgv
UY/75g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{222, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->130112607]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31585],

Cell["Evaluate for complex arguments and orders:", "ExampleText",
 CellID->4691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{
   RowBox[{"3.", "+", "I"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28911],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.927087441441004`"}], "+", 
  RowBox[{"0.34865943047445674`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244775869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114595362],

Cell["Evaluate for large orders:", "ExampleText",
 CellID->488113904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChebyshevU", "[", 
   RowBox[{
    RowBox[{"10", "^", "5"}], ",", "2"}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48014888],

Cell[BoxData[
 TagBox[
  RowBox[{"61250587746919697796974285989386973", 
   RowBox[{"\[LeftSkeleton]", "57125", "\[RightSkeleton]"}], 
   "72316017360490595741986641284522369"}],
  Short]], "Output",
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->143739397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29388],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->24896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ChebyshevU", "[", 
    RowBox[{"10", ",", " ", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3297],

Cell[BoxData["0.\
8774238344425815847855171129062304188047215024809903639350370031668`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286746040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4473],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevU"]], "InlineFormula"],
 " threads element-wise over the list:"
}], "ExampleText",
 CellID->24837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", "x"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "3"]}]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["x", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "-", 
    RowBox[{"32", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["x", "5"]}]}]}], "}"}]], "Output",
 ImageSize->{382, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33679691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1902],

Cell["\<\
Simple cases give exact symbolic results even for arbitrary order:\
\>", "ExampleText",
 CellID->22065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{"n", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15598],

Cell[BoxData[
 RowBox[{"1", "+", "n"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110327225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23581161],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->327037745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChebyshevU", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9323138],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["U", "n"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->170351373]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22871],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChebyshevU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevU"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->15143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{"10", ",", " ", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "6"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3000],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"60", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"60", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   RowBox[{"505", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"1070", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-1, 0, 60, -60, -505, 1070}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->780987062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{"10", ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12793],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2865"}], ",", "2875"}], "}"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169430895]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12314],

Cell[TextData[{
 "Approximate a function on the interval ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], "<=", "x", "<=", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8091],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["2", "\[Pi]"], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "1"}], "1"], 
        RowBox[{
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}]], " ", 
         RowBox[{"ChebyshevU", "[", 
          RowBox[{"n", ",", "x"}], "]"}], " ", 
         RowBox[{"Sinc", "[", 
          RowBox[{"2", "x", " ", "\[Pi]"}], "]"}], 
         RowBox[{"\[DifferentialD]", "x"}]}]}]}], ")"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"2", "\[Pi]", " ", "x"}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{"coeffs", ".", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"ChebyshevU", "[", 
          RowBox[{"n", ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14275],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->229183092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27116],

Cell["Build a curve that passes through given points:", "ExampleText",
 CellID->17554],

Cell[BoxData[
 RowBox[{
  RowBox[{"curve", "[", "pts_List", "]"}], ":=", 
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", " ", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", "=", 
         RowBox[{"Length", "[", "pts", "]"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"pts", ".", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"ChebyshevU", "[", 
            RowBox[{
             RowBox[{"n", "-", "1"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Sin", "[", 
                FractionBox[
                 RowBox[{"k", " ", "\[Pi]"}], "n"], "]"}], " ", 
               SqrtBox[
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"]}]]}], "+", 
              RowBox[{"x", " ", 
               RowBox[{"Cos", "[", 
                FractionBox[
                 RowBox[{"\[Pi]", " ", "k"}], "n"], "]"}]}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "0", ",", 
             RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], "/", "n"}]}], "]"}],
      "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2671],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", "[", "pts_List", "]"}], ":=", 
  RowBox[{"MapIndexed", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1."}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"First", "[", "#2", "]"}], ")"}], "*", 
          RowBox[{"Pi", "/", 
           RowBox[{"Length", "[", "pts", "]"}]}]}], "]"}]}], ",", "#1"}], 
      "}"}], "&"}], ",", 
    RowBox[{"Reverse", "[", "pts", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"curve", "[", 
      RowBox[{"Range", "[", "15", "]"}], "]"}], "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"points", "[", 
        RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10040],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[3]=",
 CellID->504017022]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10879],

Cell[TextData[{
 "Light amplitude transmission through ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " layers of glass:"
}], "ExampleText",
 CellID->13371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["k", "2"], " ", 
          SuperscriptBox[
           RowBox[{"ChebyshevU", "[", 
            RowBox[{"n", ",", 
             RowBox[{
              RowBox[{"Cos", "[", "k", "]"}], "+", 
              RowBox[{"Sinc", "[", "k", "]"}]}]}], "]"}], "2"]}]}], ")"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17453],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->14695580]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22445],

Cell[TextData[{
 "Get the list of coefficients in a ",
 Cell[BoxData[
  ButtonBox["ChebyshevU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevU"]], "InlineFormula"],
 " polynomial:"
}], "ExampleText",
 CellID->19894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", " ", 
  RowBox[{
   RowBox[{"ChebyshevU", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "60", ",", "0", ",", 
   RowBox[{"-", "560"}], ",", "0", ",", "1792", ",", "0", ",", 
   RowBox[{"-", "2304"}], ",", "0", ",", "1024"}], "}"}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->681945229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6901],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand through trigonometric functions:"
}], "ExampleText",
 CellID->21037176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"ChebyshevU", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11045],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"ArcCos", "[", "x", "]"}]}], "]"}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", "x"}]], " ", 
   SqrtBox[
    RowBox[{"1", "+", "x"}]]}]]], "Output",
 ImageSize->{150, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238444171]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1589],

Cell["\<\
Cancellations in the polynomial form may lead to inaccurate numerical \
results:\
\>", "ExampleText",
 CellID->377633235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChebyshevU", "[", 
   RowBox[{"60", ",", "x"}], "]"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300499535],

Cell[BoxData["0``-1.7058620018488975"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5991120]
}, Open  ]],

Cell["Evaluate the function directly:", "ExampleText",
 CellID->370676016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{"60", ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60075057],

Cell[BoxData["1.1568372648685898865460594449`13.509024890792636"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50366208]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32737],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevT"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiP"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31960],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->28360]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->21813],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ChebyshevPolynomialoftheSecondKind.html"]\
, None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Polynomials/ChebyshevU/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->592504838],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->131751228]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChebyshevU - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 13.6801290}", "context" -> "System`", 
    "keywords" -> {
     "Chebyshev functions", "Tschebyscheff polynomials", "Chebychev", 
      "Chebyshov", "Tchebycheff ", "Chebyshev polynomial"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ChebyshevU[n, x] gives the Chebyshev polynomial of the second kind U_n \
(x). ", "synonyms" -> {"Chebyshev U"}, "title" -> "ChebyshevU", "type" -> 
    "Symbol", "uri" -> "ref/ChebyshevU"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5883, 212, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->92855262]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 80986, 1978}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1949, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2572, 76, 48, 1, 70, "ObjectName",
 CellID->11682],
Cell[2623, 79, 701, 23, 70, "Usage",
 CellID->25793]
}, Open  ]],
Cell[CellGroupData[{
Cell[3361, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3839, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3962, 130, 155, 6, 70, "Notes",
 CellID->31767],
Cell[4120, 138, 417, 16, 70, "Notes",
 CellID->15347],
Cell[4540, 156, 251, 8, 70, "Notes",
 CellID->10409698],
Cell[4794, 166, 222, 7, 70, "Notes",
 CellID->31226],
Cell[5019, 175, 205, 7, 70, "Notes",
 CellID->28162],
Cell[5227, 184, 619, 23, 70, "Notes",
 CellID->18217]
}, Closed]],
Cell[CellGroupData[{
Cell[5883, 212, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92855262],
Cell[CellGroupData[{
Cell[6267, 226, 148, 5, 70, "ExampleSection",
 CellID->260396685],
Cell[6418, 233, 289, 12, 70, "ExampleText",
 CellID->18453],
Cell[CellGroupData[{
Cell[6732, 249, 126, 4, 28, "Input",
 CellID->25677],
Cell[6861, 255, 492, 17, 36, "Output",
 CellID->279878139]
}, Open  ]],
Cell[7368, 275, 124, 3, 70, "ExampleDelimiter",
 CellID->53466006],
Cell[CellGroupData[{
Cell[7517, 282, 263, 9, 28, "Input",
 CellID->16695],
Cell[7783, 293, 4299, 75, 156, "Output",
 Evaluatable->False,
 CellID->130112607]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12131, 374, 216, 7, 70, "ExampleSection",
 CellID->31585],
Cell[12350, 383, 80, 1, 70, "ExampleText",
 CellID->4691],
Cell[CellGroupData[{
Cell[12455, 388, 174, 6, 70, "Input",
 CellID->28911],
Cell[12632, 396, 270, 8, 36, "Output",
 CellID->244775869]
}, Open  ]],
Cell[12917, 407, 125, 3, 70, "ExampleDelimiter",
 CellID->114595362],
Cell[13045, 412, 69, 1, 70, "ExampleText",
 CellID->488113904],
Cell[CellGroupData[{
Cell[13139, 417, 183, 6, 70, "Input",
 CellID->48014888],
Cell[13325, 425, 337, 10, 54, "Output",
 CellID->143739397]
}, Open  ]],
Cell[13677, 438, 121, 3, 70, "ExampleDelimiter",
 CellID->29388],
Cell[13801, 443, 66, 1, 70, "ExampleText",
 CellID->24896],
Cell[CellGroupData[{
Cell[13892, 448, 211, 7, 70, "Input",
 CellID->3297],
Cell[14106, 457, 235, 7, 36, "Output",
 CellID->286746040]
}, Open  ]],
Cell[14356, 467, 120, 3, 70, "ExampleDelimiter",
 CellID->4473],
Cell[14479, 472, 213, 7, 70, "ExampleText",
 CellID->24837],
Cell[CellGroupData[{
Cell[14717, 483, 207, 7, 70, "Input",
 CellID->28861],
Cell[14927, 492, 780, 28, 39, "Output",
 CellID->33679691]
}, Open  ]],
Cell[15722, 523, 120, 3, 70, "ExampleDelimiter",
 CellID->1902],
Cell[15845, 528, 113, 3, 70, "ExampleText",
 CellID->22065],
Cell[CellGroupData[{
Cell[15983, 535, 125, 4, 70, "Input",
 CellID->15598],
Cell[16111, 541, 180, 6, 36, "Output",
 CellID->110327225]
}, Open  ]],
Cell[16306, 550, 124, 3, 70, "ExampleDelimiter",
 CellID->23581161],
Cell[16433, 555, 203, 7, 70, "ExampleText",
 CellID->327037745],
Cell[CellGroupData[{
Cell[16661, 566, 166, 5, 70, "Input",
 CellID->9323138],
Cell[16830, 573, 254, 8, 50, "Output",
 CellID->170351373]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17133, 587, 239, 7, 70, "ExampleSection",
 CellID->22871],
Cell[17375, 596, 209, 7, 70, "ExampleText",
 CellID->15143],
Cell[CellGroupData[{
Cell[17609, 607, 268, 9, 70, "Input",
 CellID->3000],
Cell[17880, 618, 709, 23, 36, "Output",
 CellID->780987062]
}, Open  ]],
Cell[18604, 644, 121, 3, 70, "ExampleDelimiter",
 CellID->15772],
Cell[CellGroupData[{
Cell[18750, 651, 235, 8, 70, "Input",
 CellID->12793],
Cell[18988, 661, 266, 9, 36, "Output",
 CellID->169430895]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19303, 676, 223, 7, 70, "ExampleSection",
 CellID->12314],
Cell[19529, 685, 190, 7, 70, "ExampleText",
 CellID->8091],
Cell[19722, 694, 726, 23, 70, "Input",
 CellID->10953],
Cell[CellGroupData[{
Cell[20473, 721, 604, 20, 70, "Input",
 CellID->14275],
Cell[21080, 743, 7560, 128, 70, "Output",
 Evaluatable->False,
 CellID->229183092]
}, Open  ]],
Cell[28655, 874, 121, 3, 70, "ExampleDelimiter",
 CellID->27116],
Cell[28779, 879, 86, 1, 70, "ExampleText",
 CellID->17554],
Cell[28868, 882, 1191, 35, 70, "Input",
 CellID->2671],
Cell[30062, 919, 576, 19, 70, "Input",
 CellID->8476],
Cell[CellGroupData[{
Cell[30663, 942, 604, 19, 70, "Input",
 CellID->10040],
Cell[31270, 963, 4941, 85, 70, "Output",
 Evaluatable->False,
 CellID->504017022]
}, Open  ]],
Cell[36226, 1051, 121, 3, 70, "ExampleDelimiter",
 CellID->10879],
Cell[36350, 1056, 177, 6, 70, "ExampleText",
 CellID->13371],
Cell[CellGroupData[{
Cell[36552, 1066, 778, 24, 70, "Input",
 CellID->17453],
Cell[37333, 1092, 36103, 596, 70, "Output",
 Evaluatable->False,
 CellID->14695580]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73485, 1694, 233, 7, 70, "ExampleSection",
 CellID->22445],
Cell[73721, 1703, 228, 8, 70, "ExampleText",
 CellID->19894],
Cell[CellGroupData[{
Cell[73974, 1715, 199, 6, 70, "Input",
 CellID->22769],
Cell[74176, 1723, 363, 10, 36, "Output",
 CellID->681945229]
}, Open  ]],
Cell[74554, 1736, 120, 3, 70, "ExampleDelimiter",
 CellID->6901],
Cell[74677, 1741, 240, 8, 70, "ExampleText",
 CellID->21037176],
Cell[CellGroupData[{
Cell[74942, 1753, 167, 5, 70, "Input",
 CellID->11045],
Cell[75112, 1760, 418, 16, 55, "Output",
 CellID->238444171]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75579, 1782, 225, 7, 70, "ExampleSection",
 CellID->1589],
Cell[75807, 1791, 131, 4, 70, "ExampleText",
 CellID->377633235],
Cell[CellGroupData[{
Cell[75963, 1799, 265, 9, 70, "Input",
 CellID->300499535],
Cell[76231, 1810, 177, 5, 36, "Output",
 CellID->5991120]
}, Open  ]],
Cell[76423, 1818, 74, 1, 70, "ExampleText",
 CellID->370676016],
Cell[CellGroupData[{
Cell[76522, 1823, 210, 7, 70, "Input",
 CellID->60075057],
Cell[76735, 1832, 206, 5, 36, "Output",
 CellID->50366208]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77002, 1844, 311, 9, 70, "SeeAlsoSection",
 CellID->32737],
Cell[77316, 1855, 704, 26, 70, "SeeAlso",
 CellID->31361]
}, Open  ]],
Cell[CellGroupData[{
Cell[78057, 1886, 314, 9, 70, "TutorialsSection",
 CellID->31960],
Cell[78374, 1897, 154, 3, 70, "Tutorials",
 CellID->28360]
}, Open  ]],
Cell[CellGroupData[{
Cell[78565, 1905, 321, 9, 70, "RelatedLinksSection",
 CellID->21813],
Cell[78889, 1916, 203, 4, 70, "RelatedLinks"],
Cell[79095, 1922, 194, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79326, 1931, 319, 9, 70, "MoreAboutSection",
 CellID->592504838],
Cell[79648, 1942, 145, 3, 70, "MoreAbout",
 CellID->131751228]
}, Open  ]],
Cell[79808, 1948, 27, 0, 70, "History"],
Cell[79838, 1950, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

