(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59354,       2065]
NotebookOptionsPosition[     48679,       1716]
NotebookOutlinePosition[     51075,       1768]
CellTagsIndexPosition[     50989,       1763]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Toggler" :> Documentation`HelpLookup["paclet:ref/Toggler"], 
          "Opener" :> Documentation`HelpLookup["paclet:ref/Opener"], "Setter" :> 
          Documentation`HelpLookup["paclet:ref/Setter"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"], "RadioButton" :> 
          Documentation`HelpLookup["paclet:ref/RadioButton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Toggler\"\>", 2->"\<\"Opener\"\>", 
       3->"\<\"Setter\"\>", 4->"\<\"Panel\"\>", 
       5->"\<\"RadioButton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], "Generalized Input" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedInput"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Inspectors\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Document Generation\"\>", 
       5->"\<\"Dynamic Interactivity Language\"\>", 
       6->"\<\"Generalized Input\"\>", 7->"\<\"Toolbars\"\>", 
       8->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Checkbox", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Checkbox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Checkbox"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a checkbox with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", displayed as ",
     Cell[BoxData[
      TagBox[
       CheckboxBox[True],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      TagBox[
       CheckboxBox[False],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Checkbox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Checkbox"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being toggled if the checkbox is clicked. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Checkbox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Checkbox"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a checkbox that toggles between values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", and displays as ",
     Cell[BoxData[
      TagBox[
       CheckboxBox[True],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " and ",
     Cell[BoxData[
      TagBox[
       CheckboxBox[False],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " respectively. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Checkbox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Checkbox"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["3", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a checkbox that cycles through values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", and displays as ",
     Cell[BoxData[
      TagBox[
       CheckboxBox[3, {1, 2, 3}],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " for all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ">", "2"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " is effectively a special case of ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13568],

Cell["The following options can be given: ", "Notes",
 CellID->5703],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the checkbox ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to change the checkbox automatically when the mouse is over it \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the checkbox is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed checkbox ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->12829],

Cell[TextData[{
 "Typical possible settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13002],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"], "[", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15016]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284501301],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->560724925],

Cell[TextData[{
 "The default states for ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->830464174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", "False", "]"}], ",", 
   RowBox[{"Checkbox", "[", "True", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236081946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[False], ",", 
   CheckboxBox[True]}], "}"}]], "Output",
 ImageSize->{56, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60395610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5499267],

Cell["Using different values for states:", "ExampleText",
 CellID->48010555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Checkbox", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Checkbox", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107649430],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[1, {1, 2, 3}], ",", 
   CheckboxBox[2, {1, 2, 3}], ",", 
   CheckboxBox[3, {1, 2, 3}]}], "}"}]], "Output",
 ImageSize->{80, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183632877]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11831],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " variables within ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " the state variable is dynamically updated:"
}], "ExampleText",
 CellID->317513876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414984996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171479238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->162762893],

Cell[TextData[{
 "Here the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " cycles through the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->346941134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116331372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`x], {1, 2, 3, 4}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147418342]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4687120],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->688710124],

Cell["Control the appearance of checkbox:", "ExampleText",
 CellID->777161034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"Appearance", "\[Rule]", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->569683149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[False,
    Appearance->Tiny], ",", 
   CheckboxBox[False,
    Appearance->Small], ",", 
   CheckboxBox[False,
    Appearance->Medium], ",", 
   CheckboxBox[False,
    Appearance->Large]}], "}"}]], "Output",
 ImageSize->{96, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1182586917]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749957384],

Cell["Dynamically changing appearance:", "ExampleText",
 CellID->168329651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Large"}], "}"}], ",", 
     RowBox[{"Appearance", "\[Rule]", 
      RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294023278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`x], {Tiny, Large},
    Appearance->Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{28., {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->504809855]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->117884547],

Cell["\<\
By default, the checkbox does not change state until it is clicked:\
\>", "ExampleText",
 CellID->952228645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Checkbox", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1058699071],

Cell[BoxData[
 CheckboxBox[False]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327416423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1653270902],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the checkbox changes state on mouse over:"
}], "ExampleText",
 CellID->233141381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Checkbox", "[", 
  RowBox[{"AutoAction", "\[Rule]", "True"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1248510922],

Cell[BoxData[
 CheckboxBox[False,
  AutoAction->True]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->660351217]
}, Open  ]],

Cell["\<\
Values will change as the cursor is moved over the clickable area:\
\>", "ExampleText",
 CellID->75059382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Checkbox", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200225882],

Cell[BoxData[
 CheckboxBox[Dynamic[$CellContext`x],
  AutoAction->True]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134788612]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17647943],

Cell["Change the background color:", "ExampleText",
 CellID->313002774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"False", ",", 
     RowBox[{"Background", "\[Rule]", "b"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Yellow", ",", "Orange"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1034717747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[False,
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   CheckboxBox[False,
    Background->RGBColor[0, 1, 0]], ",", 
   CheckboxBox[False,
    Background->RGBColor[1, 1, 0]], ",", 
   CheckboxBox[False,
    Background->RGBColor[1, 0.5, 0]]}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300655587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256592240],

Cell["Dynamically change the background color:", "ExampleText",
 CellID->61021719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Checkbox", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "color", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Orange", ",", "Blue"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", "color", "]"}]}], ",", 
   RowBox[{"ImageMargins", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30391527],

Cell[BoxData[
 CheckboxBox[Dynamic[$CellContext`color], {RGBColor[1, 0.5, 0], RGBColor[
  0, 0, 1]},
  Background->Dynamic[$CellContext`color],
  ImageMargins->5]], "Output",
 ImageSize->{27, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125057691]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->27096317],

Cell["Align with surrounding text:", "ExampleText",
 CellID->639805715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Checkbox", "[", 
      RowBox[{"BaselinePosition", "\[Rule]", "b"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->764031476],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   CheckboxBox[False,
    BaselinePosition->Bottom], "xxx", 
   CheckboxBox[False,
    BaselinePosition->Center], "xxx", 
   CheckboxBox[False,
    BaselinePosition->Top]}],
  Row[{
    Checkbox[BaselinePosition -> Bottom], 
    Checkbox[BaselinePosition -> Center], 
    Checkbox[BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{97, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1267287645]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28736302],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 " option allows the checkbox to be changed:"
}], "ExampleText",
 CellID->413061582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Checkbox", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->354727137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`x],
    Enabled->False], ",", 
   CheckboxBox[Dynamic[$CellContext`x],
    Enabled->True]}], "}"}]], "Output",
 ImageSize->{56, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29885907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446729287],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 " option can be changed dynamically for use in applications:"
}], "ExampleText",
 CellID->308311672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Checkbox", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137480908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`x]], ",", 
   CheckboxBox[Dynamic[$CellContext`y],
    Enabled->Dynamic[$CellContext`x]]}], "}"}]], "Output",
 ImageSize->{56, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->712510352]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->153733933],

Cell["Change the margins around the image:", "ExampleText",
 CellID->485909987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Checkbox", "[", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67073108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    CheckboxBox[False,
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    CheckboxBox[False,
     ImageMargins->5],
    StripOnInput->False], ",", 
   FrameBox[
    CheckboxBox[False,
     ImageMargins->10],
    StripOnInput->False], ",", 
   FrameBox[
    CheckboxBox[False,
     ImageMargins->30],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{234, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2016295128]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->209273914],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " to set variables corresponding three-way light switch:"
}], "ExampleText",
 CellID->308839216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Checkbox", "[", 
     RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"Checkbox", "[", 
     RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
    RowBox[{"Checkbox", "[", 
     RowBox[{"Dynamic", "[", "z", "]"}], "]"}], ",", 
    "\"\<\[DoubleLongRightArrow]\>\"", ",", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Xor", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70502881],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`x]], "\[InvisibleSpace]", 
   CheckboxBox[Dynamic[$CellContext`y]], "\[InvisibleSpace]", 
   CheckboxBox[Dynamic[$CellContext`z]], 
   "\[InvisibleSpace]", "\<\"\[DoubleLongRightArrow]\"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[
     Xor[$CellContext`x, $CellContext`y, $CellContext`z], StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}],
  Row[{
    Checkbox[
     Dynamic[$CellContext`x]], 
    Checkbox[
     Dynamic[$CellContext`y]], 
    Checkbox[
     Dynamic[$CellContext`z]], "\[DoubleLongRightArrow]", 
    Dynamic[
     Xor[$CellContext`x, $CellContext`y, $CellContext`z]]}]]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482806332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466328437],

Cell["Control options through checkboxes:", "ExampleText",
 CellID->474653188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Checkbox", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "xlab", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\>\"", ",", "\"\<x\>\""}], "}"}], ",", 
        RowBox[{"Enabled", "\[Rule]", 
         RowBox[{"Dynamic", "[", "axes", "]"}]}]}], "]"}], ",", 
      RowBox[{"Checkbox", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "ylab", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\>\"", ",", "\"\<y\>\""}], "}"}], ",", 
        RowBox[{"Enabled", "\[Rule]", 
         RowBox[{"Dynamic", "[", "axes", "]"}]}]}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"Checkbox", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "axes", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149747988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      CheckboxBox[Dynamic[$CellContext`xlab], {"", "x"},
       Enabled->Dynamic[$CellContext`axes]], ",", 
      CheckboxBox[Dynamic[$CellContext`ylab], {"", "y"},
       Enabled->Dynamic[$CellContext`axes]]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    CheckboxBox[Dynamic[$CellContext`axes], {False, True}]}]}], 
  "}"}]], "Output",
 ImageSize->{217, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268199624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".5", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
         RowBox[{"Rectangle", "[", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", "20", "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dynamic", "[", "xlab", "]"}], ",", 
      RowBox[{"Dynamic", "[", "ylab", "]"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"Dynamic", "[", "axes", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137184201],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmm9IW1cYxk9z7s09Se6029qgtUuj5k9hbCt6oRJTdqXOuFKNztZNFzXR
RNOpq//ayibk+GHoRtmgH0qhWmHayTaKrbaDlrILtZRSZlqRwSyDwAYZYxnd
AmNhDM7eTNiX0bXd4qbuwHOfe+857/t73vshcC+kKjAQDnUHBg61BayevkBP
+FBbv7XicB8s4U0IoYtwnM9BcM3g6vfjImNw/rN7wfcwOrJzXd0JK3fvZN13
VQerpazFo2OfUgffzfiuCLslTB2A85LhL6uegCpH1BoRx9VvDeOU6aLqiBR/
3qPw6nVXjaE6m1lPOOKbT4lR6wKOql/oH6oLQ5fMfC86kgf2i3FfB453deHo
cYrXTfdj0J2brK0U4/UtON7iw9FePx7fp+mi9g4pXrQbYVbu1Jwvg5ARzKkp
HToa1gh9m1k4lVM5lVM5dWNSp8+4sXdqUDf90l5pruFphLXWwom6UhAyguVP
NO7Vr0GyCGSp40IlwnS+RP0gDEJGsHx1bpA8kIgwIFM1DhAyguWmvDYxWbsL
J+ufxUtHLOL0oFuai9hg5tHtnP6f07OA/mT+spuUzflJ2XW6bZhRgafwlDWT
YoYUnKq2iz96i/APtUX4Tm+B+P7hcun8GzsRvhKxlY73gJARLKtksoc8tVhi
siwrxDVXQ4qv+01Bpmb/kZj+LsXwfQqJ12TWFUAYXv6TBxQQMoKZ4XlIxpNE
SJJYvweerXNfymcHwbP57OZUYyFJNdjwz402/M2Rx8U7xwokSET4k0H37pOj
IGQEI89NjeqLT1KSd0s1WZaUza7pGlPfDath+Iaq/18lkrQLlN2k2uyKsOa/
IMaGGqRYZD/Cy29WJYJOEDKCmRNtDum7NgcSYADIXxGfgk/Bp+BT/LtTpIfA
Gr0qxo43S7GRasiOVCfanSDIbofsoD2dLaxKIoFE+d5rTvO9jkLp+6Bd+NVX
gBPHssW7QxYCATInczInZ5wsAVnUPgsS7Vq5HBspMMeGt0lfDlmEX7py/j5V
BiqhiVFZGys3a+8p0pW33MJPoV1kDdHgK2CsfDbQCkIGMPPsq43STH2zsFDx
CtFqveSct/mfk3eASTMNrcJClZ9oB+vIufp2uVs7RZq1QX1oMkyURcXk+mp7
XkaICAOyeJKCEAYjeYsw810lz3WpxlB2yc/pD6YLK7+3j2WVnSH+RD/CM2Ou
jwJNILQDDH/Y1CTwFJ7CU3gKT3nIFDmdcrOCysuUkatUQ/iWZyJUeRsEYZW3
iTIZdmxYugHo+QePXsZ1r18W/O3z8ukqjZxQGSeuHtEE5ujtnDDQTs3ISRuM
ZAOSEDo6L5/t1shZyrakqzB7l0IHCLky2LkVOm0v0KgQol9vgY6tsO6mU2x1
qnKhyhain+fwXb67Lnb3wO4zj7Da/4h39/sfMNr0G0zGsOk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80429007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236590568],

Cell["Use checkboxes to build a dynamic truth table:", "ExampleText",
 CellID->59846959],

Cell[BoxData[
 RowBox[{
  RowBox[{"DynamicTruthTable", "[", 
   RowBox[{"f_", ",", "vars_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", ",", "x", ",", "e", ",", "tt"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "localize", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"Array", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "vars", "]"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"e", "=", 
      RowBox[{"Function", "[", 
       RowBox[{"Evaluate", "[", 
        RowBox[{"f", "/.", 
         RowBox[{"Thread", "[", 
          RowBox[{"vars", "\[Rule]", 
           RowBox[{"Array", "[", 
            RowBox[{"Slot", ",", 
             RowBox[{"{", 
              RowBox[{"Length", "[", "vars", "]"}], "}"}]}], "]"}]}], "]"}]}],
         "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"truth", " ", "table"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"tt", "=", 
      RowBox[{"Grid", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{"vars", ",", 
            RowBox[{"TraditionalForm", "[", "f", "]"}]}], "]"}], ",", 
          RowBox[{"Append", "[", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"Composition", "[", 
               RowBox[{"Checkbox", ",", "Dynamic"}], "]"}], ",", "v"}], "]"}],
             ",", 
            RowBox[{"Apply", "[", 
             RowBox[{
              RowBox[{"Composition", "[", 
               RowBox[{"Dynamic", ",", 
                RowBox[{"Evaluate", "[", "e", "]"}]}], "]"}], ",", " ", "v"}],
              "]"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"Dividers", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"All", ",", "All"}], "}"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "initialize", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "i", "]"}], "=", "False"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "vars", "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "tt"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->191224038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicTruthTable", "[", 
  RowBox[{
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"Or", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24029601],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "y", "z", 
     TagBox[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "\[Or]", "y"}], ")"}], "\[And]", "y", "\[And]", "z"}],
       TraditionalForm],
      TraditionalForm,
      Editable->True]},
    {
     CheckboxBox[Dynamic[
       $CellContext`x$181189[1]]], 
     CheckboxBox[Dynamic[
       $CellContext`x$181189[2]]], 
     CheckboxBox[Dynamic[
       $CellContext`x$181189[3]]], 
     DynamicBox[ToBoxes[
       (And[
        Or[#, #2], #2, #3]& )[
        $CellContext`x$181189[1], 
        $CellContext`x$181189[2], 
        $CellContext`x$181189[3]], StandardForm],
      ImageSizeCache->{380.875, {2., 8.}}]}
   },
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{461, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41011054]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->455929375],

Cell[TextData[{
 "Count the number of clicks in a ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->404531712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "=", "False"}], ",", 
     RowBox[{"changeCount", "=", "0"}]}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Checkbox", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"x", "=", "#"}], ";", 
             RowBox[{"changeCount", "++"}]}], ")"}], "&"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"False", ",", "True"}], "}"}]}], "]"}], ",", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<x is \>\"", ",", 
         RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<x has been changed \>\"", ",", 
         RowBox[{"Dynamic", "[", "changeCount", "]"}], ",", 
         "\"\< times.\>\""}], "}"}], "]"}]}], "}"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->30058019],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = False, $CellContext`changeCount$$ = 10},
   
  TagBox[GridBox[{
     {
      CheckboxBox[
       Dynamic[$CellContext`x$$, ($CellContext`x$$ = #; 
        Increment[$CellContext`changeCount$$])& ], {False, True}]},
     {
      InterpretationBox[
       RowBox[{"\<\"x is \"\>", "\[InvisibleSpace]", 
        DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
         ImageSizeCache->{35., {0., 8.}}]}],
       Row[{"x is ", 
         Dynamic[$CellContext`x$$]}]]},
     {
      InterpretationBox[
       RowBox[{"\<\"x has been changed \"\>", "\[InvisibleSpace]", 
        DynamicBox[ToBoxes[$CellContext`changeCount$$, StandardForm],
         ImageSizeCache->{14., {0., 8.}}], 
        "\[InvisibleSpace]", "\<\" times.\"\>"}],
       Row[{"x has been changed ", 
         Dynamic[$CellContext`changeCount$$], " times."}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{200, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460740583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->376321148],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36865483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160928523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[Dynamic[$CellContext`x], {False->"False", True->"True"}, 
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{35., {0., 8.}}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{102, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309937969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135051261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`y]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->792358662]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24826],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opener"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13331]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12819],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->82906462],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->214239681],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->38290050],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->39601944],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->1828203],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->7238414],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "MoreAbout",
 CellID->166081538],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->489430946],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->442054762]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Checkbox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 19.5865302}", "context" -> "System`", 
    "keywords" -> {
     "checkbox", "toggle", "switch", "finite choices", "cycle switch", 
      "on off button", "mode button"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Checkbox[x] represents a checkbox with setting x, displayed as TagBox[ \
CheckboxBox[True], EventHandlerTag[{ \"MouseDown\" -> Null, PassEventsDown -> \
Automatic, PassEventsUp -> True}]] when x is True and TagBox[ \
CheckboxBox[False], EventHandlerTag[{ \"MouseDown\" -> Null, PassEventsDown \
-> Automatic, PassEventsUp -> True}]] when x is False. Checkbox[Dynamic[x]] \
takes the setting to be the dynamically updated current value of x, with the \
value of x being toggled if the checkbox is clicked. Checkbox[x, {val_1, \
val_2}] represents a checkbox that toggles between values val_1 and val_2, \
and displays as TagBox[ CheckboxBox[True], EventHandlerTag[{ \"MouseDown\" -> \
Null, PassEventsDown -> Automatic, PassEventsUp -> True}]] and TagBox[ \
CheckboxBox[False], EventHandlerTag[{ \"MouseDown\" -> Null, PassEventsDown \
-> Automatic, PassEventsUp -> True}]] respectively. Checkbox[x, {val_1, \
val_2, val_3, ...}] represents a checkbox that cycles through values val_i, \
and displays as TagBox[ CheckboxBox[3, {1, 2, 3}], EventHandlerTag[{ \
\"MouseDown\" -> Null, PassEventsDown -> Automatic, PassEventsUp -> True}]] \
for all val_i with i > 2. ", "synonyms" -> {}, "title" -> "Checkbox", "type" -> 
    "Symbol", "uri" -> "ref/Checkbox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14014, 427, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->284501301]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50845, 1756}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3342, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3965, 99, 1573, 37, 70, "ObjectNameGrid"],
Cell[5541, 138, 4625, 153, 70, "Usage",
 CellID->26896]
}, Open  ]],
Cell[CellGroupData[{
Cell[10203, 296, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10681, 313, 325, 12, 70, "Notes",
 CellID->13568],
Cell[11009, 327, 68, 1, 70, "Notes",
 CellID->5703],
Cell[11080, 330, 1866, 48, 70, "3ColumnTableMod",
 CellID->12829],
Cell[12949, 380, 580, 23, 70, "Notes",
 CellID->13002],
Cell[13532, 405, 445, 17, 70, "Notes",
 CellID->15016]
}, Closed]],
Cell[CellGroupData[{
Cell[14014, 427, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284501301],
Cell[CellGroupData[{
Cell[14399, 441, 148, 5, 70, "ExampleSection",
 CellID->560724925],
Cell[14550, 448, 206, 8, 70, "ExampleText",
 CellID->830464174],
Cell[CellGroupData[{
Cell[14781, 460, 194, 6, 28, "Input",
 CellID->236081946],
Cell[14978, 468, 239, 9, 39, "Output",
 CellID->60395610]
}, Open  ]],
Cell[15232, 480, 123, 3, 70, "ExampleDelimiter",
 CellID->5499267],
Cell[15358, 485, 76, 1, 70, "ExampleText",
 CellID->48010555],
Cell[CellGroupData[{
Cell[15459, 490, 497, 16, 70, "Input",
 CellID->107649430],
Cell[15959, 508, 291, 10, 70, "Output",
 CellID->183632877]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16299, 524, 216, 7, 70, "ExampleSection",
 CellID->11831],
Cell[16518, 533, 374, 13, 70, "ExampleText",
 CellID->317513876],
Cell[CellGroupData[{
Cell[16917, 550, 222, 7, 70, "Input",
 CellID->414984996],
Cell[17142, 559, 327, 10, 70, "Output",
 CellID->171479238]
}, Open  ]],
Cell[17484, 572, 125, 3, 70, "ExampleDelimiter",
 CellID->162762893],
Cell[17612, 577, 274, 10, 70, "ExampleText",
 CellID->346941134],
Cell[CellGroupData[{
Cell[17911, 591, 321, 10, 70, "Input",
 CellID->116331372],
Cell[18235, 603, 341, 10, 70, "Output",
 CellID->147418342]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18625, 619, 220, 7, 70, "ExampleSection",
 CellID->4687120],
Cell[CellGroupData[{
Cell[18870, 630, 231, 7, 70, "ExampleSubsection",
 CellID->688710124],
Cell[19104, 639, 78, 1, 70, "ExampleText",
 CellID->777161034],
Cell[CellGroupData[{
Cell[19207, 644, 343, 11, 70, "Input",
 CellID->569683149],
Cell[19553, 657, 392, 15, 70, "Output",
 CellID->1182586917]
}, Open  ]],
Cell[19960, 675, 125, 3, 70, "ExampleDelimiter",
 CellID->749957384],
Cell[20088, 680, 75, 1, 70, "ExampleText",
 CellID->168329651],
Cell[CellGroupData[{
Cell[20188, 685, 397, 12, 70, "Input",
 CellID->294023278],
Cell[20588, 699, 383, 11, 70, "Output",
 CellID->504809855]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21020, 716, 231, 7, 70, "ExampleSubsection",
 CellID->117884547],
Cell[21254, 725, 118, 3, 70, "ExampleText",
 CellID->952228645],
Cell[CellGroupData[{
Cell[21397, 732, 100, 3, 70, "Input",
 CellID->1058699071],
Cell[21500, 737, 175, 6, 70, "Output",
 CellID->327416423]
}, Open  ]],
Cell[21690, 746, 126, 3, 70, "ExampleDelimiter",
 CellID->1653270902],
Cell[21819, 751, 240, 8, 70, "ExampleText",
 CellID->233141381],
Cell[CellGroupData[{
Cell[22084, 763, 146, 4, 70, "Input",
 CellID->1248510922],
Cell[22233, 769, 195, 7, 70, "Output",
 CellID->660351217]
}, Open  ]],
Cell[22443, 779, 116, 3, 70, "ExampleText",
 CellID->75059382],
Cell[CellGroupData[{
Cell[22584, 786, 204, 6, 70, "Input",
 CellID->200225882],
Cell[22791, 794, 213, 7, 70, "Output",
 CellID->134788612]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23053, 807, 230, 7, 70, "ExampleSubsection",
 CellID->17647943],
Cell[23286, 816, 71, 1, 70, "ExampleText",
 CellID->313002774],
Cell[CellGroupData[{
Cell[23382, 821, 375, 12, 70, "Input",
 CellID->1034717747],
Cell[23760, 835, 446, 15, 70, "Output",
 CellID->300655587]
}, Open  ]],
Cell[24221, 853, 125, 3, 70, "ExampleDelimiter",
 CellID->256592240],
Cell[24349, 858, 82, 1, 70, "ExampleText",
 CellID->61021719],
Cell[CellGroupData[{
Cell[24456, 863, 362, 10, 70, "Input",
 CellID->30391527],
Cell[24821, 875, 304, 9, 70, "Output",
 CellID->125057691]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25174, 890, 236, 7, 70, "ExampleSubsection",
 CellID->27096317],
Cell[25413, 899, 71, 1, 70, "ExampleText",
 CellID->639805715],
Cell[CellGroupData[{
Cell[25509, 904, 413, 13, 70, "Input",
 CellID->764031476],
Cell[25925, 919, 503, 17, 70, "Output",
 CellID->1267287645]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26477, 942, 227, 7, 70, "ExampleSubsection",
 CellID->28736302],
Cell[26707, 951, 226, 8, 70, "ExampleText",
 CellID->413061582],
Cell[CellGroupData[{
Cell[26958, 963, 394, 12, 70, "Input",
 CellID->354727137],
Cell[27355, 977, 315, 11, 70, "Output",
 CellID->29885907]
}, Open  ]],
Cell[27685, 991, 125, 3, 70, "ExampleDelimiter",
 CellID->446729287],
Cell[27813, 996, 243, 8, 70, "ExampleText",
 CellID->308311672],
Cell[CellGroupData[{
Cell[28081, 1008, 361, 11, 70, "Input",
 CellID->137480908],
Cell[28445, 1021, 315, 10, 70, "Output",
 CellID->712510352]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28809, 1037, 233, 7, 70, "ExampleSubsection",
 CellID->153733933],
Cell[29045, 1046, 79, 1, 70, "ExampleText",
 CellID->485909987],
Cell[CellGroupData[{
Cell[29149, 1051, 359, 12, 70, "Input",
 CellID->67073108],
Cell[29511, 1065, 551, 23, 70, "Output",
 CellID->2016295128]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30123, 1095, 227, 7, 70, "ExampleSection",
 CellID->209273914],
Cell[30353, 1104, 241, 8, 70, "ExampleText",
 CellID->308839216],
Cell[CellGroupData[{
Cell[30619, 1116, 541, 16, 70, "Input",
 CellID->70502881],
Cell[31163, 1134, 822, 24, 70, "Output",
 CellID->482806332]
}, Open  ]],
Cell[32000, 1161, 125, 3, 70, "ExampleDelimiter",
 CellID->466328437],
Cell[32128, 1166, 78, 1, 70, "ExampleText",
 CellID->474653188],
Cell[CellGroupData[{
Cell[32231, 1171, 988, 28, 70, "Input",
 CellID->149747988],
Cell[33222, 1201, 581, 17, 70, "Output",
 CellID->268199624]
}, Open  ]],
Cell[CellGroupData[{
Cell[33840, 1223, 812, 24, 70, "Input",
 CellID->137184201],
Cell[34655, 1249, 1663, 31, 70, "Output",
 Evaluatable->False,
 CellID->80429007]
}, Open  ]],
Cell[36333, 1283, 125, 3, 70, "ExampleDelimiter",
 CellID->236590568],
Cell[36461, 1288, 88, 1, 70, "ExampleText",
 CellID->59846959],
Cell[36552, 1291, 2434, 66, 70, "Input",
 CellID->191224038],
Cell[CellGroupData[{
Cell[39011, 1361, 319, 10, 70, "Input",
 CellID->24029601],
Cell[39333, 1373, 916, 32, 70, "Output",
 CellID->41011054]
}, Open  ]],
Cell[40264, 1408, 125, 3, 70, "ExampleDelimiter",
 CellID->455929375],
Cell[40392, 1413, 215, 8, 70, "ExampleText",
 CellID->404531712],
Cell[CellGroupData[{
Cell[40632, 1425, 1057, 32, 70, "Input",
 CellID->30058019],
Cell[41692, 1459, 1118, 31, 70, "Output",
 CellID->460740583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42859, 1496, 237, 7, 70, "ExampleSection",
 CellID->376321148],
Cell[43099, 1505, 321, 12, 70, "ExampleText",
 CellID->36865483],
Cell[CellGroupData[{
Cell[43445, 1521, 307, 10, 70, "Input",
 CellID->160928523],
Cell[43755, 1533, 453, 12, 70, "Output",
 CellID->309937969]
}, Open  ]],
Cell[CellGroupData[{
Cell[44245, 1550, 222, 7, 70, "Input",
 CellID->135051261],
Cell[44470, 1559, 327, 10, 70, "Output",
 CellID->792358662]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44858, 1576, 311, 9, 70, "SeeAlsoSection",
 CellID->24826],
Cell[45172, 1587, 1176, 44, 70, "SeeAlso",
 CellID->13331]
}, Open  ]],
Cell[CellGroupData[{
Cell[46385, 1636, 314, 9, 70, "TutorialsSection",
 CellID->12819],
Cell[46702, 1647, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[46864, 1652, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[47049, 1660, 318, 9, 70, "MoreAboutSection",
 CellID->82906462],
Cell[47370, 1671, 141, 3, 70, "MoreAbout",
 CellID->214239681],
Cell[47514, 1676, 148, 3, 70, "MoreAbout",
 CellID->38290050],
Cell[47665, 1681, 167, 3, 70, "MoreAbout",
 CellID->39601944],
Cell[47835, 1686, 147, 3, 70, "MoreAbout",
 CellID->1828203],
Cell[47985, 1691, 168, 3, 70, "MoreAbout",
 CellID->7238414],
Cell[48156, 1696, 145, 3, 70, "MoreAbout",
 CellID->166081538],
Cell[48304, 1701, 128, 3, 70, "MoreAbout",
 CellID->489430946],
Cell[48435, 1706, 172, 3, 70, "MoreAbout",
 CellID->442054762]
}, Open  ]],
Cell[48622, 1712, 27, 0, 70, "History"],
Cell[48652, 1714, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

