(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    416956,      10197]
NotebookOptionsPosition[    384678,       9105]
NotebookOutlinePosition[    387706,       9167]
CellTagsIndexPosition[    387619,       9162]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElementData" :> 
          Documentation`HelpLookup["paclet:ref/ElementData"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ElementData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integrated Data Sources\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ChemicalData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChemicalData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChemicalData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of the specified property for the \
chemical ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChemicalData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChemicalData"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a structure diagram for the chemical with the \
specified name."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChemicalData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChemicalData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of available chemicals in the specified \
class."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Chemicals can be specified by their common names such as ",
 Cell[BoxData["\"\<Water\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<AceticAcid\>\""], "InlineFormula"],
 ", registry numbers such as ",
 Cell[BoxData["\"\<CID962\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<CAS732-18-5\>\""], "InlineFormula"],
 ", IUPAC-like names such as ",
 Cell[BoxData["\"\<2Methylpropane\>\""], "InlineFormula"],
 " or structure strings."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChemicalData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChemicalData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of available classes of chemicals."
}], "Notes",
 CellID->49291775],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChemicalData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChemicalData"], "[", "\"\<Properties\>\"", "]"}]],
   "InlineFormula"],
 " gives a list of all properties available for chemicals. "
}], "Notes",
 CellID->54231339],

Cell[TextData[{
 "Properties that do not apply or are not known in a particular case are \
indicated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->48425469],

Cell[TextData[{
 "Except where noted, all relevant quantities are given in SI (MKS) units. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChemicalData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChemicalData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives the numerical value; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChemicalData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChemicalData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\"", ",", "\"\<Units\>\""}], "]"}]], 
  "InlineFormula"],
 " gives the units used."
}], "Notes",
 CellID->193117324],

Cell["\<\
Numerical values that are known only to a certain precision are typically \
tagged with their precision, and given in arbitrary-precision form.\
\>", "Notes",
 CellID->286491208],

Cell["Fundamental properties include:", "Notes",
 CellID->381198116],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FormulaDisplay\>\"", Cell[
    "chemical formula in display form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FormulaString\>\"", Cell[
    "chemical formula as a string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HillFormulaDisplay\>\"", Cell[
    "chemical formula in Hill order for display", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HillFormulaString\>\"", Cell[
    "chemical formula in Hill order as a string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IUPACName\>\"", Cell[
    "IUPAC name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MolecularWeight\>\"", Cell[
    "total molecular weight in atomic mass units", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StructureDiagram\>\"", Cell[
    "two-dimensional bond connectivity diagram", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "common English name", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->56793120],

Cell["Basic physical properties include:", "Notes",
 CellID->987574898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BoilingPoint\>\"", Cell[
    "boiling temperature in Celsius", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CombustionHeat\>\"", Cell[
    "heat of combustion", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CriticalPressure\>\"", Cell[
    "pressure at the critical point", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CriticalTemperature\>\"", Cell[
    "temperature at the critical point", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Density\>\"", Cell[
    "density", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MeltingPoint\>\"", Cell[
    "melting temperature in Celsius", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MolarVolume\>\"", Cell[
    "molar volume", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Phase\>\"", Cell[
    "naturally occurring phase", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RefractiveIndex\>\"", Cell[
    "index of refraction", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SurfaceTension\>\"", Cell[
    "surface tension for liquids", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VaporDensity\>\"", Cell[
    "density relative to air density", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VaporizationHeat\>\"", Cell[
    "heat of vaporization", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VaporPressure\>\"", Cell[
    "vapor pressure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Viscosity\>\"", Cell[
    "kinematic viscosity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SolubilityType\>\"", Cell[
    "type of solubility in water", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True}}}},
 CellID->270203023],

Cell["\<\
If not otherwise specified, physical properties are given for standard \
temperature and pressure.\
\>", "Notes",
 CellID->154524926],

Cell["Molecular visualization properties include:", "Notes",
 CellID->1521777803],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorStructureDiagram\>\"", Cell[
    "2D bond connectivity diagram with color coding", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MoleculePlot\>\"", Cell[
    "three-dimensional molecular structure plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StructureDiagram\>\"", Cell[
    "two-dimensional bond connectivity diagram", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->311524290],

Cell["Molecular structure properties include:", "Notes",
 CellID->1535753758],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AdjacencyMatrix\>\"", Cell[
    "bond connectivity adjacency matrix", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AtomPositions\>\"", Cell[
    "list of 3D coordinates of atoms (in picometers)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BondTally\>\"", Cell[
    "tally of types of bonds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeRules\>\"", Cell[
    "list of graph edge rules for bonds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeTypes\>\"", Cell[
    "list of bond types for graph edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElementTally\>\"", Cell[
    "tally of chemical elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElementTypes\>\"", Cell[
    "list of chemical elements present", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FormalCharges\>\"", Cell[
    "list of formal charges for atoms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InChI\>\"", Cell[
    "InChI structure string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SMILES\>\"", Cell[
    "SMILES structure string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCoordinates\>\"", Cell[
    "list of 2D relative coordinates of graph vertices", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexTypes\>\"", Cell[
    "list of atom types at graph vertices", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->807457413],

Cell["Properties calculated from structure include:", "Notes",
 CellID->33828597],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HBondAcceptorCount\>\"", Cell[
    "hydrogen bond acceptor count", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HBondDonorCount\>\"", Cell[
    "hydrogen bond donor count", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PartitionCoefficient\>\"", Cell[
    "partition coefficient for octanol/water solubility", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RotatableBondCount\>\"", Cell[
    "rotatable bond count", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TautomerCount\>\"", Cell[
    "tautomer count", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TPSA\>\"", Cell[
    "topological polar surface area", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->353720050],

Cell["Identification properties include:", "Notes",
 CellID->1363875235],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlternateNames\>\"", Cell[
    "common chemical synonyms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BeilsteinNumber\>\"", Cell[
    "Beilstein record number string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CASNumber\>\"", Cell[
    "CAS registry number string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CIDNumber\>\"", Cell[
    "PubChem registry number string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EUNumber\>\"", Cell[
    "EU chemical substance number string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GmelinNumber\>\"", Cell[
    "Gmelin registry number string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IUPACName\>\"", Cell[
    "IUPAC name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "common English name (e.g. \"citric acid\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NSCNumber\>\"", Cell[
    "NCI registry number string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RTECSNumber\>\"", Cell[
    "RTECS registry number string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StandardName\>\"", Cell[TextData[{
     "standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " name (e.g. ",
     Cell[BoxData["\"\<CitricAcid\>\""], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->410626567],

Cell["Material safety properties include:", "Notes",
 CellID->465177886],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AutoignitionPoint\>\"", Cell[
    "autoignition temperature in Celsius", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DOTHazardClass\>\"", Cell[
    "DOT hazard class (0.x - 9.x)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DOTNumbers\>\"", Cell[
    "list of DOT (UN) numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FlashPoint\>\"", Cell[
    "flash point temperature in Celsius", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LowerExplosiveLimit\>\"", Cell[
    "lower explosive air concentration fraction", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NFPAFireRating\>\"", Cell[
    "NFPA flammability (red) rating (0-4) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NFPAHazards\>\"", Cell[
    "list of specific NFPA hazard tags", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NFPAHealthRating\>\"", Cell[
    "NFPA health (blue) rating (0-4)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NFPALabel\>\"", Cell[
    "image of NFPA label", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NFPAReactivityRating\>\"", Cell[
    "NFPA reactivity (yellow) rating (0-4)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RTECSClasses\>\"", Cell[
    "list of RTECS classes", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UpperExplosiveLimit\>\"", Cell[
    "upper explosive air concentration fraction", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->675382760],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChemicalData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChemicalData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->276644756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[TextData[{
     Cell[BoxData[Cell["", "TableText"]]],
     "short textual description of the property"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Interval\>\"", Cell[TextData[{
     "uncertainty range given by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interval",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interval"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LongDescription\>\"", Cell[
    "longer textual description of the property ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "additional information about the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Units\>\"", Cell[
    "units in which the value is given", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsName\>\"", Cell[
    "English name for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsNotation\>\"", Cell[
    "notation for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsStandardName\>\"", Cell[
    TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " standard name for the units used"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->524183967],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChemicalData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChemicalData"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<Compound\>\""}], "}"}], "]"}]], 
  "InlineFormula", "TemplateInclusion"],
 " gives a list of available chemicals that contain the element with the \
specified name."
}], "Notes",
 CellID->556530527]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194068024],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->80449674],

Cell["The basic structure diagram for caffeine:", "ExampleText",
 CellID->586239093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", "\"\<Caffeine\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551393615],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{146, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35728135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->361711382],

Cell["3D molecular plot for caffeine:", "ExampleText",
 CellID->41894317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Caffeine\>\"", ",", "\"\<MoleculePlot\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->973827730],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJwtUw1MjWEUbjSzpFmrlaYisVBrLSqUDmlJqHvLvbdbrtv9q/une2+XWmRC
wxgLtSkjN6GttaIhjLOYyVKYxNIoK3+Zv/IXm/d9j7N9O9v7nfec53nO887R
FEr1k9zc3CLZN5l9fxq/PF4fEgffw3KPdJRp8KwtwaNvUQHcHmcHX+3YV88O
5GkYzSNThVObZil1Wjm+mx81tckzHdx4vFXjgy4WO4xQnXTQ8mZiLcx0l3lF
eEvAgzf4rcbtPs0pgwuVeK72zuwWRxIEV3yQXFXl0ZwQPWVpLip1y1+m+2bB
qORqUIU5HC7cTYs90AqwRHUt1dN7NbiSL3/7q9sIbyYY8KpMlOe03hpVhaCV
Hyg3Is1V0P25BsKbBrgH759JrpaigceIFQQelwbKqxjgfbHEuygPBd4hNQyW
soLKQqr/aofFu67Abo0vcNhBVQaws/J6hQUXMNnG9xtxIHRKeZVWQby6nSB0
8zOC4Hs0DllVWG6xhXJPPulWYiHd4nWkS2kG1Jxg0erEz+c58XRkKEt9Nhhh
DQfUYyc8XkWk15AC+fiwUD1wOqV7rdC57ebpgE8xIHDNsAOHaessJry4jubW
GUifCSPxPmgi3lIjzS930t6v6NHvefePzKIsYNUfJBkmFDguOfCYPxO6LBXq
fkaNNA8HApd5+aJNqFjadm9bgAbaeb27lXg8Ssb+XztNN5wKfMFz2zLkLmnc
KoWxv09K3l1U4s/M1w2179V4h/PaHQGr1MMPQ6KVKPY/bxNy1xQ0KIDDrY8v
wLJE5ojbeSD2O20liP2bUv/rZwZ+vT8vGxy8Xh0DXOauli1wMtrVFnshAY5+
3JG4JGgz4Oip+PDZUhQ4OuQo3sFwBvnjsBaF8cIkKPq1R+EKLlSjgd5Dupb4
ekmIv1YGx7kuvZuht4S9kDE58nUfceWTL4a0NDdAQr55Zac9vdDTvelxKPCP
G1DgVeiIr/sWFPo/05DPgrPJhwkOrAuIHAiVZZMP/PUgcpeNfLLLAVgWGJd/
KAVFHzZH9FHa4KlsNPJ6Sjj5IMcCUv5jwAnFEXOCxyyJIHDXGED4b6GZ+nmY
8IaTbb5DQ7hldiQ/5eNvvl6zjHyYZSY8JYXkk0op/ANM5hbS
    "], {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[15, 24.], SphereBox[16, 24.], 
      SphereBox[17, 24.], SphereBox[18, 24.], SphereBox[19, 24.], 
      SphereBox[20, 24.], SphereBox[21, 24.], SphereBox[22, 24.], 
      SphereBox[23, 24.], SphereBox[24, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[7, 34.], SphereBox[8, 34.], 
      SphereBox[9, 34.], SphereBox[10, 34.], SphereBox[11, 34.], 
      SphereBox[12, 34.], SphereBox[13, 34.], SphereBox[14, 34.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[3, 32.], 
      SphereBox[4, 32.], SphereBox[5, 32.], SphereBox[6, 32.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[1, 31.], 
      SphereBox[2, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{38, 15}, 15.], 
      CylinderBox[{39, 16}, 15.], CylinderBox[{40, 17}, 15.], 
      CylinderBox[{41, 18}, 15.], CylinderBox[{42, 19}, 15.], 
      CylinderBox[{43, 20}, 15.], CylinderBox[{44, 21}, 15.], 
      CylinderBox[{45, 22}, 15.], CylinderBox[{46, 23}, 15.], 
      CylinderBox[{47, 24}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{25, 9}, 15.], 
      CylinderBox[{26, 10}, 15.], CylinderBox[{27, 8}, 15.], 
      CylinderBox[{28, 10}, 15.], CylinderBox[{29, 12}, 15.], 
      CylinderBox[{30, 7}, 15.], CylinderBox[{31, 11}, 15.], 
      CylinderBox[{32, 13}, 15.], CylinderBox[{33, 9}, 15.], 
      CylinderBox[{34, 10}, 15.], CylinderBox[{35, 14}, 15.], 
      CylinderBox[{36, 8}, 15.], CylinderBox[{37, 11}, 15.], 
      CylinderBox[{7, 8}, 15.], CylinderBox[{7, 9}, 15.], 
      CylinderBox[{11, 38}, 15.], CylinderBox[{12, 39}, 15.], 
      CylinderBox[{12, 40}, 15.], CylinderBox[{12, 41}, 15.], 
      CylinderBox[{13, 42}, 15.], CylinderBox[{13, 43}, 15.], 
      CylinderBox[{13, 44}, 15.], CylinderBox[{14, 45}, 15.], 
      CylinderBox[{14, 46}, 15.], CylinderBox[{14, 47}, 15.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], CylinderBox[{3, 27}, 15.], 
      CylinderBox[{3, 28}, 15.], CylinderBox[{3, 29}, 15.], 
      CylinderBox[{4, 30}, 15.], CylinderBox[{4, 31}, 15.], 
      CylinderBox[{4, 32}, 15.], CylinderBox[{5, 33}, 15.], 
      CylinderBox[{5, 34}, 15.], CylinderBox[{5, 35}, 15.], 
      CylinderBox[{6, 36}, 15.], CylinderBox[{6, 37}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{1, 25}, 15.], 
      CylinderBox[{2, 26}, 15.]}}]},
  Boxed->False,
  ImageSize->{248.74800326355722`, Automatic},
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, -2.}]], "Output",
 ImageSize->{253, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->885239577,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->432939377],

Cell["Molecular weight of caffeine:", "ExampleText",
 CellID->86551233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Caffeine\>\"", ",", "\"\<MolecularWeight\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107438379],

Cell[BoxData["194.1906`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454864223]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(27)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  InterpretationBox[Cell[TextData[{
    "Names and Classes",
    "\[NonBreakingSpace]\[NonBreakingSpace]",
    Cell["(11)", "ExampleCount"]
   }], "ExampleSubsection"],
   $Line = 0; Null], " "}]], "ExampleSubsection",
 CellID->1705437741],

Cell["Obtain a list of chemical names sorted by molecular weight: ", \
"ExampleText",
 CellID->182841121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "[", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59259327],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"Helium\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "18141", "\[RightSkeleton]"}], 
    ",", "\<\"SodiumVanadate\"\>", ",", "\<\"Glycol(Polysorbate80)\"\>"}], 
   "}"}],
  Short]], "Output",
 ImageSize->{471, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->2008696288]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195686189],

Cell[BoxData["18145"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1715581576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1769839040],

Cell["Use string expressions to find compounds:", "ExampleText",
 CellID->888750683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "[", "\"\<*penta*\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1966091159],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Isopentane\"\>", ",", "\<\"MethylCyclopentane\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "202", "\[RightSkeleton]"}], 
    ",", "\<\"EicosapentaenoicAcid\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{437, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1664103210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "[", "\"\<1,2*\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1838273438],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"1,2-Epoxybutane\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "235", "\[RightSkeleton]"}], 
    ",", "\<\"1,2-Dibromo-1,1,2-Trifluoroethane\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{426, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->1903115589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31793384],

Cell[TextData[{
 "A chemical can be specified by its standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " name or a registry ID:"
}], "ExampleText",
 CellID->186712231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<CupricOxide\>\"", ",", "\"\<CASNumber\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374014864],

Cell[BoxData["\<\"CAS1317-38-0\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1042265905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<CAS1317-38-0\>\"", ",", "\"\<StandardName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1170128794],

Cell[BoxData["\<\"CupricOxide\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338956756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Ibuprofen\>\"", ",", "\"\<CIDNumber\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->617343353],

Cell[BoxData["\<\"CID3672\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1719566248]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<CID3672\>\"", ",", "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1530244426],

Cell[BoxData["\<\"Ibuprofen\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2062492457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2012114934],

Cell[TextData[{
 "Obtain a list of alternate standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " names:"
}], "ExampleText",
 CellID->1190706429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<MagnesiumHydroxide\>\"", ",", "\"\<AlternateStandardNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493536268],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"MagnesiumHydrate\"\>", ",", "\<\"MilkOfMagnesia\"\>", 
   ",", "\<\"MagnesiaMagma\"\>", ",", "\<\"[MilkOf]Magnesia\"\>"}], 
  "}"}]], "Output",
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1777178572]
}, Open  ]],

Cell["Use an alternate name as input:", "ExampleText",
 CellID->121758285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<MilkOfMagnesia\>\"", ",", "\"\<StandardName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1214756028],

Cell[BoxData["\<\"MagnesiumHydroxide\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1837697128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99762228],

Cell["Find the English name of a chemical:", "ExampleText",
 CellID->565259315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<MagnesiumHydroxide\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->33052035],

Cell[BoxData["\<\"magnesium hydroxide\"\>"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1065819142]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<SulfuricAcid\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1159465972],

Cell[BoxData["\<\"sulfuric acid\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1061219967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->917419666],

Cell["Obtain a list of alternate English names:", "ExampleText",
 CellID->139741002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<MagnesiumHydroxide\>\"", ",", "\"\<AlternateNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1804029678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"magnesia magma\"\>", ",", "\<\"magnesia, [Milk of]\"\>", 
   ",", "\<\"magnesium hydrate\"\>", ",", "\<\"milk of magnesia\"\>"}], 
  "}"}]], "Output",
 ImageSize->{514, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1072297034]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<SulfuricAcid\>\"", ",", "\"\<AlternateNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1427394443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"battery acid\"\>", ",", "\<\"dipping acid\"\>", 
   ",", "\<\"electrolyte acid\"\>", ",", "\<\"sulphuric acid\"\>"}], 
  "}"}]], "Output",
 ImageSize->{430, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413484814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194874262],

Cell["Find the IUPAC name:", "ExampleText",
 CellID->357967183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Caffeine\>\"", ",", "\"\<IUPACName\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->496225321],

Cell[BoxData["\<\"1,3,7-trimethylpurine-2,6-dione\"\>"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182187206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1736278621],

Cell["Find the list of chemical classes:", "ExampleText",
 CellID->1626987711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", "\"\<Classes\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->873181526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Acid\"\>", ",", "\<\"Alcohol\"\>", ",", "\<\"Aldehyde\"\>", 
   ",", "\<\"Alkane\"\>", ",", "\<\"Alkene\"\>", ",", "\<\"Alkyne\"\>", 
   ",", "\<\"Amide\"\>", ",", "\<\"Amine\"\>", ",", "\<\"Aromatic\"\>", 
   ",", "\<\"Chiral\"\>", ",", "\<\"Ester\"\>", ",", "\<\"Ether\"\>", 
   ",", "\<\"Gas\"\>", ",", "\<\"Ketone\"\>", ",", "\<\"Liquid\"\>", 
   ",", "\<\"NaturalProduct\"\>", ",", "\<\"NonaromaticCyclic\"\>", 
   ",", "\<\"Phenol\"\>", ",", "\<\"Poison\"\>", ",", "\<\"Solid\"\>"}], 
  "}"}]], "Output",
 ImageSize->{405, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1856174267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1240203172],

Cell["Find the list of chemicals belonging to a class:", "ExampleText",
 CellID->618434022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "[", "\"\<Liquid\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199756274],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"HeavyWater\"\>", ",", "\<\"Water\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "2983", "\[RightSkeleton]"}], 
    ",", "\<\"Perfluorotripentylamine\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->225965500]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "[", "\"\<Acid\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1666982761],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"HydrochloricAcid\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "1425", "\[RightSkeleton]"}], ",", 
    RowBox[{"\<\"Mono-C6-12-AlkylDerivs\"\>", 
     "\[Ellipsis]", "\<\"nesulfonicAcid,Methyl-\"\>"}]}], "}"}],
  Short]], "Output",
 ImageSize->{530, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->1051070604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->841127130],

Cell["Test whether a chemical belongs to a class:", "ExampleText",
 CellID->2086309356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Nutrasweet\>\"", ",", "\"\<NaturalProduct\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->547024914],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143161206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Sucrose\>\"", ",", "\"\<NaturalProduct\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1692395553],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->928704602]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->251256900],

Cell["A list of strontium compounds:", "ExampleText",
 CellID->95636078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Strontium\>\"", ",", "\"\<Compound\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174295882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"StrontiumHydride\"\>", ",", "\<\"StrontiumOxide\"\>", 
   ",", "\<\"StrontiumPeroxide\"\>", ",", "\<\"StrontiumSulfide\"\>", 
   ",", "\<\"StrontiumFluoride\"\>", ",", "\<\"StrontiumSelenide\"\>", 
   ",", "\<\"StrontiumTitanate\"\>", ",", "\<\"StrontiumSulfate\"\>", 
   ",", "\<\"StrontiumChromate\"\>", ",", "\<\"StrontiumAcetate\"\>", 
   ",", "\<\"StrontiumNitrate\"\>", ",", "\<\"StrontiumSelenate\"\>", 
   ",", "\<\"StrontiumBromide\"\>", ",", "\<\"StrontiumChlorate\"\>", 
   ",", "\<\"StrontiumPerchlorate\"\>", ",", "\<\"StrontiumPhosphide\"\>", 
   ",", "\<\"StrontiumIodide\"\>", 
   ",", "\<\"StrontiumCyclohexanebutyrate\"\>"}], "}"}]], "Output",
 ImageSize->{521, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->827099418]
}, Open  ]],

Cell["Chlorine compounds:", "ExampleText",
 CellID->488358076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<Chlorine\>\"", ",", "\"\<Compound\>\""}], "}"}], "]"}], "//",
   "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151684498],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"HydrochloricAcid\"\>", ",", "\<\"LithiumChloride\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "2834", "\[RightSkeleton]"}], 
    ",", "\<\"VancomycinHydrochloride\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{486, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->398271295]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Chemical Structure",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->87181009],

Cell["Get the structure diagram for a molecule:", "ExampleText",
 CellID->67265443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Trinitrotoluene\>\"", ",", "\"\<StructureDiagram\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1707434259],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{183, 166},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72786532]
}, Open  ]],

Cell["Color structure diagram:", "ExampleText",
 CellID->494617519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Trinitrotoluene\>\"", ",", "\"\<ColorStructureDiagram\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127444296],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWX1QVFUUv+4uK36Umt9OkuZnZn479v0xqTWa01hjaTZNjMnoEGaIA4zC
VA74UYqQqEipI5AohMnQYA5jqzPwhzLqLIwbY2ghBOqqQKCCGv3uOe+9vbtv
xR1rpjIZ2L3vvHPP+Z3fvfe88w6zQqMWLYwIjVq8IHTQK5GhSxctXrBs0PSP
IiGydhBCFOLvm34C4zaM6K+wrQ3fgXw+gk9r6cTxEdr3MJKGyM8gXLbpPxiL
cL/SoffUDJ0PK75t+A7zuQ5pl02yYa1J29pSUyOHEXR9s7Hx3Pov5HCQolUR
trCx9JhHC1PKZs28t7TSP844U1Lu0bpSfXHjB9t9taJT6pynr3u06i7dCP30
N1+tmE0XTFqf1f7zWqu+dldWt3q0LjfejNx43qMV+FkcKPfajKXnLGQHA96c
YvFt5IOVPW5I8YOxeJp0i4uL09PTGxoaxFi/WkM8FhS7FgyfkgN7RUVFVVXV
0aNHY2NjCwsLW1tbn/CjO8SEw/gUU6S0ExAAx7p169xuNwSwk5eXFx8ff+LE
CTHa7zyPTYufyCfKj44wk5+fD2iHDx+GMQYoSNcGR5s3b16/fj3wj7qNlfb4
s/rojqE4mAk4hSMImpubPXHQDBsYW7VqVVZWFu6NDMjyQELRn2a33Pgjs7Ch
1HVNQexv5YkzG0Jbs2YNL3CQEnVycnJtbS37cTgcQFxUVCSG38Gmja6xlbft
q2+6ekv0IVz96JbjeDN2PqABYDAkMijWd/3SAmU5pBWzAQqCBwWVlZWdSFJe
Xg6G9uzZA0Z4bTDAJYS4RWtghVkYokXVrFM81n2ORvjFp+hNaAiTDao4YWt3
XcJR6+o3CsYr55F9G5YLuwMeQccDpAFGNF543UBYMv1gwOcBqxC2um5vUYPo
7OPDTjMQNpiCChR7Erpe7Mvtzo7PXrq2CjB5DUqcV5FK5DDYx1KQYunDz2UW
DFE4w94CVd28OcMGs+o6iCAjIwO3BpDk3PnWuLSL+EWi6uLjiZGAtu+Lf6dz
q89YmVq7KSrv2tmzPSiGh0h+q6Wldsf28jdnu/P3szfsC8SAXAfbPRVJ4rZy
96V69u9yuTZs2AAOsQ176qziCGJLQmIxrURfPbJNWS6FRxuWdVPOFeaDvdcX
FwMMHqJ4lBIfgtDarvx4CPLqL1Mgt5jmsv29Bc6YGO3M9lG4BHklJSWsg/Nr
8G3x3sfgu5d+kuLi4tMzDom+SvxgGyQyu3VZmUBzITdHPEgYeeVA7emI8J+X
ReIRyXqgNiHiOyyEGKBzwnkM6aWXz+40NAoKCqKiopDQrfrZB7N89rt7Zx5I
eBYIjYssUtnB3vw1MeHUvLlNTiedHEGnwcYVCsDX6/aZcZ47UGcE7jijqh75
ZBs6O3fuRFLC6Wc7asbsquQothOi86HxxnOaK35yvf/emdgY+O7sQWnFaoNi
z+5lZvGLwWATB2ZvrANoRta0mPjvpEuMxD5YYQ6wwByv4qUfDgCQHNIc0d3E
5DDOnQ6H8XAK1vefYX2YiSWLwjaAArdd0WE7QzlvOJ3ME8ARQ5SZZLVq1xEC
CCgTIxW/IAipw7BpYBuhcMHYrDpfBqcWE4MjfTzZNASU2Ti/mSrtIH1OK1UD
YpQpA5v9PG5aTUJnZ3adTiezhSmkKWtu5C5jr5gw2NrBN4ksg6SVK1dmZmam
paUlJCTA8ljTHuNn6O7du2NiYsClmHB3voJgHEHBzsGDB8PDw9mOFhuyAOob
IMDSTLxL+8AM+ywNCwvj+knLg0lJSTizk/4my5OJEaQp2JTD9hDru3VyQJYm
ee2s5wOa8+x93f+VbllZGU4M6y5ZskTTPXDgAFv41+G9r3sv6SJTB6DLuZfr
t5SUFMx4TtGGHELkZBT20dHRQuZNYUemNqpRPJiRtXkOfXY0auojR44YxTW/
8WuVpLzWas/aWhiTw2fIAiG9Q/3Lz9523uPwWOaIqevgVfXblWj5ST5C1zGe
9lYFqax5iQnxpLcP4KBa0KtWGqLrGHWN+hbOWF8ga1N8fHDdq1Z+XOep1Zq5
k/AS2Zps4qO7zplRsw1UcKi1k1r7vUzWJipemA9+j1Trrv66/S1btmCuXv14
1W9Tydp43Qs0V6xYAS/99LhQo8AaNHubYjcqPaPemk7WximcMOP8ZlFfX5+b
m8tv8D1Nq8KR1tXVoXLimuxVsjZG8cJxheixG3uhm75fzDU6wly+fDkqpBlk
bbQ35zD7qGldunjvZeOtxNjvMEtNS60GVTkZ7rNjghUcfMTUNzHe7bPI1mO6
D4MRo/4GLD5TQQpW9dypJ/11sjbC2wuCocjtql8IZNUMCkVHvuQfz+mfTbaG
mc42rXAQ8wFwiYmJwCSsJibfoPlD9Zyo5Rjau3bmhFlTkMhcwzCEOhv4tAzE
dV9OTk52drZxgMVbpPsuIQB7qampvL/fNuQWiOf9966+zduvXG3NdilXmYUN
f/2KOtRaL3ouSQPpOku+/fUD2S6xbuphzvfc8+kFzzfN8vR0Pff8dWPb8+fb
M51DurSrZM/03PlWvtFef5Pn0DmQHTmttyff3aU7vksnzqvX5dtfZCTO09e5
8cMzBJ17W9N5d/L2KqVvJXuIsCGHvp0/egOSHRqo7yhoaLp6i3MHZSOt/1Y6
5538rJN8Fo3eHjR76HEjAIThON78Gs2lvCg7N6fmzVW7PmqnknP/5cabq9Oq
d4VtbHI6OZtShvbqqHAEeamO0E9qZCeVn0Fqz4GzOj0pZN8DLuHYp4N0Mukr
uH+YJHjjL5s1syZtK8Lj58s0ksMUNBEw5Iy4pabGwPGIzggmYnpj6bFpHr8d
4ZcZZQDceOFetBV2tf9RTVVi5F4Fe6P/BFK94emauPP3c3iUx6Wcn/pUa5ne
ZMf5lb54T83Q+ZnQ5v2/UKr2AsoxosOfdsfH4w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{183, 166},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162021899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->573350563],

Cell["Plot the three-dimensional structure:", "ExampleText",
 CellID->342936055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Trinitrotoluene\>\"", ",", "\"\<MoleculePlot\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->938235150],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], 
   GraphicsComplex3DBox[{{33.232, 155.61, -301.57}, {-177.98, -263.22, 
    58.554}, {-147.02, 212.51, -194.42}, {-134.77, -183.2, 256.37}, {
    328.11, -12.539, 222.41}, {365.67, 139.34, 71.279}, {-41.085, 
    155.14, -203.86}, {-123.52, -184.37, 134.17}, {297.46, 54.873, 
    127.22}, {-85.56, -15.132, -36.299}, {1.5383, 
    80.577, -93.129}, {-40.537, -89.688, 75.925}, {171.67, 30.958, 72.368}, {
    129.05, 105.52, -38.359}, {86.971, -64.75, 
    130.7}, {-219.58, -41.094, -93.983}, {192.5, 180.47, -80.832}, {
    119.37, -118.96, 217.06}, {-256.57, 
    48.207, -139.87}, {-212.41, -118.59, -167.41}, {-286.54, -71.65, \
-16.315}, {-3.9265000000000043`, 
    155.375, -252.715}, {-150.75, -223.79500000000002`, 
    96.362}, {-94.05250000000001, 183.825, -199.14}, {-129.145, -183.785, 
    195.26999999999998`}, {312.78499999999997`, 21.166999999999994`, 
    174.815}, {331.565, 97.1065, 99.2495}, {-19.77335, 
    117.85849999999999`, -148.49450000000002`}, {-82.0285, -137.029, 
    105.04749999999999`}, {234.565, 42.915499999999994`, 99.794}, {160.775, 
    142.995, -59.5955}, {103.1705, -91.85499999999999, 173.88}, {-238.075, 
    3.5564999999999998`, -116.9265}, {-215.995, -79.84200000000001, \
-130.69650000000001`}, {-253.06, -56.372, -55.149}}, {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[17, 24.], SphereBox[18, 24.], 
      SphereBox[19, 24.], SphereBox[20, 24.], SphereBox[21, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[10, 34.], SphereBox[11, 34.], 
      SphereBox[12, 34.], SphereBox[13, 34.], SphereBox[14, 34.], 
      SphereBox[15, 34.], SphereBox[16, 34.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[7, 32.], 
      SphereBox[8, 32.], SphereBox[9, 32.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[1, 31.], 
      SphereBox[2, 31.], SphereBox[3, 31.], SphereBox[4, 31.], 
      SphereBox[5, 31.], SphereBox[6, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{31, 17}, 15.], 
      CylinderBox[{32, 18}, 15.], CylinderBox[{33, 19}, 15.], 
      CylinderBox[{34, 20}, 15.], CylinderBox[{35, 21}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{28, 11}, 15.], 
      CylinderBox[{29, 12}, 15.], CylinderBox[{30, 13}, 15.], 
      CylinderBox[{10, 11}, 15.], CylinderBox[{10, 12}, 15.], 
      CylinderBox[{10, 16}, 15.], CylinderBox[{11, 14}, 15.], 
      CylinderBox[{12, 15}, 15.], CylinderBox[{13, 14}, 15.], 
      CylinderBox[{13, 15}, 15.], CylinderBox[{14, 31}, 15.], 
      CylinderBox[{15, 32}, 15.], CylinderBox[{16, 33}, 15.], 
      CylinderBox[{16, 34}, 15.], CylinderBox[{16, 35}, 15.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], CylinderBox[{22, 7}, 15.], 
      CylinderBox[{23, 8}, 15.], CylinderBox[{24, 7}, 15.], 
      CylinderBox[{25, 8}, 15.], CylinderBox[{26, 9}, 15.], 
      CylinderBox[{27, 9}, 15.], CylinderBox[{7, 28}, 15.], 
      CylinderBox[{8, 29}, 15.], CylinderBox[{9, 30}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{1, 22}, 15.], 
      CylinderBox[{2, 23}, 15.], CylinderBox[{3, 24}, 15.], 
      CylinderBox[{4, 25}, 15.], CylinderBox[{5, 26}, 15.], 
      CylinderBox[{6, 27}, 15.]}}]},
  Boxed->False,
  ImageSize->272.77683408735095`,
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, -2.}]], "Output",
 ImageSize->{277, 282},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385490765,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Buckminsterfullerene\>\"", ",", "\"\<MoleculePlot\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9638023],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJwtVA1MU1cU7pgOZMb9hAERo5AJA50xuilWVA6si4KbWrStQGlLaSkt/Xnv
9dVtjC0xG5n/hBizn2xji8uCEckwLGOLYScghmz+TU3QTGJYonOihi2Z2bAx
3ne/3uSlvfede875fs4r8MZq/Gkmk2mdeJ4Uz6bJtqy+9EbKHD+qrN/XROuN
Pz+q9Iqx9gfJPDC2a8hdSe9m9W2c9KqkGgEmHy3qmLIOHoqROG3LKgqQZ+yO
/ULVeLk83+AhI13mZR3voy5y/VQ1N+3pbVwzuLBjqlCnB8XOzuETGj3/Af/y
9egSMtK3DTSTsX09u4pKxOt/B1L3+9wkdsVORwy/6WEq3Vvhuemx4f37Tv5G
lBuPB5FnUKEy5fyeS64CtncfP3HVnc0yrnIX+gp4SMaPBFjieVtBPUucRkT6
Tq2eJR8zLjLatebrZMBaOFqH/U4bjeZ/p7X021ne69GAx+anoe75yyd6t6Ov
kwkKz/n/q0B8AXBPBuncWbH2qFT41O4jr+URm4zVE2YD5cYKN8n9xVYy0hb3
ejijd0Gdb2QH3xXlO47Hge96K8l9WYjBi49m2ectOzlRSFLPcYU/+1QscwR6
ZSVwnu7gPx8e+/tSJJ+lvt0J1ElaSMbPIZb5kwGWPrCp5Cu7sfVg5zYqXyUU
DG9Av6d08JXrZMnHdJhk/7+FoM8zTSxxJhXk+9yPOgdqwX9OlCWfs4tQ54so
8mW4WfI/EwSuPAV8LfbDl10ay/s/W6nnzObSvSsqUG9KB79PNIC/dpWajTXk
R/xbtfDHUY3qDEAdDuDt94L3Yz70uUOjpR9lXzv/kpU/eeOFA9WhXJa8/ZDy
x3QYvljrAZ+LQqj3sgIc/Tr4+c9Ot6/1zjiXvYg5GdZ4bprIbHagj1+98NPN
MMs+D7XifHMTeOxvgQ/rVOj/cCsXCLt1jdZA10QCfli6BL57L4L5zXQDx9lW
6MIpXotL4NvbUeDJCWMetoRQp9qHfHke9HMrAH8JH8m5r2nEnNpswHs6zhLX
nQS/81fRiox2C2/xPrvT/CphrvbHkb+vPuUvF/qaFQJ/91UWrvo4+kcl/LDc
AR23a+Dxex90eW4Ty/trdNy/0gA9cxqQ924L4iMK6t1vQL9rrfhe7dO56157
+aovS6BraSHwPkjgnjWRulfPovuBsW8d4OH3OL4LykrocjkAXqoVzLsS4aQY
ozeH7fD5hz7U/SfGUo+JZl4TsARj08lyGT/mwnuvnooPceiUfjhXt4CP1Rrw
1jbCx+YmnD9S+TFvZaeF
    "], {
     {RGBColor[0.4, 0.4, 0.4], SphereBox[1, 34.], SphereBox[2, 34.], 
      SphereBox[3, 34.], SphereBox[4, 34.], SphereBox[5, 34.], 
      SphereBox[6, 34.], SphereBox[7, 34.], SphereBox[8, 34.], 
      SphereBox[9, 34.], SphereBox[10, 34.], SphereBox[11, 34.], 
      SphereBox[12, 34.], SphereBox[13, 34.], SphereBox[14, 34.], 
      SphereBox[15, 34.], SphereBox[16, 34.], SphereBox[17, 34.], 
      SphereBox[18, 34.], SphereBox[19, 34.], SphereBox[20, 34.], 
      SphereBox[21, 34.], SphereBox[22, 34.], SphereBox[23, 34.], 
      SphereBox[24, 34.], SphereBox[25, 34.], SphereBox[26, 34.], 
      SphereBox[27, 34.], SphereBox[28, 34.], SphereBox[29, 34.], 
      SphereBox[30, 34.], SphereBox[31, 34.], SphereBox[32, 34.], 
      SphereBox[33, 34.], SphereBox[34, 34.], SphereBox[35, 34.], 
      SphereBox[36, 34.], SphereBox[37, 34.], SphereBox[38, 34.], 
      SphereBox[39, 34.], SphereBox[40, 34.], SphereBox[41, 34.], 
      SphereBox[42, 34.], SphereBox[43, 34.], SphereBox[44, 34.], 
      SphereBox[45, 34.], SphereBox[46, 34.], SphereBox[47, 34.], 
      SphereBox[48, 34.], SphereBox[49, 34.], SphereBox[50, 34.], 
      SphereBox[51, 34.], SphereBox[52, 34.], SphereBox[53, 34.], 
      SphereBox[54, 34.], SphereBox[55, 34.], SphereBox[56, 34.], 
      SphereBox[57, 34.], SphereBox[58, 34.], SphereBox[59, 34.], 
      SphereBox[60, 34.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{1, 2}, 15.], 
      CylinderBox[{1, 3}, 15.], CylinderBox[{1, 4}, 15.], 
      CylinderBox[{2, 5}, 15.], CylinderBox[{2, 6}, 15.], 
      CylinderBox[{3, 7}, 15.], CylinderBox[{3, 8}, 15.], 
      CylinderBox[{4, 9}, 15.], CylinderBox[{4, 10}, 15.], 
      CylinderBox[{5, 10}, 15.], CylinderBox[{5, 11}, 15.], 
      CylinderBox[{6, 12}, 15.], CylinderBox[{6, 13}, 15.], 
      CylinderBox[{7, 14}, 15.], CylinderBox[{7, 15}, 15.], 
      CylinderBox[{8, 13}, 15.], CylinderBox[{8, 16}, 15.], 
      CylinderBox[{9, 14}, 15.], CylinderBox[{9, 17}, 15.], 
      CylinderBox[{10, 18}, 15.], CylinderBox[{11, 19}, 15.], 
      CylinderBox[{11, 20}, 15.], CylinderBox[{12, 19}, 15.], 
      CylinderBox[{12, 21}, 15.], CylinderBox[{13, 22}, 15.], 
      CylinderBox[{14, 23}, 15.], CylinderBox[{15, 16}, 15.], 
      CylinderBox[{15, 24}, 15.], CylinderBox[{16, 25}, 15.], 
      CylinderBox[{17, 26}, 15.], CylinderBox[{17, 27}, 15.], 
      CylinderBox[{18, 27}, 15.], CylinderBox[{18, 28}, 15.], 
      CylinderBox[{19, 29}, 15.], CylinderBox[{20, 28}, 15.], 
      CylinderBox[{20, 30}, 15.], CylinderBox[{21, 22}, 15.], 
      CylinderBox[{21, 31}, 15.], CylinderBox[{22, 32}, 15.], 
      CylinderBox[{23, 26}, 15.], CylinderBox[{23, 33}, 15.], 
      CylinderBox[{24, 33}, 15.], CylinderBox[{24, 34}, 15.], 
      CylinderBox[{25, 32}, 15.], CylinderBox[{25, 35}, 15.], 
      CylinderBox[{26, 36}, 15.], CylinderBox[{27, 37}, 15.], 
      CylinderBox[{28, 38}, 15.], CylinderBox[{29, 30}, 15.], 
      CylinderBox[{29, 39}, 15.], CylinderBox[{30, 40}, 15.], 
      CylinderBox[{31, 39}, 15.], CylinderBox[{31, 41}, 15.], 
      CylinderBox[{32, 42}, 15.], CylinderBox[{33, 43}, 15.], 
      CylinderBox[{34, 35}, 15.], CylinderBox[{34, 44}, 15.], 
      CylinderBox[{35, 45}, 15.], CylinderBox[{36, 46}, 15.], 
      CylinderBox[{36, 47}, 15.], CylinderBox[{37, 38}, 15.], 
      CylinderBox[{37, 46}, 15.], CylinderBox[{38, 48}, 15.], 
      CylinderBox[{39, 49}, 15.], CylinderBox[{40, 48}, 15.], 
      CylinderBox[{40, 50}, 15.], CylinderBox[{41, 42}, 15.], 
      CylinderBox[{41, 51}, 15.], CylinderBox[{42, 45}, 15.], 
      CylinderBox[{43, 44}, 15.], CylinderBox[{43, 47}, 15.], 
      CylinderBox[{44, 52}, 15.], CylinderBox[{45, 53}, 15.], 
      CylinderBox[{46, 54}, 15.], CylinderBox[{47, 55}, 15.], 
      CylinderBox[{48, 56}, 15.], CylinderBox[{49, 50}, 15.], 
      CylinderBox[{49, 51}, 15.], CylinderBox[{50, 57}, 15.], 
      CylinderBox[{51, 58}, 15.], CylinderBox[{52, 53}, 15.], 
      CylinderBox[{52, 59}, 15.], CylinderBox[{53, 58}, 15.], 
      CylinderBox[{54, 55}, 15.], CylinderBox[{54, 56}, 15.], 
      CylinderBox[{55, 59}, 15.], CylinderBox[{56, 57}, 15.], 
      CylinderBox[{57, 60}, 15.], CylinderBox[{58, 60}, 15.], 
      CylinderBox[{59, 60}, 15.]}}]},
  Boxed->False,
  ImageSize->299.0760382559981,
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, -2.}]], "Output",
 ImageSize->{303, 327},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2132608003,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->527447672],

Cell["Structure diagram for a more complicated molecule:", "ExampleText",
 CellID->729150048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Digitonin\>\"", ",", "\"\<ColorStructureDiagram\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16692798],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{576, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304715400]
}, Open  ]],

Cell["Three-dimensional structure:", "ExampleText",
 CellID->2134696175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Digitonin\>\"", ",", "\"\<MoleculePlot\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->412065042],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[2], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJw9mXl8VNXZxwERhaKiBQVklRQQhRAQEFlyYgQBkwBJSEL2bTLZZ5/JTCbJ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    "], {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[86, 24.], SphereBox[87, 24.], 
      SphereBox[88, 24.], SphereBox[89, 24.], SphereBox[90, 24.], 
      SphereBox[91, 24.], SphereBox[92, 24.], SphereBox[93, 24.], 
      SphereBox[94, 24.], SphereBox[95, 24.], SphereBox[96, 24.], 
      SphereBox[97, 24.], SphereBox[98, 24.], SphereBox[99, 24.], 
      SphereBox[100, 24.], SphereBox[101, 24.], SphereBox[102, 24.], 
      SphereBox[103, 24.], SphereBox[104, 24.], SphereBox[105, 24.], 
      SphereBox[106, 24.], SphereBox[107, 24.], SphereBox[108, 24.], 
      SphereBox[109, 24.], SphereBox[110, 24.], SphereBox[111, 24.], 
      SphereBox[112, 24.], SphereBox[113, 24.], SphereBox[114, 24.], 
      SphereBox[115, 24.], SphereBox[116, 24.], SphereBox[117, 24.], 
      SphereBox[118, 24.], SphereBox[119, 24.], SphereBox[120, 24.], 
      SphereBox[121, 24.], SphereBox[122, 24.], SphereBox[123, 24.], 
      SphereBox[124, 24.], SphereBox[125, 24.], SphereBox[126, 24.], 
      SphereBox[127, 24.], SphereBox[128, 24.], SphereBox[129, 24.], 
      SphereBox[130, 24.], SphereBox[131, 24.], SphereBox[132, 24.], 
      SphereBox[133, 24.], SphereBox[134, 24.], SphereBox[135, 24.], 
      SphereBox[136, 24.], SphereBox[137, 24.], SphereBox[138, 24.], 
      SphereBox[139, 24.], SphereBox[140, 24.], SphereBox[141, 24.], 
      SphereBox[142, 24.], SphereBox[143, 24.], SphereBox[144, 24.], 
      SphereBox[145, 24.], SphereBox[146, 24.], SphereBox[147, 24.], 
      SphereBox[148, 24.], SphereBox[149, 24.], SphereBox[150, 24.], 
      SphereBox[151, 24.], SphereBox[152, 24.], SphereBox[153, 24.], 
      SphereBox[154, 24.], SphereBox[155, 24.], SphereBox[156, 24.], 
      SphereBox[157, 24.], SphereBox[158, 24.], SphereBox[159, 24.], 
      SphereBox[160, 24.], SphereBox[161, 24.], SphereBox[162, 24.], 
      SphereBox[163, 24.], SphereBox[164, 24.], SphereBox[165, 24.], 
      SphereBox[166, 24.], SphereBox[167, 24.], SphereBox[168, 24.], 
      SphereBox[169, 24.], SphereBox[170, 24.], SphereBox[171, 24.], 
      SphereBox[172, 24.], SphereBox[173, 24.], SphereBox[174, 24.], 
      SphereBox[175, 24.], SphereBox[176, 24.], SphereBox[177, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[30, 34.], SphereBox[31, 34.], 
      SphereBox[32, 34.], SphereBox[33, 34.], SphereBox[34, 34.], 
      SphereBox[35, 34.], SphereBox[36, 34.], SphereBox[37, 34.], 
      SphereBox[38, 34.], SphereBox[39, 34.], SphereBox[40, 34.], 
      SphereBox[41, 34.], SphereBox[42, 34.], SphereBox[43, 34.], 
      SphereBox[44, 34.], SphereBox[45, 34.], SphereBox[46, 34.], 
      SphereBox[47, 34.], SphereBox[48, 34.], SphereBox[49, 34.], 
      SphereBox[50, 34.], SphereBox[51, 34.], SphereBox[52, 34.], 
      SphereBox[53, 34.], SphereBox[54, 34.], SphereBox[55, 34.], 
      SphereBox[56, 34.], SphereBox[57, 34.], SphereBox[58, 34.], 
      SphereBox[59, 34.], SphereBox[60, 34.], SphereBox[61, 34.], 
      SphereBox[62, 34.], SphereBox[63, 34.], SphereBox[64, 34.], 
      SphereBox[65, 34.], SphereBox[66, 34.], SphereBox[67, 34.], 
      SphereBox[68, 34.], SphereBox[69, 34.], SphereBox[70, 34.], 
      SphereBox[71, 34.], SphereBox[72, 34.], SphereBox[73, 34.], 
      SphereBox[74, 34.], SphereBox[75, 34.], SphereBox[76, 34.], 
      SphereBox[77, 34.], SphereBox[78, 34.], SphereBox[79, 34.], 
      SphereBox[80, 34.], SphereBox[81, 34.], SphereBox[82, 34.], 
      SphereBox[83, 34.], SphereBox[84, 34.], SphereBox[85, 34.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[1, 31.], 
      SphereBox[2, 31.], SphereBox[3, 31.], SphereBox[4, 31.], 
      SphereBox[5, 31.], SphereBox[6, 31.], SphereBox[7, 31.], 
      SphereBox[8, 31.], SphereBox[9, 31.], SphereBox[10, 31.], 
      SphereBox[11, 31.], SphereBox[12, 31.], SphereBox[13, 31.], 
      SphereBox[14, 31.], SphereBox[15, 31.], SphereBox[16, 31.], 
      SphereBox[17, 31.], SphereBox[18, 31.], SphereBox[19, 31.], 
      SphereBox[20, 31.], SphereBox[21, 31.], SphereBox[22, 31.], 
      SphereBox[23, 31.], SphereBox[24, 31.], SphereBox[25, 31.], 
      SphereBox[26, 31.], SphereBox[27, 31.], SphereBox[28, 31.], 
      SphereBox[29, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{181, 119}, 15.], 
      CylinderBox[{187, 125}, 15.], CylinderBox[{191, 134}, 15.], 
      CylinderBox[{193, 137}, 15.], CylinderBox[{197, 139}, 15.], 
      CylinderBox[{205, 147}, 15.], CylinderBox[{209, 151}, 15.], 
      CylinderBox[{213, 156}, 15.], CylinderBox[{217, 162}, 15.], 
      CylinderBox[{219, 163}, 15.], CylinderBox[{221, 165}, 15.], 
      CylinderBox[{223, 167}, 15.], CylinderBox[{225, 168}, 15.], 
      CylinderBox[{229, 172}, 15.], CylinderBox[{231, 175}, 15.], 
      CylinderBox[{233, 176}, 15.], CylinderBox[{235, 177}, 15.], 
      CylinderBox[{236, 86}, 15.], CylinderBox[{237, 87}, 15.], 
      CylinderBox[{238, 88}, 15.], CylinderBox[{239, 89}, 15.], 
      CylinderBox[{240, 90}, 15.], CylinderBox[{241, 91}, 15.], 
      CylinderBox[{242, 92}, 15.], CylinderBox[{243, 93}, 15.], 
      CylinderBox[{244, 94}, 15.], CylinderBox[{245, 95}, 15.], 
      CylinderBox[{246, 96}, 15.], CylinderBox[{247, 97}, 15.], 
      CylinderBox[{248, 98}, 15.], CylinderBox[{249, 99}, 15.], 
      CylinderBox[{250, 100}, 15.], CylinderBox[{251, 101}, 15.], 
      CylinderBox[{252, 102}, 15.], CylinderBox[{253, 103}, 15.], 
      CylinderBox[{254, 104}, 15.], CylinderBox[{255, 105}, 15.], 
      CylinderBox[{256, 106}, 15.], CylinderBox[{257, 107}, 15.], 
      CylinderBox[{258, 108}, 15.], CylinderBox[{259, 109}, 15.], 
      CylinderBox[{260, 110}, 15.], CylinderBox[{261, 111}, 15.], 
      CylinderBox[{262, 112}, 15.], CylinderBox[{263, 113}, 15.], 
      CylinderBox[{264, 114}, 15.], CylinderBox[{265, 115}, 15.], 
      CylinderBox[{266, 116}, 15.], CylinderBox[{267, 117}, 15.], 
      CylinderBox[{268, 118}, 15.], CylinderBox[{269, 120}, 15.], 
      CylinderBox[{270, 121}, 15.], CylinderBox[{271, 122}, 15.], 
      CylinderBox[{272, 123}, 15.], CylinderBox[{273, 124}, 15.], 
      CylinderBox[{274, 126}, 15.], CylinderBox[{275, 127}, 15.], 
      CylinderBox[{276, 128}, 15.], CylinderBox[{277, 129}, 15.], 
      CylinderBox[{278, 130}, 15.], CylinderBox[{279, 131}, 15.], 
      CylinderBox[{280, 132}, 15.], CylinderBox[{281, 133}, 15.], 
      CylinderBox[{282, 135}, 15.], CylinderBox[{283, 136}, 15.], 
      CylinderBox[{284, 138}, 15.], CylinderBox[{285, 140}, 15.], 
      CylinderBox[{286, 141}, 15.], CylinderBox[{287, 142}, 15.], 
      CylinderBox[{288, 143}, 15.], CylinderBox[{289, 144}, 15.], 
      CylinderBox[{290, 145}, 15.], CylinderBox[{291, 146}, 15.], 
      CylinderBox[{292, 148}, 15.], CylinderBox[{293, 149}, 15.], 
      CylinderBox[{294, 150}, 15.], CylinderBox[{295, 152}, 15.], 
      CylinderBox[{296, 153}, 15.], CylinderBox[{297, 154}, 15.], 
      CylinderBox[{298, 155}, 15.], CylinderBox[{299, 157}, 15.], 
      CylinderBox[{300, 158}, 15.], CylinderBox[{301, 159}, 15.], 
      CylinderBox[{302, 160}, 15.], CylinderBox[{303, 161}, 15.], 
      CylinderBox[{304, 164}, 15.], CylinderBox[{305, 166}, 15.], 
      CylinderBox[{306, 169}, 15.], CylinderBox[{307, 170}, 15.], 
      CylinderBox[{308, 171}, 15.], CylinderBox[{309, 173}, 15.], 
      CylinderBox[{310, 174}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{178, 35}, 15.], 
      CylinderBox[{43, 179}, 15.], CylinderBox[{37, 180}, 15.], 
      CylinderBox[{182, 43}, 15.], CylinderBox[{183, 54}, 15.], 
      CylinderBox[{51, 184}, 15.], CylinderBox[{57, 185}, 15.], 
      CylinderBox[{49, 186}, 15.], CylinderBox[{188, 57}, 15.], 
      CylinderBox[{189, 60}, 15.], CylinderBox[{58, 190}, 15.], 
      CylinderBox[{59, 192}, 15.], CylinderBox[{61, 194}, 15.], 
      CylinderBox[{63, 195}, 15.], CylinderBox[{196, 62}, 15.], 
      CylinderBox[{198, 63}, 15.], CylinderBox[{199, 66}, 15.], 
      CylinderBox[{64, 200}, 15.], CylinderBox[{69, 201}, 15.], 
      CylinderBox[{65, 202}, 15.], CylinderBox[{70, 203}, 15.], 
      CylinderBox[{204, 67}, 15.], CylinderBox[{206, 69}, 15.], 
      CylinderBox[{207, 74}, 15.], CylinderBox[{208, 68}, 15.], 
      CylinderBox[{210, 70}, 15.], CylinderBox[{211, 77}, 15.], 
      CylinderBox[{71, 212}, 15.], CylinderBox[{72, 214}, 15.], 
      CylinderBox[{80, 215}, 15.], CylinderBox[{73, 216}, 15.], 
      CylinderBox[{75, 218}, 15.], CylinderBox[{76, 220}, 15.], 
      CylinderBox[{78, 222}, 15.], CylinderBox[{224, 79}, 15.], 
      CylinderBox[{226, 80}, 15.], CylinderBox[{227, 83}, 15.], 
      CylinderBox[{81, 228}, 15.], CylinderBox[{82, 230}, 15.], 
      CylinderBox[{84, 232}, 15.], CylinderBox[{234, 85}, 15.], 
      CylinderBox[{30, 31}, 15.], CylinderBox[{30, 33}, 15.], 
      CylinderBox[{30, 38}, 15.], CylinderBox[{30, 45}, 15.], 
      CylinderBox[{31, 32}, 15.], CylinderBox[{31, 37}, 15.], 
      CylinderBox[{31, 236}, 15.], CylinderBox[{32, 34}, 15.], 
      CylinderBox[{32, 42}, 15.], CylinderBox[{32, 237}, 15.], 
      CylinderBox[{33, 35}, 15.], CylinderBox[{33, 40}, 15.], 
      CylinderBox[{33, 238}, 15.], CylinderBox[{34, 36}, 15.], 
      CylinderBox[{34, 39}, 15.], CylinderBox[{34, 239}, 15.], 
      CylinderBox[{35, 37}, 15.], CylinderBox[{35, 240}, 15.], 
      CylinderBox[{36, 41}, 15.], CylinderBox[{36, 46}, 15.], 
      CylinderBox[{36, 48}, 15.], CylinderBox[{37, 241}, 15.], 
      CylinderBox[{38, 39}, 15.], CylinderBox[{38, 242}, 15.], 
      CylinderBox[{38, 243}, 15.], CylinderBox[{39, 244}, 15.], 
      CylinderBox[{39, 245}, 15.], CylinderBox[{40, 43}, 15.], 
      CylinderBox[{40, 50}, 15.], CylinderBox[{40, 246}, 15.], 
      CylinderBox[{41, 44}, 15.], CylinderBox[{41, 47}, 15.], 
      CylinderBox[{41, 247}, 15.], CylinderBox[{42, 44}, 15.], 
      CylinderBox[{42, 248}, 15.], CylinderBox[{42, 249}, 15.], 
      CylinderBox[{43, 52}, 15.], CylinderBox[{44, 250}, 15.], 
      CylinderBox[{44, 251}, 15.], CylinderBox[{45, 252}, 15.], 
      CylinderBox[{45, 253}, 15.], CylinderBox[{45, 254}, 15.], 
      CylinderBox[{46, 49}, 15.], CylinderBox[{46, 255}, 15.], 
      CylinderBox[{46, 256}, 15.], CylinderBox[{47, 51}, 15.], 
      CylinderBox[{47, 257}, 15.], CylinderBox[{47, 258}, 15.], 
      CylinderBox[{48, 259}, 15.], CylinderBox[{48, 260}, 15.], 
      CylinderBox[{48, 261}, 15.], CylinderBox[{49, 51}, 15.], 
      CylinderBox[{49, 262}, 15.], CylinderBox[{50, 263}, 15.], 
      CylinderBox[{50, 264}, 15.], CylinderBox[{50, 265}, 15.], 
      CylinderBox[{51, 266}, 15.], CylinderBox[{52, 53}, 15.], 
      CylinderBox[{52, 267}, 15.], CylinderBox[{52, 268}, 15.], 
      CylinderBox[{53, 55}, 15.], CylinderBox[{53, 269}, 15.], 
      CylinderBox[{53, 270}, 15.], CylinderBox[{54, 55}, 15.], 
      CylinderBox[{54, 271}, 15.], CylinderBox[{54, 272}, 15.], 
      CylinderBox[{55, 56}, 15.], CylinderBox[{55, 273}, 15.], 
      CylinderBox[{56, 274}, 15.], CylinderBox[{56, 275}, 15.], 
      CylinderBox[{56, 276}, 15.], CylinderBox[{57, 58}, 15.], 
      CylinderBox[{57, 277}, 15.], CylinderBox[{58, 59}, 15.], 
      CylinderBox[{58, 278}, 15.], CylinderBox[{59, 61}, 15.], 
      CylinderBox[{59, 279}, 15.], CylinderBox[{60, 61}, 15.], 
      CylinderBox[{60, 62}, 15.], CylinderBox[{60, 280}, 15.], 
      CylinderBox[{61, 281}, 15.], CylinderBox[{62, 282}, 15.], 
      CylinderBox[{62, 283}, 15.], CylinderBox[{63, 64}, 15.], 
      CylinderBox[{63, 284}, 15.], CylinderBox[{64, 65}, 15.], 
      CylinderBox[{64, 285}, 15.], CylinderBox[{65, 67}, 15.], 
      CylinderBox[{65, 286}, 15.], CylinderBox[{66, 67}, 15.], 
      CylinderBox[{66, 68}, 15.], CylinderBox[{66, 287}, 15.], 
      CylinderBox[{67, 288}, 15.], CylinderBox[{68, 289}, 15.], 
      CylinderBox[{68, 290}, 15.], CylinderBox[{69, 71}, 15.], 
      CylinderBox[{69, 291}, 15.], CylinderBox[{70, 73}, 15.], 
      CylinderBox[{70, 292}, 15.], CylinderBox[{71, 72}, 15.], 
      CylinderBox[{71, 293}, 15.], CylinderBox[{72, 75}, 15.], 
      CylinderBox[{72, 294}, 15.], CylinderBox[{73, 76}, 15.], 
      CylinderBox[{73, 295}, 15.], CylinderBox[{74, 75}, 15.], 
      CylinderBox[{74, 79}, 15.], CylinderBox[{74, 296}, 15.], 
      CylinderBox[{75, 297}, 15.], CylinderBox[{76, 78}, 15.], 
      CylinderBox[{76, 298}, 15.], CylinderBox[{77, 78}, 15.], 
      CylinderBox[{77, 299}, 15.], CylinderBox[{77, 300}, 15.], 
      CylinderBox[{78, 301}, 15.], CylinderBox[{79, 302}, 15.], 
      CylinderBox[{79, 303}, 15.], CylinderBox[{80, 81}, 15.], 
      CylinderBox[{80, 304}, 15.], CylinderBox[{81, 82}, 15.], 
      CylinderBox[{81, 305}, 15.], CylinderBox[{82, 84}, 15.], 
      CylinderBox[{82, 306}, 15.], CylinderBox[{83, 84}, 15.], 
      CylinderBox[{83, 85}, 15.], CylinderBox[{83, 307}, 15.], 
      CylinderBox[{84, 308}, 15.], CylinderBox[{85, 309}, 15.], 
      CylinderBox[{85, 310}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{1, 178}, 15.], 
      CylinderBox[{179, 1}, 15.], CylinderBox[{180, 2}, 15.], 
      CylinderBox[{2, 181}, 15.], CylinderBox[{3, 182}, 15.], 
      CylinderBox[{3, 183}, 15.], CylinderBox[{184, 4}, 15.], 
      CylinderBox[{185, 4}, 15.], CylinderBox[{186, 5}, 15.], 
      CylinderBox[{5, 187}, 15.], CylinderBox[{6, 188}, 15.], 
      CylinderBox[{6, 189}, 15.], CylinderBox[{190, 7}, 15.], 
      CylinderBox[{7, 191}, 15.], CylinderBox[{192, 8}, 15.], 
      CylinderBox[{8, 193}, 15.], CylinderBox[{194, 9}, 15.], 
      CylinderBox[{195, 9}, 15.], CylinderBox[{10, 196}, 15.], 
      CylinderBox[{10, 197}, 15.], CylinderBox[{11, 198}, 15.], 
      CylinderBox[{11, 199}, 15.], CylinderBox[{200, 12}, 15.], 
      CylinderBox[{201, 12}, 15.], CylinderBox[{202, 13}, 15.], 
      CylinderBox[{203, 13}, 15.], CylinderBox[{14, 204}, 15.], 
      CylinderBox[{14, 205}, 15.], CylinderBox[{15, 206}, 15.], 
      CylinderBox[{15, 207}, 15.], CylinderBox[{16, 208}, 15.], 
      CylinderBox[{16, 209}, 15.], CylinderBox[{17, 210}, 15.], 
      CylinderBox[{17, 211}, 15.], CylinderBox[{212, 18}, 15.], 
      CylinderBox[{18, 213}, 15.], CylinderBox[{214, 19}, 15.], 
      CylinderBox[{215, 19}, 15.], CylinderBox[{216, 20}, 15.], 
      CylinderBox[{20, 217}, 15.], CylinderBox[{218, 21}, 15.], 
      CylinderBox[{21, 219}, 15.], CylinderBox[{220, 22}, 15.], 
      CylinderBox[{22, 221}, 15.], CylinderBox[{222, 23}, 15.], 
      CylinderBox[{23, 223}, 15.], CylinderBox[{24, 224}, 15.], 
      CylinderBox[{24, 225}, 15.], CylinderBox[{25, 226}, 15.], 
      CylinderBox[{25, 227}, 15.], CylinderBox[{228, 26}, 15.], 
      CylinderBox[{26, 229}, 15.], CylinderBox[{230, 27}, 15.], 
      CylinderBox[{27, 231}, 15.], CylinderBox[{232, 28}, 15.], 
      CylinderBox[{28, 233}, 15.], CylinderBox[{29, 234}, 15.], 
      CylinderBox[{29, 235}, 15.]}}]},
  Boxed->False,
  ImageSize->400,
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, -2.},
  ViewVertical->{-0.32091209096890483`, 0.4849428285192393, 
   1.268174471881036}]], "Output",
 ImageSize->{404, 313},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, 280.327868852459}},
 CellLabel->"Out[2]=",
 CellID->1483986014,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Get the common chemical formula:", "ExampleText",
 CellID->123316091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Salt\>\"", ",", "\"\<FormulaString\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1820430401],

Cell[BoxData["\<\"NaCl \"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->477861040]
}, Open  ]],

Cell["Hill ordered formula:", "ExampleText",
 CellID->271786084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Salt\>\"", ",", "\"\<HillFormulaString\>\""}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->1008144807],

Cell[BoxData["\<\"ClNa\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1969143147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224886642],

Cell["Get the chemical formula in standard notation:", "ExampleText",
 CellID->263879239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<MethylamineHydrochloride\>\"", ",", "\"\<FormulaDisplay\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87615657],

Cell[BoxData["\<\"C\\!\\(\\*SubscriptBox[\\(H\\),\\(3\\)]\\)N\\!\\(\\*\
SubscriptBox[\\(H\\),\\(2\\)]\\) HCl\"\>"], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->518387712]
}, Open  ]],

Cell["Hill ordered formula:", "ExampleText",
 CellID->1641875272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<MethylamineHydrochloride\>\"", ",", "\"\<HillFormulaDisplay\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1377846302],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C\"\>", "\[InvisibleSpace]", 
   SubscriptBox["\<\"H\"\>", "6"], "\[InvisibleSpace]", "\<\"Cl\"\>", 
   "\[InvisibleSpace]", "\<\"N\"\>"}],
  Row[{"C", 
    Subscript["H", 6], "Cl", "N"}]]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201119705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->505055951],

Cell["Find the SMILES string:", "ExampleText",
 CellID->138694679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Aspartame\>\"", ",", "\"\<SMILES\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->697195135],

Cell[BoxData["\<\"COC(=O)C(CC1=CC=CC=C1)NC(=O)C(CC(=O)[O-])[NH3+]\"\>"], \
"Output",
 ImageSize->{333, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79621557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->546034300],

Cell["Find the InChI string:", "ExampleText",
 CellID->846910159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<2-Acetonaphthone\>\"", ",", "\"\<InChI\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2019506442],

Cell[BoxData["\<\"1/C12H10O/c1-9(13)11-7-6-10-4-2-3-5-12(10)8-11/h2-8H,1H3\"\>\
"], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317196418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762195920],

Cell["Find chemical isomers:", "ExampleText",
 CellID->486873085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", "\"\<C4H8\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160676605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1-Butene\"\>", ",", "\<\"Butene(MixedIsomers)\"\>", 
   ",", "\<\"Cis-2-Butene\"\>", ",", "\<\"Cyclobutane\"\>", 
   ",", "\<\"Isobutylene\"\>", ",", "\<\"Methylcyclopropane\"\>", 
   ",", "\<\"Poly(Butadiene)\"\>", ",", "\<\"Polyisobutylene\"\>", 
   ",", "\<\"Trans-2-Butene\"\>"}], "}"}]], "Output",
 ImageSize->{497, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1065785472]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", "\"\<C14H12O\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2067202840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2-Methylbenzophenone\"\>", ",", "\<\"3-Methylbenzophenone\"\>",
    ",", "\<\"4-Acetylbiphenyl\"\>", ",", "\<\"4-Methylbenzophenone\"\>", 
   ",", "\<\"Deoxybenzoin\"\>", ",", "\<\"Diphenylacetaldehyde\"\>", 
   ",", "\<\"Fluorene-9-Methanol\"\>", ",", "\<\"ParaStyrylphenol\"\>", 
   ",", "\<\"Trans-StilbeneOxide\"\>"}], "}"}]], "Output",
 ImageSize->{433, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->495328277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237924958],

Cell["\<\
Get the list of elements in a chemical sorted by atomic weight:\
\>", "ExampleText",
 CellID->77308514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Tryptophan\>\"", ",", "\"\<ElementTypes\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1922241411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"H\"\>", ",", "\<\"C\"\>", ",", "\<\"N\"\>", ",", "\<\"O\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1335735767]
}, Open  ]],

Cell["A tally of elements:", "ExampleText",
 CellID->403067174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Tryptophan\>\"", ",", "\"\<ElementTally\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1493124523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"H\"\>", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"N\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"O\"\>", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2064473878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->484610202],

Cell["Obtain a tally of bond types:", "ExampleText",
 CellID->1585675590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Tryptophan\>\"", ",", "\"\<BondTally\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177581860],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtSwzAMTRrStEA/sGIJl4EVh+gwzLQLBgYKC+CMcKQQ5dMG1a6kRIk9
0Mw09S/Wky3L9tPtYr28f1isV3eLy5vnxdNydfdyef34nBVFYRCEX0EQXF0E
WTrNUvkPnu/sVySL1Am8o6o2DY6I/BjlZ0T7tvXHHeObe46vLX7X+Kj6CF5i
lNB+kGXPDL01KdeWf+5YvhSXq/HH/Q7SJtYAvUM2RuVxWV4aWf5QfQ2zV8xo
l1hk4nYjJV248hImfq6efeOXjL8a/qNNvkRZFFdPhL7p0q7GZd9Yps5Kyb+K
69pW2GF1Jri1BS+U433C1i6xSmzaq1AftuyROlLXGnExcqyoI12UrQ2fZgcc
hGK98Nqc1fTcvHc83RTlcT0+yWEpE0WU29mgUA6FWrhBievxqVMF5Q6qSa20
+byfZq+hxfbr+TDvv5HHJ21VemrH5zijFCWU2/HWvrv1g7LrGyjP65ptVSpr
YuybhcgTy4X6gWGV9mMLpnvRwWIBZaxmo7m/3Z7oe7VPsCxcLvWNfvhWzBRI
UfxdSzX7Vo2Zr9d37Fc704G3Q+jvaXZZUxVEfSI+WLU8LgFfgdOH03S0EVM9
Nl9tOgVEBowUb2lDM7X0N7eU23Bpy7fJmSvJ352Bk1bzclaWU6xYQchBEse5
5ClKRyp/iJT1i68t/ld4kRZG5Q+RKd3I1JvKrPQVleCy975GhaS4tPTYRFR+
7Q7UKEpiWJxRWqcatqbJ4Mtac9hv1zEJzViDa124GGWRpWIfoiIXnJW2b3fE
0RfMiGPe38ZSq/D9e3BRTD7rPtoWX+t4hPneh1u9p2r+Z88I4Zl1eKMXoKRO
b1T0zA8+isdFfKQu7IAaQZpX/Q82YDpvcG4mpvOHm3mW8Ms+rnQ/+HHvVnpD
rlHu3dVsoiFiyj78Y6A1bUVqGyY9KmYQ/k0+MjJItzFwbZhJk3wbAwntY0X5
7XhiG3/7mXcGSQ7DGIQ/4Zfenw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{462, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137837611]
}, Open  ]],

Cell["Compare with a structure diagram:", "ExampleText",
 CellID->169113065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", "\"\<Tryptophan\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1162418474],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytW01sVMkRfng8Hs8SC2N+1uHXsMuu1/zYGGLANh6vYxsvy++BCFkKBq0i
sQeywKKYhCQkhg0hRHAJQQEhJF9IpEVEQoiQJXECByQ2EUSRgjhEcOMSiSPH
yddV3V31+j2PPSMsMftevarq+uuvu+u93X7g2MHvHTpw7NNPDjRtOXrg8MFP
P/m8afCzoyBlZkTRjJlRFP2vMcJ1EVf0z/x9A//4stKrU/jNQF1UTbf27+d0
c9r8Zt1YRcswNq1n2WlzTvaslGVpnnxhfjNnzpx5+fKluTwlI2Rev35dX1+P
X7631OvXr+/du9dcaipIeCDUU4GGLxRVNGhqoVAYHx8X6pjTUFdXZzT8QlFF
A1NbiXr48OH9+/fDkWhXYBNztZnf6mvXrjU3N8NjKN3uxmhsbHz16lV0hvhW
md88qGDauHEjLkDA4+PHj0Py5s2b0TaSu3PnztDQkLlkuZWkH8/BBVsgQUmo
fv78+a5du8D69OnTrSQJM2GGSH5gfnN4DCawQqC3t/fgwYPGlyzpwFhe65DL
GVtmdbxPfHgMJrBCIEOUS5cueX9JV+bChQtNTU34jf5Fku8RFXyWWuM0eYez
SndbW9vExMRjknyX6LgFEeaCIZ/wmGUfP34Ml9i3f5LscqLDQ6QJj8BQl/A0
qyIKY+BBl63vKrLZz4Hol6SzifjBdvLkSTiD7M8OPM46DgSEObpSZ9Ov6L9L
3fhghUqIzUlEOav8QLU8fPhwU2Bblde3OB4LCL1NFM48/hAd1gc1LS0tO3bs
AM8GZaH/tRoXOnsQfs7MQhVFxMxHUdfBWiflfa6aNKYLiHru3Lm5c+dCR7RE
RRAKQfLV4etltfOTowRvMyWi3JjI+zIXU+9VNlFXzYZSg0fgQXrAhvyCnlHe
GGfO0hjz43HGxQpnI0YFBYMlZ9o7NAYcwoQFRMAPuAsjfks658b9huAHiXoJ
ZxxFL4cHDGFARzgELDAznWsV0jZAjINz3Ozk7DE6xWpcz04wISTfpFFAuXjx
4oYNGzAKY6HBuLkOPWC1jDI7PpNhTmu8rhGorIuhn8mkKwceeAAKxkGgrly5
YvCaspoBK5QW/bowS+WRZ/06V+9+5GDWw2iSqsEjhAFSSAXGAcMiGgN0yJoI
8hh1LkK+HjcEMdQoABKsn0kjwC4kCcowAmyB5U0uJ7DXXPL6SGtnNQKKBPCM
2pSoBY8LMJVxgXC1BvGDCMaALBKGCBCKmtULY5tLXsnfcnGBMFIARZsTNczV
xTymumgG10AlaqOZ/mAObmltMOscJ9KOUJtArg/TsaPm/v37MI9nGVRjZFrr
MrgAxWSbdxjMDUsQSIwDAcQc3va7mmPAYDuzjx49amho4IkLAbuKIxmImLn8
mdLp6wiD4QK3Ay73jBFRFchRprOz084ewji1BziZpg1/rG2LQwNcj46O4pfq
MoMQQLmxrrT8R8TN1+ZyncqMufxpWdLr6R6RHhkZMZc/KUv6W3TPuGkuf1yB
NOKKXBm8KE+6I5gvJ8qS5nmKhKJIzOWPKpBGgcB1VGaZ0huDiv5hWdK85sNs
GG8uj5cl3Un3CBmDfzRagTRyhYwZFCxPuiu4/0FZ0t34qUKhlidFSJZhzDGX
xyqQxpxEpkyFlifdQ/dygvi8LOkC3cv+/WgF0lKhFUibVWv37t0g4eKIkofK
W7dusfzdu3fXrFnD8iDikcjzOoM/XGj5jo4OiPnx169fz/Ig4pGPXM7PbfwB
L4t0NIo+qyCDsm7T7tDgnV0Bv1+BNtlp8D5WsLc827rpXvZHrE3WgcNlaety
tnDCrKcy08vT1hnYwtpkxTxSgTapZfZUELC86twU2FLlat3uOcqbZ4zG8BGY
JnGTPVJ52vzKgHvkwmqTVcrsPMxZoa8CrWJTVVDVtJ9JnHk+LGuMjuA+E9T6
mxjDr/ix2SgzoO2NjYFdKzaXEiuZF2vfwBi8a2Jki1UgasjMlvY3MIbf18Xm
s8yhdRVVUruzdMmSJWZdCOd1eXuR9sAmjoPMpfL2RbyPlvXSRxVbbTOXup12
a2v3NLRjTbHa25y0XcvZ80OHDu3bt69ocaAK8MF0HMtsn7Kr5Ci8m5+g0+zZ
s2dBaXNWxxAgRC/p6LGXshNNjgddMHhCziI1+lQLOnDPjGp2RzyazLBOZ43t
O1YFo+vRYABEYDNOU2NjY7j9Nnmn+y18nnr27NmiRYu4eWEQd1XgYyaYgzRK
ztdJkQ5X1iK2oNaN5LtdfEJENfheEvU4TUfj3r17fHiGoXx4jqhHo3ammWCG
dqfWllQuxcmehHV3lE/C+mzMJ2HuGUDYnoTBGnQMqOuj1l8eEdHiRq/dS0jf
OswMW8Tnf92h4PO/PksnuyV0/g+7JXDejMN9Bjk/+Flmd4oFkvWn2Viu2Cbf
9fDH7A5HKdEpor6H6RTBJu5H4RfXRi93V2Q/EGJdYYrsUUxsx0f38ta56E3a
Jat3NQXl0MddMp4Itq8kkckEVvSmZlCes1Xc79Kd2NYEJatQhPuB86iqYDl8
QfB7enqOHDmCzM4L0MIjrkU1Wg1yvuo4e9Y+tmdOIiYrE3HTPVBGGerN1gBN
h4eHdQ/UdxLt/oZjJOctsiexV5NeCe2+bH9T109zosayioexaCnZ5Hu/+OOO
UZ3DQNtXyFhs7HcYgYCm5YttmZ+YXytcxCCH9cL3ubkrxzHk/i0G9/0whkZC
lMSJQZCS8DznkZLzNWvWLGMf29OYQKBlCZTybz48T7OzxwMl7MGwNUW9Tghe
DqbmqbW19caNG+aSdqDcoa8eHx9fsGABY/LiBG77biRXEwxf7RAStjBCMmiH
p6fwxDLobGxoaBCbxEa2yb+X8GvUwmCOExqa9wq2J9ju0JERm9Gxr69PzjmC
jgTFOUw/v+5L/fD4ixNzhd+0JN8ugQKLwAYKIWae0RAUZHzPnj2gCQZ+FFjC
3suaShrseyONHHOcPfHebayby2+iDMzMm/fixQuLb1vdvIF/afHmEZelIWhK
P1rXRI9DrdOnT5vVmt5q5vRuSqLKoyxP6OBVJ/mOUd4m9gZza9sUEaSTgn2z
qN+L5VVM9XuCCfX2kXFNdokfp8ZOxuax3lOVod+Y6epJUvpd9Czmk1+xvSiP
y5F7P4GcVQnkTL5HG0yNXdibEByjE5B9m6znOqYyA6J986HfgQ+lxgyeIn9p
MeMxViawrVohIr+G35oaIb8K+QhxFgiPaoHejDv81KN9+MZ9qkjQHoNPx7EV
bAfxyd5p2xTeKj0ZDGWjyIuq7HSSnrFGjtXYtGyX1bldSYWWmhefzc0iJVpY
6lSqZRCBoLZsneKOWybrkFi0VnFP3yKWOj1Ni9oVt6z+ziIq3AcPHvAMNKNr
7bKbIu1voS55y7R8+XKohr1wEFpAgegakuQvX2TPQ5J1t2/fRhHxm3HUH0ID
MV6OYDK44Z7ByhalAytvoVCIzR1ImHUrZ+7zcBRjICigRlHEaIUSM2e0FUqP
fOvCMwdWIAVmDSCUzYOfC9O87ooiaAMMQ7PhoOLl71yUT0NOrz310iqUh/0A
ZnDBI/YLPsJTs+NYqPTIGsN6BKNpLTXrJMIFWTxAiBFoic/bSo+sIluCWqBV
Oo9IJeMDDrfym34Kf610JrBjwFbHuw6NEB9oR1j4RBz2emYqLeJdfzDnW6aU
FY/oLK522itLyNL3FAqj6CytekmrppQVG3vd3EOFmNmwekpZWQULQZW67ifH
+Gxg5WbnMS97tBOojmx3wnKHJ3qzrAwNmTroVVyCsswle0rmoq9BFOpwl6Sr
q+vy5cs+XpZLUIY7NyiC0VF68dWnuGTEjUHOKW/ROaKi4PhFhu22Ch72ey5T
ZR1BvgaUDkHB9UFmaA2Pfk1Uj3q2Ryc52KK4Tpw4MTIyYmbj2iD2Q8JVCzDs
6OjgeYdI8rxz50aTARDhCe9YowtupiHiPNNqa2vhOMJhkYi/ERDsYLnfFC3y
IHQaeaADfMZy3nlKF5ywK/pd0SIN7IJO2Aik0SDMSKPySNgZXS1aZNHIu3Tp
0oGBAeg3FTU/yCThdkQfDuafPHkCMIYtjCTIgCBtvcst4mKyR9/+ReRqHjkN
kFX847OidIhoBxF9meYf5ARJq12GbQ9gJ8n90fzO5MahRk7OIJKDUcyoBCbR
bZrVPmuzZ89GbUS76dmfglrdpaiyRjP1bjGOuzsVVdZaTZUVlal/Dqpjh6KK
Bk0VDUz9KtCwXVFFg6YKyjL1HlEF/bcpalgP9wINTP1LoOFjRRUNmioamPrX
AB23Kqqgs6YK7jKVxDItLS1YO2WeTQQaNFVQjKl/K8ZxckhRZT5pqmhg6t8D
3NviqQbnNI/gGvPcD3Bs0FONpHEz+fVxs5KEJTZyFJLEikVnl+i/UzzL+rtn
ZmSkJ329Z57/0DNk0n9zZ3CxlMS/zW/O9wH893OuPzWZj/Q9bZaF8vn88PCw
+VqYzzdPnP/ciLZ9pIli+ves/ZK9hI2DKrPxr0wHE1Lyvag88996JjTz2vmV
y7w9EabzZoLxeQ0n/MkixTt37kTJcZOANLhRaw3AEi+Vv/2Ck7+uROkiQHWp
mn+fGneyogZ5Aej7LzRhd32qjj+kesJIDR32O8zvlOD9rn+Wjd0lORc6rXyY
4F1XSV5UhUXBQgmPFzi9Fl2Z9xFR+/r6zp8/by57FPXq1avcxopRRQNTvyaq
4PNmRRV81lTRwNR/BBq6FRVAg8wK1Xg++f9f8XWq55tEXyKCndN6lp0252TP
SllW2ie5imb8H/tFV00=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{267, 236},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->326407590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1057590868],

Cell["Obtain the molecular graph edge rules: ", "ExampleText",
 CellID->1153480671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Tryptophan\>\"", ",", "\"\<EdgeRules\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69040111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "13"}], ",", 
   RowBox[{"2", "\[Rule]", "13"}], ",", 
   RowBox[{"3", "\[Rule]", "9"}], ",", 
   RowBox[{"3", "\[Rule]", "10"}], ",", 
   RowBox[{"3", "\[Rule]", "20"}], ",", 
   RowBox[{"7", "\[Rule]", "4"}], ",", 
   RowBox[{"4", "\[Rule]", "21"}], ",", 
   RowBox[{"4", "\[Rule]", "22"}], ",", 
   RowBox[{"4", "\[Rule]", "23"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}], ",", 
   RowBox[{"5", "\[Rule]", "7"}], ",", 
   RowBox[{"5", "\[Rule]", "16"}], ",", 
   RowBox[{"5", "\[Rule]", "17"}], ",", 
   RowBox[{"6", "\[Rule]", "8"}], ",", 
   RowBox[{"6", "\[Rule]", "10"}], ",", 
   RowBox[{"7", "\[Rule]", "13"}], ",", 
   RowBox[{"7", "\[Rule]", "18"}], ",", 
   RowBox[{"8", "\[Rule]", "9"}], ",", 
   RowBox[{"8", "\[Rule]", "11"}], ",", 
   RowBox[{"9", "\[Rule]", "12"}], ",", 
   RowBox[{"10", "\[Rule]", "19"}], ",", 
   RowBox[{"11", "\[Rule]", "14"}], ",", 
   RowBox[{"11", "\[Rule]", "24"}], ",", 
   RowBox[{"12", "\[Rule]", "15"}], ",", 
   RowBox[{"12", "\[Rule]", "25"}], ",", 
   RowBox[{"14", "\[Rule]", "15"}], ",", 
   RowBox[{"14", "\[Rule]", "26"}], ",", 
   RowBox[{"15", "\[Rule]", "27"}]}], "}"}]], "Output",
 ImageSize->{468, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1609366591]
}, Open  ]],

Cell["The bond orders for each edge:", "ExampleText",
 CellID->1128289029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Tryptophan\>\"", ",", "\"\<EdgeTypes\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->873107393],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Single\"\>", ",", "\<\"Double\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", ",", "\<\"Double\"\>", 
   ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Double\"\>", ",", "\<\"Double\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Single\"\>", ",", "\<\"Double\"\>", ",", "\<\"Single\"\>", 
   ",", "\<\"Single\"\>"}], "}"}]], "Output",
 ImageSize->{539, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1067760972]
}, Open  ]],

Cell["Find the type of atom at each graph vertex:", "ExampleText",
 CellID->1061068838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Tryptophan\>\"", ",", "\"\<VertexTypes\>\""}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->679755578],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV81ygjAQXn4iVkXw1qNP0558CMZxRg5OO9bnro9AszSlTNjIokQBYYZN
vi/LZjfZJbBJTvvdITml22T9fkw+9+n2a/32cZSU5wA43wAQvYLsZ7KX33id
5Q3go/T+uAxeNBy1jOMns2fbvofiV5bYmRSuhDGzXT1Ij6u/0uJzyagRIxQa
Hxh4oXi1iPml1wNHx2TfxE8b6rfF2563WCv/f62quzRhafFsdVWr3zHS1ZWz
osDKABrCCg3qR8u2moxdOef0Vn+tjI5eDdfnag25GuuRz4a1bCEvsX37SqpE
vLxyddpk7+uDfoI6Gf/NO2bNs2YN/a4Zs8aMhdojofzntFx9O7uBJ41+eswv
8H3bkUfX0HDruHHmdHJthjxbF3ygc49iEUaqDTPq/3FOsqjrq7h8ZaOMTW2d
3oKcjWZpz2yx9/WB/LfIwZnRA+cHqF8HBg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{494, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->857313737]
}, Open  ]],

Cell["The formal charges of the atoms:", "ExampleText",
 CellID->748011948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Tryptophan\>\"", ",", "\"\<FormalCharges\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->467540498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1122011376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2092238428],

Cell["Find the adjacency matrix:", "ExampleText",
 CellID->187379067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"am", "=", 
  RowBox[{"ChemicalData", "[", 
   RowBox[{"\"\<Aspirin\>\"", ",", "\"\<AdjacencyMatrix\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1068952567],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "42", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 42, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"21", ",", "21"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->591292125]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "am", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1716360935],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWl9rFDEQ39vd656KRU8KVa+900MFwQfBB0Gh4kPFh4IPgi8iHEehBf/R
9jOIn8AHP4OPffD7+EFiJpncZSeTZFvtupUc3M5OMr/fZDezySS7O7Ojvd0P
s6P9+Wzy4mD2eW9/fjjZ/nQgi4pelmXH8v9zPZPnQp6p/7EQUrrHoTwW0mAd
5SbKXMpcyhHqWanM8XdbKiVaQe1VVXkNjqAK9ctuEB24snKpa3wIURB9YunQ
Dlp/paV23CI6xbfVDuiHrL/Q8a4MWe/Qw9Cj42ZeS5sVcHdO6MvWN5v5dNin
Do7v8SG28SbKDZSFWEZxjkGcY/za9foqfM/IZXn8nmmJR6sFJdGvE31M9AnR
70X4LnXI6zfWyh4JKE8lD9WvH0+/Un8WJtddiyMM389Ur/FWJG4EPzr0VDmN
PKoHPQVwVNfeFJsT1328csP9BfU+a11EmJq0lkcXeOdDT1jwfrjPtM8HClOS
x9rujD+FJd3IfI3YJ6Scj+NknayTdfest9D6VbI+pfVjtH6TrBta62nI/IwJ
nZseIsc7UGpzExjVV0d6horlFbS+5iGSn8AiD/ILPqP5t55ANR7eCj4r9DA7
c36wF2jL2YzBl5WsnITZQWN3WzmNWVnQK/XHjb0e0Rkwjdv7iN0l5XyUJ2vX
egetYR25JuXFhGoJBYhVQIqPi/G3WQ6QkGeIRGtAruL5+4RsGVnPFsxOq2+u
Az5zPoYKJ/swDNZ8F9xr8+UDjif/DIuswTm8c57tzMT2uCGsLOWcX+NZeG6y
d9MsWuP7OGZ+N+PbFPW7xC6cHSR0e+gpotYQNUL5IKE7ih550I8Susto6wk1
+cXLhO4I2rzRcd5pWH0NLHTdCqcDxTAgNXQ2jzIRvd8yK6iUbe65K5oF9mDY
90Bcm5w8YrDgsLHO+0eOy9nPuaBkJfg9nNg9Mvl3Jbg4UutniXpOygOr7WRd
K91G62bPbbL2WMvo3UJJn+qE+lsoGI8Wa0lmNjG5top8ZyWvR5CKYKknlisw
xq+0zAoqZXvmuS9tt+3PWX2zVryHl7MWja3//Rui5ddTvm+s0teIp29H+hox
7svWz+vXiFnvN7GSOP4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->269023980]
}, Open  ]],

Cell["The list of atoms for the matrix:", "ExampleText",
 CellID->630594576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Aspirin\>\"", ",", "\"\<VertexTypes\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->571240887],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVtsOgjAMLQwEr8Cbj3yNPvkRhJjAg9EgPyA/jhuCMaUYCJOLsGTrzlnp
unYbO3lxcL54ceh77jHybkHo393DNeIUUwCUBwBYe+D9lPeyKkrCK4AmWlZw
KSwRtiRje2L2WBZlhtgVb1QO7ZrS6VjPQf6q5CoEFlBHvNETb45kXj3nX4ev
KDi6MrUWnc8oU4vefRmrv3FuQBgSO9gY5Kg5ezVir8p7UkUsI7/dymGH9hds
taLdLyNVYvENrKT1b5Q5e31njz57U86envv1KXcVPJZzNOez0AXbbVz+eTY6
5xQroPVFarnvGoGrJNbbpNSbfd2AbW+hCUu+0TKQ1OiB8gSdJM49\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->55583407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties and Annotations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1415856565],

Cell["Get a list of properties for a particular chemical:", "ExampleText",
 CellID->69743622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<MethylOrange\>\"", ",", "\"\<Properties\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->20957920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AdjacencyMatrix\"\>", ",", "\<\"AdjacencyMatrixRules\"\>", 
   ",", "\<\"AlternateNames\"\>", ",", "\<\"AlternateStandardNames\"\>", 
   ",", "\<\"AtomPositions\"\>", ",", "\<\"AutoignitionPoint\"\>", 
   ",", "\<\"BeilsteinNumber\"\>", ",", "\<\"BoilingPoint\"\>", 
   ",", "\<\"BondTally\"\>", ",", "\<\"CASNumber\"\>", 
   ",", "\<\"CIDNumber\"\>", ",", "\<\"ColorStructureDiagram\"\>", 
   ",", "\<\"CombustionHeat\"\>", ",", "\<\"CriticalPressure\"\>", 
   ",", "\<\"CriticalTemperature\"\>", ",", "\<\"Density\"\>", 
   ",", "\<\"DOTHazardClass\"\>", ",", "\<\"DOTNumbers\"\>", 
   ",", "\<\"EdgeRules\"\>", ",", "\<\"EdgeTypes\"\>", 
   ",", "\<\"ElementTally\"\>", ",", "\<\"ElementTypes\"\>", 
   ",", "\<\"EUNumber\"\>", ",", "\<\"FlashPoint\"\>", 
   ",", "\<\"FormalCharges\"\>", ",", "\<\"FormulaDisplay\"\>", 
   ",", "\<\"FormulaString\"\>", ",", "\<\"GmelinNumber\"\>", 
   ",", "\<\"HBondAcceptorCount\"\>", ",", "\<\"HBondDonorCount\"\>", 
   ",", "\<\"HillFormulaDisplay\"\>", ",", "\<\"HillFormulaString\"\>", 
   ",", "\<\"InChI\"\>", ",", "\<\"IUPACName\"\>", 
   ",", "\<\"LowerExplosiveLimit\"\>", ",", "\<\"LowPressureBoilingPoint\"\>",
    ",", "\<\"MeltingPoint\"\>", ",", "\<\"Memberships\"\>", 
   ",", "\<\"MolarVolume\"\>", ",", "\<\"MolecularWeight\"\>", 
   ",", "\<\"MoleculePlot\"\>", ",", "\<\"Name\"\>", 
   ",", "\<\"NFPAFireRating\"\>", ",", "\<\"NFPAHazards\"\>", 
   ",", "\<\"NFPAHealthRating\"\>", ",", "\<\"NFPALabel\"\>", 
   ",", "\<\"NFPAReactivityRating\"\>", ",", "\<\"NSCNumber\"\>", 
   ",", "\<\"PartitionCoefficient\"\>", ",", "\<\"Phase\"\>", 
   ",", "\<\"RefractiveIndex\"\>", ",", "\<\"RotatableBondCount\"\>", 
   ",", "\<\"RTECSClasses\"\>", ",", "\<\"RTECSNumber\"\>", 
   ",", "\<\"SMILES\"\>", ",", "\<\"SolubilityType\"\>", 
   ",", "\<\"StandardName\"\>", ",", "\<\"StructureDiagram\"\>", 
   ",", "\<\"SurfaceTension\"\>", ",", "\<\"TautomerCount\"\>", 
   ",", "\<\"TopologicalPolarSurfaceArea\"\>", 
   ",", "\<\"UpperExplosiveLimit\"\>", ",", "\<\"VaporDensity\"\>", 
   ",", "\<\"VaporizationHeat\"\>", ",", "\<\"VaporPressure\"\>", 
   ",", "\<\"VertexCoordinates\"\>", ",", "\<\"VertexTypes\"\>", 
   ",", "\<\"Viscosity\"\>"}], "}"}]], "Output",
 ImageSize->{567, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->669999470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->394706798],

Cell["Get a short textual description of a property:", "ExampleText",
 CellID->145809335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<Benzene\>\"", ",", "\"\<VaporDensity\>\"", ",", 
   "\"\<Description\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44910077],

Cell[BoxData["\<\"vapor density\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1328520561]
}, Open  ]],

Cell["Get a longer textual description:", "ExampleText",
 CellID->29023189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<Benzene\>\"", ",", "\"\<VaporDensity\>\"", ",", 
   "\"\<LongDescription\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17124444],

Cell[BoxData["\<\"density relative to air density\"\>"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->822264523]
}, Open  ]],

Cell["The actual value: ", "ExampleText",
 CellID->224887026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Benzene\>\"", ",", "\"\<VaporDensity\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29562881],

Cell[BoxData["2.8`2.000000000000004"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->742569616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332284946],

Cell["Find the units in which a property value is given:", "ExampleText",
 CellID->471574122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<Acetone\>\"", ",", "\"\<BoilingPoint\>\"", ",", "\"\<Units\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->560816081],

Cell[BoxData["\<\"DegreesCelsius\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100173262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Acetone\>\"", ",", "\"\<BoilingPoint\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1229972329],

Cell[BoxData["56.2`3.000000000000006"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2132318833]
}, Open  ]],

Cell["Get units in proper textual form:", "ExampleText",
 CellID->462577197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<Acetone\>\"", ",", "\"\<BoilingPoint\>\"", ",", "\"\<UnitsName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1250211495],

Cell[BoxData["\<\"degrees Celsius\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->675525095]
}, Open  ]],

Cell["Get units as notation:", "ExampleText",
 CellID->709789288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<Acetone\>\"", ",", "\"\<BoilingPoint\>\"", ",", 
   "\"\<UnitsNotation\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->826445282],

Cell[BoxData["\<\"\[Degree]C\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1951713623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172207452],

Cell[TextData[{
 "Uncertainty is represented using ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->488422106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<OctylAcetate\>\"", ",", "\"\<BoilingPoint\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493396966],

Cell[BoxData["197.`3.000000000000006"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->947210276]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<OctylAcetate\>\"", ",", "\"\<BoilingPoint\>\"", ",", 
   "\"\<Interval\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->431132459],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"194.5`2.998884994299202", ",", "199.5`3.001089823613064"}], "}"}],
   "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->466833521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227754128],

Cell["Find additional notes about properties:", "ExampleText",
 CellID->60667100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Dehydroabietylamine\>\"", ",", "\"\<RefractiveIndex\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502847698],

Cell[BoxData["1.5498`5.000000000000002"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1340063395]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
  "\"\<Dehydroabietylamine\>\"", ",", "\"\<RefractiveIndex\>\"", ",", 
   "\"\<Note\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->417695890],

Cell[BoxData["\<\"Value measured at a temperature of 30 degrees \
Celsius\"\>"], "Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1784473676]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Property Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->225821302],

Cell[TextData[{
 "A property value can be any valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->553589695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<LeadSulfate\>\"", ",", "\"\<Density\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529027222],

Cell[BoxData["6063.1`5.000000000000002"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1335758153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<HydrochloricAcid\>\"", ",", "\"\<Phase\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->609521478],

Cell[BoxData["\<\"Liquid\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->293231733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<AluminumPhosphide\>\"", ",", "\"\<NFPALabel\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->414708089],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.87, 0], EdgeForm[{GrayLevel[0], Thickness[0.009]}], 
   GeometricTransformationBox[
    GeometricTransformationBox[RectangleBox[{0, 0}], {0, -1}], {{{
     0.7071067811865475, -0.7071067811865475}, {0.7071067811865475, 
     0.7071067811865475}}, {0, 0}}], 
   {RGBColor[0.9, 0.25, 0.1], 
    GeometricTransformationBox[
     GeometricTransformationBox[RectangleBox[{0, 0}], {
      0, -1}], {{{-0.7071067811865475, -0.7071067811865475}, {
      0.7071067811865475, -0.7071067811865475}}, {0, 0}}]}, 
   {RGBColor[0.1, 0.37, 0.9], 
    GeometricTransformationBox[
     GeometricTransformationBox[RectangleBox[{0, 0}], {
      0, -1}], {{{-0.7071067811865475, 
      0.7071067811865475}, {-0.7071067811865475, -0.7071067811865475}}, {0, 
      0}}]}, 
   {GrayLevel[1], 
    GeometricTransformationBox[
     GeometricTransformationBox[RectangleBox[{0, 0}], {0, -1}], {{{
      0.7071067811865475, 0.7071067811865475}, {-0.7071067811865475, 
      0.7071067811865475}}, {0, 0}}]}, 
   {GrayLevel[0], 
    InsetBox["2", 
     NCache[{2^Rational[-1, 2], -0.05}, {0.7071067811865475, -0.05}]], 
    InsetBox["4", {0, 0.6821067811865474}], 
    InsetBox["4", 
     NCache[{-2^Rational[-1, 2], -0.05}, {-0.7071067811865475, -0.05}]], 
    InsetBox[
     StyleBox[
      StyleBox["\<\"W\"\>",
       StripOnInput->False,
       FontVariations->{"StrikeThrough"->True}],
      StripOnInput->False,
      FontSize->Scaled[0.18]], {0, -0.7571067811865475}]}},
  BaseStyle->{FontFamily -> "Times", FontSize -> Scaled[0.24]},
  ImageSize->167,
  PlotRange->{{-1.5, 1.5}, {-1.5, 1.5}}]], "Output",
 ImageSize->{171, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2018250313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107469361],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " to find out the number of significant digits for a property:"
}], "ExampleText",
 CellID->5758993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Toluene\>\"", ",", "\"\<MeltingPoint\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607479222],

Cell[BoxData[
 RowBox[{"-", "95.`1.9999999999999998"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1228806226]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388541687],

Cell[BoxData["1.9999999999999998`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196007183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->490922267],

Cell[TextData[{
 "A property that is not available for an chemical has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotAvailable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->187464565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Formaldehyde\>\"", ",", "\"\<BoilingPoint\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178393597],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52810183]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["Obtain a property value using the \"Value\" annotation:", "ExampleText",
 CellID->852661407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ChemicalData", "[", 
    RowBox[{"\"\<Water\>\"", ",", "\"\<BoilingPoint\>\"", ",", "#"}], "]"}], 
   "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<Value\>\"", ",", "\"\<UnitsNotation\>\""}], "}"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->521891018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100.`3.000000000000006", ",", "\<\"\[Degree]C\"\>"}], 
  "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548388396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1911442295],

Cell["Specify a chemical registry number using a list form:", "ExampleText",
 CellID->1193998041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<CID\>\"", ",", "896"}], "}"}], ",", "\"\<CASNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1009410715],

Cell[BoxData["\<\"CAS73-31-4\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1424331069]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<CAS\>\"", ",", "\"\<73-31-4\>\""}], "}"}], ",", 
   "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1673130191],

Cell[BoxData["\<\"Melatonin\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->732063574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96191124],

Cell["\<\
Find compounds containing a specified element using a string:\
\>", "ExampleText",
 CellID->1776518524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", "\"\<UraniumCompound\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1481688627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"UraniumNitride\"\>", ",", "\<\"UraniumBoride\"\>", 
   ",", "\<\"UraniumDioxide\"\>", ",", "\<\"Uranium(VI)Oxide\"\>", 
   ",", "\<\"UraniumDisilicide\"\>", ",", "\<\"Uranium(III)Fluoride\"\>", 
   ",", "\<\"UraniumSulfide\"\>", ",", "\<\"UraniumTetrafluoride\"\>", 
   ",", "\<\"UraniumPentafluoride\"\>", ",", "\<\"Uranium(III)Chloride\"\>", 
   ",", "\<\"UraniumHexafluoride\"\>", ",", "\<\"UranylSulfate\"\>", 
   ",", "\<\"Uranium(IV)Chloride\"\>", ",", "\<\"UraniumDiselenide\"\>", 
   ",", "\<\"Dioxobis(2,4-Pentanedionato-O,o')Uranium\"\>", 
   ",", "\<\"UraniumTribromide\"\>", ",", "\<\"UraniumDitelluride\"\>", 
   ",", "\<\"UraniumTetrabromide\"\>", ",", "\<\"Uranium(III)Iodide\"\>", 
   ",", "\<\"UraniumPentabromide\"\>", ",", "\<\"Uranium(IV)Iodide\"\>"}], 
  "}"}]], "Output",
 ImageSize->{566, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->858674555]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Find the distribution of molecular weights:", "ExampleText",
 CellID->107588731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "800", ",", "10"}], "}"}]}], "]"}], ",", 
      
      RowBox[{"BinCounts", "[", 
       RowBox[{
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"ChemicalData", "[", 
             RowBox[{"#", ",", "\"\<MolecularWeight\>\""}], "]"}], "&"}], "/@",
            
           RowBox[{"ChemicalData", "[", "]"}]}], ",", "_Real"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "805", ",", "10"}], "}"}]}], "]"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<molecular weight\>\"", ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1689806558],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->349339333]
}, Open  ]],

Cell["The distribution of boiling points:", "ExampleText",
 CellID->1513697018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"-", "100"}], ",", "1000", ",", "10"}], "}"}]}], "]"}], ",",
       
      RowBox[{"BinCounts", "[", 
       RowBox[{
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"ChemicalData", "[", 
             RowBox[{"#", ",", "\"\<BoilingPoint\>\""}], "]"}], "&"}], "/@", 
           RowBox[{"ChemicalData", "[", "]"}]}], ",", "_Real"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "105"}], ",", "1005", ",", "10"}], "}"}]}], "]"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<boiling point\>\"", ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->977521728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->346408877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62571143],

Cell["Investigate the structure of acid molecules:", "ExampleText",
 CellID->1138191383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Show", "[", 
        RowBox[{
         RowBox[{"ChemicalData", "[", "#", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], "&"}], "/@", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{"ChemicalData", "[", "\"\<Acid\>\"", "]"}], ",", "16"}], 
       "]"}]}], ",", "4"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232773034],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{444, 444},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74805734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7368848],

Cell["\<\
Systematically explore boiling point versus density for different chemical \
classes:\
\>", "ExampleText",
 CellID->1441660457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ChemicalData", "[", 
          RowBox[{"chem", ",", "\"\<Density\>\""}], "]"}], ",", 
         RowBox[{"ChemicalData", "[", 
          RowBox[{"chem", ",", "\"\<BoilingPoint\>\""}], "]"}]}], "}"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"chem", ",", 
         RowBox[{"ChemicalData", "[", "grp", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<density\>\"", ",", "\"\<boiling point\>\""}], "}"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"grp", ",", "\"\<Alkane\>\"", ",", "\"\<chemical class\>\""}], 
      "}"}], ",", 
     RowBox[{"ChemicalData", "[", "\"\<Classes\>\"", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->754057190],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`grp$$ = "Alkane", Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`grp$$], "Alkane", "chemical class"}, {
      "Acid", "Alcohol", "Aldehyde", "Alkane", "Alkene", "Alkyne", "Amide", 
       "Amine", "Aromatic", "Chiral", "Ester", "Ether", "Gas", "Ketone", 
       "Liquid", "NaturalProduct", "NonaromaticCyclic", "Phenol", "Poison", 
       "Solid"}}}, Typeset`size$$ = {300., {86., 91.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`grp$431755$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`grp$$ = "Alkane"}, 
      "ControllerVariables" :> {
        Hold[$CellContext`grp$$, $CellContext`grp$431755$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        Table[{
          ChemicalData[$CellContext`chem, "Density"], 
          
          ChemicalData[$CellContext`chem, 
           "BoilingPoint"]}, {$CellContext`chem, 
          ChemicalData[$CellContext`grp$$]}], 
        AxesLabel -> {"density", "boiling point"}], 
      "Specifications" :> {{{$CellContext`grp$$, "Alkane", 
          "chemical class"}, {
         "Acid", "Alcohol", "Aldehyde", "Alkane", "Alkene", "Alkyne", "Amide",
           "Amine", "Aromatic", "Chiral", "Ester", "Ether", "Gas", "Ketone", 
          "Liquid", "NaturalProduct", "NonaromaticCyclic", "Phenol", "Poison",
           "Solid"}}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{346., {127., 132.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{350, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1081201660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1285838666],

Cell["Find stereoisomers for the formula \"C5H8\":", "ExampleText",
 CellID->1361472130],

Cell[BoxData[
 RowBox[{"<<", "Combinatorica`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->967035319],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{
    RowBox[{"Subsets", "[", 
     RowBox[{
      RowBox[{"ChemicalData", "[", "\"\<C5H8\>\"", "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], "//", "Sort"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->806365937],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FromAdjacencyMatrix", "[", 
        RowBox[{
         RowBox[{"ChemicalData", "[", 
          RowBox[{"#", ",", "\"\<AdjacencyMatrix\>\""}], "]"}], "//", 
         "Normal"}], "]"}], "&"}], "/@", 
      RowBox[{"c", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "c", "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->1970490589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Labeled", "[", 
      RowBox[{
       RowBox[{"ChemicalData", "[", "#", "]"}], ",", 
       RowBox[{"ChemicalData", "[", 
        RowBox[{"#", ",", "\"\<StandardName\>\""}], "]"}]}], "]"}], "&"}], 
    ",", 
    RowBox[{"c", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"IsomorphicQ", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], "/@", "g"}], 
         ",", "True"}], "]"}], "//", "Flatten"}], "]"}], "]"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1690008936],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{288, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->815201497]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " to obtain the property values for a list of chemicals:"
}], "ExampleText",
 CellID->214644472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ChemicalData", "[", 
    RowBox[{"i", ",", "\"\<MeltingPoint\>\""}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"ChemicalData", "[", "\"\<C5H10\>\"", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1117571144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "109.`2.9999999999999973"}], ",", 
   RowBox[{"-", "165.`3.9999999999999996"}], ",", 
   RowBox[{"-", "137.5`3.9999999999999996"}], ",", 
   RowBox[{"-", "124.`2.9999999999999973"}], ",", 
   RowBox[{"-", "140.`2.9999999999999973"}], ",", 
   RowBox[{"-", "168.`2.9999999999999973"}], ",", 
   RowBox[{"-", "152.5`3.9999999999999996"}], ",", 
   RowBox[{"-", "93.3`3.0000000000000018"}], ",", 
   RowBox[{"-", "149.2`3.9999999999999996"}], ",", 
   RowBox[{"-", "144.`3.0000000000000018"}], ",", 
   RowBox[{"-", "132.`3.0000000000000018"}], ",", 
   RowBox[{"-", "161.5`3.9999999999999996"}], ",", 
   RowBox[{"-", "129.`3.0000000000000018"}], ",", 
   RowBox[{"-", "114.`3.0000000000000018"}], ",", 
   RowBox[{"-", "140.2`3.9999999999999996"}]}], "}"}]], "Output",
 ImageSize->{403, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1897162353]
}, Open  ]],

Cell[TextData[{
 "The same thing using ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->215160751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ChemicalData", "[", 
    RowBox[{"#", ",", "\"\<MeltingPoint\>\""}], "]"}], "&"}], "/@", 
  RowBox[{"ChemicalData", "[", "\"\<C5H10\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->540657586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "109.`2.9999999999999973"}], ",", 
   RowBox[{"-", "165.`3.9999999999999996"}], ",", 
   RowBox[{"-", "137.5`3.9999999999999996"}], ",", 
   RowBox[{"-", "124.`2.9999999999999973"}], ",", 
   RowBox[{"-", "140.`2.9999999999999973"}], ",", 
   RowBox[{"-", "168.`2.9999999999999973"}], ",", 
   RowBox[{"-", "152.5`3.9999999999999996"}], ",", 
   RowBox[{"-", "93.3`3.0000000000000018"}], ",", 
   RowBox[{"-", "149.2`3.9999999999999996"}], ",", 
   RowBox[{"-", "144.`3.0000000000000018"}], ",", 
   RowBox[{"-", "132.`3.0000000000000018"}], ",", 
   RowBox[{"-", "161.5`3.9999999999999996"}], ",", 
   RowBox[{"-", "129.`3.0000000000000018"}], ",", 
   RowBox[{"-", "114.`3.0000000000000018"}], ",", 
   RowBox[{"-", "140.2`3.9999999999999996"}]}], "}"}]], "Output",
 ImageSize->{403, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1917959862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183120514],

Cell["Get values of multiple properties for a list of chemicals:", \
"ExampleText",
 CellID->316513968],

Cell[BoxData[
 RowBox[{
  RowBox[{"vals", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ChemicalData", "[", 
        RowBox[{"#", ",", "prop"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"prop", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<FormulaDisplay\>\"", ",", "\"\<MolecularWeight\>\"", ",", 
           "\"\<Density\>\""}], "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
    RowBox[{"ChemicalData", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<Sodium\>\"", ",", "\"\<Compound\>\""}], "}"}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1804925199],

Cell[TextData[{
 "Display the data as a formatted table using ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->613113541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"vals", "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "10"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\>\"", ",", "\"\<molecular weight\>\"", ",", "\"\<density\>\""}], 
       "}"}]}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"LightBlue", ",", "White"}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", "\[Rule]", "LightYellow"}], "}"}]}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23822071],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   TagBox[GridBox[{
      {"\<\"\"\>", "\<\"molecular weight\"\>", "\<\"density\"\>"},
      {"\<\"NaN\\!\\(\\*SubscriptBox[\\(H\\),\\(2\\)]\\)\"\>", "39.01235`", 
       "1390.`2.9999999999999996"},
      {"\<\"NaOH  \"\>", "39.99711`", "2130.`3.0000000000000018"},
      {"\<\"NaF\"\>", "41.9881732`", "2558.`3.9999999999999996"},
      {
       InterpretationBox[
        RowBox[{
         SubscriptBox["\<\"C\"\>", "2"], "\[InvisibleSpace]", "\<\"H\"\>", 
         "\[InvisibleSpace]", "\<\"Na\"\>"}],
        Row[{
          Subscript["C", 2], "H", "Na"}]], "48.01911`", 
       "1330.`2.9999999999999996"},
      {"\<\"NaCN\"\>", "49.00717`", "1595.`3.9999999999999996"},
      {
       InterpretationBox[
        RowBox[{"\<\"Al\"\>", "\[InvisibleSpace]", 
         SubscriptBox["\<\"H\"\>", "4"], "\[InvisibleSpace]", "\<\"Na\"\>"}],
        Row[{"Al", 
          Subscript["H", 4], "Na"}]], "54.003068`", 
       "1240.`2.9999999999999996"},
      {"\<\"NaOC\\!\\(\\*SubscriptBox[\\(H\\),\\(3\\)]\\)\"\>", "54.02369`", 
       "990.`1.9999999999999998"},
      {
       InterpretationBox[
        RowBox[{"\<\"Na\"\>", "\[InvisibleSpace]", 
         InterpretationBox[
          SubsuperscriptBox["\<\"O\"\>", "2", "\<\"+\"\>"],
          Subsuperscript["O", 2, "+"],
          Editable->False]}],
        Row[{"Na", 
          Subsuperscript["O", 2, "+"]}]], "54.988569999999996`", 
       "2200.`1.9999999999999998"},
      {"\<\"NaHS\"\>", "56.062709999999996`", "1790.`3.0000000000000018"},
      {"\<\"NaCl \"\>", "58.44277`", "2160.`2.9999999999999996"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{
          RGBColor[0.87, 0.94, 1], 
          GrayLevel[1]}}, "RowsIndexed" -> {1 -> RGBColor[1, 1, 0.85]}},
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"]], "Text", "TR"],
  Text[
   Grid[{{"", "molecular weight", "density"}, {
     "NaN\!\(\*SubscriptBox[\(H\),\(2\)]\)", 39.01235, 
      1390.`2.9999999999999996}, {
     "NaOH  ", 39.99711, 2130.`3.0000000000000027}, {
     "NaF", 41.9881732, 2558.`3.9999999999999996}, {
      Row[{
        Subscript["C", 2], "H", "Na"}], 48.01911, 1330.`2.9999999999999996}, {
     "NaCN", 49.00717, 1595.`4.000000000000001}, {
      Row[{"Al", 
        Subscript["H", 4], "Na"}], 54.003068, 1240.`2.9999999999999996}, {
     "NaOC\!\(\*SubscriptBox[\(H\),\(3\)]\)", 54.02369, 
      990.`1.9999999999999987}, {
      Row[{"Na", 
        Subsuperscript["O", 2, "+"]}], 54.988569999999996`, 2200.}, {
     "NaHS", 56.062709999999996`, 1790.`3.000000000000001}, {
     "NaCl ", 58.44277, 2160.`2.9999999999999996}}, Frame -> All, 
    Background -> {None, {{{
         RGBColor[0.87, 0.94, 1], 
         GrayLevel[1]}}, {1 -> RGBColor[1, 1, 0.85]}}}, Alignment -> 
    Left]]]], "Output",
 ImageSize->{211, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1414772115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135815337],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 " to filter out non-missing data:"
}], "ExampleText",
 CellID->146537355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"ChemicalData", "[", 
          RowBox[{"#", ",", "prop"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"prop", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<FormulaDisplay\>\"", ",", "\"\<BoilingPoint\>\""}], 
            "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
      RowBox[{"ChemicalData", "[", "\"\<Alkane\>\"", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"_", ",", "_Missing"}], "}"}]}], "]"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1805150387],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WNtu1DAQ9eaym26zTVtAaoGKFgF9QbwgHuAD4ImPWFVI7QMClf4o/aEQ
ez27zvHYYwfKShvHt5kz4zP2xF/Xd9ffvq/vbq7W519u1z+vb65+nX/+cTs0
lTOlZr+VUt2JGt774c389e9++CtV6WdJbb1XPxweulpA+3th3hLqjZWj24uh
3If+t4K8jwnytVwWR7WtB0a9nmANJ2cP6ui1EuqvBL1mvDcLRx2zNn5gZBV2
BWKY3X7lrNi7gLxPAblmhWsXlZbW6nIBrbaPJF4mIjca5rs6CVpGdFRW1hvB
p0WS53U/RYcuVW3VmB8tC0o5GB61bS9tWTv217a9FrQ3ATQVKd7ab7A1iI2e
GIudI4fKHFwt50unXjOR4/oiNhdtjvoA5fg+qVyfmDER3nD7Gflo7jChsPXJ
a9ewGLIx4zotADP2E/8k7GmxYUZ58R9pdfYcYtxRkkyOS9vdWRxNuti925vN
8pO1R8tsbdll+GIaer3nuTuRFKNh3a6URZZv0nXEIpx2Gl02GX4zrPVOQY7L
mRbxFiSOnVt9iwxLQnxOi0v0J5tTYH+Qhat+czYhn9KQrwTdUr8rL+x5tPhx
vztPU32+x7ai1SvrFfIO7uI4notCd36XaT/uk7I/OP9AvsjEpE6qMCvIXSsW
RRZWXZexYh1xIydnRkzS6SVGCc56wknJjhLUjSzx8qkkrcS55+F1SIyK2Dci
d/awdS8Xo9nHKdZ6s8ORUDq2B9gU5ReeFP9uNUYsZtqORGxYxy+kv8jcoL8m
5sC4illvykWwXfLc0up52Y/z1GVAzyNBnrQyxAopI5H0dBb3aR/jos807rsr
pucA9LjfHv+HBb5VHCdGJ4mAbQpHfBQXbGtkT4sgPBP60U/PBMR87n8KoyI5
pXMaTmHMVN1oN/rt4b8KkVsom9t3srnlaeW/OXIYJuFAhuX4JG3uim19QM7x
93wTEfASpbxuwz/pPpvOLP+mTg962u++tNy8obWz2BOakU43LeO7mot+vG+3
PX/nddbvbgDce8IXAW0tq+3EwUynBHeLGrJhP0kq3V1KZ87mJlu/3ie8qdkf
sa/jZQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->118781045]
}, Open  ]],

Cell[TextData[{
 "Alternatively use ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["Except",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Except"]], "InlineFormula"],
 " to filter out missing data: "
}], "ExampleText",
 CellID->75974750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"ChemicalData", "[", 
          RowBox[{"#", ",", "prop"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"prop", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<FormulaDisplay\>\"", ",", "\"\<BoilingPoint\>\""}], 
            "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
      RowBox[{"ChemicalData", "[", "\"\<Alkane\>\"", "]"}]}], ",", 
     RowBox[{"Except", "[", 
      RowBox[{"{", 
       RowBox[{"_", ",", "_Missing"}], "}"}], "]"}]}], "]"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->424408147],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WNtu1DAQ9eaym26zTVtAaoGKFgF9QbwgHuAD4ImPWFVI7QMClf4o/aEQ
ez27zvHYYwfKShvHt5kz4zP2xF/Xd9ffvq/vbq7W519u1z+vb65+nX/+cTs0
lTOlZr+VUt2JGt774c389e9++CtV6WdJbb1XPxweulpA+3th3hLqjZWj24uh
3If+t4K8jwnytVwWR7WtB0a9nmANJ2cP6ui1EuqvBL1mvDcLRx2zNn5gZBV2
BWKY3X7lrNi7gLxPAblmhWsXlZbW6nIBrbaPJF4mIjca5rs6CVpGdFRW1hvB
p0WS53U/RYcuVW3VmB8tC0o5GB61bS9tWTv217a9FrQ3ATQVKd7ab7A1iI2e
GIudI4fKHFwt50unXjOR4/oiNhdtjvoA5fg+qVyfmDER3nD7Gflo7jChsPXJ
a9ewGLIx4zotADP2E/8k7GmxYUZ58R9pdfYcYtxRkkyOS9vdWRxNuti925vN
8pO1R8tsbdll+GIaer3nuTuRFKNh3a6URZZv0nXEIpx2Gl02GX4zrPVOQY7L
mRbxFiSOnVt9iwxLQnxOi0v0J5tTYH+Qhat+czYhn9KQrwTdUr8rL+x5tPhx
vztPU32+x7ai1SvrFfIO7uI4notCd36XaT/uk7I/OP9AvsjEpE6qMCvIXSsW
RRZWXZexYh1xIydnRkzS6SVGCc56wknJjhLUjSzx8qkkrcS55+F1SIyK2Dci
d/awdS8Xo9nHKdZ6s8ORUDq2B9gU5ReeFP9uNUYsZtqORGxYxy+kv8jcoL8m
5sC4illvykWwXfLc0up52Y/z1GVAzyNBnrQyxAopI5H0dBb3aR/jos807rsr
pucA9LjfHv+HBb5VHCdGJ4mAbQpHfBQXbGtkT4sgPBP60U/PBMR87n8KoyI5
pXMaTmHMVN1oN/rt4b8KkVsom9t3srnlaeW/OXIYJuFAhuX4JG3uim19QM7x
93wTEfASpbxuwz/pPpvOLP+mTg962u++tNy8obWz2BOakU43LeO7mot+vG+3
PX/nddbvbgDce8IXAW0tq+3EwUynBHeLGrJhP0kq3V1KZ87mJlu/3ie8qdkf
sa/jZQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->558912940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5874536],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " to plot a list of property values:"
}], "ExampleText",
 CellID->535512214],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ChemicalData", "[", 
        RowBox[{"chem", ",", "\"\<BoilingPoint\>\""}], "]"}], ",", 
       RowBox[{"ChemicalData", "[", 
        RowBox[{"chem", ",", "\"\<VaporizationHeat\>\""}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"chem", ",", 
       RowBox[{"ChemicalData", "[", "\"\<Liquid\>\"", "]"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1403006388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<boiling point\>\"", ",", "\"\<heat of vaporization\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1864310337],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->699144628]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " data is automatically excluded in plotting functions: "
}], "ExampleText",
 CellID->94821444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cases", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"_", ",", "_Missing"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->957919056],

Cell[BoxData["1183"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->311740141]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4200064],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " to label individual data points:"
}], "ExampleText",
 CellID->671567693],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ChemicalData", "[", 
          RowBox[{"chem", ",", "\"\<VaporDensity\>\""}], "]"}], ",", 
         RowBox[{"ChemicalData", "[", 
          RowBox[{"chem", ",", "\"\<RefractiveIndex\>\""}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"ChemicalData", "[", 
        RowBox[{"chem", ",", "\"\<HillFormulaDisplay\>\""}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"chem", ",", 
       RowBox[{"ChemicalData", "[", "\"\<Alcohol\>\"", "]"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68752822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<vapor density\>\"", ",", "\"\<refractive index\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1598254698],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{1.11, 1.33066}, {1.59, 1.3629}, {2.1, 0.3852}, {2.07, 
      1.3862}, {2.6, 1.43312}, {2.55, 1.425}, {2.6, 1.3993}, {2.55, 1.3976}, {
      2.6, 1.3975}, {2.55, 1.38468}, {2.7, 1.4963}, {2.97, 1.45512}, {3.04, 
      1.4103}, {3., 1.40992}, {3., 1.4075}, {3., 1.40468}, {3.1, 1.406}, {3.5,
       1.465}, {4.5, 1.4162}, {3.52, 1.414}, {3.72, 1.54035}, {3.94, 
      1.4595}, {3.9, 1.4224}, {4.5, 1.43}, {5.3, 1.4369}, {7.67, 
      1.49}}]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.94, 1.4595}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "7"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "14"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 7], 
         Subscript["H", 14], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 7], 
        Subscript["H", 14], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.9, 1.4224}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "7"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "16"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 7], 
         Subscript["H", 16], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 7], 
        Subscript["H", 16], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4.5, 1.43}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "8"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "18"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 8], 
         Subscript["H", 18], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 8], 
        Subscript["H", 18], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.3, 1.4369}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "10"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "20"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 10], 
         Subscript["H", 20], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 10], 
        Subscript["H", 20], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.67, 1.49}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "15"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "26"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 15], 
         Subscript["H", 26], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 15], 
        Subscript["H", 26], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1.11, 1.33066}}]},
      InterpretationBox[
       RowBox[{"\"C\"", "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "4"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{"C", 
         Subscript["H", 4], "O"}]]],
     Annotation[#, 
      Row[{"C", 
        Subscript["H", 4], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1.59, 1.3629}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "2"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "6"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 2], 
         Subscript["H", 6], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 2], 
        Subscript["H", 6], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1.11, 1.33066}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "3"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "8"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 3], 
         Subscript["H", 8], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 3], 
        Subscript["H", 8], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.07, 1.3862}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "3"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "8"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 3], 
         Subscript["H", 8], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 3], 
        Subscript["H", 8], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.6, 1.43312}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "2"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "6"], "\[InvisibleSpace]", 
         SubscriptBox["\"O\"", "2"]}], 
       Row[{
         Subscript["C", 2], 
         Subscript["H", 6], 
         Subscript["O", 2]}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 2], 
        Subscript["H", 6], 
        Subscript["O", 2]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.55, 1.425}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "3"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "6"], "\[InvisibleSpace]", 
         SubscriptBox["\"O\"", "2"]}], 
       Row[{
         Subscript["C", 3], 
         Subscript["H", 6], 
         Subscript["O", 2]}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 3], 
        Subscript["H", 6], 
        Subscript["O", 2]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.6, 1.3993}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "4"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "10"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 4], 
         Subscript["H", 10], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 4], 
        Subscript["H", 10], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.55, 1.3976}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "4"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "10"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 4], 
         Subscript["H", 10], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 4], 
        Subscript["H", 10], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.6, 1.3975}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "4"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "10"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 4], 
         Subscript["H", 10], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 4], 
        Subscript["H", 10], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.55, 1.38468}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "4"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "10"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 4], 
         Subscript["H", 10], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 4], 
        Subscript["H", 10], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.7, 1.4963}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "2"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "6"], "\[InvisibleSpace]", "\"O\"", 
         "\[InvisibleSpace]", "\"S\""}], 
       Row[{
         Subscript["C", 2], 
         Subscript["H", 6], "O", "S"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 2], 
        Subscript["H", 6], "O", "S"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2.97, 1.45512}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "5"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "10"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 5], 
         Subscript["H", 10], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 5], 
        Subscript["H", 10], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.04, 1.4103}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "5"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "12"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 5], 
         Subscript["H", 12], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 5], 
        Subscript["H", 12], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1.40992}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "5"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "12"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 5], 
         Subscript["H", 12], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 5], 
        Subscript["H", 12], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1.4075}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "5"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "12"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 5], 
         Subscript["H", 12], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 5], 
        Subscript["H", 12], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1.40468}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "5"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "12"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 5], 
         Subscript["H", 12], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 5], 
        Subscript["H", 12], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.1, 1.406}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "4"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "10"], "\[InvisibleSpace]", 
         SubscriptBox["\"O\"", "2"]}], 
       Row[{
         Subscript["C", 4], 
         Subscript["H", 10], 
         Subscript["O", 2]}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 4], 
        Subscript["H", 10], 
        Subscript["O", 2]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.5, 1.465}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "6"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "12"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 6], 
         Subscript["H", 12], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 6], 
        Subscript["H", 12], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4.5, 1.4162}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "6"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "14"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 6], 
         Subscript["H", 14], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 6], 
        Subscript["H", 14], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.52, 1.414}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "6"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "14"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 6], 
         Subscript["H", 14], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 6], 
        Subscript["H", 14], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.72, 1.54035}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "7"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "8"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 7], 
         Subscript["H", 8], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 7], 
        Subscript["H", 8], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.94, 1.4595}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "7"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "14"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 7], 
         Subscript["H", 14], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 7], 
        Subscript["H", 14], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.9, 1.4224}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "7"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "16"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 7], 
         Subscript["H", 16], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 7], 
        Subscript["H", 16], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4.5, 1.43}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "8"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "18"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 8], 
         Subscript["H", 18], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 8], 
        Subscript["H", 18], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.3, 1.4369}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "10"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "20"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 10], 
         Subscript["H", 20], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 10], 
        Subscript["H", 20], "O"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.67, 1.49}}]},
      InterpretationBox[
       RowBox[{
         SubscriptBox["\"C\"", "15"], "\[InvisibleSpace]", 
         SubscriptBox["\"H\"", "26"], "\[InvisibleSpace]", "\"O\""}], 
       Row[{
         Subscript["C", 15], 
         Subscript["H", 26], "O"}]]],
     Annotation[#, 
      Row[{
        Subscript["C", 15], 
        Subscript["H", 26], "O"}], "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"vapor density\"", TraditionalForm], 
    FormBox["\"refractive index\"", TraditionalForm]},
  AxesOrigin->{1., 1.3},
  PlotRange->{{1.11, 7.67}, {1.2771165, 1.54035}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{304, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1703934754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1647648724],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ElementData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ElementData"]], "InlineFormula"],
 " to get additional properties of the chemical elements:"
}], "ExampleText",
 CellID->230476203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", "\"\<Properties\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1700528280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Abbreviation\"\>", ",", "\<\"AbsoluteBoilingPoint\"\>", 
   ",", "\<\"AbsoluteMeltingPoint\"\>", ",", "\<\"AdiabaticIndex\"\>", 
   ",", "\<\"AllotropeNames\"\>", ",", "\<\"AllotropicMultiplicities\"\>", 
   ",", "\<\"AlternateNames\"\>", ",", "\<\"AlternateStandardNames\"\>", 
   ",", "\<\"AtomicNumber\"\>", ",", "\<\"AtomicRadius\"\>", 
   ",", "\<\"AtomicWeight\"\>", ",", "\<\"Block\"\>", 
   ",", "\<\"BoilingPoint\"\>", ",", "\<\"BrinellHardness\"\>", 
   ",", "\<\"BulkModulus\"\>", ",", "\<\"CASNumber\"\>", ",", "\<\"Color\"\>",
    ",", "\<\"CommonCompoundNames\"\>", ",", "\<\"CovalentRadius\"\>", 
   ",", "\<\"CriticalPressure\"\>", ",", "\<\"CriticalTemperature\"\>", 
   ",", "\<\"CrustAbundance\"\>", ",", "\<\"CrystalStructure\"\>", 
   ",", "\<\"CuriePoint\"\>", ",", "\<\"DecayMode\"\>", 
   ",", "\<\"Density\"\>", ",", "\<\"DiscoveryCountries\"\>", 
   ",", "\<\"DiscoveryYear\"\>", ",", "\<\"ElectricalConductivity\"\>", 
   ",", "\<\"ElectricalType\"\>", ",", "\<\"ElectronAffinity\"\>", 
   ",", "\<\"ElectronConfiguration\"\>", 
   ",", "\<\"ElectronConfigurationString\"\>", 
   ",", "\<\"Electronegativity\"\>", 
   ",", "\<\"ElectronShellConfiguration\"\>", ",", "\<\"FusionHeat\"\>", 
   ",", "\<\"GasAtomicMultiplicities\"\>", ",", "\<\"Group\"\>", 
   ",", "\<\"HalfLife\"\>", ",", "\<\"HumanAbundance\"\>", 
   ",", "\<\"IconColor\"\>", ",", "\<\"IonizationEnergies\"\>", 
   ",", "\<\"IsotopeAbundances\"\>", ",", "\<\"KnownIsotopes\"\>", 
   ",", "\<\"LatticeAngles\"\>", ",", "\<\"LatticeConstants\"\>", 
   ",", "\<\"Lifetime\"\>", ",", "\<\"LiquidDensity\"\>", 
   ",", "\<\"MagneticType\"\>", ",", "\<\"MassMagneticSusceptibility\"\>", 
   ",", "\<\"MeltingPoint\"\>", ",", "\<\"Memberships\"\>", 
   ",", "\<\"MeteoriteAbundance\"\>", ",", "\<\"MohsHardness\"\>", 
   ",", "\<\"MolarMagneticSusceptibility\"\>", ",", "\<\"MolarVolume\"\>", 
   ",", "\<\"Name\"\>", ",", "\<\"NeelPoint\"\>", 
   ",", "\<\"NeutronCrossSection\"\>", ",", "\<\"NeutronMassAbsorption\"\>", 
   ",", "\<\"OceanAbundance\"\>", ",", "\<\"Period\"\>", ",", "\<\"Phase\"\>",
    ",", "\<\"PoissonRatio\"\>", ",", "\<\"QuantumNumbers\"\>", 
   ",", "\<\"Radioactive\"\>", ",", "\<\"RefractiveIndex\"\>", 
   ",", "\<\"Resistivity\"\>", ",", "\<\"ShearModulus\"\>", 
   ",", "\<\"SolarAbundance\"\>", ",", "\<\"SoundSpeed\"\>", 
   ",", "\<\"SpaceGroupName\"\>", ",", "\<\"SpaceGroupNumber\"\>", 
   ",", "\<\"SpecificHeat\"\>", ",", "\<\"StableIsotopes\"\>", 
   ",", "\<\"StandardName\"\>", ",", "\<\"SuperconductingPoint\"\>", 
   ",", "\<\"ThermalConductivity\"\>", ",", "\<\"ThermalExpansion\"\>", 
   ",", "\<\"UniverseAbundance\"\>", ",", "\<\"Valence\"\>", 
   ",", "\<\"VanDerWaalsRadius\"\>", ",", "\<\"VaporizationHeat\"\>", 
   ",", "\<\"VickersHardness\"\>", 
   ",", "\<\"VolumeMagneticSusceptibility\"\>", ",", "\<\"YoungModulus\"\>"}],
   "}"}]], "Output",
 ImageSize->{571, 339},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1336977733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Carbon\>\"", ",", "\"\<HumanAbundance\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1883059209],

Cell[BoxData["0.23`1.9999999999999998"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1463359970]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Oxygen\>\"", ",", "\"\<QuantumNumbers\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->451524384],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyNTc0OQDAM7mx+Dkbi5OhpOHmIRSRzEIL3n1oXZEE06drvZ/1atel+VNvQ
qapZ1KyHbq3qaUGKMwAosPMScDe42S6MwSnx5QiDE8EBjS3HRs4Teiqzauyx
4peL3zCc+bFL+rghLtYxrzyFUIkXD/eSDktilcBT5KM/pWOCBr3Zx39gO62V
x8w=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->54471681]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1640818470],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["IsotopeData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IsotopeData"]], "InlineFormula"],
 " to find detailed information about the nuclear isotopes:"
}], "ExampleText",
 CellID->1398514163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsotopeData", "[", "\"\<Properties\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619021126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AtomicMass\"\>", ",", "\<\"AtomicNumber\"\>", 
   ",", "\<\"BindingEnergy\"\>", ",", "\<\"BranchingRatios\"\>", 
   ",", "\<\"DaughterNuclides\"\>", ",", "\<\"DecayEnergies\"\>", 
   ",", "\<\"DecayModes\"\>", ",", "\<\"DecayModeSymbols\"\>", 
   ",", "\<\"DecayProducts\"\>", ",", "\<\"ExcitedStateEnergies\"\>", 
   ",", "\<\"ExcitedStateHalfLives\"\>", ",", "\<\"ExcitedStateLifetimes\"\>",
    ",", "\<\"ExcitedStateParities\"\>", ",", "\<\"ExcitedStateSpins\"\>", 
   ",", "\<\"ExcitedStateWidths\"\>", ",", "\<\"FullSymbol\"\>", 
   ",", "\<\"HalfLife\"\>", ",", "\<\"IsotopeAbundance\"\>", 
   ",", "\<\"Lifetime\"\>", ",", "\<\"MagneticMoment\"\>", 
   ",", "\<\"MassExcess\"\>", ",", "\<\"MassNumber\"\>", 
   ",", "\<\"Memberships\"\>", ",", "\<\"Name\"\>", 
   ",", "\<\"NeutronNumber\"\>", ",", "\<\"Parity\"\>", 
   ",", "\<\"QuadrupoleMoment\"\>", ",", "\<\"QuantumStatistics\"\>", 
   ",", "\<\"Spin\"\>", ",", "\<\"Stable\"\>", ",", "\<\"Symbol\"\>", 
   ",", "\<\"Width\"\>"}], "}"}]], "Output",
 ImageSize->{576, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1329644903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsotopeData", "[", 
  RowBox[{"\"\<Deuterium\>\"", ",", "\"\<IsotopeAbundance\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->647099227],

Cell[BoxData["0.000115`3.0000000000000018"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->627054039]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsotopeData", "[", 
  RowBox[{"\"\<Carbon14\>\"", ",", "\"\<HalfLife\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1563222531],

Cell[BoxData["1.8`1.9999999999999998*^11"], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1194977644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1733355203],

Cell[TextData[{
 "Explore families of graphs using ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1007317824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphData", "[", "\"\<Classes\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1377078667],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Antiprism\"\>", ",", "\<\"Archimedean\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "67", "\[RightSkeleton]"}], 
    ",", "\<\"WeaklyRegular\"\>", ",", "\<\"Wheel\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->722195964]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphData", "[", "\"\<Properties\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105977099],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"AdjacencyMatrix\"\>", ",", "\<\"AllImages\"\>", 
    ",", "\<\"AlternateNames\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "116", "\[RightSkeleton]"}], 
    ",", "\<\"WeaklyRegular\"\>", ",", "\<\"Wheel\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{515, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->369994104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Cycle\>\"", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1996765934],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 0.}, {0.5, 
    0.866}, {-0.5, 0.866}, {-1., 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 6}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 0.}, {0.5, 
     0.866}, {-0.5, 0.866}, {-1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1525747863]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Using non-standard chemical and property names will not work: \
\>", "ExampleText",
 CellID->1329051991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<hydrochloric acid\>\"", ",", "\"\<MeltingPoint\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46500988],

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "::", "\<\"notent\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"\\\\\\\"hydrochloric acid\\\\\\\"\\\"\\) is not a known \
entity, class, or tag for \\!\\(ChemicalData\\). Use \\!\\(ChemicalData\\)[] \
for a list of entities.\"\>"}]], "Message", "MSG",
 CellID->142104614],

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\<\"hydrochloric acid\"\>", ",", "\<\"MeltingPoint\"\>"}], 
  "]"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350432034]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<HydrochloricAcid\>\"", ",", " ", "\"\<melting point\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222925477],

Cell[BoxData[
 RowBox[{
  RowBox[{"ChemicalData", "::", "\<\"notprop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"\\\\\\\"melting point\\\\\\\"\\\"\\) is not a known \
property for \\!\\(ChemicalData\\). Use \
\\!\\(ChemicalData\\)[\\\"Properties\\\"] for a list of properties.\"\>"}]], \
"Message", "MSG",
 CellID->1311035364],

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\<\"HydrochloricAcid\"\>", ",", "\<\"melting point\"\>"}], 
  "]"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1389144528]
}, Open  ]],

Cell["Use string functions to find the standardized names: ", "ExampleText",
 CellID->173046581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ChemicalData", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{
      "___", "~~", "\"\<hydrochloric\>\"", "~~", "___", "~~", 
       "\"\<acid\>\""}], ",", 
      RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->135247669],

Cell[BoxData[
 RowBox[{"{", "\<\"HydrochloricAcid\"\>", "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2057355559]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ChemicalData", "[", 
    RowBox[{"\"\<HydrochloricAcid\>\"", ",", "\"\<Properties\>\""}], "]"}], 
   ",", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"___", "~~", "\"\<melting\>\"", "~~", "___"}], ",", 
      RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->57009403],

Cell[BoxData[
 RowBox[{"{", "\<\"MeltingPoint\"\>", "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1340679766]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<HydrochloricAcid\>\"", ",", "\"\<MeltingPoint\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1260968962],

Cell[BoxData[
 RowBox[{"-", "74.`1.9999999999999998"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1406402838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90344104],

Cell[TextData[{
 "Arithmetical operations cannot be carried out on ",
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " entries:"
}], "ExampleText",
 CellID->46301994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"45", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ChemicalData", "[", 
     RowBox[{"chem", ",", "\"\<BoilingPoint\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"chem", ",", 
      RowBox[{"ChemicalData", "[", "\"\<C4H8\>\"", "]"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1739347100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "274.5`1.9999999999999998"}], ",", 
   "39.5999999999999999998`1.9999999999999998", ",", 
   "166.5`1.9999999999999998", ",", "540.`1.9999999999999998", ",", 
   RowBox[{"-", "310.5`1.9999999999999998"}], ",", "31.5`1.000000000000002", 
   ",", 
   RowBox[{"45", " ", 
    RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]}], ",", 
   RowBox[{"45", " ", 
    RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]}], ",", 
   "39.5999999999999999998`1.9999999999999998"}], "}"}]], "Output",
 ImageSize->{390, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59995737]
}, Open  ]],

Cell[TextData[{
 "Remove the ",
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " entries before performing operations: "
}], "ExampleText",
 CellID->85509328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ChemicalData", "[", 
      RowBox[{"chem", ",", "\"\<BoilingPoint\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"chem", ",", 
       RowBox[{"ChemicalData", "[", "\"\<C4H8\>\"", "]"}]}], "}"}]}], "]"}], 
   ",", "_Missing"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->548645387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "6.1`1.9999999999999998"}], ",", "0.88`1.9999999999999998", 
   ",", "3.7`1.9999999999999998", ",", "12.`1.9999999999999998", ",", 
   RowBox[{"-", "6.9`1.9999999999999998"}], ",", "0.7`1.000000000000002", ",",
    "0.88`1.9999999999999998"}], "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1178521316]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"45", " ", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->60605648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "274.5`1.9999999999999998"}], ",", 
   "39.5999999999999999998`1.9999999999999998", ",", 
   "166.5`1.9999999999999998", ",", "540.`1.9999999999999998", ",", 
   RowBox[{"-", "310.5`1.9999999999999998"}], ",", "31.5`1.000000000000002", 
   ",", "39.5999999999999999998`1.9999999999999998"}], "}"}]], "Output",
 ImageSize->{395, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1166081731]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["\<\
Find chemical isomers of nonaromatic cyclic molecules in a network based on \
bond tally matches:\
\>", "ExampleText",
 CellID->1086410556],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Subsets", "[", 
    RowBox[{
     RowBox[{"ChemicalData", "[", "\"\<NonaromaticCyclic\>\"", "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550905309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}], "/@", 
   RowBox[{"Cases", "[", 
    RowBox[{"c", ",", 
     RowBox[{"x_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChemicalData", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<BondTally\>\""}], "]"}],
          "==", 
         RowBox[{"ChemicalData", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<BondTally\>\""}], 
          "]"}]}], "&"}], ")"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->792346524],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxNk3s01GkYx2dcfqOZNcOMyYwwOc3OyqXd3NqwvS+pFZmV2Fp2E5vLIhFK
DmKjJBWbRVpStEdNCalE2++ts9kWR8iOS1Yuuc/QJMZlsdY2v/zxnvd8zvM9
z/M+z/t8DXwPufkpkUikPUvnv9ungHX/6r0BkMYUe7zs56DPxmYZ2JFa8MM9
I15XGBsJ1RN5VcIJsNXCsdj2IBvtW1zlSc/ThNbX+yPSqlno5FNhQIs5A2q7
WH9xfrsGutZAOTN0kQVltXtqpPYahJ73vai2pleJ0Jd6XK/KkclxhV7HhfeK
2SfHFfo/PW3ax03UCf2PV18HT9pjRP5N+bz4chsMpXYdiMCs1OGc3mPpsSg2
MizKzBIxmfBpzWUXpUA28tJPPWLlpg6pCfGl7FEOavNOlWxey4Q/TRU5RHZx
UFnUm8Pd9qqQ42qTFWnMQrG2xoIcWzIcHuThYyEMBLUkLZm2q2B+n2eTyI+B
UuIoEkc7LuzYW9jEsxrF/2c2PE3OXuZ627OyjDoqrH+V/3WVeRee28nfMfiS
BKt6Gmg/G8rwxwFfXWP10+CjWW3Rc54Mb39Q4MGYJENX4fHh8cAu/OY534QM
Xwya8pUoL4RSfMMvwY3iMWXo5nVb6Nw8jZ/4ztPIzBuD7/8Jf3j69t60NjXI
x2zD/2icxhXvC36ex/AelBPve1KYvcyK/73YYeyy7ugQXsAoOn/XvhuEhJ58
pv33X3jcLrMSiWgMKPIXzzvRXXTmgMBApH4pYBjf/ihVYEmZACnrd0uS46S4
7sHq+/SgAUAfkH6zrlKKp6SMmYh/ewvCzKMqtCpncLmy9bZDaQPgYaKdcWPh
DO45xwn+J+YFyL+QLDYcfod7lQ9knkqeAjsdqn39a8T4muajjhzTGXCGlxMt
s54k+rGcsVjTyiUjRT8+fRtXMBdWUC+VLACMiHe/y17BXGiuS7YX+NOIuDe2
YPeBubA9686IYGl/FfFxWvky39x5wrvVTAW66H5KrtQloc/1cwEvlwal+0q2
bOIro/3TI0nNPhh05ee0PXJXRaFvaGEBS/EqZHD442MURK3NVtFNV4PxCxWJ
peeoaGx3YPwFARkGWRkOepgoo6gKvx6GtQo0XAzvyz9LRb83Pnwyv54MT6na
5N1JoKCPTNfKb6SoQUtlC6caNgkZ6TcyV2+Qg0w+HevdoUT4NfqBgd1dbQrS
inSP4frMgNltNeluLArS8OkM3qoiBn5mQZUprkqo5cTkfqNKCfi1aTaW16qK
Oh5wr4DhXuAwleGbLqGijXiL2q0bEhAv36xbZ0RC1EqtHqrjBLjl3BbRMEol
/Dwitoq22SjDFf58beYssRipJfys2B/FfHMu+1dYtzOJ+ZZo+S0zLSlKb6p5
ESj8W298/FldG0b4t5XcrSlSJRH+NSkMihyawAj/KvLvLebGC0PYRP5QPc4y
t5CbwrHudtA53x3ul0BHwaszPilLnQLGQCfPaVATIfVA58Bv3wKaewZ/lw0d
tageEG2JHQF92gWSK4hFzDckaYIao8ck6nHK6r/0XdQm6m0Q1K1gLgx3NtH4
0D8bmr6fx79EzIFP
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 3}, {4, 5}, {4, 6}, {5, 6}, {7, 8}, {7, 
       9}, {8, 9}, {10, 11}, {10, 12}, {11, 12}, {13, 14}, {13, 15}, {13, 
       16}, {14, 15}, {14, 16}, {15, 16}, {17, 18}, {17, 19}, {18, 19}, {20, 
       21}, {22, 23}, {22, 24}, {22, 25}, {22, 26}, {22, 27}, {22, 28}, {22, 
       29}, {23, 24}, {23, 25}, {23, 26}, {23, 27}, {23, 28}, {23, 29}, {24, 
       25}, {24, 26}, {24, 27}, {24, 28}, {24, 29}, {25, 26}, {25, 27}, {25, 
       28}, {25, 29}, {26, 27}, {26, 28}, {26, 29}, {27, 28}, {27, 29}, {28, 
       29}, {30, 31}, {32, 33}, {32, 34}, {32, 35}, {32, 36}, {32, 37}, {32, 
       38}, {32, 39}, {32, 40}, {32, 41}, {32, 42}, {33, 34}, {33, 35}, {33, 
       36}, {33, 37}, {33, 38}, {33, 39}, {33, 40}, {33, 41}, {33, 42}, {34, 
       35}, {34, 36}, {34, 37}, {34, 38}, {34, 39}, {34, 40}, {34, 41}, {34, 
       42}, {35, 36}, {35, 37}, {35, 38}, {35, 39}, {35, 40}, {35, 41}, {35, 
       42}, {36, 37}, {36, 38}, {36, 39}, {36, 40}, {36, 41}, {36, 42}, {37, 
       38}, {37, 39}, {37, 40}, {37, 41}, {37, 42}, {38, 39}, {38, 40}, {38, 
       41}, {38, 42}, {39, 40}, {39, 41}, {39, 42}, {40, 41}, {40, 42}, {41, 
       42}, {43, 44}, {45, 46}, {47, 48}, {49, 50}, {51, 52}, {51, 53}, {51, 
       54}, {51, 55}, {51, 56}, {51, 57}, {51, 58}, {51, 59}, {52, 53}, {52, 
       54}, {52, 55}, {52, 56}, {52, 57}, {52, 58}, {52, 59}, {53, 54}, {53, 
       55}, {53, 56}, {53, 57}, {53, 58}, {53, 59}, {54, 55}, {54, 56}, {54, 
       57}, {54, 58}, {54, 59}, {55, 56}, {55, 57}, {55, 58}, {55, 59}, {56, 
       57}, {56, 58}, {56, 59}, {57, 58}, {57, 59}, {58, 59}, {60, 61}, {60, 
       62}, {60, 63}, {60, 64}, {60, 65}, {60, 66}, {60, 67}, {61, 62}, {61, 
       63}, {61, 64}, {61, 65}, {61, 66}, {61, 67}, {62, 63}, {62, 64}, {62, 
       65}, {62, 66}, {62, 67}, {63, 64}, {63, 65}, {63, 66}, {63, 67}, {64, 
       65}, {64, 66}, {64, 67}, {65, 66}, {65, 67}, {66, 67}, {68, 69}, {68, 
       70}, {69, 70}, {71, 72}, {73, 74}, {73, 75}, {73, 76}, {74, 75}, {74, 
       76}, {75, 76}, {77, 78}, {79, 80}, {79, 81}, {79, 82}, {79, 83}, {80, 
       81}, {80, 82}, {80, 83}, {81, 82}, {81, 83}, {82, 83}, {84, 85}, {86, 
       87}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "\"Cyclopentane\""],
       Annotation[#, "Cyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "\"Methylcyclobutane\""],
       Annotation[#, "Methylcyclobutane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "\"Trans-1,2-Dimethylcyclopropane\""],
       Annotation[#, "Trans-1,2-Dimethylcyclopropane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "\"Cis-2,3-Dimethyloxirane\""],
       Annotation[#, "Cis-2,3-Dimethyloxirane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "\"Tetrahydrofuran\""],
       Annotation[#, "Tetrahydrofuran", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "\"Trans-2,3-Dimethyloxirane\""],
       Annotation[#, "Trans-2,3-Dimethyloxirane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "\"1,3-Cyclohexadiene\""],
       Annotation[#, "1,3-Cyclohexadiene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "\"1,4-Cyclohexadiene\""],
       Annotation[#, "1,4-Cyclohexadiene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "\"Cyclohexadiene\""],
       Annotation[#, "Cyclohexadiene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "\"1-Methylcyclopentene\""],
       Annotation[#, "1-Methylcyclopentene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "\"Cyclohexene\""],
       Annotation[#, "Cyclohexene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "\"Methylenecyclopentane\""],
       Annotation[#, "Methylenecyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "\"Cyclohexane\""],
       Annotation[#, "Cyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "\"Cyclohexane-D12\""],
       Annotation[#, "Cyclohexane-D12", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "\"Ethylcyclobutane\""],
       Annotation[#, "Ethylcyclobutane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "\"MethylCyclopentane\""],
       Annotation[#, "MethylCyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "\"1-Methylcyclohexene\""],
       Annotation[#, "1-Methylcyclohexene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "\"3-Methylcyclohexene\""],
       Annotation[#, "3-Methylcyclohexene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "\"Methylenecyclohexane\""],
       Annotation[#, "Methylenecyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "\"Bicyclo[2.2.1]heptane\""],
       Annotation[#, "Bicyclo[2.2.1]heptane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "\"Bicyclo[4.1.0]heptane\""],
       Annotation[#, "Bicyclo[4.1.0]heptane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "\"Cis-1,2-Dimethylcyclopentane\""],
       Annotation[#, "Cis-1,2-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "\"Cis-1,3-Dimethylcyclopentane\""],
       Annotation[#, "Cis-1,3-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "\"Cycloheptane\""],
       Annotation[#, "Cycloheptane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "\"Dimethylcyclopentane\""],
       Annotation[#, "Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "\"Ethylcyclopentane\""],
       Annotation[#, "Ethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "\"Methylcyclohexane\""],
       Annotation[#, "Methylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "\"Trans-1,2-Dimethylcyclopentane\""],
       Annotation[#, "Trans-1,2-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "\"Trans-1,3-Dimethylcyclopentane\""],
       Annotation[#, "Trans-1,3-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "\"1,4-Endoethylenecyclohexane\""],
       Annotation[#, "1,4-Endoethylenecyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "\"Bicyclo[4.2.0]octane\""],
       Annotation[#, "Bicyclo[4.2.0]octane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "\"1,1-Dimethylcyclohexane\""],
       Annotation[#, "1,1-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "\"1,4-Dimethylcyclohexane\""],
       Annotation[#, "1,4-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "\"Cis-1,2-Dimethylcyclohexane\""],
       Annotation[#, "Cis-1,2-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "\"Cis-1,3-Dimethylcyclohexane\""],
       Annotation[#, "Cis-1,3-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "\"Cis-1,4-Dimethylcyclohexane\""],
       Annotation[#, "Cis-1,4-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "\"Cis-1-Ethyl-3-Methylcyclopentane\""],
       Annotation[#, "Cis-1-Ethyl-3-Methylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "\"Cyclooctane\""],
       Annotation[#, "Cyclooctane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "\"Ethylcyclohexane\""],
       Annotation[#, "Ethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "\"Trans-1,2-Dimethylcyclohexane\""],
       Annotation[#, "Trans-1,2-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "\"Trans-1,4-Dimethylcyclohexane\""],
       Annotation[#, "Trans-1,4-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "\"Trans-1-Ethyl-2-Methylcyclopentane\""],
       Annotation[#, "Trans-1-Ethyl-2-Methylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "\"1-Methylcyclohexanol\""],
       Annotation[#, "1-Methylcyclohexanol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "\"Trans-3-Methylcyclohexanol\""],
       Annotation[#, "Trans-3-Methylcyclohexanol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "\"Cis-Cyclononene\""],
       Annotation[#, "Cis-Cyclononene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "\"Trans-Cyclononene\""],
       Annotation[#, "Trans-Cyclononene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "\"Isopropylcyclohexane\""],
       Annotation[#, "Isopropylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "\"Propylcyclohexane\""],
       Annotation[#, "Propylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "\"1-Isopropyl-4-Methyl-1,3-Cyclohexadiene\""],
       Annotation[#, "1-Isopropyl-4-Methyl-1,3-Cyclohexadiene", "Tooltip"]& ],
       
      TagBox[
       TooltipBox[PointBox[50],
        "\"Gamma-Terpinene\""],
       Annotation[#, "Gamma-Terpinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "\"(1R,4S)-(-)-Champhene\""],
       Annotation[#, "(1R,4S)-(-)-Champhene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "\"2,2-Dimethyl-3-Methylenenorbornane\""],
       Annotation[#, "2,2-Dimethyl-3-Methylenenorbornane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "\"2-Pinene\""],
       Annotation[#, "2-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "\"(+/-)-6,6-Dimethyl-2-Methylenebicyclo[3.1.1]heptane\""],
       Annotation[#, "(+/-)-6,6-Dimethyl-2-Methylenebicyclo[3.1.1]heptane", 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "\"(-)-Alpha-Pinene\""],
       Annotation[#, "(-)-Alpha-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "\"Alpha-Pinene\""],
       Annotation[#, "Alpha-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "\"Beta-Pinene\""],
       Annotation[#, "Beta-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "\"Camphene\""],
       Annotation[#, "Camphene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "\"DidehydroDerivativePinane\""],
       Annotation[#, "DidehydroDerivativePinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "\"(1R)-(+)-Cis-Pinane\""],
       Annotation[#, "(1R)-(+)-Cis-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "\"(1R)-(+)-Trans-Pinane\""],
       Annotation[#, "(1R)-(+)-Trans-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "\"(1S)-(-)-Cis-Pinane\""],
       Annotation[#, "(1S)-(-)-Cis-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "\"(1S)-(+)-Trans-Pinane\""],
       Annotation[#, "(1S)-(+)-Trans-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "\"Cis-Decahydronaphthalene\""],
       Annotation[#, "Cis-Decahydronaphthalene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "\"Cis-Pinane\""],
       Annotation[#, "Cis-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "\"Pinane\""],
       Annotation[#, "Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "\"Trans-Decahydronaphthalene\""],
       Annotation[#, "Trans-Decahydronaphthalene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "\"(+/-)-Camphor\""],
       Annotation[#, "(+/-)-Camphor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "\"D-Camphor\""],
       Annotation[#, "D-Camphor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "\"L-Camphor\""],
       Annotation[#, "L-Camphor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "\"5-Methyl-2-(1-Methylethyl)Cyclohexanone\""],
       Annotation[#, "5-Methyl-2-(1-Methylethyl)Cyclohexanone", "Tooltip"]& ],
       
      TagBox[
       TooltipBox[PointBox[72],
        "\"(-)-Menthone\""],
       Annotation[#, "(-)-Menthone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "\"DL-Menthol\""],
       Annotation[#, "DL-Menthol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "\"Hexahydrothymol\""],
       Annotation[#, "Hexahydrothymol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "\"L-(-)-Menthol\""],
       Annotation[#, "L-(-)-Menthol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "\"ParaMenthan-3-ol\""],
       Annotation[#, "ParaMenthan-3-ol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "\"Androsterone\""],
       Annotation[#, "Androsterone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "\"Trans-Androsterone\""],
       Annotation[#, "Trans-Androsterone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "\"Alpha-Hexachlorocyclohexane\""],
       Annotation[#, "Alpha-Hexachlorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "\"Beta-Hexachlorocyclohexane\""],
       Annotation[#, "Beta-Hexachlorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "\"Delta-Hexachlorocyclohexane\""],
       Annotation[#, "Delta-Hexachlorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "\"Hexachlorocyclohexane(MixedIsomers)\""],
       Annotation[#, "Hexachlorocyclohexane(MixedIsomers)", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "\"Lindane\""],
       Annotation[#, "Lindane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "\"Aldrin\""],
       Annotation[#, "Aldrin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "\"Isodrin\""],
       Annotation[#, "Isodrin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "\"Beta-Carotene\""],
       Annotation[#, "Beta-Carotene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "\"Quillajasaponin\""],
       Annotation[#, "Quillajasaponin", "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNk3s01GkYx2dcfqOZNcOMyYwwOc3OyqXd3NqwvS+pFZmV2Fp2E5vLIhFK
DmKjJBWbRVpStEdNCalE2++ts9kWR8iOS1Yuuc/QJMZlsdY2v/zxnvd8zvM9
z/M+z/t8DXwPufkpkUikPUvnv9ungHX/6r0BkMYUe7zs56DPxmYZ2JFa8MM9
I15XGBsJ1RN5VcIJsNXCsdj2IBvtW1zlSc/ThNbX+yPSqlno5FNhQIs5A2q7
WH9xfrsGutZAOTN0kQVltXtqpPYahJ73vai2pleJ0Jd6XK/KkclxhV7HhfeK
2SfHFfo/PW3ax03UCf2PV18HT9pjRP5N+bz4chsMpXYdiMCs1OGc3mPpsSg2
MizKzBIxmfBpzWUXpUA28tJPPWLlpg6pCfGl7FEOavNOlWxey4Q/TRU5RHZx
UFnUm8Pd9qqQ42qTFWnMQrG2xoIcWzIcHuThYyEMBLUkLZm2q2B+n2eTyI+B
UuIoEkc7LuzYW9jEsxrF/2c2PE3OXuZ627OyjDoqrH+V/3WVeRee28nfMfiS
BKt6Gmg/G8rwxwFfXWP10+CjWW3Rc54Mb39Q4MGYJENX4fHh8cAu/OY534QM
Xwya8pUoL4RSfMMvwY3iMWXo5nVb6Nw8jZ/4ztPIzBuD7/8Jf3j69t60NjXI
x2zD/2icxhXvC36ex/AelBPve1KYvcyK/73YYeyy7ugQXsAoOn/XvhuEhJ58
pv33X3jcLrMSiWgMKPIXzzvRXXTmgMBApH4pYBjf/ihVYEmZACnrd0uS46S4
7sHq+/SgAUAfkH6zrlKKp6SMmYh/ewvCzKMqtCpncLmy9bZDaQPgYaKdcWPh
DO45xwn+J+YFyL+QLDYcfod7lQ9knkqeAjsdqn39a8T4muajjhzTGXCGlxMt
s54k+rGcsVjTyiUjRT8+fRtXMBdWUC+VLACMiHe/y17BXGiuS7YX+NOIuDe2
YPeBubA9686IYGl/FfFxWvky39x5wrvVTAW66H5KrtQloc/1cwEvlwal+0q2
bOIro/3TI0nNPhh05ee0PXJXRaFvaGEBS/EqZHD442MURK3NVtFNV4PxCxWJ
peeoaGx3YPwFARkGWRkOepgoo6gKvx6GtQo0XAzvyz9LRb83Pnwyv54MT6na
5N1JoKCPTNfKb6SoQUtlC6caNgkZ6TcyV2+Qg0w+HevdoUT4NfqBgd1dbQrS
inSP4frMgNltNeluLArS8OkM3qoiBn5mQZUprkqo5cTkfqNKCfi1aTaW16qK
Oh5wr4DhXuAwleGbLqGijXiL2q0bEhAv36xbZ0RC1EqtHqrjBLjl3BbRMEol
/Dwitoq22SjDFf58beYssRipJfys2B/FfHMu+1dYtzOJ+ZZo+S0zLSlKb6p5
ESj8W298/FldG0b4t5XcrSlSJRH+NSkMihyawAj/KvLvLebGC0PYRP5QPc4y
t5CbwrHudtA53x3ul0BHwaszPilLnQLGQCfPaVATIfVA58Bv3wKaewZ/lw0d
tageEG2JHQF92gWSK4hFzDckaYIao8ck6nHK6r/0XdQm6m0Q1K1gLgx3NtH4
0D8bmr6fx79EzIFP
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{304, 296},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->399890395]
}, Open  ]],

Cell["A network using a looser matching criterion:", "ExampleText",
 CellID->1196437502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}], "/@", 
   RowBox[{"Cases", "[", 
    RowBox[{"c", ",", 
     RowBox[{"x_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Intersection", "[", 
           RowBox[{
            RowBox[{"ChemicalData", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<BondTally\>\""}], 
             "]"}], ",", 
            RowBox[{"ChemicalData", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<BondTally\>\""}], 
             "]"}]}], "]"}], "]"}], ">", "1"}], "&"}], ")"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1263526146],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9lXs01Nsbxl0qokTFMJj5jtuUmTHzTSYlfV+JECpd5dLUuNXvSHLpdIqU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    "], {
     {RGBColor[0.5, 0., 0.], LineBox[CompressedData["
1:eJwVxWdDGgcAANA0CkidSdwrx+29r81gg2ib1Rx3wAE3yoaWDa5WSRQ1Wlf7
i9t+ec9XaKuFp0+ePGn+x/9/93RicsI14Z7wTExNuibdk57JqUmvy+3yuBZd
U64l17Lb4150T7mX3MueRc+UZ8mz7D3zMl7eK3pH3vPvvdMz07PTc9Pz0wsz
szNzM/MzC7Nzs/OzC3PzcwtzK/ML8ysLK8+eP3vx/MXS8srJyunKaHVtdX11
Y3VzdWt1e219bWNtc21rbXt9Y31zfWt9e2NzY2tje3Nrc3tr+yXw0geAAATA
AAKgAAbgAAGQAAXQAAOwAAfwgACIgATIgOIDfTu+hG/Xt+f7CdwBIRAGETAB
oiAG4iAB7oJ7IAlSIA0yIAtyIA8KoAhKoAwqEAwhEAphEA4REAlREA0xEAtx
EA8JkAhJkAwpMAKjMAbjMAGTMAXTMAOzMAfzsACLsATLsIKgCIbgCIGQCIXQ
CIOwCIfwiICIiITIiIJiKI4SKIlSKI0yKItyKI8KqIhKqIwqGI4RGIlRGI0x
GItxGI8JmIhJmIwpOIGTOIXTOIOzOIfzuICLuITLuEKQBEXQBEOwBEfwhECI
hETIhEKekBRJkwzJkhzJk2NSIC9IkbwkJVImz0mFoimGYimO4qkxJVAidUNJ
lEydUwrN0CzN0Twt0CL9Fy3RMq0wLMMxPCMwIjNiJEZmFJZjeVZgRVZiZVbh
eE7gRE7iZE7hBV7kR7zEy7wiiMJXQRJkQRFHoiTKoiLJkiIrP/z46vWrN6/e
vl588/7tZ3/AH/SH/GF/xB/1x/zxQDAQCoQDkUA0EAvEg6FgOBgJRoOxYDwU
DkVC0VAsFA9HwtFwLByPRCOxSDwai8Zj8finncTO7s5e4m3ic2I3sbe79/O7
d58/fPzw6eOnX6bUpKqpuppS02pGNdSsmlPzqqlaqq06SS2pJ1PJdDKTNJLZ
ZC6ZT5pJK2knHU3XUlpay2iGltVyWl4zNUuzNUdP6Wk9oxt6Vs/ped3ULd3W
nVQ6lUkZqWwql8qnzJSVslNOOpM20tl0Lp1Pm2krbaedjJHJZnKZfMbMWBk7
4xhZI2fkDdOwDNtwsrlsPmtmrayddXL5nJmzcnbOyZt5K2/nHdMybbNgFs2S
WTYrZtWsmXWzYTqWbRWsolWyylbFqlo1q241LMd27KbT/PV9oVgoFcqFSqFa
qBXqhUahVSwVy8VKsVqsFevFRrFVKpcqpWqpVqqXGqVWuVKulmvlerlRblWq
lVqlXmlUWtVatV5tVFu1eq1Ra9Ub9Vaj9dvvzeOm0O60u+1eu98etIft/U63
0+v0O4POsLPf7XX73UF32N3v9XuD3rC33x/0h/39wXCwP9w/ODw4OmgeHB8e
HTYPj4+aR8fHwh9/npyeXJ5ejr59+Xo2Prs8Oz/7Nr4Yj8bfLm4uz69Orqir
06vx1cU1dT2+vri+uR7dnN/e3d7fPtw+3t3fPdw93j/cPz48/v3Pv+Z5SCE=

       "]]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "\"Cyclopropane\""],
       Annotation[#, "Cyclopropane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "\"1,3-Cyclopentadiene\""],
       Annotation[#, "1,3-Cyclopentadiene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "\"Cyclobutane\""],
       Annotation[#, "Cyclobutane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "\"Cyclopentene\""],
       Annotation[#, "Cyclopentene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "\"1,3-Cyclohexadiene\""],
       Annotation[#, "1,3-Cyclohexadiene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "\"1,4-Cyclohexadiene\""],
       Annotation[#, "1,4-Cyclohexadiene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "\"Cyclohexadiene\""],
       Annotation[#, "Cyclohexadiene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "\"Piracetam\""],
       Annotation[#, "Piracetam", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "\"ErythorbicAcid\""],
       Annotation[#, "ErythorbicAcid", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "\"Cyclobutanone\""],
       Annotation[#, "Cyclobutanone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "\"Cyclopentane\""],
       Annotation[#, "Cyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "\"Methylcyclobutane\""],
       Annotation[#, "Methylcyclobutane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "\"Trans-1,2-Dimethylcyclopropane\""],
       Annotation[#, "Trans-1,2-Dimethylcyclopropane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "\"1-Methylcyclopentene\""],
       Annotation[#, "1-Methylcyclopentene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "\"Cyclohexene\""],
       Annotation[#, "Cyclohexene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "\"Methylenecyclopentane\""],
       Annotation[#, "Methylenecyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "\"Cis-2,3-Dimethyloxirane\""],
       Annotation[#, "Cis-2,3-Dimethyloxirane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "\"Tetrahydrofuran\""],
       Annotation[#, "Tetrahydrofuran", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "\"Trans-2,3-Dimethyloxirane\""],
       Annotation[#, "Trans-2,3-Dimethyloxirane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "\"1-Methoxycyclohexa-1,4-Diene\""],
       Annotation[#, "1-Methoxycyclohexa-1,4-Diene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "\"Aldrin\""],
       Annotation[#, "Aldrin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "\"Isodrin\""],
       Annotation[#, "Isodrin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "\"RhodizonicAcid\""],
       Annotation[#, "RhodizonicAcid", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "\"Cyclohexane\""],
       Annotation[#, "Cyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "\"Cyclohexane-D12\""],
       Annotation[#, "Cyclohexane-D12", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "\"Ethylcyclobutane\""],
       Annotation[#, "Ethylcyclobutane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "\"MethylCyclopentane\""],
       Annotation[#, "MethylCyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "\"1-Methylcyclohexene\""],
       Annotation[#, "1-Methylcyclohexene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "\"3-Methylcyclohexene\""],
       Annotation[#, "3-Methylcyclohexene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "\"Methylenecyclohexane\""],
       Annotation[#, "Methylenecyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "\"Cyclopentylamine\""],
       Annotation[#, "Cyclopentylamine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "\"Cyclopentanol\""],
       Annotation[#, "Cyclopentanol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "\"Cyclohexylamine\""],
       Annotation[#, "Cyclohexylamine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "\"Cyclohexanol\""],
       Annotation[#, "Cyclohexanol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "\"SquaricAcid\""],
       Annotation[#, "SquaricAcid", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "\"1-Methylcyclohexanol\""],
       Annotation[#, "1-Methylcyclohexanol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "\"Trans-3-Methylcyclohexanol\""],
       Annotation[#, "Trans-3-Methylcyclohexanol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "\"DL-Menthol\""],
       Annotation[#, "DL-Menthol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "\"Hexahydrothymol\""],
       Annotation[#, "Hexahydrothymol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "\"L-(-)-Menthol\""],
       Annotation[#, "L-(-)-Menthol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "\"ParaMenthan-3-ol\""],
       Annotation[#, "ParaMenthan-3-ol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "\"Estrone\""],
       Annotation[#, "Estrone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "\"Pentazocine\""],
       Annotation[#, "Pentazocine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "\"VitaminA\""],
       Annotation[#, "VitaminA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "\"Testosterone\""],
       Annotation[#, "Testosterone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "\"Androsterone\""],
       Annotation[#, "Androsterone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "\"Trans-Androsterone\""],
       Annotation[#, "Trans-Androsterone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "\"Norethindrone\""],
       Annotation[#, "Norethindrone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "\"AbieticAcid\""],
       Annotation[#, "AbieticAcid", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "\"Pregnenolone\""],
       Annotation[#, "Pregnenolone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "\"7-Dehydrocholesterol\""],
       Annotation[#, "7-Dehydrocholesterol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "\"Cholesterol\""],
       Annotation[#, "Cholesterol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "\"Ergosterol\""],
       Annotation[#, "Ergosterol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "\"Bicyclo[2.2.1]heptane\""],
       Annotation[#, "Bicyclo[2.2.1]heptane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "\"Bicyclo[4.1.0]heptane\""],
       Annotation[#, "Bicyclo[4.1.0]heptane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "\"Cyclohexanone\""],
       Annotation[#, "Cyclohexanone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "\"CyclohexeneOxide\""],
       Annotation[#, "CyclohexeneOxide", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "\"Norcamphor\""],
       Annotation[#, "Norcamphor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "\"CyclopentanecarbonylChloride\""],
       Annotation[#, "CyclopentanecarbonylChloride", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "\"Cis-1,2-Dimethylcyclopentane\""],
       Annotation[#, "Cis-1,2-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "\"Cis-1,3-Dimethylcyclopentane\""],
       Annotation[#, "Cis-1,3-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "\"Cycloheptane\""],
       Annotation[#, "Cycloheptane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "\"Dimethylcyclopentane\""],
       Annotation[#, "Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "\"Ethylcyclopentane\""],
       Annotation[#, "Ethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "\"Methylcyclohexane\""],
       Annotation[#, "Methylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "\"Trans-1,2-Dimethylcyclopentane\""],
       Annotation[#, "Trans-1,2-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "\"Trans-1,3-Dimethylcyclopentane\""],
       Annotation[#, "Trans-1,3-Dimethylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "\"1-Ethylcyclohexene\""],
       Annotation[#, "1-Ethylcyclohexene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "\"Fluorocyclohexane\""],
       Annotation[#, "Fluorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "\"Chlorocyclohexane\""],
       Annotation[#, "Chlorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "\"Bromocyclohexane\""],
       Annotation[#, "Bromocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "\"Iodocyclohexane\""],
       Annotation[#, "Iodocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "\"2-Nitrophenyl-Beta-D-Galactopyranoside\""],
       Annotation[#, "2-Nitrophenyl-Beta-D-Galactopyranoside", "Tooltip"]& ], 
      
      TagBox[
       TooltipBox[PointBox[74],
        "\"Cyclohexylacetylene\""],
       Annotation[#, "Cyclohexylacetylene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "\"Cycloheptanone\""],
       Annotation[#, "Cycloheptanone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "\"CyclohexylMethylKetone\""],
       Annotation[#, "CyclohexylMethylKetone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "\"1,4-Endoethylenecyclohexane\""],
       Annotation[#, "1,4-Endoethylenecyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "\"Bicyclo[4.2.0]octane\""],
       Annotation[#, "Bicyclo[4.2.0]octane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "\"2,3-Dimethyl-2-Norbornene\""],
       Annotation[#, "2,3-Dimethyl-2-Norbornene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "\"1,4-Cyclohexanedione\""],
       Annotation[#, "1,4-Cyclohexanedione", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "\"CyclohexanecarbonylChloride\""],
       Annotation[#, "CyclohexanecarbonylChloride", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "\"1,1-Dimethylcyclohexane\""],
       Annotation[#, "1,1-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "\"1,4-Dimethylcyclohexane\""],
       Annotation[#, "1,4-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "\"Cis-1,2-Dimethylcyclohexane\""],
       Annotation[#, "Cis-1,2-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "\"Cis-1,3-Dimethylcyclohexane\""],
       Annotation[#, "Cis-1,3-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "\"Cis-1,4-Dimethylcyclohexane\""],
       Annotation[#, "Cis-1,4-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "\"Cis-1-Ethyl-3-Methylcyclopentane\""],
       Annotation[#, "Cis-1-Ethyl-3-Methylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "\"Cyclooctane\""],
       Annotation[#, "Cyclooctane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "\"Ethylcyclohexane\""],
       Annotation[#, "Ethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "\"Trans-1,2-Dimethylcyclohexane\""],
       Annotation[#, "Trans-1,2-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "\"Trans-1,4-Dimethylcyclohexane\""],
       Annotation[#, "Trans-1,4-Dimethylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "\"Trans-1-Ethyl-2-Methylcyclopentane\""],
       Annotation[#, "Trans-1-Ethyl-2-Methylcyclopentane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "\"Cis-Cyclononene\""],
       Annotation[#, "Cis-Cyclononene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "\"Trans-Cyclononene\""],
       Annotation[#, "Trans-Cyclononene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "\"1-Isopropyl-4-Methyl-1,3-Cyclohexadiene\""],
       Annotation[#, "1-Isopropyl-4-Methyl-1,3-Cyclohexadiene", "Tooltip"]& ],
       
      TagBox[
       TooltipBox[PointBox[96],
        "\"Gamma-Terpinene\""],
       Annotation[#, "Gamma-Terpinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "\"Cyclononyne\""],
       Annotation[#, "Cyclononyne", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "\"(1R,4S)-(-)-Champhene\""],
       Annotation[#, "(1R,4S)-(-)-Champhene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "\"2,2-Dimethyl-3-Methylenenorbornane\""],
       Annotation[#, "2,2-Dimethyl-3-Methylenenorbornane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "\"2-Pinene\""],
       Annotation[#, "2-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "\"(+/-)-6,6-Dimethyl-2-Methylenebicyclo[3.1.1]heptane\""],
       Annotation[#, "(+/-)-6,6-Dimethyl-2-Methylenebicyclo[3.1.1]heptane", 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "\"(-)-Alpha-Pinene\""],
       Annotation[#, "(-)-Alpha-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "\"Alpha-Pinene\""],
       Annotation[#, "Alpha-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "\"Beta-Pinene\""],
       Annotation[#, "Beta-Pinene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "\"Camphene\""],
       Annotation[#, "Camphene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "\"DidehydroDerivativePinane\""],
       Annotation[#, "DidehydroDerivativePinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "\"Isopropylcyclohexane\""],
       Annotation[#, "Isopropylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "\"Propylcyclohexane\""],
       Annotation[#, "Propylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "\"Jasmone\""],
       Annotation[#, "Jasmone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "\"Phenylcyclohexane\""],
       Annotation[#, "Phenylcyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "\"(1R)-(+)-Cis-Pinane\""],
       Annotation[#, "(1R)-(+)-Cis-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "\"(1R)-(+)-Trans-Pinane\""],
       Annotation[#, "(1R)-(+)-Trans-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "\"(1S)-(-)-Cis-Pinane\""],
       Annotation[#, "(1S)-(-)-Cis-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "\"(1S)-(+)-Trans-Pinane\""],
       Annotation[#, "(1S)-(+)-Trans-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "\"Cis-Decahydronaphthalene\""],
       Annotation[#, "Cis-Decahydronaphthalene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "\"Cis-Pinane\""],
       Annotation[#, "Cis-Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "\"Pinane\""],
       Annotation[#, "Pinane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "\"Trans-Decahydronaphthalene\""],
       Annotation[#, "Trans-Decahydronaphthalene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "\"(+/-)-Camphor\""],
       Annotation[#, "(+/-)-Camphor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "\"D-Camphor\""],
       Annotation[#, "D-Camphor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "\"L-Camphor\""],
       Annotation[#, "L-Camphor", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "\"Beta-Ionone\""],
       Annotation[#, "Beta-Ionone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "\"5-Methyl-2-(1-Methylethyl)Cyclohexanone\""],
       Annotation[#, "5-Methyl-2-(1-Methylethyl)Cyclohexanone", "Tooltip"]& ],
       
      TagBox[
       TooltipBox[PointBox[124],
        "\"(-)-Menthone\""],
       Annotation[#, "(-)-Menthone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "\"Estradiol\""],
       Annotation[#, "Estradiol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "\"Ethinyloestradiol\""],
       Annotation[#, "Ethinyloestradiol", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "\"Digitoxigenin\""],
       Annotation[#, "Digitoxigenin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        "\"AscorbicAcid\""],
       Annotation[#, "AscorbicAcid", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        "\"GibberellicAcid\""],
       Annotation[#, "GibberellicAcid", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[130],
        "\"Artemisinin\""],
       Annotation[#, "Artemisinin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[131],
        "\"Brucine\""],
       Annotation[#, "Brucine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[132],
        "\"Dihydrocodeinone\""],
       Annotation[#, "Dihydrocodeinone", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[133],
        "\"Cocaine\""],
       Annotation[#, "Cocaine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[134],
        "\"Strychnine\""],
       Annotation[#, "Strychnine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[135],
        "\"Dextromethorphan\""],
       Annotation[#, "Dextromethorphan", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[136],
        "\"Deltamethrin\""],
       Annotation[#, "Deltamethrin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[137],
        "\"Morphine\""],
       Annotation[#, "Morphine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[138],
        "\"Heroin\""],
       Annotation[#, "Heroin", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[139],
        "\"Quinine\""],
       Annotation[#, "Quinine", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[140],
        "\"Alpha-Hexachlorocyclohexane\""],
       Annotation[#, "Alpha-Hexachlorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[141],
        "\"Beta-Hexachlorocyclohexane\""],
       Annotation[#, "Beta-Hexachlorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[142],
        "\"Delta-Hexachlorocyclohexane\""],
       Annotation[#, "Delta-Hexachlorocyclohexane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[143],
        "\"Hexachlorocyclohexane(MixedIsomers)\""],
       Annotation[#, "Hexachlorocyclohexane(MixedIsomers)", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[144],
        "\"Lindane\""],
       Annotation[#, "Lindane", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[145],
        "\"Beta-Carotene\""],
       Annotation[#, "Beta-Carotene", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[146],
        "\"Quillajasaponin\""],
       Annotation[#, "Quillajasaponin", "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9lXs01Nsbxl0qokTFMJj5jtuUmTHzTSYlfV+JECpd5dLUuNXvSHLpdIqU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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{304, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[3]=",
 CellID->1481537302]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ElementData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ElementData"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[ButtonBox["ChemicalData Source Information",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
ChemicalDataSourceInformation.html"], None}]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "MoreAbout",
 CellID->71525801],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->662131652]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChemicalData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 21.1959464}", "context" -> "System`", 
    "keywords" -> {
     "chemical compounds", "chemicals", "chemistry", "EC number", "EC-No", 
      "electron-dot diagrams", "International Chemical Identifier", 
      "Lewis structures", "molecular weight", "molecules", 
      "physical chemistry", "stereochemistry", "formula display", 
      "formula string", "Hill formula display", "Hill formula string", 
      "IUPAC name", "molecular weight", "structure diagram", "CAS", "CID", 
      "boiling point", "combustion heat", "critical pressure", 
      "critical temperature", "density", "melting point", "molar volume", 
      "physical phase", "refractive index", "surface tension", 
      "vapor density", "vaporization heat", "vapor pressure", "viscosity", 
      "solubility type", "color structure diagram", "molecule plot", 
      "structure diagram", "atom positions", "atomic bonds", 
      "bond connectivity", "atom positions", "mond matrix", "edge rules", 
      "edge types", "element tally", "element count", "element types", 
      "formal charges", "H bond acceptor point", "H bond donor count", 
      "partition coefficient", "rotatable bond count", "tautomer count", 
      "alternate names", "Beilstein number", "CAS number", "CID number", 
      "EUN", "EUN number", "Gmelin number", "IUPAC", "IUPAC name", "NSC", 
      "NSC number", "RTECS", "RTECS number", "autoignition point", 
      "DOT hazard class", "DOT numbers", "flash point", 
      "lower explosive limit", "NFPA fire rating", "NFPA hazards", 
      "NFPA health rating", "NFPA label", "NFPA reactivity rating", 
      "RTECS classes", "upper explosive limit"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ChemicalData[\"name\", \" property\"] gives the value of the specified \
property for the chemical \" name\". ChemicalData[\"name\"] gives a structure \
diagram for the chemical with the specified name. ChemicalData[\"class\"] \
gives a list of available chemicals in the specified class.", 
    "synonyms" -> {"chemical data"}, "title" -> "ChemicalData", "type" -> 
    "Symbol", "uri" -> "ref/ChemicalData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[22476, 586, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->194068024]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 387475, 9155}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1997, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2620, 78, 1577, 37, 70, "ObjectNameGrid"],
Cell[4200, 117, 1401, 41, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5638, 163, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6116, 180, 490, 13, 70, "Notes",
 CellID->1067943069],
Cell[6609, 195, 276, 9, 70, "Notes",
 CellID->49291775],
Cell[6888, 206, 286, 9, 70, "Notes",
 CellID->54231339],
Cell[7177, 217, 321, 11, 70, "Notes",
 CellID->48425469],
Cell[7501, 230, 742, 22, 70, "Notes",
 CellID->193117324],
Cell[8246, 254, 188, 4, 70, "Notes",
 CellID->286491208],
Cell[8437, 260, 68, 1, 70, "Notes",
 CellID->381198116],
Cell[8508, 263, 1319, 25, 70, "2ColumnTableMod",
 CellID->56793120],
Cell[9830, 290, 71, 1, 70, "Notes",
 CellID->987574898],
Cell[9904, 293, 2126, 42, 70, "2ColumnTableMod",
 CellID->270203023],
Cell[12033, 337, 143, 4, 70, "Notes",
 CellID->154524926],
Cell[12179, 343, 81, 1, 70, "Notes",
 CellID->1521777803],
Cell[12263, 346, 683, 13, 70, "2ColumnTableMod",
 CellID->311524290],
Cell[12949, 361, 77, 1, 70, "Notes",
 CellID->1535753758],
Cell[13029, 364, 1855, 36, 70, "2ColumnTableMod",
 CellID->807457413],
Cell[14887, 402, 81, 1, 70, "Notes",
 CellID->33828597],
Cell[14971, 405, 1027, 19, 70, "2ColumnTableMod",
 CellID->353720050],
Cell[16001, 426, 72, 1, 70, "Notes",
 CellID->1363875235],
Cell[16076, 429, 1808, 40, 70, "2ColumnTableMod",
 CellID->410626567],
Cell[17887, 471, 72, 1, 70, "Notes",
 CellID->465177886],
Cell[17962, 474, 1885, 36, 70, "2ColumnTableMod",
 CellID->675382760],
Cell[19850, 512, 482, 14, 70, "Notes",
 CellID->276644756],
Cell[20335, 528, 1673, 38, 70, "2ColumnTableMod",
 CellID->524183967],
Cell[22011, 568, 428, 13, 70, "Notes",
 CellID->556530527]
}, Closed]],
Cell[CellGroupData[{
Cell[22476, 586, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194068024],
Cell[CellGroupData[{
Cell[22861, 600, 147, 5, 70, "ExampleSection",
 CellID->80449674],
Cell[23011, 607, 84, 1, 70, "ExampleText",
 CellID->586239093],
Cell[CellGroupData[{
Cell[23120, 612, 123, 3, 28, "Input",
 CellID->551393615],
Cell[23246, 617, 2830, 50, 162, "Output",
 Evaluatable->False,
 CellID->35728135]
}, Open  ]],
Cell[26091, 670, 125, 3, 70, "ExampleDelimiter",
 CellID->361711382],
Cell[26219, 675, 73, 1, 70, "ExampleText",
 CellID->41894317],
Cell[CellGroupData[{
Cell[26317, 680, 165, 4, 70, "Input",
 CellID->973827730],
Cell[26485, 686, 21754, 364, 276, 3764, 65, "CachedBoxData", "BoxData", \
"Output",
 CellID->885239577]
}, Open  ]],
Cell[48254, 1053, 125, 3, 70, "ExampleDelimiter",
 CellID->432939377],
Cell[48382, 1058, 71, 1, 70, "ExampleText",
 CellID->86551233],
Cell[CellGroupData[{
Cell[48478, 1063, 171, 5, 70, "Input",
 CellID->107438379],
Cell[48652, 1070, 166, 5, 36, "Output",
 CellID->454864223]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48867, 1081, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[49114, 1092, 263, 8, 70, "ExampleSubsection",
 CellID->1705437741],
Cell[49380, 1102, 105, 2, 70, "ExampleText",
 CellID->182841121],
Cell[CellGroupData[{
Cell[49510, 1108, 130, 4, 70, "Input",
 CellID->59259327],
Cell[49643, 1114, 407, 12, 36, "Output",
 CellID->2008696288]
}, Open  ]],
Cell[CellGroupData[{
Cell[50087, 1131, 102, 3, 70, "Input",
 CellID->195686189],
Cell[50192, 1136, 163, 5, 36, "Output",
 CellID->1715581576]
}, Open  ]],
Cell[50370, 1144, 126, 3, 70, "ExampleDelimiter",
 CellID->1769839040],
Cell[50499, 1149, 84, 1, 70, "ExampleText",
 CellID->888750683],
Cell[CellGroupData[{
Cell[50608, 1154, 154, 5, 70, "Input",
 CellID->1966091159],
Cell[50765, 1161, 383, 11, 36, "Output",
 CellID->1664103210]
}, Open  ]],
Cell[CellGroupData[{
Cell[51185, 1177, 151, 5, 70, "Input",
 CellID->1838273438],
Cell[51339, 1184, 366, 11, 36, "Output",
 CellID->1903115589]
}, Open  ]],
Cell[51720, 1198, 124, 3, 70, "ExampleDelimiter",
 CellID->31793384],
Cell[51847, 1203, 179, 6, 70, "ExampleText",
 CellID->186712231],
Cell[CellGroupData[{
Cell[52051, 1213, 165, 4, 70, "Input",
 CellID->374014864],
Cell[52219, 1219, 178, 5, 36, "Output",
 CellID->1042265905]
}, Open  ]],
Cell[CellGroupData[{
Cell[52434, 1229, 173, 5, 70, "Input",
 CellID->1170128794],
Cell[52610, 1236, 176, 5, 36, "Output",
 CellID->338956756]
}, Open  ]],
Cell[CellGroupData[{
Cell[52823, 1246, 163, 4, 70, "Input",
 CellID->617343353],
Cell[52989, 1252, 173, 5, 36, "Output",
 CellID->1719566248]
}, Open  ]],
Cell[CellGroupData[{
Cell[53199, 1262, 165, 4, 70, "Input",
 CellID->1530244426],
Cell[53367, 1268, 175, 5, 36, "Output",
 CellID->2062492457]
}, Open  ]],
Cell[53557, 1276, 126, 3, 70, "ExampleDelimiter",
 CellID->2012114934],
Cell[53686, 1281, 156, 6, 70, "ExampleText",
 CellID->1190706429],
Cell[CellGroupData[{
Cell[53867, 1291, 191, 6, 70, "Input",
 CellID->493536268],
Cell[54061, 1299, 319, 9, 36, "Output",
 CellID->1777178572]
}, Open  ]],
Cell[54395, 1311, 74, 1, 70, "ExampleText",
 CellID->121758285],
Cell[CellGroupData[{
Cell[54494, 1316, 175, 5, 70, "Input",
 CellID->1214756028],
Cell[54672, 1323, 185, 5, 36, "Output",
 CellID->1837697128]
}, Open  ]],
Cell[54872, 1331, 124, 3, 70, "ExampleDelimiter",
 CellID->99762228],
Cell[54999, 1336, 79, 1, 70, "ExampleText",
 CellID->565259315],
Cell[CellGroupData[{
Cell[55103, 1341, 168, 5, 70, "Input",
 CellID->33052035],
Cell[55274, 1348, 186, 5, 36, "Output",
 CellID->1065819142]
}, Open  ]],
Cell[CellGroupData[{
Cell[55497, 1358, 162, 4, 70, "Input",
 CellID->1159465972],
Cell[55662, 1364, 179, 5, 36, "Output",
 CellID->1061219967]
}, Open  ]],
Cell[55856, 1372, 125, 3, 70, "ExampleDelimiter",
 CellID->917419666],
Cell[55984, 1377, 84, 1, 70, "ExampleText",
 CellID->139741002],
Cell[CellGroupData[{
Cell[56093, 1382, 181, 5, 70, "Input",
 CellID->1804029678],
Cell[56277, 1389, 326, 9, 36, "Output",
 CellID->1072297034]
}, Open  ]],
Cell[CellGroupData[{
Cell[56640, 1403, 175, 5, 70, "Input",
 CellID->1427394443],
Cell[56818, 1410, 313, 9, 36, "Output",
 CellID->413484814]
}, Open  ]],
Cell[57146, 1422, 125, 3, 70, "ExampleDelimiter",
 CellID->194874262],
Cell[57274, 1427, 63, 1, 70, "ExampleText",
 CellID->357967183],
Cell[CellGroupData[{
Cell[57362, 1432, 162, 4, 70, "Input",
 CellID->496225321],
Cell[57527, 1438, 197, 5, 36, "Output",
 CellID->182187206]
}, Open  ]],
Cell[57739, 1446, 126, 3, 70, "ExampleDelimiter",
 CellID->1736278621],
Cell[57868, 1451, 78, 1, 70, "ExampleText",
 CellID->1626987711],
Cell[CellGroupData[{
Cell[57971, 1456, 122, 3, 70, "Input",
 CellID->873181526],
Cell[58096, 1461, 686, 14, 71, "Output",
 CellID->1856174267]
}, Open  ]],
Cell[58797, 1478, 126, 3, 70, "ExampleDelimiter",
 CellID->1240203172],
Cell[58926, 1483, 91, 1, 70, "ExampleText",
 CellID->618434022],
Cell[CellGroupData[{
Cell[59042, 1488, 152, 5, 70, "Input",
 CellID->199756274],
Cell[59197, 1495, 373, 11, 36, "Output",
 CellID->225965500]
}, Open  ]],
Cell[CellGroupData[{
Cell[59607, 1511, 151, 5, 70, "Input",
 CellID->1666982761],
Cell[59761, 1518, 422, 12, 36, "Output",
 CellID->1051070604]
}, Open  ]],
Cell[60198, 1533, 125, 3, 70, "ExampleDelimiter",
 CellID->841127130],
Cell[60326, 1538, 87, 1, 70, "ExampleText",
 CellID->2086309356],
Cell[CellGroupData[{
Cell[60438, 1543, 172, 5, 70, "Input",
 CellID->547024914],
Cell[60613, 1550, 162, 5, 36, "Output",
 CellID->143161206]
}, Open  ]],
Cell[CellGroupData[{
Cell[60812, 1560, 169, 5, 70, "Input",
 CellID->1692395553],
Cell[60984, 1567, 161, 5, 36, "Output",
 CellID->928704602]
}, Open  ]],
Cell[61160, 1575, 125, 3, 70, "ExampleDelimiter",
 CellID->251256900],
Cell[61288, 1580, 72, 1, 70, "ExampleText",
 CellID->95636078],
Cell[CellGroupData[{
Cell[61385, 1585, 189, 6, 70, "Input",
 CellID->174295882],
Cell[61577, 1593, 836, 16, 105, "Output",
 CellID->827099418]
}, Open  ]],
Cell[62428, 1612, 62, 1, 70, "ExampleText",
 CellID->488358076],
Cell[CellGroupData[{
Cell[62515, 1617, 218, 7, 70, "Input",
 CellID->151684498],
Cell[62736, 1626, 389, 11, 36, "Output",
 CellID->398271295]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63174, 1643, 239, 7, 70, "ExampleSubsection",
 CellID->87181009],
Cell[63416, 1652, 83, 1, 70, "ExampleText",
 CellID->67265443],
Cell[CellGroupData[{
Cell[63524, 1657, 180, 5, 70, "Input",
 CellID->1707434259],
Cell[63707, 1664, 2737, 49, 70, "Output",
 Evaluatable->False,
 CellID->72786532]
}, Open  ]],
Cell[66459, 1716, 67, 1, 70, "ExampleText",
 CellID->494617519],
Cell[CellGroupData[{
Cell[66551, 1721, 184, 5, 70, "Input",
 CellID->127444296],
Cell[66738, 1728, 3181, 56, 70, "Output",
 Evaluatable->False,
 CellID->162021899]
}, Open  ]],
Cell[69934, 1787, 125, 3, 70, "ExampleDelimiter",
 CellID->573350563],
Cell[70062, 1792, 80, 1, 70, "ExampleText",
 CellID->342936055],
Cell[CellGroupData[{
Cell[70167, 1797, 175, 5, 70, "Input",
 CellID->938235150],
Cell[70345, 1804, 24227, 404, 303, 3357, 57, "CachedBoxData", "BoxData", \
"Output",
 CellID->385490765]
}, Open  ]],
Cell[CellGroupData[{
Cell[94609, 2213, 178, 5, 70, "Input",
 CellID->9638023],
Cell[94790, 2220, 39599, 656, 348, 5780, 97, "CachedBoxData", "BoxData", \
"Output",
 CellID->2132608003]
}, Open  ]],
Cell[134404, 2879, 125, 3, 70, "ExampleDelimiter",
 CellID->527447672],
Cell[134532, 2884, 93, 1, 70, "ExampleText",
 CellID->729150048],
Cell[CellGroupData[{
Cell[134650, 2889, 177, 5, 70, "Input",
 CellID->16692798],
Cell[134830, 2896, 13214, 221, 70, "Output",
 Evaluatable->False,
 CellID->304715400]
}, Open  ]],
Cell[148059, 3120, 72, 1, 70, "ExampleText",
 CellID->2134696175],
Cell[CellGroupData[{
Cell[148156, 3125, 168, 5, 70, "Input",
 CellID->412065042],
Cell[148327, 3132, 58573, 953, 334, 20468, 324, "CachedBoxData", "BoxData", \
"Output",
 CellID->1483986014]
}, Open  ]],
Cell[206915, 4088, 75, 1, 70, "ExampleText",
 CellID->123316091],
Cell[CellGroupData[{
Cell[207015, 4093, 163, 4, 70, "Input",
 CellID->1820430401],
Cell[207181, 4099, 170, 5, 36, "Output",
 CellID->477861040]
}, Open  ]],
Cell[207366, 4107, 64, 1, 70, "ExampleText",
 CellID->271786084],
Cell[CellGroupData[{
Cell[207455, 4112, 169, 5, 70, "Input",
 CellID->1008144807],
Cell[207627, 4119, 170, 5, 36, "Output",
 CellID->1969143147]
}, Open  ]],
Cell[207812, 4127, 125, 3, 70, "ExampleDelimiter",
 CellID->224886642],
Cell[207940, 4132, 89, 1, 70, "ExampleText",
 CellID->263879239],
Cell[CellGroupData[{
Cell[208054, 4137, 185, 5, 70, "Input",
 CellID->87615657],
Cell[208242, 4144, 255, 6, 36, "Output",
 CellID->518387712]
}, Open  ]],
Cell[208512, 4153, 65, 1, 70, "ExampleText",
 CellID->1641875272],
Cell[CellGroupData[{
Cell[208602, 4158, 194, 6, 70, "Input",
 CellID->1377846302],
Cell[208799, 4166, 379, 11, 36, "Output",
 CellID->201119705]
}, Open  ]],
Cell[209193, 4180, 125, 3, 70, "ExampleDelimiter",
 CellID->505055951],
Cell[209321, 4185, 66, 1, 70, "ExampleText",
 CellID->138694679],
Cell[CellGroupData[{
Cell[209412, 4190, 160, 4, 70, "Input",
 CellID->697195135],
Cell[209575, 4196, 214, 6, 36, "Output",
 CellID->79621557]
}, Open  ]],
Cell[209804, 4205, 125, 3, 70, "ExampleDelimiter",
 CellID->546034300],
Cell[209932, 4210, 65, 1, 70, "ExampleText",
 CellID->846910159],
Cell[CellGroupData[{
Cell[210022, 4215, 169, 5, 70, "Input",
 CellID->2019506442],
Cell[210194, 4222, 224, 6, 36, "Output",
 CellID->317196418]
}, Open  ]],
Cell[210433, 4231, 125, 3, 70, "ExampleDelimiter",
 CellID->762195920],
Cell[210561, 4236, 65, 1, 70, "ExampleText",
 CellID->486873085],
Cell[CellGroupData[{
Cell[210651, 4241, 119, 3, 70, "Input",
 CellID->160676605],
Cell[210773, 4246, 478, 11, 54, "Output",
 CellID->1065785472]
}, Open  ]],
Cell[CellGroupData[{
Cell[211288, 4262, 123, 3, 70, "Input",
 CellID->2067202840],
Cell[211414, 4267, 515, 11, 71, "Output",
 CellID->495328277]
}, Open  ]],
Cell[211944, 4281, 125, 3, 70, "ExampleDelimiter",
 CellID->237924958],
Cell[212072, 4286, 113, 3, 70, "ExampleText",
 CellID->77308514],
Cell[CellGroupData[{
Cell[212210, 4293, 170, 5, 70, "Input",
 CellID->1922241411],
Cell[212383, 4300, 259, 8, 36, "Output",
 CellID->1335735767]
}, Open  ]],
Cell[212657, 4311, 63, 1, 70, "ExampleText",
 CellID->403067174],
Cell[CellGroupData[{
Cell[212745, 4316, 170, 5, 70, "Input",
 CellID->1493124523],
Cell[212918, 4323, 455, 15, 36, "Output",
 CellID->2064473878]
}, Open  ]],
Cell[213388, 4341, 125, 3, 70, "ExampleDelimiter",
 CellID->484610202],
Cell[213516, 4346, 73, 1, 70, "ExampleText",
 CellID->1585675590],
Cell[CellGroupData[{
Cell[213614, 4351, 164, 4, 70, "Input",
 CellID->177581860],
Cell[213781, 4357, 1216, 24, 70, "Output",
 Evaluatable->False,
 CellID->137837611]
}, Open  ]],
Cell[215012, 4384, 76, 1, 70, "ExampleText",
 CellID->169113065],
Cell[CellGroupData[{
Cell[215113, 4389, 126, 3, 70, "Input",
 CellID->1162418474],
Cell[215242, 4394, 5052, 87, 70, "Output",
 Evaluatable->False,
 CellID->326407590]
}, Open  ]],
Cell[220309, 4484, 126, 3, 70, "ExampleDelimiter",
 CellID->1057590868],
Cell[220438, 4489, 83, 1, 70, "ExampleText",
 CellID->1153480671],
Cell[CellGroupData[{
Cell[220546, 4494, 163, 4, 70, "Input",
 CellID->69040111],
Cell[220712, 4500, 1335, 35, 71, "Output",
 CellID->1609366591]
}, Open  ]],
Cell[222062, 4538, 74, 1, 70, "ExampleText",
 CellID->1128289029],
Cell[CellGroupData[{
Cell[222161, 4543, 164, 4, 70, "Input",
 CellID->873107393],
Cell[222328, 4549, 865, 16, 71, "Output",
 CellID->1067760972]
}, Open  ]],
Cell[223208, 4568, 87, 1, 70, "ExampleText",
 CellID->1061068838],
Cell[CellGroupData[{
Cell[223320, 4573, 168, 5, 70, "Input",
 CellID->679755578],
Cell[223491, 4580, 675, 15, 70, "Output",
 Evaluatable->False,
 CellID->857313737]
}, Open  ]],
Cell[224181, 4598, 75, 1, 70, "ExampleText",
 CellID->748011948],
Cell[CellGroupData[{
Cell[224281, 4603, 171, 5, 70, "Input",
 CellID->467540498],
Cell[224455, 4610, 486, 11, 36, "Output",
 CellID->1122011376]
}, Open  ]],
Cell[224956, 4624, 126, 3, 70, "ExampleDelimiter",
 CellID->2092238428],
Cell[225085, 4629, 69, 1, 70, "ExampleText",
 CellID->187379067],
Cell[CellGroupData[{
Cell[225179, 4634, 197, 6, 70, "Input",
 CellID->1068952567],
Cell[225379, 4642, 483, 17, 36, "Output",
 CellID->591292125]
}, Open  ]],
Cell[CellGroupData[{
Cell[225899, 4664, 108, 3, 70, "Input",
 CellID->1716360935],
Cell[226010, 4669, 1331, 26, 70, "Output",
 Evaluatable->False,
 CellID->269023980]
}, Open  ]],
Cell[227356, 4698, 76, 1, 70, "ExampleText",
 CellID->630594576],
Cell[CellGroupData[{
Cell[227457, 4703, 163, 4, 70, "Input",
 CellID->571240887],
Cell[227623, 4709, 568, 13, 70, "Output",
 Evaluatable->False,
 CellID->55583407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[228240, 4728, 248, 7, 70, "ExampleSubsection",
 CellID->1415856565],
Cell[228491, 4737, 93, 1, 70, "ExampleText",
 CellID->69743622],
Cell[CellGroupData[{
Cell[228609, 4742, 168, 5, 70, "Input",
 CellID->20957920],
Cell[228780, 4749, 2393, 41, 258, "Output",
 CellID->669999470]
}, Open  ]],
Cell[231188, 4793, 125, 3, 70, "ExampleDelimiter",
 CellID->394706798],
Cell[231316, 4798, 89, 1, 70, "ExampleText",
 CellID->145809335],
Cell[CellGroupData[{
Cell[231430, 4803, 198, 6, 70, "Input",
 CellID->44910077],
Cell[231631, 4811, 179, 5, 36, "Output",
 CellID->1328520561]
}, Open  ]],
Cell[231825, 4819, 75, 1, 70, "ExampleText",
 CellID->29023189],
Cell[CellGroupData[{
Cell[231925, 4824, 202, 6, 70, "Input",
 CellID->17124444],
Cell[232130, 4832, 197, 5, 36, "Output",
 CellID->822264523]
}, Open  ]],
Cell[232342, 4840, 61, 1, 70, "ExampleText",
 CellID->224887026],
Cell[CellGroupData[{
Cell[232428, 4845, 163, 4, 70, "Input",
 CellID->29562881],
Cell[232594, 4851, 178, 5, 36, "Output",
 CellID->742569616]
}, Open  ]],
Cell[232787, 4859, 125, 3, 70, "ExampleDelimiter",
 CellID->332284946],
Cell[232915, 4864, 93, 1, 70, "ExampleText",
 CellID->471574122],
Cell[CellGroupData[{
Cell[233033, 4869, 192, 6, 70, "Input",
 CellID->560816081],
Cell[233228, 4877, 180, 5, 36, "Output",
 CellID->100173262]
}, Open  ]],
Cell[CellGroupData[{
Cell[233445, 4887, 165, 4, 70, "Input",
 CellID->1229972329],
Cell[233613, 4893, 180, 5, 36, "Output",
 CellID->2132318833]
}, Open  ]],
Cell[233808, 4901, 76, 1, 70, "ExampleText",
 CellID->462577197],
Cell[CellGroupData[{
Cell[233909, 4906, 197, 6, 70, "Input",
 CellID->1250211495],
Cell[234109, 4914, 181, 5, 36, "Output",
 CellID->675525095]
}, Open  ]],
Cell[234305, 4922, 65, 1, 70, "ExampleText",
 CellID->709789288],
Cell[CellGroupData[{
Cell[234395, 4927, 201, 6, 70, "Input",
 CellID->826445282],
Cell[234599, 4935, 176, 5, 36, "Output",
 CellID->1951713623]
}, Open  ]],
Cell[234790, 4943, 125, 3, 70, "ExampleDelimiter",
 CellID->172207452],
Cell[234918, 4948, 216, 8, 70, "ExampleText",
 CellID->488422106],
Cell[CellGroupData[{
Cell[235159, 4960, 172, 5, 70, "Input",
 CellID->493396966],
Cell[235334, 4967, 179, 5, 36, "Output",
 CellID->947210276]
}, Open  ]],
Cell[CellGroupData[{
Cell[235550, 4977, 201, 6, 70, "Input",
 CellID->431132459],
Cell[235754, 4985, 287, 9, 36, "Output",
 CellID->466833521]
}, Open  ]],
Cell[236056, 4997, 125, 3, 70, "ExampleDelimiter",
 CellID->227754128],
Cell[236184, 5002, 81, 1, 70, "ExampleText",
 CellID->60667100],
Cell[CellGroupData[{
Cell[236290, 5007, 182, 5, 70, "Input",
 CellID->502847698],
Cell[236475, 5014, 182, 5, 36, "Output",
 CellID->1340063395]
}, Open  ]],
Cell[CellGroupData[{
Cell[236694, 5024, 207, 6, 70, "Input",
 CellID->417695890],
Cell[236904, 5032, 222, 6, 36, "Output",
 CellID->1784473676]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[237175, 5044, 236, 7, 70, "ExampleSubsection",
 CellID->225821302],
Cell[237414, 5053, 158, 6, 70, "ExampleText",
 CellID->553589695],
Cell[CellGroupData[{
Cell[237597, 5063, 163, 4, 70, "Input",
 CellID->529027222],
Cell[237763, 5069, 182, 5, 36, "Output",
 CellID->1335758153]
}, Open  ]],
Cell[CellGroupData[{
Cell[237982, 5079, 168, 5, 70, "Input",
 CellID->609521478],
Cell[238153, 5086, 171, 5, 36, "Output",
 CellID->293231733]
}, Open  ]],
Cell[CellGroupData[{
Cell[238361, 5096, 174, 5, 70, "Input",
 CellID->414708089],
Cell[238538, 5103, 1761, 43, 193, "Output",
 CellID->2018250313]
}, Open  ]],
Cell[240314, 5149, 125, 3, 70, "ExampleDelimiter",
 CellID->107469361],
Cell[240442, 5154, 247, 8, 70, "ExampleText",
 CellID->5758993],
Cell[CellGroupData[{
Cell[240714, 5166, 164, 4, 70, "Input",
 CellID->607479222],
Cell[240881, 5172, 197, 6, 36, "Output",
 CellID->1228806226]
}, Open  ]],
Cell[CellGroupData[{
Cell[241115, 5183, 105, 3, 70, "Input",
 CellID->388541687],
Cell[241223, 5188, 176, 5, 36, "Output",
 CellID->196007183]
}, Open  ]],
Cell[241414, 5196, 125, 3, 70, "ExampleDelimiter",
 CellID->490922267],
Cell[241542, 5201, 297, 10, 70, "ExampleText",
 CellID->187464565],
Cell[CellGroupData[{
Cell[241864, 5215, 172, 5, 70, "Input",
 CellID->178393597],
Cell[242039, 5222, 210, 6, 36, "Output",
 CellID->52810183]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[242310, 5235, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[242557, 5244, 98, 1, 70, "ExampleText",
 CellID->852661407],
Cell[CellGroupData[{
Cell[242680, 5249, 302, 10, 70, "Input",
 CellID->521891018],
Cell[242985, 5261, 244, 8, 36, "Output",
 CellID->548388396]
}, Open  ]],
Cell[243244, 5272, 126, 3, 70, "ExampleDelimiter",
 CellID->1911442295],
Cell[243373, 5277, 97, 1, 70, "ExampleText",
 CellID->1193998041],
Cell[CellGroupData[{
Cell[243495, 5282, 212, 7, 70, "Input",
 CellID->1009410715],
Cell[243710, 5291, 176, 5, 36, "Output",
 CellID->1424331069]
}, Open  ]],
Cell[CellGroupData[{
Cell[243923, 5301, 228, 7, 70, "Input",
 CellID->1673130191],
Cell[244154, 5310, 174, 5, 36, "Output",
 CellID->732063574]
}, Open  ]],
Cell[244343, 5318, 124, 3, 70, "ExampleDelimiter",
 CellID->96191124],
Cell[244470, 5323, 113, 3, 70, "ExampleText",
 CellID->1776518524],
Cell[CellGroupData[{
Cell[244608, 5330, 131, 3, 70, "Input",
 CellID->1481688627],
Cell[244742, 5335, 969, 18, 122, "Output",
 CellID->858674555]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[245760, 5359, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[245990, 5368, 86, 1, 70, "ExampleText",
 CellID->107588731],
Cell[CellGroupData[{
Cell[246101, 5373, 1146, 34, 70, "Input",
 CellID->1689806558],
Cell[247250, 5409, 4006, 70, 70, "Output",
 Evaluatable->False,
 CellID->349339333]
}, Open  ]],
Cell[251271, 5482, 79, 1, 70, "ExampleText",
 CellID->1513697018],
Cell[CellGroupData[{
Cell[251375, 5487, 1156, 34, 70, "Input",
 CellID->977521728],
Cell[252534, 5523, 4246, 74, 70, "Output",
 Evaluatable->False,
 CellID->346408877]
}, Open  ]],
Cell[256795, 5600, 124, 3, 70, "ExampleDelimiter",
 CellID->62571143],
Cell[256922, 5605, 88, 1, 70, "ExampleText",
 CellID->1138191383],
Cell[CellGroupData[{
Cell[257035, 5610, 564, 17, 70, "Input",
 CellID->232773034],
Cell[257602, 5629, 10878, 182, 70, "Output",
 Evaluatable->False,
 CellID->74805734]
}, Open  ]],
Cell[268495, 5814, 123, 3, 70, "ExampleDelimiter",
 CellID->7368848],
Cell[268621, 5819, 137, 4, 70, "ExampleText",
 CellID->1441660457],
Cell[CellGroupData[{
Cell[268783, 5827, 966, 29, 70, "Input",
 CellID->754057190],
Cell[269752, 5858, 2471, 51, 70, "Output",
 CellID->1081201660]
}, Open  ]],
Cell[272238, 5912, 126, 3, 70, "ExampleDelimiter",
 CellID->1285838666],
Cell[272367, 5917, 88, 1, 70, "ExampleText",
 CellID->1361472130],
Cell[272458, 5920, 101, 3, 70, "Input",
 CellID->967035319],
Cell[272562, 5925, 281, 9, 70, "Input",
 CellID->806365937],
Cell[272846, 5936, 566, 19, 70, "Input",
 CellID->1970490589],
Cell[CellGroupData[{
Cell[273437, 5959, 868, 27, 70, "Input",
 CellID->1690008936],
Cell[274308, 5988, 3254, 57, 70, "Output",
 Evaluatable->False,
 CellID->815201497]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[277611, 6051, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[277852, 6060, 235, 8, 70, "ExampleText",
 CellID->214644472],
Cell[CellGroupData[{
Cell[278112, 6072, 315, 10, 70, "Input",
 CellID->1117571144],
Cell[278430, 6084, 955, 22, 54, "Output",
 CellID->1897162353]
}, Open  ]],
Cell[279400, 6109, 194, 8, 70, "ExampleText",
 CellID->215160751],
Cell[CellGroupData[{
Cell[279619, 6121, 246, 7, 70, "Input",
 CellID->540657586],
Cell[279868, 6130, 955, 22, 54, "Output",
 CellID->1917959862]
}, Open  ]],
Cell[280838, 6155, 125, 3, 70, "ExampleDelimiter",
 CellID->183120514],
Cell[280966, 6160, 103, 2, 70, "ExampleText",
 CellID->316513968],
Cell[281072, 6164, 633, 20, 70, "Input",
 CellID->1804925199],
Cell[281708, 6186, 340, 13, 70, "ExampleText",
 CellID->613113541],
Cell[CellGroupData[{
Cell[282073, 6203, 874, 27, 70, "Input",
 CellID->23822071],
Cell[282950, 6232, 3149, 73, 248, "Output",
 CellID->1414772115]
}, Open  ]],
Cell[286114, 6308, 125, 3, 70, "ExampleDelimiter",
 CellID->135815337],
Cell[286242, 6313, 224, 8, 70, "ExampleText",
 CellID->146537355],
Cell[CellGroupData[{
Cell[286491, 6325, 685, 21, 70, "Input",
 CellID->1805150387],
Cell[287179, 6348, 1325, 26, 70, "Output",
 Evaluatable->False,
 CellID->118781045]
}, Open  ]],
Cell[288519, 6377, 348, 13, 70, "ExampleText",
 CellID->75974750],
Cell[CellGroupData[{
Cell[288892, 6394, 716, 22, 70, "Input",
 CellID->424408147],
Cell[289611, 6418, 1325, 26, 70, "Output",
 Evaluatable->False,
 CellID->558912940]
}, Open  ]],
Cell[290951, 6447, 123, 3, 70, "ExampleDelimiter",
 CellID->5874536],
Cell[291077, 6452, 221, 8, 70, "ExampleText",
 CellID->535512214],
Cell[291301, 6462, 543, 17, 70, "Input",
 CellID->1403006388],
Cell[CellGroupData[{
Cell[291869, 6483, 273, 8, 70, "Input",
 CellID->1864310337],
Cell[292145, 6493, 6263, 107, 70, "Output",
 Evaluatable->False,
 CellID->699144628]
}, Open  ]],
Cell[298423, 6603, 229, 7, 70, "ExampleText",
 CellID->94821444],
Cell[CellGroupData[{
Cell[298677, 6614, 218, 8, 70, "Input",
 CellID->957919056],
Cell[298898, 6624, 161, 5, 36, "Output",
 CellID->311740141]
}, Open  ]],
Cell[299074, 6632, 123, 3, 70, "ExampleDelimiter",
 CellID->4200064],
Cell[299200, 6637, 217, 8, 70, "ExampleText",
 CellID->671567693],
Cell[299420, 6647, 726, 22, 70, "Input",
 CellID->68752822],
Cell[CellGroupData[{
Cell[300171, 6673, 269, 8, 70, "Input",
 CellID->1598254698],
Cell[300443, 6683, 14890, 467, 70, "Output",
 CellID->1703934754]
}, Open  ]],
Cell[315348, 7153, 126, 3, 70, "ExampleDelimiter",
 CellID->1647648724],
Cell[315477, 7158, 247, 8, 70, "ExampleText",
 CellID->230476203],
Cell[CellGroupData[{
Cell[315749, 7170, 125, 3, 70, "Input",
 CellID->1700528280],
Cell[315877, 7175, 3062, 51, 360, "Output",
 CellID->1336977733]
}, Open  ]],
Cell[CellGroupData[{
Cell[318976, 7231, 165, 4, 70, "Input",
 CellID->1883059209],
Cell[319144, 7237, 181, 5, 36, "Output",
 CellID->1463359970]
}, Open  ]],
Cell[CellGroupData[{
Cell[319362, 7247, 164, 4, 70, "Input",
 CellID->451524384],
Cell[319529, 7253, 397, 11, 70, "Output",
 Evaluatable->False,
 CellID->54471681]
}, Open  ]],
Cell[319941, 7267, 126, 3, 70, "ExampleDelimiter",
 CellID->1640818470],
Cell[320070, 7272, 250, 8, 70, "ExampleText",
 CellID->1398514163],
Cell[CellGroupData[{
Cell[320345, 7284, 124, 3, 70, "Input",
 CellID->619021126],
Cell[320472, 7289, 1189, 22, 122, "Output",
 CellID->1329644903]
}, Open  ]],
Cell[CellGroupData[{
Cell[321698, 7316, 172, 5, 70, "Input",
 CellID->647099227],
Cell[321873, 7323, 184, 5, 36, "Output",
 CellID->627054039]
}, Open  ]],
Cell[CellGroupData[{
Cell[322094, 7333, 161, 4, 70, "Input",
 CellID->1563222531],
Cell[322258, 7339, 184, 5, 36, "Output",
 CellID->1194977644]
}, Open  ]],
Cell[322457, 7347, 126, 3, 70, "ExampleDelimiter",
 CellID->1733355203],
Cell[322586, 7352, 219, 8, 70, "ExampleText",
 CellID->1007317824],
Cell[CellGroupData[{
Cell[322830, 7364, 151, 5, 70, "Input",
 CellID->1377078667],
Cell[322984, 7371, 388, 11, 36, "Output",
 CellID->722195964]
}, Open  ]],
Cell[CellGroupData[{
Cell[323409, 7387, 153, 5, 70, "Input",
 CellID->105977099],
Cell[323565, 7394, 429, 12, 36, "Output",
 CellID->369994104]
}, Open  ]],
Cell[CellGroupData[{
Cell[324031, 7411, 165, 5, 70, "Input",
 CellID->1996765934],
Cell[324199, 7418, 1248, 42, 70, "Output",
 CellID->1525747863]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[325496, 7466, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[325730, 7475, 114, 3, 70, "ExampleText",
 CellID->1329051991],
Cell[CellGroupData[{
Cell[325869, 7482, 176, 5, 70, "Input",
 CellID->46500988],
Cell[326048, 7489, 311, 6, 70, "Message",
 CellID->142104614],
Cell[326362, 7497, 266, 8, 36, "Output",
 CellID->350432034]
}, Open  ]],
Cell[CellGroupData[{
Cell[326665, 7510, 182, 5, 70, "Input",
 CellID->222925477],
Cell[326850, 7517, 318, 7, 70, "Message",
 CellID->1311035364],
Cell[327171, 7526, 267, 8, 36, "Output",
 CellID->1389144528]
}, Open  ]],
Cell[327453, 7537, 96, 1, 70, "ExampleText",
 CellID->173046581],
Cell[CellGroupData[{
Cell[327574, 7542, 403, 13, 70, "Input",
 CellID->135247669],
Cell[327980, 7557, 205, 6, 36, "Output",
 CellID->2057355559]
}, Open  ]],
Cell[CellGroupData[{
Cell[328222, 7568, 434, 13, 70, "Input",
 CellID->57009403],
Cell[328659, 7583, 201, 6, 36, "Output",
 CellID->1340679766]
}, Open  ]],
Cell[CellGroupData[{
Cell[328897, 7594, 177, 5, 70, "Input",
 CellID->1260968962],
Cell[329077, 7601, 197, 6, 36, "Output",
 CellID->1406402838]
}, Open  ]],
Cell[329289, 7610, 124, 3, 70, "ExampleDelimiter",
 CellID->90344104],
Cell[329416, 7615, 237, 8, 70, "ExampleText",
 CellID->46301994],
Cell[CellGroupData[{
Cell[329678, 7627, 346, 11, 70, "Input",
 CellID->1739347100],
Cell[330027, 7640, 679, 17, 58, "Output",
 CellID->59995737]
}, Open  ]],
Cell[330721, 7660, 229, 8, 70, "ExampleText",
 CellID->85509328],
Cell[CellGroupData[{
Cell[330975, 7672, 401, 12, 70, "Input",
 CellID->548645387],
Cell[331379, 7686, 449, 11, 36, "Output",
 CellID->1178521316]
}, Open  ]],
Cell[CellGroupData[{
Cell[331865, 7702, 92, 3, 70, "Input",
 CellID->60605648],
Cell[331960, 7707, 497, 12, 39, "Output",
 CellID->1166081731]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[332506, 7725, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[332737, 7734, 149, 4, 70, "ExampleText",
 CellID->1086410556],
Cell[332889, 7740, 262, 8, 70, "Input",
 CellID->550905309],
Cell[CellGroupData[{
Cell[333176, 7752, 837, 27, 70, "Input",
 CellID->792346524],
Cell[334016, 7781, 18416, 451, 70, "Output",
 CellID->399890395]
}, Open  ]],
Cell[352447, 8235, 88, 1, 70, "ExampleText",
 CellID->1196437502],
Cell[CellGroupData[{
Cell[352560, 8240, 990, 31, 70, "Input",
 CellID->1263526146],
Cell[353553, 8273, 28530, 732, 70, "Output",
 CellID->1481537302]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[382144, 9012, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[382463, 9023, 206, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[382706, 9034, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[383027, 9045, 299, 9, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[383363, 9059, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[383692, 9070, 238, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[383967, 9080, 299, 8, 70, "MoreAboutSection"],
Cell[384269, 9090, 149, 3, 70, "MoreAbout",
 CellID->71525801],
Cell[384421, 9095, 185, 3, 70, "MoreAbout",
 CellID->662131652]
}, Open  ]],
Cell[384621, 9101, 27, 0, 70, "History"],
Cell[384651, 9103, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

