(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34894,       1330]
NotebookOptionsPosition[     27015,       1053]
NotebookOutlinePosition[     28335,       1090]
CellTagsIndexPosition[     28249,       1085]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "GCD" :> 
          Documentation`HelpLookup["paclet:ref/GCD"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Reduce\"\>", 2->"\<\"FindInstance\"\>", 
       3->"\<\"GCD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Diophantine Equations\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ChineseRemainder", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ChineseRemainder",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ChineseRemainder"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the smallest positive ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " that satisfies all the integer congruences ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " mod ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " = ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " mod ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If no solution for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " exists, ",
 Cell[BoxData[
  ButtonBox["ChineseRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChineseRemainder"]], "InlineFormula"],
 " returns unevaluated."
}], "Notes",
 CellID->494204128],

Cell[TextData[{
 "If all ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["i", "TI"]], "<", 
   SubscriptBox[
    StyleBox["m", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 ", then the result satisfies ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " mod ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " = ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9763]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1007932894],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->125340440],

Cell[TextData[{
 "The smallest positive integer ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " that satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", " ", "mod", " ", "4"}], "=", "3"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", " ", "mod", " ", "5"}], "=", "4"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->32965516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378820495],

Cell[BoxData["19"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128656062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171886816],

Cell[TextData[{
 "Find the smallest positive integer giving remainder ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", ",", "5", ",", "7"}], TraditionalForm]], "InlineMath"],
 " when divided by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", ",", "3", ",", "5"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->115781007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1576662597],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1953885152]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Database encryption and decryption:", "ExampleText",
 CellID->1855866361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", " ", "=", 
  RowBox[{"{", 
   RowBox[{
   "931074546", ",", "117172357", ",", "482333642", ",", "199386034", ",", 
    "394354985"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297662520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "931074546", ",", "117172357", ",", "482333642", ",", "199386034", ",", 
   "394354985"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1775303387]
}, Open  ]],

Cell["Key generation:", "ExampleText",
 CellID->55837962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"keys", " ", "=", " ", 
  RowBox[{"RandomPrime", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "9"}], ",", " ", 
      RowBox[{"10", "^", "12"}]}], "}"}], ",", " ", "5"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1400237393],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "845561638189", ",", "470080286183", ",", "694627438217", ",", 
   "171542057711", ",", "495487155157"}], "}"}]], "Output",
 ImageSize->{515, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->386233891]
}, Open  ]],

Cell["Encrypted data:", "ExampleText",
 CellID->377203505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"encrypted", " ", "=", " ", 
  RowBox[{"ChineseRemainder", "[", 
   RowBox[{"data", ",", " ", "keys"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->953234966],

Cell[BoxData["13602008091437373614601568183872741788693826402988604732766"], \
"Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1737424803]
}, Open  ]],

Cell["Decryption:", "ExampleText",
 CellID->348552149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"encrypted", ",", "keys"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1920507538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "931074546", ",", "117172357", ",", "482333642", ",", "199386034", ",", 
   "394354985"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1563515762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35267165],

Cell["Define a residue number system:", "ExampleText",
 CellID->110681909],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Prime", "[", "100", "]"}], ",", 
     RowBox[{"Prime", "[", "101", "]"}], ",", 
     RowBox[{"Prime", "[", "102", "]"}], ",", " ", 
     RowBox[{"Prime", "[", "103", "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416336319],

Cell["Numbers and their representation in a residue system:", "ExampleText",
 CellID->85371402],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n1", "=", "123456787"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n2", "=", "123"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->86876444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n1r", "=", 
  RowBox[{"Mod", "[", 
   RowBox[{"n1", ",", "m"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->75807375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"46", ",", "528", ",", "522", ",", "458"}], "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1399507242]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n2r", "=", 
  RowBox[{"Mod", "[", 
   RowBox[{"n2", ",", "m"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8580111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"123", ",", "123", ",", "123", ",", "123"}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->129830703]
}, Open  ]],

Cell["Multiplying and recovering in the residue system:", "ExampleText",
 CellID->582439884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"n1r", " ", "n2r"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74591197],

Cell[BoxData["15185184801"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->221239969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n1", " ", "n2"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->453562600],

Cell[BoxData["15185184801"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1085966026]
}, Open  ]],

Cell["Adding and recovering:", "ExampleText",
 CellID->130921836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"n1r", "+", "n2r"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->122057532],

Cell[BoxData["123456910"], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->367483129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n1", "+", "n2"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->528754668],

Cell[BoxData["123456910"], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->125980331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324885446],

Cell["Modular computation of a determinant:", "ExampleText",
 CellID->633361373],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "15"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->990752637],

Cell["Modular determinants:", "ExampleText",
 CellID->8435738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{"Det", "[", 
   RowBox[{"a", ",", 
    RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146400330],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2080030822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2", "=", 
  RowBox[{"Det", "[", 
   RowBox[{"a", ",", 
    RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->264321756],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->191735841]
}, Open  ]],

Cell["Recover result: ", "ExampleText",
 CellID->300558006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d1", ",", "d2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->49695079],

Cell[BoxData["33"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1278809187]
}, Open  ]],

Cell["Shift residue to be symmetric:", "ExampleText",
 CellID->75507059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"33", ",", 
   RowBox[{"5", " ", "7"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", "7"}], "+", "1"}], ")"}], "/", "2"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->481160300],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->929666733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "a", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->100114939],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1965249606]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Solve congruential equations using ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23263815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"x", ",", "3"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"x", ",", "5"}], "]"}], "\[Equal]", "2"}]}], "}"}], ",", "x", 
   ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329193653],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"7", "+", 
    RowBox[{"15", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}]}]], "Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1651637182]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"x", ",", "3"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"x", ",", "5"}], "]"}], "\[Equal]", "2"}]}], "}"}], ",", "x", 
   ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20273703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "7"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->692496752]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36744588],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1579027771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Not all congruential equations have a solution:", "ExampleText",
 CellID->466321028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "3"}], ",", 
     RowBox[{"2", " ", "5"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157456829],

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "10"}], "}"}]}], "]"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116837571]
}, Open  ]],

Cell[TextData[{
 "A solution exists when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Mod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mod"], "[", 
    RowBox[{
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["i", "TI"]], ",", 
     RowBox[{
      ButtonBox["GCD",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GCD"], "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "]"}]}], "]"}], "==", 
   RowBox[{
    ButtonBox["Mod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mod"], "[", 
    RowBox[{
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["j", "TI"]], ",", 
     RowBox[{
      ButtonBox["GCD",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GCD"], "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "]"}]}], "]"}]}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->748189390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mod", "[", 
   RowBox[{"1", ",", 
    RowBox[{"GCD", "[", 
     RowBox[{
      RowBox[{"2", " ", "3"}], ",", 
      RowBox[{"2", " ", "5"}]}], "]"}]}], "]"}], "\[Equal]", 
  RowBox[{"Mod", "[", 
   RowBox[{"2", ",", 
    RowBox[{"GCD", "[", 
     RowBox[{
      RowBox[{"2", " ", "3"}], ",", 
      RowBox[{"2", " ", "5"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81175428],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->889002439]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->67048278],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->113286811],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->590321879],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->524310375],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->679278952],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->637102508]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChineseRemainder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 25.9929442}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ChineseRemainder[{r_1, r_2, ...}, {m_1, m_2, ...}] gives the smallest \
positive x that satisfies all the integer congruences x mod m_i = r_i mod \
m_i.", "synonyms" -> {"Chinese remainder"}, "title" -> "ChineseRemainder", 
    "type" -> "Symbol", "uri" -> "ref/ChineseRemainder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7991, 248, 361, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1007932894]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28105, 1078}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2740, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3363, 90, 1581, 37, 70, "ObjectNameGrid"],
Cell[4947, 129, 1627, 54, 70, "Usage",
 CellID->5688]
}, Open  ]],
Cell[CellGroupData[{
Cell[6611, 188, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7089, 205, 303, 11, 70, "Notes",
 CellID->494204128],
Cell[7395, 218, 559, 25, 70, "Notes",
 CellID->9763]
}, Closed]],
Cell[CellGroupData[{
Cell[7991, 248, 361, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1007932894],
Cell[CellGroupData[{
Cell[8377, 262, 148, 5, 70, "ExampleSection",
 CellID->125340440],
Cell[8528, 269, 437, 18, 70, "ExampleText",
 CellID->32965516],
Cell[CellGroupData[{
Cell[8990, 291, 233, 8, 28, "Input",
 CellID->378820495],
Cell[9226, 301, 159, 5, 36, "Output",
 CellID->128656062]
}, Open  ]],
Cell[9400, 309, 125, 3, 70, "ExampleDelimiter",
 CellID->171886816],
Cell[9528, 314, 334, 11, 70, "ExampleText",
 CellID->115781007],
Cell[CellGroupData[{
Cell[9887, 329, 254, 8, 70, "Input",
 CellID->1576662597],
Cell[10144, 339, 160, 5, 36, "Output",
 CellID->1953885152]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10353, 350, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[10583, 359, 79, 1, 70, "ExampleText",
 CellID->1855866361],
Cell[CellGroupData[{
Cell[10687, 364, 226, 7, 70, "Input",
 CellID->297662520],
Cell[10916, 373, 282, 9, 36, "Output",
 CellID->1775303387]
}, Open  ]],
Cell[11213, 385, 57, 1, 70, "ExampleText",
 CellID->55837962],
Cell[CellGroupData[{
Cell[11295, 390, 286, 9, 70, "Input",
 CellID->1400237393],
Cell[11584, 401, 296, 9, 36, "Output",
 CellID->386233891]
}, Open  ]],
Cell[11895, 413, 58, 1, 70, "ExampleText",
 CellID->377203505],
Cell[CellGroupData[{
Cell[11978, 418, 188, 5, 70, "Input",
 CellID->953234966],
Cell[12169, 425, 220, 6, 36, "Output",
 CellID->1737424803]
}, Open  ]],
Cell[12404, 434, 54, 1, 70, "ExampleText",
 CellID->348552149],
Cell[CellGroupData[{
Cell[12483, 439, 134, 4, 70, "Input",
 CellID->1920507538],
Cell[12620, 445, 282, 9, 36, "Output",
 CellID->1563515762]
}, Open  ]],
Cell[12917, 457, 124, 3, 70, "ExampleDelimiter",
 CellID->35267165],
Cell[13044, 462, 74, 1, 70, "ExampleText",
 CellID->110681909],
Cell[13121, 465, 332, 10, 70, "Input",
 CellID->416336319],
Cell[13456, 477, 95, 1, 70, "ExampleText",
 CellID->85371402],
Cell[13554, 480, 191, 6, 70, "Input",
 CellID->86876444],
Cell[CellGroupData[{
Cell[13770, 490, 148, 5, 70, "Input",
 CellID->75807375],
Cell[13921, 497, 232, 7, 36, "Output",
 CellID->1399507242]
}, Open  ]],
Cell[CellGroupData[{
Cell[14190, 509, 147, 5, 70, "Input",
 CellID->8580111],
Cell[14340, 516, 232, 7, 36, "Output",
 CellID->129830703]
}, Open  ]],
Cell[14587, 526, 92, 1, 70, "ExampleText",
 CellID->582439884],
Cell[CellGroupData[{
Cell[14704, 531, 162, 5, 70, "Input",
 CellID->74591197],
Cell[14869, 538, 168, 5, 36, "Output",
 CellID->221239969]
}, Open  ]],
Cell[CellGroupData[{
Cell[15074, 548, 94, 3, 70, "Input",
 CellID->453562600],
Cell[15171, 553, 169, 5, 36, "Output",
 CellID->1085966026]
}, Open  ]],
Cell[15355, 561, 65, 1, 70, "ExampleText",
 CellID->130921836],
Cell[CellGroupData[{
Cell[15445, 566, 163, 5, 70, "Input",
 CellID->122057532],
Cell[15611, 573, 166, 5, 36, "Output",
 CellID->367483129]
}, Open  ]],
Cell[CellGroupData[{
Cell[15814, 583, 94, 3, 70, "Input",
 CellID->528754668],
Cell[15911, 588, 166, 5, 36, "Output",
 CellID->125980331]
}, Open  ]],
Cell[16092, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->324885446],
Cell[16220, 601, 80, 1, 70, "ExampleText",
 CellID->633361373],
Cell[16303, 604, 269, 10, 70, "Input",
 CellID->990752637],
Cell[16575, 616, 62, 1, 70, "ExampleText",
 CellID->8435738],
Cell[CellGroupData[{
Cell[16662, 621, 184, 6, 70, "Input",
 CellID->146400330],
Cell[16849, 629, 159, 5, 36, "Output",
 CellID->2080030822]
}, Open  ]],
Cell[CellGroupData[{
Cell[17045, 639, 184, 6, 70, "Input",
 CellID->264321756],
Cell[17232, 647, 158, 5, 36, "Output",
 CellID->191735841]
}, Open  ]],
Cell[17405, 655, 59, 1, 70, "ExampleText",
 CellID->300558006],
Cell[CellGroupData[{
Cell[17489, 660, 234, 8, 70, "Input",
 CellID->49695079],
Cell[17726, 670, 160, 5, 36, "Output",
 CellID->1278809187]
}, Open  ]],
Cell[17901, 678, 72, 1, 70, "ExampleText",
 CellID->75507059],
Cell[CellGroupData[{
Cell[17998, 683, 285, 11, 70, "Input",
 CellID->481160300],
Cell[18286, 696, 175, 6, 36, "Output",
 CellID->929666733]
}, Open  ]],
Cell[CellGroupData[{
Cell[18498, 707, 99, 3, 70, "Input",
 CellID->100114939],
Cell[18600, 712, 176, 6, 36, "Output",
 CellID->1965249606]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18825, 724, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[19066, 733, 349, 13, 70, "ExampleText",
 CellID->23263815],
Cell[CellGroupData[{
Cell[19440, 750, 385, 13, 70, "Input",
 CellID->329193653],
Cell[19828, 765, 362, 12, 36, "Output",
 CellID->1651637182]
}, Open  ]],
Cell[CellGroupData[{
Cell[20227, 782, 390, 13, 70, "Input",
 CellID->20273703],
Cell[20620, 797, 233, 8, 36, "Output",
 CellID->692496752]
}, Open  ]],
Cell[CellGroupData[{
Cell[20890, 810, 232, 8, 70, "Input",
 CellID->36744588],
Cell[21125, 820, 159, 5, 36, "Output",
 CellID->1579027771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21333, 831, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[21567, 840, 90, 1, 70, "ExampleText",
 CellID->466321028],
Cell[CellGroupData[{
Cell[21682, 845, 285, 10, 70, "Input",
 CellID->157456829],
Cell[21970, 857, 323, 11, 36, "Output",
 CellID->116837571]
}, Open  ]],
Cell[22308, 871, 1186, 45, 70, "ExampleText",
 CellID->748189390],
Cell[CellGroupData[{
Cell[23519, 920, 430, 15, 70, "Input",
 CellID->81175428],
Cell[23952, 937, 162, 5, 36, "Output",
 CellID->889002439]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24175, 949, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[24494, 960, 694, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[25225, 991, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[25546, 1002, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[25781, 1011, 318, 9, 70, "MoreAboutSection",
 CellID->67048278],
Cell[26102, 1022, 153, 3, 70, "MoreAbout",
 CellID->113286811],
Cell[26258, 1027, 162, 3, 70, "MoreAbout",
 CellID->590321879],
Cell[26423, 1032, 137, 3, 70, "MoreAbout",
 CellID->524310375],
Cell[26563, 1037, 179, 3, 70, "MoreAbout",
 CellID->679278952],
Cell[26745, 1042, 198, 4, 70, "MoreAbout",
 CellID->637102508]
}, Open  ]],
Cell[26958, 1049, 27, 0, 70, "History"],
Cell[26988, 1051, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

