(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54163,       1954]
NotebookOptionsPosition[     45012,       1627]
NotebookOutlinePosition[     46338,       1664]
CellTagsIndexPosition[     46252,       1659]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LUDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/LUDecomposition"], 
          "LinearSolve" :> Documentation`HelpLookup["paclet:ref/LinearSolve"],
           "LinearSolveFunction" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolveFunction"], 
          "FindMinimum" :> Documentation`HelpLookup["paclet:ref/FindMinimum"],
           "PseudoInverse" :> 
          Documentation`HelpLookup["paclet:ref/PseudoInverse"], 
          "QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"], 
          "HermitianMatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/HermitianMatrixQ"], 
          "PositiveDefiniteMatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/PositiveDefiniteMatrixQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"LUDecomposition\"\>", 
       2->"\<\"LinearSolve\"\>", 3->"\<\"LinearSolveFunction\"\>", 
       4->"\<\"FindMinimum\"\>", 5->"\<\"PseudoInverse\"\>", 
       6->"\<\"QRDecomposition\"\>", 7->"\<\"HermitianMatrixQ\"\>", 
       8->"\<\"PositiveDefiniteMatrixQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Matrix Decompositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CholeskyDecomposition", "ObjectName",
 CellID->19426],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CholeskyDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CholeskyDecomposition"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Cholesky decomposition of a matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be numerical or symbolic, but must be Hermitian and positive definite. \
",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->312006625,
  ButtonNote->"312006625"]
}], "Notes",
 CellID->6775],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CholeskyDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CholeskyDecomposition"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " yields an upper\[Hyphen]triangular matrix ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " so that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"ConjugateTranspose", "[", 
     StyleBox["u", "TI"], "]"}], ".", 
    StyleBox["u", "TI"]}], "==", "m"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->227007292,
  ButtonNote->"227007292"]
}], "Notes",
 CellID->20904]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40048562],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->325672654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CholeskyDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox["2"], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SqrtBox[
      FractionBox["3", "2"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{170, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13282]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConjugateTranspose", "[", "%", "]"}], ".", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->335]
}, Open  ]],

Cell["The matrix is positive definite:", "ExampleText",
 CellID->12006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5705]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16222],

Cell["Hilbert matrices are symmetric and positive definite:", "ExampleText",
 CellID->449392683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"HilbertMatrix", "[", "5", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122030861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "7"], ",", 
     FractionBox["1", "8"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "7"], ",", 
     FractionBox["1", "8"], ",", 
     FractionBox["1", "9"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{384, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106760549]
}, Open  ]],

Cell["Compute the Cholesky decomposition with exact arithmetic:", \
"ExampleText",
 CellID->19630182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CholeskyDecomposition", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86921173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}]], ",", 
     FractionBox["1", 
      RowBox[{"2", " ", 
       SqrtBox["3"]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["3"]}], "20"], ",", 
     FractionBox["2", 
      RowBox[{"5", " ", 
       SqrtBox["3"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["1", 
      RowBox[{"6", " ", 
       SqrtBox["5"]}]], ",", 
     FractionBox["1", 
      RowBox[{"4", " ", 
       SqrtBox["5"]}]], ",", 
     FractionBox["2", 
      RowBox[{"7", " ", 
       SqrtBox["5"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox["1", 
      RowBox[{"20", " ", 
       SqrtBox["7"]}]], ",", 
     FractionBox["1", 
      RowBox[{"10", " ", 
       SqrtBox["7"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox["1", "210"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{509, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->309117912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5831877],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      FractionBox["1", "2"], 
      FractionBox["1", "3"], 
      FractionBox["1", "4"], 
      FractionBox["1", "5"]},
     {"0", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["3"]}]], 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["3"]}]], 
      FractionBox[
       RowBox[{"3", " ", 
        SqrtBox["3"]}], "20"], 
      FractionBox["2", 
       RowBox[{"5", " ", 
        SqrtBox["3"]}]]},
     {"0", "0", 
      FractionBox["1", 
       RowBox[{"6", " ", 
        SqrtBox["5"]}]], 
      FractionBox["1", 
       RowBox[{"4", " ", 
        SqrtBox["5"]}]], 
      FractionBox["2", 
       RowBox[{"7", " ", 
        SqrtBox["5"]}]]},
     {"0", "0", "0", 
      FractionBox["1", 
       RowBox[{"20", " ", 
        SqrtBox["7"]}]], 
      FractionBox["1", 
       RowBox[{"10", " ", 
        SqrtBox["7"]}]]},
     {"0", "0", "0", "0", 
      FractionBox["1", "210"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{201, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->222341814]
}, Open  ]],

Cell["Compute the Cholesky decomposition with machine arithmetic:", \
"ExampleText",
 CellID->7757490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CholeskyDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->268301556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "0.5`", ",", "0.3333333333333333`", ",", "0.25`", ",", 
     "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.28867513459481287`", ",", "0.2886751345948129`", ",", 
     "0.2598076211353316`", ",", "0.23094010767585027`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.`", ",", "0.07453559924999285`", ",", 
     "0.11180339887498938`", ",", "0.12777531299998812`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.`", ",", "0.`", ",", "0.018898223650461475`", ",", 
     "0.03779644730092232`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.004761904761904629`"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{518, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->649432361]
}, Open  ]],

Cell["\<\
Compute the Cholesky decomposition with 24 digit precision arithmetic:\
\>", "ExampleText",
 CellID->674317737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CholeskyDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->118885223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`24.", ",", "0.5`24.", ",", 
     "0.33333333333333333333333333333333333333`24.", ",", "0.25`24.", ",", 
     "0.2`24."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0.28867513459481288225457439025097872782`24.", ",", 
     "0.28867513459481288225457439025097872783`24.", ",", 
     "0.25980762113533159402911695122588085504`24.", ",", 
     "0.23094010767585030580365951220078298226`24."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0.07453559924999298988030578895770920782`24.", ",", 
     "0.11180339887498948482045868343656381181`24.", ",", 
     "0.12777531299998798265195278107035864206`24."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", 
     "0.01889822365046136136072582681170900288`24.", ",", 
     "0.03779644730092272272145165362341800591`24."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", 
     "0.0047619047619047619047619047619047623`24."}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{476, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->461568308]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208116455],

Cell["\<\
Compute the Cholesky decomposition of a random complex Hermitian matrix:\
\>", "ExampleText",
 CellID->126129460],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "I"}], ")"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"CholeskyDecomposition", "[", 
  RowBox[{
   RowBox[{"r", ".", 
    RowBox[{"ConjugateTranspose", "[", "r", "]"}]}], "+", 
   RowBox[{"IdentityMatrix", "[", "4", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->59575838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.8929083107624098`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.6025023326801603`"}], "+", 
      RowBox[{"0.37700863786205435`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.4691203678944048`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.6151635457182123`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.18293724480046103`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.34820224040409`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.7058147852974035`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.11190430044905654`"}], "+", 
      RowBox[{"0.8408541340255076`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.2747807068239224`"}], "+", 
      RowBox[{"0.5583822482817036`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.9229838647709503`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.4511804887448894`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.03300800118517213`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.6797859445835652`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{546, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229911316]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20379],

Cell["Use symbolic matrices:", "ExampleText",
 CellID->30782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CholeskyDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox["x"], ",", 
     FractionBox["y", 
      SqrtBox["x"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SqrtBox[
      RowBox[{"x", "-", 
       FractionBox[
        RowBox[{"y", " ", 
         RowBox[{"Conjugate", "[", 
          FractionBox["y", 
           SqrtBox["x"]], "]"}]}], 
        SqrtBox["x"]]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{292, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487752073]
}, Open  ]],

Cell["\<\
Conditions are needed to make sure the matrix is positive definite:\
\>", "ExampleText",
 CellID->4682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ConjugateTranspose", "[", "%", "]"}], ".", "%"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "y"}], "&&", 
    RowBox[{"x", ">", 
     RowBox[{"-", "y"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108533307]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "-", "y"}], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->384014945]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32082],

Cell["\<\
The Cholesky decomposition is a fast way of determining positive \
definiteness:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->312006625],

Cell[BoxData[
 RowBox[{
  RowBox[{"pdq", "[", 
   RowBox[{
    RowBox[{"m_", "?", "MatrixQ"}], "/;", 
    RowBox[{"m", "\[Equal]", 
     RowBox[{"ConjugateTranspose", "[", "m", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"Check", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CholeskyDecomposition", "[", "m", "]"}], ";", "True"}], ",", 
     "False", ",", 
     RowBox[{"CholeskyDecomposition", "::", "posdef"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->456301221],

Cell["The identity matrix is positive definite", "ExampleText",
 CellID->282041762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdq", "[", 
  RowBox[{"IdentityMatrix", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621596126],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355348679]
}, Open  ]],

Cell[TextData[{
 "Estimate the probability that a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", " ", "+", " ", 
    SuperscriptBox["r", "T"]}], TraditionalForm]]],
 " is positive definite for ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " a random 3x3 matrix:"
}], "ExampleText",
 CellID->117183444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"trials", "=", "1000"}], ",", 
     RowBox[{"count", "=", "0"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"pdq", "[", 
          RowBox[{"r", "+", 
           RowBox[{"Transpose", "[", "r", "]"}]}], "]"}], ",", 
         RowBox[{"count", "++"}]}], "]"}]}], ",", 
      RowBox[{"{", "trials", "}"}]}], "]"}], ";", 
    RowBox[{"N", "[", 
     RowBox[{"count", "/", "trials"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->385761198],

Cell[BoxData["0.065`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->534725312]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9378],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a symmetric positive definite matrix:"
}], "ExampleText",
 CellID->122752006],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434284564],

Cell["Compute the Cholesky decomposition:", "ExampleText",
 CellID->620917531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"CholeskyDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64575900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["3", "2"], ",", "1", ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      SqrtBox["7"], "2"], ",", 
     FractionBox["3", 
      SqrtBox["7"]], ",", 
     FractionBox["5", 
      RowBox[{"2", " ", 
       SqrtBox["7"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["3", "7"]]}], ",", 
     FractionBox["5", 
      SqrtBox["21"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     SqrtBox[
      FractionBox["5", "3"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->405909199]
}, Open  ]],

Cell[TextData[{
 "Verify ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["ConjugateTranspose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
     StyleBox["u", "TI"], "]"}], ".", 
    StyleBox["u", "TI"]}], " ", "==", " ", 
   StyleBox["m", "TI"]}]], "InlineFormula"]
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->227007292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConjugateTranspose", "[", "u", "]"}], ".", "u"}], "-", 
  "m"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12083656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->138342380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92512332],

Cell["m is a random matrix with real entries:", "ExampleText",
 CellID->494602245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23154159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.5537728325026605`", ",", "0.6039791803721561`", ",", 
     "0.8635622418086197`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.20475538591118236`", ",", "0.5654219095225759`", ",", 
     "0.29684316438710634`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.08005785709593294`", ",", "0.6106755733148623`", ",", 
     "0.7272303726757556`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3994875066869832`", ",", "0.22257527899752394`", ",", 
     "0.8509693673869518`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7731760940078802`", ",", "0.012345074414814139`", ",", 
     "0.18170257740733886`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.2140064372189605`", ",", "0.3448030396683863`", ",", 
     "0.5526307676984734`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17209585]
}, Open  ]],

Cell[TextData[{
 "Find the Cholesky decomposition of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Transpose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Transpose"], "[", 
    StyleBox["m", "TI"], "]"}], ".", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->123821624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"CholeskyDecomposition", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", "m", "]"}], ".", "m"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->193079536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.0761917459615957`", ",", "0.6238487265943925`", ",", 
     "1.1112557931383473`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.9147740158688702`", ",", "0.8990834759113888`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.6180975218337146`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{514, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->349259495]
}, Open  ]],

Cell[TextData[{
 "Find the ",
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->447895298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "r"}], "}"}], "=", 
  RowBox[{"QRDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->851052438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5145670690940443`"}], ",", 
       RowBox[{"-", "0.1902592049042617`"}], ",", 
       RowBox[{"-", "0.07438995643327471`"}], ",", 
       RowBox[{"-", "0.37120476735308383`"}], ",", 
       RowBox[{"-", "0.7184371157920695`"}], ",", 
       RowBox[{"-", "0.19885530438420354`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3093301347236675`"}], ",", 
       RowBox[{"-", "0.48834896823766777`"}], ",", 
       RowBox[{"-", "0.6168381304388049`"}], ",", "0.00983886978131581`", ",",
        "0.4764575707763593`", ",", 
       RowBox[{"-", "0.24131360032356236`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0220563780092575`"}], ",", "0.5721588496785057`", ",", 
       
       RowBox[{"-", "0.14556785793516316`"}], ",", 
       RowBox[{"-", "0.7236914381087415`"}], ",", "0.3046278200658338`", ",", 
       
       RowBox[{"-", "0.1855541950748878`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.0761917459615955`"}], ",", 
       RowBox[{"-", "0.6238487265943926`"}], ",", 
       RowBox[{"-", "1.1112557931383475`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.9147740158688702`"}], ",", 
       RowBox[{"-", "0.8990834759113887`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", 
       RowBox[{"-", "0.6180975218337141`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{574, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->279348142]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " except for the choice of sign for each row:"
}], "ExampleText",
 CellID->16425230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{"r", " ", 
    RowBox[{"Sign", "[", 
     RowBox[{"Tr", "[", 
      RowBox[{"r", ",", "List"}], "]"}], "]"}]}], "-", "u"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->141075616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->23519961]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12425],

Cell["\<\
Matrices need to be positive definite enough to overcome numerical roundoff:\
\>", "ExampleText",
 CellID->191426393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"CholeskyDecomposition", "[", 
   RowBox[{"N", "[", 
    RowBox[{"HilbertMatrix", "[", "16", "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361525945],

Cell[BoxData[
 RowBox[{
  RowBox[{"CholeskyDecomposition", "::", "\<\"posdef\"\>"}], ":", 
  " ", "\<\"The matrix \\!\\({\\(\\({1.`, 0.5`, 0.3333333333333333`, 0.25`, \
0.2`, \\(\\(\[LeftSkeleton] 20 \[RightSkeleton]\\)\\), 0.14285714285714285`, \
0.125`, 0.1111111111111111`, 0.1`, \\(\\(\[LeftSkeleton] 6 \
\[RightSkeleton]\\)\\)}\\)\\), \\(\\(\[LeftSkeleton] 9 \
\[RightSkeleton]\\)\\), \\(\\(\[LeftSkeleton] 6 \[RightSkeleton]\\)\\)}\\) is \
not sufficiently positive definite to complete the Cholesky decomposition to \
reasonable accuracy.\"\>"}]], "Message", "MSG",
 CellID->169111207],

Cell[BoxData["CholeskyDecomposition"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254791895]
}, Open  ]],

Cell["\<\
The smallest eigenvalue is effectively zero to machine precision:\
\>", "ExampleText",
 CellID->352131948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"HilbertMatrix", "[", "16", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->203084487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.8600364427433271`", ",", "0.44013143636233815`", ",", 
   "0.06111426291630709`", ",", "0.006297815269922938`", ",", 
   "0.0005146753583779355`", ",", "0.00003412756971658616`", ",", 
   "1.8529753628386086`*^-6", ",", "8.253135278123955`*^-8", ",", 
   "3.0045761593828615`*^-9", ",", "8.86170884436706`*^-11", ",", 
   "2.085937152775827`*^-12", ",", "3.827669089575262`*^-14", ",", 
   "5.277456405490515`*^-16", ",", "5.14339953206079`*^-18", ",", 
   "3.159250701855795`*^-20", ",", "9.197419820651453`*^-23"}], 
  "}"}]], "Output",
 ImageSize->{505, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40778960]
}, Open  ]],

Cell["\<\
The decomposition can be computed when the precision is high enough to \
resolve it:\
\>", "ExampleText",
 CellID->57031387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"CholeskyDecomposition", "[", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"HilbertMatrix", "[", "16", "]"}], ",", "24"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->357446552],

Cell[BoxData["List"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->328060252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->672840983],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " is a sparse tridiagonal matrix:"
}], "ExampleText",
 CellID->56927419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", "=", "500"}], "}"}], ",", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
         RowBox[{
          RowBox[{"2.", 
           RowBox[{"n", "^", "2"}]}], "-", "1."}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
         RowBox[{
          RowBox[{"-", "1."}], 
          RowBox[{"n", "^", "2"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13370220],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1498", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1498, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"500", ",", "500"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271496081]
}, Open  ]],

Cell["\<\
The Cholesky decomposition is computed as a dense matrix even if the result \
is sparse:\
\>", "ExampleText",
 CellID->85211045],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CholeskyDecomposition", "[", "s", "]"}]}], ";"}], "\n", 
 RowBox[{"ArrayPlot", "[", "u", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->68428148],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyt2ddOVHsYhvFB7L2LHXvvvXewYe8dEQUVQcDee+8FsCt2sxMPvAOugmPK
AfUS2LMG3XvlyXO0syeZyZqZX77/N+87BBJSUvMz0rNS8zPTUhOTc1NzMjLT
8hKTsnOjL8XHRSKRX8E9IRK9boheNd7jGxqCi+D2M3qPa3waH7wXu0V+Rh/i
GsH/+uqP4CG+rq7u9/Mmqr7HVGVlZXFxcexS1bfYWxUVFYWFhfX19ZGmqr6G
VHV1daSZqi8xVV5eHlVVVVWR5qo+h1Qwq4WqTzFVVlYWVTU1NZGWqj5iVitV
xVCtVX2AaqPq/R9VVFQUfMa2qt4hiXaq3kK1V/UGe3VQ9TrUUDCro6pXUJ1U
vcRenVW9wF5dVBWFVNBjV1WFobaDWd1UFeDE7qqeY/seqp6FTgxUgqqnmNVT
1ROoXqoeh7IPtu+t6hFUH1UPofqqeoC8+qm6H0oiaKi/qnuYlajqLnocoOoO
Zg1UdRupDlJ1C2qwqptQQ1TdwF5DVV3HrGGqrqGh4aqu/plVUFAQzBqh6gr2
GqnqckgFPY5SdQkNjVZ1EWqMqgtIYqyq81DjVJ2DGq/qLNQEVWeQ/URVp5Hq
JFWnMGuyqpOYNUXVCaQ6VdVxzJqm6hhmTVeVDzVDVR5SnakqF2qWqqNQs1Xl
4DPOUZWNWXNVHUFD81Rl4cT5qg7jxAWqDmHWQlUHkf0iVZlQi1VlYK8lqg5g
ryRV+zErWVU61FJV+5D9MlVp2Gu5qr1QK1Sl4sSVqvZgVoqq3VCrVO1CQ6tV
7YRao2oHUl2rajvUOlXboNar2gq1QdUWqI2qNiOvTao2QW1WtRFqi6oNUFtV
rUf221Stg9quam1IBUnsULUGee1UtRpql6pVULtVpeB7v0fVSuSVqmoF1F5V
y6HSVC0LqeCvjn2qlmJWuqpkNLRfVRLUAVVL0GOGqsXIPlPVolD2gTqoaiFm
HVK1AOqwqvnIK0vVPKgjquZCZauaA5WjajayP6pqFlSuqploKE/VDOSVr2o6
1DFV09DjcVVToU6omoK8TqqaDHVK1SSo06omQp1RNQHqrKrxaOicqnFQ51WN
RY8XVI1BQxdVjUb2l1SNgrqsaiROvKJqBPK6qmo41DVVw6CuqxoKdUPVEKib
qgajoVuqBqGh26oGQt1RNQCp3lWVGGoo2Oueqv7o8b6qfkjigaq+UA9V9YF6
pKp3SAW/0x6r6oVZT1T1RKpPVSVAPVPVA+q5qu5oqEBVN6hCVV3RY5GqLpj1
QlVn5PVSVSeoV6o64nv/WlUHzHqjqj3UW1XtkP07VW2x13tVbaA+qGqNE4tV
tUJDH1W1hPqkqgV6/KyqOfL6oqpZaPvgZ+irqqZQ31TFQ31X1SSmamtrf+/1
41/V/B8VvZWWlpaUlPylM/7b/2Z+Nb4X9ze+Zp4Q\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22164225]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " will give a ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " that has a sparse Cholesky factorization:"
}], "ExampleText",
 CellID->21058419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"s", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<Cholesky\>\""}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->158907943],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"500", ",", "500"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->83194457]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ByteCount", "[", "u", "]"}], "/", 
   RowBox[{"ByteCount", "[", "f", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->256302862],

Cell[BoxData["96.10301748990966`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->300875283]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3890],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LUDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LUDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolveFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolveFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PseudoInverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PseudoInverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermitianMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermitianMatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PositiveDefiniteMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2528]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22330],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->11780]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->801312581],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->385091875],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->120963],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->34136458]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CholeskyDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 28.8211416}", "context" -> "System`", 
    "keywords" -> {"Cholesky decomposition", "positive definite matrix"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CholeskyDecomposition[m] gives the Cholesky decomposition of a matrix m. \
", "synonyms" -> {"cholesky decomposition", "chol"}, "title" -> 
    "CholeskyDecomposition", "type" -> "Symbol", "uri" -> 
    "ref/CholeskyDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5797, 178, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->40048562]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46110, 1652}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3002, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3625, 94, 59, 1, 70, "ObjectName",
 CellID->19426],
Cell[3687, 97, 588, 18, 70, "Usage",
 CellID->7032]
}, Open  ]],
Cell[CellGroupData[{
Cell[4312, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4790, 137, 312, 11, 70, "Notes",
 CellID->6775],
Cell[5105, 150, 655, 23, 70, "Notes",
 CellID->20904]
}, Closed]],
Cell[CellGroupData[{
Cell[5797, 178, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40048562],
Cell[CellGroupData[{
Cell[6181, 192, 148, 5, 70, "ExampleSection",
 CellID->325672654],
Cell[CellGroupData[{
Cell[6354, 201, 261, 9, 28, "Input",
 CellID->6731],
Cell[6618, 212, 393, 16, 62, "Output",
 CellID->13282]
}, Open  ]],
Cell[CellGroupData[{
Cell[7048, 233, 132, 4, 28, "Input",
 CellID->4730],
Cell[7183, 239, 296, 11, 36, "Output",
 CellID->335]
}, Open  ]],
Cell[7494, 253, 71, 1, 70, "ExampleText",
 CellID->12006],
Cell[CellGroupData[{
Cell[7590, 258, 252, 9, 28, "Input",
 CellID->10764],
Cell[7845, 269, 198, 7, 36, "Output",
 CellID->5705]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8092, 282, 216, 7, 70, "ExampleSection",
 CellID->16222],
Cell[8311, 291, 96, 1, 70, "ExampleText",
 CellID->449392683],
Cell[CellGroupData[{
Cell[8432, 296, 132, 4, 70, "Input",
 CellID->122030861],
Cell[8567, 302, 1205, 41, 81, "Output",
 CellID->106760549]
}, Open  ]],
Cell[9787, 346, 101, 2, 70, "ExampleText",
 CellID->19630182],
Cell[CellGroupData[{
Cell[9913, 352, 116, 3, 70, "Input",
 CellID->86921173],
Cell[10032, 357, 1366, 49, 95, "Output",
 CellID->309117912]
}, Open  ]],
Cell[CellGroupData[{
Cell[11435, 411, 104, 3, 70, "Input",
 CellID->5831877],
Cell[11542, 416, 1622, 57, 182, "Output",
 CellID->222341814]
}, Open  ]],
Cell[13179, 476, 102, 2, 70, "ExampleText",
 CellID->7757490],
Cell[CellGroupData[{
Cell[13306, 482, 145, 4, 70, "Input",
 CellID->268301556],
Cell[13454, 488, 923, 27, 71, "Output",
 CellID->649432361]
}, Open  ]],
Cell[14392, 518, 121, 3, 70, "ExampleText",
 CellID->674317737],
Cell[CellGroupData[{
Cell[14538, 525, 170, 5, 70, "Input",
 CellID->118885223],
Cell[14711, 532, 1214, 33, 173, "Output",
 CellID->461568308]
}, Open  ]],
Cell[15940, 568, 125, 3, 70, "ExampleDelimiter",
 CellID->208116455],
Cell[16068, 573, 123, 3, 70, "ExampleText",
 CellID->126129460],
Cell[CellGroupData[{
Cell[16216, 580, 579, 19, 70, "Input",
 CellID->59575838],
Cell[16798, 601, 2205, 51, 88, "Output",
 CellID->229911316]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19052, 658, 239, 7, 70, "ExampleSection",
 CellID->20379],
Cell[19294, 667, 61, 1, 70, "ExampleText",
 CellID->30782],
Cell[CellGroupData[{
Cell[19380, 672, 262, 9, 70, "Input",
 CellID->25384],
Cell[19645, 683, 565, 22, 77, "Output",
 CellID->487752073]
}, Open  ]],
Cell[20225, 708, 113, 3, 70, "ExampleText",
 CellID->4682],
Cell[CellGroupData[{
Cell[20363, 715, 294, 10, 70, "Input",
 CellID->31677],
Cell[20660, 727, 302, 11, 36, "Output",
 CellID->108533307]
}, Open  ]],
Cell[CellGroupData[{
Cell[20999, 743, 252, 9, 70, "Input",
 CellID->27800],
Cell[21254, 754, 251, 9, 36, "Output",
 CellID->384014945]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21554, 769, 223, 7, 70, "ExampleSection",
 CellID->32082],
Cell[21780, 778, 179, 5, 70, "ExampleText",
 CellID->312006625],
Cell[21962, 785, 507, 16, 70, "Input",
 CellID->456301221],
Cell[22472, 803, 83, 1, 70, "ExampleText",
 CellID->282041762],
Cell[CellGroupData[{
Cell[22580, 808, 141, 4, 70, "Input",
 CellID->621596126],
Cell[22724, 814, 161, 5, 36, "Output",
 CellID->355348679]
}, Open  ]],
Cell[22900, 822, 314, 11, 70, "ExampleText",
 CellID->117183444],
Cell[CellGroupData[{
Cell[23239, 837, 815, 26, 70, "Input",
 CellID->385761198],
Cell[24057, 865, 163, 5, 36, "Output",
 CellID->534725312]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24269, 876, 232, 7, 70, "ExampleSection",
 CellID->9378],
Cell[24504, 885, 156, 5, 70, "ExampleText",
 CellID->122752006],
Cell[24663, 892, 474, 15, 70, "Input",
 CellID->434284564],
Cell[25140, 909, 78, 1, 70, "ExampleText",
 CellID->620917531],
Cell[CellGroupData[{
Cell[25243, 914, 139, 4, 70, "Input",
 CellID->64575900],
Cell[25385, 920, 845, 31, 62, "Output",
 CellID->405909199]
}, Open  ]],
Cell[26245, 954, 412, 14, 70, "ExampleText",
 CellID->227007292],
Cell[CellGroupData[{
Cell[26682, 972, 163, 6, 70, "Input",
 CellID->12083656],
Cell[26848, 980, 500, 15, 36, "Output",
 CellID->138342380]
}, Open  ]],
Cell[27363, 998, 124, 3, 70, "ExampleDelimiter",
 CellID->92512332],
Cell[27490, 1003, 82, 1, 70, "ExampleText",
 CellID->494602245],
Cell[CellGroupData[{
Cell[27597, 1008, 203, 7, 70, "Input",
 CellID->23154159],
Cell[27803, 1017, 994, 31, 71, "Output",
 CellID->17209585]
}, Open  ]],
Cell[28812, 1051, 319, 12, 70, "ExampleText",
 CellID->123821624],
Cell[CellGroupData[{
Cell[29156, 1067, 202, 6, 70, "Input",
 CellID->193079536],
Cell[29361, 1075, 524, 17, 36, "Output",
 CellID->349259495]
}, Open  ]],
Cell[29900, 1095, 272, 11, 70, "ExampleText",
 CellID->447895298],
Cell[CellGroupData[{
Cell[30197, 1110, 181, 6, 70, "Input",
 CellID->851052438],
Cell[30381, 1118, 1722, 47, 88, "Output",
 CellID->279348142]
}, Open  ]],
Cell[32118, 1168, 236, 8, 70, "ExampleText",
 CellID->16425230],
Cell[CellGroupData[{
Cell[32379, 1180, 244, 9, 70, "Input",
 CellID->141075616],
Cell[32626, 1191, 390, 13, 36, "Output",
 CellID->23519961]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33065, 1210, 226, 7, 70, "ExampleSection",
 CellID->12425],
Cell[33294, 1219, 127, 3, 70, "ExampleText",
 CellID->191426393],
Cell[CellGroupData[{
Cell[33446, 1226, 220, 6, 70, "Input",
 CellID->361525945],
Cell[33669, 1234, 592, 10, 70, "Message",
 CellID->169111207],
Cell[34264, 1246, 179, 5, 36, "Output",
 CellID->254791895]
}, Open  ]],
Cell[34458, 1254, 116, 3, 70, "ExampleText",
 CellID->352131948],
Cell[CellGroupData[{
Cell[34599, 1261, 177, 5, 70, "Input",
 CellID->203084487],
Cell[34779, 1268, 713, 16, 75, "Output",
 CellID->40778960]
}, Open  ]],
Cell[35507, 1287, 134, 4, 70, "ExampleText",
 CellID->57031387],
Cell[CellGroupData[{
Cell[35666, 1295, 250, 8, 70, "Input",
 CellID->357446552],
Cell[35919, 1305, 161, 5, 36, "Output",
 CellID->328060252]
}, Open  ]],
Cell[36095, 1313, 125, 3, 70, "ExampleDelimiter",
 CellID->672840983],
Cell[36223, 1318, 146, 5, 70, "ExampleText",
 CellID->56927419],
Cell[CellGroupData[{
Cell[36394, 1327, 888, 29, 70, "Input",
 CellID->13370220],
Cell[37285, 1358, 489, 17, 36, "Output",
 CellID->271496081]
}, Open  ]],
Cell[37789, 1378, 138, 4, 70, "ExampleText",
 CellID->85211045],
Cell[CellGroupData[{
Cell[37952, 1386, 206, 6, 70, "Input",
 CellID->68428148],
Cell[38161, 1394, 1655, 31, 70, "Output",
 Evaluatable->False,
 CellID->22164225]
}, Open  ]],
Cell[39831, 1428, 394, 13, 70, "ExampleText",
 CellID->21058419],
Cell[CellGroupData[{
Cell[40250, 1445, 205, 6, 70, "Input",
 CellID->158907943],
Cell[40458, 1453, 330, 12, 36, "Output",
 CellID->83194457]
}, Open  ]],
Cell[CellGroupData[{
Cell[40825, 1470, 194, 6, 70, "Input",
 CellID->256302862],
Cell[41022, 1478, 175, 5, 36, "Output",
 CellID->300875283]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41258, 1490, 310, 9, 70, "SeeAlsoSection",
 CellID->3890],
Cell[41571, 1501, 2038, 71, 70, "SeeAlso",
 CellID->2528]
}, Open  ]],
Cell[CellGroupData[{
Cell[43646, 1577, 314, 9, 70, "TutorialsSection",
 CellID->22330],
Cell[43963, 1588, 161, 3, 70, "Tutorials",
 CellID->11780]
}, Open  ]],
Cell[CellGroupData[{
Cell[44161, 1596, 319, 9, 70, "MoreAboutSection",
 CellID->801312581],
Cell[44483, 1607, 139, 3, 70, "MoreAbout",
 CellID->385091875],
Cell[44625, 1612, 160, 3, 70, "MoreAbout",
 CellID->120963],
Cell[44788, 1617, 152, 3, 70, "MoreAbout",
 CellID->34136458]
}, Open  ]],
Cell[44955, 1623, 27, 0, 70, "History"],
Cell[44985, 1625, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

