(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30163,       1143]
NotebookOptionsPosition[     23704,        912]
NotebookOutlinePosition[     25048,        950]
CellTagsIndexPosition[     24963,        945]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Precision\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Clip" :> 
          Documentation`HelpLookup["paclet:ref/Clip"], "Accuracy" :> 
          Documentation`HelpLookup["paclet:ref/Accuracy"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "IntegerPart" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPart"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"], "SetPrecision" :> 
          Documentation`HelpLookup["paclet:ref/SetPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rationalize\"\>", 
       2->"\<\"Round\"\>", 3->"\<\"Clip\"\>", 4->"\<\"Accuracy\"\>", 
       5->"\<\"Floor\"\>", 6->"\<\"IntegerPart\"\>", 7->"\<\"N\"\>", 
       8->"\<\"Precision\"\>", 9->"\<\"SetPrecision\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Functions\"\>", 
       2->"\<\"Precision & Accuracy Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Chop", "ObjectName",
 CellID->3378],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Chop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Chop"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces approximate real numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that are close to zero by the exact integer ",
     Cell[BoxData["0"], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["delta", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " replaces numbers smaller in absolute magnitude than ",
 Cell[BoxData[
  StyleBox["delta", "TI"]], "InlineFormula"],
 " by ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31603],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " uses a default tolerance of ",
 Cell[BoxData[
  SuperscriptBox["10", 
   RowBox[{"-", "10"}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28243],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " works on both ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers. "
}], "Notes",
 CellID->924]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->728127220],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->374469730],

Cell["Zero out elements that are very close to 0:", "ExampleText",
 CellID->17797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"Fourier", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.9999999999999998`", ",", "0.9999999999999999`", ",", 
   "0.9999999999999999`", ",", "9.064933036736789`*^-17", ",", 
   "6.829683435393`*^-17", ",", "9.064933036736789`*^-17"}], "}"}]], "Output",\

 ImageSize->{386, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23758]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.9999999999999998`", ",", "0.9999999999999999`", ",", 
   "0.9999999999999999`", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24918]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28996],

Cell["Drop small imaginary parts:", "ExampleText",
 CellID->3453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"Range", "[", "4", "]"}], " ", "Pi", " ", "I"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], "+", 
    RowBox[{"1.2246063538223773`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.4492127076447545`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], "+", 
    RowBox[{"3.673819061467132`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.`", "\[InvisibleSpace]", "-", 
    RowBox[{"4.898425415289509`*^-16", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{577, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7005]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", "1.`", ",", 
   RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245980387],

Cell["Convert from approximate zeros to exact zeros:", "ExampleText",
 CellID->439937738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierDST", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
    "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63906541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.72360679774997896964091736687312688844`19.353847239519773", ",", 
   "0``19.504640129957842", ",", 
   "0.27639320225002103035908263312687209622`18.92322435921697", ",", 
   "0``19.406774961514962", ",", 
   "1.34164078649987381784550420123876439235`19.69897000433602"}], 
  "}"}]], "Output",
 ImageSize->{390, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75203687]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"%", ",", 
   RowBox[{"10", "^", 
    RowBox[{"-", "19"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->76960985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.72360679774997896964091736687312688844`19.353847239519773", ",", "0", 
   ",", "0.27639320225002103035908263312687209622`18.92322435921697", ",", 
   "0", ",", "1.34164078649987381784550420123876439235`19.69897000433602"}], 
  "}"}]], "Output",
 ImageSize->{518, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205593019]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3713],

Cell["Test if two numbers are the same to a certain tolerance:", "ExampleText",
 CellID->406787404],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"N", "[", "Pi", "]"}]}], ";"}], "\n", 
 RowBox[{"r", "=", 
  RowBox[{"Rationalize", "[", 
   RowBox[{"x", ",", 
    RowBox[{"10", "^", 
     RowBox[{"-", "12"}]}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->106189581],

Cell[BoxData[
 FractionBox["4272943", "1360120"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->913566937]
}, Open  ]],

Cell[TextData[{
 "They are the same to the default tolerance of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1011091435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Chop", "[", 
   RowBox[{"x", "-", "r"}], "]"}], "===", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112357983],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144687297]
}, Open  ]],

Cell[TextData[{
 "They are not the same to the tolerance of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "14"}]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->282461489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Chop", "[", 
   RowBox[{
    RowBox[{"x", "-", "r"}], ",", 
    RowBox[{"10", "^", 
     RowBox[{"-", "14"}]}]}], "]"}], "===", "0"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->465351253],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->44460557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->428890279],

Cell[TextData[{
 "Eliminate very small terms before comparing with ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->131194131],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"identity", "=", 
  RowBox[{"FourierDCT", "[", 
   RowBox[{
    RowBox[{"FourierDCT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
      "2"}], "]"}], ",", "3"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->390358882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.551115123125783`*^-17", ",", 
   RowBox[{"-", "5.551115123125783`*^-17"}], ",", "1.`", ",", "0.`", ",", 
   "0.`"}], "}"}]], "Output",
 ImageSize->{292, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113107270]
}, Open  ]],

Cell["\<\
They are not equal because a small number is not equal to zero:\
\>", "ExampleText",
 CellID->160954763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "\[Equal]", "identity"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->248923665],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104129124]
}, Open  ]],

Cell["Once the small terms are eliminated, equality holds:", "ExampleText",
 CellID->618663221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "\[Equal]", 
  RowBox[{"Chop", "[", "identity", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->121967413],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->100618559]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17609],

Cell[TextData[{
 "A functional implementation of ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->285053166],

Cell[BoxData[
 RowBox[{
  RowBox[{"chop", "[", 
   RowBox[{"xa_", ",", 
    RowBox[{"dxa_:", 
     RowBox[{"10", "^", 
      RowBox[{"-", "10"}]}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ch", ",", "x", ",", "dx"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"ch", "[", 
       RowBox[{"x_Real", ",", " ", "dx_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", "x", "]"}], "<", "dx"}], ",", "0", ",", "x"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ch", "[", 
       RowBox[{
        RowBox[{"Complex", "[", 
         RowBox[{"r_", ",", "i_"}], "]"}], ",", "dx_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"ch", "[", 
        RowBox[{"r", ",", "dx"}], "]"}], "+", 
       RowBox[{"I", " ", 
        RowBox[{"ch", "[", "i", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ch", "[", 
       RowBox[{
        RowBox[{"x_", "?", "AtomQ"}], ",", "dx_"}], "]"}], ":=", "x"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ch", "[", 
       RowBox[{"x_", ",", "dx_"}], "]"}], ":=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ch", "[", 
          RowBox[{"#", ",", "dx"}], "]"}], "&"}], ",", "x"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ch", "[", 
      RowBox[{"xa", ",", "dxa"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98135275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", " ", 
  RowBox[{"f", "[", 
   RowBox[{"$MachineEpsilon", ",", 
    RowBox[{"1.", "+", 
     RowBox[{"2.", " ", "x"}], "+", " ", 
     RowBox[{"3.", " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "12"}]}], " ", 
      RowBox[{"x", "^", "2"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47359929],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"2.220446049250313`*^-16", ",", 
   RowBox[{"1.`", "\[InvisibleSpace]", "+", 
    RowBox[{"2.`", " ", "x"}], "+", 
    RowBox[{"3.`*^-12", " ", 
     SuperscriptBox["x", "2"]}]}]}], "]"}]], "Output",
 ImageSize->{260, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16776996]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"chop", "[", "e", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->830558734],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"0", ",", 
   RowBox[{"1.`", "\[InvisibleSpace]", "+", 
    RowBox[{"2.`", " ", "x"}]}]}], "]"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->260218662]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "e", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->107916047],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"0", ",", 
   RowBox[{"1.`", "\[InvisibleSpace]", "+", 
    RowBox[{"2.`", " ", "x"}]}]}], "]"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->504796513]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " is much faster for large expressions:"
}], "ExampleText",
 CellID->383906539],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0.", ",", 
     RowBox[{"10", "^", "6"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", "1."}], ";"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->59963569],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"Fourier", "[", 
    RowBox[{"InverseFourier", "[", "x", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->415079680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Chop", "[", "y", "]"}], "\[Equal]", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->469954476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.28000000000000086`", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->139167622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"chop", "[", "y", "]"}], "\[Equal]", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->248758360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.876`", ",", "True"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->37560845]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3289],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11401]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24055],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->5234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->23557252],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->55410565],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->224268422]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Chop - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 29.7274148}", "context" -> "System`", 
    "keywords" -> {
     "errors", "numbers", "roundoff errors", "truncation of numbers", "zero", 
      "drop zeros", "comparing approximate numbers"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Chop[expr] replaces approximate real numbers in expr that are close to \
zero by the exact integer 0. ", "synonyms" -> {}, "title" -> "Chop", "type" -> 
    "Symbol", "uri" -> "ref/Chop"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5731, 186, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->728127220]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24820, 938}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2702, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3325, 88, 41, 1, 70, "ObjectName",
 CellID->3378],
Cell[3369, 91, 649, 20, 70, "Usage",
 CellID->32736]
}, Open  ]],
Cell[CellGroupData[{
Cell[4055, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4533, 133, 452, 16, 70, "Notes",
 CellID->31603],
Cell[4988, 151, 278, 11, 70, "Notes",
 CellID->28243],
Cell[5269, 164, 425, 17, 70, "Notes",
 CellID->924]
}, Closed]],
Cell[CellGroupData[{
Cell[5731, 186, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->728127220],
Cell[CellGroupData[{
Cell[6116, 200, 148, 5, 70, "ExampleSection",
 CellID->374469730],
Cell[6267, 207, 82, 1, 70, "ExampleText",
 CellID->17797],
Cell[CellGroupData[{
Cell[6374, 212, 233, 7, 28, "Input",
 CellID->23290],
Cell[6610, 221, 370, 11, 39, "Output",
 CellID->23758]
}, Open  ]],
Cell[CellGroupData[{
Cell[7017, 237, 96, 3, 28, "Input",
 CellID->30118],
Cell[7116, 242, 301, 9, 36, "Output",
 CellID->24918]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7466, 257, 216, 7, 70, "ExampleSection",
 CellID->28996],
Cell[7685, 266, 65, 1, 70, "ExampleText",
 CellID->3453],
Cell[CellGroupData[{
Cell[7775, 271, 194, 7, 70, "Input",
 CellID->8550],
Cell[7972, 280, 646, 18, 39, "Output",
 CellID->7005]
}, Open  ]],
Cell[CellGroupData[{
Cell[8655, 303, 96, 3, 70, "Input",
 CellID->32277],
Cell[8754, 308, 266, 9, 36, "Output",
 CellID->20226]
}, Open  ]],
Cell[9035, 320, 125, 3, 70, "ExampleDelimiter",
 CellID->245980387],
Cell[9163, 325, 89, 1, 70, "ExampleText",
 CellID->439937738],
Cell[CellGroupData[{
Cell[9277, 330, 244, 8, 70, "Input",
 CellID->63906541],
Cell[9524, 340, 467, 13, 58, "Output",
 CellID->75203687]
}, Open  ]],
Cell[CellGroupData[{
Cell[10028, 358, 168, 6, 70, "Input",
 CellID->76960985],
Cell[10199, 366, 420, 11, 36, "Output",
 CellID->205593019]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10668, 383, 222, 7, 70, "ExampleSection",
 CellID->3713],
Cell[10893, 392, 99, 1, 70, "ExampleText",
 CellID->406787404],
Cell[CellGroupData[{
Cell[11017, 397, 285, 10, 70, "Input",
 CellID->106189581],
Cell[11305, 409, 190, 6, 51, "Output",
 CellID->913566937]
}, Open  ]],
Cell[11510, 418, 222, 8, 70, "ExampleText",
 CellID->1011091435],
Cell[CellGroupData[{
Cell[11757, 430, 149, 5, 70, "Input",
 CellID->112357983],
Cell[11909, 437, 161, 5, 36, "Output",
 CellID->144687297]
}, Open  ]],
Cell[12085, 445, 217, 8, 70, "ExampleText",
 CellID->282461489],
Cell[CellGroupData[{
Cell[12327, 457, 222, 8, 70, "Input",
 CellID->465351253],
Cell[12552, 467, 161, 5, 36, "Output",
 CellID->44460557]
}, Open  ]],
Cell[12728, 475, 125, 3, 70, "ExampleDelimiter",
 CellID->428890279],
Cell[12856, 480, 226, 8, 70, "ExampleText",
 CellID->131194131],
Cell[CellGroupData[{
Cell[13107, 492, 455, 15, 70, "Input",
 CellID->390358882],
Cell[13565, 509, 307, 9, 39, "Output",
 CellID->113107270]
}, Open  ]],
Cell[13887, 521, 114, 3, 70, "ExampleText",
 CellID->160954763],
Cell[CellGroupData[{
Cell[14026, 528, 109, 3, 70, "Input",
 CellID->248923665],
Cell[14138, 533, 162, 5, 36, "Output",
 CellID->104129124]
}, Open  ]],
Cell[14315, 541, 95, 1, 70, "ExampleText",
 CellID->618663221],
Cell[CellGroupData[{
Cell[14435, 546, 140, 4, 70, "Input",
 CellID->121967413],
Cell[14578, 552, 161, 5, 36, "Output",
 CellID->100618559]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14788, 563, 233, 7, 70, "ExampleSection",
 CellID->17609],
Cell[15024, 572, 206, 8, 70, "ExampleText",
 CellID->285053166],
Cell[15233, 582, 1545, 48, 70, "Input",
 CellID->98135275],
Cell[CellGroupData[{
Cell[16803, 634, 346, 11, 70, "Input",
 CellID->47359929],
Cell[17152, 647, 373, 11, 39, "Output",
 CellID->16776996]
}, Open  ]],
Cell[CellGroupData[{
Cell[17562, 663, 100, 3, 70, "Input",
 CellID->830558734],
Cell[17665, 668, 282, 9, 36, "Output",
 CellID->260218662]
}, Open  ]],
Cell[CellGroupData[{
Cell[17984, 682, 100, 3, 70, "Input",
 CellID->107916047],
Cell[18087, 687, 282, 9, 36, "Output",
 CellID->504796513]
}, Open  ]],
Cell[18384, 699, 207, 7, 70, "ExampleText",
 CellID->383906539],
Cell[18594, 708, 311, 11, 70, "Input",
 CellID->59963569],
Cell[18908, 721, 188, 6, 70, "Input",
 CellID->415079680],
Cell[CellGroupData[{
Cell[19121, 731, 164, 5, 70, "Input",
 CellID->469954476],
Cell[19288, 738, 225, 7, 36, "Output",
 CellID->139167622]
}, Open  ]],
Cell[CellGroupData[{
Cell[19550, 750, 164, 5, 70, "Input",
 CellID->248758360],
Cell[19717, 757, 210, 7, 36, "Output",
 CellID->37560845]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19988, 771, 310, 9, 70, "SeeAlsoSection",
 CellID->3289],
Cell[20301, 782, 2154, 80, 70, "SeeAlso",
 CellID->11401]
}, Open  ]],
Cell[CellGroupData[{
Cell[22492, 867, 314, 9, 70, "TutorialsSection",
 CellID->24055],
Cell[22809, 878, 147, 3, 70, "Tutorials",
 CellID->5234]
}, Open  ]],
Cell[CellGroupData[{
Cell[22993, 886, 318, 9, 70, "MoreAboutSection",
 CellID->23557252],
Cell[23314, 897, 148, 3, 70, "MoreAbout",
 CellID->55410565],
Cell[23465, 902, 167, 3, 70, "MoreAbout",
 CellID->224268422]
}, Open  ]],
Cell[23647, 908, 27, 0, 70, "History"],
Cell[23677, 910, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

