(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14808,        524]
NotebookOptionsPosition[     11480,        414]
NotebookOutlinePosition[     12717,        450]
CellTagsIndexPosition[     12632,        445]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CirclePlus" :> 
          Documentation`HelpLookup["paclet:ref/CirclePlus"], "CircleTimes" :> 
          Documentation`HelpLookup["paclet:ref/CircleTimes"], "CircleDot" :> 
          Documentation`HelpLookup["paclet:ref/CircleDot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CirclePlus\"\>", 
       2->"\<\"CircleTimes\"\>", 3->"\<\"CircleDot\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "CircleMinus ",
     StyleBox["(\[CircleMinus])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CircleMinus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CircleMinus"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "\[CircleMinus]", "y"}], "\[CircleMinus]", 
        "\[Ellipsis]"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CircleMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleMinus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " has no built-in meaning."
}], "Notes",
 CellID->10989299],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[CircleMinus]", "y"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CircleMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleMinus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->237513406],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[CircleMinus]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 Cell[TextData[ButtonBox["\\[CircleMinus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CircleMinus"]], "InlineCharacterName"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]c-\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->246050499]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635688157],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->528992818],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CircleMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleMinus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is formatted as a binary operation with operator ",
 Cell[BoxData["\[CircleMinus]"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->119373489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CircleMinus", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14776008],

Cell[BoxData[
 RowBox[{"x", "\[CircleMinus]", "y"}]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180624959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129706444],

Cell[TextData[{
 "An input form using the ",
 Cell[BoxData["\[CircleMinus]"], "InlineFormula"],
 " operator is interpreted as ",
 Cell[BoxData[
  ButtonBox["CircleMinus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CircleMinus"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->37225701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[CircleMinus]", "y"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701888764],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CircleMinus", "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->428589399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70668113],

Cell["Add a definition for \[CircleMinus]:", "ExampleText",
 CellID->170507384],

Cell[BoxData[
 RowBox[{
  RowBox[{"CircleMinus", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Complement", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316162217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "\[CircleMinus]", 
  RowBox[{"{", 
   RowBox[{"1", ",", "4"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18536979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14294243]
}, Open  ]],

Cell["Clear definition: ", "ExampleText",
 CellID->153105287],

Cell[BoxData[
 RowBox[{"Clear", "[", "CircleMinus", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1028479901]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CirclePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CirclePlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircleTimes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleTimes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircleDot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleDot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CircleMinus (\[CircleMinus]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 30.3211800}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CircleMinus[x, y, ...] displays as x\\[CircleMinus]y\\[CircleMinus].... \
", "synonyms" -> {"circle minus"}, "title" -> "CircleMinus", "type" -> 
    "Symbol", "uri" -> "ref/CircleMinus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6321, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->635688157]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12489, 438}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1563, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2186, 64, 1656, 40, 70, "ObjectNameGrid"],
Cell[3845, 106, 749, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4631, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5109, 152, 339, 12, 70, "Notes",
 CellID->10989299],
Cell[5451, 166, 411, 15, 70, "Notes",
 CellID->237513406],
Cell[5865, 183, 419, 13, 70, "Notes",
 CellID->246050499]
}, Closed]],
Cell[CellGroupData[{
Cell[6321, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635688157],
Cell[CellGroupData[{
Cell[6706, 215, 148, 5, 70, "ExampleSection",
 CellID->528992818],
Cell[6857, 222, 387, 13, 70, "ExampleText",
 CellID->119373489],
Cell[CellGroupData[{
Cell[7269, 239, 129, 4, 28, "Input",
 CellID->14776008],
Cell[7401, 245, 193, 6, 36, "Output",
 CellID->180624959]
}, Open  ]],
Cell[7609, 254, 125, 3, 70, "ExampleDelimiter",
 CellID->129706444],
Cell[7737, 259, 307, 10, 70, "ExampleText",
 CellID->37225701],
Cell[CellGroupData[{
Cell[8069, 273, 136, 4, 70, "Input",
 CellID->701888764],
Cell[8208, 279, 354, 13, 50, "Output",
 CellID->428589399]
}, Open  ]],
Cell[8577, 295, 124, 3, 70, "ExampleDelimiter",
 CellID->70668113],
Cell[8704, 300, 79, 1, 70, "ExampleText",
 CellID->170507384],
Cell[8786, 303, 218, 7, 70, "Input",
 CellID->316162217],
Cell[CellGroupData[{
Cell[9029, 314, 218, 7, 70, "Input",
 CellID->18536979],
Cell[9250, 323, 202, 7, 36, "Output",
 CellID->14294243]
}, Open  ]],
Cell[9467, 333, 61, 1, 70, "ExampleText",
 CellID->153105287],
Cell[9531, 336, 112, 3, 70, "Input",
 CellID->1028479901]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9692, 345, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10011, 356, 712, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10760, 387, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11081, 398, 191, 4, 70, "Tutorials",
 CellID->341631938],
Cell[11275, 404, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[11423, 410, 27, 0, 70, "History"],
Cell[11453, 412, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

