(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14940,        526]
NotebookOptionsPosition[     11581,        416]
NotebookOutlinePosition[     12853,        452]
CellTagsIndexPosition[     12768,        447]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CircleMinus" :> 
          Documentation`HelpLookup["paclet:ref/CircleMinus"], "CircleTimes" :> 
          Documentation`HelpLookup["paclet:ref/CircleTimes"], "CircleDot" :> 
          Documentation`HelpLookup["paclet:ref/CircleDot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CircleMinus\"\>", 
       2->"\<\"CircleTimes\"\>", 3->"\<\"CircleDot\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "CirclePlus ",
     StyleBox["(\[CirclePlus])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CirclePlus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CirclePlus"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[CirclePlus]", "y", "\[CirclePlus]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CirclePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CirclePlus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " has no built-in meaning."
}], "Notes",
 CellID->10989299],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[CirclePlus]", "y"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CirclePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CirclePlus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->237513406],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 Cell[TextData[ButtonBox["\\[CirclePlus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CirclePlus"]], "InlineCharacterName"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]c+\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->246050499]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->240594070],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->258403274],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["CirclePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CirclePlus"]], "InlineFormula"],
 " expression is formatted as an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "-ary operation with operator ",
 Cell[BoxData["\[CirclePlus]"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->383378191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CirclePlus", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14776008],

Cell[BoxData[
 RowBox[{"x", "\[CirclePlus]", "y", "\[CirclePlus]", "z"}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->633951863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229076129],

Cell[TextData[{
 "Input using the ",
 Cell[BoxData["\[CirclePlus]"], "InlineFormula"],
 " operator is interpreted as a ",
 Cell[BoxData[
  ButtonBox["CirclePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CirclePlus"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->41753796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[CirclePlus]", "y", "\[CirclePlus]", "z"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154865979],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CirclePlus", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->82907933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3111047],

Cell["Add a definition to \[CirclePlus]: ", "ExampleText",
 CellID->51026929],

Cell[BoxData[
 RowBox[{
  RowBox[{"CirclePlus", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->780468918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[CirclePlus]", "0"}], ",", 
   RowBox[{"1", "\[CirclePlus]", "0"}], ",", 
   RowBox[{"0", "\[CirclePlus]", "1"}], ",", 
   RowBox[{"1", "\[CirclePlus]", "1"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->461167377],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52753975]
}, Open  ]],

Cell["Clear definition: ", "ExampleText",
 CellID->73506270],

Cell[BoxData[
 RowBox[{"Clear", "[", "CirclePlus", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404787799]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircleMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleMinus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircleTimes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleTimes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CircleDot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CircleDot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CirclePlus (\[CirclePlus]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 32.3524820}", "context" -> "System`", 
    "keywords" -> {"ring plus", "circle plus", "modular sum"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CirclePlus[x, y, ...] displays as x\\[CirclePlus]y\\[CirclePlus]....", 
    "synonyms" -> {"circle plus"}, "title" -> "CirclePlus", "type" -> 
    "Symbol", "uri" -> "ref/CirclePlus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6289, 200, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->240594070]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12625, 440}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1566, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2189, 64, 1654, 40, 70, "ObjectNameGrid"],
Cell[3846, 106, 724, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4607, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5085, 151, 337, 12, 70, "Notes",
 CellID->10989299],
Cell[5425, 165, 408, 15, 70, "Notes",
 CellID->237513406],
Cell[5836, 182, 416, 13, 70, "Notes",
 CellID->246050499]
}, Closed]],
Cell[CellGroupData[{
Cell[6289, 200, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->240594070],
Cell[CellGroupData[{
Cell[6674, 214, 148, 5, 70, "ExampleSection",
 CellID->258403274],
Cell[6825, 221, 373, 13, 70, "ExampleText",
 CellID->383378191],
Cell[CellGroupData[{
Cell[7223, 238, 138, 4, 28, "Input",
 CellID->14776008],
Cell[7364, 244, 214, 6, 36, "Output",
 CellID->633951863]
}, Open  ]],
Cell[7593, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->229076129],
Cell[7721, 258, 298, 10, 70, "ExampleText",
 CellID->41753796],
Cell[CellGroupData[{
Cell[8044, 272, 160, 5, 70, "Input",
 CellID->154865979],
Cell[8207, 279, 362, 13, 50, "Output",
 CellID->82907933]
}, Open  ]],
Cell[8584, 295, 123, 3, 70, "ExampleDelimiter",
 CellID->3111047],
Cell[8710, 300, 77, 1, 70, "ExampleText",
 CellID->51026929],
Cell[8790, 303, 235, 8, 70, "Input",
 CellID->780468918],
Cell[CellGroupData[{
Cell[9050, 315, 279, 8, 70, "Input",
 CellID->461167377],
Cell[9332, 325, 222, 7, 36, "Output",
 CellID->52753975]
}, Open  ]],
Cell[9569, 335, 60, 1, 70, "ExampleText",
 CellID->73506270],
Cell[9632, 338, 110, 3, 70, "Input",
 CellID->404787799]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9791, 347, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10110, 358, 714, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10861, 389, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11182, 400, 191, 4, 70, "Tutorials",
 CellID->341631938],
Cell[11376, 406, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[11524, 412, 27, 0, 70, "History"],
Cell[11554, 414, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

