(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    307857,       6956]
NotebookOptionsPosition[    288574,       6288]
NotebookOutlinePosition[    290049,       6328]
CellTagsIndexPosition[    289962,       6323]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CountryData" :> 
          Documentation`HelpLookup["paclet:ref/CountryData"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"CountryData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integrated Data Sources\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CityData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CityData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CityData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of the specified property for the city \
with the specified name."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CityData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CityData"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the full specifications of cities whose \
names are consistent with ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The full specification of a city is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"region\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"region\", \"TI\"]\)\>\""], "InlineFormula"],
 " is a state, province or other administrative division."
}], "Notes",
 CellID->92013167],

Cell[TextData[{
 "Names of cities, regions, and countries are given in standard forms, such \
as ",
 Cell[BoxData["\"\<NewYork\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<BritishColumbia\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<UnitedStates\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->93194075],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", "\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives a list of all available cities worldwide that use the name ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\""], "InlineFormula"],
 ", sorted in order of decreasing population."
}], "Notes",
 CellID->126336585],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " gives the full specifications for all available cities in the specified \
country that use the name ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\""], "InlineFormula"],
 ". The results are sorted in order of decreasing population. "
}], "Notes",
 CellID->11040761],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives the value of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""], "InlineFormula"],
 " for the city with the largest population in the given country that has the \
specified name."
}], "Notes",
 CellID->86814781],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"region\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives the value of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""], "InlineFormula"],
 " for the particular city represented by the full city specification ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"region\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->97519546],

Cell["\<\
If there is more than one city with a given name in a particular region and \
country, the standard name for that city will contain additional identifying \
information, such as a county name. \
\>", "Notes",
 CellID->7671498],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"city\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ss\", \"TI\"]\)\>\""}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be used to specify cities in particular states in the United States, \
such as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Springfield\>\"", ",", " ", "\"\<IL\>\""}], "}"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->267241996],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", "\"\<\!\(\*
StyleBox[\"region\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " gives a list of all available cities in the specified region of a country, \
sorted in order of decreasing population."
}], "Notes",
 CellID->71383191],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Large",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Large"], ",", "\"\<\!\(\*
StyleBox[\"region\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " gives a list of all large cities in the specified region.",
 " ",
 "Large cities are typically defined as having populations above 100,000."
}], "Notes",
 CellID->12057716],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Large",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Large"], ",", "\"\<\!\(\*
StyleBox[\"country\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " give all available cities and all large cities, respectively, in the \
specified country."
}], "Notes",
 CellID->403469145],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula"],
 " gives a list of all available cities in the world."
}], "Notes",
 CellID->657499313],

Cell["Typical properties for cities include:", "Notes",
 CellID->136617021],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Coordinates\>\"", Cell[
    "latitude, longitude for the city center", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Elevation\>\"", Cell[
    "elevation in meters of the city center", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Latitude\>\"", Cell[
    "latitude for the city center", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LocationLink\>\"", Cell[
    "URI for a map centered on the city", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Longitude\>\"", Cell[
    "longitude for the city center", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Population\>\"", Cell[
    "estimated total ordinary population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TimeZone\>\"", Cell[
    "current time zone relative to UTC", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->28424917],

Cell["Names and identification-related properties include:", "Notes",
 CellID->213119814],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlternateNames\>\"", Cell[
    "alternate names", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Country\>\"", Cell[
    "country in which the city lies", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FullName\>\"", Cell[TextData[{
     "primary full English name (e.g. ",
     Cell[BoxData["\"\<New York, NY\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[TextData[{
     "primary short English name (e.g. ",
     Cell[BoxData["\"\<New York\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Region\>\"", Cell[
    "state, province or other administrative division", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RegionName\>\"", Cell[
    "English or local name for region", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->274486316],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CityData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CityData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->276644756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Date\>\"", Cell[
    "date to which the data refers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[
    "the description of the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "special note about the property given", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Units\>\"", Cell[
    "units in which the value is given", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsName\>\"", Cell[
    "English name for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsNotation\>\"", Cell[
    "notation for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsStandardName\>\"", Cell[
    TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " standard name for the units used"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->469751789]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9282787],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->741076802],

Cell["\<\
Find all available cities in the world named London, sorted by decreasing \
population:\
\>", "ExampleText",
 CellID->586588777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", "\"\<London\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126439799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"London\"\>", ",", "\<\"England\"\>", 
     ",", "\<\"UnitedKingdom\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"London\"\>", ",", "\<\"Ontario\"\>", ",", "\<\"Canada\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"London\"\>", ",", "\<\"Ohio\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"London\"\>", ",", "\<\"Kentucky\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"London\"\>", ",", "\<\"California\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"London\"\>", ",", "\<\"Arkansas\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"London\"\>", ",", "\<\"Kiritimati\"\>", 
     ",", "\<\"Kiribati\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{480, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123324761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196956086],

Cell["Find the population of London, England:", "ExampleText",
 CellID->261335503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<London\>\"", ",", "\"\<Population\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32998443],

Cell[BoxData["7421209"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->834491093]
}, Open  ]],

Cell["Find the population of London, Ontario:", "ExampleText",
 CellID->512348210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<London\>\"", ",", "\"\<Ontario\>\"", ",", "\"\<Canada\>\""}],
     "}"}], ",", "\"\<Population\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599646084],

Cell[BoxData["346765"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30291230]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543518508],

Cell["\<\
Find the latitude and longitude of the center of London, England:\
\>", "ExampleText",
 CellID->263642772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<London\>\"", ",", "\"\<Coordinates\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62305198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"51.52`", ",", 
   RowBox[{"-", "0.1`"}]}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164833595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4969788],

Cell["Give English names for a city:", "ExampleText",
 CellID->110401064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<NewLondon\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557885358],

Cell[BoxData["\<\"New London\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117606852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<NewLondon\>\"", ",", "\"\<FullName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250442195],

Cell[BoxData["\<\"New London, Connecticut\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->357955357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12341576],

Cell["Large cities (of over 100,000) in Ireland:", "ExampleText",
 CellID->28976636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"Large", ",", "\"\<Ireland\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->734364217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Dublin\"\>", ",", "\<\"Dublin\"\>", ",", "\<\"Ireland\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cork\"\>", ",", "\<\"Cork\"\>", ",", "\<\"Ireland\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50606241]
}, Open  ]],

Cell["Large cities in Ohio:", "ExampleText",
 CellID->27620481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"Large", ",", "\"\<Ohio\>\"", ",", "\"\<UnitedStates\>\""}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->809016189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Columbus\"\>", ",", "\<\"Ohio\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cleveland\"\>", ",", "\<\"Ohio\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cincinnati\"\>", ",", "\<\"Ohio\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Toledo\"\>", ",", "\<\"Ohio\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Akron\"\>", ",", "\<\"Ohio\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dayton\"\>", ",", "\<\"Ohio\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->383705783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->425911365],

Cell["Find all available cities in Vanuatu:", "ExampleText",
 CellID->619402774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"All", ",", "\"\<Vanuatu\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->750760486],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Vila\"\>", ",", "\<\"Shefa\"\>", ",", "\<\"Vanuatu\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Luganville\"\>", ",", "\<\"Sanma\"\>", 
     ",", "\<\"Vanuatu\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Norsup\"\>", ",", "\<\"Malampa\"\>", 
     ",", "\<\"Vanuatu\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PortOlry\"\>", ",", "\<\"Sanma\"\>", 
     ",", "\<\"Vanuatu\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Isangel\"\>", ",", "\<\"Tafea\"\>", ",", "\<\"Vanuatu\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sola\"\>", ",", "\<\"Torba\"\>", ",", "\<\"Vanuatu\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Longana\"\>", ",", "\<\"Penama\"\>", 
     ",", "\<\"Vanuatu\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Lakatoro\"\>", ",", "\<\"Malampa\"\>", 
     ",", "\<\"Vanuatu\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21291066]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  InterpretationBox[Cell[TextData[{
    "City Names & Identification",
    "\[NonBreakingSpace]\[NonBreakingSpace]",
    Cell["(6)", "ExampleCount"]
   }], "ExampleSubsection"],
   $Line = 0; Null], " "}]], "ExampleSubsection",
 CellID->101890143],

Cell[TextData[{
 "Standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " names omit all spaces:"
}], "ExampleText",
 CellID->706936007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", "\"\<LosAngeles\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64217807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"LosAngeles\"\>", ",", "\<\"California\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LosAngeles\"\>", ",", "\<\"BioBio\"\>", 
     ",", "\<\"Chile\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LosAngeles\"\>", ",", "\<\"Caraga\"\>", 
     ",", "\<\"Philippines\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1131204]
}, Open  ]],

Cell["Cities can be requested using names that contain spaces:", "ExampleText",
 CellID->582824772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", "\"\<Los Angeles\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79734037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"LosAngeles\"\>", ",", "\<\"California\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LosAngeles\"\>", ",", "\<\"BioBio\"\>", 
     ",", "\<\"Chile\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"LosAngeles\"\>", ",", "\<\"Caraga\"\>", 
     ",", "\<\"Philippines\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304831961]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Name\>\""], "InlineFormula"],
 " property gives traditional names, with spaces:"
}], "ExampleText",
 CellID->174304696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<LosAngeles\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->147605353],

Cell[BoxData["\<\"Los Angeles\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->307711868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133923449],

Cell["Specify the Los Angeles in Chile:", "ExampleText",
 CellID->5628488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<LosAngeles\>\"", ",", "\"\<Chile\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109407644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"LosAngeles\"\>", ",", "\<\"BioBio\"\>", ",", "\<\"Chile\"\>"}],
   "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451907455]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69862915],

Cell["All available cities named Fresno in the world:", "ExampleText",
 CellID->127823120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", "\"\<Fresno\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461009226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Fresno\"\>", ",", "\<\"California\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Fresno\"\>", ",", "\<\"Tolima\"\>", 
     ",", "\<\"Colombia\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Fresno\"\>", ",", "\<\"Texas\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ElFresno\"\>", ",", "\<\"Avila\"\>", ",", "\<\"Spain\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84868055]
}, Open  ]],

Cell["Cities in the U.S. named Fresno:", "ExampleText",
 CellID->334224336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Fresno\>\"", ",", "\"\<UnitedStates\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11802462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Fresno\"\>", ",", "\<\"California\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Fresno\"\>", ",", "\<\"Texas\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{459, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193216645]
}, Open  ]],

Cell["Specify Fresno, Texas:", "ExampleText",
 CellID->106507505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Fresno\>\"", ",", "\"\<TX\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->105777901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Fresno\"\>", ",", "\<\"Texas\"\>", 
   ",", "\<\"UnitedStates\"\>"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->39730402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246261828],

Cell["\<\
Multiple cities with the same name in a state are identified by county or \
other information:\
\>", "ExampleText",
 CellID->34923962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Jefferson\>\"", ",", "\"\<Wisconsin\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211029415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Jefferson\"\>", ",", "\<\"Wisconsin\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"JeffersonGreen\"\>", ",", "\<\"Wisconsin\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"JeffersonVernon\"\>", ",", "\<\"Wisconsin\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"JeffersonMonroe\"\>", ",", "\<\"Wisconsin\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{557, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587828767]
}, Open  ]],

Cell["The basic names are the same:", "ExampleText",
 CellID->3092209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CityData", "[", 
    RowBox[{"#", ",", "\"\<Name\>\""}], "]"}], "&"}], "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27051229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Jefferson\"\>", ",", "\<\"Jefferson\"\>", 
   ",", "\<\"Jefferson\"\>", ",", "\<\"Jefferson\"\>"}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168140913]
}, Open  ]],

Cell["\<\
The full names of the smaller cities contain county information:\
\>", "ExampleText",
 CellID->36100077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CityData", "[", 
    RowBox[{"#", ",", "\"\<FullName\>\""}], "]"}], "&"}], "/@", 
  "%%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->235632346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Jefferson, Wisconsin\"\>", 
   ",", "\<\"Jefferson (Green), Wisconsin\"\>", 
   ",", "\<\"Jefferson (Vernon), Wisconsin\"\>", 
   ",", "\<\"Jefferson (Monroe), Wisconsin\"\>"}], "}"}]], "Output",
 ImageSize->{436, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->335423557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->977682331],

Cell["Find alternate names for Beijing:", "ExampleText",
 CellID->416350756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<Beijing\>\"", ",", "\"\<AlternateNames\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->335061581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Beijing\"\>", ",", "\<\"Peking\"\>", 
   ",", "\<\"P\[EAcute]kin\"\>", ",", "\<\"Pek\[IAcute]n\"\>"}], 
  "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523464641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185437537],

Cell["\<\
There is no known city with the name Frog anywhere in the world:\
\>", "ExampleText",
 CellID->215414749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", "\"\<Frog\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499172160],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->869825570]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Collections of Cities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->676208838],

Cell["Find all available cities in Tuvalu:", "ExampleText",
 CellID->416011143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"All", ",", "\"\<Tuvalu\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106419545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Vaiaku\"\>", ",", "\<\"Funafuti\"\>", 
     ",", "\<\"Tuvalu\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Lolua\"\>", ",", "\<\"Nanumea\"\>", ",", "\<\"Tuvalu\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Asau\"\>", ",", "\<\"Vaitupu\"\>", ",", "\<\"Tuvalu\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Savave\"\>", ",", "\<\"Nukufetau\"\>", 
     ",", "\<\"Tuvalu\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Kua\"\>", ",", "\<\"Niutao\"\>", ",", "\<\"Tuvalu\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Tanrake\"\>", ",", "\<\"Nui\"\>", ",", "\<\"Tuvalu\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Tonga\"\>", ",", "\<\"Nanumanga\"\>", 
     ",", "\<\"Tuvalu\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Fangaua\"\>", ",", "\<\"Nukulaelae\"\>", 
     ",", "\<\"Tuvalu\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{535, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23102302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310275228],

Cell["Find large cities (population above 100,000) in Belgium:", "ExampleText",
 CellID->31433621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"Large", ",", "\"\<Belgium\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17746772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Brussels\"\>", ",", "\<\"Brussels\"\>", 
     ",", "\<\"Belgium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Antwerp\"\>", ",", "\<\"Antwerp\"\>", 
     ",", "\<\"Belgium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Gent\"\>", ",", "\<\"EastFlanders\"\>", 
     ",", "\<\"Belgium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Charleroi\"\>", ",", "\<\"Hainaut\"\>", 
     ",", "\<\"Belgium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Liege\"\>", ",", "\<\"Liege\"\>", ",", "\<\"Belgium\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Brugge\"\>", ",", "\<\"WestFlanders\"\>", 
     ",", "\<\"Belgium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Namur\"\>", ",", "\<\"Namur\"\>", ",", "\<\"Belgium\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{563, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216623511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CityData", "[", 
    RowBox[{"#", ",", "\"\<Population\>\""}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->221569772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1019022", ",", "459805", ",", "231493", ",", "200132", ",", "182597", ",", 
   "116709", ",", "106284"}], "}"}]], "Output",
 ImageSize->{404, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->182765259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259611172],

Cell["Find all available cities in the state of Illinois:", "ExampleText",
 CellID->307981279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CityData", "[", 
   RowBox[{"{", 
    RowBox[{"All", ",", "\"\<Illinois\>\"", ",", "\"\<UnitedStates\>\""}], 
    "}"}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198109053],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Chicago\"\>", ",", "\<\"Illinois\"\>", 
      ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "1310", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Kaskaskia\"\>", ",", "\<\"Illinois\"\>", 
      ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{562, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->41731139]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "City Information",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65997959],

Cell["The coordinates of the center of Chicago:", "ExampleText",
 CellID->25384182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<Chicago\>\"", ",", "\"\<Coordinates\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->590927930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"41.840675`", ",", 
   RowBox[{"-", "87.679365`"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445188676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1728610334],

Cell["The elevation of Chicago in meters:", "ExampleText",
 CellID->1430184768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<Chicago\>\"", ",", "\"\<Elevation\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330934905],

Cell[BoxData["179"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453051384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->659365943],

Cell["A link to a web-based map of the city:", "ExampleText",
 CellID->1595106922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<Chicago\>\"", ",", "\"\<LocationLink\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->947785481],

Cell[BoxData["\<\"http://maps.google.com/maps?q=+41.8407-87.6794&z=12&t=h\"\>\
"], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1605082273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134912517],

Cell["The region in which Chicago lies:", "ExampleText",
 CellID->671533505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\"\<Chicago\>\"", ",", "\"\<Region\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->867676606],

Cell[BoxData["\<\"Illinois\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187301664]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Create a function to find the nearest large cities to a given position in the \
U.S.:\
\>", "ExampleText",
 CellID->99443403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nc", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CityData", "[", 
       RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "\[Rule]", "#"}], 
     "&"}], "/@", 
    RowBox[{"CityData", "[", 
     RowBox[{"{", 
      RowBox[{"Large", ",", "\"\<UnitedStates\>\""}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312938027],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"272", ",", "2"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252676805]
}, Open  ]],

Cell["Find the 3 large cities nearest Champaign, Illinois:", "ExampleText",
 CellID->284489533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nc", "[", 
  RowBox[{
   RowBox[{"CityData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Champaign\>\"", ",", "\"\<Illinois\>\""}], "}"}], ",", 
     "\"\<Coordinates\>\""}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340077948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Springfield\"\>", ",", "\<\"Illinois\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Joliet\"\>", ",", "\<\"Illinois\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Peoria\"\>", ",", "\<\"Illinois\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{466, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->341888171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->926990457],

Cell["Plot the positions of all available cities in Japan:", "ExampleText",
 CellID->17772098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Reverse", "[", 
     RowBox[{"CityData", "[", 
      RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{"CityData", "[", 
    RowBox[{"{", 
     RowBox[{"All", ",", "\"\<Japan\>\""}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137007917],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{301, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150351789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284797],

Cell["Find city names that occur in both Germany and Belgium:", "ExampleText",
 CellID->1991734125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"First", "/@", 
    RowBox[{"CityData", "[", 
     RowBox[{"{", 
      RowBox[{"All", ",", "\"\<Germany\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"First", "/@", 
    RowBox[{"CityData", "[", 
     RowBox[{"{", 
      RowBox[{"All", ",", "\"\<Belgium\>\""}], "}"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395177084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Alken\"\>", ",", "\<\"Bocholt\"\>", ",", "\<\"Brakel\"\>", 
   ",", "\<\"Brecht\"\>", ",", "\<\"Brugge\"\>", ",", "\<\"Damme\"\>", 
   ",", "\<\"Essen\"\>", ",", "\<\"Halle\"\>", ",", "\<\"Herne\"\>", 
   ",", "\<\"Huy\"\>", ",", "\<\"Melle\"\>", ",", "\<\"Wellen\"\>"}], 
  "}"}]], "Output",
 ImageSize->{324, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68324136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->437659313],

Cell["\<\
Make a rank plot of the populations of cities in several U.S. states:\
\>", "ExampleText",
 CellID->17649571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Reverse", "[", 
     RowBox[{"Sort", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CityData", "[", 
         RowBox[{"#", ",", "\"\<Population\>\""}], "]"}], "&"}], "/@", 
       RowBox[{"CityData", "[", 
        RowBox[{"{", 
         RowBox[{"All", ",", "#"}], "}"}], "]"}]}], "]"}], "]"}], "&"}], "/@",
    
   RowBox[{"{", 
    RowBox[{
    "\"\<Alabama\>\"", ",", "\"\<Alaska\>\"", ",", "\"\<Arizona\>\"", ",", 
     "\"\<Arkansas\>\"", ",", "\"\<California\>\""}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->201814535],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5937832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25127873],

Cell["\<\
Plot the large cities in Australia, with tooltips for their names:\
\>", "ExampleText",
 CellID->400379279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"CountryData", "[", 
     RowBox[{"\"\<Australia\>\"", ",", "\"\<Polygon\>\""}], "]"}], ",", 
    RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"Reverse", "[", 
          RowBox[{"CityData", "[", 
           RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "]"}], "]"}], 
        ",", 
        RowBox[{"CityData", "[", 
         RowBox[{"#", ",", "\"\<Name\>\""}], "]"}]}], "]"}], "&"}], "/@", 
     RowBox[{"CityData", "[", 
      RowBox[{"{", 
       RowBox[{"Large", ",", "\"\<Australia\>\""}], "}"}], "]"}]}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->746612128],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], PolygonBox[{CompressedData["
1:eJxMXXe8luMbTwhtDSSU9e55Oud0zjF6zJCUpJLzLipRdikNSdqlqaEltIf2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      "], CompressedData["
1:eJxNWXlcV8X6RvJa5lK5gkuuAS64ZVaiOMoZxS0l3NccFxDFDUU2QVxAcRcF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      "]}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], 
    TagBox[
     TooltipBox[PointBox[{151.21, -33.87}],
      "\"Sydney\""],
     Annotation[#, "Sydney", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{144.96, -37.81}],
      "\"Melbourne\""],
     Annotation[#, "Melbourne", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{153.02, -27.46}],
      "\"Brisbane\""],
     Annotation[#, "Brisbane", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{115.84, -31.96}],
      "\"Perth\""],
     Annotation[#, "Perth", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{138.6, -34.93}],
      "\"Adelaide\""],
     Annotation[#, "Adelaide", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{153.44, -28.07}],
      "\"Gold Coast\""],
     Annotation[#, "Gold Coast", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{151.75, -32.92}],
      "\"Newcastle\""],
     Annotation[#, "Newcastle", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{149.13, -35.31}],
      "\"Canberra\""],
     Annotation[#, "Canberra", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{152.56, -25.88}],
      "\"Sunshine Coast\""],
     Annotation[#, "Sunshine Coast", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{150.87, -34.42}],
      "\"Wollongong\""],
     Annotation[#, "Wollongong", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{147.29, -42.85}],
      "\"Hobart\""],
     Annotation[#, "Hobart", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{145.75, -16.92}],
      "\"Cairns\""],
     Annotation[#, "Cairns", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{144.32, -38.14}],
      "\"Geelong\""],
     Annotation[#, "Geelong", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{146.78, -19.26}],
      "\"Townsville\""],
     Annotation[#, "Townsville", "Tooltip"]& ], 
    TagBox[
     TooltipBox[PointBox[{146.92000000000002`, -36.06}],
      "\"Albury\""],
     Annotation[#, "Albury", "Tooltip"]& ]}}]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51452194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56990423],

Cell["Plot larger cities with larger, transparent, disks:", "ExampleText",
 CellID->488890987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"CountryData", "[", 
     RowBox[{"\"\<NewZealand\>\"", ",", "\"\<Polygon\>\""}], "]"}], ",", 
    RowBox[{"Opacity", "[", 
     RowBox[{"0.3", ",", "Blue"}], "]"}], ",", 
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"Reverse", "[", 
           RowBox[{"CityData", "[", 
            RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "]"}], ",", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"10.", "^", "9"}], ",", 
            RowBox[{"CityData", "[", 
             RowBox[{"#", ",", "\"\<Population\>\""}], "]"}]}], "]"}]}], 
         "]"}], "&"}], "/@", 
       RowBox[{"CityData", "[", 
        RowBox[{"{", 
         RowBox[{"All", ",", "\"\<NewZealand\>\""}], "}"}], "]"}]}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", "__Real", "}"}], ",", "_Real"}], "]"}]}], "]"}]}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7696966],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229039034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53404250],

Cell["\<\
Find a traveling salesman tour of the large cities in Germany:\
\>", "ExampleText",
 CellID->22383061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"CountryData", "[", 
     RowBox[{"\"\<Germany\>\"", ",", "\"\<Polygon\>\""}], "]"}], ",", "Thick",
     ",", "Green", ",", 
    RowBox[{"Line", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", 
         RowBox[{"Last", "[", 
          RowBox[{"FindShortestTour", "[", "#", "]"}], "]"}], "]"}], "]"}], 
       "&"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Reverse", "[", 
         RowBox[{"CityData", "[", 
          RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "]"}], "&"}], "/@",
        
       RowBox[{"CityData", "[", 
        RowBox[{"{", 
         RowBox[{"Large", ",", "\"\<Germany\>\""}], "}"}], "]"}]}], "]"}], 
     "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191301156],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65119437]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->833950944],

Cell["\<\
Make a 3D contour map of Colorado based on the elevations of its cities:\
\>", "ExampleText",
 CellID->366290712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CityData", "[", 
        RowBox[{"#", ",", "\"\<Longitude\>\""}], "]"}], ",", 
       RowBox[{"CityData", "[", 
        RowBox[{"#", ",", "\"\<Latitude\>\""}], "]"}], ",", 
       RowBox[{"CityData", "[", 
        RowBox[{"#", ",", "\"\<Elevation\>\""}], "]"}]}], "}"}], "&"}], "/@", 
    
    RowBox[{"CityData", "[", 
     RowBox[{"{", 
      RowBox[{"All", ",", "\"\<Colorado\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Topographic\>\""}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#3", "&"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35878671],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{316, 253},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277023358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26011022],

Cell["\<\
Make a scatter plot of population versus elevation for cities in Colorado:\
\>", "ExampleText",
 CellID->351195181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CityData", "[", 
       RowBox[{"#", ",", "\"\<Elevation\>\""}], "]"}], ",", 
      RowBox[{"CityData", "[", 
       RowBox[{"#", ",", "\"\<Population\>\""}], "]"}]}], "}"}], "&"}], "/@", 
   
   RowBox[{"CityData", "[", 
    RowBox[{"{", 
     RowBox[{"All", ",", "\"\<Colorado\>\"", ",", "\"\<UnitedStates\>\""}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49025323],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{251, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251611283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CityData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CityData"]], "InlineFormula"],
 " gives cities listed in order of decreasing population:"
}], "ExampleText",
 CellID->356958269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"CityData", "[", 
    RowBox[{"{", 
     RowBox[{"All", ",", "\"\<Albania\>\""}], "}"}], "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->507461611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Tirana\"\>", ",", "\<\"Tirana\"\>", ",", "\<\"Albania\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Durres\"\>", ",", "\<\"Durres\"\>", ",", "\<\"Albania\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Elbasan\"\>", ",", "\<\"Elbasan\"\>", 
     ",", "\<\"Albania\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Vlore\"\>", ",", "\<\"Vlore\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Shkoder\"\>", ",", "\<\"Shkoder\"\>", 
     ",", "\<\"Albania\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Fier\"\>", ",", "\<\"Fier\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Korce\"\>", ",", "\<\"Korce\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Berat\"\>", ",", "\<\"Berat\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Lushnje\"\>", ",", "\<\"Lushnje\"\>", 
     ",", "\<\"Albania\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Kavaje\"\>", ",", "\<\"Kavaje\"\>", ",", "\<\"Albania\"\>"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{563, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69025108]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 " can give the largest cities in a country:"
}], "ExampleText",
 CellID->37897459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Albania\>\"", ",", "\"\<LargestCities\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->326026137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Tirana\"\>", ",", "\<\"Tirana\"\>", ",", "\<\"Albania\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Durres\"\>", ",", "\<\"Durres\"\>", ",", "\<\"Albania\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Elbasan\"\>", ",", "\<\"Elbasan\"\>", 
     ",", "\<\"Albania\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Vlore\"\>", ",", "\<\"Vlore\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Shkoder\"\>", ",", "\<\"Shkoder\"\>", 
     ",", "\<\"Albania\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Fier\"\>", ",", "\<\"Fier\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Korce\"\>", ",", "\<\"Korce\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Berat\"\>", ",", "\<\"Berat\"\>", ",", "\<\"Albania\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Lushnje\"\>", ",", "\<\"Lushnje\"\>", 
     ",", "\<\"Albania\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Kavaje\"\>", ",", "\<\"Kavaje\"\>", ",", "\<\"Albania\"\>"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{563, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15375070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79158946],

Cell["\<\
Make a Lambert azimuthal projection map, centered on New York City:\
\>", "ExampleText",
 CellID->103797875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<SchematicPolygon\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<LambertAzimuthal\>\"", ",", 
            RowBox[{"CityData", "[", 
             RowBox[{"\"\<NewYork\>\"", ",", "\"\<Coordinates\>\""}], "]"}]}],
            "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488128011],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446175253]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CityData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CityData"]], "InlineFormula"],
 " includes only complete cities, not parts of cities:"
}], "ExampleText",
 CellID->160800538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", "\"\<Manhattan\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78193026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Manhattan\"\>", ",", "\<\"Kansas\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Manhattan\"\>", ",", "\<\"Illinois\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Manhattan\"\>", ",", "\<\"Montana\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{501, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5530327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402278008],

Cell["\<\
Sometimes the name of a city, region and country can all be the same:\
\>", "ExampleText",
 CellID->57260276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", "\"\<Singapore\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357916792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Singapore\"\>", ",", "\<\"Singapore\"\>", 
   ",", "\<\"Singapore\"\>"}], "}"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251721997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45442980],

Cell["\<\
There can be multiple cities in one state with the same name:\
\>", "ExampleText",
 CellID->169860158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Kendall\>\"", ",", "\"\<Wisconsin\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46289561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Kendall\"\>", ",", "\<\"Wisconsin\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"KendallLafayette\"\>", ",", "\<\"Wisconsin\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{557, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448048132]
}, Open  ]],

Cell["\<\
The smaller ones have county or other identifying information:\
\>", "ExampleText",
 CellID->275495289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CityData", "[", 
    RowBox[{"#", ",", "\"\<FullName\>\""}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->836622504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Kendall, Wisconsin\"\>", 
   ",", "\<\"Kendall (Lafayette), Wisconsin\"\>"}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->904811086]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Find the 10 most common city names in the world:", "ExampleText",
 CellID->336349540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{
     RowBox[{"Tally", "[", 
      RowBox[{"First", "/@", 
       RowBox[{"CityData", "[", "]"}]}], "]"}], ",", "Last"}], "]"}], ",", 
   RowBox[{"-", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531961307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Victoria\"\>", ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SanFrancisco\"\>", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SanVicente\"\>", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SantaMaria\"\>", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SanAntonio\"\>", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SantaCruz\"\>", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SanJuan\"\>", ",", "39"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SanMiguel\"\>", ",", "41"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SanIsidro\"\>", ",", "46"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SanJose\"\>", ",", "55"}], "}"}]}], "}"}]], "Output",
 ImageSize->{433, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237105490]
}, Open  ]],

Cell["Find the countries where cities named San Jose exist:", "ExampleText",
 CellID->27566907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"Last", "/@", 
   RowBox[{"CityData", "[", "\"\<SanJose\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84167453],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"UnitedStates\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CostaRica\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Philippines\"\>", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Uruguay\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Guatemala\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Spain\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Bolivia\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Peru\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Colombia\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Honduras\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"NorthernMarianaIslands\"\>", ",", "2"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{448, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225495074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274478476],

Cell["\<\
Find the city names that appear in the largest number of different countries:\
\
\>", "ExampleText",
 CellID->155121875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], "\[Rule]", 
        RowBox[{"Union", "[", 
         RowBox[{"Last", "/@", "#"}], "]"}]}], "&"}], "/@", 
      RowBox[{"Split", "[", 
       RowBox[{
        RowBox[{"Sort", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Drop", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", "2", "}"}]}], "]"}], "&"}], "/@", 
          RowBox[{"CityData", "[", "]"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "&"}]}], "]"}], ",", 
   RowBox[{"-", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39960110],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"SanPedro\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Argentina\"\>", ",", "\<\"Belize\"\>", 
      ",", "\<\"Bolivia\"\>", ",", "\<\"Colombia\"\>", 
      ",", "\<\"CostaRica\"\>", ",", "\<\"Honduras\"\>", 
      ",", "\<\"IvoryCoast\"\>", ",", "\<\"Mexico\"\>", 
      ",", "\<\"Nicaragua\"\>", ",", "\<\"Philippines\"\>", 
      ",", "\<\"Spain\"\>", ",", "\<\"UnitedStates\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"SantaAna\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Bolivia\"\>", ",", "\<\"Colombia\"\>", 
      ",", "\<\"CostaRica\"\>", ",", "\<\"Ecuador\"\>", 
      ",", "\<\"ElSalvador\"\>", ",", "\<\"Guatemala\"\>", 
      ",", "\<\"Honduras\"\>", ",", "\<\"Mexico\"\>", ",", "\<\"Peru\"\>", 
      ",", "\<\"Philippines\"\>", ",", "\<\"Spain\"\>", 
      ",", "\<\"UnitedStates\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"SantaRosa\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Argentina\"\>", ",", "\<\"Bolivia\"\>", 
      ",", "\<\"Brazil\"\>", ",", "\<\"Colombia\"\>", 
      ",", "\<\"CostaRica\"\>", ",", "\<\"Ecuador\"\>", 
      ",", "\<\"Honduras\"\>", ",", "\<\"Paraguay\"\>", ",", "\<\"Peru\"\>", 
      ",", "\<\"Philippines\"\>", ",", "\<\"UnitedStates\"\>", 
      ",", "\<\"Uruguay\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"Victoria\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Argentina\"\>", ",", "\<\"Canada\"\>", ",", "\<\"Chile\"\>",
       ",", "\<\"Colombia\"\>", ",", "\<\"ElSalvador\"\>", 
      ",", "\<\"Grenada\"\>", ",", "\<\"Honduras\"\>", ",", "\<\"Mexico\"\>", 
      ",", "\<\"Philippines\"\>", ",", "\<\"Romania\"\>", 
      ",", "\<\"Seychelles\"\>", ",", "\<\"UnitedStates\"\>"}], "}"}]}], ",", 
   
   RowBox[{"\<\"SantaMaria\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Brazil\"\>", ",", "\<\"CapeVerde\"\>", ",", "\<\"Chile\"\>",
       ",", "\<\"Colombia\"\>", ",", "\<\"CostaRica\"\>", 
      ",", "\<\"Honduras\"\>", ",", "\<\"Nicaragua\"\>", 
      ",", "\<\"Panama\"\>", ",", "\<\"Paraguay\"\>", ",", "\<\"Peru\"\>", 
      ",", "\<\"Philippines\"\>", ",", "\<\"Romania\"\>", 
      ",", "\<\"UnitedStates\"\>"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{506, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273780469]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1399755],

Cell["\<\
Find the number of cities with shared named between all countries:\
\>", "ExampleText",
 CellID->32561020],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"First", "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Last", "[", 
       RowBox[{"Reap", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Sow", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "&"}], "/@", 
          RowBox[{"CityData", "[", "]"}]}], ",", 
         RowBox[{"CountryData", "[", "]"}]}], "]"}], "]"}], "/.", 
      RowBox[{
       RowBox[{"{", "}"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", "}"}], "}"}]}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30325159],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"ReplacePart", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"Intersection", "[", "##", "]"}], "]"}], "&"}], ",", "d", 
       ",", "d", ",", "1"}], "]"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x_", ",", "x_"}], "}"}], "\[Rule]", "0"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->299246960],

Cell["Plot a matrix of shared city names:", "ExampleText",
 CellID->83445278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->754290440],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnX/sl1W9wOHLb0EHXEn/iK+iY1BJaq6Um+uL6DSnDazhFEdfEwRvNyfL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   "], {{0, 0}, {237, 237}}, {0, 5.948034989180646}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageSize->{142., Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{146, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->318370495]
}, Open  ]],

Cell["Find clusters of countries that share many city names:", "ExampleText",
 CellID->680329877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"FindClusters", "[", 
   RowBox[{
    RowBox[{"Thread", "[", 
     RowBox[{"m", "\[Rule]", 
      RowBox[{"CountryData", "[", "]"}]}], "]"}], ",", "5"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->326777908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Argentina\"\>", ",", "\<\"Bolivia\"\>", 
     ",", "\<\"Brazil\"\>", ",", "\<\"Chile\"\>", ",", "\<\"CostaRica\"\>", 
     ",", "\<\"Ecuador\"\>", ",", "\<\"ElSalvador\"\>", 
     ",", "\<\"Guatemala\"\>", ",", "\<\"Honduras\"\>", 
     ",", "\<\"Nicaragua\"\>", ",", "\<\"Panama\"\>", ",", "\<\"Paraguay\"\>",
      ",", "\<\"Peru\"\>", ",", "\<\"Uruguay\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Australia\"\>", ",", "\<\"India\"\>", ",", "\<\"Ireland\"\>",
      ",", "\<\"Jamaica\"\>", ",", "\<\"NewZealand\"\>", 
     ",", "\<\"Russia\"\>", ",", "\<\"SouthAfrica\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Canada\"\>", ",", "\<\"France\"\>", ",", "\<\"Germany\"\>", 
     ",", "\<\"Italy\"\>", ",", "\<\"Switzerland\"\>", 
     ",", "\<\"UnitedKingdom\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Colombia\"\>", ",", "\<\"Mexico\"\>", 
     ",", "\<\"Philippines\"\>", ",", "\<\"Spain\"\>", 
     ",", "\<\"UnitedStates\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{485, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->689967469]
}, Open  ]],

Cell["\<\
Find the maximum number of cities shared between two countries:\
\>", "ExampleText",
 CellID->33658139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "m", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29429918],

Cell[BoxData["382"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->98250452]
}, Open  ]],

Cell["Find for which countries this is the case:", "ExampleText",
 CellID->597848994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CountryData", "[", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"First", "[", 
    RowBox[{"Position", "[", 
     RowBox[{"m", ",", "%"}], "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->35461367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"UnitedKingdom\"\>", ",", "\<\"UnitedStates\"\>"}], 
  "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->492950815]
}, Open  ]],

Cell["\<\
Make a network of countries that share more than 50 city names:\
\>", "ExampleText",
 CellID->48916817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Rule", "@@@", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CountryData", "[", "]"}], "[", 
        RowBox[{"[", "#", "]"}], "]"}], "&"}], ",", 
      RowBox[{"Union", "[", 
       RowBox[{"Sort", "/@", 
        RowBox[{"Position", "[", 
         RowBox[{"m", ",", 
          RowBox[{"x_", "/;", 
           RowBox[{"x", ">", "50"}]}]}], "]"}]}], "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->960379822],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.6095253921146355`, -0.41556263969305585`}, {
    0.9680961381450528, -0.5243366667989195}, {
    1.5435373135602188`, -1.7237163871524048`}, {
    0.4155626396930555, -2.3348112650646518`}, {
    0.6191899609014732, -1.899119122774982}, {
    0.7810916693248778, -2.694992623141341}, {
    1.3346765604403088`, -2.3891216825738106`}, {
    2.5351788756164004`, -2.1353188967162335`}, {
    2.884384393920378, -1.5112238685240456`}, {
    2.301457144118087, -2.8007470007069797`}, {
    3.6792205136782288`, -1.910916348262184}, {
    1.4155626396930556`, -3.631872280182884}, {
    0.4155626396930556, -3.631872280093091}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 3}, {4, 5}, {4, 6}, {4, 7}, {4, 3}, {5, 
       6}, {5, 7}, {5, 3}, {6, 7}, {6, 3}, {7, 3}, {8, 9}, {8, 10}, {8, 7}, {
       8, 11}, {8, 3}, {9, 11}, {9, 3}, {10, 3}, {12, 13}}]}, {InsetBox[
       FrameBox["\<\"Canada\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"UnitedKingdom\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"UnitedStates\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"Colombia\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"Mexico\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"Philippines\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"Spain\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"France\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"Germany\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"Italy\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["\<\"Switzerland\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["\<\"Russia\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["\<\"Ukraine\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.6095253921146355`, -0.41556263969305585`}, {
     0.9680961381450528, -0.5243366667989195}, {
     1.5435373135602188`, -1.7237163871524048`}, {
     0.4155626396930555, -2.3348112650646518`}, {
     0.6191899609014732, -1.899119122774982}, {
     0.7810916693248778, -2.694992623141341}, {
     1.3346765604403088`, -2.3891216825738106`}, {
     2.5351788756164004`, -2.1353188967162335`}, {
     2.884384393920378, -1.5112238685240456`}, {
     2.301457144118087, -2.8007470007069797`}, {
     3.6792205136782288`, -1.910916348262184}, {
     1.4155626396930556`, -3.631872280182884}, {
     0.4155626396930556, -3.631872280093091}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{324., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{328, 319},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->260159425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22683820],

Cell["\<\
Find the capital cities in the world with the smallest recorded populations:\
\>", "ExampleText",
 CellID->286757361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CountryData", "[", 
        RowBox[{"#", ",", "\"\<CapitalCity\>\""}], "]"}], "&"}], "/@", 
      RowBox[{"CountryData", "[", "]"}]}], ",", 
     RowBox[{
      RowBox[{"CityData", "[", 
       RowBox[{"#", ",", "\"\<Population\>\""}], "]"}], "&"}]}], "]"}], ",", 
   "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12477490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Jamestown\"\>", ",", "\<\"SaintHelena\"\>", 
     ",", "\<\"SaintHelena\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Hamilton\"\>", ",", "\<\"Hamilton\"\>", 
     ",", "\<\"Bermuda\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"MonacoVille\"\>", ",", "\<\"MonacoVille\"\>", 
     ",", "\<\"Monaco\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Longyearbyen\"\>", ",", "\<\"Svalbard\"\>", 
     ",", "\<\"Svalbard\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Matautu\"\>", ",", "\<\"Hahake\"\>", 
     ",", "\<\"WallisFutuna\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{473, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->723273424]
}, Open  ]],

Cell["Find the populations:", "ExampleText",
 CellID->19298621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CityData", "[", 
    RowBox[{"#", ",", "\"\<Population\>\""}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->382917086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"637", ",", "902", ",", "985", ",", "1232", ",", "1295"}], 
  "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28383279]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[ButtonBox["CityData Source Information",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
CityDataSourceInformation.html"], None}]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "MoreAbout",
 CellID->347310280],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->358801764]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CityData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 36.1025780}", "context" -> "System`", 
    "keywords" -> {
     "city coordinates", "phone prefix", "time zone", "city location", "town",
       "township", "location link"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CityData[\"name\", \" property\"] gives the value of the specified \
property for the city with the specified name. CityData[\"name\"] gives a \
list of the full specifications of cities whose names are consistent with \
name.", "synonyms" -> {"city data"}, "title" -> "CityData", "type" -> 
    "Symbol", "uri" -> "ref/CityData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16619, 496, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9282787]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 289820, 6316}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1997, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2620, 78, 1573, 37, 70, "ObjectNameGrid"],
Cell[4196, 117, 1058, 31, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5291, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5769, 170, 468, 13, 70, "Notes",
 CellID->92013167],
Cell[6240, 185, 323, 10, 70, "Notes",
 CellID->93194075],
Cell[6566, 197, 438, 12, 70, "Notes",
 CellID->126336585],
Cell[7007, 211, 583, 16, 70, "Notes",
 CellID->11040761],
Cell[7593, 229, 611, 18, 70, "Notes",
 CellID->86814781],
Cell[8207, 249, 872, 25, 70, "Notes",
 CellID->97519546],
Cell[9082, 276, 236, 5, 70, "Notes",
 CellID->7671498],
Cell[9321, 283, 600, 20, 70, "Notes",
 CellID->267241996],
Cell[9924, 305, 548, 16, 70, "Notes",
 CellID->71383191],
Cell[10475, 323, 573, 17, 70, "Notes",
 CellID->12057716],
Cell[11051, 342, 804, 27, 70, "Notes",
 CellID->403469145],
Cell[11858, 371, 481, 17, 70, "Notes",
 CellID->657499313],
Cell[12342, 390, 75, 1, 70, "Notes",
 CellID->136617021],
Cell[12420, 393, 1170, 23, 70, "2ColumnTableMod",
 CellID->28424917],
Cell[13593, 418, 89, 1, 70, "Notes",
 CellID->213119814],
Cell[13685, 421, 1185, 25, 70, "2ColumnTableMod",
 CellID->274486316],
Cell[14873, 448, 474, 14, 70, "Notes",
 CellID->276644756],
Cell[15350, 464, 1232, 27, 70, "2ColumnTableMod",
 CellID->469751789]
}, Closed]],
Cell[CellGroupData[{
Cell[16619, 496, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9282787],
Cell[CellGroupData[{
Cell[17002, 510, 148, 5, 70, "ExampleSection",
 CellID->741076802],
Cell[17153, 517, 138, 4, 70, "ExampleText",
 CellID->586588777],
Cell[CellGroupData[{
Cell[17316, 525, 117, 3, 28, "Input",
 CellID->126439799],
Cell[17436, 530, 1026, 28, 88, "Output",
 CellID->123324761]
}, Open  ]],
Cell[18477, 561, 125, 3, 70, "ExampleDelimiter",
 CellID->196956086],
Cell[18605, 566, 82, 1, 70, "ExampleText",
 CellID->261335503],
Cell[CellGroupData[{
Cell[18712, 571, 156, 4, 70, "Input",
 CellID->32998443],
Cell[18871, 577, 164, 5, 36, "Output",
 CellID->834491093]
}, Open  ]],
Cell[19050, 585, 82, 1, 70, "ExampleText",
 CellID->512348210],
Cell[CellGroupData[{
Cell[19157, 590, 248, 7, 70, "Input",
 CellID->599646084],
Cell[19408, 599, 162, 5, 36, "Output",
 CellID->30291230]
}, Open  ]],
Cell[19585, 607, 125, 3, 70, "ExampleDelimiter",
 CellID->543518508],
Cell[19713, 612, 116, 3, 70, "ExampleText",
 CellID->263642772],
Cell[CellGroupData[{
Cell[19854, 619, 157, 4, 70, "Input",
 CellID->62305198],
Cell[20014, 625, 230, 8, 36, "Output",
 CellID->164833595]
}, Open  ]],
Cell[20259, 636, 123, 3, 70, "ExampleDelimiter",
 CellID->4969788],
Cell[20385, 641, 73, 1, 70, "ExampleText",
 CellID->110401064],
Cell[CellGroupData[{
Cell[20483, 646, 154, 4, 70, "Input",
 CellID->557885358],
Cell[20640, 652, 175, 5, 36, "Output",
 CellID->117606852]
}, Open  ]],
Cell[CellGroupData[{
Cell[20852, 662, 158, 4, 70, "Input",
 CellID->250442195],
Cell[21013, 668, 189, 5, 36, "Output",
 CellID->357955357]
}, Open  ]],
Cell[21217, 676, 124, 3, 70, "ExampleDelimiter",
 CellID->12341576],
Cell[21344, 681, 84, 1, 70, "ExampleText",
 CellID->28976636],
Cell[CellGroupData[{
Cell[21453, 686, 169, 5, 70, "Input",
 CellID->734364217],
Cell[21625, 693, 407, 13, 36, "Output",
 CellID->50606241]
}, Open  ]],
Cell[22047, 709, 63, 1, 70, "ExampleText",
 CellID->27620481],
Cell[CellGroupData[{
Cell[22135, 714, 198, 6, 70, "Input",
 CellID->809016189],
Cell[22336, 722, 900, 25, 71, "Output",
 CellID->383705783]
}, Open  ]],
Cell[23251, 750, 125, 3, 70, "ExampleDelimiter",
 CellID->425911365],
Cell[23379, 755, 80, 1, 70, "ExampleText",
 CellID->619402774],
Cell[CellGroupData[{
Cell[23484, 760, 167, 5, 70, "Input",
 CellID->750760486],
Cell[23654, 767, 1103, 31, 71, "Output",
 CellID->21291066]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24806, 804, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[25053, 815, 271, 8, 70, "ExampleSubsection",
 CellID->101890143],
Cell[25327, 825, 144, 6, 70, "ExampleText",
 CellID->706936007],
Cell[CellGroupData[{
Cell[25496, 835, 120, 3, 70, "Input",
 CellID->64217807],
Cell[25619, 840, 550, 16, 54, "Output",
 CellID->1131204]
}, Open  ]],
Cell[26184, 859, 99, 1, 70, "ExampleText",
 CellID->582824772],
Cell[CellGroupData[{
Cell[26308, 864, 121, 3, 70, "Input",
 CellID->79734037],
Cell[26432, 869, 552, 16, 54, "Output",
 CellID->304831961]
}, Open  ]],
Cell[26999, 888, 163, 5, 70, "ExampleText",
 CellID->174304696],
Cell[CellGroupData[{
Cell[27187, 897, 155, 4, 70, "Input",
 CellID->147605353],
Cell[27345, 903, 176, 5, 36, "Output",
 CellID->307711868]
}, Open  ]],
Cell[27536, 911, 125, 3, 70, "ExampleDelimiter",
 CellID->133923449],
Cell[27664, 916, 74, 1, 70, "ExampleText",
 CellID->5628488],
Cell[CellGroupData[{
Cell[27763, 921, 183, 6, 70, "Input",
 CellID->109407644],
Cell[27949, 929, 259, 8, 36, "Output",
 CellID->451907455]
}, Open  ]],
Cell[28223, 940, 124, 3, 70, "ExampleDelimiter",
 CellID->69862915],
Cell[28350, 945, 90, 1, 70, "ExampleText",
 CellID->127823120],
Cell[CellGroupData[{
Cell[28465, 950, 117, 3, 70, "Input",
 CellID->461009226],
Cell[28585, 955, 655, 19, 54, "Output",
 CellID->84868055]
}, Open  ]],
Cell[29255, 977, 75, 1, 70, "ExampleText",
 CellID->334224336],
Cell[CellGroupData[{
Cell[29355, 982, 185, 6, 70, "Input",
 CellID->11802462],
Cell[29543, 990, 427, 13, 36, "Output",
 CellID->193216645]
}, Open  ]],
Cell[29985, 1006, 65, 1, 70, "ExampleText",
 CellID->106507505],
Cell[CellGroupData[{
Cell[30075, 1011, 173, 5, 70, "Input",
 CellID->105777901],
Cell[30251, 1018, 261, 8, 36, "Output",
 CellID->39730402]
}, Open  ]],
Cell[30527, 1029, 125, 3, 70, "ExampleDelimiter",
 CellID->246261828],
Cell[30655, 1034, 144, 4, 70, "ExampleText",
 CellID->34923962],
Cell[CellGroupData[{
Cell[30824, 1042, 186, 6, 70, "Input",
 CellID->211029415],
Cell[31013, 1050, 705, 19, 71, "Output",
 CellID->587828767]
}, Open  ]],
Cell[31733, 1072, 70, 1, 70, "ExampleText",
 CellID->3092209],
Cell[CellGroupData[{
Cell[31828, 1077, 182, 6, 70, "Input",
 CellID->27051229],
Cell[32013, 1085, 292, 8, 36, "Output",
 CellID->168140913]
}, Open  ]],
Cell[32320, 1096, 114, 3, 70, "ExampleText",
 CellID->36100077],
Cell[CellGroupData[{
Cell[32459, 1103, 191, 7, 70, "Input",
 CellID->235632346],
Cell[32653, 1112, 370, 10, 54, "Output",
 CellID->335423557]
}, Open  ]],
Cell[33038, 1125, 125, 3, 70, "ExampleDelimiter",
 CellID->977682331],
Cell[33166, 1130, 76, 1, 70, "ExampleText",
 CellID->416350756],
Cell[CellGroupData[{
Cell[33267, 1135, 164, 5, 70, "Input",
 CellID->335061581],
Cell[33434, 1142, 298, 9, 36, "Output",
 CellID->523464641]
}, Open  ]],
Cell[33747, 1154, 125, 3, 70, "ExampleDelimiter",
 CellID->185437537],
Cell[33875, 1159, 115, 3, 70, "ExampleText",
 CellID->215414749],
Cell[CellGroupData[{
Cell[34015, 1166, 115, 3, 70, "Input",
 CellID->499172160],
Cell[34133, 1171, 175, 6, 36, "Output",
 CellID->869825570]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34357, 1183, 242, 7, 70, "ExampleSubsection",
 CellID->676208838],
Cell[34602, 1192, 79, 1, 70, "ExampleText",
 CellID->416011143],
Cell[CellGroupData[{
Cell[34706, 1197, 166, 5, 70, "Input",
 CellID->106419545],
Cell[34875, 1204, 1097, 31, 71, "Output",
 CellID->23102302]
}, Open  ]],
Cell[35987, 1238, 125, 3, 70, "ExampleDelimiter",
 CellID->310275228],
Cell[36115, 1243, 98, 1, 70, "ExampleText",
 CellID->31433621],
Cell[CellGroupData[{
Cell[36238, 1248, 168, 5, 70, "Input",
 CellID->17746772],
Cell[36409, 1255, 1003, 28, 71, "Output",
 CellID->216623511]
}, Open  ]],
Cell[CellGroupData[{
Cell[37449, 1288, 192, 7, 70, "Input",
 CellID->221569772],
Cell[37644, 1297, 297, 9, 36, "Output",
 CellID->182765259]
}, Open  ]],
Cell[37956, 1309, 125, 3, 70, "ExampleDelimiter",
 CellID->259611172],
Cell[38084, 1314, 94, 1, 70, "ExampleText",
 CellID->307981279],
Cell[CellGroupData[{
Cell[38203, 1319, 232, 7, 70, "Input",
 CellID->198109053],
Cell[38438, 1328, 532, 16, 36, "Output",
 CellID->41731139]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39019, 1350, 236, 7, 70, "ExampleSubsection",
 CellID->65997959],
Cell[39258, 1359, 83, 1, 70, "ExampleText",
 CellID->25384182],
Cell[CellGroupData[{
Cell[39366, 1364, 159, 4, 70, "Input",
 CellID->590927930],
Cell[39528, 1370, 241, 8, 36, "Output",
 CellID->445188676]
}, Open  ]],
Cell[39784, 1381, 126, 3, 70, "ExampleDelimiter",
 CellID->1728610334],
Cell[39913, 1386, 79, 1, 70, "ExampleText",
 CellID->1430184768],
Cell[CellGroupData[{
Cell[40017, 1391, 157, 4, 70, "Input",
 CellID->330934905],
Cell[40177, 1397, 160, 5, 36, "Output",
 CellID->453051384]
}, Open  ]],
Cell[40352, 1405, 125, 3, 70, "ExampleDelimiter",
 CellID->659365943],
Cell[40480, 1410, 82, 1, 70, "ExampleText",
 CellID->1595106922],
Cell[CellGroupData[{
Cell[40587, 1415, 160, 4, 70, "Input",
 CellID->947785481],
Cell[40750, 1421, 224, 6, 36, "Output",
 CellID->1605082273]
}, Open  ]],
Cell[40989, 1430, 125, 3, 70, "ExampleDelimiter",
 CellID->134912517],
Cell[41117, 1435, 76, 1, 70, "ExampleText",
 CellID->671533505],
Cell[CellGroupData[{
Cell[41218, 1440, 154, 4, 70, "Input",
 CellID->867676606],
Cell[41375, 1446, 173, 5, 36, "Output",
 CellID->187301664]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41609, 1458, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[41839, 1467, 135, 4, 70, "ExampleText",
 CellID->99443403],
Cell[CellGroupData[{
Cell[41999, 1475, 412, 14, 70, "Input",
 CellID->312938027],
Cell[42414, 1491, 449, 16, 36, "Output",
 CellID->252676805]
}, Open  ]],
Cell[42878, 1510, 95, 1, 70, "ExampleText",
 CellID->284489533],
Cell[CellGroupData[{
Cell[42998, 1515, 290, 9, 70, "Input",
 CellID->340077948],
Cell[43291, 1526, 555, 16, 54, "Output",
 CellID->341888171]
}, Open  ]],
Cell[43861, 1545, 125, 3, 70, "ExampleDelimiter",
 CellID->926990457],
Cell[43989, 1550, 94, 1, 70, "ExampleText",
 CellID->17772098],
Cell[CellGroupData[{
Cell[44108, 1555, 367, 11, 70, "Input",
 CellID->137007917],
Cell[44478, 1568, 6796, 115, 70, "Output",
 Evaluatable->False,
 CellID->150351789]
}, Open  ]],
Cell[51289, 1686, 122, 3, 70, "ExampleDelimiter",
 CellID->284797],
Cell[51414, 1691, 99, 1, 70, "ExampleText",
 CellID->1991734125],
Cell[CellGroupData[{
Cell[51538, 1696, 404, 13, 70, "Input",
 CellID->395177084],
Cell[51945, 1711, 466, 11, 54, "Output",
 CellID->68324136]
}, Open  ]],
Cell[52426, 1725, 125, 3, 70, "ExampleDelimiter",
 CellID->437659313],
Cell[52554, 1730, 119, 3, 70, "ExampleText",
 CellID->17649571],
Cell[CellGroupData[{
Cell[52698, 1737, 629, 20, 70, "Input",
 CellID->201814535],
Cell[53330, 1759, 4253, 74, 70, "Output",
 Evaluatable->False,
 CellID->5937832]
}, Open  ]],
Cell[57598, 1836, 124, 3, 70, "ExampleDelimiter",
 CellID->25127873],
Cell[57725, 1841, 117, 3, 70, "ExampleText",
 CellID->400379279],
Cell[CellGroupData[{
Cell[57867, 1848, 816, 23, 70, "Input",
 CellID->746612128],
Cell[58686, 1873, 78318, 1318, 70, "Output",
 CellID->51452194]
}, Open  ]],
Cell[137019, 3194, 124, 3, 70, "ExampleDelimiter",
 CellID->56990423],
Cell[137146, 3199, 94, 1, 70, "ExampleText",
 CellID->488890987],
Cell[CellGroupData[{
Cell[137265, 3204, 1084, 31, 70, "Input",
 CellID->7696966],
Cell[138352, 3237, 16914, 281, 70, "Output",
 Evaluatable->False,
 CellID->229039034]
}, Open  ]],
Cell[155281, 3521, 124, 3, 70, "ExampleDelimiter",
 CellID->53404250],
Cell[155408, 3526, 112, 3, 70, "ExampleText",
 CellID->22383061],
Cell[CellGroupData[{
Cell[155545, 3533, 849, 26, 70, "Input",
 CellID->191301156],
Cell[156397, 3561, 6466, 110, 70, "Output",
 Evaluatable->False,
 CellID->65119437]
}, Open  ]],
Cell[162878, 3674, 125, 3, 70, "ExampleDelimiter",
 CellID->833950944],
Cell[163006, 3679, 123, 3, 70, "ExampleText",
 CellID->366290712],
Cell[CellGroupData[{
Cell[163154, 3686, 761, 22, 70, "Input",
 CellID->35878671],
Cell[163918, 3710, 75279, 1238, 70, "Output",
 Evaluatable->False,
 CellID->277023358]
}, Open  ]],
Cell[239212, 4951, 124, 3, 70, "ExampleDelimiter",
 CellID->26011022],
Cell[239339, 4956, 125, 3, 70, "ExampleText",
 CellID->351195181],
Cell[CellGroupData[{
Cell[239489, 4963, 510, 16, 70, "Input",
 CellID->49025323],
Cell[240002, 4981, 4641, 80, 70, "Output",
 Evaluatable->False,
 CellID->251611283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[244692, 5067, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[244933, 5076, 232, 7, 70, "ExampleText",
 CellID->356958269],
Cell[CellGroupData[{
Cell[245190, 5087, 230, 8, 70, "Input",
 CellID->507461611],
Cell[245423, 5097, 1322, 37, 88, "Output",
 CellID->69025108]
}, Open  ]],
Cell[246760, 5137, 224, 7, 70, "ExampleText",
 CellID->37897459],
Cell[CellGroupData[{
Cell[247009, 5148, 164, 4, 70, "Input",
 CellID->326026137],
Cell[247176, 5154, 1322, 37, 88, "Output",
 CellID->15375070]
}, Open  ]],
Cell[248513, 5194, 124, 3, 70, "ExampleDelimiter",
 CellID->79158946],
Cell[248640, 5199, 118, 3, 70, "ExampleText",
 CellID->103797875],
Cell[CellGroupData[{
Cell[248783, 5206, 598, 17, 70, "Input",
 CellID->488128011],
Cell[249384, 5225, 2640, 47, 70, "Output",
 Evaluatable->False,
 CellID->446175253]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[252073, 5278, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[252307, 5287, 229, 7, 70, "ExampleText",
 CellID->160800538],
Cell[CellGroupData[{
Cell[252561, 5298, 119, 3, 70, "Input",
 CellID->78193026],
Cell[252683, 5303, 554, 16, 54, "Output",
 CellID->5530327]
}, Open  ]],
Cell[253252, 5322, 125, 3, 70, "ExampleDelimiter",
 CellID->402278008],
Cell[253380, 5327, 119, 3, 70, "ExampleText",
 CellID->57260276],
Cell[CellGroupData[{
Cell[253524, 5334, 120, 3, 70, "Input",
 CellID->357916792],
Cell[253647, 5339, 266, 8, 36, "Output",
 CellID->251721997]
}, Open  ]],
Cell[253928, 5350, 124, 3, 70, "ExampleDelimiter",
 CellID->45442980],
Cell[254055, 5355, 112, 3, 70, "ExampleText",
 CellID->169860158],
Cell[CellGroupData[{
Cell[254192, 5362, 183, 6, 70, "Input",
 CellID->46289561],
Cell[254378, 5370, 441, 13, 36, "Output",
 CellID->448048132]
}, Open  ]],
Cell[254834, 5386, 113, 3, 70, "ExampleText",
 CellID->275495289],
Cell[CellGroupData[{
Cell[254972, 5393, 190, 7, 70, "Input",
 CellID->836622504],
Cell[255165, 5402, 270, 8, 36, "Output",
 CellID->904811086]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[255484, 5416, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[255715, 5425, 91, 1, 70, "ExampleText",
 CellID->336349540],
Cell[CellGroupData[{
Cell[255831, 5430, 307, 10, 70, "Input",
 CellID->531961307],
Cell[256141, 5442, 945, 27, 71, "Output",
 CellID->237105490]
}, Open  ]],
Cell[257101, 5472, 95, 1, 70, "ExampleText",
 CellID->27566907],
Cell[CellGroupData[{
Cell[257221, 5477, 177, 5, 70, "Input",
 CellID->84167453],
Cell[257401, 5484, 1016, 30, 71, "Output",
 CellID->225495074]
}, Open  ]],
Cell[258432, 5517, 125, 3, 70, "ExampleDelimiter",
 CellID->274478476],
Cell[258560, 5522, 130, 4, 70, "ExampleText",
 CellID->155121875],
Cell[CellGroupData[{
Cell[258715, 5530, 1072, 34, 70, "Input",
 CellID->39960110],
Cell[259790, 5566, 2320, 47, 190, "Output",
 CellID->273780469]
}, Open  ]],
Cell[262125, 5616, 123, 3, 70, "ExampleDelimiter",
 CellID->1399755],
Cell[262251, 5621, 116, 3, 70, "ExampleText",
 CellID->32561020],
Cell[262370, 5626, 753, 24, 70, "Input",
 CellID->30325159],
Cell[263126, 5652, 465, 16, 70, "Input",
 CellID->299246960],
Cell[263594, 5670, 77, 1, 70, "ExampleText",
 CellID->83445278],
Cell[CellGroupData[{
Cell[263696, 5675, 159, 5, 70, "Input",
 CellID->754290440],
Cell[263858, 5682, 12495, 211, 163, "Output",
 CellID->318370495]
}, Open  ]],
Cell[276368, 5896, 97, 1, 70, "ExampleText",
 CellID->680329877],
Cell[CellGroupData[{
Cell[276490, 5901, 270, 9, 70, "Input",
 CellID->326777908],
Cell[276763, 5912, 1199, 26, 105, "Output",
 CellID->689967469]
}, Open  ]],
Cell[277977, 5941, 113, 3, 70, "ExampleText",
 CellID->33658139],
Cell[CellGroupData[{
Cell[278115, 5948, 98, 3, 70, "Input",
 CellID->29429918],
Cell[278216, 5953, 159, 5, 36, "Output",
 CellID->98250452]
}, Open  ]],
Cell[278390, 5961, 85, 1, 70, "ExampleText",
 CellID->597848994],
Cell[CellGroupData[{
Cell[278500, 5966, 248, 8, 70, "Input",
 CellID->35461367],
Cell[278751, 5976, 246, 8, 36, "Output",
 CellID->492950815]
}, Open  ]],
Cell[279012, 5987, 113, 3, 70, "ExampleText",
 CellID->48916817],
Cell[CellGroupData[{
Cell[279150, 5994, 626, 19, 70, "Input",
 CellID->960379822],
Cell[279779, 6015, 4099, 94, 340, "Output",
 CellID->260159425]
}, Open  ]],
Cell[283893, 6112, 124, 3, 70, "ExampleDelimiter",
 CellID->22683820],
Cell[284020, 6117, 127, 3, 70, "ExampleText",
 CellID->286757361],
Cell[CellGroupData[{
Cell[284172, 6124, 466, 15, 70, "Input",
 CellID->12477490],
Cell[284641, 6141, 799, 22, 71, "Output",
 CellID->723273424]
}, Open  ]],
Cell[285455, 6166, 63, 1, 70, "ExampleText",
 CellID->19298621],
Cell[CellGroupData[{
Cell[285543, 6171, 192, 7, 70, "Input",
 CellID->382917086],
Cell[285738, 6180, 248, 8, 36, "Output",
 CellID->28383279]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[286047, 6195, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[286366, 6206, 206, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[286609, 6217, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[286930, 6228, 299, 9, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[287266, 6242, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[287595, 6253, 230, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[287862, 6263, 299, 8, 70, "MoreAboutSection"],
Cell[288164, 6273, 150, 3, 70, "MoreAbout",
 CellID->347310280],
Cell[288317, 6278, 185, 3, 70, "MoreAbout",
 CellID->358801764]
}, Open  ]],
Cell[288517, 6284, 27, 0, 70, "History"],
Cell[288547, 6286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

