(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35234,       1301]
NotebookOptionsPosition[     26599,       1008]
NotebookOutlinePosition[     28134,       1049]
CellTagsIndexPosition[     28048,       1044]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Variables" :> 
          Documentation`HelpLookup["paclet:tutorial/DefiningVariables"], 
          "Defining Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/DefiningFunctions"], 
          "Making Definitions" :> 
          Documentation`HelpLookup["paclet:tutorial/MakingDefinitions"], 
          "Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"], 
          "Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Defining Variables\"\>", 
       2->"\<\"Defining Functions\"\>", 3->"\<\"Making Definitions\"\>", 
       4->"\<\"Manipulating Symbols and Contexts by Name\"\>", 
       5->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClearAll" :> Documentation`HelpLookup["paclet:ref/ClearAll"], 
          "Unset" :> Documentation`HelpLookup["paclet:ref/Unset"], "TagUnset" :> 
          Documentation`HelpLookup["paclet:ref/TagUnset"], "ClearAttributes" :> 
          Documentation`HelpLookup["paclet:ref/ClearAttributes"], "Remove" :> 
          Documentation`HelpLookup["paclet:ref/Remove"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ClearAll\"\>", 2->"\<\"Unset\"\>", 
       3->"\<\"TagUnset\"\>", 4->"\<\"ClearAttributes\"\>", 
       5->"\<\"Remove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"], 
          "Defining Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>", 
       3->"\<\"Symbol Handling\"\>", 4->"\<\"Tuning & Debugging\"\>", 
       5->"\<\"Defining Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Clear", "ObjectName",
 CellID->27249],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clear",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clear"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["symbol", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["symbol", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]clears values and definitions for the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["symbol", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clear",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clear"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"form\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]clears values and definitions for all symbols whose \
names match any of the string patterns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32593]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " does not clear attributes, messages, or defaults associated with symbols. \
"
}], "Notes",
 CellID->13835],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " allows abbreviated string patterns containing the following \
metacharacters:"
}], "Notes",
 CellID->23859],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "*", Cell[
    "zero or more characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "@", Cell[
    "one or more characters, excluding upper-case letters", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\\\\*, etc.", "TableText"], Cell[
    "literal *, etc.", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->439942953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)*\>\"", "]"}]], "InlineFormula"],
 " clears all symbols in a particular context. "
}], "Notes",
 CellID->26926],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11057],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " does not affect symbols with the attribute ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13404]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->138521163],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->128188886],

Cell["Clear a variable:", "ExampleText",
 CellID->33805128],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60615253],

Cell[BoxData[
 RowBox[{"Clear", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28312647],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->637374087],

Cell["Clear a function definition:", "ExampleText",
 CellID->1521856],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533163969],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->785536367]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23539253],

Cell["Clear values of variables:", "ExampleText",
 CellID->301706367],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126604733],

Cell[BoxData[
 RowBox[{"Clear", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168486254],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:=",
 CellID->53040972],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->870438650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278688287],

Cell["Clear functions (downvalues):", "ExampleText",
 CellID->37454990],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->179882384],

Cell[BoxData[
 RowBox[{"Clear", "[", "fact", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371484883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->312638351],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`fact],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->763710113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->516851901],

Cell["Clear upvalues:", "ExampleText",
 CellID->627855],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"hf", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380574387],

Cell[BoxData[
 RowBox[{"Clear", "[", "h", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202963165],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131376886],

Cell["Clear several symbols:", "ExampleText",
 CellID->180368890],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2420569],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->776255491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->133977497],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137049015]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->449557545],

Cell["Clear all symbols in a given context:", "ExampleText",
 CellID->362475358],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38138293],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106237485],

Cell["Specify symbols to clear as string patterns:", "ExampleText",
 CellID->437475939],

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "=", "1"}], ";", 
  RowBox[{"x2", "=", "3"}], ";", 
  RowBox[{"y", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168901340],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<x*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237737555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "y"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29696549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "5"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->323700825]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->116385787],

Cell["Clear any old definitions before making new ones:", "ExampleText",
 CellID->59344518],

Cell[BoxData[
 RowBox[{"Clear", "[", "fib", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665750006],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "2", "]"}], "=", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->891805863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->962876173],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->380772415]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->295616585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " does not remove defaults, options or attributes: "
}], "ExampleText",
 CellID->477239184],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Default", "[", "f", "]"}], "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"opt1", "\[Rule]", "def1"}], ",", 
     RowBox[{"opt2", "\[Rule]", "def2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->128049439],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542553653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->364794754],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Default", "[", "f", "]"}], "=", "0"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"Options", "[", "f", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"opt1", "\[Rule]", "def1"}], ",", 
           RowBox[{"opt2", "\[Rule]", "def2"}]}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{585, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->120701923]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ClearAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAll"]], "InlineFormula"],
 " to clear everything:"
}], "ExampleText",
 CellID->384645278],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->306970198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->326232527],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->38856383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->509057922],

Cell[TextData[{
 "Use ",
 Cell[BoxData["=."], "InlineFormula"],
 " to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->120956370],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->751248781],

Cell[BoxData[
 RowBox[{
  RowBox[{"fact", "[", "1", "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37722120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43396380],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVcFOwzAM9dIk02B0bJfCZUxIfAfiAD3xEdWEtB0QaOyzEL8YnNYurUnV
dt0gUuLafY7t19R5zvabl9dsv11nq3SXvW+264/V09sOTdEIQD0CwOwK8Nnh
Uz55pDgBbnBVaF6QfCC5JOmRXyUSonIHmOBiUY2E/V7oS6H75TPfsXAtRkSq
QalQet2Q1B6mq7l7a2HmcSaiWMo/DqI1RRoS8YJ8dWN9SrzJyzXVXYFi/7aG
sZLrsO95AxdctQ162X/K9lKgjsJnBWVa9G4cJkM5G5wRf73xwXx5pD4ZQ1PX
53QdN5eTnKHW8xzKTQVqmgid/8dZA15m/xc5xp0ZDHVt7pn8Rcu+WOuhCure
0wZe4gDWup+OfVi0eecKJTeLFk7l+9ue/knnzLj6a1e/te+EPSFpnLzFmZ20
pwajb6rYZrk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->410516446]
}, Open  ]],

Cell["Clear all definitions:", "ExampleText",
 CellID->166079012],

Cell[BoxData[
 RowBox[{"Clear", "[", "fact", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->216930195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->317841575],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`fact],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->410760633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->203451301],

Cell["Protected symbols cannot be cleared:", "ExampleText",
 CellID->86724539],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "x", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->354007221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Clear", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->812009204],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "::", "\<\"wrsym\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(x\\) is Protected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/wrsym\\\", ButtonNote -> \
\\\"Clear::wrsym\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->117484357]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unprotect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unprotect"]], "InlineFormula"],
 " to clear definitions of protected symbols:"
}], "ExampleText",
 CellID->163671064],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "x", "]"}], ";"}], "\n", 
 RowBox[{"Clear", "[", "x", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->152175712]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->203224274],

Cell["Clear the definitions of all symbols in the current context:", \
"ExampleText",
 CellID->54699474],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";", 
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{"z", "^", "3"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->732450189],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{
    RowBox[{"Context", "[", "]"}], "<>", "\"\<*\>\""}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->501611447],

Cell[BoxData[
 RowBox[{"?", "`*"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->125890298]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22083],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagUnset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagUnset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAttributes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22349]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26865],

Cell[TextData[ButtonBox["Defining Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningVariables"]], "Tutorials",
 CellID->25059],

Cell[TextData[ButtonBox["Defining Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningFunctions"]], "Tutorials",
 CellID->24106],

Cell[TextData[ButtonBox["Making Definitions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingDefinitions"]], "Tutorials",
 CellID->29295],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->7939],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->20907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->72284411],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->92622867],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->107401437],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->441121947],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->434743761],

Cell[TextData[ButtonBox["Defining Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->420470963]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Clear - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 40.1339312}", "context" -> "System`", 
    "keywords" -> {
     "deleting functions", "deleting symbols", "functions", "kill definition",
       "removing functions", "removing symbols", "symbols", 
      "undefining functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Clear[symbol_1, symbol_2, ...] clears values and definitions for the \
symbol_i. Clear[\"SubscriptBox[ form, 1]\", \"SubscriptBox[ form, 2]\", ...] \
clears values and definitions for all symbols whose names match any of the \
string patterns form_i. ", "synonyms" -> {}, "title" -> "Clear", "type" -> 
    "Symbol", "uri" -> "ref/Clear"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8158, 249, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->138521163]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27905, 1037}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3406, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4029, 99, 43, 1, 70, "ObjectName",
 CellID->27249],
Cell[4075, 102, 1513, 47, 70, "Usage",
 CellID->32593]
}, Open  ]],
Cell[CellGroupData[{
Cell[5625, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6103, 171, 238, 8, 70, "Notes",
 CellID->13835],
Cell[6344, 181, 239, 8, 70, "Notes",
 CellID->23859],
Cell[6586, 191, 603, 13, 70, "2ColumnTableMod",
 CellID->439942953],
Cell[7192, 206, 301, 10, 70, "Notes",
 CellID->26926],
Cell[7496, 218, 289, 12, 70, "Notes",
 CellID->11057],
Cell[7788, 232, 333, 12, 70, "Notes",
 CellID->13404]
}, Closed]],
Cell[CellGroupData[{
Cell[8158, 249, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->138521163],
Cell[CellGroupData[{
Cell[8543, 263, 148, 5, 70, "ExampleSection",
 CellID->128188886],
Cell[8694, 270, 59, 1, 70, "ExampleText",
 CellID->33805128],
Cell[8756, 273, 109, 4, 70, "Input",
 CellID->60615253],
Cell[8868, 279, 100, 3, 70, "Input",
 CellID->28312647],
Cell[8971, 284, 125, 3, 70, "ExampleDelimiter",
 CellID->637374087],
Cell[9099, 289, 69, 1, 70, "ExampleText",
 CellID->1521856],
Cell[9171, 292, 145, 5, 70, "Input",
 CellID->533163969],
Cell[9319, 299, 101, 3, 70, "Input",
 CellID->785536367]
}, Open  ]],
Cell[CellGroupData[{
Cell[9457, 307, 219, 7, 70, "ExampleSection",
 CellID->23539253],
Cell[9679, 316, 69, 1, 70, "ExampleText",
 CellID->301706367],
Cell[9751, 319, 110, 4, 70, "Input",
 CellID->126604733],
Cell[9864, 325, 101, 3, 70, "Input",
 CellID->168486254],
Cell[CellGroupData[{
Cell[9990, 332, 69, 2, 70, "Input",
 CellID->53040972],
Cell[10062, 336, 158, 5, 36, "Output",
 CellID->870438650]
}, Open  ]],
Cell[10235, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->278688287],
Cell[10363, 349, 71, 1, 70, "ExampleText",
 CellID->37454990],
Cell[10437, 352, 290, 10, 70, "Input",
 CellID->179882384],
Cell[10730, 364, 104, 3, 70, "Input",
 CellID->371484883],
Cell[CellGroupData[{
Cell[10859, 371, 109, 3, 70, "Input",
 CellID->312638351],
Cell[10971, 376, 234, 8, 36, "Output",
 CellID->763710113]
}, Open  ]],
Cell[11220, 387, 125, 3, 70, "ExampleDelimiter",
 CellID->516851901],
Cell[11348, 392, 55, 1, 70, "ExampleText",
 CellID->627855],
Cell[11406, 395, 191, 6, 70, "Input",
 CellID->380574387],
Cell[11600, 403, 101, 3, 70, "Input",
 CellID->202963165],
Cell[11704, 408, 125, 3, 70, "ExampleDelimiter",
 CellID->131376886],
Cell[11832, 413, 65, 1, 70, "ExampleText",
 CellID->180368890],
Cell[11900, 416, 196, 7, 70, "Input",
 CellID->2420569],
Cell[12099, 425, 124, 4, 70, "Input",
 CellID->776255491],
Cell[CellGroupData[{
Cell[12248, 433, 97, 3, 70, "Input",
 CellID->133977497],
Cell[12348, 438, 185, 6, 36, "Output",
 CellID->137049015]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12582, 450, 243, 7, 70, "ExampleSection",
 CellID->449557545],
Cell[12828, 459, 80, 1, 70, "ExampleText",
 CellID->362475358],
Cell[12911, 462, 115, 3, 70, "Input",
 CellID->38138293],
Cell[13029, 467, 125, 3, 70, "ExampleDelimiter",
 CellID->106237485],
Cell[13157, 472, 87, 1, 70, "ExampleText",
 CellID->437475939],
Cell[13247, 475, 178, 6, 70, "Input",
 CellID->168901340],
Cell[13428, 483, 110, 3, 70, "Input",
 CellID->237737555],
Cell[CellGroupData[{
Cell[13563, 490, 126, 4, 70, "Input",
 CellID->29696549],
Cell[13692, 496, 215, 7, 36, "Output",
 CellID->323700825]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13956, 509, 227, 7, 70, "ExampleSection",
 CellID->116385787],
Cell[14186, 518, 91, 1, 70, "ExampleText",
 CellID->59344518],
Cell[14280, 521, 103, 3, 70, "Input",
 CellID->665750006],
Cell[14386, 526, 458, 16, 70, "Input",
 CellID->891805863],
Cell[CellGroupData[{
Cell[14869, 546, 99, 3, 70, "Input",
 CellID->962876173],
Cell[14971, 551, 158, 5, 36, "Output",
 CellID->380772415]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15178, 562, 237, 7, 70, "ExampleSection",
 CellID->295616585],
Cell[15418, 571, 221, 7, 70, "ExampleText",
 CellID->477239184],
Cell[15642, 580, 560, 18, 70, "Input",
 CellID->128049439],
Cell[16205, 600, 101, 3, 70, "Input",
 CellID->542553653],
Cell[CellGroupData[{
Cell[16331, 607, 106, 3, 70, "Input",
 CellID->364794754],
Cell[16440, 612, 1206, 38, 96, "Output",
 CellID->120701923]
}, Open  ]],
Cell[17661, 653, 207, 8, 70, "ExampleText",
 CellID->384645278],
Cell[17871, 663, 104, 3, 70, "Input",
 CellID->306970198],
Cell[CellGroupData[{
Cell[18000, 670, 106, 3, 70, "Input",
 CellID->326232527],
Cell[18109, 675, 230, 8, 36, "Output",
 CellID->38856383]
}, Open  ]],
Cell[18354, 686, 125, 3, 70, "ExampleDelimiter",
 CellID->509057922],
Cell[18482, 691, 161, 5, 70, "ExampleText",
 CellID->120956370],
Cell[18646, 698, 290, 10, 70, "Input",
 CellID->751248781],
Cell[18939, 710, 118, 4, 70, "Input",
 CellID->37722120],
Cell[CellGroupData[{
Cell[19082, 718, 108, 3, 70, "Input",
 CellID->43396380],
Cell[19193, 723, 651, 15, 70, "Output",
 Evaluatable->False,
 CellID->410516446]
}, Open  ]],
Cell[19859, 741, 65, 1, 70, "ExampleText",
 CellID->166079012],
Cell[19927, 744, 104, 3, 70, "Input",
 CellID->216930195],
Cell[CellGroupData[{
Cell[20056, 751, 109, 3, 70, "Input",
 CellID->317841575],
Cell[20168, 756, 234, 8, 36, "Output",
 CellID->410760633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20451, 770, 230, 7, 70, "ExampleSection",
 CellID->203451301],
Cell[20684, 779, 78, 1, 70, "ExampleText",
 CellID->86724539],
Cell[20765, 782, 174, 6, 70, "Input",
 CellID->354007221],
Cell[CellGroupData[{
Cell[20964, 792, 101, 3, 70, "Input",
 CellID->812009204],
Cell[21068, 797, 354, 7, 70, "Message",
 CellID->117484357]
}, Open  ]],
Cell[21437, 807, 231, 8, 70, "ExampleText",
 CellID->163671064],
Cell[21671, 817, 167, 5, 70, "Input",
 CellID->152175712]
}, Closed]],
Cell[CellGroupData[{
Cell[21875, 827, 228, 7, 70, "ExampleSection",
 CellID->203224274],
Cell[22106, 836, 104, 2, 70, "ExampleText",
 CellID->54699474],
Cell[22213, 840, 193, 7, 70, "Input",
 CellID->732450189],
Cell[22409, 849, 202, 7, 70, "Input",
 CellID->501611447],
Cell[22614, 858, 88, 3, 70, "Input",
 CellID->125890298]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22751, 867, 311, 9, 70, "SeeAlsoSection",
 CellID->22083],
Cell[23065, 878, 1190, 44, 70, "SeeAlso",
 CellID->22349]
}, Open  ]],
Cell[CellGroupData[{
Cell[24292, 927, 314, 9, 70, "TutorialsSection",
 CellID->26865],
Cell[24609, 938, 146, 3, 70, "Tutorials",
 CellID->25059],
Cell[24758, 943, 146, 3, 70, "Tutorials",
 CellID->24106],
Cell[24907, 948, 146, 3, 70, "Tutorials",
 CellID->29295],
Cell[25056, 953, 190, 4, 70, "Tutorials",
 CellID->7939],
Cell[25249, 959, 144, 3, 70, "Tutorials",
 CellID->20907]
}, Open  ]],
Cell[CellGroupData[{
Cell[25430, 967, 318, 9, 70, "MoreAboutSection",
 CellID->72284411],
Cell[25751, 978, 133, 3, 70, "MoreAbout",
 CellID->92622867],
Cell[25887, 983, 177, 3, 70, "MoreAbout",
 CellID->107401437],
Cell[26067, 988, 141, 3, 70, "MoreAbout",
 CellID->441121947],
Cell[26211, 993, 148, 3, 70, "MoreAbout",
 CellID->434743761],
Cell[26362, 998, 165, 3, 70, "MoreAbout",
 CellID->420470963]
}, Open  ]],
Cell[26542, 1004, 27, 0, 70, "History"],
Cell[26572, 1006, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

