(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18924,        712]
NotebookOptionsPosition[     14286,        555]
NotebookOutlinePosition[     15685,        594]
CellTagsIndexPosition[     15600,        589]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flat and Orderless Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FlatAndOrderlessFunctions"], "Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Flat and Orderless Functions\"\>", 
       2->"\<\"Attributes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:ref/Attributes"], "SetAttributes" :> 
          Documentation`HelpLookup["paclet:ref/SetAttributes"], "Unprotect" :> 
          Documentation`HelpLookup["paclet:ref/Unprotect"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"SetAttributes\"\>", 
       3->"\<\"Unprotect\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ClearAttributes", "ObjectName",
 CellID->28930],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ClearAttributes",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ClearAttributes"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["attr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes ",
     Cell[BoxData[
      StyleBox["attr", "TI"]], "InlineFormula"],
     " from the list of attributes of the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19291]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClearAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAttributes"]], "InlineFormula"],
 " modifies ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27623],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClearAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAttributes"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " removes several attributes at a time. "
}], "Notes",
 CellID->32107],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClearAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAttributes"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["attrs", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " removes attributes from several symbols at a time. "
}], "Notes",
 CellID->10644],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClearAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAttributes"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5224],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClearAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAttributes"]], "InlineFormula"],
 " does not affect symbols with the attribute ",
 Cell[BoxData[
  ButtonBox["Locked",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4529]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->656669003],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->51634149],

Cell[BoxData[
 RowBox[{"ClearAttributes", "[", 
  RowBox[{"Log", ",", "Listable"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473587850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257796770],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144622773]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->61178452],

Cell[TextData[{
 "Set a number of attributes for the symbol ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->304896254],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "Orderless", ",", "OneIdentity"}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297125081],

Cell["\<\
Clear a particular attribute; the remaining ones are retained:\
\>", "ExampleText",
 CellID->71777453],

Cell[BoxData[
 RowBox[{"ClearAttributes", "[", 
  RowBox[{"f", ",", "OneIdentity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->432839618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6887915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "Orderless"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->163267549]
}, Open  ]],

Cell["Clear several attributes:", "ExampleText",
 CellID->270871340],

Cell[BoxData[
 RowBox[{"ClearAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->227778215]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->472885449],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClearAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAttributes"]], "InlineFormula"],
 " is equivalent to this assignment to the attributes:"
}], "ExampleText",
 CellID->21085966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "f", "]"}], "=", 
  RowBox[{"Complement", "[", 
   RowBox[{
    RowBox[{"Attributes", "[", "f", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"HoldFirst", ",", "NHoldFirst"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30647318],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345744423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->249012309],

Cell[TextData[{
 "Unprotecting a symbol is equivalent to clearing the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->52594906],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"f", ",", "g"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634542146],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"g", ",", "Protected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->618640824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->738079365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->715073669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->400739634],

Cell[TextData[{
 "After setting the attribute ",
 Cell[BoxData[
  ButtonBox["Locked",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
 ", no more changes to the attributes can be made:"
}], "ExampleText",
 CellID->482908561],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Locked", ",", "Protected"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->513627669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClearAttributes", "[", 
  RowBox[{"f", ",", "Locked"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->563120665],

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "::", "\<\"locked\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(f\\) is locked.\"\>"}]], "Message", "MSG",
 CellID->51725115]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20728],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAttributes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unprotect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unprotect"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32127],

Cell[TextData[ButtonBox["Flat and Orderless Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"]], "Tutorials",
 CellID->30795],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->20915]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->361188427]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClearAttributes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 39.6026676}", "context" -> "System`", 
    "keywords" -> {
     "evaluation control", "evaluation properties", 
      "pattern matching properties", "properties", "remove attributes", 
      "symbol properties"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ClearAttributes[s, attr] removes attr from the list of attributes of the \
symbol s. ", "synonyms" -> {"clear attributes"}, "title" -> "ClearAttributes",
     "type" -> "Symbol", "uri" -> "ref/ClearAttributes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6207, 216, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->656669003]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15457, 582}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2073, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2696, 78, 53, 1, 70, "ObjectName",
 CellID->28930],
Cell[2752, 81, 717, 23, 70, "Usage",
 CellID->19291]
}, Open  ]],
Cell[CellGroupData[{
Cell[3506, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3984, 126, 372, 14, 70, "Notes",
 CellID->27623],
Cell[4359, 142, 568, 20, 70, "Notes",
 CellID->32107],
Cell[4930, 164, 576, 19, 70, "Notes",
 CellID->10644],
Cell[5509, 185, 312, 12, 70, "Notes",
 CellID->5224],
Cell[5824, 199, 346, 12, 70, "Notes",
 CellID->4529]
}, Closed]],
Cell[CellGroupData[{
Cell[6207, 216, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->656669003],
Cell[CellGroupData[{
Cell[6592, 230, 147, 5, 70, "ExampleSection",
 CellID->51634149],
Cell[6742, 237, 143, 4, 70, "Input",
 CellID->473587850],
Cell[CellGroupData[{
Cell[6910, 245, 156, 5, 28, "Input",
 CellID->257796770],
Cell[7069, 252, 244, 8, 36, "Output",
 CellID->144622773]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7362, 266, 219, 7, 70, "ExampleSection",
 CellID->61178452],
Cell[7584, 275, 164, 6, 70, "ExampleText",
 CellID->304896254],
Cell[7751, 283, 231, 8, 70, "Input",
 CellID->297125081],
Cell[7985, 293, 112, 3, 70, "ExampleText",
 CellID->71777453],
Cell[8100, 298, 144, 4, 70, "Input",
 CellID->432839618],
Cell[CellGroupData[{
Cell[8269, 306, 104, 3, 70, "Input",
 CellID->6887915],
Cell[8376, 311, 215, 7, 36, "Output",
 CellID->163267549]
}, Open  ]],
Cell[8606, 321, 68, 1, 70, "ExampleText",
 CellID->270871340],
Cell[8677, 324, 194, 6, 70, "Input",
 CellID->227778215]
}, Closed]],
Cell[CellGroupData[{
Cell[8908, 335, 237, 7, 70, "ExampleSection",
 CellID->472885449],
Cell[9148, 344, 242, 7, 70, "ExampleText",
 CellID->21085966],
Cell[CellGroupData[{
Cell[9415, 355, 296, 9, 70, "Input",
 CellID->30647318],
Cell[9714, 366, 175, 6, 36, "Output",
 CellID->345744423]
}, Open  ]],
Cell[9904, 375, 125, 3, 70, "ExampleDelimiter",
 CellID->249012309],
Cell[10032, 380, 246, 8, 70, "ExampleText",
 CellID->52594906],
Cell[10281, 390, 145, 5, 70, "Input",
 CellID->634542146],
Cell[10429, 397, 227, 7, 70, "Input",
 CellID->618640824],
Cell[CellGroupData[{
Cell[10681, 408, 153, 5, 70, "Input",
 CellID->738079365],
Cell[10837, 415, 241, 9, 36, "Output",
 CellID->715073669]
}, Open  ]],
Cell[11093, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->400739634],
Cell[11221, 432, 254, 8, 70, "ExampleText",
 CellID->482908561],
Cell[11478, 442, 194, 6, 70, "Input",
 CellID->513627669],
Cell[CellGroupData[{
Cell[11697, 452, 139, 4, 70, "Input",
 CellID->563120665],
Cell[11839, 458, 166, 4, 70, "Message",
 CellID->51725115]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12066, 469, 311, 9, 70, "SeeAlsoSection",
 CellID->20728],
Cell[12380, 480, 711, 26, 70, "SeeAlso",
 CellID->3219]
}, Open  ]],
Cell[CellGroupData[{
Cell[13128, 511, 314, 9, 70, "TutorialsSection",
 CellID->32127],
Cell[13445, 522, 164, 3, 70, "Tutorials",
 CellID->30795],
Cell[13612, 527, 131, 3, 70, "Tutorials",
 CellID->20915]
}, Open  ]],
Cell[CellGroupData[{
Cell[13780, 535, 299, 8, 70, "MoreAboutSection"],
Cell[14082, 545, 132, 3, 70, "MoreAbout",
 CellID->361188427]
}, Open  ]],
Cell[14229, 551, 27, 0, 70, "History"],
Cell[14259, 553, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

