(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    104131,       2558]
NotebookOptionsPosition[     97677,       2344]
NotebookOutlinePosition[     99141,       2383]
CellTagsIndexPosition[     99055,       2378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToDynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Introduction to Dynamic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LocatorPane" :> 
          Documentation`HelpLookup["paclet:ref/LocatorPane"], "Pane" :> 
          Documentation`HelpLookup["paclet:ref/Pane"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], "ArrayPlot" :> 
          Documentation`HelpLookup["paclet:ref/ArrayPlot"], "EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LocatorPane\"\>", 2->"\<\"Pane\"\>",
        3->"\<\"Button\"\>", 4->"\<\"Manipulate\"\>", 5->"\<\"ArrayPlot\"\>", 
       6->"\<\"EventHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Click-Interactive Panels\"\>", 2->"\<\"Control Objects\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Dynamic Visualization\"\>", 
       5->"\<\"Graphics Interactivity & Drawing\"\>", 
       6->"\<\"Stand-Alone Interfaces\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ClickPane", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ClickPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ClickPane"], "[", 
       RowBox[{
        StyleBox["image", "TI"], ",", 
        StyleBox["func", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a clickable pane that displays as ",
     Cell[BoxData[
      StyleBox["image", "TI"]], "InlineFormula"],
     " and applies ",
     Cell[BoxData[
      StyleBox["func", "TI"]], "InlineFormula"],
     " to the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
     " coordinates of each click within the pane."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ClickPane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ClickPane"], "[", 
       RowBox[{
        StyleBox["image", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["min", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["max", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["max", "TI"]]}], "}"}]}], "}"}], ",", 
        StyleBox["func", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies the range of coordinates to use."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The image in a click pane can be a graphic or any other expression.\
\>", "Notes",
 CellID->414459412],

Cell[TextData[{
 "For a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["func", "TI"]}], "]"}]], "InlineFormula"],
 " by default takes the range of coordinates supplied to ",
 Cell[BoxData[
  StyleBox["func", "TI"]], "InlineFormula"],
 " to be the range of graphics coordinates corresponding to ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29911436],

Cell[TextData[{
 "For a general expression, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["func", "TI"]}], "]"}]], "InlineFormula"],
 " takes the range of coordinates to be 0 to 1 in each direction."
}], "Notes",
 CellID->143470244]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->431445802],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->503574666],

Cell["Move the point to where the \"click\" occurred:", "ExampleText",
 CellID->152355461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Yellow", ",", 
          RowBox[{"Disk", "[", "]"}], ",", "Black", ",", 
          RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"pt", "=", "#"}], ")"}], "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231560287],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {-0.3682659932659931, \
-0.20158249158249172`}}, 
  TagBox[
   DynamicBox[ToBoxes[
     Graphics[{Yellow, 
       Disk[], Black, 
       Point[$CellContext`pt$$]}, ImageSize -> Tiny], StandardForm],
    ImageSizeCache->{100., {48., 52.}}],
   EventHandlerTag[{"MouseClicked" :> (($CellContext`pt$$ = #)& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164262732]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5898560],

Cell["Center the disk on mouse clicks:", "ExampleText",
 CellID->41648072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Yellow", ",", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"Disk", "[", "pt", "]"}]}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"pt", "=", "#"}], ")"}], "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1795833276],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {3., 1.6}}, 
  TagBox[
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 1, 0], 
      DynamicBox[Typeset`ToBoxes[
        Disk[$CellContext`pt$$], StandardForm, Graphics],
       ImageSizeCache->{{105., 135.}, {-41., -11.}}]},
     PlotRange->5],
    StripOnInput->False],
   EventHandlerTag[{"MouseClicked" :> (($CellContext`pt$$ = #)& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{164, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->408144595]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->181233884],

Cell[TextData[{
 "Visualize solutions to a linear system of differential equations ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "\[LongEqual]", 
    RowBox[{"A", ".", "x"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->642170170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClickPane", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Dynamic", "@", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", "=", 
      RowBox[{
       RowBox[{"MatrixExp", "[", 
        RowBox[{
         RowBox[{"(", GridBox[{
            {
             RowBox[{"-", "1.1"}], "0.9"},
            {
             RowBox[{"-", "1.4"}], "0.3"}
           }], ")"}], "t"}], "]"}], ".", "#"}]}], ")"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444291304],

Cell[BoxData[
 TagBox[
  FrameBox[
   DynamicBox[ToBoxes[
     ParametricPlot[$CellContext`f, {$CellContext`t, 0, 10}, PlotRange -> 5], 
     StandardForm],
    ImageSizeCache->{180., {88., 92.}}],
   StripOnInput->False],
  EventHandlerTag[{"MouseClicked" :> (($CellContext`f = Dot[
       MatrixExp[{{-1.1, 0.9}, {-1.4, 0.3}} $CellContext`t], #])& )[
      MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
    PassEventsUp -> True}]]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170569394]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->706423579],

Cell["Keep track of all solutions as you go:", "ExampleText",
 CellID->1660694309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", "=", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"ClickPane", "[", 
     RowBox[{
      RowBox[{"Framed", "@", 
       RowBox[{"Dynamic", "@", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{"f", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"f", ",", 
          RowBox[{
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"(", GridBox[{
                {
                 RowBox[{"-", "1.1"}], "0.9"},
                {
                 RowBox[{"-", "1.4"}], "0.3"}
               }], ")"}], "t"}], "]"}], ".", "#"}]}], "]"}], ")"}], "&"}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1788223705],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`f$$ = {{
   0.8668903803131986 (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    2.2651006711409387` (
      Complex[0.5, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, 0.3988620176087329] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])), 
    2.2651006711409387` (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    0.8668903803131986 (
      Complex[0.5, 0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]))}, {
   2.0413870246085004` (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    2.656599552572707 (
     Complex[0.5, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, 0.3988620176087329] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t])), (-2.656599552572707) (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    2.0413870246085004` (
      Complex[0.5, 0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]))}, {(-2.2651006711409396`) (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    2.488814317673378 (
     Complex[0.5, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, 0.3988620176087329] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t])), (-2.488814317673378) (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    2.2651006711409396` (
     Complex[0.5, 0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]))}, {(-3.383668903803132) (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    2.3210290827740483` (
      Complex[0.5, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, 0.3988620176087329] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])), 
    2.3210290827740483` (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    3.383668903803132 (
     Complex[0.5, 0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]))}, {(-2.5447427293064875`) (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    1.0906040268456367` (
      Complex[0.5, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, 0.3988620176087329] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])), 
    1.0906040268456367` (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    2.5447427293064875` (
     Complex[0.5, 0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]))}, {(-1.4261744966442955`) (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    4.334451901565994 (
      Complex[0.5, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, 0.3988620176087329] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])), 
    4.334451901565994 (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    1.4261744966442955` (
     Complex[0.5, 0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]))}, {(-0.47539149888143206`) (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    4.054809843400446 (
      Complex[0.5, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, 0.3988620176087329] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])), 
    4.054809843400446 (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    0.47539149888143206` (
     Complex[0.5, 0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]))}, {
   1.9854586129753908` (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    0.5313199105145419 (
     Complex[0.5, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, 0.3988620176087329] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t])), (-0.5313199105145419) (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    1.9854586129753908` (
      Complex[0.5, 0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]))}, {
   1.0346756152125274` (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    3.0480984340044746` (
     Complex[0.5, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, 0.3988620176087329] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t])), (-3.0480984340044746`) (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) + 
    1.0346756152125274` (
      Complex[0.5, 0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[0.49999999999999994`, -0.3988620176087328] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]))}, {(-1.4261744966442955`) (
      Complex[6.727474480272555*^-17, 0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[3.2742905609062234`*^-17, -0.5128225940683708] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    3.3277404921700224` (
     Complex[0.5, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, 0.3988620176087329] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t])), (-3.3277404921700224`) (
      Complex[7.990570011218168*^-17, -0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t]) + 
      Complex[-4.2582040324368187`*^-17, 0.7977240352174656] (
        E^((-0.4000000000000001) $CellContext`t) 
         Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
          E^((-0.4000000000000001) $CellContext`t)) 
         Sin[0.8774964387392121 $CellContext`t])) - 
    1.4261744966442955` (
     Complex[0.5, 0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, -1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]) + 
     Complex[0.49999999999999994`, -0.3988620176087328] (
       E^((-0.4000000000000001) $CellContext`t) 
        Cos[0.8774964387392121 $CellContext`t] + (Complex[0, 1] 
         E^((-0.4000000000000001) $CellContext`t)) 
        Sin[0.8774964387392121 $CellContext`t]))}}}, 
  TagBox[
   FrameBox[
    DynamicBox[ToBoxes[
      ParametricPlot[$CellContext`f$$, {$CellContext`t, 0, 10}, PlotRange -> 
       5], StandardForm],
     ImageSizeCache->{180., {88., 92.}}],
    StripOnInput->False],
   EventHandlerTag[{"MouseClicked" :> (AppendTo[$CellContext`f$$, 
       Dot[
        MatrixExp[{{-1.1, 0.9}, {-1.4, 0.3}} $CellContext`t], #]]& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574754330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195193327],

Cell[TextData[{
 "Get a circle from three points ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Circle.html"], None}],
 ":"
}], "ExampleText",
 CellID->830925843],

Cell[BoxData[
 RowBox[{
  RowBox[{"createCircle", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x2_", ",", "y2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3_", ",", "y3_"}], "}"}]}], "}"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"Det", "[", 
        RowBox[{"(", GridBox[{
           {"x1", "y1", "1"},
           {"x2", "y2", "1"},
           {"x3", "y3", "1"}
          }], ")"}], "]"}]}], ",", 
      RowBox[{"d", "=", 
       RowBox[{"-", 
        RowBox[{"Det", "[", 
         RowBox[{"(", GridBox[{
            {
             RowBox[{
              SuperscriptBox["x1", "2"], "+", 
              SuperscriptBox["y1", "2"]}], "y1", "1"},
            {
             RowBox[{
              SuperscriptBox["x2", "2"], "+", 
              SuperscriptBox["y2", "2"]}], "y2", "1"},
            {
             RowBox[{
              SuperscriptBox["x3", "2"], "+", 
              SuperscriptBox["y3", "2"]}], "y3", "1"}
           }], ")"}], "]"}]}]}], ",", 
      RowBox[{"e", "=", 
       RowBox[{"Det", "[", 
        RowBox[{"(", GridBox[{
           {
            RowBox[{
             SuperscriptBox["x1", "2"], "+", 
             SuperscriptBox["y1", "2"]}], "x1", "1"},
           {
            RowBox[{
             SuperscriptBox["x2", "2"], "+", 
             SuperscriptBox["y2", "2"]}], "x2", "1"},
           {
            RowBox[{
             SuperscriptBox["x3", "2"], "+", 
             SuperscriptBox["y3", "2"]}], "x3", "1"}
          }], ")"}], "]"}]}], ",", 
      RowBox[{"f", "=", 
       RowBox[{"-", 
        RowBox[{"Det", "[", 
         RowBox[{"(", GridBox[{
            {
             RowBox[{
              SuperscriptBox["x1", "2"], "+", 
              SuperscriptBox["y1", "2"]}], "x1", "y1"},
            {
             RowBox[{
              SuperscriptBox["x2", "2"], "+", 
              SuperscriptBox["y2", "2"]}], "x2", "y2"},
            {
             RowBox[{
              SuperscriptBox["x3", "2"], "+", 
              SuperscriptBox["y3", "2"]}], "x3", "y3"}
           }], ")"}], "]"}]}]}]}], "}"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["d", 
          RowBox[{"2", " ", "a"}]]}], ",", 
        RowBox[{"-", 
         FractionBox["e", 
          RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["d", "2"], "+", 
          SuperscriptBox["e", "2"]}], 
         RowBox[{"4", 
          SuperscriptBox["a", "2"]}]], "-", 
        FractionBox["f", "a"]}]]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284486860],

Cell[BoxData[
 RowBox[{
  RowBox[{"createCircle", "[", "pts_", "]"}], ":=", 
  RowBox[{"{", "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108659516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pts", "=", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"c", "=", 
      RowBox[{"{", "}"}]}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dynamic", "[", "c", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"Dynamic", "[", "pts", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "pts", "]"}], "<", "3"}], ",", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"pts", ",", "#"}], "]"}], ",", 
          RowBox[{"pts", "=", 
           RowBox[{"{", "#", "}"}]}]}], "]"}], ";", 
        RowBox[{"c", "=", 
         RowBox[{"createCircle", "[", "pts", "]"}]}]}], ")"}], "&"}]}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1072057798],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{0.05555555555555536, 
  0.5555555555555556}, {1.7222222222222214`, 0.5555555555555556}, {
  0.2777777777777777, -2.6666666666666665`}}, $CellContext`c$$ = 
  Circle[{0.8888888888888885, -1.0057471264367814`}, 1.769776965959527]}, 
  TagBox[
   FrameBox[
    GraphicsBox[{
      DynamicBox[Typeset`ToBoxes[$CellContext`c$$, StandardForm, Graphics],
       ImageSizeCache->{{73.125, 138.875}, {-16.75, 49.}}], 
      PointBox[Dynamic[$CellContext`pts$$]]},
     PlotRange->5],
    StripOnInput->False],
   EventHandlerTag[{"MouseClicked" :> ((If[Length[$CellContext`pts$$] < 3, 
        AppendTo[$CellContext`pts$$, #], $CellContext`pts$$ = {#}]; \
$CellContext`c$$ = $CellContext`createCircle[$CellContext`pts$$])& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{},
  Initialization:>($CellContext`createCircle[{{
        Pattern[$CellContext`x1, 
         Blank[]], 
        Pattern[$CellContext`y1, 
         Blank[]]}, {
        Pattern[$CellContext`x2, 
         Blank[]], 
        Pattern[$CellContext`y2, 
         Blank[]]}, {
        Pattern[$CellContext`x3, 
         Blank[]], 
        Pattern[$CellContext`y3, 
         Blank[]]}}] := 
    With[{$CellContext`a = 
       Det[{{$CellContext`x1, $CellContext`y1, 
           1}, {$CellContext`x2, $CellContext`y2, 
           1}, {$CellContext`x3, $CellContext`y3, 1}}], $CellContext`d = -
        Det[{{$CellContext`x1^2 + $CellContext`y1^2, $CellContext`y1, 
            1}, {$CellContext`x2^2 + $CellContext`y2^2, $CellContext`y2, 
            1}, {$CellContext`x3^2 + $CellContext`y3^2, $CellContext`y3, 
            1}}], $CellContext`e = 
       Det[{{$CellContext`x1^2 + $CellContext`y1^2, $CellContext`x1, 
           1}, {$CellContext`x2^2 + $CellContext`y2^2, $CellContext`x2, 
           1}, {$CellContext`x3^2 + $CellContext`y3^2, $CellContext`x3, 
           1}}], $CellContext`f = -
        Det[{{$CellContext`x1^2 + $CellContext`y1^2, $CellContext`x1, \
$CellContext`y1}, {$CellContext`x2^2 + $CellContext`y2^2, $CellContext`x2, \
$CellContext`y2}, {$CellContext`x3^2 + $CellContext`y3^2, $CellContext`x3, \
$CellContext`y3}}]}, 
      Circle[{-($CellContext`d/(2 $CellContext`a)), -($CellContext`e/(
         2 $CellContext`a))}, (($CellContext`d^2 + $CellContext`e^2)/(
         4 $CellContext`a^2) - $CellContext`f/$CellContext`a)^
       Rational[1, 2]]]; $CellContext`createCircle[
      Pattern[$CellContext`pts, 
       Blank[]]] := {})]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->538717341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->950092610],

Cell["Detect whether we inside or outside a disk: ", "ExampleText",
 CellID->268325457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pt", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"c", "=", "\"\<Red\>\""}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"Disk", "[", "]"}], ",", "Black", ",", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", "pt"}], "}"}], 
           "]"}]}], ",", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "c", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}]}]}], "}"}], 
       "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"pt", "=", "#"}], ";", 
        RowBox[{"c", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Norm", "[", "pt", "]"}], "<", "1"}], ",", "\"\<Red\>\"", 
           ",", "\"\<White\>\""}], "]"}]}]}], ")"}], "&"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1431635203],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {-0.16985735735735785`, 
  0.15872372372372387`}, $CellContext`c$$ = "Red"}, 
  TagBox[
   FrameBox[
    GraphicsBox[{
      {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
      {GrayLevel[0], 
       DynamicBox[Typeset`ToBoxes[
         Arrow[{{-2, 0}, $CellContext`pt$$}], StandardForm, Graphics],
        ImageSizeCache->{{6.625, 112.375}, {-13.4375, -0.625}}], 
       DynamicBox[Typeset`ToBoxes[
         Text[
          Dynamic[$CellContext`c$$], {-2, 0}], StandardForm, Graphics],
        ImageSizeCache->{{0., 16.}, {-8.8125, 3.1875}}]}}],
    StripOnInput->False],
   EventHandlerTag[{
    "MouseClicked" :> (($CellContext`pt$$ = #; $CellContext`c$$ = 
       If[Norm[$CellContext`pt$$] < 1, "Red", "White"])& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254252017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187641087],

Cell["\<\
Make plot where the arrow \"snaps\" to the curve, when you click in the pane: \
\
\>", "ExampleText",
 CellID->40168086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Pi]", "/", "2"}], ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dynamic", "@", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "5"}], "}"}], ",", "pt"}], "}"}], "]"}]}], 
          ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<Feature\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "5"}], "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "6"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"pt", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"3", 
           RowBox[{"Sin", "[", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], "}"}]}], ")"}], 
      "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83002260],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {Rational[1, 2] Pi, 3}}, 
  TagBox[
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtmnk8lN8Xx2fGzDyyz4IsKUSoUEooPVcUSRSSSpIlLbRYixZKtmzZtyyp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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    Epilog->{
      DynamicBox[
       Typeset`ToBoxes[
        Arrow[{{1, 5}, $CellContext`pt$$}], StandardForm, Graphics]], 
      InsetBox[
       FormBox["\"Feature\"", TraditionalForm], {2, 5}]},
    PlotRange->{{-6, 6}, {-6, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], Automatic}],
   EventHandlerTag[{"MouseClicked" :> (($CellContext`pt$$ = {
        Part[#, 1], 3 Sin[
          Part[#, 1]]})& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3526988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13391893],

Cell["Make a plot where the arrow \"snaps\" to one of the extrema: ", \
"ExampleText",
 CellID->173939852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Pi]", "/", "2"}], ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dynamic", "@", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "5"}], "}"}], ",", "pt"}], "}"}], "]"}]}], 
          ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<Extremum\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "5"}], "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "6"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", "=", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", 
               RowBox[{"Round", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "+", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "/", "\[Pi]"}]}], "]"}]}], 
              "+", "1"}], ")"}], 
            RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}], ",", 
         RowBox[{"pt", "=", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"3", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}]}]}], "]"}], ")"}], 
      "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1211344882],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {Rational[1, 2] Pi, 3}}, 
  TagBox[
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtmnk8lN8Xx2fGzDyyz4IsKUSoUEooPVcUSRSSSpIlLbRYixZKtmzZtyyp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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    Epilog->{
      DynamicBox[
       Typeset`ToBoxes[
        Arrow[{{1, 5}, $CellContext`pt$$}], StandardForm, Graphics]], 
      InsetBox[
       FormBox["\"Extremum\"", TraditionalForm], {2, 5}]},
    PlotRange->{{-6, 6}, {-6, 6}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], Automatic}],
   EventHandlerTag[{
    "MouseClicked" :> (
      With[{$CellContext`x$ = (2 Round[(-1)/2 + Part[#, 1]/Pi] + 1) (Pi/
          2)}, $CellContext`pt$$ = {$CellContext`x$, 3 
         Sin[$CellContext`x$]}]& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188685820]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClickPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClickPane"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139373048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Line", "[", "pts", "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"pts", ",", "#"}], "]"}], "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162100497],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{0.1200000000000001, 
  0.62}, {-0.42000000000000004`, 0.}, {0.19999999999999996`, -0.44}, {
  0.6200000000000001, 0.5}}}, 
  TagBox[
   DynamicBox[ToBoxes[
     Framed[
      Graphics[
       Line[$CellContext`pts$$], PlotRange -> 1]], StandardForm],
    ImageSizeCache->{110., {53., 57.}}],
   EventHandlerTag[{"MouseClicked" :> (AppendTo[$CellContext`pts$$, #]& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1867210935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"EventHandler", "[", 
     RowBox[{
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Line", "[", "pts", "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
      RowBox[{"\"\<MouseClicked\>\"", "\[RuleDelayed]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"pts", ",", 
         RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], "]"}]}]}],
      "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126335905],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{-0.26, 
  0.30000000000000004`}, {-0.52, -0.18000000000000002`}, {0.24, -0.26}, {
  0.3800000000000001, 0.30000000000000004`}}}, 
  DynamicBox[ToBoxes[
    EventHandler[
     Framed[
      Graphics[
       Line[$CellContext`pts$$], PlotRange -> 1]], "MouseClicked" :> 
     AppendTo[$CellContext`pts$$, 
       MousePosition["Graphics"]]], StandardForm],
   ImageSizeCache->{110., {53., 57.}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->315173815]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->657777349],

Cell["\<\
For a \"click\" to register, you must press and release the mouse at the same \
point:\
\>", "ExampleText",
 CellID->1086075833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"ClickPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "@", 
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Line", "[", "pts", "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"pts", ",", "#"}], "]"}], "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260855],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{
  0.1777777777777778, -0.3111111111111111}, {-0.2666666666666666, 
  0.08888888888888889}, {0.07777777777777772, 0.4}, {
  0.6222222222222222, -0.5333333333333334}, {-0.2777777777777778, \
-0.6444444444444445}, {-0.7222222222222222, -0.34444444444444444`}, \
{-0.7222222222222222, 0.01111111111111111}, {-0.47777777777777775`, 
  0.5666666666666667}, {0.08888888888888902, 0.6333333333333333}, {
  0.6222222222222222, 0.3444444444444445}, {
  0.7666666666666668, -0.8111111111111112}, {-0.3666666666666667, -0.8}, \
{-0.7666666666666666, 0.4}, {-0.7666666666666666, 
  0.6444444444444445}, {-0.23333333333333328`, 0.7444444444444445}, {
  0.1444444444444446, 0.7444444444444445}, {0.7222222222222223, 
  0.6666666666666666}, {0.8222222222222222, 
  0.32222222222222224`}, {-0.24444444444444446`, -0.34444444444444444`}, {
  0.21111111111111125`, -0.4222222222222222}, {
  0.5111111111111111, -0.4888888888888889}, {
  0.8333333333333335, -0.45555555555555555`}, {
  0.8222222222222222, -0.13333333333333333`}, {0.6888888888888889, 
  0.1111111111111111}, {-0.1333333333333333, 
  0.5555555555555556}, {-0.3111111111111111, 
  0.2888888888888889}, {-0.4555555555555555, -0.044444444444444446`}}}, 
  TagBox[
   DynamicBox[ToBoxes[
     Framed[
      Graphics[
       Line[$CellContext`pts$$], PlotRange -> 1]], StandardForm],
    ImageSizeCache->{190., {93., 97.}}],
   EventHandlerTag[{"MouseClicked" :> (AppendTo[$CellContext`pts$$, #]& )[
       MousePosition["EventHandlerAutomatic"]], PassEventsDown -> Automatic, 
     PassEventsUp -> True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507085581]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 " to get additional flexibility in registering actions with events:"
}], "ExampleText",
 CellID->594115771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"EventHandler", "[", 
     RowBox[{
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Line", "[", "pts", "]"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
      RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"pts", ",", 
         RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], "]"}]}]}],
      "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65525731],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{-0.5111111111111111, 
  0.07777777777777778}, {0.4444444444444444, 0.38888888888888895`}, {
  0.47777777777777786`, -0.08888888888888889}, {-0.16666666666666663`, \
-0.5222222222222223}, {-0.7666666666666666, -0.1}, {-0.2666666666666666, 
  0.41111111111111115`}, {-0.011111111111111072`, -0.24444444444444446`}, {
  0.11111111111111116`, 0.4555555555555556}, {0.3222222222222222, 
  0.07777777777777778}, {0.07777777777777772, -0.1}, {
  0.4555555555555557, -0.24444444444444446`}, {
  0.5444444444444445, -0.6555555555555556}, {
  0.16666666666666674`, -0.7777777777777778}, {-0.5555555555555556, \
-0.6666666666666667}, {-0.5555555555555556, -0.3}, {-0.21111111111111103`, 
  0.03333333333333334}, {0.05555555555555558, -0.1888888888888889}, {
  0.18888888888888888`, -0.5888888888888889}, {0.5444444444444445, -0.8}, {
  0.7222222222222223, -0.4444444444444444}, {
  0.6111111111111112, -0.011111111111111112`}, {
  0.38888888888888884`, -0.06666666666666667}, {
  0.16666666666666674`, -0.16666666666666669`}, {0.6777777777777778, 
  0.46666666666666673`}, {0.06666666666666665, 0.6}, {-0.5777777777777777, 
  0.5111111111111111}, {-0.6333333333333333, 0.3444444444444445}, {
  0.288888888888889, -0.4111111111111111}, {
  0.8555555555555556, -0.011111111111111112`}, {-0.0444444444444444, 
  0.8444444444444444}, {-0.9444444444444444, 
  0.7111111111111111}, {-0.8333333333333333, -0.43333333333333335`}, \
{-0.21111111111111103`, -0.8666666666666667}, {0.5, -0.9777777777777779}, {
  0.7666666666666668, -0.8}, {0.9000000000000001, -0.3}, {
  0.8777777777777778, -0.07777777777777778}}}, 
  DynamicBox[ToBoxes[
    EventHandler[
     Framed[
      Graphics[
       Line[$CellContext`pts$$], PlotRange -> 1]], "MouseDown" :> 
     AppendTo[$CellContext`pts$$, 
       MousePosition["Graphics"]]], StandardForm],
   ImageSizeCache->{190., {93., 97.}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1779333653]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->34961954],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->102439985],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->62541429],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->698407068],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsInteractivityAndDrawing"]], "MoreAbout",
 CellID->16117897],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->146184913]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClickPane - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 42.1808586}", "context" -> "System`", 
    "keywords" -> {
     "image map", "imagemap", "mouse click", "mouse down", "mouse events"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ClickPane[image, func] represents a clickable pane that displays as \
image and applies func to the x, y coordinates of each click within the pane. \
ClickPane[image, {{x_min, y_min}, {x_max, y_max}}, func] specifies the range \
of coordinates to use.", "synonyms" -> {"click pane"}, "title" -> "ClickPane",
     "type" -> "Symbol", "uri" -> "ref/ClickPane"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9015, 268, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->431445802]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 98912, 2371}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3107, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3730, 96, 1574, 37, 70, "ObjectNameGrid"],
Cell[5307, 135, 1817, 56, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7161, 196, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7639, 213, 112, 3, 70, "Notes",
 CellID->414459412],
Cell[7754, 218, 851, 31, 70, "Notes",
 CellID->29911436],
Cell[8608, 251, 370, 12, 70, "Notes",
 CellID->143470244]
}, Closed]],
Cell[CellGroupData[{
Cell[9015, 268, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->431445802],
Cell[CellGroupData[{
Cell[9400, 282, 148, 5, 70, "ExampleSection",
 CellID->503574666],
Cell[9551, 289, 90, 1, 70, "ExampleText",
 CellID->152355461],
Cell[CellGroupData[{
Cell[9666, 294, 682, 21, 47, "Input",
 CellID->231560287],
Cell[10351, 317, 638, 17, 121, "Output",
 CellID->164262732]
}, Open  ]],
Cell[11004, 337, 123, 3, 70, "ExampleDelimiter",
 CellID->5898560],
Cell[11130, 342, 74, 1, 70, "ExampleText",
 CellID->41648072],
Cell[CellGroupData[{
Cell[11229, 347, 658, 21, 70, "Input",
 CellID->1795833276],
Cell[11890, 370, 722, 20, 70, "Output",
 CellID->408144595]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12661, 396, 227, 7, 70, "ExampleSection",
 CellID->181233884],
Cell[12891, 405, 316, 10, 70, "ExampleText",
 CellID->642170170],
Cell[CellGroupData[{
Cell[13232, 419, 707, 24, 70, "Input",
 CellID->444291304],
Cell[13942, 445, 601, 16, 70, "Output",
 CellID->170569394]
}, Open  ]],
Cell[14558, 464, 125, 3, 70, "ExampleDelimiter",
 CellID->706423579],
Cell[14686, 469, 82, 1, 70, "ExampleText",
 CellID->1660694309],
Cell[CellGroupData[{
Cell[14793, 474, 979, 31, 70, "Input",
 CellID->1788223705],
Cell[15775, 507, 23814, 448, 70, "Output",
 CellID->574754330]
}, Open  ]],
Cell[39604, 958, 125, 3, 70, "ExampleDelimiter",
 CellID->195193327],
Cell[39732, 963, 224, 8, 70, "ExampleText",
 CellID->830925843],
Cell[39959, 973, 2830, 92, 70, "Input",
 CellID->284486860],
Cell[42792, 1067, 153, 5, 70, "Input",
 CellID->108659516],
Cell[CellGroupData[{
Cell[42970, 1076, 1119, 35, 70, "Input",
 CellID->1072057798],
Cell[44092, 1113, 2704, 58, 70, "Output",
 CellID->538717341]
}, Open  ]],
Cell[46811, 1174, 125, 3, 70, "ExampleDelimiter",
 CellID->950092610],
Cell[46939, 1179, 87, 1, 70, "ExampleText",
 CellID->268325457],
Cell[CellGroupData[{
Cell[47051, 1184, 1391, 44, 70, "Input",
 CellID->1431635203],
Cell[48445, 1230, 1045, 26, 70, "Output",
 CellID->254252017]
}, Open  ]],
Cell[49505, 1259, 125, 3, 70, "ExampleDelimiter",
 CellID->187641087],
Cell[49633, 1264, 130, 4, 70, "ExampleText",
 CellID->40168086],
Cell[CellGroupData[{
Cell[49788, 1272, 1428, 45, 70, "Input",
 CellID->83002260],
Cell[51219, 1319, 15624, 269, 70, "Output",
 CellID->3526988]
}, Open  ]],
Cell[66858, 1591, 124, 3, 70, "ExampleDelimiter",
 CellID->13391893],
Cell[66985, 1596, 106, 2, 70, "ExampleText",
 CellID->173939852],
Cell[CellGroupData[{
Cell[67116, 1602, 1883, 58, 70, "Input",
 CellID->1211344882],
Cell[69002, 1662, 15720, 271, 70, "Output",
 CellID->188685820]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84771, 1939, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[85012, 1948, 334, 12, 70, "ExampleText",
 CellID->139373048],
Cell[CellGroupData[{
Cell[85371, 1964, 578, 18, 70, "Input",
 CellID->162100497],
Cell[85952, 1984, 754, 19, 70, "Output",
 CellID->1867210935]
}, Open  ]],
Cell[CellGroupData[{
Cell[86743, 2008, 684, 20, 70, "Input",
 CellID->126335905],
Cell[87430, 2030, 673, 18, 70, "Output",
 CellID->315173815]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[88152, 2054, 230, 7, 70, "ExampleSection",
 CellID->657777349],
Cell[88385, 2063, 138, 4, 70, "ExampleText",
 CellID->1086075833],
Cell[CellGroupData[{
Cell[88548, 2071, 570, 18, 70, "Input",
 CellID->260855],
Cell[89121, 2091, 1776, 36, 70, "Output",
 CellID->507085581]
}, Open  ]],
Cell[90912, 2130, 260, 8, 70, "ExampleText",
 CellID->594115771],
Cell[CellGroupData[{
Cell[91197, 2142, 680, 20, 70, "Input",
 CellID->65525731],
Cell[91880, 2164, 2085, 40, 70, "Output",
 CellID->1779333653]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94026, 2211, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[94345, 2222, 1443, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[95825, 2280, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[96146, 2291, 159, 3, 70, "Tutorials",
 CellID->445434225]
}, Open  ]],
Cell[CellGroupData[{
Cell[96342, 2299, 299, 8, 70, "MoreAboutSection"],
Cell[96644, 2309, 157, 3, 70, "MoreAbout",
 CellID->34961954],
Cell[96804, 2314, 141, 3, 70, "MoreAbout",
 CellID->102439985],
Cell[96948, 2319, 167, 3, 70, "MoreAbout",
 CellID->62541429],
Cell[97118, 2324, 153, 3, 70, "MoreAbout",
 CellID->698407068],
Cell[97274, 2329, 174, 3, 70, "MoreAbout",
 CellID->16117897],
Cell[97451, 2334, 154, 3, 70, "MoreAbout",
 CellID->146184913]
}, Open  ]],
Cell[97620, 2340, 27, 0, 70, "History"],
Cell[97650, 2342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

