(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23047,        775]
NotebookOptionsPosition[     19087,        658]
NotebookOutlinePosition[     21068,        705]
CellTagsIndexPosition[     20983,        700]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], "SessionTime" :> 
          Documentation`HelpLookup["paclet:ref/SessionTime"], "Animator" :> 
          Documentation`HelpLookup["paclet:ref/Animator"], "Refresh" :> 
          Documentation`HelpLookup["paclet:ref/Refresh"], "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteTime\"\>", 
       2->"\<\"SessionTime\"\>", 3->"\<\"Animator\"\>", 4->"\<\"Refresh\"\>", 
       5->"\<\"RandomReal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelInterfaceControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Dynamic Interactivity Language\"\>", 
       3->"\<\"Low-Level Interface Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Clock", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a clock variable whose value cycles \
continuously from 0 to 1 once per second when it appears inside a dynamically \
updated object such as a ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", 
       StyleBox["t", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]cycles from 0 to ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " every ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["max", "TI"]], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]cycles from 0 to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " every ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]cycles through the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " every ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["max", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]cycles through the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " over the course of ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["max", "TI"]], "-", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["min", "TI"]]}]], "InlineFormula"],
     " seconds."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["max", "TI"]], ",", 
         StyleBox["dv", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]cycles from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["dv", "TI"]], "InlineFormula"],
     ", spending ",
     Cell[BoxData[
      StyleBox["dv", "TI"]], "InlineFormula"],
     " seconds at each value."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dv", "TI"]}], "}"}], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]cycles from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " in steps ",
     Cell[BoxData[
      StyleBox["dv", "TI"]], "InlineFormula"],
     " every ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Clock",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Clock"], "[", 
       RowBox[{
        StyleBox["vals", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]goes through the cycle only ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times, then always yields only the maximum value."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The base for all times used by ",
 Cell[BoxData[
  ButtonBox["Clock",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clock"]], "InlineFormula"],
 " is the creation time of the cell in which ",
 Cell[BoxData[
  ButtonBox["Clock",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clock"]], "InlineFormula"],
 " appears."
}], "Notes",
 CellID->18993],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"], "[", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"], "]"}]], "InlineFormula"],
 " gives a value that ranges from ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " at a rate of one unit per second."
}], "Notes",
 CellID->889669199],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["min", "TI"]], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"]}], "}"}], "]"}]], "InlineFormula"],
 " gives a value that ranges from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ", at a rate of one unit per second."
}], "Notes",
 CellID->196867756],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["min", "TI"]], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], ",", 
     StyleBox["dv", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " ranges from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " in steps of ",
 Cell[BoxData[
  StyleBox["dv", "TI"]], "InlineFormula"],
 ", spending ",
 Cell[BoxData[
  StyleBox["dv", "TI"]], "InlineFormula"],
 " seconds at each value."
}], "Notes",
 CellID->141050671]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41878771],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->306623588],

Cell["\<\
Create a clock value that cycles continuously from 0 to 1 once per second:\
\>", "ExampleText",
 CellID->260308989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Clock", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->679108273],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Clock[], StandardForm],
  ImageSizeCache->{56., {0., 8.}}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2044644153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->588989184],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Clock",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clock"]], "InlineFormula"],
 " to trigger updates for some time interval:"
}], "ExampleText",
 CellID->1389086465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"DateString", "[", "]"}], ",", 
    RowBox[{"Clock", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153260476],

Cell[BoxData[
 DynamicBox[ToBoxes[{
    DateString[], 
    Clock[{1, 1}, 1]}, StandardForm],
  ImageSizeCache->{200.1875, {2., 8.}}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1040855024]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->586],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SessionTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SessionTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23247]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29269],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->278677838],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->27130675],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->384154919],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->226915141]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Clock - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 50.1654380}", "context" -> "System`", 
    "keywords" -> {
     "real time clock", "tick", "metronome", "synchronizing signal", 
      "time keeper", "click time"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Clock[] represents a clock variable whose value cycles continuously from \
0 to 1 once per second when it appears inside a dynamically updated object \
such as a Dynamic. Clock[t] cycles from 0 to t every t seconds. Clock[v_max, \
t] cycles from 0 to v_max every t seconds. Clock[{v_min, v_max}, t] cycles \
through the range v_min to v_max every t seconds. Clock[{v_min, v_max}] \
cycles through the range v_min to v_max over the course of v_max - v_min \
seconds. Clock[{v_min, v_max, dv}] cycles from v_min to v_max in steps of dv, \
spending dv seconds at each value. Clock[{v_min, v_max, dv}, t] cycles from \
v_min to v_max in steps dv every t seconds. Clock[vals, t, n] goes through \
the cycle only n times, then always yields only the maximum value.", 
    "synonyms" -> {}, "title" -> "Clock", "type" -> "Symbol", "uri" -> 
    "ref/Clock"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13890, 452, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41878771]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20840, 693}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2695, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3318, 88, 1570, 37, 70, "ObjectNameGrid"],
Cell[4891, 127, 6091, 207, 70, "Usage",
 CellID->7272]
}, Open  ]],
Cell[CellGroupData[{
Cell[11019, 339, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11497, 356, 367, 13, 70, "Notes",
 CellID->18993],
Cell[11867, 371, 498, 17, 70, "Notes",
 CellID->889669199],
Cell[12368, 390, 665, 24, 70, "Notes",
 CellID->196867756],
Cell[13036, 416, 817, 31, 70, "Notes",
 CellID->141050671]
}, Closed]],
Cell[CellGroupData[{
Cell[13890, 452, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41878771],
Cell[CellGroupData[{
Cell[14274, 466, 148, 5, 70, "ExampleSection",
 CellID->306623588],
Cell[14425, 473, 125, 3, 70, "ExampleText",
 CellID->260308989],
Cell[CellGroupData[{
Cell[14575, 480, 130, 4, 28, "Input",
 CellID->679108273],
Cell[14708, 486, 239, 8, 36, "Output",
 CellID->2044644153]
}, Open  ]],
Cell[14962, 497, 125, 3, 70, "ExampleDelimiter",
 CellID->588989184],
Cell[15090, 502, 224, 8, 70, "ExampleText",
 CellID->1389086465],
Cell[CellGroupData[{
Cell[15339, 514, 302, 11, 70, "Input",
 CellID->153260476],
Cell[15644, 527, 276, 9, 70, "Output",
 CellID->1040855024]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15981, 543, 309, 9, 70, "SeeAlsoSection",
 CellID->586],
Cell[16293, 554, 1202, 44, 70, "SeeAlso",
 CellID->23247]
}, Open  ]],
Cell[CellGroupData[{
Cell[17532, 603, 314, 9, 70, "TutorialsSection",
 CellID->29269],
Cell[17849, 614, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[18011, 619, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[18221, 627, 319, 9, 70, "MoreAboutSection",
 CellID->278677838],
Cell[18543, 638, 133, 3, 70, "MoreAbout",
 CellID->27130675],
Cell[18679, 643, 170, 3, 70, "MoreAbout",
 CellID->384154919],
Cell[18852, 648, 163, 3, 70, "MoreAbout",
 CellID->226915141]
}, Open  ]],
Cell[19030, 654, 27, 0, 70, "History"],
Cell[19060, 656, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

