(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30236,       1133]
NotebookOptionsPosition[     23656,        902]
NotebookOutlinePosition[     25041,        941]
CellTagsIndexPosition[     24956,        936]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Picking Out Pieces of Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"], 
          "Finding the Structure of a Polynomial" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingTheStructureOfAPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Picking Out Pieces of Algebraic Expressions\"\>", 
       2->"\<\"Finding the Structure of a Polynomial\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exponent" :> Documentation`HelpLookup["paclet:ref/Exponent"], 
          "CoefficientList" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientList"], 
          "SeriesCoefficient" :> 
          Documentation`HelpLookup["paclet:ref/SeriesCoefficient"], 
          "CoefficientArrays" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientArrays"], 
          "Variables" :> Documentation`HelpLookup["paclet:ref/Variables"], 
          "Numerator" :> Documentation`HelpLookup["paclet:ref/Numerator"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Exponent\"\>", 
       2->"\<\"CoefficientList\"\>", 3->"\<\"SeriesCoefficient\"\>", 
       4->"\<\"CoefficientArrays\"\>", 5->"\<\"Variables\"\>", 
       6->"\<\"Numerator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Formula Manipulation\"\>", 
       2->"\<\"Polynomial Algebra\"\>", 
       3->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Coefficient", "ObjectName",
 CellID->18082],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Coefficient",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Coefficient"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the coefficient of ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in the polynomial ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Coefficient",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Coefficient"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the coefficient of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["form", "TI"], "^", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " picks only terms that contain the particular form specified. ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " is not considered part of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "3"], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->24891],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can be a product of powers. "
}], "Notes",
 CellID->8509],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Coefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coefficient"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " picks out terms that are not proportional to ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21273],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " works whether or not ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is explicitly given in expanded form. "
}], "Notes",
 CellID->30666]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->235053508],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->144811241],

Cell["Find coefficients of polynomials:", "ExampleText",
 CellID->37234259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], ",", "x", ",", " ", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12749815],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40803090]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], "^", "4"}], ",", 
   RowBox[{"x", " ", 
    RowBox[{"y", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->279108285],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261522862]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4698],

Cell[TextData[{
 "Find a coefficient at ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->74438099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}], "+", "c"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70219740],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2201712]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87056782],

Cell[TextData[{
 "Find a coefficient at a power of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->414855875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"c", " ", "x"}], "+", "d"}], ",", "x", ",", "2"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->385472952],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5385274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->681764736],

Cell["Find the free term in a polynomial:", "ExampleText",
 CellID->41792867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "3"}], ")"}], "^", "3"}]}], ",", "x", ",", "0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237739797],

Cell[BoxData["31"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72851494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->626941027],

Cell["Find a coefficient at a multivariate monomial:", "ExampleText",
 CellID->7791694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}], "+", "5"}], ")"}]}], ",", 
   RowBox[{"x", " ", 
    RowBox[{"y", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220072177],

Cell[BoxData["18"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221498960]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29695],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3705],

Cell["Find a coefficient over the integers modulo 2:", "ExampleText",
 CellID->56382699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], ",", "x", ",", " ", "2", ",",
    
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75925904],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563154514]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29217],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " gives a list of all polynomial coefficients:"
}], "ExampleText",
 CellID->3950056],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "3"}], ")"}], "^", "5"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143677547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204798018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"243", ",", "405", ",", "270", ",", "90", ",", "15", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->433198074]
}, Open  ]],

Cell[TextData[{
 "The same list of coefficients obtained using ",
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->60829602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"f", ",", "x", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", 
    RowBox[{"Exponent", "[", 
     RowBox[{"f", ",", "x"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->192705980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"243", ",", "405", ",", "270", ",", "90", ",", "15", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->190657202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->904816869],

Cell[TextData[{
 "For multivariate polynomials ",
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " gives tensors of coefficients:"
}], "ExampleText",
 CellID->104769514],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"5", "y"}]}], ")"}], "^", "4"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241863659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "=", 
  RowBox[{"CoefficientList", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63611906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "625"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1500", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1350", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "540", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{364, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24695106]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " gives a list of arrays of polynomial coefficients ordered by total \
degrees:"
}], "ExampleText",
 CellID->112975120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ca", "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28571790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtO4zAQdeOmF6A3IUF56yIhvgEQCO3D7hMfUSEkeEAg4Fd2fzdrJ55i
TSYZO3EWkjZS63h8mfGZ8dg5d+uPx4fn9cfT/Xr1+239+vh0/7769fKmRLIn
RO+PEOLHUqj3RL2lP/38Vb/sNXubqn+pGq9V2VdlrMpIlSe6VcKoROyh+hjV
Z0y9b+aNkXwSSP88kD0yRQX3viFG2/WlmQ1buWfkc1MumHmk6Rda/8LTDlyP
UlRGaVMmFekjjdd0/xgEwrSpX2S16zKDGx5QQo2KjRjKMusGll3ZI4lRA1Qf
EWuMja14nI+cq9vWbg+Kw/+E7mekRgYDa02wnrwktte9gTgnjSjtuV4c0rTG
oowEcnoUZIyBKXFejEp1DSu2ch6B0Tsf8D4YfYmH8nvmgPaKg5/GuX6we6t5
wR61iQNk78ZLZNTo1imjm7sh4EyH17JoHV44LiFuOaR871Yccti+XuIUf0l2
+lEYwUmFMXTdDf28toKRfBbg7lYuN9OyOht33wanYc4uF3yq3OT9s93YQsPp
lDL96NOGzvAUwpC3fOdibmukXw7RGLzvOGS5bATfjh3BMKFvvDheMYq+8cqh
WvLtReRu+9Zv73DcBt8Y0vSxtYiCMVHBPPB1ITegCqvVtnJM+uGI8oMHguQN
0KpPWokV/nY/ZlDyjTsONbe402s8R7JVJa/Te3TiIeVWgOPAxXbOC7TV08bX
UnyK2VGn/8+M7NSU+0kWfUtiBl2dobLoNJ876tI7h0JNmjl8dNLsnH7FPKb/
G9aJb8ehmMmmmU9XZvMyXTWVdUIyjvvMuCYZThe9VyQKkKkxZtvJ1e0YzJCM
5EVCRRzPy+24s3KcOB/scPSLt+ooZycLxoS2s32sWT2WsXssYljWlcPnNp3f
LXu2hxmrxyB2hyEMy6Ry9vnEUse4LdIrHD+4ZfxfJYx82T2fGGwnj1WN8+sm
pxeG/+SwqRNTTfN5TXB04flFt5OD4uB0VfurLgtXl3Urm5tj2X6mU2uRC28m
ev8AkkxmOA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->750389548]
}, Open  ]],

Cell[TextData[{
 "The coefficient at ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], " ", 
   SuperscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["3", "TR"]]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9322727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", " ", 
    RowBox[{"y", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->519298020],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->45858691]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  StyleBox["cl", "TI"]], "InlineFormula"],
 " it is the element at position ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     StyleBox["exponent", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["of", "ExampleText"], " ", 
     StyleBox["x", "TI"]}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{
     StyleBox["exponent", "ExampleText"], 
     StyleBox[" ", "ExampleText"], 
     StyleBox["of", "ExampleText"], " ", 
     StyleBox["y", "TI"]}]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->264421385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"1", "+", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->37654526],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->598791171]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  StyleBox["ca", "TI"]], "InlineFormula"],
 " it is at position ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   StyleBox[
    RowBox[{"degree", " ", "of", " ", "monomial"}], "ExampleText"]}]], 
  "InlineFormula"],
 ", first variable, three times second variable:"
}], "ExampleText",
 CellID->111634366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ca", "[", 
  RowBox[{"[", 
   RowBox[{"5", ",", "1", ",", "2", ",", "2", ",", "2"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->365051057],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->84078551]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2774],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variables",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Numerator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Numerator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27412],

Cell[TextData[ButtonBox["Picking Out Pieces of Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]], "Tutorials",
 CellID->31888],

Cell[TextData[ButtonBox["Finding the Structure of a Polynomial",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingTheStructureOfAPolynomial"]], "Tutorials",\

 CellID->6084]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->117183515],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->156437],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->343244631],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->276357336]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Coefficient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 54.0405372}", "context" -> "System`", 
    "keywords" -> {
     "coef", "coefficient of a polynomial", "monomial coefficient", 
      "polynomial coefficient"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Coefficient[expr, form] gives the coefficient of form in the polynomial \
expr. Coefficient[expr, form, n] gives the coefficient of form^n in expr. ", 
    "synonyms" -> {}, "title" -> "Coefficient", "type" -> "Symbol", "uri" -> 
    "ref/Coefficient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6742, 216, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->235053508]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24813, 929}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2916, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3539, 93, 49, 1, 70, "ObjectName",
 CellID->18082],
Cell[3591, 96, 1304, 43, 70, "Usage",
 CellID->13718]
}, Open  ]],
Cell[CellGroupData[{
Cell[4932, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5410, 161, 452, 15, 70, "Notes",
 CellID->24891],
Cell[5865, 178, 136, 5, 70, "Notes",
 CellID->8509],
Cell[6004, 185, 399, 14, 70, "Notes",
 CellID->21273],
Cell[6406, 201, 299, 10, 70, "Notes",
 CellID->30666]
}, Closed]],
Cell[CellGroupData[{
Cell[6742, 216, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->235053508],
Cell[CellGroupData[{
Cell[7127, 230, 148, 5, 70, "ExampleSection",
 CellID->144811241],
Cell[7278, 237, 75, 1, 70, "ExampleText",
 CellID->37234259],
Cell[CellGroupData[{
Cell[7378, 242, 222, 8, 28, "Input",
 CellID->12749815],
Cell[7603, 252, 157, 5, 36, "Output",
 CellID->40803090]
}, Open  ]],
Cell[CellGroupData[{
Cell[7797, 262, 254, 9, 28, "Input",
 CellID->279108285],
Cell[8054, 273, 158, 5, 36, "Output",
 CellID->261522862]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8261, 284, 215, 7, 70, "ExampleSection",
 CellID->4698],
Cell[8479, 293, 142, 6, 70, "ExampleText",
 CellID->74438099],
Cell[CellGroupData[{
Cell[8646, 303, 213, 7, 70, "Input",
 CellID->70219740],
Cell[8862, 312, 156, 5, 36, "Output",
 CellID->2201712]
}, Open  ]],
Cell[9033, 320, 124, 3, 70, "ExampleDelimiter",
 CellID->87056782],
Cell[9160, 325, 154, 6, 70, "ExampleText",
 CellID->414855875],
Cell[CellGroupData[{
Cell[9339, 335, 313, 11, 70, "Input",
 CellID->385472952],
Cell[9655, 348, 156, 5, 36, "Output",
 CellID->5385274]
}, Open  ]],
Cell[9826, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->681764736],
Cell[9954, 361, 77, 1, 70, "ExampleText",
 CellID->41792867],
Cell[CellGroupData[{
Cell[10056, 366, 323, 12, 70, "Input",
 CellID->237739797],
Cell[10382, 380, 158, 5, 36, "Output",
 CellID->72851494]
}, Open  ]],
Cell[10555, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->626941027],
Cell[10683, 393, 87, 1, 70, "ExampleText",
 CellID->7791694],
Cell[CellGroupData[{
Cell[10795, 398, 432, 16, 70, "Input",
 CellID->220072177],
Cell[11230, 416, 159, 5, 36, "Output",
 CellID->221498960]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11438, 427, 218, 7, 70, "ExampleSection",
 CellID->29695],
Cell[CellGroupData[{
Cell[11681, 438, 223, 7, 70, "ExampleSubsection",
 CellID->3705],
Cell[11907, 447, 88, 1, 70, "ExampleText",
 CellID->56382699],
Cell[CellGroupData[{
Cell[12020, 452, 269, 9, 70, "Input",
 CellID->75925904],
Cell[12292, 463, 158, 5, 36, "Output",
 CellID->563154514]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[12511, 475, 233, 7, 70, "ExampleSection",
 CellID->29217],
Cell[12747, 484, 234, 7, 70, "ExampleText",
 CellID->3950056],
Cell[12984, 493, 185, 7, 70, "Input",
 CellID->143677547],
Cell[CellGroupData[{
Cell[13194, 504, 134, 4, 70, "Input",
 CellID->204798018],
Cell[13331, 510, 255, 8, 36, "Output",
 CellID->433198074]
}, Open  ]],
Cell[13601, 521, 362, 13, 70, "ExampleText",
 CellID->60829602],
Cell[CellGroupData[{
Cell[13988, 538, 304, 10, 70, "Input",
 CellID->192705980],
Cell[14295, 550, 255, 8, 36, "Output",
 CellID->190657202]
}, Open  ]],
Cell[14565, 561, 125, 3, 70, "ExampleDelimiter",
 CellID->904816869],
Cell[14693, 566, 256, 8, 70, "ExampleText",
 CellID->104769514],
Cell[14952, 576, 229, 9, 70, "Input",
 CellID->241863659],
Cell[CellGroupData[{
Cell[15206, 589, 214, 7, 70, "Input",
 CellID->63611906],
Cell[15423, 598, 642, 18, 54, "Output",
 CellID->24695106]
}, Open  ]],
Cell[16080, 619, 273, 8, 70, "ExampleText",
 CellID->112975120],
Cell[CellGroupData[{
Cell[16378, 631, 211, 7, 70, "Input",
 CellID->28571790],
Cell[16592, 640, 1261, 25, 70, "Output",
 Evaluatable->False,
 CellID->750389548]
}, Open  ]],
Cell[17868, 668, 229, 10, 70, "ExampleText",
 CellID->9322727],
Cell[CellGroupData[{
Cell[18122, 682, 179, 6, 70, "Input",
 CellID->519298020],
Cell[18304, 690, 160, 5, 36, "Output",
 CellID->45858691]
}, Open  ]],
Cell[18479, 698, 586, 21, 70, "ExampleText",
 CellID->264421385],
Cell[CellGroupData[{
Cell[19090, 723, 194, 7, 70, "Input",
 CellID->37654526],
Cell[19287, 732, 161, 5, 36, "Output",
 CellID->598791171]
}, Open  ]],
Cell[19463, 740, 335, 12, 70, "ExampleText",
 CellID->111634366],
Cell[CellGroupData[{
Cell[19823, 756, 178, 6, 70, "Input",
 CellID->365051057],
Cell[20004, 764, 160, 5, 36, "Output",
 CellID->84078551]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20225, 776, 310, 9, 70, "SeeAlsoSection",
 CellID->2774],
Cell[20538, 787, 1485, 53, 70, "SeeAlso",
 CellID->27448]
}, Open  ]],
Cell[CellGroupData[{
Cell[22060, 845, 314, 9, 70, "TutorialsSection",
 CellID->27412],
Cell[22377, 856, 195, 4, 70, "Tutorials",
 CellID->31888],
Cell[22575, 862, 181, 4, 70, "Tutorials",
 CellID->6084]
}, Open  ]],
Cell[CellGroupData[{
Cell[22793, 871, 319, 9, 70, "MoreAboutSection",
 CellID->117183515],
Cell[23115, 882, 148, 3, 70, "MoreAbout",
 CellID->156437],
Cell[23266, 887, 147, 3, 70, "MoreAbout",
 CellID->343244631],
Cell[23416, 892, 145, 3, 70, "MoreAbout",
 CellID->276357336]
}, Open  ]],
Cell[23576, 898, 50, 0, 70, "History"],
Cell[23629, 900, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

