(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42692,       1586]
NotebookOptionsPosition[     34102,       1282]
NotebookOutlinePosition[     35560,       1322]
CellTagsIndexPosition[     35474,       1317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding the Structure of a Polynomial" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingTheStructureOfAPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Finding the Structure of a Polynomial\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "CoefficientArrays" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientArrays"], 
          "SeriesCoefficient" :> 
          Documentation`HelpLookup["paclet:ref/SeriesCoefficient"], 
          "Coefficient" :> Documentation`HelpLookup["paclet:ref/Coefficient"],
           "Collect" :> Documentation`HelpLookup["paclet:ref/Collect"], 
          "FactorList" :> Documentation`HelpLookup["paclet:ref/FactorList"], 
          "FromDigits" :> 
          Documentation`HelpLookup["paclet:ref/FromDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Series\"\>", 
       2->"\<\"CoefficientArrays\"\>", 3->"\<\"SeriesCoefficient\"\>", 
       4->"\<\"Coefficient\"\>", 5->"\<\"Collect\"\>", 
       6->"\<\"FactorList\"\>", 7->"\<\"FromDigits\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Polynomial Algebra\"\>", 3->"\<\"Polynomial Systems\"\>", 
       4->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CoefficientList", "ObjectName",
 CellID->8026],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CoefficientList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CoefficientList"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of coefficients of powers of ",
     Cell[BoxData[
      StyleBox["var", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     ", starting with power ",
     Cell[BoxData[
      StyleBox["0", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CoefficientList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CoefficientList"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["var", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["var", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an array of coefficients of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["var", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1587]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The dimensions of the array returned by ",
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " are determined by the values of the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    SubscriptBox[
     StyleBox["var", "TI"], 
     StyleBox["i", "TI"]]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2348],

Cell["\<\
Terms that do not contain positive integer powers of a particular variable \
are included in the first element of the list for that variable. \
\>", "Notes",
 CellID->7654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " always returns a full rectangular array. Combinations of powers that do \
not appear in ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " give zeros in the array. "
}], "Notes",
 CellID->31287],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoefficientList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientList"], "[", 
   RowBox[{"0", ",", 
    StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31609],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " works whether or not ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " is explicitly given in expanded form. "
}], "Notes",
 CellID->17407]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56084402],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->10247075],

Cell["Find the coefficients in a polynomial:", "ExampleText",
 CellID->11421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"6", "x"}], "-", 
    RowBox[{"x", "^", "4"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "6", ",", "0", ",", "0", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490266092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29746],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " works even when the polynomial has not been expanded out:"
}], "ExampleText",
 CellID->7416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "10"}], " ", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "10", ",", "45", ",", "120", ",", "210", ",", "252", ",", "210", 
   ",", "120", ",", "45", ",", "10", ",", "1"}], "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->704163870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->629],

Cell["Matrix of coefficients for a quadratic form:", "ExampleText",
 CellID->18119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x", " ", "y"}], " ", "+", " ", 
    RowBox[{"c", " ", 
     RowBox[{"y", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2188917]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18557],

Cell["Univariate polynomial coefficient lists:", "ExampleText",
 CellID->85645844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "x"}], "+", "3"}], ")"}], "^", "5"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313591940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"243", ",", "810", ",", "1080", ",", "720", ",", "240", ",", "32"}],
   "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->530196603]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"d", " ", "x"}], "+", "e"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224905847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", "d", ",", "c", ",", "b", ",", "a"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4230847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444808486],

Cell["Multivariate polynomial coefficient lists:", "ExampleText",
 CellID->365578299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", " ", "y"}], "+", "1"}], ")"}], "^", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4677501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "12", ",", "48", ",", "64"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "72", ",", "144", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "108", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22719798]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"z", "^", "3"}]}], "+", "5"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26418774],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmttSwjAQhkNbzip45yXP4EPolQ/BMM7AhaODvJq+HjaFSOfvhiRNSxNY
Z6DZNIc/202afPK23K3fP5a7zWq5eN0uv9ab1ffi5XObZ6U9IXo/QojnJ5Gn
93mq+Mi/3/xzSB5SU/mdqrt7kYE9BnvmaWP7E0N/c+7PqT+0U/lVUUGpTHJz
rrk+Eq3KfGx3UiofYzsmbyZW3pSl+rmJ+cP8S5r9lvKxvxHhJareiHUFrat+
FIr+v13UOcSkjPxhB3dRrSyN6+F51SNWfVOqzbMAx2Sq9UD2fe+di3P4HuyU
rMVquldjipje3ma1RdtfJ52L/eB+kJ7TbfmS1diraeatjtF7d5O+ZDV6Nc3E
2QDs6U36ktXo1bR5SuG3J6upE20mmilLSXNmuGI95ESqnXnk7djRQ5lEbuye
YtJ8Xf0xafZph/Jeomao82mT2r25EOjxMT+1LG8ipzoCzkQ3bF319nA63ujD
CPFtkRhrUQriI56suju6nKgV0EiV8XSMRFO/Kx7kV5rZmCgpuT/vgNYOwW6L
QMVFjYt4dqZ3D9QYWz3FXer/ISYdOINuk2OSZyDnKMIx0b4sxpSdStX1GDkv
O3hyasVuax28xsjBWYdjoilvuVT8Mz4UHTHGjz+tbSaWmIyGqoaOK5L9ZeW2
+keNqTjRSsVSVH7oNLUtKlvMysLwp7CuJImpbFz90VQWuZ5NxDGlNVFaV6/q
KJ8rtdPRWl3+pehj0xQ5FCoaqi6a1rpGZXu/E9YxXCqfOtldjigybY5JNTWK
w3uOiqRzNrJMu/NwmeMOCI1NE9P6zBh7xt2G/6+6QqXFNJ91XRvr8ZJrpBWo
o/lICtUT9Im27t5Pnfno83iV0VZzTH4q92Q75qbYsFqNyyf366LAzUXDuVHR
fkN2hrZNZFTuX5Tb8SrCcVPnqTFhNUWSK9eTY8iOqtVV3kYygs+eYpyZqDLN
2NitH3MVvT/dqwTk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{437, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->206869683]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4834],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18859],

Cell["Coefficient list over the integers modulo 2:", "ExampleText",
 CellID->916818353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "^", "5"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107342719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125713769]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16363],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " to get a coefficient at a specified power of the variable:"
}], "ExampleText",
 CellID->109660459],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "x"}], "+", "3"}], ")"}], "^", "3"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372441503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", "x", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->495972122],

Cell[BoxData["36"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135064702]
}, Open  ]],

Cell[TextData[{
 "The list of coefficients can be obtained using ",
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->60829602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"f", ",", "x", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", 
    RowBox[{"Exponent", "[", 
     RowBox[{"f", ",", "x"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->192705980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27", ",", "54", ",", "36", ",", "8"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->78923714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->292252059],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27", ",", "54", ",", "36", ",", "8"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->80021053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67117802],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromDigits"]], "InlineFormula"],
 " can reconstruct a univariate polynomial from the list of its \
coefficients:"
}], "ExampleText",
 CellID->30606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"a", " ", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103348900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{
   RowBox[{"Reverse", "[", "%", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15458],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"b", " ", "x"}], "+", 
  RowBox[{"c", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356190620]
}, Open  ]],

Cell["Fold the operation for multivariate polynomials:", "ExampleText",
 CellID->216196456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ")"}], "^", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->115381586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "12", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->106326180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FromDigits", "[", 
     RowBox[{
      RowBox[{"Reverse", "[", "#1", "]"}], ",", "#2"}], "]"}], "&"}], ",", 
   "%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20181176],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{
   SuperscriptBox["y", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"12", " ", "x"}], "+", 
     RowBox[{"8", " ", "y"}]}], ")"}]}]}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->82205265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], ")"}], "^", "3"}], "-", "%"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->573491448],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->708369798]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20986],

Cell[TextData[{
 "Polynomial multiplication is convolution as performed by ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"x", "^", "2"}]}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"x", "^", "3"}]}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15629],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{
    RowBox[{"2", " ", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"3", " ", "a"}], "+", 
    RowBox[{"2", " ", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "a"}], "+", 
    RowBox[{"3", " ", "b"}], "+", 
    RowBox[{"2", " ", "c"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "b"}], "+", 
    RowBox[{"3", " ", "c"}]}], ",", 
   RowBox[{"4", " ", "c"}]}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9745596]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24517],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{
    RowBox[{"2", " ", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"3", " ", "a"}], "+", 
    RowBox[{"2", " ", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"4", " ", "a"}], "+", 
    RowBox[{"3", " ", "b"}], "+", 
    RowBox[{"2", " ", "c"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "b"}], "+", 
    RowBox[{"3", " ", "c"}]}], ",", 
   RowBox[{"4", " ", "c"}]}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->95824579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->904816869],

Cell[TextData[{
 "For multivariate polynomials ",
 Cell[BoxData[
  ButtonBox["CoefficientList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientList"]], "InlineFormula"],
 " gives tensors of coefficients:"
}], "ExampleText",
 CellID->104769514],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "x"}], "+", 
      RowBox[{"5", "y"}]}], ")"}], "^", "4"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241863659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "=", 
  RowBox[{"CoefficientList", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63611906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "625"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1500", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1350", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "540", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{364, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156963670]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " gives a list of arrays of polynomial coefficients ordered by total \
degrees:"
}], "ExampleText",
 CellID->112975120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ca", "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28571790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtO4zAQdeOmF6A3IUF56yIhvgEQCO3D7hMfUSEkeEAg4Fd2fzdrJ55i
TSYZO3EWkjZS63h8mfGZ8dg5d+uPx4fn9cfT/Xr1+239+vh0/7769fKmRLIn
RO+PEOLHUqj3RL2lP/38Vb/sNXubqn+pGq9V2VdlrMpIlSe6VcKoROyh+hjV
Z0y9b+aNkXwSSP88kD0yRQX3viFG2/WlmQ1buWfkc1MumHmk6Rda/8LTDlyP
UlRGaVMmFekjjdd0/xgEwrSpX2S16zKDGx5QQo2KjRjKMusGll3ZI4lRA1Qf
EWuMja14nI+cq9vWbg+Kw/+E7mekRgYDa02wnrwktte9gTgnjSjtuV4c0rTG
oowEcnoUZIyBKXFejEp1DSu2ch6B0Tsf8D4YfYmH8nvmgPaKg5/GuX6we6t5
wR61iQNk78ZLZNTo1imjm7sh4EyH17JoHV44LiFuOaR871Yccti+XuIUf0l2
+lEYwUmFMXTdDf28toKRfBbg7lYuN9OyOht33wanYc4uF3yq3OT9s93YQsPp
lDL96NOGzvAUwpC3fOdibmukXw7RGLzvOGS5bATfjh3BMKFvvDheMYq+8cqh
WvLtReRu+9Zv73DcBt8Y0vSxtYiCMVHBPPB1ITegCqvVtnJM+uGI8oMHguQN
0KpPWokV/nY/ZlDyjTsONbe402s8R7JVJa/Te3TiIeVWgOPAxXbOC7TV08bX
UnyK2VGn/8+M7NSU+0kWfUtiBl2dobLoNJ876tI7h0JNmjl8dNLsnH7FPKb/
G9aJb8ehmMmmmU9XZvMyXTWVdUIyjvvMuCYZThe9VyQKkKkxZtvJ1e0YzJCM
5EVCRRzPy+24s3KcOB/scPSLt+ooZycLxoS2s32sWT2WsXssYljWlcPnNp3f
LXu2hxmrxyB2hyEMy6Ry9vnEUse4LdIrHD+4ZfxfJYx82T2fGGwnj1WN8+sm
pxeG/+SwqRNTTfN5TXB04flFt5OD4uB0VfurLgtXl3Urm5tj2X6mU2uRC28m
ev8AkkxmOA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->248757380]
}, Open  ]],

Cell[TextData[{
 "The coefficient at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[InvisibleSpace]", 
    SuperscriptBox["y", "3"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->9322727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"f", ",", 
   RowBox[{"x", " ", 
    RowBox[{"y", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->519298020],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->420527066]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  StyleBox["cl", "TI"]], "InlineFormula"],
 " it is the element at position {1+exponent of x, 1+exponent of y}:"
}], "ExampleText",
 CellID->264421385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"1", "+", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->37654526],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->105794270]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  StyleBox["ca", "TI"]], "InlineFormula"],
 " it is at position 1+degree of monomial, first variable, three times second \
variable:"
}], "ExampleText",
 CellID->111634366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ca", "[", 
  RowBox[{"[", 
   RowBox[{"5", ",", "1", ",", "2", ",", "2", ",", "2"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->365051057],

Cell[BoxData["1500"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->481315453]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15960],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5345]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6331],

Cell[TextData[ButtonBox["Finding the Structure of a Polynomial",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingTheStructureOfAPolynomial"]], "Tutorials",\

 CellID->5642]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->843019403],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->468274411],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->355524245],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->143909423],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->291987789]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with CoefficientList",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
CoefficientList"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
CoefficientList"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoefficientList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 53.6342768}", "context" -> "System`", 
    "keywords" -> {
     "coefficient of a polynomial", "monomial coefficients", 
      "polynomial coefficients"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CoefficientList[poly, var] gives a list of coefficients of powers of var \
in poly, starting with power 0. CoefficientList[poly, {var_1, var_2, ...}] \
gives an array of coefficients of the var_i. ", 
    "synonyms" -> {"coefficient list"}, "title" -> "CoefficientList", "type" -> 
    "Symbol", "uri" -> "ref/CoefficientList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7427, 238, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56084402]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35332, 1310}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2905, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3528, 93, 52, 1, 70, "ObjectName",
 CellID->8026],
Cell[3583, 96, 1564, 50, 70, "Usage",
 CellID->1587]
}, Open  ]],
Cell[CellGroupData[{
Cell[5184, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5662, 168, 537, 19, 70, "Notes",
 CellID->2348],
Cell[6202, 189, 182, 4, 70, "Notes",
 CellID->7654],
Cell[6387, 195, 361, 11, 70, "Notes",
 CellID->31287],
Cell[6751, 208, 329, 13, 70, "Notes",
 CellID->31609],
Cell[7083, 223, 307, 10, 70, "Notes",
 CellID->17407]
}, Closed]],
Cell[CellGroupData[{
Cell[7427, 238, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56084402],
Cell[CellGroupData[{
Cell[7811, 252, 147, 5, 70, "ExampleSection",
 CellID->10247075],
Cell[7961, 259, 77, 1, 70, "ExampleText",
 CellID->11421],
Cell[CellGroupData[{
Cell[8063, 264, 208, 7, 28, "Input",
 CellID->3968],
Cell[8274, 273, 253, 8, 36, "Output",
 CellID->490266092]
}, Open  ]],
Cell[8542, 284, 121, 3, 70, "ExampleDelimiter",
 CellID->29746],
Cell[8666, 289, 244, 7, 70, "ExampleText",
 CellID->7416],
Cell[CellGroupData[{
Cell[8935, 300, 214, 8, 70, "Input",
 CellID->20288],
Cell[9152, 310, 315, 9, 36, "Output",
 CellID->704163870]
}, Open  ]],
Cell[9482, 322, 119, 3, 70, "ExampleDelimiter",
 CellID->629],
Cell[9604, 327, 83, 1, 70, "ExampleText",
 CellID->18119],
Cell[CellGroupData[{
Cell[9712, 332, 370, 12, 70, "Input",
 CellID->14667],
Cell[10085, 346, 389, 13, 36, "Output",
 CellID->2188917]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10523, 365, 216, 7, 70, "ExampleSection",
 CellID->18557],
Cell[10742, 374, 82, 1, 70, "ExampleText",
 CellID->85645844],
Cell[CellGroupData[{
Cell[10849, 379, 234, 9, 70, "Input",
 CellID->313591940],
Cell[11086, 390, 259, 8, 36, "Output",
 CellID->530196603]
}, Open  ]],
Cell[CellGroupData[{
Cell[11382, 403, 366, 12, 70, "Input",
 CellID->224905847],
Cell[11751, 417, 231, 7, 36, "Output",
 CellID->4230847]
}, Open  ]],
Cell[11997, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->444808486],
Cell[12125, 432, 85, 1, 70, "ExampleText",
 CellID->365578299],
Cell[CellGroupData[{
Cell[12235, 437, 315, 11, 70, "Input",
 CellID->4677501],
Cell[12553, 450, 509, 15, 36, "Output",
 CellID->22719798]
}, Open  ]],
Cell[CellGroupData[{
Cell[13099, 470, 475, 16, 70, "Input",
 CellID->26418774],
Cell[13577, 488, 1204, 24, 70, "Output",
 Evaluatable->False,
 CellID->206869683]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14830, 518, 217, 7, 70, "ExampleSection",
 CellID->4834],
Cell[CellGroupData[{
Cell[15072, 529, 224, 7, 70, "ExampleSubsection",
 CellID->18859],
Cell[15299, 538, 87, 1, 70, "ExampleText",
 CellID->916818353],
Cell[CellGroupData[{
Cell[15411, 543, 255, 8, 70, "Input",
 CellID->107342719],
Cell[15669, 553, 247, 8, 36, "Output",
 CellID->125713769]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[15977, 568, 233, 7, 70, "ExampleSection",
 CellID->16363],
Cell[16213, 577, 251, 8, 70, "ExampleText",
 CellID->109660459],
Cell[16467, 587, 207, 8, 70, "Input",
 CellID->372441503],
Cell[CellGroupData[{
Cell[16699, 599, 140, 4, 70, "Input",
 CellID->495972122],
Cell[16842, 605, 159, 5, 36, "Output",
 CellID->135064702]
}, Open  ]],
Cell[17016, 613, 364, 13, 70, "ExampleText",
 CellID->60829602],
Cell[CellGroupData[{
Cell[17405, 630, 304, 10, 70, "Input",
 CellID->192705980],
Cell[17712, 642, 226, 7, 36, "Output",
 CellID->78923714]
}, Open  ]],
Cell[CellGroupData[{
Cell[17975, 654, 134, 4, 70, "Input",
 CellID->292252059],
Cell[18112, 660, 226, 7, 36, "Output",
 CellID->80021053]
}, Open  ]],
Cell[18353, 670, 124, 3, 70, "ExampleDelimiter",
 CellID->67117802],
Cell[18480, 675, 254, 8, 70, "ExampleText",
 CellID->30606],
Cell[CellGroupData[{
Cell[18759, 687, 245, 8, 70, "Input",
 CellID->18978],
Cell[19007, 697, 213, 7, 36, "Output",
 CellID->103348900]
}, Open  ]],
Cell[CellGroupData[{
Cell[19257, 709, 160, 5, 70, "Input",
 CellID->15458],
Cell[19420, 716, 261, 9, 36, "Output",
 CellID->356190620]
}, Open  ]],
Cell[19696, 728, 91, 1, 70, "ExampleText",
 CellID->216196456],
Cell[CellGroupData[{
Cell[19812, 733, 280, 10, 70, "Input",
 CellID->115381586],
Cell[20095, 745, 501, 15, 36, "Output",
 CellID->106326180]
}, Open  ]],
Cell[CellGroupData[{
Cell[20633, 765, 309, 11, 70, "Input",
 CellID->20181176],
Cell[20945, 778, 422, 15, 36, "Output",
 CellID->82205265]
}, Open  ]],
Cell[CellGroupData[{
Cell[21404, 798, 222, 8, 70, "Input",
 CellID->573491448],
Cell[21629, 808, 158, 5, 36, "Output",
 CellID->708369798]
}, Open  ]],
Cell[21802, 816, 121, 3, 70, "ExampleDelimiter",
 CellID->20986],
Cell[21926, 821, 244, 8, 70, "ExampleText",
 CellID->25526],
Cell[CellGroupData[{
Cell[22195, 833, 485, 17, 70, "Input",
 CellID->15629],
Cell[22683, 852, 582, 20, 36, "Output",
 CellID->9745596]
}, Open  ]],
Cell[CellGroupData[{
Cell[23302, 877, 345, 11, 70, "Input",
 CellID->24517],
Cell[23650, 890, 583, 20, 36, "Output",
 CellID->95824579]
}, Open  ]],
Cell[24248, 913, 125, 3, 70, "ExampleDelimiter",
 CellID->904816869],
Cell[24376, 918, 256, 8, 70, "ExampleText",
 CellID->104769514],
Cell[24635, 928, 229, 9, 70, "Input",
 CellID->241863659],
Cell[CellGroupData[{
Cell[24889, 941, 214, 7, 70, "Input",
 CellID->63611906],
Cell[25106, 950, 643, 18, 54, "Output",
 CellID->156963670]
}, Open  ]],
Cell[25764, 971, 273, 8, 70, "ExampleText",
 CellID->112975120],
Cell[CellGroupData[{
Cell[26062, 983, 211, 7, 70, "Input",
 CellID->28571790],
Cell[26276, 992, 1261, 25, 70, "Output",
 Evaluatable->False,
 CellID->248757380]
}, Open  ]],
Cell[27552, 1020, 211, 8, 70, "ExampleText",
 CellID->9322727],
Cell[CellGroupData[{
Cell[27788, 1032, 179, 6, 70, "Input",
 CellID->519298020],
Cell[27970, 1040, 161, 5, 36, "Output",
 CellID->420527066]
}, Open  ]],
Cell[28146, 1048, 190, 6, 70, "ExampleText",
 CellID->264421385],
Cell[CellGroupData[{
Cell[28361, 1058, 194, 7, 70, "Input",
 CellID->37654526],
Cell[28558, 1067, 161, 5, 36, "Output",
 CellID->105794270]
}, Open  ]],
Cell[28734, 1075, 211, 7, 70, "ExampleText",
 CellID->111634366],
Cell[CellGroupData[{
Cell[28970, 1086, 178, 6, 70, "Input",
 CellID->365051057],
Cell[29151, 1094, 161, 5, 36, "Output",
 CellID->481315453]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29373, 1106, 311, 9, 70, "SeeAlsoSection",
 CellID->15960],
Cell[29687, 1117, 1719, 62, 70, "SeeAlso",
 CellID->5345]
}, Open  ]],
Cell[CellGroupData[{
Cell[31443, 1184, 313, 9, 70, "TutorialsSection",
 CellID->6331],
Cell[31759, 1195, 181, 4, 70, "Tutorials",
 CellID->5642]
}, Open  ]],
Cell[CellGroupData[{
Cell[31977, 1204, 319, 9, 70, "MoreAboutSection",
 CellID->843019403],
Cell[32299, 1215, 147, 3, 70, "MoreAbout",
 CellID->468274411],
Cell[32449, 1220, 147, 3, 70, "MoreAbout",
 CellID->355524245],
Cell[32599, 1225, 147, 3, 70, "MoreAbout",
 CellID->143909423],
Cell[32749, 1230, 145, 3, 70, "MoreAbout",
 CellID->291987789]
}, Open  ]],
Cell[CellGroupData[{
Cell[32931, 1238, 305, 8, 70, "RelatedLinksSection"],
Cell[33239, 1248, 372, 12, 70, "RelatedLinks"],
Cell[33614, 1262, 393, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[34022, 1278, 50, 0, 70, "History"],
Cell[34075, 1280, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

