(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41224,       1466]
NotebookOptionsPosition[     34647,       1243]
NotebookOutlinePosition[     36195,       1284]
CellTagsIndexPosition[     36109,       1279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Structural Operations on Polynomials\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "CoefficientList" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientList"], 
          "HornerForm" :> Documentation`HelpLookup["paclet:ref/HornerForm"], 
          "Together" :> Documentation`HelpLookup["paclet:ref/Together"], 
          "Cases" :> Documentation`HelpLookup["paclet:ref/Cases"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Series\"\>", 
       2->"\<\"CoefficientList\"\>", 3->"\<\"HornerForm\"\>", 
       4->"\<\"Together\"\>", 5->"\<\"Cases\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>", 
       3->"\<\"Polynomial Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Collect", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Collect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Collect"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]collects together terms involving the same powers of \
objects matching ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Collect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Collect"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]collects together terms that involve the same powers of \
objects matching ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Collect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Collect"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["var", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " to the expression that forms the coefficient of each term obtained. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->11785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " effectively writes ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as a polynomial in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " or a fractional power of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20783],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    ButtonBox["Simplify",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Simplify"]}], "]"}]], "InlineFormula"],
 " can be used to simplify each coefficient separately. "
}], "Notes",
 CellID->7238],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Collect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Collect"]], "InlineFormula"],
 " automatically threads over lists in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", as well as equations, inequalities and logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244796202],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->381245174],

Cell[TextData[{
 "Collect terms involving ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->74400960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}], "+", 
    RowBox[{"c", " ", "x"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621681711],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "c"}], ")"}], " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}]}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53877057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151994285],

Cell[TextData[{
 "Collect each power of ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->198131932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a", "+", "x"}], ")"}], "^", "4"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541412242],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"4", " ", "a"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["a", "3"]}], "+", 
  SuperscriptBox["a", "4"], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"12", " ", "a"}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["a", "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "3"]}]}], ")"}], " ", "x"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"6", "+", 
     RowBox[{"12", " ", "a"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["a", "2"]}]}], ")"}], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"4", " ", "a"}]}], ")"}], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{519, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542074602]
}, Open  ]],

Cell["Simplify each coefficient:", "ExampleText",
 CellID->58357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a", "+", "x"}], ")"}], "^", "4"}], ",", "x", ",", 
   "Simplify"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205494822],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "4"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], "3"], " ", "x"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], "2"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251492067]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29837],

Cell["A polynomial:", "ExampleText",
 CellID->121006457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"a", "^", "2"}], "x"}], "-", 
    RowBox[{"3", "b", " ", "x"}], "+", "x", "-", "7"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194985057],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "-", 
     RowBox[{"3", " ", "b"}]}], ")"}], " ", "x"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 ImageSize->{196, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481744264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72292724],

Cell["A Puiseux polynomial:", "ExampleText",
 CellID->120937581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], "+", 
    RowBox[{"Sqrt", "[", "x", "]"}], "+", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"2", "/", "3"}], ")"}]}], "-", 
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"3", "x"}], "-", 
    RowBox[{"2", "b", " ", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"2", "/", "3"}], ")"}]}]}], "+", "5"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179157545],

Cell[BoxData[
 RowBox[{"5", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], " ", 
   SqrtBox["x"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "b"}]}], ")"}], " ", 
   SuperscriptBox["x", 
    RowBox[{"2", "/", "3"}]]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"3", "-", "c"}], ")"}], " ", "x"}]}]], "Output",
 ImageSize->{244, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468824045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201951172],

Cell["Collect with respect to two variables:", "ExampleText",
 CellID->338157101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z", "+", "1"}], ")"}], "^", "4"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7265631],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "4"], "+", 
  SuperscriptBox["y", "4"], "+", 
  RowBox[{"4", " ", "z"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["z", "3"]}], "+", 
  SuperscriptBox["z", "4"], "+", 
  RowBox[{
   SuperscriptBox["y", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"4", " ", "z"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"4", " ", "y"}], "+", 
     RowBox[{"4", " ", "z"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["y", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"6", "+", 
     RowBox[{"12", " ", "z"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
  RowBox[{"y", " ", 
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"12", " ", "z"}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "3"]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"6", "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"12", " ", "z"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"y", " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"12", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["y", "3"]}], "+", 
     RowBox[{"12", " ", "z"}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "3"]}], "+", 
     RowBox[{
      SuperscriptBox["y", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"12", " ", "z"}]}], ")"}]}], "+", 
     RowBox[{"y", " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"24", " ", "z"}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{530, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317366138]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10903133],

Cell["Collect with respect to a pattern:", "ExampleText",
 CellID->740397822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258524822],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], 
    RowBox[{"5", "/", "2"}]]], "-", 
  FractionBox[
   RowBox[{"3", " ", "x", " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"3", " ", "x", " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", "3", ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Output",
 ImageSize->{578, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7364544]
}, Open  ]],

Cell["Collect derivative terms:", "ExampleText",
 CellID->464897206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "_", "]"}], "[", "f", "]"}], "[", "_", "]"}], 
   ",", "Together"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->573366416],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"3", " ", "x", " ", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}]], "]"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"5", "/", "2"}]]]}], "+", 
  FractionBox[
   RowBox[{"3", " ", "x", " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", "3", ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Output",
 ImageSize->{347, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158889381]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16188116],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19507],

Cell["Collect over the integers modulo 2:", "ExampleText",
 CellID->130530381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", "b"}], ")"}], "^", "2"}]}], ",", "x", 
   ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244952119],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["b", "2"], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["a", "2"]}], ")"}], " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{111, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398745991]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9900],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["Collect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Collect"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27222],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y", "+", "1"}], ")"}], "^", "5"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107710256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11536],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "5"], "+", 
  RowBox[{"5", " ", "y"}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["y", "4"]}], "+", 
  SuperscriptBox["y", "5"], "+", 
  RowBox[{
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"5", "+", 
     RowBox[{"5", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"10", "+", 
     RowBox[{"20", " ", "y"}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"10", "+", 
     RowBox[{"30", " ", "y"}], "+", 
     RowBox[{"30", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["y", "3"]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"5", "+", 
     RowBox[{"20", " ", "y"}], "+", 
     RowBox[{"30", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"20", " ", 
      SuperscriptBox["y", "3"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["y", "4"]}]}], ")"}]}]}]], "Output",
 ImageSize->{434, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118386772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", "%", "]"}], "===", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28714],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->179773804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265427849],

Cell["The order of variables matters:", "ExampleText",
 CellID->28877025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", "y", "+", "z"}], ")"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Simplify"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393627994],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"], "+", 
  RowBox[{"2", " ", "y", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "z"}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "z"}], ")"}], "2"], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "y"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "z"}], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->715833734]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", "y", "+", "z"}], ")"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}], ",", "Simplify"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->82340998],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"], "+", 
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "z"}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "z"}], ")"}], "2"], "+", 
  RowBox[{"y", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "z"}], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39939254]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14647],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HornerForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HornerForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Together",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Together"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32457]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31393],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->32267],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "Tutorials",
 CellID->3468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->119342742],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->882486407],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->2128026],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->509154110]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Collect"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Collect - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 58.5875286}", "context" -> "System`", 
    "keywords" -> {
     "collecting terms", "grouping terms", "patterns", 
      "rearranging polynomials", "reordering terms"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Collect[expr, x] collects together terms involving the same powers of \
objects matching x. Collect[expr, {x_1, x_2, ...}] collects together terms \
that involve the same powers of objects matching x_1, x_2, ... . \
Collect[expr, var, h] applies h to the expression that forms the coefficient \
of each term obtained. ", "synonyms" -> {}, "title" -> "Collect", "type" -> 
    "Symbol", "uri" -> "ref/Collect"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11585, 321, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->244796202]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35965, 1272}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2743, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3366, 90, 4191, 83, 70, "ObjectNameGrid"],
Cell[7560, 175, 2073, 68, 70, "Usage",
 CellID->11785]
}, Open  ]],
Cell[CellGroupData[{
Cell[9670, 248, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10148, 265, 522, 20, 70, "Notes",
 CellID->20783],
Cell[10673, 287, 415, 14, 70, "Notes",
 CellID->7238],
Cell[11091, 303, 457, 13, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[11585, 321, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244796202],
Cell[CellGroupData[{
Cell[11970, 335, 148, 5, 70, "ExampleSection",
 CellID->381245174],
Cell[12121, 342, 125, 5, 70, "ExampleText",
 CellID->74400960],
Cell[CellGroupData[{
Cell[12271, 351, 235, 8, 28, "Input",
 CellID->621681711],
Cell[12509, 361, 274, 10, 36, "Output",
 CellID->53877057]
}, Open  ]],
Cell[12798, 374, 125, 3, 70, "ExampleDelimiter",
 CellID->151994285],
Cell[12926, 379, 124, 5, 70, "ExampleText",
 CellID->198131932],
Cell[CellGroupData[{
Cell[13075, 388, 214, 8, 70, "Input",
 CellID->541412242],
Cell[13292, 398, 957, 33, 39, "Output",
 CellID->542074602]
}, Open  ]],
Cell[14264, 434, 65, 1, 70, "ExampleText",
 CellID->58357],
Cell[CellGroupData[{
Cell[14354, 439, 232, 8, 70, "Input",
 CellID->205494822],
Cell[14589, 449, 658, 23, 36, "Output",
 CellID->251492067]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15296, 478, 216, 7, 70, "ExampleSection",
 CellID->29837],
Cell[15515, 487, 56, 1, 70, "ExampleText",
 CellID->121006457],
Cell[CellGroupData[{
Cell[15596, 492, 376, 13, 70, "Input",
 CellID->194985057],
Cell[15975, 507, 468, 17, 39, "Output",
 CellID->481744264]
}, Open  ]],
Cell[16458, 527, 124, 3, 70, "ExampleDelimiter",
 CellID->72292724],
Cell[16585, 532, 64, 1, 70, "ExampleText",
 CellID->120937581],
Cell[CellGroupData[{
Cell[16674, 537, 529, 18, 70, "Input",
 CellID->179157545],
Cell[17206, 557, 506, 19, 38, "Output",
 CellID->468824045]
}, Open  ]],
Cell[17727, 579, 125, 3, 70, "ExampleDelimiter",
 CellID->201951172],
Cell[17855, 584, 81, 1, 70, "ExampleText",
 CellID->338157101],
Cell[CellGroupData[{
Cell[17961, 589, 268, 9, 70, "Input",
 CellID->7265631],
Cell[18232, 600, 2189, 74, 75, "Output",
 CellID->317366138]
}, Open  ]],
Cell[20436, 677, 124, 3, 70, "ExampleDelimiter",
 CellID->10903133],
Cell[20563, 682, 77, 1, 70, "ExampleText",
 CellID->740397822],
Cell[CellGroupData[{
Cell[20665, 687, 284, 10, 70, "Input",
 CellID->258524822],
Cell[20952, 699, 1994, 73, 72, "Output",
 CellID->7364544]
}, Open  ]],
Cell[22961, 775, 68, 1, 70, "ExampleText",
 CellID->464897206],
Cell[CellGroupData[{
Cell[23054, 780, 246, 8, 70, "Input",
 CellID->573366416],
Cell[23303, 790, 1326, 49, 72, "Output",
 CellID->158889381]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24678, 845, 221, 7, 70, "ExampleSection",
 CellID->16188116],
Cell[CellGroupData[{
Cell[24924, 856, 224, 7, 70, "ExampleSubsection",
 CellID->19507],
Cell[25151, 865, 78, 1, 70, "ExampleText",
 CellID->130530381],
Cell[CellGroupData[{
Cell[25254, 870, 384, 14, 70, "Input",
 CellID->244952119],
Cell[25641, 886, 339, 12, 39, "Output",
 CellID->398745991]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26041, 905, 232, 7, 70, "ExampleSection",
 CellID->9900],
Cell[26276, 914, 323, 12, 70, "ExampleText",
 CellID->27222],
Cell[26602, 928, 235, 9, 70, "Input",
 CellID->107710256],
Cell[CellGroupData[{
Cell[26862, 941, 122, 4, 70, "Input",
 CellID->11536],
Cell[26987, 947, 1349, 46, 58, "Output",
 CellID->118386772]
}, Open  ]],
Cell[CellGroupData[{
Cell[28373, 998, 123, 4, 70, "Input",
 CellID->28714],
Cell[28499, 1004, 161, 5, 36, "Output",
 CellID->179773804]
}, Open  ]],
Cell[28675, 1012, 125, 3, 70, "ExampleDelimiter",
 CellID->265427849],
Cell[28803, 1017, 73, 1, 70, "ExampleText",
 CellID->28877025],
Cell[CellGroupData[{
Cell[28901, 1022, 287, 9, 70, "Input",
 CellID->393627994],
Cell[29191, 1033, 593, 21, 36, "Output",
 CellID->715833734]
}, Open  ]],
Cell[CellGroupData[{
Cell[29821, 1059, 286, 9, 70, "Input",
 CellID->82340998],
Cell[30110, 1070, 592, 21, 36, "Output",
 CellID->39939254]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30763, 1098, 311, 9, 70, "SeeAlsoSection",
 CellID->14647],
Cell[31077, 1109, 1194, 44, 70, "SeeAlso",
 CellID->32457]
}, Open  ]],
Cell[CellGroupData[{
Cell[32308, 1158, 314, 9, 70, "TutorialsSection",
 CellID->31393],
Cell[32625, 1169, 190, 4, 70, "Tutorials",
 CellID->32267],
Cell[32818, 1175, 182, 4, 70, "Tutorials",
 CellID->3468]
}, Open  ]],
Cell[CellGroupData[{
Cell[33037, 1184, 319, 9, 70, "MoreAboutSection",
 CellID->119342742],
Cell[33359, 1195, 161, 3, 70, "MoreAbout",
 CellID->882486407],
Cell[33523, 1200, 149, 3, 70, "MoreAbout",
 CellID->2128026],
Cell[33675, 1205, 147, 3, 70, "MoreAbout",
 CellID->509154110]
}, Open  ]],
Cell[CellGroupData[{
Cell[33859, 1213, 305, 8, 70, "RelatedLinksSection"],
Cell[34167, 1223, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[34567, 1239, 50, 0, 70, "History"],
Cell[34620, 1241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

