(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2353952,      42243]
NotebookOptionsPosition[   2326142,      41297]
NotebookOutlinePosition[   2328116,      41344]
CellTagsIndexPosition[   2328027,      41339]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorDataFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorDataFunction"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ColorDataFunction\"\>", 
       2->"\<\"Blend\"\>", 3->"\<\"RGBColor\"\>", 
       4->"\<\"ColorFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Color Schemes" :> 
          Documentation`HelpLookup["paclet:guide/ColorSchemes"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Color Schemes\"\>", 3->"\<\"Graphics Directives\"\>", 
       4->"\<\"Graphics Options & Styling\"\>", 5->"\<\"Plotting Options\"\>",
        6->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ColorData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorData"], "[", "\"\<\!\(\*
StyleBox[\"scheme\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a function that generates colors in the named \
color scheme when applied to parameter values. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"scheme\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the specified property of a color scheme."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorData"], "[", "\"\<\!\(\*
StyleBox[\"collection\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of color schemes in a named collection."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorData"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of named collections of color schemes."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->373365731]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"ColorData", "[", "\"\<\!\(\*
StyleBox[\"scheme\", \"TI\"]\)\>\"", "]"}], "[", 
   StyleBox["par", "TI"], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"scheme\", \"TI\"]\)\>\"", ",", 
    StyleBox["par", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " object corresponding to parameter value ",
 Cell[BoxData[
  StyleBox["par", "TI"]], "InlineFormula"],
 " in the specified scheme."
}], "Notes",
 CellID->118122314],

Cell["Typical collections of schemes include:", "Notes",
 CellID->278950582],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Gradients\>\"", Cell[
    "continuous normalized color gradients", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Indexed\>\"", Cell[
    "colors indexed by successive integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Named\>\"", Cell[
    "collections of named colors", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Physical\>\"", Cell[
    "colors determined by physical parameters", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->15538052],

Cell["\<\
Color gradients have a single parameter that ranges from 0 to 1. \
\>", "Notes",
 CellID->502862273],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " uses the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " indexed color palette."
}], "Notes",
 CellID->6492498],

Cell[TextData[{
 "Possible properties in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"scheme\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->295907378],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorFunction\>\"", Cell[
    "a color function to be applied to parameters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorList\>\"", Cell[
    "list of colors for finite indexed color schemes", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorRules\>\"", Cell[
    "color rules for discrete color schemes", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Image\>\"", Cell[
    "a graphics image showing colors in the scheme", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "English name for the color scheme", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Panel\>\"", Cell[
    "a clickable panel showing colors in the scheme", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ParameterCount\>\"", Cell[
    "the number of parameters used in the scheme", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Range\>\"", Cell[
    "range of possible values for the first parameter", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<Range\>\"", ",", 
      StyleBox["i", "TI"]}], "}"}], Cell[TextData[{
     "range of possible values for the ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["\[Null]", "th"], " "}], TraditionalForm]]],
     "parameter"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->28892429],

Cell["Ranges are specified as they would be for a slider:", "Notes",
 CellID->49544040],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], Cell[TextData[{
     "continuous values from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dx", "TI"]}], "}"}], Cell[TextData[{
     "discrete values in steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[
    "specific discrete values", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->6805852],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"], "[", "\"\<\!\(\*
StyleBox[\"scheme\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->87731275]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84608386],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->122381421],

Cell["Return a function that generates colors:", "ExampleText",
 CellID->147684499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<TemperatureMap\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235817211],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVlXk41ekbxm1xECkpYkjIMBGpyNKdlLJEStnGFJLslGwVKalUZJKlmqiQ
SEmJojJZsjv2cBzHcnC279fWRKl+5/fHc73vP891P8/9Xp/7VfUMPuAtLCAg
IMgvb379/1539Xn4yok6XDLPtLx1rRPVMtvOmQ3xQGXh+nVmPX4MJLT0pndh
tVjWr7hxHvqtqA9ExhpxOjzMUSmnG/4/RC7U8XgYe3K07OxIM7gyngNHi3vw
YdZPRPILD4T4dPMcoxXHCu09cyt7IcumJtgv8rD4akfo62AqaLvNWKz6z/Bh
bBVPFSYgyKScnQlqhyNDO0S3uw8VPfeufZYgICbXnqAb1IHmaPmvJ4f7saxF
SPq3FQQkd2em+AV2wkJONKaMNwCv6hM3PRQI2LsEMRdju6Dc8JO2i0ODnKnF
jl5VAi+HGtyN73XjqfiPx+HDg/jvS28CU5vAquMaPRHlPdhm/f1kfi8dvc8D
WmYNCERzz9uVdvWiLnHBrL9lCOW+giuFzAjQT9LqZqY+o4B5RkTUk4EMtTRX
GUsC5guG0JPqx9SS7yzlQQaiBrUfKNsTyIm9VRaoNQDD9dFths7DcE3/MLHB
mQBFlNxYuJuGc5YLr/Z3DsPEwVHXxIPAyD5bB6nYQVA8ZSMLnUYwUGyyWiOA
wGP5opryGToUwrz+u0qM4Jtb/a66aAJl06JKmwwY0E54GXbi0ijkxQ6d9LlK
YI1TWbcYjwGTDOFZS6UxGJYMZ1EyCJyr9EkezBuGbcHBUI2XYzjsHtTyJI8A
Q1Xe6uXREbhXPiKFrZkIo3z/Zl1KwOJyvdDVNaMIbp0NHGEwcevl5d+51QTy
uJGVf3WN4jzDglsVMY4Xf608fKODgPgBrfDNSWNImbnllyU9Aar4g4u6w3zd
W3nm7aZMBLq4iVDSJyDPUh+6PUNgpktNKojDhHXVuvshKpM4Wp9v/EOYxPFV
Dz5L3BnHek22Yd/jSTx5vCHtmByJfiflnMd7JyCU9KLdXI+F6YTi6ab1JOwy
7wbv+joB+lykf0E5C9uOb95nYESiul/eZDh3EhVuO5bImrMRt7s8/44VCUOl
NNEYRxbSP4plnWlgo0HdVETIjcRTd9mONcJshGm1GY05cLBCpOqIbwCJ5EH7
XvWrbIQ7xwR0VXAgVdCkfzKKxJNF/yjmNzau+asGXlnFhaeB4gebeL6u4hXF
vAAOsmJqAk1DuSir9LPVSCYxaJzz7jidg1cpPkFTTVwstXzb9zOTxLxL1RHN
/Vw05kgE56znwbNN3OdzDokVUTTByX+5GCorCnaO46HM2WXuxXMSOhnzj/IN
eJhr3B+ylMbD0pH8uGtvSewpW2npm8uDOH02pGorAQ//eWnvWhJa2RXsdYIE
hEz371oRS+C2l9zo2xck7ilFprbqEajbqPIu6yGB+G0tu8Q9SEhnbt4efZRA
ohqxRaeOQNiyS3lOMiTi5KYnNG4S2Lf63bO3LAJeTFNK3gcCcylFKe38c7nk
dc29UiQOVsz5zgUROC7tZ3KOJND10zW7W4+ERcrTpp3KBPoS1zN/VyGRMaOl
4OVIwsDnmE5KCw82YqNJXXYk3MbnU6YiSKwzU0oeOsvD+4tZRudjSKj0f5KI
ucv3RbZrSmcDD8lNQUo+V0ksfZuqIZBNwlbC7GlcBBcestsF7FJJLGR67LjA
9/GyYJ5P90cONrlJjW3OIjEepesm8oTEv/PSalrSHAg/on1SLCDR6fL9dEIR
ie9kBP2sCxvd7MJCoVISVdvqb1JKSGyZYGRSc1jI23QmmfWBRJHC7cLE1yRC
6FaH1KcmERltfYraSOLOgkfd0goSBd0lMpEmk7D6qMAnkj9Hn+5wEr9vvFmx
uSlhAms8md6Xe/m6Djwn7XckkhSfazrFj4Ojs1GiuYvEvrScswfKSLBvOx38
6cpE5ULkM5kOEp/63R5E899vj4xAbK7+GG7UfjxwqI3EThXZuoeFJB4l5hfY
UkbxV8rSr5nNJCq9GtmNuSQEljj0zNKHsdH98F16A5+D/Lhls3w//oxdELxb
yoCAVjbUPpF4wTXarHiHROishVu8/BDa51ijPjUk/tCfcrbg+6o9mVrSUUvD
jwCE3ePvHzX3PPqbD4lTEQrdjrR+DJs9pRX/ze8vPZ/WRhBoN1mStL22D7XS
Crtrg0j4hjuU5JwmoCcwbfn7s8/IH7pU1GdNwsNwXWsU/59IqqH9Wp7ei+vF
M3IEn2+3+RmW3UUepq/Ul3+P7UFI3JEYIX5OHHxTvURdggf7fa9CmSe64Xig
eXzVEAGb6FTVhZtcPFuerd3m0AVDtW32f1Tw88zE26x1NZ+7nmuj5cadUJzL
LUM6AZPFLS6P7nPgfyfi3kO1DqQcMuZ5HePnltMVQ4FuNuSOXLjR2N4OSlnr
uiv6BN6X9Mu5S7LxQe1GzExsO2LkvZyf/uRBQFpn7o05C76T6cFrdNvxJerr
DWoTD+a+sR2rIichW/Tw6E4aFf4D16rnMni4WNNefOrZBN6HFjn4JVIxbLp2
Qf44DzUq6snUsXGc2Fq+828jKpzvv9I14/MueiY8UEdxHGr/XfIJa2lD66+9
xzwEeNjTU2+T6MBEZOxdqxqtNkxJmrR6t3NBlc5aPn9pDAuajzcsJLXCh+d2
wDWHi/kthjZBb0YhzdC5mT3fAnrr2R47Pjeq7m3xY9wRqGW8mt3j2YJDxf+4
WlhzYRXv89517QiM9ps4kU3NaEp5Tzf8jYvQwl9fqQeHYUf5+DZtSzN2nhry
3DDFQWZHuv6eywx4Ve1V3p7VhDeOAhNrqzmInz3SE316CJGRbXFMShP0tqr6
y6Vx0GV+08qHNogbeoeZ1082QitEzijdj4N/xEZtyxcHoC94TruqvwGabsVp
Bjs5cKmMDulI7sOs0NgmyR0NULe0+dKmwMGq0BWp3HW9KBWxMTmcWw9V/fGD
AdNsdGoUlIm+7kK4aInFA4l6qCjFlVD4uZ/ebz6w1qoDxhQFW27wJ/wmprQ8
N5uNfOWXP06Xt2FR/LyjYXcd1sy8DjaPZEP1ysiuAnoj3klO/HnBuA7ygw6t
g/Zs3J1efp0uUodYKTvvlqxayNVzN0RrsrHSzbxzxR//wnxZaaD8klr8D6qA
3nM=
      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392109064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->604529165],

Cell["Plot a surface with gradient colors:", "ExampleText",
 CellID->460183624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<TemperatureMap\>\"", "]"}], "[", "#3", 
       "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410677686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137482694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9965630],

Cell["Use an indexed color scheme for plot styles:", "ExampleText",
 CellID->45126038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", "+", 
        RowBox[{"Pi", " ", 
         RowBox[{"n", "/", "4"}]}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"ColorData", "[", 
     RowBox[{"3", ",", "\"\<ColorList\>\""}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217047991],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412312371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->671044231],

Cell["Use an indexed color scheme for contour shading:", "ExampleText",
 CellID->264752834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"Contours", "\[Rule]", "9"}], ",", 
   RowBox[{"ContourShading", "\[Rule]", 
    RowBox[{"ColorData", "[", 
     RowBox[{"35", ",", "\"\<ColorList\>\""}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47890773],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyM3T2MbUm2J/RzT+XHycxzbl618MBg0IAwMDHw8iANDM2HBGVhYYAGiY/H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   "], {{
     {RGBColor[0.803921568627451, 0.30980392156862746`, 0.07058823529411765], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHd8V+W9xw8rTEFmSMCEFSBhhxUgIYQEEgJJCEEIYSQIIlUBW8VbxaLg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd81kW2xgdC6B0ChBYILSR0C0oSQkggMaRCJCGBJBQFYYFVylVsFEXv
KnKXlS4dxUavCooUWRcbIq5yBRH0XpWiWFYWV2W/zz78cT7vb96ZOXPanDZt
R00ePKlyCOHrSiFU4ffG1BD6FISwMyaE3UD1whDeTw9hTmwIs4H9A0OoOiqE
73uFMLNOCCtvC2EV8EujEC6C4IUBIXSrCGFN9xDWAT347g58F+n/moO/Dfh/
qBfCx7VDGD4khJzsEP7E+NO2IewaFsJDfUN4s0MIJ+NC2JIcQiTnfcd506uF
8EoJ56SEkFIrhJ86h1B2ewjlwF3RpiG7CJrzQ3iqNWd1DOER8M0BPmfuL6x5
KSOEvsNDmJQQwmLOnzMohMn9wdkmhLTm8AL9bVnflrOXQW/oF0Id8P0FfAuB
eHjpDMTUCKE9a9ZD+7PAiBbwy3wK5/cF6nB2XeAY9HcY5rW7ob8nvHdGBtVa
hvAi8u2SF0JX4FPOnhERQizzacXg7xTCM8xvLw9hB3BnJ/OcxNnJwCDwfQn9
/ZBNCef15HvRDdCbFMKBoSE8gPw2gC85MYSB6KddsxCmoeMTnL0d/s/Cf1vG
k3OhB/oSwDeqLnwMRp7AEeQxn3EB9GSxpwG6XoqO5oLrMeAS8tyIvu9DH8+g
jz3oYhewBFktQWZR0N4YOACuifB3oRV8ot860NsRea8CXxXovQgv5djUuB4h
jAWmsXY68B3r86H/FWRxHzKsjOxWILOCzBCulobQC/rfhN085nOBhIYhLEC/
H0LrWWjOh/7BQDd4WwxNjaClFzw+w/mvp0ET56+9ERmwNibVsl4O7EeWM3K4
D8hzAfr7b+Tzp1zbzhl43ov9ZLJ+KOdvb2LZlwKbWlgH7cDXhvmV4FoBrEEW
k8rQfdcQWsbY1k5h80NjbXNHkV8V1tSOD6EWEIcs9kFj5E2WUQ3OXsJ/D7fj
XsB/C3htDlyBtn8Ca9m7Gv5agLtVjG2nIzSsirENlSH/ZtCzJMY6TWf+d86f
xvltmM9lroL1n8BLyzq++zfw364Y+4AR0PIkNLyOLfyIvorwBS+wvwrymNQA
fuBtIjC9vnnsk+o9Wvsb8ngS3f2CzL4H/4ecV8D+9exPRpZ3sj8d/ZxnTZXq
tum+I0NozX1uGhXCa9jDJ8j2JLANXrcCK6BvGPo5CO7G8BMNvungy4OeFuCr
gb/6HBlPqmeflQL/cf1t25ncgTPsX4YMHhHv7B/H+TXwN5mcP5Xzi7DH4gp/
647Hc1fK4ecn+ClG51eg5TJ37BT+7H3omYgtNcsK4abGIdyCDFaCewWwFXvc
A01N4O1olm2zC2dGcl4V4Fe+fwNmyn5ZM79qCP3bmLYvCmy7onEl3xuTzGtU
G/vC17GHjTXsE6tx/pUR6AzZj2X92/DbHR10gNfe3Lf54HsKeBp6tkLDPPbn
s+ca8nsI+28P/k6s33DdXuewdnaxcY0DdnFWBHvO9/KZrVjflPWLWbsI2Ia+
RrNmCHPnevruHWe+oI3v4EnsMwV9fcb9KGD9r/imBchjDLQcwEdFMf8m/83m
Owb7P4ytHQTqgq8LPmACvmUu/uB3vqfhX47C33vwG9nVOm6BL2gOHKsJgONH
7tMPAsYrGb+ZaxuU7XUFRyvWXsWHfNkUujlveYp9mHzXbqAx842Ag/jav7H/
Y3z7NPibzP17DB6qwF8E8CLy2wjU4O5dBcf/4PvnAx1TLVPJ8jmgBP5ykN8e
7Ocw/mw24yGMjzLuwBmbZfuMLyLfqfi4WuD7HXwLwPXn1r6rh2Tjsb6zf4T2
9znjDLY4Gh6eR7Yv5PjuykdHcvbP/UzbC9y5JeBOQAa70P9S9H0X8a7qMNve
NM6bhz0vxL7KIq2jfHjPK3Usfxr5XOP8vdyfm+qZhmxw/468MpjLBAYhn2yg
LnunIPM/MDcB+IXY8iLyXNzPMUGxYBPr/5limUlWgfEo9n4LLGP/CtYfwRaq
Fln2c4AkdJ8I1IK+r4iRK+DlVu5rFXQZAWzBHnZCXwL0ZSGPKdB+DxADLZ24
n6nI65YS284GjjyLL9qAPOdG2+edZG0n/Ndk7CkKmS6EvvElpv1l4BD2PRIe
5qKrKHT092THMMWu15FfJLTWy3du8Bb09kj1HdTduwmozN6/gq8avNYA2qY6
Rsg+5KPly2fw35MJ9umzWL8YGh9WbMFeXoTWr9HBcsY/4N/WQt9M8O2HtgPA
GsbJI+0r32D8W4ptSLYTyXkxnBUN/o+wh4gmjgW6w7q7igkPgisix7nDXvYP
RRdFQDT6+AqZfsbaY6n2lTnAGe7u58BLyPoBZJyDPGrmOjbJh+VgX9nAvdhb
DOfdRa7wYZJjZQY+KY+5XKAj9nWFcRTfjYE1yDJdORq5ztPAlW7cR3R+Ad6/
Aa7C+xjsLy3JOpEungJH5yLnJMpFfkD+canOsZRbKeeZwt5T6Lcz+KLB8Qb2
VRcZN453jtQcXlsAS+HnTvx3I74bAxMZD6tv37qNeJTS3j72A2LDC/iDdcg7
G/hfzs+6zbQqRu2F9sbIYyH8tyd/bMddq5Tl3C+WmDKLteOBLGgrAwrgfTDQ
UPEUHjoUOGdTrqYcIomzjhLTrrE2hxiTAv8bwDeN9esYN+X8JsDj8HYKfsaA
q6/8HXNx3JdHBjnHVW6bDowfZB+gux8RZVr2cEdebGqangP3J/D/OPqfyhnH
sY9y7LF1TctsC/xtBZp2dwxsDa1F2Ntp7G0t+M9B/3T++1clx4AGrK0HzIa+
0ejgnWzHAPn+BzjjQdbO5MwCzroZG6kLrvv5rzZFydPgbIP9b0ffX/a0T9/J
dxf++5Hvb/ivgPtTFfl8BO4EfFov+LmCfjdh75fBl83a+9Jsa8OhIU62kOj7
/seujgX7+pADNXdMeALZvQ2/c5FNV2S0lL0noD8JfqdhD5+y/2HozY+2TXXA
F+1iPJvx+urG/XGpfYnOqAF9d2CTDzL+AvvYBr7vwDcCfMvAV4d64yz7/9HM
d0a+qDNwd1fvPwd9u7jTl+F3BT7oGvyvhMYR0PYZd2Aw/NUEXxm8joW/3Vqf
6dz5Ce5v6wLnzMqVFbP7Z9onyhcqhk3Ft/ZkrFLnMv60E7Z7C/LcGOscpguy
6MN4C+OZ4G/F2kcH2ZYYhkvcj9/6uzaQzTVLck6gXOASNCwsd46k3OiqdIQs
CsH311jn2Nu5W/dkuhbRHTsLvjNAc+XLQHyZfZJ8kWSSyP64CtdmymGioLdJ
rnMb3TnVbrHDfNdUwwlXp+HO3YTzXcZvDbZvVg5xDFzZA32XBwGfMx+RaNm1
YL5yov/Tt/YvQh5Ps/5EY/voDlmu+VTrSYed+I4rsi/6HlhIrHg0zb5kAfF3
zADrULpTDTwDXb5a7NxdNc5yfPGyHOfOpxHwZuRXlz3R3X3nFjD+Kd2ylI9U
7XxuhGWlGvrlJOeMyhVfgr7EAutMulJOPwHc43Nce6/G38Zz/jnomQk9efjv
5dC7F3qHQ8tq6O06yjYu284jRsxBH33wqUvh513O3MraRMYXml7/D9pOg28y
+IaTw+1AvruALsh2ADJ7OcM1uGrvXyAqYzT/A0ewh9hb8I+SJ/K9pYd9wgDs
411o6Ew9tIccLAL+ErGfrbGuuTdx3kXOX9jMMWIHZzdnzQ/Y3lfY4FhwvwL9
j0PL8VvtS6KTbJvyKfJ1yvGU28nnnctwzapa9STya8Vcy2znHl8DHUfaR8g3
KAa0QTc9Cp2LKcc+iL3cBz0/t3UM7cX6QxnulWzu4dqu00DLWjXeOtauGeJa
qBU8dcV3VcaH9a7nnGM7+EYohrV1jhWXaB8m3xXf2L77G+7w5Nb24fei2yNJ
rl3VYxjF+njoWw3uj9TfQF9j1c9p4JjTH3mnZjn2yEdvYP5qhn1nE+a3YW8z
+C+nvm0wId0ylmyV8ydn2UfKN6oGVG9oa7J7NeoRtUiyz5avlk7kO5cDE6Pt
Q99AN18McyybD76yge4JqBewBBzvQH8X6F8L/WObOBZVZLjWU0zqCX33M57F
9zzuwzy+E/jv0W6OERvYv3aIZTuE/XlZ9sHyvcuBWcWueVTrqMeiWmdTsnNx
1TzdClwzq1ZWjfQ7tGQhg9IGrsnXg28dMAH5PcR/C/k+P8S5yjj4e5Zx/XLH
vimM3yKebibeTOA+Vo93LO+X5NitmJ6S7Biu2C0fsyjLOIVLPa6+0NcP/xKh
/sQNjnXHkVdOD8e8lzi7NueVcN7dDXwXm4KzV1XfyebI5z3o/zvz56KcC3+R
YVtXTvxqlmUmWT3G+Dy+9UKuY7vu0OVCxwTFAtVEVTmrOlAIvhH89wX8fQmc
wh7vwX5fybQNyvaUM1Yjvu/nv/HwP481z4JvPdACXC2BQ/j3TfjrT/DX6e08
l1TgXqTWKFb1As7XdcwqG2UfLd+sGl24j5Q499UZc4lNfx7s3Fl7lJscKHHt
oRzltTT3hNQLUkw9kW2fIV+hGjCin3s06s2sJidJKHTNolplDTreAf7Ng+1L
VYNUoMu/lTjX/7WKc5PBxa79laNI9uqpqpcqHfRmfe0i167FrL97oHMk5UZ/
gN9p+JeBo6/7xva2nXvxib+0sw2pFsuBxtviXZNNwRcUpjiWq4e2jrO+GeDe
VQU+8jtw7ylx71Q2NAZ/cUeOe32qEWTblwp9tmz8v253T1a9WJ25EtwPlbhW
UM3dEHw9Wb8h1j3MesqvhzpXVQ79K7b3AflQA/Q5qDf+DV42Jzk/0rgBa+sD
4+o7Bz/OedHoKAndjIHf06yNux6/FQPeQVdptzsWaPwE+p5R4tpdeyoxtwoZ
nub8qcrnsN3nCm1b6gGrdlLNpFpJNZRy1xjOuxLlHLZyhWUuWd+NgS3Ndw9R
vUP1NF9jfh9wmvt0M3fufb7fq7DvUs64S7QApR3sk1KLfGd1V1Xj5gx0zqFc
Q3f29nz3JNSL0J2phv03LHCtph5XS9Y+McC1kXzmInS9iD0NYtzTXMh4ZqZ5
bcj4W+7iJSAC+kqhP429HzDu0905bBnji+WeUw6qXsuRXPdG1HN5GFpHY9Mv
YYt53InT+JNPhzgXUc9Svdq9WfYN6tneib00KnetoJgypr9xaK9y1gxi2Yj+
tj31pOakO0dSbiQfPRJfcqrEvR/V7LXKXROoFpAPuwP9FxW5llcP4PwA5yTK
RdSTPIBtHAQuJLiG3MdZOwe7F6CehXKJvRXWlXKKx7kfjwHHItxT2llhnyNf
oxzlJnR9M/D/0e5Bfgg9x8vdS5cM+0LPrBLX3vL5TRmfHOpe00XWXMG2qqKf
J1v7DeI8Z32d516PYvQqZL06170L9Vxq5vvNQm8V6iHtS3MOptxLPWrh+jnF
vlI4F6S5p6Neju6Mcrf/S3eupRxObxXXUlw76c3iWKnv3H/uWoJ7EZX6Ofao
J6HeVGk/+2r1qNSLUw9GvRf15NSr3DfQuYt6lvLNh1Pdq5SP3sl4x3DHar0p
9C50zqRcSTWEcjXFQMU+5WwTc50TKxdWD1i9LPUY/tNbkM9XPpXrXr9qjmrs
zy92bTeLcV6ae5jqXSqmrcx1T0q9KPWEbsXeWha7N647IN/0arlrcfmo1qnu
+avXrzeEK+ivZrFrM71RPQ6u3FL3vtTDWoss/pHotxnd6U+Y63ZdnvJhCcjm
cKF7y+oBK1d5N9GxQTmLcq/Rie6FKAfT29CT6c5V9EYUh2w6Zzl2qidSifkb
oSmtit/AvuXubUl3rqwcd1Kee27qtelNZfZwy0iy2Qg9h1XrZTo3lI2rlh5f
6t6baupr8k0p7t0oZkwfYJ8nX6eabAi4uha4d6mcfAvnj0x3biMfOZVx03T3
UtRzr53vHph6X+pZPpPhnqd6nY/A8/N660j3W4Fq1GrlzumUyylneJn5YenO
VdSjVK67I9Fvgcp516KbdcXXYwH6fI75IemuddUTaY/+O+S61y6f/3aJY7Bi
r95U7i9xjFVs1RvVO+yNLHTuozcj+VL5UPlO+VT1ZtWDU+9NPVrl8ody3YtW
Tl+C/fxc5N6/3hAj4Scn3b0F9bRXpFon0sU81meTq+eU+VtvDNLtxBL3FqVj
vd3ojUhvQ3rD6cl589Pci9Iby2eMV4L/TAP3GN4A9/7hzkXk857PcI9dvXX1
CJMlvzTntqrJ2gzym6zeYuXTlMvHZ7kWU06/kti/Kse9OZ2hXuSuDNeO6kmq
d7Ezw71k9TD+leEaQbWB3nT0FqY3Gr3N6E1MvezdA/02qZ52ZI7fSPU2qjey
E0mO4YrdiukTZEvlthX1sP4N5UNJ5A==
         "],
         VertexColors->None]}]}, 
     {RGBColor[1., 0.7254901960784313, 0.09411764705882353], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd4VsXWxQ8l9N4JgTQIkEAIRYokhJBQ0hOSkEBCqDYUe++KHRX1WsAC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnHd8z1cXx79FbLETIZWBIEGtKs2SYWQnIkISSazqo3vr1onS6m5VUbSK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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9568627450980393, 0.796078431372549, 0.13725490196078433`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd4V8X29b+UUEMnBQgkIQECoRfRkEBCCwmQHpKQRkBUFLsIKoI/9Sqo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnHd8lzXXxm/2HmWUUVaZhbJkiEI3oy0FumlLF0WZIogLVAS3DBVcqLhQ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9529411764705882, 0.9803921568627451, 0.5725490196078431], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnQd0VlXWhj9qCF1AWkjoCQk1JCGUBEKAQIAQCISWhGYDbGBFRx3GXsGC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAmcz1X3x78ou8i+ZF/GjH0tM2M2s8+YYcwwZsyCElFElvYFlWQrldRT
ipDwhChbG5EtlL2eHm2IpLLv//fn/3ler86r3517v/eec+65557tajxoZNYD
JYMg6HZLEPBfcDImCFbmB8G8qkEwt2IQZA4Mgu8Sg6BFjSC4UicIPs4Mgne6
B0FRmSDo2CAI7ksIgqNpQbCibhDcVo2/07clJQjm1PYcRyKD4Md+QbCmRRCs
Bir0DoKKwOl69JcNglDWC+sVBOX59ukKQfBAUhAsjw6Cb0KDILVmEFzrEQTP
pwdBHOPLtaWdGwTx2azbLgjOhQTBw8x1SxbfNQqCgjvpZ62rQBnWfhF8DzJX
D+asxlzDwHcluD4KXLgjCB4B5wTma80c7zUMgsbMt7JnEKwCutLft3MQPFcU
BMfjg+AUa58EVkNfeb7/lrlbgPMPrHUoPAi+6GL6yvWHBxlB0Iy+Ei2DoGlB
EDQCet4WBEmtg2BqXhB8AE7DSwTBNmi8hb6ScUHQjr42wGH4exCoCi8GgO+z
8D8sIggKGZ/TAZ5AezJQhfk3NgmCLPBplcrewO/h4D8aWqsz31T4kQnNp9mf
aeD0Jrj8F55dhdeXgQXs7Rho7j6Y8fB4TeUg2AD/ZsGPmcB/KrE26y/OCYL3
gU7N2G8Be1HE+rtZ+zL8+xpam7OHrcOgoT7fDAqCr1h/O/IxGP69TP8s4Av2
+iw8vRN+dQNuhVeTWO975CM0GR7VQrb42x54sx/6c1k7D1hPuyc4Ft+FDNAu
GQUNrJHe1TI1H3pTobE79LwMveHs1yz2qwvrv8p+fcb3Bxizm754vj8BPxPg
2WOl6e8YBPv4dhj8mQB/dsCfn8DtKLDxVvjRNAh+LQyCBsz3XHXoY751zBcO
vW+xP7ENLNuiQbgLnxz2dwpjZrG3M4Ej0JJC/9nmyCfjE+DdcNZcD//WARsZ
O5dv3oX+K+WD4HPJFusdZK0X4O8nyNZV+HOM/uvs+VHOZpXYIKjXKgjqApnw
YhD4HC0VBJ92CoLanNU6wL3IfyVkZii86wcOe9mb97shA+ztDOjvDH/2IS97
+H4Y/ce1d+DTEtwGg9MK1nubOYroKwZugssf5ThH9K+Bx63bBMFE+new1jag
Lf010BFzkOfF7P8OZHk7sIrxD0Pz78z9Efz9nLn+jTyX4jxHw48Z8H4mMA/+
v6094Nuv0B+vIc+9kclO4FcfnPORx6HQd4C1k5jzW9YeBA5bka0hUZa9tsB6
2muBMuDalPZF1p4OfhPYy/FAY+R3MfLfFNk/Bc59mPt3znsH5msDP/b3hS/A
U+zvXPasBGslw68vkJ/7GfMq+D8Nf6qAe2XgrQHwg/3Yyl5sAbojL5HAdXB/
qjH7x/jp7O9uZKET41/k9zK+30V7B1DM2CLgU/ZqPvRkFgdBe2TgPPplM/x6
ifXrgM8nnL0M9r89uLcFpoDfWuYbxu972P9T/D4J7EMevwPKwa9X0Tm7WSsJ
msvB7/7Sf/DiFubfyfxL23N+wf8o+J8H97PAq5yP6exPHy6FqeibEujGN9AP
y6BlPDwrhJ5xtN+mfRj+jqY/n++P0fcb0GWwz7jO9kTgV+ZrB/9yOG9TOW//
sJ8TOA8tGduWMzyT/ueZb0CVIHic9X5nL6uwRn3o28UefsTYQvbnHPhP4Uw2
hVddGP8j/N0JPxbzfXPG1OPy2s73I+HFBHgyH/p/ZY4Yzs67yFRF8O2ETF9m
/ETwqY38bwefFczdmTGNGd8Z/fQjvArnPnkH/TmNNf+m/Q/wlviHPrvC95P4
/g6+38X3R+BnFn/bCy+/BZbzexmwlfP4LfjsRPf8qTuSvdyKDHWHX3fCr3XQ
vxY4Qnsr7WTWSwKush+Xmb8p+rIp5ycCXBqDf3pr43QU+c9hvgzm6wl8St/n
0NyZubrBk9rw7k3kpQ+yO4P9Kc153Ml8H5bxHTOGs5HAeevJWTsCvYvhXR94
cAr6noK/47lLJkJvFO0kZCSCvYwEyutuA7JZfz76aRJ9y9v6bp7FevHNfUcn
sb/twacmezef87oQ/JbS3sz9UA/8+vH9k6w5B158yPcR4BMgj39ythaCz0r2
4jHm7MpcXeFhPO3e4HeS9kfo+AnQNwCZPgdtZ4GxrHcba0yBXy3Yn2zaE1lv
NvL7DetvYL1m8KsFvGoOnGeuGtIJ6KMRrLeVvboffBpAewf283v2MwZ8SqIb
vmM/n6D/PPNXQz7u6uC7SWdKZ0l31CJ01R7mvwg/HkNnnYi3zSBb4Q9gK/v7
E/ScQRa7sH9FzPcba+TXsE4Zif4ZBbzJ95nw4B2+nQeM57yUAd8MztM30DSv
lu/ADYxdD+xl7CL01T/MN5z9/Z7xq8E/A1x/4M7YzfyLOf/p4LcO/CqCf2vw
W8752YdMfsPaV9E37QZaJ0gXLAHms5cLgCL2sxCIAvdI4N7y1tmyva6y/tkQ
22D3MPcF2n/RHkJ7LLL1A3/bw+/JyFgc8pcKTvcjeyOAcdBSWfYB296S/bqM
vF+Ltaw3BgK+fbvItJcDJoDbdXRiafBdyB3cDVz+lA5q4DtpFLRvQmanwb9P
4Uke3/YFfrudsw3/LyI/3ZizL/z/GR4uhDen+P5Bvj9zm+/aitA0uYnv3D58
u4C//cr3f6FfdoPrVni4gbmzkd9H6d9Hf2faS+Dnw7Qvh/vuPMz3/+3DHtLf
n3YuUF33PfxJgT+/0z8ZeoZwnu7iLD0Dv/OQtfw00/YcOuw8uL7ImqOY+wLr
x/A7Fx3wBr8ngm999u4Y8w/kfP3GHr+APbABef+W87UXaI+8RDG+mLFZ6N/r
zPcWczzJfCVYYwq0j2J/6+tugwfH2Y9jQG/O2g/YsEP5vYz9eIf7qCz78y/m
msYc+6ClAjr0AuenJjTNoH0/52cE9H8MPmXhxxr2qBb9Q6EvHPru4fvNUT7D
OrsvgfMY5r/O/E9z3prQv4H57wGnaHjbUncMuI0DTiFvLcCxCvt9uLd142H2
+wvk6Rns0YGMv9jaZ/0uxtyo6zP/GXtxg/VOstfVGLMCeT/bw7rsJvJeCVl6
HHrCqtmGfZS59sCfv5nrJvbBL4z/CWjJ/rdlv65qfyWPjB+GPJZBFvqyh3uR
p3Os8Sp9F6D/msYCrzHfn8xXnbXqN7NsfUf/obaWsVRoTQa6Qd9X6K81soei
7Ut1AHojy+OgpyNnrSl78hG8WA08CC9GAdXY33V88wvf7+L+LAc9ZfrrMOHP
gN9yaP8szbbjO+B3DX5fGWTfRDZz8wTrROnCEOAGe3Wzn30l7eH73J3vwdP4
kraRfscWeBZ8outZRtqyX61Y/xJ7OYc9KcF+3GQ/w+BfKNAO/H6CB6fgfSby
d3ex72zd1ftYrw641hWAbx3gM3BpAU5vsvY85GcruDaR/YH81UMeNzH/JOa7
h/kuM/85xldFxtaBzyDme1N3dZxlszywA31SDZkbVtY2TX3Wn838Mxk7A3iL
uSqD/wzma8H+LIfWu6G/C/xJQUaHcb4eg54y0JYIPs8mGGfhOonvf2Wtf8Pj
+fB2DHOU5XdXxsey1g3Gt0SffoB8/FXdd/Qc5OUwOmpbGZ/p/tLP8g/A72PO
6FTwewFoy3m4wviK4FYJ2ML+hcHjVsh+U+ZfwF7MB87Q9zPfnwm1DlzHXt/D
nh3n92S+GQJ/ViBv15Hfi/C8SrxlSLLTSD4s+PUCn5e4L97saNtFd57uOtkw
JXvY55OvJxv/AnvxOjx5hv15jP2PY60eQGf434X2YXA/BNwJfV+hfzbx+0tg
OPRFMd945j/AmYQ1QU3uz1aD7bPLV08BBnH/53NGdnE2tqJPitn/J6B3LXtx
mfs7SmPh/30tbTP9Id8YCKlgHf4H43cyR6f69jFaQdu96NukENuA39P/n36W
f/nodZGdqsjME+zvl/Vsm8kHke8hG21Fou9E3YUfAKeR3bbw8E541xUYlGyZ
kCzkIAP9wSUv077wE/DgKfTxV8yXCf5b4McSxo6ItG86iv34k7nzwXE1/F8M
/0PhR2P2ZyH2byL8eJbvJwG5fL+L72uD/xnGV4KfjeFHAH5Tii0r14C+wh+c
JoJLJu0waO3HHbTwdvucO6B3J3AWWsuw5kLWP8WeFrB329iPcObvBiQga7U5
X3/C+wD+DIc/pZHPxxh/if07y5/bMv4+aB0KjCxvn7EBZ60eMp3B2CPQtwT8
Qgba1tUZuMHYa0Ac+zWZ/drMed4KXG/tM10QbZtOttx54Ea8fXT55jf5Jh7a
j9Oe3dE++01obT/Qe7MOnA7Q7jPQtvc+dEZvxp+i/VZHy/jf8P4SPDmO7PyX
M1Y5wWdAsv94OccO5BPIF1AMQXerfBb5Krpj3+c8PIYM1EY/TmePosG3Dj5c
WfidBw8uMXYhNDfl99d8s5m9+arYst8V+ZvIWXqx2HulOysEfXMsz7Et+Zgx
6NbYdPv+Q4G3OGulBto2eJL+2ZyNXsX2BRfB37HwO6/YsYrm4LeI/tHFju2s
Zw/OSjZp/017G/ZEWoJ9FvkqwvFB9NHoFNMiH++Z7qZBuMsnmhlvm1i2cBT8
mM7520m7R0fH7GqCa610xwYvs34+srKL/sSOlrFFcY4ByPdfg8zukK8JRCKP
z0D/YdY+kuLfScjgKMaOAeYx/ifwPxjnO153ezFjBjL/fubPYv626IcE9nMz
7bq0X4a+RQPtA8r3k0wPhn93A0Xwrkl5236ykWUbywY8FOszqLP3o3xEaNkG
jV2R9wW0/wbXLbQ7094Mffewt2t0Zpj/Unnrbp0hnR3p8DLgs1T+Xwf7fI05
e02AToq/0Z/FXFPpH9rBOv1V6HsF+jZB3xnwvz/CPrB83xPI7+Ie9sHle+8E
32fRDc8B4ZzlyrRroxvqAE/Rfp/1YuFlYq5jly2Q9y+gb/EA66bPoacO6zUu
8F2tGOQkxk7OdaxQOv0Y369k/vuZbxrzRWB/jEd/PdvSOlxnXzaNbBnpgDDk
70X6X6d/Nf2xyM/DzJcbYp9lI/xYL3sCfTuT81YfXBoA79EeDj9r8bs28C7t
prS38Xv7AMceqiCPZdDlZTMcW9oO/oeYby/zLWL8cuY7C+3ngIdpL+D7FfS/
T/842s/Tf4O+m8AU2gvpb8R5OxNrXdYQ+V4NPY9DTwA9j/O/h6BnNfTsh55m
jP+F/kfov4YtOIL+WyLsA8r3C9ifM3HWidKFQzgDk6H/Ku3dHR0TWEu7IvOV
Zr6JtCN7OIar2O1XjC+vWBTterQTkO/RUb4jdTdKx5dBdp7XHUH7aeyZWeDy
KO2WtP/h+3B0UQRwM8QxJvkGGayX19I+wnHWj6WdRLsE801DPx5hjhHQmwr+
S+hbBuygvzL0hnM+vi6y7S4fpyn0/sD4Bxifw/hU5OFn9vdgiO/4hfxeBMyi
vZ7xP8OvcYy/AL+YJhjFfXY/MJK/jwq3Lfgz8FAz24Qx0P8S9DytuwQd9DN7
9Uu+Y5lh4PsisjoD2MD5uMie/YVs/t3XsrwE+d8IPhtSrctl48j3exCaP6tq
H3An7TrdHcubTfsS+vGA4sFVHQNU7KJ/kX1DxTCWRjsmr1j8TuA9fn8T7bN2
AJ6s5fcX3E8x3F0HQp2bkM0uW105iqxU2+yy1X+CnlLQl4gOmYGtV5b773n6
0qJti+ez3hr5NsqPlLJNXxbay+Rb1vqEOZbeAvvqwwaOqY8Cn5HANfZiOesd
T/GZ1VltzvyV+LYicANd0o/x3zH2GfZ8AuvVoD2F9dtBczi8msX4FNrTuzvW
ojutLLJQwN8eKWMfQrHJ1/n+hVqOUSp2+Roycb6uY5gdWLt9imVDMbha/J4V
YVv5Zi3HegZyHju2cMynPP3bEx0bvkD/fn7fh35OYnwk+rQVuN8W6Vjrg4zv
Qftx5rgE/wez//s5H7+DYy3WHk3/LH6vSvHdopix9nYX+Het6j0upD+Z/k5l
bTMO5fe9gMhbCg716B/G+JfL2AdZz142Y0++Rj73ssYM6J0DPWngt4d2I/Bp
CGSjm+5h/T78zsq37n6NdlyKdbB07+fwtyd96fm2lRVDeSLGMTTFzl5gfBZj
eyueAP+iGD8p3Xei7kLF3NZwVj4GRtVyTuYWcC0F3FXaMYcofj/a3bGf29i/
MPRRGOelV2vPOQTZCeH8VW5mn6AXst4beJ7+pZyZHMb2BR6nfQ3+n+b7o+ic
PGznJ1ivKfrg0yL7hnNZ7yb8fbfIsZjhtFchH0eTnVv6g+/Px9sHlu/7Ieuf
RTecL7JvdpPxPVgrvsCxn3+xnyMUq8x3bOUX9jgU2sOAN1i7cgnL6svgU7GJ
ZfYl+ed8XxpfpBv68CJ3xSWgPvOloL9ugP/8IsfmNccy9u5Wxrelfwl7tgUd
dIXxTUR/4Fh/BXTCpCaO+Ss2WorxrVo7RvoxsnmpyLGsPRWta8sX27eWzn05
wT6lfMkw+BnB2Mgi55okI2cY/1ehfYXz7GkG8lUCeh4B97Pgl6X4bZFjp4ox
KXe3DXwSmjqHdzraMTjF3i4gfx8hj6vybGv+Sbs94weA8xxwD+rYF1yZ5z75
hIp95RY5tqoYWG/W/nehY33H0U8f8ntloWMhp2mHKr840LFk+dzPQ/8UYDC0
n2TN2ezHTuYYKd/8dsdGfit0Lkwxksvcb58UOjd7lvme5Nu9hfY1p/D9F+zf
l8B45PnLytZ9f6T4t3TgWL4vLHTuQzH8JdDyfp5l6Tfo+Q1ZOQbUb+Uc6N3c
d59yhn/l7EbXd+6rdb51g3JgH3HXD8OfKd8ZOYNFy2Md01IsSzmId2gPoV2y
s33ScsjDe5yZhvgHEdBcJc4xSsUmX0CH7AfXAynmXSfm3xLnHKdym38hz/Np
T6ZdQLvRrbbtXuNvm1vbxqvN3DWBQmT9X5zHSnGOWStWPQp5acN+hiBTq9jL
q+z/vdDXlP6O+Ho7Gjl2Kx9Qvp9iuL+gK5eBczv09+eyd2IdU1MsTTkDxRoq
i/5Ojjm0R790AHbA/4+g4d98+yHQie8byr5i/gMJzu2vq+a7oDDVY3UnPB5r
n1y+uGJ2g2Occ1SuUTmohei2a+A0Bv02Gqga6xiQYj/fwM/rMfb55evLp9+Y
aZ0rXdu1gWNNfZlvfyfHnNbG2CeWL9yf8duwBbdnOLdXWMa5vY3Kr9d3ju9z
aPsCyAP/u5DHxFjHQBX7rAB9k2KcE1AuQDnpAHv8hmJczD2OPa/J2Hv6Ofbz
Y1fkq7d5JN4cob9djHMaymUoZv1ggWsEVBvwNvs7ssA5Y+WK36RdP8U2omzD
UuznB8jq9p7OXW5HZo/z+wQwEP5/Ud2ys0AyV8EyJF4sjLEsiSeHODsdejjX
ORyd3oHzOLuPY7/yqVoy/nv2bzfnKY7xecrH9bavNBb+fIguKcc3tTiPI9Ap
I+HVcea7yHxtuW9S0B93Zzp2pRj/+HTn3JVr71TPvo1saNnO8nG+KnCMV7Hd
a9D7Cvd5KfbjYdYbik56CN6OBf7h+7V8EwL9OxmzAX82tKVtmxbMt6KBbZwT
9O3QeevinMg+dGE+f+sDP7OAacovYU9VZr8TwGdagXNyysWtZ/268KIecKmB
78iH6Huf8R0Z34Hxu8BtB7CrpWNEgXLZtBsif2NpT4X3L3HmvmHt05znvvBm
Bvg8w/zdS9uXPicfsp19asV+P6O/QhfHgDdDy8vYKCn1rTMfSXfNgWoNurD+
T8jDNfg/H/lcWdu1F9eBhxq6BkOxjVcTHYtQjOMgYyvBg/V1bdP8mG8fQr5D
bXTgKXj/GPRdhN+DgWoDLVOSpRnw+Bi4nIPnu6BnRznHQiUjkg3FRPelOkel
3JRyTqK1H/PfXsE0Sze+G2vapSNjmGsl9K9oZ58iarB9ANn+n3HGjuY6BqXY
04EQ28qqkVBthGzmhzJcA6Dc//fge4H2D/DoQ+gbBs+G8v0cZPxSS8fsJtD+
nPX3trJPKV2+Wjq8tHV6t1T7EPIdyoJ/J9YaNNi1DWnI70LmWgRMZ+5a3Bdf
sfZ0+BkgS3Or/S8XB02NQ52Tmw/vFvR0rrw8Zz5csRj6W9M/oLznukg7JNRz
jqB9v+LbzNcEHuRyV/UHZoc6hz8PeyOD/s+b/r+LGTxI3+g82+7x3G/jWGs8
0JRvj7OniejrvvS/RP/j0JiDPFXIty1fCX3Ym/t0XZ5tgXPs50vMPyfPvggq
IsiQLQbsZq5PaC9DFy0HRlXy384y3xrmu1zDOk+5g5l5tm2VQ2jJ3lfn/h3R
2DqkHGPL59sXkU+hu2tfnn0J3WHHOQ8nin02Z9PfirVToXej+MH6z7IfvRg/
jflXwI85yNq+Po7t70Vfvc5acwttC8sGV6zzeeCbMMc8p4Bv73zb1vJ5pvL7
xXzntnpCf2N+N8m3La4alv9wfpezv6GsP0z+JX1xmjPMPsRK8GlDe0zY/3JK
/A4B7gtzzP1JcH8qx7U1+Xy/g/O6M8W/H6T/l3THiBQb+ov5OmBLdgQKWrlG
6Aa21s0i1/L0uNW1X/3AZ3sT14Apd9yG8QNaOYecy97072dboH1Fx4LX0X+8
lWPC3WjPo/11K8t8JvZsfJLXVk5uC31bgTOtnPNVLZlqSlRLopoy1eZNy7Mv
qxq96uiHGgNd+6Lrby66440010KUh8a54PvbIOf+riv+TnsgsIXfzas5dhv0
ci2YYrirOAvv9vRZUcxkcrpr7FRbpxzRMM5buTTXAlaq5thIeoJjiYqR9M/2
Gpp7BzwaDC+WxTh30Bn7IU21HjGuNTnGfF9yf92uegL6n2zu2G4V5ttZyTFe
5dLSlC+p75za4CzbiLIN66HvuvZzTYpqUU4rnprrmjfVusmGbsG3ocC7jD+J
fDXsYR0n3bYJ/tyX6xyucrfJ6KN6UfZh5buq5uBeeDMUWA/9BwPHJifE23ZW
jHLLIOe0lMv6Qzl7+LcYWAR/y7JedehdD32doHcj9EZxtqKLXZsxqKJrAb/P
dO2YagIfh7dPpNl3+5L1K0DrDdmf2C5pfDML3tRKc61QTyCE3+Okc+krzfhe
qofLdG2dYvgfICtL82xr7wGfv5nr7CDX5oinfbAlsntbNpYiX/dGOQep3KNq
PNL4Nj3PtVD3Md8b7NcNeFgBfmWxXy9wNh7IdW3Daf52O/R+DL1b2c+10HuI
uUtnONaXiL1bCXm6yRpvs/bBurZlFyQ4FyCbdmqUbTbZaspZqLbwFeDcHa4x
7Kp6hWjXJl3n+zXsxXBw+KSGa0Jf4/emOMfelLPdUOAcv3L7ygF/X2CfWL6w
crhvwN+5cT4rMaovk+6Ks60gGtPRHWk5jl3rzl2ALHRB3y1tbJ9iCn1/obMP
SzfWtW0/JMu5fNn4qk1SDlO5S9UorWP82hzHdhQD0N18HB27v5bv6GGMTY6z
Ly2drtx8T3h6vJ5z9NOQ1RezLfs3aOfw+9Y+jiVuU46NdodExx7OYI8sznYO
QbkD2dQPofvGAjNqGec98ueSfHe+DvTN9pyaSzpOtahJQO+KrkndBD5Ts722
7txCfhdkOzemHN/r8HcA+G+4zTWCj0HPo1mORepvV8JdU6FaikZcoI/lOEev
3Lwu1P78zs1xbPBb6J/MWbkKj85VsY02A1rbxNsXmMCdc1y2AvwrgJ4fWGMP
81fhjE5v7zu8DLJymfMYFuoYpmKvpfv4blYM9gV4OxVYDG0LgZfom9XHuc/y
0NOetWb28W/FLIr4XdjHvrBwUuxWMQzFLhTDvU/1Dln27fYAb9JXOsK56ObN
HLtKSXGuRzGsDOY60cOxxem3uxYvnvO7ob5r8lSLF0Z7fn3X5Cn3d76HfXvl
ACWLihkpViSZrAY/1qdZFnVnpijWW2DfRXf4q+zVK9mONYtmxSYO9vbZVIzi
GvI9D39vYAvbsBdpX+jl2PLIhq5FU45VuVXVpJ2BthfTbbtnow/+pv98L499
sKFzIzkR1i3Kkah2TTpEukM1bAWsPaC3c+HyeZdy/jL6OjckHyZFtSGx9vVS
qrq28Ml8515VY/g0v1exXkR565xmsc6pK5eumu86/K7d27XoqjEsy+8yvV2r
opq4FX3tQ8l3Uo5EufhSfVzbqZx8XcZWi7WvqxpV1cI9kulcpmriPmLtT6B5
u2pzGL+a9roY+7btkeFOjO/Y17pzJt8PiHVNpWoplbNsSt/r8GdbM8cor8fb
55KvpRrftuxfmxzLpmpGb+X3LTm2lS5Xd63bsFzfXap5ezfeNUqqTVLMT7VK
PyY51q2apY/oGx1vWVOMtjvfR2Y7NqKa2/2cn5fDXTv/YVPXAk0psm5XTdAF
2lUH2hcZR3951dol+Swq5pYs3ma4Fnwz9N1L+/dI117+0NC0lk5xbY1oVq2S
fFb5qqpZOkj/mHT7dk1pH6O9ivO9qJZzZAHrbY63bS4bW7nDnyMdK1EOcQLz
HYlwbVEI8I1qD4C7y/gOPsXerEJmLoXZJg7gR0q2a+0Vw9sKLy/1sux+rBo4
7Ith/RwbU8z/FX6/EWnbcRhjZtN+uZ9tX9U06+zc7OXYg87QLvr2Rzo2q5zY
B7RXRjqXpRzXbtoHI537Ug6tkWJVvWw7KGawVrGHSOfalPOqovPXy7alcqCd
+N0ReOUW2yiK1fwn376kYjanaB9NsW+qNw+q7SkV7Vpv1ficRh5/xN4s09o5
v+WMX9TP3z4ElGVskwK/bViseoBo11irtlo66hq6tW2mc8VtQv3tgn6OFWmO
UHBrGeO3H6qBeIT5N2Q6NqQasjH0j+5lX0cxBdU6d0eeKtZ0zXMb7N3d6Lc5
dVxjV5KxZ8ChRwW/YdjU1zakbEflTJ/Psc0mW00x8vvZzxG51h2vM0dOpn1K
+ZJRigfI/kJefm/gGnrVfg9JdC5FNeB1Wf9kT/vibUNcKxsa59yFambvop0J
Te818puHe2kXoH8bw59utOvC+3pAbeS3qJzXkoxKNrXmeHB9IMa1zKrpGxXj
GmXVJivmUYr5Svazb6mcZVV+397PueOqt7m2STa2bGvVOA3i90ORjl0rR9OA
dmykaw8VkxnX3zWcqt1UDvhEpM+ozqZihvfRVyHKuW29mbioXFKKa1+VgzyD
fXN6kGMrd2Cj/c34EpnOpTdh/yvw+3iUYxOq8X6A7+9KtS+vnKJqs05EufZb
NVolov9XA1jXd5xsw3JJvvtlI4bIP4m27a6ajJaZvnN018imb9nfMSjFnsKA
j1jvdvh/uI59nIvs/bzuji2qhnUiZ+MZ4NAd1tljMxzDUOxCNvRPuY55KNah
nKjeEr3D/je/w2+KZnZ3Dbhqv/UGZTbfrs9ybaNs1PN8ey7XuRHV4F/hdzW+
31DPNbXybb6Gvk017eOo1ulklG1z1TzVYK7qWfY1VcOk2NhLQHZdx8hUy7yU
/XiqtmuaD9O+I8WxyBasP6+n/6bfwllr647S3SQcVFsnG122uWrsekBPg1Tb
iorx1e7uHKtyq4phtqa9J9Vn5wHakXrvw98W32EfJxreH+vuXLR4urT//2Ki
LZ2DzgWX1qmOfavGXrG6tZl+K6GY3Xy+LQt9e5h/9R2OtanmTbVuirkp1rcE
GFXXMT+tPbjYtYbCIb2nfUr5krKRn4j0HaS7ZwvtGj3tg8n3+hSYDm6tolzb
oDdTCxk/Qe/VGroG/Qr4Xc5wbfq6uq5dTY127Y5qWOWL3Yx0rZV8MtVSXenl
t1aqqWqAr1Q/z7UGZZkvnN8PRLsWdzzn4172/zr3aRKyXJE7PRve5KT6t+6o
6DTXXKnWSjXql5Cfy8DuOn5DF0//dfTT5/J36C8R5zdmelumnJjeEn0a7lpg
vSmqSd/kfNeaRbX2W4wOqc4t6U3Gw8xXgfkqMFcEcJq+P1Jda9WopvdmQXe/
xdMe/ZDqnKFyhQdZYwz96Uke25nv85XLynOsSzGzIdDbYaBtFdXY6i1AdoJ9
Zb0JeDXDPq98XcU8nwGXScCq6tahR6Hl/XDXOu6t4dr398JdO60a+LLKZfV2
LF8xXuV2fy50ba9yvPvzXDOkWiHFGHTX6Y7X3a47723auRGOZemNz9ZC57iU
21JM/Sv6Nw9wrE4xmYPclx/T/q2VYzpXY13jrtp25SDfZq52vfx2J4P1MyKc
I1duXG8USxY4Z6lcpWpqNyILy8JdW6E3DF0ivGfaK9XEB3GuwVXtrXKYTXQ3
RvjtV6xyBLQfSfBbRd2ZrZXrLHAthXLGir3LR5JvpBi83pqE0J/W2m9O6vG7
boHvQtW0hPK7ZYFztxpzKtU5Y+WKVcN7AVrPD3BtnnK0ym1JBrT3ynF1Vuwp
zbU3klG9HT2f4Viw3pAqNv+vHPtCitH/Tv+JNJ81xcQVSx+l+H5dx9RvS3fM
QLGCQ8Apzu/J/q4NU83AnemOCSgWoBpxxXav9rctohivahuyOROJtVzjUEHn
M9pv46JDXTv/QYJrN1VDL1tDOk+6TjbHdymOQSr2qJry5pylZvnOPSvG+Geh
c4jKHaqGdEiM32zprZZikkf49ssC1zbPY/63ac+Lc+26dLje0hZ291s8vamN
zfcbBr1dUIzzFfpnp7i2Sm8ol9DXBp3zWiPfCTskS/BrdF3rSP3eG+63Qvpb
YrZjdorV6U3iC9F+w6i3i4pJ6y3ja4k+y3rTmEVf7zzXFirGq7t0VXe/ddWd
mtjfMSfFmvTGSG9jpJOki/RGRm9n1zA+pJrf0DYodsxKsSrVaCsX8HqOfX/l
BFRLOz3KuX7V1I5lL3enmFeqkU+Ub5luXao3bvLlZZPKFv1/n5722Si/hVIM
X7mH79Mdu1YOYiP9z0U5tqOcsnIDf/W3raIcwYR058SUC1PN86PpzvEot6M3
Sp/yeyPwYnXnIMuk+c7SXSWdnJXkGL5i97JJ/+Zs/B7uWts6qgGkfSHWtppq
ePUWbWmUc3d6k1aSdolk54oVY9HbqbQUv+XRG6qIYteMqlZUOZqmqnUY4No6
1cypNl1vzvTWTDXqrQf4Da3eqiom3Z52uwGubVNMu3WyY/oK3+gN4UT65sXa
N9Ub2pmsNSPJtZB6A6tcTWac3xopZ3ML40sNcG2eagD1FmNTuN9+6U2GfKs/
Yuwbyceay1wlIl3LqDdNnyS5BkO1F8phfBzrN5Z6W6mYeCa8PZjgXLVspOJi
x6gUm9KbI71t0htTvS3VG6fIga6ZVa2scpCNkm0D6O6XzR3D3MWxrtVVDVl7
zk67LOd+VNOst9SqUVdt+tRGPlu5ca7d1xmTbbAuw29NZSOoFnZVpN8qqia2
D+Ozslzbojdrm5HtTTmOLasmolSWZUKy8EAj+wp/DrLtLJ+hB/rpUKbfgk9t
5reg0lHSTXoTqtrc9yP9dk81ul+DT69IvzVTTaveFlZOt25MbuTawyPhro1Q
DeIHsX7To7c8qnltw3opmX6bopq9cGQtAogC17nl/DZiV0/HmvVGYkms39Tp
LZ1qXu+Ptk0jW0Y1hHpLHJHgt1l6U/xjsu9A3X2qSXgOeXi3u2MhygGdpX8M
MIS+o8BYdONDBY7dK6c2kN/FBfaVVNOUze8+ysnf4pqm0QXO0Ss3r5pi1e7W
j3Qtjmp4Jya6Zk21arIh9Lb7SpHf9uiN90jVAwx27aJqGPVWSz6bfDW92Zpe
4By0cs+qURyRZh9DvoXeQKv241yycVcNiGodn4xwbatqHvUWbniWY396Exca
7Roh1QYpRqXcck6ia0+UY05m/oqJrjWRDTZBb9vi/PZEb4q+TbQNJNtH/0bD
lgLn6JWbV4397gLHZBSLUQ3VWmTtkwGuNZaNcjjHNQaqLVCN6O3gez7btWyK
ka5h7IFY10rrja9iLYdS/PZNMZdhybYRZRsqxnqC/Tye71pO1eyc4vfJfMuO
anRn8PvLGOc2dAfsz3ZNmWrJlPM/lmyZl6wr5v089P6R7Fyq/g0GvXWr2dO2
ut68SVauZ/ptgWSmb7JrClVLKBs6PdkxC8UqJMOv0X412bXBuvPnJDumpFiS
ah6fQ3/kZjs3pZonvfWRjy/fXm9+0qNd06laTr3ZX5bsmJhiYXqj+VO+c7LK
xeqN/hLFV5Odi9a/oaDazAvJfouoGs317M/OOL91V47iwTTbcLLdZOP8HwX0
HbQ=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4117647058823529, 0.592156862745098, 0.4], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd4VdXSxk8oofceehMIvYUSakIggVADCQESAvaKIPYuKiJgAQQVwV4Q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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3mcz/X2xz+WyDbW7CNrMvY1jGUWs5nBGGPMjNmIaLFWXERpQ5ZEEeKm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         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.30980392156862746`, 0.47058823529411764`, 0.34509803921568627`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd8F1XWxn80KaFK70GItIRQAmkk1BQIEBIghBBCwLK6NuyCKOraRVHR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmwmYz2X3/z92hmHsYx9bhcFYso3ZjPnOxmwMs8+XVr+UqMhS0lPxlGRr
Rw/SoqzRphKVPYkiSZRKSotUWvV/vXv/r2vOdX0/c2/nPufc5z7b3X7shIIb
qgZBEFc9CPgL5pQEwWzgWEQQdGvL/5KCICs9CNo2C4IuXYKgbzkwhP/VC4LS
2CAoS+b/pUFQRPvBukEwcVgQTALeaRgEJ5jj76IgeDYhCH69NAh+Aa7ODIKr
gIU1guDJxkHwGm0dC4JgQUwQ1L0sCCrzgqCCOU+x9ufAIylB8Hx+ELSnfXW3
IKiRGwQb+d/L/J7aJghi6fsd+BaCz39Yfz3tz4Bzd8bGAm8x/wz+d4G+rZj/
oUF8s8aftK1tGgS/FwZBenwQPFglCAr432zwvQe4AVwnAA3YbxTQj70W12IO
1kpj/hPMlw89pkGbFxn/MkTMZs/V01i/MgieahEENzYKgqOp7LMiCMZ0DYL9
UYyn/zehIFjVkT2y/rXs5URZENRm/iGRQVCF9m5jguDpuCB4m/bp4F5tVBAs
6RQEYdYbNDgIlmWBG/MvaxIEw1nvI9ZL7QmNwK9uMbiw51n8rsZ+HwO3N6BR
BfQZBo+Wgsty4Ez3INgDPnGJQfBf1n8Beu6sDR1HBEGIMYugx6H2QfAovA4x
/xM9wCU6CK5k7FW0H6b9Gea4GXxvAnLh9Snm+xLafU7/PPA5x/4fg9e/guNv
8PomxmeNDYIE8ImvFgTr+gTBGua7k/GrGP8H8wX8fhseLeNnA8YPZa0t8L87
/G8A/k/R/2mgRucgGBFh2q/m++fu5kErvmvCo8HQ6lfot2QkeAyHv9C2SUfL
YhTyNiPGMvkPew/gb2fonwvNGoB/FDAf+kax/mBwXw6/tvH7TWC0ZB1YCj+v
hF4/0fdckcdOhkfbWe9NoC+8Gch6jzD/w0A+fd+AxvfD2yvB8UPoN6kXtEAW
44GFyO5bklfo8xjrZTC+yeXwE3pE8j0TNA+xnzT1h3576bsHuMjcfwNjqnoP
M/l9B/L5DLR5jvXeRn62Axf5DtH/Z/jxCxDL/EPAqSqyVQI+SztZxr4eDQ+R
gYoO7OOSIDjN93H6r4N3W/m+nL2fD/nszIAGTyK/Zew//lLL0EHW/pT1DsPv
Juwpibkz4Mfd8OMuoCvjy5OtK0bR50Z4uyIH/sKfU+2gGfiPYM5L+e4K3MV+
S6+AxgM4w4zZEA6CPqx/KefjEqAIeR8NXIWsXw00A9cRtIdpu9g8CHbRthP4
nrYfgDvQTUPzTLuBrTg3yE4IuA/5qYL8Lmf9l1n/JdbezX6ag/8mdEQKtOnY
xG1XZ6ALmrtPI2SnMTAI2neGng/Rf3y6dd84eHIX8yVJR9RBNzHfWGiTjvyt
i7EOeZz2x4B1yMN22h9G3tqzx5PIXz70WUDbfKAa7a+qnfGPAH+29hmdw/md
BX41wO9L9pfHXnOBMn6XAyPBJwTN74dXz9J/Gm3TgaCleVSd8b2zOQus1xGe
Pg3/2kPvev19B7wEf+5h/Q2s/Qj7bQDuTdlvAvuNrc95RH6eBsZyHofCn03s
NYM9pHD+n+G87mf8Bmg2mP3GA+2ZvzX9XwffFOShONM6ULpvOvQvRJbaJPis
9kKm/ma+i8C96NYPoecz8OpWvm8Et3Pw7DXmfxV4NNI6ooy9lRb7bvmZPb2I
LmnIGn/Cr4+Z813wX8b5bMrvcX2D4Bros4w5v2au9uCbjX49iYzk0n8zF2I/
ZKU/cDWy0goeLgT3RUA6+52FPMxFFj5G34XY7xX03wutdwNb0Lf1oNlE1vse
/bMQ/A7H+O56D3wTYnyH3Q9te7PfPHTLS3wf4ndtnVHWvxT+RTE2kznWqz84
DGTufHBuCq6z4OlOztIH8KMB+FeXfuYsXQW8CG9SgNq01QF6xVpHTEK/TASa
0daO/YfhRzL7OQM/xsCPJeCztMyyeE1Nzg/82A28Ci9eAa4B/2G0z6T9DuAb
znZXcLizru/gx0uss6WrjzFfEW2R6JCDnX0HHkB2dyX5rs0HMul/B/JyR0/r
iK+Y+0tgBmepHji/CT+mQN9DPWwzXML3BfDdwnxtoffSEt9hurs+6eK7Y3iZ
cdMd8htn4yzy/TryPp89DqBtRZnPtnRMN3DrV2pd9g17aIDsbIEHC6F3BPS/
wPxHmDOJ9mSgF7SYCD57wKcFPCvnuyP9U2paB+6Dtyeg//PMPYg5rrvCZ1Bn
bwDzhLhPu2ETHGzAWPh1EPlJGsr5R563wfN74f0x9pPD76to34EsfqYzxn4n
w//3oNVryP8m6PscMj4AXZHHHCO4f9ZCw3TwmQx+B8GvE/hdCz5Xg8MbA4Pg
/8DxLtEefJoxfj1rtkY2nmD8AtYbAr3Hs34Fc+5nrmGsnwFt0oEKxs5l/3tY
OxEctjP3O8xxnLlmgF8s+HXjTi+nfZbkE1l7HBk7DP3byF5gv+Og/0zkIa3U
c0knybZ7NMV3lWy8hfBmUZl1ne7MXtA2nv530vcZaDqbszgHiGrjO1S2xJ2s
36ezbYotzLWS8XsZ/z7y8jfrd+Q+exxb5iHWPws/uyXbVswA/02crwPgkMTa
/dGpxZy1AdAkDC3uAf+O8OI99rSbvvuAc8z/RZllMxL4k7vmD2A0+2uGPoig
/8vM1435JiM/42j7PWxbbzHtnZm7U7l1xSFwvgAtc8BnWFfbSN+D3y748Sr8
GMj/HkNXheHfRPi3kfaD7PUQ8BBjY9CJVyKvi1ivLutNYL2mjG8GdKG9AP7+
mOIzrLMrG3Me/I1D5v+k/RVwWAMtq7G/aHRbV+7fqvzeh5xu4ez0Yf8doEeb
cstGGt8v0X8B/Dgq+4fz3h7+lDL/QOYfcKl/d+B/H8X4fyvg/eA82zb5zawL
6o/23qUTvgbXd1mvB/TryZyfQKuPgaug1Uju8G7I/3B0xk74PYj93Iaungns
Qt8t5r54gLnmAUXYJsVAc85XRLFt3+RY0zYA3+yupnEe9tdheLKfud8FRoFv
W/AdjHz/Af/fZ78HgQTk5WVocgR+HpYPwHqt0C+7oU9PePYs8v82+5mLLNwL
rEY2X0TmPqL/WdZvSd/WQC14eXuZfZdjnImd7LWefChw24FMZLL2dniyiLNW
dqnvqluB0dG+s87RtwAeXsL8PcFhDXt5Hvixjve8GFl4FXpEcN4vQI/nkZc1
QGfut31sPYu2bNk37Oc05+Nv1q+UvmDujpyHKuiqDvR/FHtvCvvvCz/6AA04
Oz/QXpW9VAH+hB8XwK8Le38L/RKLflgODQaAy6BS30U/cabGhm0zy1Y+RJ9K
8NuLDHzH3iPg9zhweR8ejYLf69nPWug5Bf08EP08DXpcw920iv3+Du41uJ++
ZL4C+FUJryqAu8vsw8n+lE2yANm/g/4RyFsdoDXn/W1o+rBsb+AmePlnju0D
yWQ0e0tIMi458GcL610E31/Qn/+wXpcS2wSyBcaKf/zeD365DW2D1S+3jSfb
rj88XAj+i4A02mux/3bM3VI8gXbJjH8/3zpJukg6Zl2yZUC8lw8tXOtzvtf0
M86fQOue3HHXMl9trQ+tMqH3CvgbH+u7/74yy5psgOrcJT+CUw9oeZQ1VtO+
Ehqf5XslOHavNI7CbTZzzIKeC5Gvbez3e/jzGXOdBHpwtl6Dv6tYfyQy/Ce6
9/8YMznTPrp880Jk8j7oey/Qrol11DHaboY+l7e0jgyl+87TXdeR8VXgXRrt
tWmvxZg46BMFjUPsLb2Lz8KeUttKOhNVdN+w/knWH45M3YbumJ7nu1k+e3/G
l+Va9+SDcyPoeaTEvvVY+jTid3t4/gC0zmL+XPaWA1SpY5vlIvr+3Xzbojcj
75+D/9pcxzoS2eMftP+P8/E08jKR9ibgV53vC81s885m798P8tnaDQ8flDyW
2beTDS9dMK/Mtpx0Ql3GRwB31bYNdkz3K/JRB/k7JXtM9yE8i2L+M+DfF3mc
zP4vAd/r8I/vo/8w5OFp5OFq6B872jaL6HGBOerC///B00Zx9lFmw797gFPc
FfdFW5foTtddLp3yaoJtHNk2dYCDyNeuTPv2usOqQ/+Paa8F7fKh/4Ps9a1c
+45r2O9m1rsL+TqAfM2qbt+/Rbl1rWIAD0t+E61Ln2X+XPl+SbY1fq1r33E2
9NnYzWd4Gfr4uXjL6jP4wyfQ91vhT0/4Mw97Zz28XwuMgN+x3E+PsteHgca6
a9nzKuZ6EjhQ23f+A7TNC9sXu4h874Keb7HmA/CrHf70X/D3T2AS+N0E3A4v
ZgJp+Ap3MOcM9neFYgzs71mgnL0PTPJdGuL+exZZyEWfvCRdyfcY5v4hbNrM
ZPyLjJ3DfOeQx+qcty/ZzzTdQeC+iP2chTbF9HmCuWdzp92CrE6WP9jaNtxo
+DGN73kxtuEnsF4eczRi7F3gkM7c48BnIvz5CX4fAd9MaPgOtPiOOT+Fl2dG
23ffhj74GlwbMn4Z56+Y9VrD/0nMf4T5r2XNieCyJNW+l+a8XfdFFnddC9+x
k1n/T/TjBWh5Lec9j/nygVcY2x/83qR/VezXi1HG8Tv21xia3cNac4Bq/P6J
8/8O8jyF7zL6RqKTyqFNJTBJdy/r1W1hm7Kc9kz2eF7xLtrfRP6WMn5MS/Pw
etpbMn4CbROBMdD+RJrvmoPAMeTvKHBnHcvwVu73N4Hn0W3PAb3AJw6YxFyr
wecwe1/BHr7tbp15G/JSAg/2woss7oN7aLsbuCLCMn8rtCuk/Tj0+wRITHZM
S7GsQtb8H30X0T4p2jG2L6FHdda7lbWmAbvZbzP28yn7zeKMdhS/GT+Itb7l
fOyR7cSZaSl7hfbbaaukz5Xwcjh9RrOXlSmOJfRlPx8wVwLzb2LuldBom2wB
9rSJ9RtDn9crLNOS5QZ83wDt6hc5trWT7yho1RCoz1mNvMy4fpHo2KpwTuN8
r2e9gTH2GU5W2AaV7dmN8Zvh3Qbovw7az2JPtzO+a4nvzrvl03A++iOfB5CX
eop3wq9xYf/ux/62s9+mzHE62n1SdH8y/gn2Usr4p1JsE8gWGAt9A3DrmW3f
/gv638/veUC3SOsAxZIG0efD2o4pRTBXNHN2jjCNqtB3EWseh3a7meMv+g+G
pytiTP9t0OZX8KlVyzJzgLb35BNUs00oXbQR6N7OOql0iGVGsnI15+Fd5o5m
jc+Y+xD4TWH+s/wvB9oeb23bUDalbEnZiOEh5rF4uwGc34FeA6FXGrRuAI2e
YexL8O8JzldD6JUCP95kP9ltfWd8y1ql+Dcfg9tr0CyT9epIphRrYL2A85IE
v05zniLh1zD401sxlO62qVfT/1ng8Zr2qU4kmiaixRbofTLRa2juibTP5PdV
zP8V8ye3dKy8KfyP6emYuc6+dJx0m3RAruQBfBOh/xXcLycki6x/vrtjtquQ
x2mKtyOPdeW/sr9X4Hki87dif//QP8z+TrK/euD/CmNj2c+HnWzzTmB/rdB3
n3EX3sR3mPt5TKFjPTVZbwd3S2ylbfFPuWNqg3sG+9sAbabGmFbXpdsXFM10
1uaPti+hM6fYzUbuo0tjHMO5Bv6cwV6+hvkXoe+bg0v0KNtKkrFqjA/QmT8z
3xTGnIQ2NRPtC++Afw25yzfA3+PcdV8iU9HIVgH4vAo+W4BZKbZpZcvKp9uD
bBxlzY8Y25n7qwe43T3Uttwf7Pk0tHsQGUlGXk9A/9PQ6jDzF/Z2DPd2dP9t
QH908wAgH/rVRL6PcN4ehP7raLsceX4deZrLHuIZu4v1tnCfvAqU0954sH2H
lRH2DaO5Y4Jo+4h3sPdtSY699Aaf+dgCi6HBX/WtA2Nomw89Irg74hjfucB3
qu5SxVhSFa/N8d7b07/PEOeY/s0txTq29wbQI8Y2/GnO85kS+4qKOW1HHrcB
c5HF+4Glwj/V8z8JjRvTt0mJbcF9rPEStBqX49/KkUxRbBYd3qOdc1iKxbzM
HOd6OSaj3MGLrN8lxjmEo6zVA5kag633FzLbn9+L2d9s9rea9SPBvcYQ+wbK
GfXne/lgx0IVU3if8adzfBdLxzUst40v214xZMnmlALfLZLRWXzfmWNdN4U7
ZhD4PQSPwy3sc9wML39ivx+0tw3zDfP31hlu7TOr2NdnfE9q4xjYVvb6NTSY
3tg5oXWiLe2dWe8S4DnFBpHZ85yVfeik7bRvy3csVDbZf1l/N+unIFtzkcF0
5Z6ADxo6R6S793ixfRfdwUNzfCZ0FtaC09vMvyxk37EZ8ryG7+6sN0b5DdYr
Q56OpTq2Wxt5ej3fMRXFUiQD5+g7k/ujPmfvPHtYzV6qMsfXyPv18LMduEwE
x/vBpwP0aJphn0y+mGSweYFtGNkus2RjgdurmbaV49AX0YrN5Dh2mgQ/hlY6
p6Rc0rIejlUE9P+uuWMWm8GvNfRY1N4ysiHfMVnFYqUzNnB+evO9lfN1Defv
Mb4fAL8XwS+/lWkvm1m2snhwBetdCexF/3zKfTCU/qnARvjxDt9/c37/qnCb
YqDrwa0vNKvZyn2US0oC3m7rnNJXRc7JKRenO28T+P2ATC9Cli+L8d0un0i+
kO7498B1MT7Aia6OUZ+lbX2+ZWNBpGP5fw+37ayYvnS1YgiKHUhnH69wDlO5
y67Qayq8iYHGzyALA+DvRRj9eIJzqcfgWQ3OZh355PCnU4RzV1klzhUph9UC
X7I1PJvaH1zwkfsjG/VKnDvYh046RNsZ5p8KL04h41/D71nIfErLf1VU8D3n
IxaZebqRYza/g3ssYx4C18z6zq0tkT0S5xzbGHhRwPc73EVRHR1LWSZ5i3NM
ZTn8v5rvD2mHRf/6Io8DdePsk4xFFsYA/P17Z0nXtuP8P9XZOrc+6zUIOVZY
r6V9Y/mg8j3lI6fyfRvzfcP8Nfm+jbHJfG/m+xvOXBHy0gia7O5nn7bTWOMs
XPuhH7pDn1bwIMz5eYv1aiTZh5DvoJjRfOZaELZvFOJ7Ofs7ovwy+EUzx9KR
zsEo96IcSV/wvwr8VkO7apynx2k/lOZYZHx7xyYfHWnZUIxyEb93076isWNG
t7H+btYfD3+ekv6HMPciA1f3ckxWvoZsJtlK8jmG8X0s7Nhfa75TOCvfgV8z
9p7DmUlkvhdov0y5P/n/ki3O7En55vB0JLToCg07cT7Clzl2MBP4q6195ljZ
ikCv2saxB787p/juOc96o8DtLPh/SdsR1ria8zWP/93cyzlv2T5zM+2Lywba
zVndCT5D6Dua/ebR/7/K8dJ/Jf3bcF/nZdlX/hwaf6W9sWZBLce0yob5jtXd
epTzu4v2vUBI8S7mGxByzli5YuWEN3J3vpDr2gbN0Uj5T+afU8s2/GDkowcy
MQpZOMwea5fY55CvoTN2J3P/B/gO/jeFHkOTXNOgWobMjo69fgoUxjkGeyLT
PqV8yfZ8n2P/PwF3wc810OC6kHMUyk3IJnqJvtcrfsR991/af0Ye5tJnK2Mv
of1rvv8v5Fi47rD9yMZ7QEyUazBisd2uDdm2Uo3EH6zVLOS1lYMugTenofl5
vn9BJo/RPkH85Kwspz3M/JHI2Gxk6wAykyX/mPPwAOfhfb5PxVunSpfKppet
9BX9369tm+lAonWOdI101nOM/YQ5DoHfL93tW7UMORcsH+tWaP89c2bB2wz2
c0Wxc+zKrd8AP+6kvQ5neJHi8S0c630k7NiFYr6q5YinfWpD13Q8Bi41c+0r
Suan0nca8AX8qlbXufwdyiG3dU5/l+5j5ljA2Gkd7EsPAb+RTexTd4YenUY6
96MYbyxtzzFfO9Yfx/9W8HsVEM33ZU1cixHF98yersmQb7ZtpGsZ5KPtAr8m
ufbtZQMksve69J9O/6mqCaH/TeD0APtZABxn7NiQYyNDVRND34nAJz19xhTr
agK9D/RzzCuZsfOyfNaHA3P4Pg2/FiNfyay3UbhnOfenGoAXwWfyUK81R/ko
5OMW5KEf8vAX6yXIX+Q8FPexTz+Atv7Zrt3YyvpfsZd86F8TZT6+rW2pkcx5
sL1tqgrOx+vI5xLkfSb0yKPt21TXuqyKtu+1ucKxHvlgJXwXj/Ddc4Tv3+hb
NMK/jwInWO+DJJ892WjH+X4/ybUSBcIffKehr34Hl1cVs2Q/Y6HhYnRNj8au
jXoBelzbyjVSsi0mpLu2RzZGImMz2M83nW0D3AJtnmT/m/uaJ1fQPjbPuYgv
aI/mPpxO/4QaPrONwbXRCMdWlTM4L18baFfXMRzpmiJgTZR1jnLxU4EfopyT
ly30Qr5tC9lE0vWdRljWpPP7svZ4xQeb2efIyrHPKl/1BWA75/kN7ueujI0F
WrL2/gTXinwOPwN09Y1jnbt+rZ5jKbtoz2zsmMolGgs8yPoZ3O9pObZBZXsq
xtZuiG0S2SITqjg38HGicz3yLz6Vr037M3195gtpH5lj21I+2lOs1V81BDGO
Aaq2Ixk4E+Uaj0fgV0dk9EHkuwCcdobsU8mXei1wbviJRMcylCNewvfd0KQq
/kcHaLxTvjv92/VyDOPpBOs06TLF3HZqv8BC5DubMziBuQ4wxwB+DwSGKj6l
HFecY1w3gtvEdMuOePYl8nY617Iunl7Oeg2QgZeQpw3sKYaz+Hyuc211sbma
M38X6DG0j3PyOchKd+603zo7ZqLczv9Yb10v53juyHaMQLEB2WDyxaZkOncg
n6wZ67UDx7kxjnEqVt+83La2Yvbd+O6R4Ni7bDTFLj9k/YcudwzzHXDLAoef
O1sHKndZv8C+vHKYynWPy3cuVzlv1bbUSHSuXDUuexm/R/uPsE/cm7P3GOe7
BrTJ4H+7k1yjoNqEEcA+fr+VZN0rH0qxF9UQqXZIMZhM9tcA+Y5s6zn6gcvl
Bc6djgYagE8k8Hsb53i60DaTOeq3tYyGi23DyXZTjGRlvH1Y+a5zoGc45Bi5
YuPvRnlsJeu3a+U5VAs2c5h9e9WEpSNLoTzHIlcqxy1/INm/JTOnoMWbBT5b
O+o4d6OcpnKZyuHMYP4K5mvbynuanG2bVbaqcnTSrRHprkWTjl1A2zfQ74h8
K9YIMf9a/IcH6zmHo1hpdo7PtmKmuqurpzt3ojt7Pvt9hP3NZ3+jqzo23SrB
tTKKUTdh/nUjrWuVc3oOej9M/3m9nFMZwPe9ypn0dQykV6J9YPm+qpHqgy3b
u8i1GrJBLiuwjpBukE4dAH1+KHGufQH4T8fWPJvqWkTVNCj3OgL5XdnAOdhS
2vfEO3ejGsRC1tta7Nor5cx0Fm/gfwcv85msI9sHGtD1X5+1kPFvx9vWE41V
u/UH+mJSnGu4djDX7mLXquXUsS03njmz69umS0izzSlbUzWJ0hXHB/0b5vtX
ZyxMcIxTsc2PseED7qaLnK+14D+YPd1LxzjG38d9FeJ/19K+ONW52HXAUPB7
TTlP8DvbybVJE6FfzqWuUcoY5RyEcg+K0f8K7W4odK5KNTKJtCUAX3VyzPG7
eNtIso1UM1XA2d2b79qYec2s67epJqa9df5J2S7s6cM467CezNVjlGPBkinp
mvuSfBdL55zJcI2OanMkg48Odk5ZueQbuNM+Ye/nmb85e2vW3bFD5YCV+1UM
saty1dCja0/ntLfzexvwfRX/Lz3JOR/lepQDOBJyDYFqB94D3ilwjFOxzd7t
bcsMGu1cl2wa5Tp7MUdGF+c8RRvFNBXLFI2Kxthmlq18lPluZO1XwH9tM9cY
7QH/XcB1zB+Afwb908dYNlTz2Ib5TlQ4Fv8G87Xi+17V/FV1DlqxmbRKxy4U
ozlA+6cV9s3bNXQssleya9sUkzwFr78osuz8hIxNou8y8H2NtbcA+fS/Jmzf
VzUUPUc7JqlYpGpKZDudS3XtsGyoHdC3AHmuBNftPX13DB/s3KXukC/HWIdI
dzzQ27p9F/TMbGsd3zfkmk/Vesrn09l/IN66QjpAtVI/0n5dnGumtoLv9grn
PpSTki92bapr2eSTydaTjy3fWjZfWYZtLtlaiiGoturJSseiVWP1SaJrslSL
pZpA+f5XhZ27UAxAtnR3cIyJs019lLG57DmdtjQgAnrUBu6Hdne1d996zHeh
ucfEjjHNRWvVfA/ie0fIsX/VgE7Osg0p2zHUwrHZVtm2hRSjVSxANUuqVVJM
YCfnuwr6cmoH18zdCK1GpLs2UzJ9HFn6tNxnoR42dI9U55yUa1KNlsbKp5Av
oTny2d/YYvsyioncUmmZlayqxmwuZ/918KnGfI1VX4V8fTvKtfBfyQjmLshN
di5fNTjnw66hVO3keOYogf5vZTt2e5ruadB7aKJzIRsV46L9tQzXpkrHzWD9
24BG3V1zd475bhvl3K1k4Fv2dgaYz1460mcTvzcDp2N957+S75pW1bKqRkux
gvxi18oqZtAGXhVUODYun/R+8G802LF6neFq4DIO/JrXcYxRsamg2LUxilG1
QL5bjnbsQjWr80tdA6XaJ9VMhaBdZLpjL9vlA6ZaB0v3qmZOtQ3TRjrWoxoH
xeIOQL+Mdo7Jtap0TaxqYW/UGYZ3RUXOBaqGaStt11c6t/cSaz4O0TZlOTf3
Efg8z3qtK507XRBlWyKcZ19ANkVdZLM43rkXyeg/zNc007XUymmMRP5eTHVs
9XpoXgNZX81822mbyP3wG7q2aq5zveJBMbiVFLk2TDQ/wn12WDmNKrbpMmnL
KHKtonzYSH7XK3Ltv2rwq7D2FaxxV13HXH9k7REj7EvK5v6WtvFh+36qeZgL
re6nz5W0LYNepdCvBDiFbbCc73qMzYDe81QvG+VapIHZ9hVVk6Raj3V5rjVQ
zce77H+/avCbOgeTqngMa6TE2ceWL9OswLFk+TTroWdFnt+uqGa4jnQn6/0d
5Tu4Prg2CDsWIZ9rVKlxFq56U7Am1za4bG/VYPdAdrsNcW5RNO7FXJcDU8H/
e+b730jncJS7aY6Pfh7Z+36wa4EUQ96t2jngnwjr1GmclU/iXaupGsFBebaB
ZPtsa2tbSjFWxVZlUyk3rhoD1RYoRx6Jr7A52bWCL7K/h1hrQr5r95eA3xfS
D/Dk50bOYS5C/vaO8N2oN0GqTd8fsuyrRl25m6+GOJaoHE7XVOfMlCtTjaxq
yZXDV+5eNeWfVVrGJdt6Y6JYXnGxa/8V05vP/mYk+62AfKo9qr9LcuxxEf8r
H+Ucg3ILqsFRLPzH4a6FUEy8N7Tqk+vagI9UUxvyHaa7SzGnqcmuSVUt6rm6
9o0+oE9yHftIs0Y5J6ZcmGpSl6b6DtXdqTc6xYP9JkZvYZQD+Nf2C/ktj2zA
Z+H30+XORSimuT/PbzD09kI64LfhjmErdr0q0rblm0P8WzbmX9iCy9nz4uaO
0SVm22aRraKa/7g017SqllUxXeVun00375TDPYut+V2OawlkQ5SAexHQJ8o1
K9J9bSqda5UOfGeYfVL5orcgDx1YK5E974r2G5OcNN+JugtVI6+7MQ191LiF
78hixVpVT93CMjNO8STVO3eyjniOtppp1i16U7UfWZid4LdOW5GJJdmuKVEt
iWpEnqZ/tTS/vdKblkn0f4w7qkV327CyLT8LObYrG1O1QOuw8QfEuCZItZHv
Z7gWWzWSS0POWSlXpRzVgET77PLVFTN8NOQ3O3qro5xZIXONz/fblS7A2yHX
IKn2SDGKG2i7Pt+xWdUsXMfvkSnu+2+MKdc1FKqdkM94W67fgOntl96wRapW
o9i1W6rHfZ699la8QfpXPm6ma4JVCywePMn3qkznwqUDBxTYR5VvqhjG67IV
R7nWUzb/Wr31yfRc/9ZEprlGUrWRknHR8vFC146KptItS0pc6y8d8zGye7Tc
tQO6o2V7/53j2gHZ4C/QtrHcuXjdyV8odl3kt3aqQdDbHdV8qtZTb3hWIl8/
ZDqXUdrKsfjbka/8KMfkOxW4Rlm0WKD8pOzfUbaVVIOlWq7pqX6rppouxcJu
HurYj2Ji7cpNU41PjXUtQevRjtWrpiALecqo9N2pGkzFdjqEHctRjEe1L/35
XtPTNTAVQ42zcFVMV7WZNVJdu6sazWqpfnOhtxbyKY9Cu8Mlrl1Uzc/7o2yj
yzZXzDiGuR9K81sg8fgSvjuHHVtSjck45muSZVtLZ7RPgm1q2dKq2T8edoxf
sX3F9FU7NX6obQfVUPVIcw5WuVflyF6HF28U2fdTDUxGgXPyysWvi3GuXG9S
9BZFOXPdjW0KXWurOzKrwDElxZL0ZqWUtrJC146pJkC555fh573RzkFHjPIb
U70t1ZlX7io21W8FlMMSbden+W2DaJxGe0/639fcb7ZWIC+dx/gtwhdN/LZI
PpF8Ib0xUqypKfjcH+OYUy78yAFiavlNy8J855CUO1IN8YY819yo1kY1Pnob
kwJ808lvZG4Hnxlh556Vo5sHbpug35m+rpn+aphr/lTrp5j1HfT9Kc21tsq5
yJZRDlS5T9k09WjPSPXbsxnyNytcI6vaWNkoE5NdE6laSMWE5UuNKHZuSz6V
asc6gP+CKq4h68v4hxNcmyAb4R/G78PGGBrpN0mVrFceduxbbzz2QovLk/z+
o0p32/K35rhWSTZ98zTXBKgWQGdOvsyKkc4Vyqc5A28vFvlt73S+a5U4p6tc
rt5gfhRyDYtqV5QTHaK3VUnO1SpnrdxMtmI47Z2j0Vu//+S5dlhv/m7P85so
vYVSDm81uvm5DNf+F6NDTrD3HQWOfSrHWH+4bRTZJoppqvbylnTH1lWDuYKx
Fwv9FmQVNBsPfm+CX+TlrjmvP8I2omxD5ZAWox+fZ8wTzV2D9Ri0+5k7oKK5
c77yzfeVm3by0ZfSHhVyrks540V8Vw259llJgXXQam2RZbUp99Wnaa5hVO2i
ctDy/ZWTVC5SMYA5tM0O2xb5hT5PVPgNr97u6s2aajPvCbtNNZq38ntK2G87
lDO6EO+aXtXy6o3eBvayPsO+1mTwfTLsN0l6i6QckGT5gTTHGiXT2vuieNv6
osGGXPNAtNcb68/L4GWZ72LVkCuWtybVvoVieqpNrsf35mjXKK/ku03IuaZO
0hf071Do36phXZlhHok3ekOrt5bHBjlWpTeXyoXvLncsRDnxIZxNOYaqbdMZ
VS3IeNXzN3BNiHj1U9i+pngm27241L6AbPgj5X4TqLeAeuOxg7552eaNcrqn
Ml2zoVoN7eHJDOeglXvWm/jBpX4DobcPeqP0E7Q4X+ZaLL2xu6BazArnSpUj
+Vm8CrsWUz7BBH7fEP7/saqezt0MzLMtrhxOwwK/udRbyxnSYanOySsXLx9H
b1tVI6TaIL1xfXCU34ToLYhyknPK7IPJ91LN9T2cpX1FrvWXDlSu43iqc9XK
ecSw1pIM5/KkMxV7bF3st/OKQb6S6Zyrcq3S4d8UWgfo7M/s5Fr1m5Jdy66a
9YjBzoEq96k3S3UyXfOq+kK9cbw9zTWoqj1VzlG1Vx0HOzahGizVJkQNtm+j
GgWd1etDzg3qzG4tcI5QuUHFEBXbVI2SapMU44xEv1dJca5IOnAzvNw0zL7A
G6xfgi6bkWbdu6+D30YsAsY29huJjcNcw6PaHeXc+lTYB5PvpRrKV/L8Jkq+
ej/0y3Lm6hZ2bFNzfA0+pWnOVcvG7aTcXLljE3pToreP72YYF72BlO1+a7J9
C9nwqh15e5hta9WQ3FThmjrV0ikmt5u1MkOuFZBNvSfsN2p6m6YaAt2VdUY4
9qQ7sydn+YtCv1VXDVvUCOdAlPuQDtZbwHODHMvRnaBazZOpzn2rZlNn6+Ns
17rpjOlt4sFc50r0RvFD9nao3LpFb1LrV7qmW7XcFT1c6zm9yG+dVPOpty7/
lDs2rTcvensRn+S3/XqDodxtYqJjQcrh6q5qW25bTfip9q5fvGVPNXjT08xT
8VI5adWalw712qo535PvHIhyH7L5VZv7cp55pxrd/wdUfrOg
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.2980392156862745, 0.28627450980392155`, 0.5490196078431373], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd4VVXWxi9Feugd6S3UJEACBEhCQkLokEBIqCGooBR1BJ2x9y5NQFQc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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAe8j+X7xx8rI46VnX2OFc6xImdxtoPjLGc50yglK6OSESVU9o7SIJWM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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.27058823529411763`, 0.1843137254901961, 0.3764705882352941], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnQd0VsXTxl+q9N5JIEBC7xBKSAhJSEJJIAkQ0iAFxN4VEUQpNpoNbGAB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnHmcz1UXx79E2bPvYxljGVmSLWbfBzNjZsy+mDGUkqSQIvtSlpAlSypC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         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.8784313725490196, 0.10196078431372549`, 0.20784313725490197`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd4UEXa9g9FWkgAKQmdhBpI6CAkpCckAVIgBQiBQFBRwEKxAhaa6+qu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAe8z+UXx79Gyd77cm2XIhUy7h7ucCd3D1yyJasiZGtpSEJFJAoVoqH+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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8, 0.058823529411764705`, 0.07450980392156863], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3l8VdW1xw+DyDxDmIcAYQ6DEEKYgkkIkISEBIIEAUFFEStV8YEWFBQc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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd8l9W9xw8GByMQEAmEBCSMBIQgliEkkAQCmUCSX0ggEBIQRQkXBPXG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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{15060, 15091, 24354, 21432, 21433, 23281, 23280, 16436, 
         23345, 23346, 23342, 23344, 23343, 15381, 24360, 17537, 24359, 17538,
          24361, 17534, 24832, 18045, 24830, 18044, 24831, 18657, 24358, 
         17531, 24357, 17532, 19117, 19116, 22310, 22309, 21442, 17533, 21443,
          18337, 24385, 17557, 22379, 22380, 22381, 18881, 19271, 17927}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15181, 22012, 19440, 21695, 21694, 17251, 21521, 21522, 
         21518, 21520, 21519, 15567, 19862, 19863, 19757, 21465, 21464, 21466,
          15492, 22383, 19760, 19754, 20677, 20676, 18204, 19297, 16025, 
         18460, 19761, 15494, 20813, 15495, 25033, 20812, 19762, 20685, 20684,
          21206, 17643, 25256, 17644, 18967, 18966, 24157, 17259, 21286, 
         17260, 21287, 22891, 22892, 20232, 20233, 20231, 23027, 23026}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15845, 25108, 16950, 16774, 17338, 25242, 17337, 17891, 
         25273, 17892, 16907, 25204, 16906, 15773, 25355, 20044, 25354, 20045,
          19808, 19809, 15542, 20892, 15541, 25039, 20891, 19807, 20764, 
         20763, 16083, 21171, 21172, 21170, 21501, 21500, 24436, 15630, 19934,
          19931, 24121, 24120, 16018, 23979, 23981, 15632, 23980, 23978, 
         24118, 24119, 15162, 19423, 17219, 18786, 18785, 15631, 19935, 19936,
          19368, 21867, 15049, 15085, 23659, 16770, 20886, 16771, 25186, 
         20887, 22575, 22574, 16775, 25185, 23663, 20890, 20212, 16772, 20888,
          18229, 20752, 16644, 19797, 19799, 22434, 15531, 20889, 21082, 
         21000, 21001, 20999, 16889, 18744, 18743, 20031, 20030, 21002, 16890,
          20032, 20033, 15766, 21663, 21305, 20516, 20517, 19623, 19624, 
         19625, 16561, 20651, 16562, 20652, 16418, 20513, 20515, 20514, 15042,
          15080, 18818, 16979}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15849, 22850, 20082, 21068, 21067, 16787, 21713, 18008, 
         21711, 18007, 21712, 19034, 19035, 17778, 25265, 17777, 15321, 17779,
          25266, 17780, 17348, 17349, 24988, 15262, 18788, 15261, 24987, 
         17347, 16435, 19638, 19640, 15380, 20580, 18521, 24355, 24356, 21439,
          21441, 21440, 17357, 21718, 21719, 19509, 22059, 15269, 18691, 
         15268, 19508, 19507, 21311, 21310, 17354, 21437, 21438, 21434, 21436,
          21435, 18880, 24383, 24384, 21456, 21458, 21457, 17358, 21454, 
         21455, 21453, 24382, 24381}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{16448, 18661, 16331, 21125, 17006, 21124, 17005}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{17264, 25235, 17265, 16264, 17267, 25236, 17266, 18970, 
         18971, 17658, 25257, 17657, 21210, 20696, 20697, 19771, 20830, 25035,
          15502, 20831, 15501, 19770, 19769, 20695, 20694, 16035, 20691, 
         20692, 19765, 21639, 22401, 15499, 21640, 15500, 19768, 19766, 24651,
          24650, 24648, 25216, 25217, 23898, 15493, 23896, 23895, 15104, 
         24649, 24652, 24653, 21638, 17857, 18722, 18721, 15859, 20095, 20096,
          19336, 19337, 15006, 18480, 21846, 21845, 23940, 17028, 23941, 
         23939, 19886, 22510, 22509, 17577, 24416, 18341, 19162, 16599, 18726,
          17147, 17877, 25125, 15885, 18973, 17268, 21701, 17966, 19447, 
         22020, 15195, 18643, 18404, 23216, 23217, 20461, 16350, 16453, 25164,
          16452, 18491, 16049, 21404, 17478, 19656, 22264, 15399, 18976, 
         21288, 20386, 20387, 19552, 20554, 25434, 20555, 16454, 23288, 16455,
          20556, 15996, 19379, 19380, 15070, 15015, 18671, 19349, 19348}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{19296, 19150, 15001, 21615, 21616, 21614, 17824, 21620, 
         21621, 21617, 21619, 21618, 15568, 17633, 24452, 17634, 24453, 17630,
          24451, 17632, 24449, 17631, 24450, 15095, 18373, 25452, 18374, 
         19299, 19298, 22630, 22629, 24860, 18064, 25417, 22628, 18372, 24645,
          17853, 22855, 22856, 22857, 19241, 20092, 20091}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{19377, 18199, 18198, 20586, 16487, 19677, 22308}],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1XlM13Ucx/H3T9RKO7B7S2VdE5doa8sSrJRSPDAOrzQQpZFnkHagrjbR
TFfWhseqPzw6xJJKTUHpJjumq3Us/KctrC2gLVMErBSyx2/98eT1+X2/7/vz
/v24vrSisDwREVv8SeRGnLs7Ii0v4uaciEo6+56IPM+zZkSMRiYOZkWMonfi
59KI42jGidER6bMjThYLeG/ET4Vi0mETI27BAH43itktxw20h75KX5RjB32B
1twfke35LnqRvNV4a15ELXajXYzn8yNO003ebUQbvy7+VXINnRqxmpbNifh6
bMS+oohv6Ht01l0RrZPYY+C4iIxpESMwHKcmyFcSsZ3/DjyML8Xoe1/EfOcU
uoBeSMvoBXSmGc3Ap3ruUsM75vEu9qBSvL/V+LZzLT5h8zEuZneZWaRiJZsV
KDG3L+S+XR0j8Zu5taIFqewPedaAOhxEPdr4nxV/m/63YomaFmOVepbSZck+
PP9I7m52J5I59TMAp8Q9jXZcJf4Z+hc60IVOjJLjSfNap771qOBfjqvZjzPL
8Ug8ENELXepvl7ePc2+koNTMc9js8Xwv3jevY2r6gHbQpmw10AafT9J2nEKj
XD1ozHQXk/WHnWz3yb0Xy+R6+kEzHRPxFN1Nl+vpdXd+B//XaK1dqFFnuf6L
7MpOe3PMDIqdm+xVPQ4iPfnertU5P67edQURT9D1NJ1/jjhD6KXubQj/IvmL
kSlHT3JG9Ca5s7w/p658s85DARrZF9JpmIrpclWI9Vxyz+WskmOZXIen2DN8
hcd8fsbzZ7EWZezeSPaPGlR6X8V/kTir6BqsRl+5D5vZYLWkYRBuU9u1dmqR
+V5DFybnL0YTPmM7X4zzvgcL6C/q/xXNGGyex2mHO+tEiziPqL8cFVjK50e9
LXFejD/n2i1cJ84YtQykY2m9Hai0P53s65wPYD+yfe++VU/3eDsxS696bKBr
aa7fjSlY7vMK9JhBq57P0RbaTdfL/X3ye6TOK9znJfRKOn1mxOW0v8+ptB8d
QA/Yo3o91+EH97xGnu/cRW/2b6rz5eRvDn2J7qIrxV9orzbx38x/M91CM9Qz
DLeqbwQK+Odjo/cL2J/RT4PnR+3qIXqEfm5XHjKDV/Q9Uuz+ciTU3o/2dkd9
kEAKeqHBXNLMZ7K4kzAR68T/3T20oYRvNd85dB7mYri732zGGfRDe57vntPZ
DkU+315qK6ApdL/em5Jz5deNSZ536Pe83CH3v3QC/4RzDq0W96hZHcGj+vvD
b0Kz/IP18o9Yg+hZuo1ux1ZsSPbGPiX3//8n/wEdSEqU
         "]],
        "3.96`"],
       Annotation[#, 3.96, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{14999, 21821, 17904, 24699, 17000, 18831, 22324, 22323, 
         17543, 24367, 22149, 22148, 23201, 23200, 24151, 18957, 15656, 22627,
          22626, 17628, 24448, 17130, 21204, 20669, 20670, 19745, 19746, 
         15489, 21069, 15488, 25334, 25335, 25333, 19744, 20189, 22992, 20188,
          19401, 23442, 23443, 22384, 22385, 22386, 17852, 24644, 17003, 
         23897, 17004, 23899, 16034, 21132, 17018, 19767, 17017, 21131, 17574,
          21474, 21476, 21475, 16595, 20681, 16594, 20693, 15105, 18723, 
         16597, 19158, 16598, 18724, 19967, 23861, 23862, 22858, 15860, 16956,
          15991, 18443, 18813, 18812, 15669, 21528, 21529, 21527, 17645, 
         21530, 17642, 21755, 18067, 24861, 18066, 25419, 25420, 25418, 21754,
          20682, 16589, 20680, 16590, 20683, 22487, 20679, 16588, 20678, 
         16587, 18459, 16024, 20674, 16585, 19755, 21070, 21071, 16953, 19759,
          19758, 19756, 16586, 20675, 17132, 17629, 25057, 15657, 18958, 
         17252, 25233, 17253, 16696, 16932, 25100, 15828}],
        "2.9699999999999998`"],
       Annotation[#, 2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nlwVtUZx/FjkKXQFms7tp0pixKCgNpFAggJkgUStMgegpCVEEhGRaoT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         "]],
        "2.9699999999999998`"],
       Annotation[#, 2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15829, 22822, 20078, 16933, 21053, 16697, 21280, 17255, 
         21278, 17254, 21279, 18960, 18961, 17636, 21523, 17635, 24454, 18458,
          20931, 16807, 20608, 16808, 20932, 16332, 20435, 23203, 25430, 
         23202, 23204, 20436, 16333, 20610, 16501, 20609, 16500, 23351, 15333,
          18324, 17469, 19655, 22248, 22249, 18959, 19274, 17958}],
        "2.9699999999999998`"],
       Annotation[#, 2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{19739, 19740, 19048, 19743, 19742, 19741, 17558, 18456, 
         18455, 20589, 16488, 20587, 16489, 20590, 16308, 20414, 23188, 23187,
          23189, 20415, 16309, 20592, 16491, 20588, 16490, 20591, 15326, 
         21445, 17535, 21444, 17536, 19047, 19046, 24216, 17362, 21314, 17363,
          21315, 16437, 21313, 17361, 21312, 24215, 24214}],
        "2.9699999999999998`"],
       Annotation[#, 2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{24210, 24211, 24209, 24213, 24212, 16796, 17360, 25246, 
         17359, 19045, 15809, 25097, 17797, 18314, 17796, 25096, 15808, 19043,
          17355, 25245, 17356, 16795, 17848, 25110, 15853, 19044, 15854, 
         25111, 17849, 19639, 20544, 20545, 20055, 20054, 15787, 19212, 15788,
          20057, 20056, 21584, 21583, 18370, 21585, 21586, 20061, 22787, 
         15789, 19214, 20060, 20059, 20058, 18100, 21766, 16305, 18653, 17774,
          21579, 17775, 21580, 17773, 21582, 17776, 21581, 24577, 24576, 
         15633, 18810, 18811, 18369, 18368, 16961, 16786, 25118, 15050, 25117,
          25116, 25119, 15870, 22870, 23866, 23865, 19937, 18751, 16662, 
         19211, 16661, 18750, 15163, 18787, 16784, 19213, 16785, 23674, 23675,
          23673, 16788, 19933, 19932, 19930, 16783, 20902, 18197, 23984, 
         17082, 23982, 17081, 23983, 17611, 22594, 22593, 22592, 23672, 23671,
          20903, 19426, 20216, 25444, 20215, 21178, 21508, 15559, 25337, 
         21507, 19843, 19845, 19844, 19847, 19846, 24596, 17795, 22807, 22808,
          15807, 19041, 24208, 23680, 23681, 22604, 22605, 24595, 17794, 
         22805, 22806, 19219, 17793, 24886, 18112, 24883, 24885, 24884}],
        "2.9699999999999998`"],
       Annotation[#, 2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1HlM13Ucx/F3x9RKUJNMjta4+sOGVmpN8gANK1MUxiXgRcuWBzkBa2si
JbaVtuVcs0wEp1tQTc2tWdmxlZWZ/VcrDoVS7PjDTC2dYuvB+uPJ6/e53p/X
+/3+8E2vebq49rqIaPTnlsKIo/kRTbMiVj0Y8f0jET8gd3bEoaURU+gHdPyc
iHFTI66VRfw1P6J/RsQ5epp2FkTcVRMxYnrEmoURMx+PSDV3aEnEloqIV1A2
LeLNRyPK6dkFEX/iQFXEfvyWF9FXHJHIQy9NoGecHyfmnWLeMTPiWb/TaDuP
r9pfaryVfiXeZvu3LotYa20973V0fGXEBOTgCR7X0WdQhwbU4+zDPLt/JBJx
K0Zhuf33WL8P96JZvLfE3US3uWe7+27j65S6reLjF/qitdN0tXE/beDrH3vz
5DHB/rTFYtIr8jvH93n5X8QFbLA3R20a6Rdq9Tm6qiN+F6eTHjFusnZJvD/M
JTtf+1hECh3g6+Z56q43B/VoaXnEEizG83qXJO5obOHvNefbeNgjv9VzIyrc
vRBVqMQYse7X6308T6b7aYZ70pGrr1Mw0fwkFPG1AKv5Kaa19Lkivnl9ider
vHT6/RN+RDsvOeqdxUcdP9l0E92IZlRihRhXnFtJq4xHOfeR3HYs8nbQof+t
6tfGTwGvX+pBgTeYIZ9M+aTJ4aR+parL197pUcy2nmU9wXwmzdefWZiJvcYv
mF8gz15vtdt9PRjg4RqKzR+wr4iuVN92cSuMO2grGryVXXQd/TA34lfUyfOq
+tTTNjFaMdXZbvck2dtFR9Mn1WI56p1tMa7Wr0VYYe9EuT5Fh8h9KG5w5kZc
j0tqfFy9v8MBXt/DQeTzOMIby9LfRJpNm9VoI46XRnyLY8g0n2A9gyY9FLFb
PqPpYf0YTtuME+hY67vlkSaPT5z7FJ+hUbwNuN36MHHG0CNqd7f75/NfiHmD
ucirGmP1ZZIeBO+TaarvzTDfhxR6E13mrcyRbw19XR7b0an/h+VXoj6luKBP
h52/SD+mlWqz0/towWX3rvGu96n9eb7eofV81mEt1nsjx8T7BuXOJdv/rhxT
6Bm96cdmd748+G6xU77p4oWzqfxecj6FXqZpdJc31YJTvLzPy7/e4gD+tp5s
fR99gI8uPe3xHrvpCTrX/04fPWF8kvbQjsHvjrpnyyOBvl2ih7TJ/R1+/2xf
r329tI+WefvT/Q+U0Gm0lI5UwxnufEP8HdirrkPM7aFDaam65tmXP/hdNTe8
8P9v/n/Z6Cu2
         "]],
        "2.9699999999999998`"],
       Annotation[#, 2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{25115, 25113, 25114, 25431, 15007, 25432, 25115}],
        "2.9699999999999998`"],
       Annotation[#, 2.9699999999999998`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{15059, 15090, 21903, 21904, 21902, 25424, 25423, 25425, 
         17925, 25426, 17924, 24724, 24725, 21675, 17926, 21791, 18125, 20089,
          20090, 19042, 17353, 21630, 17847, 21629, 24643, 24642}],
        "1.98`"],
       Annotation[#, 1.98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15180, 22011, 19439, 17957, 21693, 17250, 18956, 22625, 
         19956, 18063, 21753, 19861, 19860, 24858, 24857, 24854, 24855, 25416,
          15000, 24856, 24859}],
        "1.98`"],
       Annotation[#, 1.98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV13ucz1Uex/GjeuxG2+OxytjYchlkd0MPTArDMC5tJsLIddyFjExlRkW5
JjPDDIMhZuSWxiXGJl12CbVtUWaYaBOJcR26SLn2aO3z+8fr8f6d8/2cz3mf
z+d8f7+ZusPSeo6rFEK4dHMIEzuH8FOvECbRi/SFjiFs6BJCvT4hxGKicd3B
Iax4OISqQ0K4A3f2C6EaPmhjnBTCdjqmWwipqJISQmXssnZ61xBShoXQuH0I
LXqEMNl4CnbLeZO93ukZwk5x79Kp5t+n7+HLtiGsFL8KB8yPM5fQN4Q/2CfN
59vpf80fxOtiViPPmuV0BcrMtxJfRVxL+iBa4yGUias03OFxg7eSVrz4fAtu
xm3WpPOfgcQOIRxxvm9wFEMeka91CPMfC2EB8jApIYSFdKR6PIHOA0PohP6P
htAXEz2f53lV9f0WRxJDGK+eO9XgWbqDVrZnC95upQ/QODxj/2x1a8pTF+Mk
nHKuxeY2OONmfkrUu9iepfRrex1CYnwIn/1dft7nDNIHmkNL5X5KzV/rFMJY
uoz20+cdnqcaLzUeQ5fQhno8yucnMBIx1o6mT2KjfTehGGfF1nvcmZxrJg9T
eKmrvo09i6U19erPqIGqzt0pWX3QEV/bdw1f43hIQ6FcW/WjgH6lxoPbhdDN
eAjdrIZ5/dUd9/YOoQEKxIzns5D+xbghsuyfiYb2ftyz3kjGfjl70Zvsu1Dt
8lGilqUIznbd/K9Yy+d6FPNaRDfTdZF3d3+wfkxR+1r6UBt18Kjn9Wgs6mK0
mFGIE9+b9kE18zG4ri9p0Xsk31dqdQgf8foh5vD7Ik8vYRtPO7AT292NX/i6
jEtYb7+VarsKq9FZn/MwH3er0xv6/w9xb2G0tdXtd4t996jNbkxQ7ww8h3Ss
1IO96pKkf5/rbZdIjR/WjxjvZTXciRh5qiGbz7f5HkDfov3pFvq0ujSwd33E
ooF+NVGDe/XmfjrW8/edZ6yzP4Uk53jP+F28gyc9n+jsh8zvkm+EvDvocDrQ
/d/p851qeAeuOc9v7sU88RfN7xbzE/2UrpH7DbyO5d7BTfK1tH6SetyjHhPp
S3gRjXjs7r28j/agW/E28tXyjDt9GqfQRo2uOPswd+gyHUo7qFUiHrbvLfa4
PfreEpflfq6Tb7xapyMDz+BZLHXPsj3PVPcszMJsZON3ciQMDaEdWrsP8Tgh
vp4en6Rtjdugld60xDI1reDlHM6ryXf4Hl317YTn3fWxnPagJ+lV9Z1mn808
TqXFtJvYC9b8iB+Q4lzn5XtF7sZ8FFt71nwFziGZl2NydYu+x+hj9Dgtcu/6
6Mf67iE0o0P1YR2vw+gYtf9Ajdqq1WG5j6BUrn3IdK7OPHzmWSX1uwlNxTbD
N+KO4oC4g/gy6rvYL6Lvb+xHkf0P69XXOOs9u+iMZ+g5VKCmPrTVzxo0gcbJ
3xyj3Z/GkW/nbUTX0nW+19diuztzQC8W00K6iBbQrQPUyTkXeRcWo1COw/ZY
Fn3X8vk59qAEe5Eg5xr+PlaP16PvRh6r8XHVnT3OZyNnbMpLM9SS/37jJmiM
62KuYYI+FKhpIW54pzqJvSDfcHv24mEYTaY9kcbfOIywxza+tqNAjQoxUp2T
nGMUvUf+u3FW/jPob4/58i/Ar9Fvhz06oAlP142v4SrmOnuemET51zhLlvNt
4SWbZqKGOtZEddyFP+FV/t5Ti/n2XoA85Mu7kG51N9rIs8CdWmK/pRhhn1Xu
3XC6mpb67vjK3TiEl/mcgb7i77Jfbc/roBYK1Dc1iuXnhtgTfB7nt5yW05M0
233Mde5p0d8Z+ML7v8V9aszHIs/ykcFzOsrs053HHphqfhqmYyjvraPvdP1r
RfvSeNpIjtv4yOKjMs2kVehgXhdatwDzUW6+j/kL4mPsM8s57jFfC7WRys85
8yniKuhAej6qp30LvbMHvbMF9AAdI3ayNS/hxWituDHI5/1VNV+CdL3PiP7u
0fca4jd6vglvYjOK8U9nSJNvvtqNoxt9P8WLP2uc4ztrDuYiF5s8O6T/sd7p
v9nzPjytpj3FTlXnV9T5rN5V4Irv2qU8XKUF9JozLPddugIrMUTvb9Wz1T6v
Qk05f1CXS3L+SAu8r4XoZc9kzLLvUuN+4pbQy2pbncbgDfFl1hXRcn6y3IGr
PM11/zK9G1nINtfC2ql8TNTXaTTXPdhoTT7NNV5Ac6L7Sd/kO9HvUnu0w1Hn
q6e2f+S5Pr1s3W883EBw3tOef+/8Ve3RLvLPT3v6pPEanva4by3U4UF05KcT
OqNYXzrQRFyQZ7KeV3JHcuzfTGwcmuMBLNeDFbjAw0PGuWLmRe8mciMPajRW
XVPREqf5OcHXKXqSnqff4RxOGXd2rk7ogA2+O9bjjGf7nOk0z6cwVy26uSfz
1HJ2VEesFVeEuurwGl2OmeZfwazoOV/PqfELmKyeE+gU+jxdoybZcmYYDzdO
p8PoTP1Jt3Y8MqO/V9TgZXPNedvHUykOWjfHuSvknx2dHzkY494O8F6k4Ia7
FNQoWY3Oq8G3PB6P7pE+lNNjOKhOic6f5I60p7HRb4icRcaH6a168ntss399
/fgXXRv9XmCS+DbOm4C2uNe7kud3owE9xvMh6/8t/0+8NPf5CC/fIFu+ZsY/
m3+AXqRx9BM+e3veB/Xl6G6+n/PM46Uvbcf3ZWe6ghLeP5Z7L/0PLaVHrftQ
7+P5+sV7kq++e9y9RfQzWkcty8XUkme6NV3F9DXuh0/tfcl4N20R/Z1p7wfp
HF5n45iYb/GR/B35+cT65eJnmJtmrrW5cvv8zz353p35AV3kOsFXEv3C8wMo
w3Exx7Cfp5XWZOnleL1/RJ5n6QB9TMFB/f8SY+XoYb9UWseetXHD/2l11LqH
ta2s6U5bR7/R+pCPi+o3wdoMPIdJ0bvv/M9H95a+QOPcpzJ3aT9quRs76S78
1XwXv4fjxMwQm+TzdNrAfD38jItoaI+B7ssgDNafRDkecdZ9xjP47aWGg8wn
04G0sjqeUa/TuGLuFN2rBp9jsTqURP+74XD0/xvq2jPHmlh6UuwJXLbuEvLs
1ST6+0yPmvLZDDnqMVINpqvFqEj1IN5d+T8oiU7s
         "]],
        "1.98`"],
       Annotation[#, 1.98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{20485, 16370, 20483, 16369, 20484, 16941, 18701, 16518, 
         17290, 25238, 17289, 18995, 15712, 17279, 24975, 15210, 23084, 16225,
          23083, 16226, 16275, 25151, 16274, 23143, 15949, 22943, 15950, 
         22944, 15603, 19137, 15604, 25047, 17589, 18365, 15602, 17713, 25262,
          17714, 17101, 17102, 15076, 15027, 17716, 25263, 17717, 17715, 
         17719, 17718, 15235, 17988, 17302, 19292, 18047, 18048, 19121, 19120,
          18889, 18890, 17830, 25105, 15840, 19230, 15839, 25104, 17829, 
         16539, 23403, 23405, 23404, 15732, 19301, 15731, 25077, 18083, 15132,
          24964, 16056, 15741, 19007, 17989, 25278, 17990, 16872, 18800, 
         22037, 22036, 16287, 23167, 16288, 20394, 21742, 25024, 15417, 21743,
          15416, 24929, 24930, 24928, 18156, 24931, 18155, 19101, 19100, 
         18926, 15362, 19618, 19617, 25137, 15955, 22947, 20179, 25143, 25144,
          25142, 16004, 16470, 15315, 24996, 16281, 17301, 23858, 16944, 
         22834, 22835, 22836, 16945, 22833, 22832, 22831, 16943, 23857, 18169,
          16002, 25141, 16001, 16978, 15890, 25127, 16977, 18265, 16467, 
         25022, 15411, 16526, 15410, 25021, 16466, 19352, 20143, 15948, 25136,
          19557, 21722, 25315, 15314, 21723, 15313, 18309, 18153, 19097, 
         19096, 15408, 19095, 15409, 22272, 20485}],
        "1.98`"],
       Annotation[#, 1.98, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV2Hmcz9Uex/FjbTW2LFFXtm52lcKUpTKrm2UQZsZelptdyL6UuN2SSCFp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         "]],
        "0.99`"],
       Annotation[#, 0.99, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV12d4VkUaxvEBcSUQFBAVkaiAflhhQYokUlUIoCKEngSB0FxZUYpl6aiX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         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV13d8V9UZx/ETAval7KkCUoYt0yaAIMuCgOwwQghDCAiU1bL3tJYlK4Fq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         "]],
        RowBox[{"-", "0.99`"}]],
       Annotation[#, -0.99, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nuUz3Uex/G30TGDccqOMnRyos1t2K2Ns6eMy2xmRKi5US4VikaWIgxr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         "]],
        RowBox[{"-", "1.98`"}]],
       Annotation[#, -1.98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15825, 19228, 15826, 20596, 20597, 20593, 20595, 20594, 
         14994, 23192, 16313, 20417, 16314, 16442, 25161, 16441, 18320, 18319,
          18021, 25014, 15389, 19289, 15388, 24303, 24304, 24301, 17454, 
         24302, 18901, 18902, 17389, 21329, 24239, 24238, 18388, 20416, 15279,
          19518, 19516, 16201, 20324, 15985, 20177, 18440, 16694, 20797, 
         16695, 20798, 22877, 22878, 18760, 18761, 17869, 21652, 24656, 24655,
          19248, 19249, 21806, 21805, 17868, 19848, 19850, 19851, 17870, 
         21654, 21653, 19854, 16689, 21905, 24955, 21906, 24016, 24015, 21750,
          24850, 24851, 19943, 19944, 15640, 19148, 15641, 22611, 19945, 
         21515, 21514, 18318, 21391, 17453, 19647, 19648, 19649, 19079, 19646,
          19645}],
        RowBox[{"-", "1.98`"}]],
       Annotation[#, -1.98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{17923, 19270, 18879, 22378, 22377, 19737, 17556, 21452, 
         18311, 21592, 21593, 20064, 20065, 15796, 19217, 15795, 22793, 20063,
          21591, 21590, 21589, 21253, 21255, 24968, 21254, 16682, 19825, 
         19830, 19831, 17606, 21504, 17604, 19828, 17605, 21868, 21869, 15056,
          24848, 24849, 21749, 18061, 18754, 18753, 22598, 22597, 20780, 
         16676, 20779, 16675, 21251, 21252, 24125, 24124, 17220, 24122, 24123,
          24586, 24585, 22791, 22792, 19037, 19038, 17351, 19503, 19504, 
         19505, 18654, 15263, 20527, 25429, 20528, 20526, 16430, 16483, 25167,
          16482, 23340, 16085, 23017, 23019, 23018, 15428, 19113, 15429, 
         25028, 17528, 18312, 18313, 16579, 25179, 16580, 16019, 19386, 20581,
          25382, 20582, 25383, 16484, 25384, 21896, 20583, 20584, 20529, 
         20531, 20530, 15431, 19040, 19287}],
        RowBox[{"-", "1.98`"}]],
       Annotation[#, -1.98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1XtM12UUx/GT/YGNLW26NdZC0QRaq9Xqj8QLqOAFTdSmgBCgDbsouKW0
mhZdt2q2ENTc2pLMQExbooIaomlNS7csm5fplrMtK5jaWgtEoNdv/fH28zvP
ec7lOc/zxbSlKxdU3xYRdf5ZNT+idErEC7SEtpVGnKX1RRENOO/3tSV8kyIO
8p1jt9MD2I/uGRF3zoqomiCffe9Mi3gkP+JhlIrZIMekpyNGWk8qk3+heKyd
KR89gP24Z3rEVXl+Q+uiiN34EnfkRhwXV6vOj3Q4e6/1fWhDl/3dSJX/iDxf
4yhel/8begzJ4kbxT9ZHk36aUa23x/U4Hjlq1+u91hmq5Lqh1nfO9j1O4LIz
n6QjJkdkLo24mBeRId8IeTPpSNqVE7GnRC/0xryIjYURH00UJ98pnJka8ape
avFa4sxZEX167KSr1O6X82N7PqdtauygK8R/qpd8v3vteVPP/+r3DdrDbtJ3
Jf9s/pvstxLr/G/TPvYc69v46xIzZFfJt1MvW9RpxGprh9Uf0McxWpPIaX2n
MyzR/1KsFpP+FB9tkO/eCndKU+l6evdsZ1QvWc/17BR3krzYvuyIidZ+MesP
+NPMZgxSMRqjMES9CeX2IQvr9Vln7xfWd2GomvXWkhJ9s0fr67q7qJb3Go0F
zm3WfehFP26h0f5BGt70AP1bXJt6ae73OTEznfFZOotOc7ZcTEU+e7n151GJ
ZzBWrWU0m6+Q5tAiOrfYXei1yTybcdrZc82i350M4DG/H8U+c30l8d6xBqfF
d6j1Az0ursV8tiNL/Akz6HRfK2i7c/eb/wAGcdS93qJ9uIk2/uX29aj1lXyn
5DtIT9Jv5d1gTwPyn4jYbO/PT5qp3IfFpKu1Uc1N6JJ3LLvT+jjaQe+jh+gu
vV/Bi/quSXyjvp8k99rr7EPpGPXGYjRS1E2j1WZ8wcweMqMHCiJut6/H/iG0
nF2B8XPcH72OK9ZbvZe92IMc9hLr2TSFfZe3mcEOdjq9H5mJWHXWyfM+1ptz
PXbo9UF1i/SyVg/F9JK4Jm+ny/48c+imzeztGOed1Ph+y3y/FShHGX+RusUo
RAkWY7q7XkTfk28hfZd+aPZ/yDOD75I5Dsq/1dzC/LbQT9CIqfwt/n5MoS+b
+Us44v0W6G+NPucm+tT7Z1gp3z/i11nb7B4viBlmzzZrW93fgBq/25Nn/aKa
ufQqe5NeMviH2fcne571X/nn0y728MT74i9gn/O7Xc7z9CwK+M+In0t/opf1
0YJlet+tXiVtpYfk68Bf5tZT+P//Hf8BJExTHg==
         "]],
        RowBox[{"-", "1.98`"}]],
       Annotation[#, -1.98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{25455, 25445, 25457, 25456, 25453, 25454, 14993, 25455}],
        RowBox[{"-", "1.98`"}]],
       Annotation[#, -1.98, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{15055, 18182, 17938, 18898, 18897, 17085, 19237, 19238, 
         18877, 18876, 21808, 15555, 19302, 19303, 18101, 21769, 21768, 15164,
          21781, 21782, 18109, 21784, 21783, 15634, 21776, 21777, 21779, 
         21778, 18104, 21774, 21772, 21773, 15621, 21775, 18105, 19815, 22447,
          15544, 19817, 15545, 22448, 19821, 21786, 21785, 21767, 21770, 
         21771, 19822, 19824, 15554, 21807, 15553, 20905, 20906, 20904, 16789,
          18757, 18756, 18937, 24580, 17783, 24579, 17784, 24581, 17350, 
         19036, 18009, 21714, 18010, 21715, 16684, 16951, 25109, 15851}],
        RowBox[{"-", "2.9699999999999998`"}]],
       Annotation[#, -2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1mlw1tUVx/EDLSEBJBAIiEmA1BASqLYC1rImJCyBYKAJuLEEwdIWEAjU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         "]],
        RowBox[{"-", "2.9699999999999998`"}]],
       Annotation[#, -2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{16438, 25160, 16439, 16311, 18692, 18693, 18315, 15327, 
         19118, 15328, 24294, 24295, 21374, 21376, 21375, 17439, 21729, 21730,
          21726, 21728, 21727, 19077, 24822, 24823, 21732, 21734, 21733, 
         17446, 21390, 17450, 21388, 17449, 21389, 15329, 24299, 17443, 21383,
          17444, 18825, 18824, 22235, 22234, 19642, 18020, 21731, 17442, 
         24297, 24298, 21381, 21380, 21382, 19586, 21384, 24300, 17445, 19641,
          19643, 19644, 18943, 18944, 17955, 19428, 22002, 22003, 18941, 
         19431, 19430, 19429, 17230, 21271, 17229, 21387, 17448, 21385, 17447,
          21386, 15301, 24296, 17441, 21377, 21379, 21378, 17228, 21269, 
         21270, 19427, 22001, 15168, 18940, 24362, 21446, 21447, 23191, 23190,
          16312, 16799, 25189, 16798, 18457, 17616, 25254, 17617, 17235, 
         18946, 17236, 21272, 17237, 21273, 16690, 17234, 25230, 17233}],
        RowBox[{"-", "2.9699999999999998`"}]],
       Annotation[#, -2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1XmQz3Ucx/G3DkmimBg1w2qq6cAaa5e0xIrdtZZdxa6zrFyrbP3jyIym
maahW9O0yBGJWkdoiliEqL+acqdk9lS7jNs6mx6/6Y+n1+/z+X7e9+ezOhSV
DJ3WKCKq/dN9dER+34g0mkfvyYqY3TuizZCI8/RKTsQ1XMfE/IgJGPNURHZm
RMXTEQuGRyzEIkxme3xoxENsH0azQRGHnJ9aFJEyPqIr9orxtVj76GHfpo2I
KEEq/2n4bUBEzriIXAzCiZ4RX6KBvyu4jDpxr9KsgohM5IyKGIgF4pWi3vdr
vufJsVqMQ2K1HRxR4/dpPkf2iqj1u6V8W6HeuRy1vjyQH/pBXsSHuMxXA0an
R4x/LqLzsxHJ6IS3+kV0oS3EyqHV1pOdnYJiJPM1QU9exFTrGt8HOTeE/zJa
+Ixa7e/HAaQ6n2L/Q+e60vm0G23F/xm5HlfDo2p4DFPkf8FeMT2nnvN+P27/
HD2LfDHS+BtKz6gtcs1ODcvUNIneYt0Ii/tELLVX5MxX+rVErJfkkm+vtX62
QVP9vQuH7W8zp3IcFGuzWW1BrdlsxjV93E4nDFMzbvSPWJOtVvRg0x2r+V0p
5ir6OU3isz3aoZ/4Gbju/nRm06Qw4g40xni1b5TjMrkX+FaIb6w3IUMO5/lK
tpeiZzfYd6MdxsrJ/i41XKe76RX9+oFetd5Od2IH+sl9H/0JjfWvKe7ETfFS
+V31gjzdy63uQBLtzHcndPQOOtJfzOAJmowuGKm3o7CBfYMZfsdHthgD0cvv
9ESucv9RvL34TH+XY7Xzo7yN2epdZr0US3BDvnuc222e3yfqsF5ofxFWsim3
9wVdbP0ptllvRZJcKsxhi/dXSU/x+yf/9fQ4vSSH3+U0Tx0fqyFLbZmYgV1s
ptPevpeLe+R5NfCx1zz24Q297OOOpalvRWKeaKLmAfrfNcPbYl/hzGuJ+uQ7
g87CTBwV+z7ne5j3k+iONu5eT1rsvUxJ/D2xnjkyYqwcj6mjtfeyw/5O/Cvf
OWLfpBvcxY1Y4X4tR55c68yuHh3sn0q8efyh5iTr9miHY9b/2O8nzik5P+DO
1NP7aZ35tKWvJN63uCW0Of1VHqflk21d6XsWraIDE++UVrOb5C5PRIV1pv27
+a/mt6V1Jb2XVtEH9fKScxdxAe/rx3vIlv9a+a3HOuxxdg+/peb7kdnOR6lc
MsyjTC699HKEWi7av4RvzWCJPizFGvafeB+lWOttvqreDc6vwVqUYTfbdbR5
4u9fon9mlz0m4na2t+EAm/342d1/RM8Hmenr5j8HzdSwXh6b2Ka7J9Pclzrn
Smg9TaZd8K67NdqsTjtTI+fV4pWLu4pupztR7L7soH34n873DJxRz1mcVPsa
NY8Tqwhz5TdXnvNomdgp/OSyrXS2CtXo73tf3yvY1lrXINW5bpjFJldPB6OF
nJrjL+cWyPkEPSjfUr/L9PJvPk6iCtWJvqijhtaiQYwj5nOZHqV5/N3Kd6F+
jcAwFGA4UsRYaQYF/ja+w/ZtzGP3prrPya0u/f//i/8DjR2WSw==
         "]],
        RowBox[{"-", "2.9699999999999998`"}]],
       Annotation[#, -2.9699999999999998`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{22202, 16390, 18268, 15230, 20981, 16862, 20980, 16863, 
         20982, 22692, 22693, 19185, 19186, 18080, 24866, 24868, 24867, 19187,
          19069, 24845, 24846, 24844, 18058, 24847, 17592, 19140, 22528, 
         20721, 16622, 23476, 16621, 24087, 24088, 24085, 17193, 24086, 24090,
          24089, 15904, 25131, 17895, 18816, 18815, 18814, 15130, 21973, 
         21241, 21972, 24963, 21971, 15892, 19002, 24767, 24768, 24766, 17985,
          19142, 19141, 15232, 24278, 24279, 24277, 24281, 24280, 15727, 
         22698, 25368, 16055, 23007, 21960, 21961, 17498, 21959, 21958, 21957,
          17185, 24076, 17184, 24276, 17426, 24274, 17425, 24275, 15290, 
         24270, 17418, 24269, 17419, 24271, 17173, 19098, 17492, 19314, 18218,
          18219, 17493, 21948, 21947, 23006, 16054, 25367, 22900, 15888, 
         24267, 24268, 24264, 24266, 24265, 15215, 19135, 19136, 17982, 24762,
          17981, 18994, 15709, 23141, 23142, 23138, 23140, 23139, 18548, 
         15126, 19410, 17684, 25068, 15699, 24058, 24059, 24056, 17160, 24057,
          24061, 24060, 16733, 20852, 16734, 20853, 22521, 19134, 17587, 
         24426, 17588, 24423, 24425, 24424, 19067, 19068, 15025, 24945, 17914,
          18850, 18849, 15454, 23381, 16523, 23380, 16522, 15224, 18264, 
         16278, 22118, 22119, 22120, 16468, 23301, 15999, 22967, 16000, 22968,
          18167, 23244, 16389, 22199, 22200, 22201, 16538, 22204, 22203, 
         22202}],
        RowBox[{"-", "2.9699999999999998`"}]],
       Annotation[#, -2.9699999999999998`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1FlslFUYxvEXkLJoMVLAmEgLRCw0UCmJKzBlV+kMO63SsnSQmEBEI0o0
3FgvwETUGKUFFJBqhHqDiewYKwq9UaQUEiEo3QhilXijXZTF31z85/ne853z
ruebkekXF67rFRFpP18/EdHzVMTw8ogl8yNKcWVpRDvypkaUI5WOWEo/fjLi
I9y3ImLtzIhhZRH3YurkiL1zIopp+7MR3yYi2mg9/WllxBlcnx3xg7NvT4l4
sDKijn3WepI20hRtol3iTHw6otveHuydEfEf/RdbnD01N6IB3+Ekvsfri9iT
IsqS8kfB8oixyMdFde2X1/hV4nhuwjjPFTjv+Sxu8FvIvuD5En7GWP7GOD+G
XiiJyJXfKX06iWz+Ns+LeAubsLY44jH9mubddPyjhnmpiD4LIu5AJ7svrXXu
oDpWT4sY8EzEQHRZ67LWSR9S/wQUom5WxAhx8/CIXj6M3CURCb3LMY8pdI+4
b4hbS6togo9PzeEzpM1nv75U0i9pXqY/ZptLz/H5h7514KgZPZ/phb71N8sc
tQ9BP8/1YmTRhlK1Y6g6fhGnUr4v27Mepd6XYbXYje5F98KISXoyGffzORyP
LtYf5Iu3U8278JccR7MfwCjs1t9e6rsnU5MebhWrWr7VtIYWqn873cbeRmvo
GvE3qmcQ+7Zz2TSs3037yukuesv6nfQmbZB7Pd/92J3sLNpF+9Ok/QNpD3sA
7aYn7N/Af5vZNZlZKz1H2+kONTTTRvZleoa+xHeWcxPUOsL8ctT1rn3voUO9
w9hDMQTH9eoYiuwdrEfj9WscLuvfN5k7JG6tnu/BYXkcwkZ9L3Jmi5km5FuM
0fy+5htppdliJs02hRJ7V/FRwH+aHuXzGFrsa0a5PG/zmdKvWzRJd8nrcfdh
J/0kM5PMdyaffN/jVvN9JxPTvb5o7z7+P7B2zd36Qj7v27dpunvp/WY6Uawi
vKKmxWKtpxvwKn6TzyHvDuNve0/Lt4+1lmURvely93sFCip8f/hVnNPsWe7H
bOzwnzWTzsCP1s97n29fs/OtaENKTyvkttsdPsDnMs9f0aT1EqyTxws4Ie82
tbRn/mvU0UpbsNJM55ppnXr24XPMYS+wfkPOf4pxk16nCf8fz6mhmF4V70N3
uZqPGlTp1SI5vkkv6cM1MTvwO46of43eVuF/p4EgmQ==
         "]],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15382, 18659, 15383, 22233, 22232, 23283, 23282, 18316, 
         17440, 25011, 15385, 19076, 15384, 25010, 18019, 18200, 17451, 25012,
          15386, 19078, 15387, 25013, 17452, 18317, 24363, 17539, 22311, 
         22312, 22313, 18822, 18823, 17903, 19322, 21819}],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{15427, 25027, 16481, 16429, 18690, 19371}],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15830, 25101, 16934, 16809, 17960, 25276, 17959, 18962, 
         15658, 25058, 17637, 16026, 17613, 25053, 15639, 18942, 17231, 25229,
          17232, 16699, 24616, 17823, 22817, 22818, 22819, 18945, 15824, 
         22821, 22820, 24618, 24617, 15984, 24663, 24664, 22887, 22888, 15881,
          18939, 24140, 24141, 21268, 25187, 16797, 23682, 21511, 22608, 
         25052, 22609, 21510, 22610, 15638, 19146, 22607, 22606, 19942, 17612,
          21509, 18201, 18202, 17614, 21512, 17615, 21513, 17120, 21194, 
         24014, 24013, 21192, 21193, 16688, 21195, 16687, 20792, 18759, 16989,
          21667, 17897, 20104, 20105, 20106, 19147, 22916, 22915, 20107, 
         21670, 21669, 21668, 20796, 25188, 16692, 20794, 16691, 20795, 18461,
          19333, 19332, 19331, 17007, 21468, 21469, 21467, 17564, 19867, 
         19866, 20801, 16698, 25181, 20108, 20109, 17898, 25133, 15909, 19126,
          17565, 21470, 17566, 19869, 19870, 19871, 18793, 15571, 18363, 
         16712, 22488, 22489, 22490, 18762, 18908, 24467, 24468, 24466, 17652,
          24469, 17261, 18968, 17962, 21699, 17963, 21700, 16819, 21055, 
         16936, 20079, 22825, 15831}],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{16440, 18658, 16310, 16996, 25215, 16995}],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{17339, 25243, 17340, 16776, 17342, 25244, 17341, 19027, 
         15774, 25087, 17764, 17215, 20768, 16666, 19816, 19818, 19819, 17864,
          21167, 17076, 19820, 17077, 21168, 16084, 21173, 17084, 19823, 
         17083, 21503, 17603, 21502, 22596, 20782, 16679, 20772, 16678, 20781,
          21587, 25413, 25415, 25414, 17781, 24578, 17782, 21588, 16683, 
         19834, 22463, 15558, 19832, 19833, 16681, 20785, 16680, 18758, 15165,
          20773, 16672, 20771, 16673, 20774, 22595, 20770, 16671, 20769, 
         16670, 23545, 18513, 20766, 16663, 20765, 16664, 21086, 21087, 21085,
          16962, 19813, 19812, 19810, 16665, 20767, 18230, 20754, 16647, 
         19801, 20893, 22435, 15533, 20894, 15532, 18358, 16762, 22554, 22555,
          22556, 18745, 18931, 24557, 24558, 24556, 17758, 24559, 17330, 
         19023, 17331, 21308, 17332, 21309, 16419, 21307, 17329, 21306, 24195,
          24194}],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{18106, 21780, 18107, 19306, 19305, 22790, 22789, 22788, 
         18108, 24882, 18371, 18111, 25094, 15793, 19307, 15792, 25093, 18110,
          18234, 18102, 25091, 15790, 19304, 15791, 25092, 18103, 18362, 
         24636, 24637, 22851, 22852, 15850, 18878, 18896}],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1FtMl3UYwPGHwDzkxBMzwgu96iAXujltoihimQf+CB5ISEBM3Up0Vlhg
oOZaOp1ubjgNZ/1BUKcDU3Sh5blpHi5EttzqqjvN0425ZjM/rIsv3/f3vr/3
Ofye98/oqjXFq1Mi4m1/5s6IqM2PeH12ROGciATecP0mEp69XBHRD31xIyci
e0HETU4ujRjjumpuxEM8QF5JRG5VxDR+ZP1jaUQX7k+NeFYYsde9E+J0YtP7
EZvxFXKWia+Gp0siji+0B5+8F9GT5/qDiJPoxC9TIlapq/xdMSsjKviM9Wkc
VFPz/IgWJFGk9gM8anFEdSKiUV1fy5Ht3jB1DMd6OdIXRQxChvVk8a7p6Rv7
2uybL0YrF/MANXfJcch6kfVBLuHDvMP+cbyTM8V5DVloE3+I2IOxsjxil+d7
1DFGPUl9H/XOYjGO8EDxX0G9HBv1swlTe/vT58/4CRPdq3YGzd5twS3n1I1M
72yTq85ZNznrWt7H63niZLHNI6tMXSieF/Gl+/s9b+B6pBaYmbpK7StDmnUf
HNBDK1LFyHEurfIPVuMQpONDtU93Lw9Fvpti5Lv+Tp8rPWsRczkPtXcFD+Nl
3GbPHXF/Q40eH4udPTNiEs94J2Ks8+nSX61en9hbx6etk2pvnhbxPSd5tTNd
g2p8K+cUe/dyjzz54tzi2+jGf85oqzMKvVwwj/O9cxejW/8VclfiVbXVmEUm
r+MM/oxH8Kf8hzy/Y4M8TRhpJtvkyeLtnKH/4bii3gu+14s4i/M4h8NqSJXz
mpxpfJ0r1fMrv2R9hVP4KndMivjCbD/HKd9wQ674ficp5jPeO9X2NJrhR7wK
H6NG/C3eT5jzPBSizN79s8wE/6hxiXjlqMBuPTTint7+wl206/U+X53ud83H
rB9wBx91RkeQq5dSv82/1fIUj+W45/4jPuasf0AHBsl3nOvM5C15Jph1p7M6
hZO4JEa7WJe5p8h3b8YJZ/envQU8wHfQH3u899y3Mbu3Fl5rfcO3868Z7rJ3
lvt95CngNJ7DzVX//297ATAG+EQ=
         "]],
        RowBox[{"-", "3.96`"}]],
       Annotation[#, -3.96, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129506327]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(21)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Schemes and Collections",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1461350],

Cell["Obtain the list of collections:", "ExampleText",
 CellID->219284098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174464948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Gradients\"\>", ",", "\<\"Indexed\"\>", ",", "\<\"Named\"\>", 
   ",", "\<\"Physical\"\>"}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135666278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->407770532],

Cell["Find the schemes that belong to each collection:", "ExampleText",
 CellID->50328223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521466319],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"DarkRainbow\"\>", ",", "\<\"Rainbow\"\>", 
    ",", "\<\"Pastel\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "46", "\[RightSkeleton]"}], 
    ",", "\<\"BrightBands\"\>", ",", "\<\"DarkBands\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->24352087]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ColorData", "[", "\"\<Indexed\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361406885],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
    RowBox[{"\[LeftSkeleton]", "17", "\[RightSkeleton]"}], ",", "31", ",", 
    "32", ",", "33", ",", "34", ",", "35", ",", "36", ",", "37", ",", "38", 
    ",", "39", ",", "40", ",", "41", ",", "42", ",", "43"}], "}"}],
  Short]], "Output",
 ImageSize->{388, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->253334836]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<Named\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->666773682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Atoms\"\>", ",", "\<\"GeologicMap\"\>", ",", "\<\"HTML\"\>", 
   ",", "\<\"Legacy\"\>", ",", "\<\"WebSafe\"\>"}], "}"}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23153730]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<Physical\>\"", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->527619832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BlackBodySpectrum\"\>", ",", "\<\"HypsometricTints\"\>", 
   ",", "\<\"VisibleSpectrum\"\>"}], "}"}]], "Output",
 ImageSize->{377, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->69193080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282613977],

Cell[TextData[{
 "Gradients are continuous color functions that are suitable for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->155120819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"y", "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", "y"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"ColorData", "[", "\"\<SunsetColors\>\"", "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322282189],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25363431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175703075],

Cell["\<\
Indexed schemes consist of lists of colors associated with discrete values:\
\>", "ExampleText",
 CellID->58327190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"ColorData", "[", 
    RowBox[{"3", ",", "\"\<ColorList\>\""}], "]"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194367212],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "]"}], ",", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.996078431372549`", ",", "0.3607843137254902`", ",", 
      "0.027450980392156862`"}], "]"}], ",", 
    RowBox[{"\[LeftSkeleton]", "7", "\[RightSkeleton]"}], ",", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.9058823529411765`", ",", "0.027450980392156862`", ",", 
      "0.12941176470588237`"}], "]"}]}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{424, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->252226334]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "i"}], ",", 
         RowBox[{
          RowBox[{"2", " ", "i"}], " ", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "7"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81302483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"ColorData", "[", 
     RowBox[{"3", ",", "\"\<ColorList\>\""}], "]"}]}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4907490],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->184904922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->659980641],

Cell["Named schemes are sets of well-known named colors:", "ExampleText",
 CellID->218112041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ColorData", "[", 
     RowBox[{"\"\<HTML\>\"", ",", "\"\<Violet\>\""}], "]"}], ",", 
    RowBox[{"Disk", "[", "]"}], ",", 
    RowBox[{"ColorData", "[", 
     RowBox[{"\"\<HTML\>\"", ",", "\"\<MidnightBlue\>\""}], "]"}], ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400936171],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.9333333333333333, 0.5098039215686274, 0.9333333333333333], 
    DiskBox[{0, 0}]}, 
   {RGBColor[0.09803921568627451, 0.09803921568627451, 0.4392156862745098], 
    DiskBox[{1, 0}]}}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568240405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178866093],

Cell["Physical schemes return colors based on physical values:", "ExampleText",
 CellID->57807761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "380", ",", "750"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "50"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "10"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->112539553],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmltoFFcYx3+ZTXazm4ugtnghaFsDldq1eKEqQWKVxNgE0xjFiFY31pCo
vWCiKD54QVr6EEVsQVSspdAUaZtCUxGND0oVLcU8BMVLkDbVWOMl2ppoNIc6
s2Z0MjO72aSxmPItO+f6zTnf//zOnDkDJy9UUbrs/VBF2dLQyOxVoY9Ky5aW
j8z6cJVe5IkDavTrjSHo6X/0VPiqUUrpFY4w0QjjdQtl/jQ94+mMk4xaz5Pa
cNKsC+ixNW/G/s5yzVafZLOztqNFsLf2rbn51sVzuzcOdZ29mK1iyxvJRLvi
buwDUerd7P0uqqLZ+4zAa1UQmw6vQ3l8LMoTrOMZix77eLn1YkzJOCMOlxme
GY49luYQ5qokPgb//z8k/I47eqrFbdY6KTha7EbdEzWW+xKESh9SMdSYa2Es
NEx7j/W+Lj4G+rxF6/oe64zxRG0xyVES08g63lrOlrV/ParRV0Qj2bt102fL
a89dX719snzuFFz76zr7e7YXMfcDZpxsy0fad/TW3ij3RLC3z++nO5BI+67H
4Q/mukOkNdNIDrblBz2Legcfp1/fuhDoe4twSfZQstPIf4midIpHs+J1Ksaz
aTLbMtmTxf5cDhZwvJBf5nF6PvULOLeQhnf5fQlNxTS/R0sJd0u5X4YKoRbE
qQJNvR2vpntVhk9N8KsxSSo9WaWlqhcHqAEDO1KGtyaPagkEr/nfbPRlNnhz
zibMqfMsPKUtO8YHtaw9wMZqPvmarXv57HN2V/LlFr5ZT3U5Py2ntphjRZzK
py6H+rc4m8GFiVwaS+OrNL1M83BuvcBfqbQl0q6RTAekex8ytJ0xbWTeZc4d
SlpYd4PKZvZd5ccrnGjk/G9cvkhTPX/+yvWfuXmElgPc+Z6/q2j9gns7ebCd
jk9RG1AVqFLUItQ7qCzUFNRY1CuoIagU9Oerw5iRD/XrgTHK7XA//Ee7pwfp
bdAKt+Ea/AENcAbq4CQchcPhL4nvoAr2wS7YAZXwMWyEdVAOK6EEFkMRFMJs
mAVZMA0yYBJMhHEQhNfo+o6NRn8YOSOYO4olOvoga8azeRKVU9k5na9mUp3H
IaH/PNLPh1yYCTMg05wAE/RvUaEv9IW+0Bf6Ql/oC32hL/SFvtAX+kJf6At9
oS/0hb7QF/pCX+gLfaEv9IW+0Bf6Ql/oC32hL/SFvtAX+v2bvu1UZ5DVcqqz
H9C3neqc3ONTnf/NyWF3C8sZ67hHWTO75Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69687299]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28728040],

Cell["Find all the properties of color schemes:", "ExampleText",
 CellID->84859578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<Properties\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448730164],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ColorFunction\"\>", ",", "\<\"ColorList\"\>", 
   ",", "\<\"ColorRules\"\>", ",", "\<\"Image\"\>", ",", "\<\"Name\"\>", 
   ",", "\<\"Panel\"\>", ",", "\<\"ParameterCount\"\>", 
   ",", "\<\"Range\"\>"}], "}"}]], "Output",
 ImageSize->{552, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44682617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->372608753],

Cell[TextData[{
 Cell[BoxData["\"\<ColorFunction\>\""], "InlineFormula"],
 " returns the ",
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->328768894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<SouthwestColors\>\"", ",", "\"\<ColorFunction\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11481048],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVVXs81IkXnUJNnpFHS0laSyqll1I5yRIieWwlm0d5lI1Cu8qKJSmiFIpN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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86585641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356377938],

Cell["Get the list of colors in a discrete color scheme:", "ExampleText",
 CellID->181832299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"38", ",", "\"\<ColorList\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66688319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.5686274509803921`", ",", "0.2980392156862745`", ",", 
     "0.1450980392156863`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.7058823529411765`", ",", "0.6980392156862745`", ",", 
     "0.4980392156862745`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.6509803921568628`", ",", "0.7607843137254902`", ",", 
     "0.22745098039215686`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.39215686274509803`", ",", "0.7294117647058823`", ",", 
     "0.5843137254901961`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.8235294117647058`", ",", "0.8941176470588236`", ",", 
     "0.9490196078431372`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.22745098039215686`", ",", "0.19215686274509805`", ",", "0.4`"}], "]"}],
    ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.5019607843137255`", ",", "0.23921568627450981`", ",", 
     "0.4470588235294118`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
    "0.6705882352941176`", ",", "0.12941176470588237`", ",", 
     "0.22745098039215686`"}], "]"}]}], "}"}]], "Output",
 ImageSize->{550, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303857318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ColorData", "[", 
   RowBox[{"\"\<Atoms\>\"", ",", "\"\<ColorList\>\""}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->39216089],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"0.65`", ",", "0.7`", ",", "0.7`"}], "]"}], ",", 
    RowBox[{"\[LeftSkeleton]", "116", "\[RightSkeleton]"}], ",", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0.635401`", ",", "0.0596628`", ",", "0.226184`"}], "]"}]}], 
   "}"}],
  Short]], "Output",
 ImageSize->{520, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->380236548]
}, Open  ]],

Cell["Gradients and physical schemes can not return color lists:", \
"ExampleText",
 CellID->507047389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<PlumColors\>\"", ",", "\"\<ColorList\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->227624324],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->292314543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533771749],

Cell["\<\
Get the color replacement rules from a discrete color scheme:\
\>", "ExampleText",
 CellID->50744247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"42", ",", "\"\<ColorRules\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->850492827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.9254901960784314`", ",", "0.8666666666666667`", ",", 
      "0.7568627450980392`"}], "]"}]}], ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.7333333333333333`", ",", "0.6666666666666666`", ",", 
      "0.5411764705882353`"}], "]"}]}], ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.5843137254901961`", ",", "0.5333333333333333`", ",", 
      "0.4117647058823529`"}], "]"}]}], ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.6862745098039216`", ",", "0.6470588235294118`", ",", 
      "0.27450980392156865`"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{302, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181255851]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<Legacy\>\"", ",", "\"\<ColorRules\>\""}], "]"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->926139882],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"AliceBlue\"\>", "\[Rule]", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.941206`", ",", "0.972503`", ",", "1.`"}], "]"}]}], ",", 
    RowBox[{"\<\"AlizarinCrimson\"\>", "\[Rule]", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.889996`", ",", "0.149998`", ",", "0.209998`"}], "]"}]}], ",",
     
    RowBox[{"\[LeftSkeleton]", "190", "\[RightSkeleton]"}], ",", 
    RowBox[{"\<\"Zinc\"\>", "\[Rule]", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.990005`", ",", "0.97`", ",", "1.`"}], "]"}]}]}], "}"}],
  Short[#, 3]& ]], "Output",
 ImageSize->{400, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->17356793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435929477],

Cell["Get a representative image of a scheme:", "ExampleText",
 CellID->18679525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<DarkRainbow\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143376534],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt0GtLkwEAxfHHcxh9haAX+T1y23PZ1bW5Z5OmYpdHzaYlM50lkt0wiREu
KwkGYdAFjJBCBLHZWnYhJFBEEUXsc/SmRl+ht+fFgT/n5S/pFfMXh7ziQK/X
HB3xhvMDvaPNkcJI42KTYRi/Gzt53Gj0n0b9G1tyj33+3KNjgdysL5h76DM7
yjQ7ZmB1lWh1T8M6d4f2hUnYPeO0+4qw+wtw8pfpDPbDudLD0NB5hAvdDA93
InL1DKOj7YgWXcbGUohfTzA+HkPrRJjJGyG4Nx2233aQu2uza8rC2WmT3n0T
faUgLj0IcHDGj8JsgGNPgph4GuStiol7z0yWnlsov7A499pGZcHh/FsHLxdD
XHgfxuJShEvLUaysxFhdjaO+1spvtQQ26qex+SXJrfUUtj+nuFNvw+6nNPdq
aex/dHmw5uKwmuFRNYtfH7I8Ws7i8F2GB29c7L9yuTefxm4lzZ25NmyXU9gq
pbg5lcTPyQQ3rsXxoxDj93wEX70Q1ztt1DMma4kAqqGWE6v+U4YhWclKVrKS
laxkJStZyUpWspKVrGQlK1nJSlaykpWsZCUrWclKVrKSlaxkJStZyUpWspKV
rGQl+z+yRtNfAVzpew==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24257258]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"22", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->477615620],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztjqFLQ2EUxc/jA2fYEJPfXdnQ4J8gJptahBWjg8cQ32CizDWDVYNpCPah
0WIRTJZhW10Qm6/aV57nzAeCbf1+nO/HPZcbfgfpIDs+TQfdTtrc66fnWbdz
0dw963MVEgAz/noE54LT/G/leY5QFEU+f2j96z0iYeVt4JitLjOIgvr4aOnj
pIIoBBauvseACWH6DPbR2xdM0P3+4V2r/YAoBBau7m8nMCHcXL2yb9bqMEH3
75fDz+sRohBYuHpZ34ERiZu5mZu5mZu5mZu5mZu5mZu5mZstatZeqTCIQmnG
wAR1yjAwQX34NGEQhdKMgQnqlGFggvpGdY1BFEozBiaoPza2GUTiz2z265f8
AOVQjs8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43541009]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<HTML\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->88903819],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[Opacity[0.1]], {
    {RGBColor[1., 1., 1.], DiskBox[{1, 9}, 0.45]}, 
    {RGBColor[0.9607843137254902, 0.9607843137254902, 0.9607843137254902], 
     DiskBox[{2, 9}, 0.45]}, 
    {RGBColor[0.8627450980392157, 0.8627450980392157, 0.8627450980392157], 
     DiskBox[{3, 9}, 0.45]}, 
    {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
     DiskBox[{4, 9}, 0.45]}, 
    {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
     DiskBox[{5, 9}, 0.45]}, 
    {RGBColor[0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
     DiskBox[{6, 9}, 0.45]}, 
    {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
     DiskBox[{7, 9}, 0.45]}, 
    {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
     DiskBox[{8, 9}, 0.45]}, 
    {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
     DiskBox[{9, 9}, 0.45]}, 
    {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
     DiskBox[{10, 9}, 0.45]}, 
    {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
     DiskBox[{11, 9}, 0.45]}, 
    {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
     DiskBox[{12, 9}, 0.45]}, 
    {RGBColor[0., 0., 0.], DiskBox[{13, 9}, 0.45]}, 
    {RGBColor[1., 0.9803921568627451, 0.9803921568627451], 
     DiskBox[{14, 9}, 0.45]}, 
    {RGBColor[0.7372549019607844, 0.5607843137254902, 0.5607843137254902], 
     DiskBox[{15, 9}, 0.45]}, 
    {RGBColor[0.9411764705882353, 0.5019607843137255, 0.5019607843137255], 
     DiskBox[{16, 9}, 0.45]}, 
    {RGBColor[0.803921568627451, 0.3607843137254902, 0.3607843137254902], 
     DiskBox[{17, 9}, 0.45]}, 
    {RGBColor[0.6470588235294118, 0.16470588235294117`, 0.16470588235294117`],
      DiskBox[{18, 9}, 0.45]}}, {
    {RGBColor[0.6980392156862745, 0.13333333333333333`, 0.13333333333333333`],
      DiskBox[{1, 8}, 0.45]}, 
    {RGBColor[1., 0., 0.], DiskBox[{2, 8}, 0.45]}, 
    {RGBColor[0.5450980392156862, 0., 0.], DiskBox[{3, 8}, 0.45]}, 
    {RGBColor[0.5019607843137255, 0., 0.], DiskBox[{4, 8}, 0.45]}, 
    {RGBColor[1., 0.8941176470588236, 0.8823529411764706], 
     DiskBox[{5, 8}, 0.45]}, 
    {RGBColor[0.9803921568627451, 0.5019607843137255, 0.4470588235294118], 
     DiskBox[{6, 8}, 0.45]}, 
    {RGBColor[1., 0.38823529411764707`, 0.2784313725490196], 
     DiskBox[{7, 8}, 0.45]}, 
    {RGBColor[0.9137254901960784, 0.5882352941176471, 0.47843137254901963`], 
     DiskBox[{8, 8}, 0.45]}, 
    {RGBColor[1., 0.4980392156862745, 0.3137254901960784], 
     DiskBox[{9, 8}, 0.45]}, 
    {RGBColor[1., 0.27058823529411763`, 0.], DiskBox[{10, 8}, 0.45]}, 
    {RGBColor[1., 0.6274509803921569, 0.47843137254901963`], 
     DiskBox[{11, 8}, 0.45]}, 
    {RGBColor[0.6274509803921569, 0.3215686274509804, 0.17647058823529413`], 
     DiskBox[{12, 8}, 0.45]}, 
    {RGBColor[1., 0.9607843137254902, 0.9333333333333333], 
     DiskBox[{13, 8}, 0.45]}, 
    {RGBColor[0.8235294117647058, 0.4117647058823529, 0.11764705882352941`], 
     DiskBox[{14, 8}, 0.45]}, 
    {RGBColor[0.5450980392156862, 0.27058823529411763`, 0.07450980392156863], 
     DiskBox[{15, 8}, 0.45]}, 
    {RGBColor[0.9568627450980393, 0.6431372549019608, 0.3764705882352941], 
     DiskBox[{16, 8}, 0.45]}, 
    {RGBColor[1., 0.8549019607843137, 0.7254901960784313], 
     DiskBox[{17, 8}, 0.45]}, 
    {RGBColor[0.803921568627451, 0.5215686274509804, 0.24705882352941178`], 
     DiskBox[{18, 8}, 0.45]}}, {
    {RGBColor[0.9803921568627451, 0.9411764705882353, 0.9019607843137255], 
     DiskBox[{1, 7}, 0.45]}, 
    {RGBColor[1., 0.8941176470588236, 0.7686274509803922], 
     DiskBox[{2, 7}, 0.45]}, 
    {RGBColor[1., 0.5490196078431373, 0.], DiskBox[{3, 7}, 0.45]}, 
    {RGBColor[0.8705882352941177, 0.7215686274509804, 0.5294117647058824], 
     DiskBox[{4, 7}, 0.45]}, 
    {RGBColor[0.9803921568627451, 0.9215686274509803, 0.8431372549019608], 
     DiskBox[{5, 7}, 0.45]}, 
    {RGBColor[0.8235294117647058, 0.7058823529411765, 0.5490196078431373], 
     DiskBox[{6, 7}, 0.45]}, 
    {RGBColor[1., 0.8705882352941177, 0.6784313725490196], 
     DiskBox[{7, 7}, 0.45]}, 
    {RGBColor[1., 0.9215686274509803, 0.803921568627451], 
     DiskBox[{8, 7}, 0.45]}, 
    {RGBColor[1., 0.9372549019607843, 0.8352941176470589], 
     DiskBox[{9, 7}, 0.45]}, 
    {RGBColor[1., 0.8941176470588236, 0.7098039215686275], 
     DiskBox[{10, 7}, 0.45]}, 
    {RGBColor[1., 0.6470588235294118, 0.], DiskBox[{11, 7}, 0.45]}, 
    {RGBColor[0.9607843137254902, 0.8705882352941177, 0.7019607843137254], 
     DiskBox[{12, 7}, 0.45]}, 
    {RGBColor[0.9921568627450981, 0.9607843137254902, 0.9019607843137255], 
     DiskBox[{13, 7}, 0.45]}, 
    {RGBColor[1., 0.9803921568627451, 0.9411764705882353], 
     DiskBox[{14, 7}, 0.45]}, 
    {RGBColor[0.7215686274509804, 0.5254901960784314, 0.043137254901960784`], 
     DiskBox[{15, 7}, 0.45]}, 
    {RGBColor[0.8549019607843137, 0.6470588235294118, 0.12549019607843137`], 
     DiskBox[{16, 7}, 0.45]}, 
    {RGBColor[1., 0.9725490196078431, 0.8627450980392157], 
     DiskBox[{17, 7}, 0.45]}, 
    {RGBColor[1., 0.8431372549019608, 0.], DiskBox[{18, 7}, 0.45]}}, {
    {RGBColor[1., 0.9803921568627451, 0.803921568627451], 
     DiskBox[{1, 6}, 0.45]}, 
    {RGBColor[0.9411764705882353, 0.9019607843137255, 0.5490196078431373], 
     DiskBox[{2, 6}, 0.45]}, 
    {RGBColor[0.9333333333333333, 0.9098039215686274, 0.6666666666666666], 
     DiskBox[{3, 6}, 0.45]}, 
    {RGBColor[0.7411764705882353, 0.7176470588235294, 0.4196078431372549], 
     DiskBox[{4, 6}, 0.45]}, 
    {RGBColor[1., 1., 0.9411764705882353], DiskBox[{5, 6}, 0.45]}, 
    {RGBColor[0.9607843137254902, 0.9607843137254902, 0.8627450980392157], 
     DiskBox[{6, 6}, 0.45]}, 
    {RGBColor[1., 1., 0.8784313725490196], DiskBox[{7, 6}, 0.45]}, 
    {RGBColor[0.9803921568627451, 0.9803921568627451, 0.8235294117647058], 
     DiskBox[{8, 6}, 0.45]}, 
    {RGBColor[1., 1., 0.], DiskBox[{9, 6}, 0.45]}, 
    {RGBColor[0.5019607843137255, 0.5019607843137255, 0.], 
     DiskBox[{10, 6}, 0.45]}, 
    {RGBColor[0.4196078431372549, 0.5568627450980392, 0.13725490196078433`], 
     DiskBox[{11, 6}, 0.45]}, 
    {RGBColor[0.6039215686274509, 0.803921568627451, 0.19607843137254902`], 
     DiskBox[{12, 6}, 0.45]}, 
    {RGBColor[0.3333333333333333, 0.4196078431372549, 0.1843137254901961], 
     DiskBox[{13, 6}, 0.45]}, 
    {RGBColor[0.6784313725490196, 1., 0.1843137254901961], 
     DiskBox[{14, 6}, 0.45]}, 
    {RGBColor[0.4980392156862745, 1., 0.], DiskBox[{15, 6}, 0.45]}, 
    {RGBColor[0.48627450980392156`, 0.9882352941176471, 0.], 
     DiskBox[{16, 6}, 0.45]}, 
    {RGBColor[0.9411764705882353, 1., 0.9411764705882353], 
     DiskBox[{17, 6}, 0.45]}, 
    {RGBColor[0.5607843137254902, 0.7372549019607844, 0.5607843137254902], 
     DiskBox[{18, 6}, 0.45]}}, {
    {RGBColor[0.596078431372549, 0.984313725490196, 0.596078431372549], 
     DiskBox[{1, 5}, 0.45]}, 
    {RGBColor[0.5647058823529412, 0.9333333333333333, 0.5647058823529412], 
     DiskBox[{2, 5}, 0.45]}, 
    {RGBColor[0.13333333333333333`, 0.5450980392156862, 0.13333333333333333`],
      DiskBox[{3, 5}, 0.45]}, 
    {RGBColor[0.19607843137254902`, 0.803921568627451, 0.19607843137254902`], 
     DiskBox[{4, 5}, 0.45]}, 
    {RGBColor[0., 1., 0.], DiskBox[{5, 5}, 0.45]}, 
    {RGBColor[0., 0.5019607843137255, 0.], DiskBox[{6, 5}, 0.45]}, 
    {RGBColor[0., 0.39215686274509803`, 0.], DiskBox[{7, 5}, 0.45]}, 
    {RGBColor[0.1803921568627451, 0.5450980392156862, 0.3411764705882353], 
     DiskBox[{8, 5}, 0.45]}, 
    {RGBColor[0.23529411764705882`, 0.7019607843137254, 0.44313725490196076`],
      DiskBox[{9, 5}, 0.45]}, 
    {RGBColor[0., 1., 0.4980392156862745], DiskBox[{10, 5}, 0.45]}, 
    {RGBColor[0.9607843137254902, 1., 0.9803921568627451], 
     DiskBox[{11, 5}, 0.45]}, 
    {RGBColor[0., 0.9803921568627451, 0.6039215686274509], 
     DiskBox[{12, 5}, 0.45]}, 
    {RGBColor[0.4, 0.803921568627451, 0.6666666666666666], 
     DiskBox[{13, 5}, 0.45]}, 
    {RGBColor[0.4980392156862745, 1., 0.8313725490196079], 
     DiskBox[{14, 5}, 0.45]}, 
    {RGBColor[0.25098039215686274`, 0.8784313725490196, 0.8156862745098039], 
     DiskBox[{15, 5}, 0.45]}, 
    {RGBColor[0.12549019607843137`, 0.6980392156862745, 0.6666666666666666], 
     DiskBox[{16, 5}, 0.45]}, 
    {RGBColor[0.2823529411764706, 0.8196078431372549, 0.8], 
     DiskBox[{17, 5}, 0.45]}, 
    {RGBColor[0.9411764705882353, 1., 1.], DiskBox[{18, 5}, 0.45]}}, {
    {RGBColor[0.8784313725490196, 1., 1.], DiskBox[{1, 4}, 0.45]}, 
    {RGBColor[0.6862745098039216, 0.9333333333333333, 0.9333333333333333], 
     DiskBox[{2, 4}, 0.45]}, 
    {RGBColor[0.1843137254901961, 0.30980392156862746`, 0.30980392156862746`],
      DiskBox[{3, 4}, 0.45]}, 
    {RGBColor[0.1843137254901961, 0.30980392156862746`, 0.30980392156862746`],
      DiskBox[{4, 4}, 0.45]}, 
    {RGBColor[0., 1., 1.], DiskBox[{5, 4}, 0.45]}, 
    {RGBColor[0., 1., 1.], DiskBox[{6, 4}, 0.45]}, 
    {RGBColor[0., 0.5450980392156862, 0.5450980392156862], 
     DiskBox[{7, 4}, 0.45]}, 
    {RGBColor[0., 0.5019607843137255, 0.5019607843137255], 
     DiskBox[{8, 4}, 0.45]}, 
    {RGBColor[0., 0.807843137254902, 0.8196078431372549], 
     DiskBox[{9, 4}, 0.45]}, 
    {RGBColor[0.37254901960784315`, 0.6196078431372549, 0.6274509803921569], 
     DiskBox[{10, 4}, 0.45]}, 
    {RGBColor[0.6901960784313725, 0.8784313725490196, 0.9019607843137255], 
     DiskBox[{11, 4}, 0.45]}, 
    {RGBColor[0.6784313725490196, 0.8470588235294118, 0.9019607843137255], 
     DiskBox[{12, 4}, 0.45]}, 
    {RGBColor[0., 0.7490196078431373, 1.], DiskBox[{13, 4}, 0.45]}, 
    {RGBColor[0.5294117647058824, 0.807843137254902, 0.9215686274509803], 
     DiskBox[{14, 4}, 0.45]}, 
    {RGBColor[0.5294117647058824, 0.807843137254902, 0.9803921568627451], 
     DiskBox[{15, 4}, 0.45]}, 
    {RGBColor[0.27450980392156865`, 0.5098039215686274, 0.7058823529411765], 
     DiskBox[{16, 4}, 0.45]}, 
    {RGBColor[0.9411764705882353, 0.9725490196078431, 1.], 
     DiskBox[{17, 4}, 0.45]}, 
    {RGBColor[0.11764705882352941`, 0.5647058823529412, 1.], 
     DiskBox[{18, 4}, 0.45]}}, {
    {RGBColor[0.4666666666666667, 0.5333333333333333, 0.6], 
     DiskBox[{1, 3}, 0.45]}, 
    {RGBColor[0.4666666666666667, 0.5333333333333333, 0.6], 
     DiskBox[{2, 3}, 0.45]}, 
    {RGBColor[0.4392156862745098, 0.5019607843137255, 0.5647058823529412], 
     DiskBox[{3, 3}, 0.45]}, 
    {RGBColor[0.4392156862745098, 0.5019607843137255, 0.5647058823529412], 
     DiskBox[{4, 3}, 0.45]}, 
    {RGBColor[0.6901960784313725, 0.7686274509803922, 0.8705882352941177], 
     DiskBox[{5, 3}, 0.45]}, 
    {RGBColor[0.39215686274509803`, 0.5843137254901961, 0.9294117647058824], 
     DiskBox[{6, 3}, 0.45]}, 
    {RGBColor[0.2549019607843137, 0.4117647058823529, 0.8823529411764706], 
     DiskBox[{7, 3}, 0.45]}, 
    {RGBColor[0.9725490196078431, 0.9725490196078431, 1.], 
     DiskBox[{8, 3}, 0.45]}, 
    {RGBColor[0.9019607843137255, 0.9019607843137255, 0.9803921568627451], 
     DiskBox[{9, 3}, 0.45]}, 
    {RGBColor[0.09803921568627451, 0.09803921568627451, 0.4392156862745098], 
     DiskBox[{10, 3}, 0.45]}, 
    {RGBColor[0., 0., 1.], DiskBox[{11, 3}, 0.45]}, 
    {RGBColor[0., 0., 0.803921568627451], DiskBox[{12, 3}, 0.45]}, 
    {RGBColor[0., 0., 0.5450980392156862], DiskBox[{13, 3}, 0.45]}, 
    {RGBColor[0., 0., 0.5019607843137255], DiskBox[{14, 3}, 0.45]}, 
    {RGBColor[0.41568627450980394`, 0.35294117647058826`, 0.803921568627451], 
     DiskBox[{15, 3}, 0.45]}, 
    {RGBColor[0.2823529411764706, 0.23921568627450981`, 0.5450980392156862], 
     DiskBox[{16, 3}, 0.45]}, 
    {RGBColor[0.4823529411764706, 0.40784313725490196`, 0.9333333333333333], 
     DiskBox[{17, 3}, 0.45]}, 
    {RGBColor[0.5764705882352941, 0.4392156862745098, 0.8470588235294118], 
     DiskBox[{18, 3}, 0.45]}}, {
    {RGBColor[0.5411764705882353, 0.16862745098039217`, 0.8862745098039215], 
     DiskBox[{1, 2}, 0.45]}, 
    {RGBColor[0.29411764705882354`, 0., 0.5098039215686274], 
     DiskBox[{2, 2}, 0.45]}, 
    {RGBColor[0.6, 0.19607843137254902`, 0.8], DiskBox[{3, 2}, 0.45]}, 
    {RGBColor[0.5803921568627451, 0., 0.8274509803921568], 
     DiskBox[{4, 2}, 0.45]}, 
    {RGBColor[0.7294117647058823, 0.3333333333333333, 0.8274509803921568], 
     DiskBox[{5, 2}, 0.45]}, 
    {RGBColor[0.8470588235294118, 0.7490196078431373, 0.8470588235294118], 
     DiskBox[{6, 2}, 0.45]}, 
    {RGBColor[0.8666666666666667, 0.6274509803921569, 0.8666666666666667], 
     DiskBox[{7, 2}, 0.45]}, 
    {RGBColor[0.9333333333333333, 0.5098039215686274, 0.9333333333333333], 
     DiskBox[{8, 2}, 0.45]}, 
    {RGBColor[1., 0., 1.], DiskBox[{9, 2}, 0.45]}, 
    {RGBColor[1., 0., 1.], DiskBox[{10, 2}, 0.45]}, 
    {RGBColor[0.5450980392156862, 0., 0.5450980392156862], 
     DiskBox[{11, 2}, 0.45]}, 
    {RGBColor[0.5019607843137255, 0., 0.5019607843137255], 
     DiskBox[{12, 2}, 0.45]}, 
    {RGBColor[0.8549019607843137, 0.4392156862745098, 0.8392156862745098], 
     DiskBox[{13, 2}, 0.45]}, 
    {RGBColor[0.7803921568627451, 0.08235294117647059, 0.5215686274509804], 
     DiskBox[{14, 2}, 0.45]}, 
    {RGBColor[1., 0.0784313725490196, 0.5764705882352941], 
     DiskBox[{15, 2}, 0.45]}, 
    {RGBColor[1., 0.4117647058823529, 0.7058823529411765], 
     DiskBox[{16, 2}, 0.45]}, 
    {RGBColor[0.8470588235294118, 0.4392156862745098, 0.5764705882352941], 
     DiskBox[{17, 2}, 0.45]}, 
    {RGBColor[1., 0.9411764705882353, 0.9607843137254902], 
     DiskBox[{18, 2}, 0.45]}}, {
    {RGBColor[0.8627450980392157, 0.0784313725490196, 0.23529411764705882`], 
     DiskBox[{1, 1}, 0.45]}, 
    {RGBColor[1., 0.7529411764705882, 0.796078431372549], 
     DiskBox[{2, 1}, 0.45]}, 
    {RGBColor[1., 0.7137254901960784, 0.7568627450980392], 
     DiskBox[{3, 1}, 0.45]}}},
  ContentSelectable->False,
  PlotRangePadding->None]], "Output",
 ImageSize->{304, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[3]=",
 CellID->57741447]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<VisibleSpectrum\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->595442412],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt0L9Lm1EUxvEn59DNDpaKgsVmaKFUQQoKposoxZJBsAjWgIivUo1INNXg
ooMiOklpNwdxEjoUkWyCtVtAyFAQB+PgIgEREYIQxR95feh/UXiGw/dw4cK9
n+4gk/ySCjLjI0H043SQTo6PzES7pqZ55BEAt5yXdeAecvs3XotOa0CPv8Kg
NSLlLVi0dqx5HNvWi5wPoGCjuPAphJZG+OQr70xyT7IB+5nzgfs7toGteRpa
VX3o/iY0xMqO7jPD0LEjnTfM/XasbBl+bDjWvxt+Ljmys4a9Mcd+v+Ew7jhp
M5y9NpSeOe5guIejgud8rjVV4IkH2DLPNm9guyX4wTmseAq/LMCu/8LCHDzc
YX+xG+w3dp6dYPvYGPsC1fy9VwCjiZW5X7FF9ojNs3/YLLvJrrGr7AKbYSfY
YTbBfmLjbAf7nm1lmzlvqQvpSle60pWudKUrXelKV7rSla50pStd6UpXutKV
rnSlK13pSle60pWudKUrXelKV7rSla50pSvd/1EXkUdFhC2D\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->642590958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->349234470],

Cell["Get a color scheme name:", "ExampleText",
 CellID->54181231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<HTML\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->508543196],

Cell[BoxData["\<\"HTML\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442598629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->660924906],

Cell["Get a clickable panel of a scheme:", "ExampleText",
 CellID->7317432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Panel\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315318281],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJx11Xk0VXsbB3BKryENlFBm1SUqDaTxy2uI5PI2kFQ0KKGk3KIrmUtcQ0ho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      "], {{0, 0}, {1, 1}}],
     EventHandlerTag[{"MouseClicked" :> (SelectionMove[
          ButtonNotebook[], After, ButtonCell]; NotebookWrite[
          ButtonNotebook[], 
          ToBoxes[
           
           DataPaclets`ColorDataDump`f$10165[(
              DataPaclets`ColorDataDump`e$10165 - 
              DataPaclets`ColorDataDump`s$10165) First[
               MousePosition["Graphics"]] + 
            DataPaclets`ColorDataDump`s$10165]]]), PassEventsDown -> 
       Automatic, PassEventsUp -> True}]],
    AspectRatio->NCache[
      Rational[1, 8], 0.125],
    ContentSelectable->False,
    ImageSize->250,
    PlotRange->{{0, 1}, {0, 1}}],
   StripOnInput->False,
   CacheGraphics->False],
  FrameMargins->Automatic]], "Output",
 ImageSize->{276, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118812999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"17", ",", "\"\<Panel\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58774019],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[{
     {RGBColor[0.2823529411764706, 0.22745098039215686`, 0.2235294117647059], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{1, 0}, Offset[{-1, -1}, {2, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.2823529411764706, 0.22745098039215686`, 0.2235294117647059]]]),
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[
      0.5647058823529412, 0.23137254901960785`, 0.15294117647058825`], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{2, 0}, Offset[{-1, -1}, {3, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.5647058823529412, 0.23137254901960785`, 
              0.15294117647058825`]]]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]]}, 
     {RGBColor[0.6392156862745098, 0.39215686274509803`, 0.3333333333333333], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{3, 0}, Offset[{-1, -1}, {4, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.6392156862745098, 0.39215686274509803`, 0.3333333333333333]]]),
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[0.8627450980392157, 0.6196078431372549, 0.2627450980392157], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{4, 0}, Offset[{-1, -1}, {5, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.8627450980392157, 0.6196078431372549, 0.2627450980392157]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[0.9647058823529412, 0.788235294117647, 0.5254901960784314], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{5, 0}, Offset[{-1, -1}, {6, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.9647058823529412, 0.788235294117647, 0.5254901960784314]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[0.4588235294117647, 0.592156862745098, 0.4627450980392157], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{6, 0}, Offset[{-1, -1}, {7, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.4588235294117647, 0.592156862745098, 0.4627450980392157]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[
      0.23921568627450981`, 0.45098039215686275`, 0.24705882352941178`], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{7, 0}, Offset[{-1, -1}, {8, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.23921568627450981`, 0.45098039215686275`, 
              0.24705882352941178`]]]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]]}, 
     {RGBColor[0.34509803921568627`, 0.5803921568627451, 0.6901960784313725], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{8, 0}, Offset[{-1, -1}, {9, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.34509803921568627`, 0.5803921568627451, 0.6901960784313725]]]),
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[
      0.1843137254901961, 0.39215686274509803`, 0.49019607843137253`], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{9, 0}, Offset[{-1, -1}, {10, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.1843137254901961, 0.39215686274509803`, 
              0.49019607843137253`]]]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]]}, 
     {RGBColor[0.5686274509803921, 0.7490196078431373, 0.8431372549019608], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{10, 0}, Offset[{-1, -1}, {11, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.5686274509803921, 0.7490196078431373, 0.8431372549019608]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}},
    AspectRatio->NCache[
      Rational[1, 10], 0.1],
    ContentSelectable->False,
    ImageSize->250,
    PlotRangePadding->None],
   StripOnInput->False,
   CacheGraphics->False],
  FrameMargins->Automatic]], "Output",
 ImageSize->{276, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->451263385]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<GeologicAges\>\"", ",", "\"\<Panel\>\""}], "]"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"In[3]:=",
 CellID->31308506],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[
    {EdgeForm[Opacity[0.1]], {
      {RGBColor[0.690196, 0.886275, 0.819608], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{1, 4}, 0.45],
          "\"Phanerozoic\""],
         Annotation[#, "Phanerozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Phanerozoic" -> RGBColor[0.690196, 0.886275, 0.819608], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 1., 0.], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{2, 4}, 0.45],
          "\"Cenozoic\""],
         Annotation[#, "Cenozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cenozoic" -> RGBColor[1., 1., 0.], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 1., 0.301961], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{3, 4}, 0.45],
          "\"Quaternary\""],
         Annotation[#, "Quaternary", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Quaternary" -> RGBColor[1., 1., 0.301961], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 1., 0.701961], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{4, 4}, 0.45],
          "\"Holocene\""],
         Annotation[#, "Holocene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Holocene" -> RGBColor[1., 1., 0.701961], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.921569, 0.384314], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{5, 4}, 0.45],
          "\"Pleistocene\""],
         Annotation[#, "Pleistocene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pleistocene" -> RGBColor[1., 0.921569, 0.384314], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.992157, 0.8, 0.541176], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{6, 4}, 0.45],
          "\"Neogene\""],
         Annotation[#, "Neogene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Neogene" -> RGBColor[0.992157, 0.8, 0.541176], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.996078, 0.921569, 0.67451], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{7, 4}, 0.45],
          "\"Pliocene\""],
         Annotation[#, "Pliocene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pliocene" -> RGBColor[0.996078, 0.921569, 0.67451], 2]]]),
           PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.870588, 0.], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{8, 4}, 0.45],
          "\"Miocene\""],
         Annotation[#, "Miocene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Miocene" -> RGBColor[1., 0.870588, 0.], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.701961, 0.], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{9, 4}, 0.45],
          "\"Paleogene\""],
         Annotation[#, "Paleogene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Paleogene" -> RGBColor[1., 0.701961, 0.], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.917647, 0.776471, 0.447059], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{10, 4}, 0.45],
          "\"Oligocene\""],
         Annotation[#, "Oligocene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Oligocene" -> RGBColor[0.917647, 0.776471, 0.447059], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.917647, 0.678431, 0.262745], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{11, 4}, 0.45],
          "\"Eocene\""],
         Annotation[#, "Eocene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Eocene" -> RGBColor[0.917647, 0.678431, 0.262745], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.921569, 0.576471, 0.00392157], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{12, 4}, 0.45],
          "\"Paleocene\""],
         Annotation[#, "Paleocene", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Paleocene" -> RGBColor[0.921569, 0.576471, 0.00392157], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.498039, 0.678431, 0.317647], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{13, 4}, 0.45],
          "\"Mesozoic\""],
         Annotation[#, "Mesozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Mesozoic" -> RGBColor[0.498039, 0.678431, 0.317647], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.498039, 0.764706, 0.109804], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{14, 4}, 0.45],
          "\"Cretaceous\""],
         Annotation[#, "Cretaceous", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Cretaceous" -> RGBColor[0.498039, 0.764706, 0.109804], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.870588, 0.945098, 0.592157], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{15, 4}, 0.45],
          "\"UpperCretaceous\""],
         Annotation[#, "UpperCretaceous", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "UpperCretaceous" -> RGBColor[0.870588, 0.945098, 0.592157], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701961, 0.87451, 0.498039], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{16, 4}, 0.45],
          "\"LowerCretaceous\""],
         Annotation[#, "LowerCretaceous", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "LowerCretaceous" -> RGBColor[0.701961, 0.87451, 0.498039], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.301961, 0.705882, 0.494118], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{17, 4}, 0.45],
          "\"Jurassic\""],
         Annotation[#, "Jurassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Jurassic" -> RGBColor[0.301961, 0.705882, 0.494118], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.8, 0.921569, 0.772549], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{18, 4}, 0.45],
          "\"UpperJurassic\""],
         Annotation[#, "UpperJurassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "UpperJurassic" -> RGBColor[0.8, 0.921569, 0.772549], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.498039, 0.792157, 0.576471], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{1, 3}, 0.45],
          "\"MiddleJurassic\""],
         Annotation[#, "MiddleJurassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "MiddleJurassic" -> RGBColor[0.498039, 0.792157, 0.576471], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.4, 0.752941, 0.572549], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{2, 3}, 0.45],
          "\"LowerJurassic\""],
         Annotation[#, "LowerJurassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "LowerJurassic" -> RGBColor[0.4, 0.752941, 0.572549], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.403922, 0.764706, 0.717647], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{3, 3}, 0.45],
          "\"Triassic\""],
         Annotation[#, "Triassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Triassic" -> RGBColor[0.403922, 0.764706, 0.717647], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.8, 0.92549, 0.882353], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{4, 3}, 0.45],
          "\"UpperTriassic\""],
         Annotation[#, "UpperTriassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["UpperTriassic" -> RGBColor[0.8, 0.92549, 0.882353], 2]]]),
           PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.6, 0.843137, 0.745098], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{5, 3}, 0.45],
          "\"MiddleTriassic\""],
         Annotation[#, "MiddleTriassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "MiddleTriassic" -> RGBColor[0.6, 0.843137, 0.745098], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.403922, 0.701961, 0.623529], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{6, 3}, 0.45],
          "\"LowerTriassic\""],
         Annotation[#, "LowerTriassic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "LowerTriassic" -> RGBColor[0.403922, 0.701961, 0.623529], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.501961, 0.709804, 0.835294], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{7, 3}, 0.45],
          "\"Paleozoic\""],
         Annotation[#, "Paleozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Paleozoic" -> RGBColor[0.501961, 0.709804, 0.835294], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.403922, 0.776471, 0.866667], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{8, 3}, 0.45],
          "\"Permian\""],
         Annotation[#, "Permian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Permian" -> RGBColor[0.403922, 0.776471, 0.866667], 2]]]),
           PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701961, 0.890196, 0.933333], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{9, 3}, 0.45],
          "\"Lopingian\""],
         Annotation[#, "Lopingian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Lopingian" -> RGBColor[0.701961, 0.890196, 0.933333], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.6, 0.847059, 0.847059], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{10, 3}, 0.45],
          "\"Guadalupian\""],
         Annotation[#, "Guadalupian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Guadalupian" -> RGBColor[0.6, 0.847059, 0.847059], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.501961, 0.807843, 0.788235], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{11, 3}, 0.45],
          "\"Cisuralian\""],
         Annotation[#, "Cisuralian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Cisuralian" -> RGBColor[0.501961, 0.807843, 0.788235], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.6, 0.741176, 0.854902], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{12, 3}, 0.45],
          "\"Carboniferous\""],
         Annotation[#, "Carboniferous", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Carboniferous" -> RGBColor[0.6, 0.741176, 0.854902], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.407843, 0.623529, 0.792157], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{13, 3}, 0.45],
          "\"Pennsylvanian\""],
         Annotation[#, "Pennsylvanian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Pennsylvanian" -> RGBColor[0.407843, 0.623529, 0.792157], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.501961, 0.568627, 0.678431], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{14, 3}, 0.45],
          "\"Mississippian\""],
         Annotation[#, "Mississippian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Mississippian" -> RGBColor[0.501961, 0.568627, 0.678431], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.6, 0.6, 0.788235], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{15, 3}, 0.45],
          "\"Devonian\""],
         Annotation[#, "Devonian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Devonian" -> RGBColor[0.6, 0.6, 0.788235], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.796078, 0.741176, 0.862745], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{16, 3}, 0.45],
          "\"UpperDevonian\""],
         Annotation[#, "UpperDevonian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "UpperDevonian" -> RGBColor[0.796078, 0.741176, 0.862745], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.6, 0.513725, 0.745098], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{17, 3}, 0.45],
          "\"MiddleDevonian\""],
         Annotation[#, "MiddleDevonian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "MiddleDevonian" -> RGBColor[0.6, 0.513725, 0.745098], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.501961, 0.490196, 0.729412], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{18, 3}, 0.45],
          "\"LowerDevonian\""],
         Annotation[#, "LowerDevonian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "LowerDevonian" -> RGBColor[0.501961, 0.490196, 0.729412], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}}, {
      {RGBColor[0.694118, 0.447059, 0.713725], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{1, 2}, 0.45],
          "\"Silurian\""],
         Annotation[#, "Silurian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Silurian" -> RGBColor[0.694118, 0.447059, 0.713725], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.913725, 0.780392, 0.886275], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{2, 2}, 0.45],
          "\"Pridoli\""],
         Annotation[#, "Pridoli", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pridoli" -> RGBColor[0.913725, 0.780392, 0.886275], 2]]]),
           PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.792157, 0.654902, 0.819608], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{3, 2}, 0.45],
          "\"Ludlow\""],
         Annotation[#, "Ludlow", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ludlow" -> RGBColor[0.792157, 0.654902, 0.819608], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.694118, 0.537255, 0.701961], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{4, 2}, 0.45],
          "\"Wenlock\""],
         Annotation[#, "Wenlock", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Wenlock" -> RGBColor[0.694118, 0.537255, 0.701961], 2]]]),
           PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.596078, 0.345098, 0.658824], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{5, 2}, 0.45],
          "\"Llandovery\""],
         Annotation[#, "Llandovery", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Llandovery" -> RGBColor[0.596078, 0.345098, 0.658824], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.976471, 0.505882, 0.65098], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{6, 2}, 0.45],
          "\"Ordovician\""],
         Annotation[#, "Ordovician", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Ordovician" -> RGBColor[0.976471, 0.505882, 0.65098], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.984314, 0.705882, 0.741176], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{7, 2}, 0.45],
          "\"UpperOrdovician\""],
         Annotation[#, "UpperOrdovician", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "UpperOrdovician" -> RGBColor[0.984314, 0.705882, 0.741176], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.980392, 0.603922, 0.694118], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{8, 2}, 0.45],
          "\"MiddleOrdovician\""],
         Annotation[#, "MiddleOrdovician", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "MiddleOrdovician" -> RGBColor[0.980392, 0.603922, 0.694118], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.901961, 0.490196, 0.643137], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{9, 2}, 0.45],
          "\"LowerOrdovician\""],
         Annotation[#, "LowerOrdovician", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "LowerOrdovician" -> RGBColor[0.901961, 0.490196, 0.643137], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.984314, 0.501961, 0.372549], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{10, 2}, 0.45],
          "\"Cambrian\""],
         Annotation[#, "Cambrian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Cambrian" -> RGBColor[0.984314, 0.501961, 0.372549], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.992157, 0.803922, 0.721569], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{11, 2}, 0.45],
          "\"UpperCambrian\""],
         Annotation[#, "UpperCambrian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "UpperCambrian" -> RGBColor[0.992157, 0.803922, 0.721569], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.909804, 0.682353, 0.592157], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{12, 2}, 0.45],
          "\"MiddleCambrian\""],
         Annotation[#, "MiddleCambrian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "MiddleCambrian" -> RGBColor[0.909804, 0.682353, 0.592157], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.905882, 0.486275, 0.447059], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{13, 2}, 0.45],
          "\"LowerCambrian\""],
         Annotation[#, "LowerCambrian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "LowerCambrian" -> RGBColor[0.905882, 0.486275, 0.447059], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.698039, 0.52549, 0.32549], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{14, 2}, 0.45],
          "\"Precambrian\""],
         Annotation[#, "Precambrian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Precambrian" -> RGBColor[0.698039, 0.52549, 0.32549], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.8, 0.847059, 0.568627], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{15, 2}, 0.45],
          "\"Proterozoic\""],
         Annotation[#, "Proterozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Proterozoic" -> RGBColor[0.8, 0.847059, 0.568627], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.792157, 0.647059, 0.584314], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{16, 2}, 0.45],
          "\"Neoproterozoic\""],
         Annotation[#, "Neoproterozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Neoproterozoic" -> RGBColor[0.792157, 0.647059, 0.584314], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.917647, 0.847059, 0.737255], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{17, 2}, 0.45],
          "\"Ediacaran\""],
         Annotation[#, "Ediacaran", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Ediacaran" -> RGBColor[0.917647, 0.847059, 0.737255], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.862745, 0.670588, 0.666667], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{18, 2}, 0.45],
          "\"Cryogenian\""],
         Annotation[#, "Cryogenian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Cryogenian" -> RGBColor[0.862745, 0.670588, 0.666667], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.796078, 0.643137, 0.423529], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{1, 1}, 0.45],
          "\"Tonian\""],
         Annotation[#, "Tonian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Tonian" -> RGBColor[0.796078, 0.643137, 0.423529], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.866667, 0.760784, 0.533333], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{2, 1}, 0.45],
          "\"Mesoproterozoic\""],
         Annotation[#, "Mesoproterozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Mesoproterozoic" -> RGBColor[0.866667, 0.760784, 0.533333], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.866667, 0.760784, 0.533333], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{3, 1}, 0.45],
          "\"Stenian\""],
         Annotation[#, "Stenian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Stenian" -> RGBColor[0.866667, 0.760784, 0.533333], 2]]]),
           PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.866667, 0.760784, 0.533333], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{4, 1}, 0.45],
          "\"Ectasian\""],
         Annotation[#, "Ectasian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Ectasian" -> RGBColor[0.866667, 0.760784, 0.533333], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.866667, 0.760784, 0.533333], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{5, 1}, 0.45],
          "\"Calymmian\""],
         Annotation[#, "Calymmian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Calymmian" -> RGBColor[0.866667, 0.760784, 0.533333], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701961, 0.698039, 0.368627], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{6, 1}, 0.45],
          "\"Paleoproterozoic\""],
         Annotation[#, "Paleoproterozoic", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Paleoproterozoic" -> RGBColor[0.701961, 0.698039, 0.368627], 
               2]]]), PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701961, 0.698039, 0.368627], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{7, 1}, 0.45],
          "\"Statherian\""],
         Annotation[#, "Statherian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Statherian" -> RGBColor[0.701961, 0.698039, 0.368627], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701961, 0.698039, 0.368627], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{8, 1}, 0.45],
          "\"Orosirian\""],
         Annotation[#, "Orosirian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Orosirian" -> RGBColor[0.701961, 0.698039, 0.368627], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701961, 0.698039, 0.368627], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{9, 1}, 0.45],
          "\"Rhyacian\""],
         Annotation[#, "Rhyacian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Rhyacian" -> RGBColor[0.701961, 0.698039, 0.368627], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701961, 0.698039, 0.368627], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{10, 1}, 0.45],
          "\"Siderian\""],
         Annotation[#, "Siderian", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Siderian" -> RGBColor[0.701961, 0.698039, 0.368627], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.6, 0.678431, 0.67451], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{11, 1}, 0.45],
          "\"Archean\""],
         Annotation[#, "Archean", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Archean" -> RGBColor[0.6, 0.678431, 0.67451], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.796078, 0.803922, 0.784314], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{12, 1}, 0.45],
          "\"Neoarchean\""],
         Annotation[#, "Neoarchean", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Neoarchean" -> RGBColor[0.796078, 0.803922, 0.784314], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.698039, 0.709804, 0.686275], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{13, 1}, 0.45],
          "\"Mesoarchean\""],
         Annotation[#, "Mesoarchean", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Mesoarchean" -> RGBColor[0.698039, 0.709804, 0.686275], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.6, 0.592157, 0.568627], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{14, 1}, 0.45],
          "\"Paleoarchean\""],
         Annotation[#, "Paleoarchean", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Paleoarchean" -> RGBColor[0.6, 0.592157, 0.568627], 2]]]),
           PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.501961, 0.564706, 0.564706], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{15, 1}, 0.45],
          "\"Eoarchean\""],
         Annotation[#, "Eoarchean", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part[
              "Eoarchean" -> RGBColor[0.501961, 0.564706, 0.564706], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.5, 0.5, 0.56], 
       TagBox[
        TagBox[
         TooltipBox[DiskBox[{16, 1}, 0.45],
          "\"Hadean\""],
         Annotation[#, "Hadean", "Tooltip"]& ],
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Hadean" -> RGBColor[0.5, 0.5, 0.56], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}},
    ContentSelectable->False,
    PlotRangePadding->None],
   StripOnInput->False,
   CacheGraphics->False],
  FrameMargins->Automatic]], "Output",
 ImageSize->{326, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[3]=",
 CellID->21923957]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<BlackBodySpectrum\>\"", ",", "\"\<Panel\>\""}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->793325902],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJxl1Qk4lHkcB/CxxbbOTlmPVbmfKLSOivpR2+FKCclRotmQknQgLVu60GxF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      "], {{0, 0}, {1, 1}}],
     EventHandlerTag[{"MouseClicked" :> (SelectionMove[
          ButtonNotebook[], After, ButtonCell]; NotebookWrite[
          ButtonNotebook[], 
          ToBoxes[
           
           DataPaclets`ColorDataDump`f$12739[(
              DataPaclets`ColorDataDump`e$12739 - 
              DataPaclets`ColorDataDump`s$12739) First[
               MousePosition["Graphics"]] + 
            DataPaclets`ColorDataDump`s$12739]]]), PassEventsDown -> 
       Automatic, PassEventsUp -> True}]],
    AspectRatio->NCache[
      Rational[1, 8], 0.125],
    ContentSelectable->False,
    ImageSize->250,
    PlotRange->{{0, 1}, {0, 1}}],
   StripOnInput->False,
   CacheGraphics->False],
  FrameMargins->Automatic]], "Output",
 ImageSize->{276, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->158009445]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232884744],

Cell["Get a number of parameters required in a scheme:", "ExampleText",
 CellID->112218229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<AuroraColors\>\"", ",", "\"\<ParameterCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114239975],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488080023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63479266],

Cell["Get a range of possible values for the first parameter:", "ExampleText",
 CellID->72926451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<GrayYellowTones\>\"", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86190099],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7862615]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"12", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176655651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "10", ",", "1"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->441684437]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ColorData", "[", 
   RowBox[{"\"\<HTML\>\"", ",", "\"\<Range\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->509093247],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"\<\"AliceBlue\"\>", ",", "\<\"AntiqueWhite\"\>", ",", 
     RowBox[{"\[LeftSkeleton]", "143", "\[RightSkeleton]"}], 
     ",", "\<\"Yellow\"\>", ",", "\<\"YellowGreen\"\>"}], "}"}], "}"}],
  Short]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//Short=",
 CellID->22531795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<VisibleSpectrum\>\"", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->223078705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"400", ",", "700"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->95884508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202650418],

Cell[TextData[{
 "The range value can be directly used in controls, such as ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->784175784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "w", "]"}], ",", 
     RowBox[{"ColorData", "[", 
      RowBox[{"\"\<GrayYellowTones\>\"", ",", "\"\<Range\>\""}], "]"}]}], 
    "]"}], ",", 
   RowBox[{"Dynamic", "[", "w", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73559170],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`w], {0, 1}], ",", 
   DynamicBox[ToBoxes[$CellContext`w, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129321629]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"ColorData", "[", 
      RowBox[{"12", ",", "\"\<Range\>\""}], "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->209532084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x], {1, 10, 1}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178027680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"ColorData", "[", 
      RowBox[{"\"\<HTML\>\"", ",", "\"\<Range\>\""}], "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->38734532],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[
    Dynamic[$CellContext`y], {{
     "AliceBlue", "AntiqueWhite", "Aqua", "Aquamarine", "Azure", "Beige", 
      "Bisque", "Black", "BlanchedAlmond", "Blue", "BlueViolet", "Brown", 
      "BurlyWood", "CadetBlue", "Chartreuse", "Chocolate", "Coral", 
      "CornflowerBlue", "Cornsilk", "Crimson", "Cyan", "DarkBlue", "DarkCyan",
       "DarkGoldenRod", "DarkGray", "DarkGreen", "DarkGrey", "DarkKhaki", 
      "DarkMagenta", "DarkOliveGreen", "DarkOrange", "DarkOrchid", "DarkRed", 
      "DarkSalmon", "DarkSeaGreen", "DarkSlateBlue", "DarkSlateGray", 
      "DarkSlateGrey", "DarkTurquoise", "DarkViolet", "DeepPink", 
      "DeepSkyBlue", "DimGray", "DimGrey", "DodgerBlue", "FireBrick", 
      "FloralWhite", "ForestGreen", "Fuchsia", "Gainsboro", "GhostWhite", 
      "Gold", "GoldenRod", "Gray", "Green", "GreenYellow", "Grey", "HoneyDew",
       "HotPink", "IndianRed", "Indigo", "Ivory", "Khaki", "Lavender", 
      "LavenderBlush", "LawnGreen", "LemonChiffon", "LightBlue", "LightCoral",
       "LightCyan", "LightGoldenRodYellow", "LightGray", "LightGreen", 
      "LightGrey", "LightPink", "LightSalmon", "LightSeaGreen", 
      "LightSkyBlue", "LightSlateGray", "LightSlateGrey", "LightSteelBlue", 
      "LightYellow", "Lime", "LimeGreen", "Linen", "Magenta", "Maroon", 
      "MediumAquaMarine", "MediumBlue", "MediumOrchid", "MediumPurple", 
      "MediumSeaGreen", "MediumSlateBlue", "MediumSpringGreen", 
      "MediumTurquoise", "MediumVioletRed", "MidnightBlue", "MintCream", 
      "MistyRose", "Moccasin", "NavajoWhite", "Navy", "OldLace", "Olive", 
      "OliveDrab", "Orange", "OrangeRed", "Orchid", "PaleGoldenRod", 
      "PaleGreen", "PaleTurquoise", "PaleVioletRed", "PapayaWhip", 
      "PeachPuff", "Peru", "Pink", "Plum", "PowderBlue", "Purple", "Red", 
      "RosyBrown", "RoyalBlue", "SaddleBrown", "Salmon", "SandyBrown", 
      "SeaGreen", "SeaShell", "Sienna", "Silver", "SkyBlue", "SlateBlue", 
      "SlateGray", "SlateGrey", "Snow", "SpringGreen", "SteelBlue", "Tan", 
      "Teal", "Thistle", "Tomato", "Turquoise", "Violet", "Wheat", "White", 
      "WhiteSmoke", "Yellow", "YellowGreen"}}], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{63., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{293, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->514871086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "z", "]"}], ",", 
     RowBox[{"ColorData", "[", 
      RowBox[{"\"\<VisibleSpectrum\>\"", ",", "\"\<Range\>\""}], "]"}]}], 
    "]"}], ",", 
   RowBox[{"Dynamic", "[", "z", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->573678324],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`z], {400, 700}], ",", 
   DynamicBox[ToBoxes[$CellContext`z, StandardForm],
    ImageSizeCache->{28., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{258, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->246602578]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Property Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->281672659],

Cell[TextData[{
 "Property values can be any valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression: "
}], "ExampleText",
 CellID->144307891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<HypsometricTints\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->69786391],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt0etLk2EYBvDX66b/oW/5qZOdD3Y+WWlHIiIkImQMc0PGbCqjo4hUYlpj
NVsm0pkiFh0YZagd6aRZ2lPhpmP6yipm29z2fulLvdlfEVwfLrif+77hueG3
3VJlK3VYquxWS26Ry1Jhs1srcwudLrMlOZqm/TIzZbJm1r/NaiIyded+TNtl
k+m7yzGj2CEz91Qgb69L8vZVY1aJW2ZbDmGO9YjMLT2GeWW1Mt9ehwXlJ2Sh
ox6LnKdk8YEm5Fd6kF/tlSVuH5YePC/LDrdg+dFWWVHThpW1l2VV3VWsPn5D
1py8ibX1t2VdQwAFjXel4PR9rPcEZYP3ITaea5fC5g4U+btkU8szbG59gS1t
r2TrpTfYdqVbdlx/j+JbH6Qk0I+ye0qcwS9wtw9ITVcYvu4RCYTjeKp3yFh2
CIbxTozUHaR1vyRUAxKqUZKqCSl1xoxHxpUXaXVW0sqHjGqWrPIjqy6IoS4i
03dNEj0PMNYblPjHR/jR/1i+fepE7PMTGf36HPrASxkOvUZ08C0ikR6J6r3Q
v/dJ7KdCPBWSVCZq/h8TIzsKIzMiRtp8j0fESA5OMhIhGMmwedvQv97fWXpY
jIyOiX0jpmkUoQhFKEIRilCEIhShCEUoQhGKUIQiFKEIRShCEYpQhCIUoQhF
KEIRilCEIhShCEUoQhGKUIQiFKEIRShCEYr87yJazh+iFSei\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->766634923]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"ColorData", "[", 
    RowBox[{"37", ",", "\"\<ColorRules\>\""}], "]"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272171805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.8549019607843137`", ",", "0.39215686274509803`", ",", 
      "0.14901960784313725`"}], "]"}]}], ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"1.`", ",", "0.5568627450980392`", ",", "0.3215686274509804`"}], 
     "]"}]}], ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{
     "0.7176470588235294`", ",", "0.27450980392156865`", ",", 
      "0.0392156862745098`"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{554, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->636696730]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<SouthwestColors\>\"", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->186946926],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.817882`", ",", "0.7260905`", ",", "0.426991`"}], "]"}]], "Output",\

 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->828041183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39483278],

Cell[TextData[{
 "Each scheme returns a ",
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->610447763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<GrayYellowTones\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124719916],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVUXk81YketY2SF+GiXnZpESmUaugkjfYSMh7KXjRCKI9kulkmy5AoWULT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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5951131]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "12", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66291465],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "10", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[{
      {RGBColor[0.6235294117647059, 0.1450980392156863, 0.12549019607843137`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{1, 0}, Offset[{-1, -1}, {2, 1}]]}, 
      {RGBColor[0.6588235294117647, 0.3058823529411765, 0.17254901960784313`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{2, 0}, Offset[{-1, -1}, {3, 1}]]}, 
      {RGBColor[
       0.24313725490196078`, 0.11764705882352941`, 0.058823529411764705`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{3, 0}, Offset[{-1, -1}, {4, 1}]]}, 
      {RGBColor[0.9450980392156862, 0.7529411764705882, 0.6352941176470588], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{4, 0}, Offset[{-1, -1}, {5, 1}]]}, 
      {RGBColor[0.8392156862745098, 0.4745098039215686, 0.21176470588235294`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{5, 0}, Offset[{-1, -1}, {6, 1}]]}, 
      {RGBColor[0.8274509803921568, 0.7254901960784313, 0.43529411764705883`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{6, 0}, Offset[{-1, -1}, {7, 1}]]}, 
      {RGBColor[0.44313725490196076`, 0.4980392156862745, 0.5490196078431373],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{7, 0}, Offset[{-1, -1}, {8, 1}]]}, 
      {RGBColor[
       0.24705882352941178`, 0.30980392156862746`, 0.37254901960784315`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{8, 0}, Offset[{-1, -1}, {9, 1}]]}, 
      {RGBColor[
       0.16862745098039217`, 0.23921568627450981`, 0.3803921568627451], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{9, 0}, Offset[{-1, -1}, {10, 1}]]}, 
      {RGBColor[
       0.2980392156862745, 0.17647058823529413`, 0.19607843137254902`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{10, 0}, Offset[{-1, -1}, {11, 1}]]}},
     AspectRatio->NCache[
       Rational[1, 10], 0.1],
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{294, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97451826]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->240614921],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", "\<\"AliceBlue\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "146", "\[RightSkeleton]"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[
     {PointSize[
       Rational[1, 20]], {
       {RGBColor[1., 1., 1.], PointBox[{1, 4}]}, 
       {RGBColor[
        0.6980392156862745, 0.13333333333333333`, 0.13333333333333333`], 
        PointBox[{1, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9411764705882353, 0.9019607843137255], 
        PointBox[{1, 2}]}, 
       {RGBColor[1., 0.9803921568627451, 0.803921568627451], 
        PointBox[{1, 1}]}, 
       {RGBColor[0.596078431372549, 0.984313725490196, 0.596078431372549], 
        PointBox[{1, 0}]}}, {
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.9607843137254902], 
        PointBox[{2, 4}]}, 
       {RGBColor[1., 0., 0.], PointBox[{2, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7686274509803922], 
        PointBox[{2, 2}]}, 
       {RGBColor[0.9411764705882353, 0.9019607843137255, 0.5490196078431373], 
        PointBox[{2, 1}]}, 
       {RGBColor[0.5647058823529412, 0.9333333333333333, 0.5647058823529412], 
        PointBox[{2, 0}]}}, {
       {RGBColor[0.8627450980392157, 0.8627450980392157, 0.8627450980392157], 
        PointBox[{3, 4}]}, 
       {RGBColor[0.5450980392156862, 0., 0.], PointBox[{3, 3}]}, 
       {RGBColor[1., 0.5490196078431373, 0.], PointBox[{3, 2}]}, 
       {RGBColor[0.9333333333333333, 0.9098039215686274, 0.6666666666666666], 
        PointBox[{3, 1}]}, 
       {RGBColor[
        0.13333333333333333`, 0.5450980392156862, 0.13333333333333333`], 
        PointBox[{3, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{4, 4}]}, 
       {RGBColor[0.5019607843137255, 0., 0.], PointBox[{4, 3}]}, 
       {RGBColor[0.8705882352941177, 0.7215686274509804, 0.5294117647058824], 
        PointBox[{4, 2}]}, 
       {RGBColor[0.7411764705882353, 0.7176470588235294, 0.4196078431372549], 
        PointBox[{4, 1}]}, 
       {RGBColor[
        0.19607843137254902`, 0.803921568627451, 0.19607843137254902`], 
        PointBox[{4, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{5, 4}]}, 
       {RGBColor[1., 0.8941176470588236, 0.8823529411764706], 
        PointBox[{5, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9215686274509803, 0.8431372549019608], 
        PointBox[{5, 2}]}, 
       {RGBColor[1., 1., 0.9411764705882353], PointBox[{5, 1}]}, 
       {RGBColor[0., 1., 0.], PointBox[{5, 0}]}}, {
       {RGBColor[0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
        PointBox[{6, 4}]}, 
       {RGBColor[0.9803921568627451, 0.5019607843137255, 0.4470588235294118], 
        PointBox[{6, 3}]}, 
       {RGBColor[0.8235294117647058, 0.7058823529411765, 0.5490196078431373], 
        PointBox[{6, 2}]}, 
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.8627450980392157], 
        PointBox[{6, 1}]}, 
       {RGBColor[0., 0.5019607843137255, 0.], PointBox[{6, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{7, 4}]}, 
       {RGBColor[1., 0.38823529411764707`, 0.2784313725490196], 
        PointBox[{7, 3}]}, 
       {RGBColor[1., 0.8705882352941177, 0.6784313725490196], 
        PointBox[{7, 2}]}, 
       {RGBColor[1., 1., 0.8784313725490196], PointBox[{7, 1}]}, 
       {RGBColor[0., 0.39215686274509803`, 0.], PointBox[{7, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{8, 4}]}, 
       {RGBColor[
        0.9137254901960784, 0.5882352941176471, 0.47843137254901963`], 
        PointBox[{8, 3}]}, 
       {RGBColor[1., 0.9215686274509803, 0.803921568627451], 
        PointBox[{8, 2}]}, 
       {RGBColor[0.9803921568627451, 0.9803921568627451, 0.8235294117647058], 
        PointBox[{8, 1}]}, 
       {RGBColor[0.1803921568627451, 0.5450980392156862, 0.3411764705882353], 
        PointBox[{8, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{9, 4}]}, 
       {RGBColor[1., 0.4980392156862745, 0.3137254901960784], 
        PointBox[{9, 3}]}, 
       {RGBColor[1., 0.9372549019607843, 0.8352941176470589], 
        PointBox[{9, 2}]}, 
       {RGBColor[1., 1., 0.], PointBox[{9, 1}]}, 
       {RGBColor[
        0.23529411764705882`, 0.7019607843137254, 0.44313725490196076`], 
        PointBox[{9, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{10, 4}]}, 
       {RGBColor[1., 0.27058823529411763`, 0.], PointBox[{10, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7098039215686275], 
        PointBox[{10, 2}]}, 
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.], 
        PointBox[{10, 1}]}, 
       {RGBColor[0., 1., 0.4980392156862745], PointBox[{10, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{11, 4}]}, 
       {RGBColor[1., 0.6274509803921569, 0.47843137254901963`], 
        PointBox[{11, 3}]}, 
       {RGBColor[1., 0.6470588235294118, 0.], PointBox[{11, 2}]}, 
       {RGBColor[
        0.4196078431372549, 0.5568627450980392, 0.13725490196078433`], 
        PointBox[{11, 1}]}, 
       {RGBColor[0.9607843137254902, 1., 0.9803921568627451], 
        PointBox[{11, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{12, 4}]}, 
       {RGBColor[
        0.6274509803921569, 0.3215686274509804, 0.17647058823529413`], 
        PointBox[{12, 3}]}, 
       {RGBColor[0.9607843137254902, 0.8705882352941177, 0.7019607843137254], 
        PointBox[{12, 2}]}, 
       {RGBColor[0.6039215686274509, 0.803921568627451, 0.19607843137254902`],
         PointBox[{12, 1}]}, 
       {RGBColor[0., 0.9803921568627451, 0.6039215686274509], 
        PointBox[{12, 0}]}}, {
       {RGBColor[0., 0., 0.], PointBox[{13, 4}]}, 
       {RGBColor[1., 0.9607843137254902, 0.9333333333333333], 
        PointBox[{13, 3}]}, 
       {RGBColor[0.9921568627450981, 0.9607843137254902, 0.9019607843137255], 
        PointBox[{13, 2}]}, 
       {RGBColor[0.3333333333333333, 0.4196078431372549, 0.1843137254901961], 
        PointBox[{13, 1}]}, 
       {RGBColor[0.4, 0.803921568627451, 0.6666666666666666], 
        PointBox[{13, 0}]}}, {
       {RGBColor[1., 0.9803921568627451, 0.9803921568627451], 
        PointBox[{14, 4}]}, 
       {RGBColor[
        0.8235294117647058, 0.4117647058823529, 0.11764705882352941`], 
        PointBox[{14, 3}]}, 
       {RGBColor[1., 0.9803921568627451, 0.9411764705882353], 
        PointBox[{14, 2}]}, 
       {RGBColor[0.6784313725490196, 1., 0.1843137254901961], 
        PointBox[{14, 1}]}, 
       {RGBColor[0.4980392156862745, 1., 0.8313725490196079], 
        PointBox[{14, 0}]}}, {
       {RGBColor[0.7372549019607844, 0.5607843137254902, 0.5607843137254902], 
        PointBox[{15, 4}]}, 
       {RGBColor[
        0.5450980392156862, 0.27058823529411763`, 0.07450980392156863], 
        PointBox[{15, 3}]}, 
       {RGBColor[
        0.7215686274509804, 0.5254901960784314, 0.043137254901960784`], 
        PointBox[{15, 2}]}, 
       {RGBColor[0.4980392156862745, 1., 0.], PointBox[{15, 1}]}, 
       {RGBColor[
        0.25098039215686274`, 0.8784313725490196, 0.8156862745098039], 
        PointBox[{15, 0}]}}, {
       {RGBColor[0.9411764705882353, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{16, 4}]}, 
       {RGBColor[0.9568627450980393, 0.6431372549019608, 0.3764705882352941], 
        PointBox[{16, 3}]}, 
       {RGBColor[
        0.8549019607843137, 0.6470588235294118, 0.12549019607843137`], 
        PointBox[{16, 2}]}, 
       {RGBColor[0.48627450980392156`, 0.9882352941176471, 0.], 
        PointBox[{16, 1}]}, 
       {RGBColor[
        0.12549019607843137`, 0.6980392156862745, 0.6666666666666666], 
        PointBox[{16, 0}]}}, {
       {RGBColor[0.803921568627451, 0.3607843137254902, 0.3607843137254902], 
        PointBox[{17, 4}]}, 
       {RGBColor[1., 0.8549019607843137, 0.7254901960784313], 
        PointBox[{17, 3}]}, 
       {RGBColor[1., 0.9725490196078431, 0.8627450980392157], 
        PointBox[{17, 2}]}, 
       {RGBColor[0.9411764705882353, 1., 0.9411764705882353], 
        PointBox[{17, 1}]}, 
       {RGBColor[0.2823529411764706, 0.8196078431372549, 0.8], 
        PointBox[{17, 0}]}}, {
       {RGBColor[
        0.6470588235294118, 0.16470588235294117`, 0.16470588235294117`], 
        PointBox[{18, 4}]}, 
       {RGBColor[0.803921568627451, 0.5215686274509804, 0.24705882352941178`],
         PointBox[{18, 3}]}, 
       {RGBColor[1., 0.8431372549019608, 0.], PointBox[{18, 2}]}, 
       {RGBColor[0.5607843137254902, 0.7372549019607844, 0.5607843137254902], 
        PointBox[{18, 1}]}, 
       {RGBColor[0.9411764705882353, 1., 1.], PointBox[{18, 0}]}}},
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{367, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->287667037]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->765786609],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"380", ",", "750"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzN1f1P00ccB/AvT0UYD6KIVRgbINhIdDKUKnYcCshwIlaEOQQljGInD4WU
AAJDhIGMbUARyoMSM7PBkIRnLDIoz+IQR8tqgVKwPJVCW6hmQ0DE4dM16fkH
+Ekuubx+uNzl3vc5iyDaKYoGhmFq64OyPl7NvdzvlEc2sQD2tuqrSF96MTjA
4HgKJ96HDd3RzOyysxUPhBDKEo7EdUBvzXjeYNcwCHi79LN7uruhn/5PILN0
HwEZlbl1G/17oYcEHix3shWBvsMc7m1mP/SW8NIjpE2TIGMOF3eLOgB9S8Jm
4cHlaeDbYzq2IuVB/5dqSGhgSYCfXnpW8KFB6C/ddCOtrKXAh6xw+jtzWOmW
Wo2MXDnwYvotEAUj0N+UAjBXTnif1xciPnrOhZXujPqOTqJpJR31GtdPPWxT
0fULlw2SJjAB4smVL2qLkoYQv9Zxqa1C8gjxJrKRq6MtF3F5OzmbMXIf8d42
td0B7WzEPczF8ceuNgAjy9GfIo0qwDvPepbHoBX/8db/hD5/P6aBUJQBbg9P
U409u6C/W5Finp6/+LQPPApLqrTmzENnfJ9DaXf9B1A/sV0K3yCHrpAGJGtv
HAKr3MHDd5yl0K8zG6l2e4RAsrOG7k2bhb5ia/J87ckYqIrGogszZ6CXie4e
FQtE4HK7V/To79PQT1ZIDB+SJsAJg5vRlu2T0Om/GBJHGJMgx23A1HX7BPR8
msO5WfEU4CZqdVLoIuhsckDas0NigKdG8QyKRqHb7LWvm701A8w8t9skLyhz
JiSyF/s2zYKh4JckfTwfeiHwcKxOmQM/JE55Fzsr823feaPnqlAKMoZI2/Kd
+qCn5TWfdtGVA5BDCPmWp3xvfRTh+BpxHjBeey10c+JqRBNlQeWeMazJYmxA
PQ91H702h686UH+y+GvxNQXqb0rxwXrwUbOz5eR7QJ3ipl3zWLl/jdfOB1q9
mQZBrUq/vs9HE7SIgPZnnC2bbyq91C2Xb/rjFBAUFBz/GKd03Qss5l+RM6BN
uypAsFeZ7/AMoW/smTlQGnsvouCsMt/px3S6YspkILxY40wuRQa91g43tNwl
B9OaQTvU9yhzz8NryBIn5gGV1qaIWpxVOa8CiIbNW8bZEsRPVoamb8XPIN6f
0ujlGTWNOPhaa1tq7yTiFgD/lPRgHHH/6FpePHiMeOzFfd0JErSfEXipPfgS
tG/pRfqdj+H2IZ5De+XNiGPvrQ/HQ3Q5kio++k7cAy4YsvxQ31m9tp89No+4
ngbTvzsI9QZNK85iswzxMFy1C2GrFHHjDV+wvolSzQ2G/UzPypYOqOYDw3bR
3A/sPiBG+8VFbDyiZArxjxZau/brq+YGwyLsmzx1clVzg2Hc2Hq+0ESE+JW4
gNZA4ijidi9WlgqWVPO0/s9fKfy8/67q/4hhv+EcwnAJfMQb+YMF34XyEDer
k3kE0gcQp2WrrfomcBC3FqcpbKgPEdfpCD314EYv4vIScj2N24P43CWiiTGu
G/H/ARV7Ius=
      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{297, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->580618748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61956046],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " returns RGB colors when applied to values within a specific range:"
}], "ExampleText",
 CellID->329853951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "\"\<GrayYellowTones\>\"", "]"}], "[", ".5", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248007193],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.6918275`", ",", "0.7071305`", ",", "0.7518994999999999`"}], 
  "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422789867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "12", "]"}], "[", "7", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->128973281],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
  "0.44313725490196076`", ",", "0.4980392156862745`", ",", 
   "0.5490196078431373`"}], "]"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278209434]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}], "[", "\"\<WhiteSmoke\>\"", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->691194735],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
  "0.9607843137254902`", ",", "0.9607843137254902`", ",", 
   "0.9607843137254902`"}], "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18504093]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}], "[", "550", 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->498012876],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0", ",", "1", ",", "0"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->407342705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324439373],

Cell["\<\
Gradients and physical schemes are defined on continuous intervals:\
\>", "ExampleText",
 CellID->105785776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<GrayYellowTones\>\"", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153854290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156469697]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<VisibleSpectrum\>\"", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25937296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"380", ",", "750"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135819400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->525522384],

Cell["Indexed schemes are defined on discrete values:", "ExampleText",
 CellID->247486878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"12", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248382279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "10", ",", "1"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->432965128]
}, Open  ]],

Cell[TextData[{
 "An indexed range can turn into a list by applying ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->267992659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Range", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151981515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132175380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->562561292],

Cell["Named schemes are defined on specific sets of values:", "ExampleText",
 CellID->217039168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ColorData", "[", 
   RowBox[{"\"\<HTML\>\"", ",", "\"\<Range\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19996527],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"\<\"AliceBlue\"\>", ",", "\<\"AntiqueWhite\"\>", ",", 
     RowBox[{"\[LeftSkeleton]", "143", "\[RightSkeleton]"}], 
     ",", "\<\"Yellow\"\>", ",", "\<\"YellowGreen\"\>"}], "}"}], "}"}],
  Short]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->358071208]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->455735975],

Cell[TextData[{
 "A property that is not applicable returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotApplicable\>\"", "]"}]], 
  "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->675423344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<SouthwestColors\>\"", ",", "\"\<ColorList\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258990663],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449358643]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<SouthwestColors\>\"", ",", "\"\<ColorRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69798453],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234202397]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["Some schemes have specialized images and panels:", "ExampleText",
 CellID->296939203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<Atoms\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99712496],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 222},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"Out[1]=",
 CellID->354744293]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<Atoms\>\"", ",", "\"\<Panel\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50212881],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[
    {EdgeForm[Opacity[0.1]], {
      {RGBColor[0.65, 0.7, 0.7], 
       TagBox[{RectangleBox[{0.55, 9.55}, {1.45, 10.45}], InsetBox[
          StyleBox["\<\"H\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {1, 10},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["H" -> RGBColor[0.65, 0.7, 0.7], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> 
          True}]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, 
      {RGBColor[0.836713, 1., 1.], 
       TagBox[{RectangleBox[{17.55, 9.55}, {18.45, 10.45}], InsetBox[
          StyleBox["\<\"He\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 10},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["He" -> RGBColor[0.836713, 1., 1.], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.799435, 0.543572, 0.997559], 
       TagBox[{RectangleBox[{0.55, 8.55}, {1.45, 9.45}], InsetBox[
          StyleBox["\<\"Li\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {1, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Li" -> RGBColor[0.799435, 0.543572, 0.997559], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.770565, 0.964309, 0.0442359], 
       TagBox[{RectangleBox[{1.55, 8.55}, {2.45, 9.45}], InsetBox[
          StyleBox["\<\"Be\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {2, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Be" -> RGBColor[0.770565, 0.964309, 0.0442359], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
      {RGBColor[1., 0.709804, 0.709804], 
       TagBox[{RectangleBox[{12.55, 8.55}, {13.45, 9.45}], InsetBox[
          StyleBox["\<\"B\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["B" -> RGBColor[1., 0.709804, 0.709804], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.4, 0.4, 0.4], 
       TagBox[{RectangleBox[{13.55, 8.55}, {14.45, 9.45}], InsetBox[
          StyleBox["\<\"C\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["C" -> RGBColor[0.4, 0.4, 0.4], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.291989, 0.437977, 0.888609], 
       TagBox[{RectangleBox[{14.55, 8.55}, {15.45, 9.45}], InsetBox[
          StyleBox["\<\"N\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["N" -> RGBColor[0.291989, 0.437977, 0.888609], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.800498, 0.201504, 0.192061], 
       TagBox[{RectangleBox[{15.55, 8.55}, {16.45, 9.45}], InsetBox[
          StyleBox["\<\"O\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["O" -> RGBColor[0.800498, 0.201504, 0.192061], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.578462, 0.85539, 0.408855], 
       TagBox[{RectangleBox[{16.55, 8.55}, {17.45, 9.45}], InsetBox[
          StyleBox["\<\"F\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {17, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["F" -> RGBColor[0.578462, 0.85539, 0.408855], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.677263, 0.928423, 0.955287], 
       TagBox[{RectangleBox[{17.55, 8.55}, {18.45, 9.45}], InsetBox[
          StyleBox["\<\"Ne\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ne" -> RGBColor[0.677263, 0.928423, 0.955287], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.658708, 0.492173, 0.842842], 
       TagBox[{RectangleBox[{0.55, 7.55}, {1.45, 8.45}], InsetBox[
          StyleBox["\<\"Na\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {1, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Na" -> RGBColor[0.658708, 0.492173, 0.842842], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.628274, 0.850553, 0.0782731], 
       TagBox[{RectangleBox[{1.55, 7.55}, {2.45, 8.45}], InsetBox[
          StyleBox["\<\"Mg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {2, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mg" -> RGBColor[0.628274, 0.850553, 0.0782731], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
      {RGBColor[0.8913, 0.631904, 0.627399], 
       TagBox[{RectangleBox[{12.55, 7.55}, {13.45, 8.45}], InsetBox[
          StyleBox["\<\"Al\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Al" -> RGBColor[0.8913, 0.631904, 0.627399], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.941176, 0.784314, 0.627451], 
       TagBox[{RectangleBox[{13.55, 7.55}, {14.45, 8.45}], InsetBox[
          StyleBox["\<\"Si\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {14, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Si" -> RGBColor[0.941176, 0.784314, 0.627451], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.501961, 0], 
       TagBox[{RectangleBox[{14.55, 7.55}, {15.45, 8.45}], InsetBox[
          StyleBox["\<\"P\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {15, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["P" -> RGBColor[1., 0.501961, 0], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.90443, 0.97015, 0.13504], 
       TagBox[{RectangleBox[{15.55, 7.55}, {16.45, 8.45}], InsetBox[
          StyleBox["\<\"S\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {16, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["S" -> RGBColor[0.90443, 0.97015, 0.13504], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.412698, 0.932689, 0.166398], 
       TagBox[{RectangleBox[{16.55, 7.55}, {17.45, 8.45}], InsetBox[
          StyleBox["\<\"Cl\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {17, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cl" -> RGBColor[0.412698, 0.932689, 0.166398], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.546138, 0.844244, 0.892092], 
       TagBox[{RectangleBox[{17.55, 7.55}, {18.45, 8.45}], InsetBox[
          StyleBox["\<\"Ar\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ar" -> RGBColor[0.546138, 0.844244, 0.892092], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.534026, 0.420729, 0.705621], 
       TagBox[{RectangleBox[{0.55, 6.55}, {1.45, 7.45}], InsetBox[
          StyleBox["\<\"K\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["K" -> RGBColor[0.534026, 0.420729, 0.705621], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.480072, 0.744591, 0.0955222], 
       TagBox[{RectangleBox[{1.55, 6.55}, {2.45, 7.45}], InsetBox[
          StyleBox["\<\"Ca\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {2, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ca" -> RGBColor[0.480072, 0.744591, 0.0955222], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.901961, 0.901961, 0.901961], 
       TagBox[{RectangleBox[{2.55, 6.55}, {3.45, 7.45}], InsetBox[
          StyleBox["\<\"Sc\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {3, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sc" -> RGBColor[0.901961, 0.901961, 0.901961], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.74902, 0.760784, 0.780392], 
       TagBox[{RectangleBox[{3.55, 6.55}, {4.45, 7.45}], InsetBox[
          StyleBox["\<\"Ti\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ti" -> RGBColor[0.74902, 0.760784, 0.780392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.65098, 0.65098, 0.670588], 
       TagBox[{RectangleBox[{4.55, 6.55}, {5.45, 7.45}], InsetBox[
          StyleBox["\<\"V\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["V" -> RGBColor[0.65098, 0.65098, 0.670588], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.541176, 0.6, 0.780392], 
       TagBox[{RectangleBox[{5.55, 6.55}, {6.45, 7.45}], InsetBox[
          StyleBox["\<\"Cr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {6, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cr" -> RGBColor[0.541176, 0.6, 0.780392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.611765, 0.478431, 0.780392], 
       TagBox[{RectangleBox[{6.55, 6.55}, {7.45, 7.45}], InsetBox[
          StyleBox["\<\"Mn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {7, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mn" -> RGBColor[0.611765, 0.478431, 0.780392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.878431, 0.4, 0.2], 
       TagBox[{RectangleBox[{7.55, 6.55}, {8.45, 7.45}], InsetBox[
          StyleBox["\<\"Fe\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {8, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Fe" -> RGBColor[0.878431, 0.4, 0.2], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.941176, 0.564706, 0.627451], 
       TagBox[{RectangleBox[{8.55, 6.55}, {9.45, 7.45}], InsetBox[
          StyleBox["\<\"Co\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {9, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Co" -> RGBColor[0.941176, 0.564706, 0.627451], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.313725, 0.815686, 0.313725], 
       TagBox[{RectangleBox[{9.55, 6.55}, {10.45, 7.45}], InsetBox[
          StyleBox["\<\"Ni\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {10, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ni" -> RGBColor[0.313725, 0.815686, 0.313725], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.784314, 0.501961, 0.2], 
       TagBox[{RectangleBox[{10.55, 6.55}, {11.45, 7.45}], InsetBox[
          StyleBox["\<\"Cu\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {11, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cu" -> RGBColor[0.784314, 0.501961, 0.2], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.490196, 0.501961, 0.690196], 
       TagBox[{RectangleBox[{11.55, 6.55}, {12.45, 7.45}], InsetBox[
          StyleBox["\<\"Zn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {12, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Zn" -> RGBColor[0.490196, 0.501961, 0.690196], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.800757, 0.542666, 0.533513], 
       TagBox[{RectangleBox[{12.55, 6.55}, {13.45, 7.45}], InsetBox[
          StyleBox["\<\"Ga\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ga" -> RGBColor[0.800757, 0.542666, 0.533513], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.60508, 0.632465, 0.576489], 
       TagBox[{RectangleBox[{13.55, 6.55}, {14.45, 7.45}], InsetBox[
          StyleBox["\<\"Ge\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {14, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ge" -> RGBColor[0.60508, 0.632465, 0.576489], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.741176, 0.501961, 0.890196], 
       TagBox[{RectangleBox[{14.55, 6.55}, {15.45, 7.45}], InsetBox[
          StyleBox["\<\"As\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {15, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["As" -> RGBColor[0.741176, 0.501961, 0.890196], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.917248, 0.657833, 0.0706628], 
       TagBox[{RectangleBox[{15.55, 6.55}, {16.45, 7.45}], InsetBox[
          StyleBox["\<\"Se\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {16, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Se" -> RGBColor[0.917248, 0.657833, 0.0706628], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.58847, 0.22163, 0.16064], 
       TagBox[{RectangleBox[{16.55, 6.55}, {17.45, 7.45}], InsetBox[
          StyleBox["\<\"Br\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Br" -> RGBColor[0.58847, 0.22163, 0.16064], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.426019, 0.747462, 0.810413], 
       TagBox[{RectangleBox[{17.55, 6.55}, {18.45, 7.45}], InsetBox[
          StyleBox["\<\"Kr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Kr" -> RGBColor[0.426019, 0.747462, 0.810413], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.425391, 0.329242, 0.585895], 
       TagBox[{RectangleBox[{0.55, 5.55}, {1.45, 6.45}], InsetBox[
          StyleBox["\<\"Rb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rb" -> RGBColor[0.425391, 0.329242, 0.585895], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.325959, 0.646423, 0.095983], 
       TagBox[{RectangleBox[{1.55, 5.55}, {2.45, 6.45}], InsetBox[
          StyleBox["\<\"Sr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {2, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sr" -> RGBColor[0.325959, 0.646423, 0.095983], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.531014, 1., 1.], 
       TagBox[{RectangleBox[{2.55, 5.55}, {3.45, 6.45}], InsetBox[
          StyleBox["\<\"Y\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {3, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Y" -> RGBColor[0.531014, 1., 1.], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.458599, 0.917466, 0.918573], 
       TagBox[{RectangleBox[{3.55, 5.55}, {4.45, 6.45}], InsetBox[
          StyleBox["\<\"Zr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Zr" -> RGBColor[0.458599, 0.917466, 0.918573], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.385036, 0.834854, 0.841681], 
       TagBox[{RectangleBox[{4.55, 5.55}, {5.45, 6.45}], InsetBox[
          StyleBox["\<\"Nb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Nb" -> RGBColor[0.385036, 0.834854, 0.841681], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.310325, 0.752163, 0.769323], 
       TagBox[{RectangleBox[{5.55, 5.55}, {6.45, 6.45}], InsetBox[
          StyleBox["\<\"Mo\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {6, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mo" -> RGBColor[0.310325, 0.752163, 0.769323], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.234466, 0.669394, 0.701499], 
       TagBox[{RectangleBox[{6.55, 5.55}, {7.45, 6.45}], InsetBox[
          StyleBox["\<\"Tc\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {7, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Tc" -> RGBColor[0.234466, 0.669394, 0.701499], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.157459, 0.586546, 0.638209], 
       TagBox[{RectangleBox[{7.55, 5.55}, {8.45, 6.45}], InsetBox[
          StyleBox["\<\"Ru\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {8, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ru" -> RGBColor[0.157459, 0.586546, 0.638209], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.0793033, 0.50362, 0.579453], 
       TagBox[{RectangleBox[{8.55, 5.55}, {9.45, 6.45}], InsetBox[
          StyleBox["\<\"Rh\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {9, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rh" -> RGBColor[0.0793033, 0.50362, 0.579453], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0., 0.420615, 0.525231], 
       TagBox[{RectangleBox[{9.55, 5.55}, {10.45, 6.45}], InsetBox[
          StyleBox["\<\"Pd\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {10, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pd" -> RGBColor[0., 0.420615, 0.525231], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.752941, 0.752941, 0.752941], 
       TagBox[{RectangleBox[{10.55, 5.55}, {11.45, 6.45}], InsetBox[
          StyleBox["\<\"Ag\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {11, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ag" -> RGBColor[0.752941, 0.752941, 0.752941], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.85098, 0.560784], 
       TagBox[{RectangleBox[{11.55, 5.55}, {12.45, 6.45}], InsetBox[
          StyleBox["\<\"Cd\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {12, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cd" -> RGBColor[1., 0.85098, 0.560784], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.728371, 0.440594, 0.422196], 
       TagBox[{RectangleBox[{12.55, 5.55}, {13.45, 6.45}], InsetBox[
          StyleBox["\<\"In\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["In" -> RGBColor[0.728371, 0.440594, 0.422196], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.39799, 0.491477, 0.495586], 
       TagBox[{RectangleBox[{13.55, 5.55}, {14.45, 6.45}], InsetBox[
          StyleBox["\<\"Sn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sn" -> RGBColor[0.39799, 0.491477, 0.495586], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.619608, 0.388235, 0.709804], 
       TagBox[{RectangleBox[{14.55, 5.55}, {15.45, 6.45}], InsetBox[
          StyleBox["\<\"Sb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sb" -> RGBColor[0.619608, 0.388235, 0.709804], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.816706, 0.451332, 0.0100947], 
       TagBox[{RectangleBox[{15.55, 5.55}, {16.45, 6.45}], InsetBox[
          StyleBox["\<\"Te\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {16, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Te" -> RGBColor[0.816706, 0.451332, 0.0100947], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.580392, 0, 0.580392], 
       TagBox[{RectangleBox[{16.55, 5.55}, {17.45, 6.45}], InsetBox[
          StyleBox["\<\"I\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["I" -> RGBColor[0.580392, 0, 0.580392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.316906, 0.638078, 0.710252], 
       TagBox[{RectangleBox[{17.55, 5.55}, {18.45, 6.45}], InsetBox[
          StyleBox["\<\"Xe\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Xe" -> RGBColor[0.316906, 0.638078, 0.710252], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.332803, 0.217712, 0.483666], 
       TagBox[{RectangleBox[{0.55, 4.55}, {1.45, 5.45}], InsetBox[
          StyleBox["\<\"Cs\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cs" -> RGBColor[0.332803, 0.217712, 0.483666], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.165935, 0.55605, 0.0796556], 
       TagBox[{RectangleBox[{1.55, 4.55}, {2.45, 5.45}], InsetBox[
          StyleBox["\<\"Ba\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {2, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ba" -> RGBColor[0.165935, 0.55605, 0.0796556], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, {}, 
      {RGBColor[0.781537, 0.717388, 0.716579], 
       TagBox[{RectangleBox[{3.55, 4.55}, {4.45, 5.45}], InsetBox[
          StyleBox["\<\"Hf\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Hf" -> RGBColor[0.781537, 0.717388, 0.716579], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.734443, 0.544489, 0.683471], 
       TagBox[{RectangleBox[{4.55, 4.55}, {5.45, 5.45}], InsetBox[
          StyleBox["\<\"Ta\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ta" -> RGBColor[0.734443, 0.544489, 0.683471], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.681179, 0.360409, 0.63675], 
       TagBox[{RectangleBox[{5.55, 4.55}, {6.45, 5.45}], InsetBox[
          StyleBox["\<\"W\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {6, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["W" -> RGBColor[0.681179, 0.360409, 0.63675], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.605181, 0.367584, 0.556343], 
       TagBox[{RectangleBox[{6.55, 4.55}, {7.45, 5.45}], InsetBox[
          StyleBox["\<\"Re\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {7, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Re" -> RGBColor[0.605181, 0.367584, 0.556343], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.521806, 0.382125, 0.469204], 
       TagBox[{RectangleBox[{7.55, 4.55}, {8.45, 5.45}], InsetBox[
          StyleBox["\<\"Os\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {8, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Os" -> RGBColor[0.521806, 0.382125, 0.469204], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.445624, 0.373159, 0.399069], 
       TagBox[{RectangleBox[{8.55, 4.55}, {9.45, 5.45}], InsetBox[
          StyleBox["\<\"Ir\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {9, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ir" -> RGBColor[0.445624, 0.373159, 0.399069], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.815686, 0.815686, 0.878431], 
       TagBox[{RectangleBox[{9.55, 4.55}, {10.45, 5.45}], InsetBox[
          StyleBox["\<\"Pt\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {10, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pt" -> RGBColor[0.815686, 0.815686, 0.878431], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.819608, 0.137255], 
       TagBox[{RectangleBox[{10.55, 4.55}, {11.45, 5.45}], InsetBox[
          StyleBox["\<\"Au\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {11, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Au" -> RGBColor[1., 0.819608, 0.137255], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.721569, 0.721569, 0.815686], 
       TagBox[{RectangleBox[{11.55, 4.55}, {12.45, 5.45}], InsetBox[
          StyleBox["\<\"Hg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {12, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Hg" -> RGBColor[0.721569, 0.721569, 0.815686], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.65098, 0.329412, 0.301961], 
       TagBox[{RectangleBox[{12.55, 4.55}, {13.45, 5.45}], InsetBox[
          StyleBox["\<\"Tl\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {13, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Tl" -> RGBColor[0.65098, 0.329412, 0.301961], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.341176, 0.34902, 0.380392], 
       TagBox[{RectangleBox[{13.55, 4.55}, {14.45, 5.45}], InsetBox[
          StyleBox["\<\"Pb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pb" -> RGBColor[0.341176, 0.34902, 0.380392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.619608, 0.309804, 0.709804], 
       TagBox[{RectangleBox[{14.55, 4.55}, {15.45, 5.45}], InsetBox[
          StyleBox["\<\"Bi\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Bi" -> RGBColor[0.619608, 0.309804, 0.709804], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.670588, 0.360784, 0], 
       TagBox[{RectangleBox[{15.55, 4.55}, {16.45, 5.45}], InsetBox[
          StyleBox["\<\"Po\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Po" -> RGBColor[0.670588, 0.360784, 0], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.458824, 0.309804, 0.270588], 
       TagBox[{RectangleBox[{16.55, 4.55}, {17.45, 5.45}], InsetBox[
          StyleBox["\<\"At\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["At" -> RGBColor[0.458824, 0.309804, 0.270588], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.218799, 0.516091, 0.591608], 
       TagBox[{RectangleBox[{17.55, 4.55}, {18.45, 5.45}], InsetBox[
          StyleBox["\<\"Rn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {18, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rn" -> RGBColor[0.218799, 0.516091, 0.591608], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.25626, 0.0861372, 0.398932], 
       TagBox[{RectangleBox[{0.55, 3.55}, {1.45, 4.45}], InsetBox[
          StyleBox["\<\"Fr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Fr" -> RGBColor[0.25626, 0.0861372, 0.398932], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0., 0.473472, 0.04654], 
       TagBox[{RectangleBox[{1.55, 3.55}, {2.45, 4.45}], InsetBox[
          StyleBox["\<\"Ra\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {2, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ra" -> RGBColor[0., 0.473472, 0.04654], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, {}, 
      {RGBColor[0.684106, 0.206907, 0.445606], 
       TagBox[{RectangleBox[{3.55, 3.55}, {4.45, 4.45}], InsetBox[
          StyleBox["\<\"Rf\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {4, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rf" -> RGBColor[0.684106, 0.206907, 0.445606], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.691534, 0.185783, 0.420025], 
       TagBox[{RectangleBox[{4.55, 3.55}, {5.45, 4.45}], InsetBox[
          StyleBox["\<\"Db\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {5, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Db" -> RGBColor[0.691534, 0.185783, 0.420025], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.696874, 0.166269, 0.395772], 
       TagBox[{RectangleBox[{5.55, 3.55}, {6.45, 4.45}], InsetBox[
          StyleBox["\<\"Sg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {6, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sg" -> RGBColor[0.696874, 0.166269, 0.395772], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.700126, 0.148365, 0.372844], 
       TagBox[{RectangleBox[{6.55, 3.55}, {7.45, 4.45}], InsetBox[
          StyleBox["\<\"Bh\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {7, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Bh" -> RGBColor[0.700126, 0.148365, 0.372844], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701289, 0.13207, 0.351243], 
       TagBox[{RectangleBox[{7.55, 3.55}, {8.45, 4.45}], InsetBox[
          StyleBox["\<\"Hs\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {8, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Hs" -> RGBColor[0.701289, 0.13207, 0.351243], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.700363, 0.117385, 0.330968], 
       TagBox[{RectangleBox[{8.55, 3.55}, {9.45, 4.45}], InsetBox[
          StyleBox["\<\"Mt\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {9, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mt" -> RGBColor[0.700363, 0.117385, 0.330968], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.697348, 0.10431, 0.31202], 
       TagBox[{RectangleBox[{9.55, 3.55}, {10.45, 4.45}], InsetBox[
          StyleBox["\<\"Ds\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {10, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ds" -> RGBColor[0.697348, 0.10431, 0.31202], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.692245, 0.0928444, 0.294398], 
       TagBox[{RectangleBox[{10.55, 3.55}, {11.45, 4.45}], InsetBox[
          StyleBox["\<\"Rg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {11, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rg" -> RGBColor[0.692245, 0.0928444, 0.294398], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.685054, 0.0829886, 0.278102], 
       TagBox[{RectangleBox[{11.55, 3.55}, {12.45, 4.45}], InsetBox[
          StyleBox["\<\"Uub\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {12, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uub" -> RGBColor[0.685054, 0.0829886, 0.278102], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.675773, 0.0747426, 0.263133], 
       TagBox[{RectangleBox[{12.55, 3.55}, {13.45, 4.45}], InsetBox[
          StyleBox["\<\"Uut\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {13, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uut" -> RGBColor[0.675773, 0.0747426, 0.263133], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.664405, 0.0681063, 0.249491], 
       TagBox[{RectangleBox[{13.55, 3.55}, {14.45, 4.45}], InsetBox[
          StyleBox["\<\"Uuq\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uuq" -> RGBColor[0.664405, 0.0681063, 0.249491], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.650947, 0.0630797, 0.237174], 
       TagBox[{RectangleBox[{14.55, 3.55}, {15.45, 4.45}], InsetBox[
          StyleBox["\<\"Uup\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uup" -> RGBColor[0.650947, 0.0630797, 0.237174], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.635401, 0.0596628, 0.226184], 
       TagBox[{RectangleBox[{15.55, 3.55}, {16.45, 4.45}], InsetBox[
          StyleBox["\<\"Uuh\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uuh" -> RGBColor[0.635401, 0.0596628, 0.226184], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}}, {{}, {}, 
      {RGBColor[0.928084, 0.716075, 0.329427], 
       TagBox[{RectangleBox[{2.55, 1.55}, {3.45, 2.45}], InsetBox[
          StyleBox["\<\"La\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {3, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["La" -> RGBColor[0.928084, 0.716075, 0.329427], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.894824, 0.731424, 0.325131], 
       TagBox[{RectangleBox[{3.55, 1.55}, {4.45, 2.45}], InsetBox[
          StyleBox["\<\"Ce\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ce" -> RGBColor[0.894824, 0.731424, 0.325131], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.86523, 0.707999, 0.315261], 
       TagBox[{RectangleBox[{4.55, 1.55}, {5.45, 2.45}], InsetBox[
          StyleBox["\<\"Pr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pr" -> RGBColor[0.86523, 0.707999, 0.315261], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.837836, 0.662974, 0.301635], 
       TagBox[{RectangleBox[{5.55, 1.55}, {6.45, 2.45}], InsetBox[
          StyleBox["\<\"Nd\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {6, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Nd" -> RGBColor[0.837836, 0.662974, 0.301635], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
