(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    605590,      11071]
NotebookOptionsPosition[    595969,      10730]
NotebookOutlinePosition[    597309,      10768]
CellTagsIndexPosition[    597221,      10763]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
         "Blend" :> Documentation`HelpLookup["paclet:ref/Blend"], 
         "ColorFunction" :> 
         Documentation`HelpLookup["paclet:ref/ColorFunction"], 
         "InterpolatingFunction" :> 
         Documentation`HelpLookup["paclet:ref/InterpolatingFunction"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"ColorData\"\>", 
      2->"\<\"Blend\"\>", 3->"\<\"ColorFunction\"\>", 
      4->"\<\"InterpolatingFunction\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ColorDataFunction", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorDataFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorDataFunction"], "[", 
       RowBox[{
        StyleBox["range", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a function that represents a color scheme. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"ColorDataFunction", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "[", 
   StyleBox["par", "TI"], "]"}]], "InlineFormula"],
 " finds the color corresponding to parameter ",
 Cell[BoxData[
  StyleBox["par", "TI"]], "InlineFormula"],
 " in the color scheme represented by the ",
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11074023],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"], "[", "\"\<\!\(\*
StyleBox[\"scheme\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->171644141]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->612187803],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->190403285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->166637215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<LightTemperatureMap\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124719916],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVlGk0lXsbxg3RgFDSoUilaMAxRCRXFImUIVEqkQzF4SBlyEZFRa8xSULG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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312481082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436431886],

Cell["Return a color when the specific parameters are applied:", "ExampleText",
 CellID->96747207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->445192393],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", "\<\"AliceBlue\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "146", "\[RightSkeleton]"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[
     {PointSize[
       Rational[1, 20]], {
       {RGBColor[1., 1., 1.], PointBox[{1, 4}]}, 
       {RGBColor[
        0.6980392156862745, 0.13333333333333333`, 0.13333333333333333`], 
        PointBox[{1, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9411764705882353, 0.9019607843137255], 
        PointBox[{1, 2}]}, 
       {RGBColor[1., 0.9803921568627451, 0.803921568627451], 
        PointBox[{1, 1}]}, 
       {RGBColor[0.596078431372549, 0.984313725490196, 0.596078431372549], 
        PointBox[{1, 0}]}}, {
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.9607843137254902], 
        PointBox[{2, 4}]}, 
       {RGBColor[1., 0., 0.], PointBox[{2, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7686274509803922], 
        PointBox[{2, 2}]}, 
       {RGBColor[0.9411764705882353, 0.9019607843137255, 0.5490196078431373], 
        PointBox[{2, 1}]}, 
       {RGBColor[0.5647058823529412, 0.9333333333333333, 0.5647058823529412], 
        PointBox[{2, 0}]}}, {
       {RGBColor[0.8627450980392157, 0.8627450980392157, 0.8627450980392157], 
        PointBox[{3, 4}]}, 
       {RGBColor[0.5450980392156862, 0., 0.], PointBox[{3, 3}]}, 
       {RGBColor[1., 0.5490196078431373, 0.], PointBox[{3, 2}]}, 
       {RGBColor[0.9333333333333333, 0.9098039215686274, 0.6666666666666666], 
        PointBox[{3, 1}]}, 
       {RGBColor[
        0.13333333333333333`, 0.5450980392156862, 0.13333333333333333`], 
        PointBox[{3, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{4, 4}]}, 
       {RGBColor[0.5019607843137255, 0., 0.], PointBox[{4, 3}]}, 
       {RGBColor[0.8705882352941177, 0.7215686274509804, 0.5294117647058824], 
        PointBox[{4, 2}]}, 
       {RGBColor[0.7411764705882353, 0.7176470588235294, 0.4196078431372549], 
        PointBox[{4, 1}]}, 
       {RGBColor[
        0.19607843137254902`, 0.803921568627451, 0.19607843137254902`], 
        PointBox[{4, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{5, 4}]}, 
       {RGBColor[1., 0.8941176470588236, 0.8823529411764706], 
        PointBox[{5, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9215686274509803, 0.8431372549019608], 
        PointBox[{5, 2}]}, 
       {RGBColor[1., 1., 0.9411764705882353], PointBox[{5, 1}]}, 
       {RGBColor[0., 1., 0.], PointBox[{5, 0}]}}, {
       {RGBColor[0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
        PointBox[{6, 4}]}, 
       {RGBColor[0.9803921568627451, 0.5019607843137255, 0.4470588235294118], 
        PointBox[{6, 3}]}, 
       {RGBColor[0.8235294117647058, 0.7058823529411765, 0.5490196078431373], 
        PointBox[{6, 2}]}, 
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.8627450980392157], 
        PointBox[{6, 1}]}, 
       {RGBColor[0., 0.5019607843137255, 0.], PointBox[{6, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{7, 4}]}, 
       {RGBColor[1., 0.38823529411764707`, 0.2784313725490196], 
        PointBox[{7, 3}]}, 
       {RGBColor[1., 0.8705882352941177, 0.6784313725490196], 
        PointBox[{7, 2}]}, 
       {RGBColor[1., 1., 0.8784313725490196], PointBox[{7, 1}]}, 
       {RGBColor[0., 0.39215686274509803`, 0.], PointBox[{7, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{8, 4}]}, 
       {RGBColor[
        0.9137254901960784, 0.5882352941176471, 0.47843137254901963`], 
        PointBox[{8, 3}]}, 
       {RGBColor[1., 0.9215686274509803, 0.803921568627451], 
        PointBox[{8, 2}]}, 
       {RGBColor[0.9803921568627451, 0.9803921568627451, 0.8235294117647058], 
        PointBox[{8, 1}]}, 
       {RGBColor[0.1803921568627451, 0.5450980392156862, 0.3411764705882353], 
        PointBox[{8, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{9, 4}]}, 
       {RGBColor[1., 0.4980392156862745, 0.3137254901960784], 
        PointBox[{9, 3}]}, 
       {RGBColor[1., 0.9372549019607843, 0.8352941176470589], 
        PointBox[{9, 2}]}, 
       {RGBColor[1., 1., 0.], PointBox[{9, 1}]}, 
       {RGBColor[
        0.23529411764705882`, 0.7019607843137254, 0.44313725490196076`], 
        PointBox[{9, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{10, 4}]}, 
       {RGBColor[1., 0.27058823529411763`, 0.], PointBox[{10, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7098039215686275], 
        PointBox[{10, 2}]}, 
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.], 
        PointBox[{10, 1}]}, 
       {RGBColor[0., 1., 0.4980392156862745], PointBox[{10, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{11, 4}]}, 
       {RGBColor[1., 0.6274509803921569, 0.47843137254901963`], 
        PointBox[{11, 3}]}, 
       {RGBColor[1., 0.6470588235294118, 0.], PointBox[{11, 2}]}, 
       {RGBColor[
        0.4196078431372549, 0.5568627450980392, 0.13725490196078433`], 
        PointBox[{11, 1}]}, 
       {RGBColor[0.9607843137254902, 1., 0.9803921568627451], 
        PointBox[{11, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{12, 4}]}, 
       {RGBColor[
        0.6274509803921569, 0.3215686274509804, 0.17647058823529413`], 
        PointBox[{12, 3}]}, 
       {RGBColor[0.9607843137254902, 0.8705882352941177, 0.7019607843137254], 
        PointBox[{12, 2}]}, 
       {RGBColor[0.6039215686274509, 0.803921568627451, 0.19607843137254902`],
         PointBox[{12, 1}]}, 
       {RGBColor[0., 0.9803921568627451, 0.6039215686274509], 
        PointBox[{12, 0}]}}, {
       {RGBColor[0., 0., 0.], PointBox[{13, 4}]}, 
       {RGBColor[1., 0.9607843137254902, 0.9333333333333333], 
        PointBox[{13, 3}]}, 
       {RGBColor[0.9921568627450981, 0.9607843137254902, 0.9019607843137255], 
        PointBox[{13, 2}]}, 
       {RGBColor[0.3333333333333333, 0.4196078431372549, 0.1843137254901961], 
        PointBox[{13, 1}]}, 
       {RGBColor[0.4, 0.803921568627451, 0.6666666666666666], 
        PointBox[{13, 0}]}}, {
       {RGBColor[1., 0.9803921568627451, 0.9803921568627451], 
        PointBox[{14, 4}]}, 
       {RGBColor[
        0.8235294117647058, 0.4117647058823529, 0.11764705882352941`], 
        PointBox[{14, 3}]}, 
       {RGBColor[1., 0.9803921568627451, 0.9411764705882353], 
        PointBox[{14, 2}]}, 
       {RGBColor[0.6784313725490196, 1., 0.1843137254901961], 
        PointBox[{14, 1}]}, 
       {RGBColor[0.4980392156862745, 1., 0.8313725490196079], 
        PointBox[{14, 0}]}}, {
       {RGBColor[0.7372549019607844, 0.5607843137254902, 0.5607843137254902], 
        PointBox[{15, 4}]}, 
       {RGBColor[
        0.5450980392156862, 0.27058823529411763`, 0.07450980392156863], 
        PointBox[{15, 3}]}, 
       {RGBColor[
        0.7215686274509804, 0.5254901960784314, 0.043137254901960784`], 
        PointBox[{15, 2}]}, 
       {RGBColor[0.4980392156862745, 1., 0.], PointBox[{15, 1}]}, 
       {RGBColor[
        0.25098039215686274`, 0.8784313725490196, 0.8156862745098039], 
        PointBox[{15, 0}]}}, {
       {RGBColor[0.9411764705882353, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{16, 4}]}, 
       {RGBColor[0.9568627450980393, 0.6431372549019608, 0.3764705882352941], 
        PointBox[{16, 3}]}, 
       {RGBColor[
        0.8549019607843137, 0.6470588235294118, 0.12549019607843137`], 
        PointBox[{16, 2}]}, 
       {RGBColor[0.48627450980392156`, 0.9882352941176471, 0.], 
        PointBox[{16, 1}]}, 
       {RGBColor[
        0.12549019607843137`, 0.6980392156862745, 0.6666666666666666], 
        PointBox[{16, 0}]}}, {
       {RGBColor[0.803921568627451, 0.3607843137254902, 0.3607843137254902], 
        PointBox[{17, 4}]}, 
       {RGBColor[1., 0.8549019607843137, 0.7254901960784313], 
        PointBox[{17, 3}]}, 
       {RGBColor[1., 0.9725490196078431, 0.8627450980392157], 
        PointBox[{17, 2}]}, 
       {RGBColor[0.9411764705882353, 1., 0.9411764705882353], 
        PointBox[{17, 1}]}, 
       {RGBColor[0.2823529411764706, 0.8196078431372549, 0.8], 
        PointBox[{17, 0}]}}, {
       {RGBColor[
        0.6470588235294118, 0.16470588235294117`, 0.16470588235294117`], 
        PointBox[{18, 4}]}, 
       {RGBColor[0.803921568627451, 0.5215686274509804, 0.24705882352941178`],
         PointBox[{18, 3}]}, 
       {RGBColor[1., 0.8431372549019608, 0.], PointBox[{18, 2}]}, 
       {RGBColor[0.5607843137254902, 0.7372549019607844, 0.5607843137254902], 
        PointBox[{18, 1}]}, 
       {RGBColor[0.9411764705882353, 1., 1.], PointBox[{18, 0}]}}},
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{367, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->556387637]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "\"\<Azure\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546472958],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.9411764705882353`", ",", "1.`", ",", "1.`"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33147540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199419762],

Cell["Define a color function for the plot:", "ExampleText",
 CellID->487966323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "\"\<DarkRainbow\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164649404],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzlVPk71PsXVyiRpdFKZW1Dst2WK72mIlmTtCdRqchSShI3KimlXNwUIpSS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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183614342]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"y", "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", "y"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "f"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272577028],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyE/U2Ipum6L3TGZ2YddJQjQRDUOgrCAUc1sdt4sWm1VBQERzmyOQ1Na2kP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   "], {{
     {RGBColor[0.237736, 0.340215, 0.575113], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUVsWVx4v+6KYbGml6o+lGlgZ6ozeaZkczgig4YRGMDtucKCrJOJE4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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll3uQ1WUZx59VNBbYRfcKu8varmzunrPnnL2yF5BKRYGKyzIDI7FNgGbp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         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.25827147995912525`, 0.37839984236926044`, 0.4838515036756635], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnQd0VlXWhi/SCQmQEFoChIAhkELIlwrBNnYRuyCIoiAiKlgRxq4zNhQ7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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndglUXWxgeQlRaQJDeUkNAU09tNuUmAtUuToiBIEUFUisKqiCAKuLoq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         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.2876209264974003, 0.46946560021181166`, 0.28755927739005105`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXV8l1X7x7/EYDBGrNiAFYMFaxZsbNiPiAqigh2AoCD2Y2DnYwfGYyK2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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3mczlX7x792M2YGs2Awhgozc9+zb/csSnuoJEt47GSvFFmztDwtSpaW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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4761351184802787, 0.5891475399697715, 0.2482608715749009], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd4VVXWxi+9JSEFSCcFQnoPISHB3nXGUT9xLKCAbRQYdQSxjIh9xobY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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3d8lcXSxx96CQRIAgmEGlrayTknvSJ2xK4vXVqwCwhcRcSCIGKhCChe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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7594849284743229, 0.7398291496002343, 0.2923133807145325], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXeYV9X19b8MnRlmGGBmmGF6770XiGJFbFhQjN0YxQKKXcEC2ImKir2L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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlm3ecVUXShg8oecjDzDBMgCFNunMn3DvhziAqIC6KLAaCgiKmNZBRQIKS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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.868487079168767, 0.7004072921185043, 0.32351454213251357`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXWcV2Xaxn/UDD09DMMwDDBMdzCNCYqJuequsbYr6io2YlECitgdYIu6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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3d8lkXWhh9CCQEC6UCAhCrJm7zpPQFsIEgRUFzbiqsgoijSRKVI7x0U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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7652729352272502, 0.3586203703690131, 0.2619078873736111], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXmc19P+x79NM9MyUzOt0zpbM9XMNPu+pbKTtRCyt4hLi7WEclW4yNZi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnuAztXWx39uY8wM45JxHcNEzO2ZeZ555nlmnhnMIJIQOaeU6j2Ve0lS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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.72987, 0.239399, 0.230961], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3l0l9WZxy/JLxtOAiFBksgSCBBCNhLIQhJ2VJTWFsSldcWFfXGdqoho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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll3lwVtUZxg8hH4EgJJCwCkkQSsn6Zb3J9yVAFiwBbGUJgkUYUSlEWbpI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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10391, 13724, 13723, 13722, 10952, 11331, 11330, 13994, 
         13993, 13992, 14719, 14718, 12876, 12875, 11060, 13209, 13611, 13610,
          12500, 14209, 14208, 14207, 11829, 15308, 15309, 15307, 11838, 
         14895, 11344, 14894, 14897, 14896, 11234, 13308, 11233, 13309, 13766,
          10430, 12376, 13765, 13764, 13763, 11551, 11678, 11677, 10559, 
         15607, 11160, 11613, 14656, 14657, 13924, 13925, 10556, 13922, 13923,
          10705, 14658, 15139, 13390, 13391, 12970, 12971, 14928, 14929, 
         14200, 14201, 10755, 15018, 12304, 15525, 12140, 15524, 12141, 12699,
          12698, 12013, 11827, 15649, 10757, 12634, 10756, 15648, 11826, 
         10823, 14539, 14540, 14538, 15352, 15351, 11886, 14204, 14203, 14202,
          11825, 15287, 11617, 14784, 11279, 14051, 14052, 14053, 11772, 
         15243, 11506, 15086, 15088, 15087, 10980, 15393, 15394, 15390, 15392,
          15391, 15470, 10624, 15621, 12037, 12036, 13683, 12168, 13681, 
         12167, 13682, 13545, 13210, 13211, 12877, 13397, 15598, 10509, 13398,
          12305}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0sdvz3Ecx/E3nVzESIRUkNhFF1pqxGipk1aNWAezNdqLCv4A60CMFie1
WrOJKHqQuglNrLoZSREzcXLo0vL4HZ55fd7v9+c9vu/Pd/zW6rKqARHRjyFT
IxYviPg3O2J0QcQo7JgW0ZEb8Qk7C9n4NifiO/JyIn7Rn/iBpzMidol/mRnR
OSviMfu4vDdi7chy/zV9hZfYNz9iLzr0+CDvIx7kRzxEBl+F+2PoIfX+iR2m
h/gOYiN/qfka6Cp6nd5U6xZS2WlIxxN3N4i10hR2MpJQnRVxw90X5qifG3EZ
2fpmod0eaudFvKW57BwsmB7RJieJ75HzbfG7uING9Y/Z2XGcQIlaK1A7JeKv
ufebu5fW0APmqEGfmn/Ri36xPvQ4d6NF/SZ1h9vdsMTu1c/Oi/jD/8JeTzuf
wRKx++w2b5ZirmbnVLqMfynOuXMWk8z0Vewbivh72WnutWbbEV3OV4wf4t8x
WfyOWXPkftZ7hNgp51Z7m5npbcW7sNnMW3DdDhvQiD55C8Uq7bYCTewMepeO
oXV2sl/fGuywz0yzz9OjxU4K6QXffRF1uOZ7z9NkM27xL23XO1+PAmTy1djx
WHXKzHBJvJTW00FqpWMCeyKWuVcnt1LebuzBFXYZ/xz5G+kmVCX+SexFMbsI
pWYeqdY6/Y7yH8ENPcrVfWf+93im1krf8ZxexWp5a1COwfJO6jGI/lZrm9yt
2G0fdXIq6TjxuercS+yC5qNZz1T7KHBuU3O9N1iHtViU6OM93sudbo5d6iWZ
KxkpGCp3IB2AQIm+KxJvoVaPffaiE93own+rU7HQ
         "]],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10514, 13399, 10515, 12879, 12878, 12922, 12921, 10609, 
         13995, 13996, 13832, 13833, 10513, 11211, 14716, 14717, 14418, 14420,
          14419, 10563, 12909, 12910, 12874, 14528, 13395, 13396, 11328, 
         15431, 11999, 15430, 11998, 12695, 14142, 14141, 14140, 12068, 15486,
          12240, 15244, 11775, 14137, 14138, 14139, 12555, 15426, 15427, 
         15425, 15429, 15428, 11212, 12030, 15618, 10607, 12590, 10608, 15619,
          11705, 13938, 14666, 14667, 14134, 14133, 10710, 12608, 10711, 
         14136, 14135, 15242, 15241, 14132, 14131, 14869, 14868, 15142, 14577,
          10712, 15819, 13883, 13882, 10540, 13884, 13881, 13988, 13987, 
         10606, 11162, 15608, 10560, 11684, 15736, 11685, 11552, 13767, 13768,
          13769, 12377, 12431, 12432, 12103, 15653, 10782, 12649, 10783, 
         14872, 14873, 14870, 11329, 14871, 10641, 12260, 11830, 14212, 14213,
          14214, 12501, 13532, 13533, 13212, 11061, 12880, 13400, 14877, 
         14878, 14145, 14146, 14147, 11429, 15708, 11430, 11336, 14875, 11335,
          14876, 14880, 14879}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10508, 12000, 12557, 12556, 14299, 14298, 13016, 15676, 
         10951, 13092, 12810, 12197, 15892, 12196, 14785, 11280, 14059, 14060,
          10644, 14931, 10645, 11779, 15247, 11780, 12615, 12614, 10719, 
         14148, 14149, 14580, 14579, 13888, 13889, 11337, 12242, 12241, 14720,
          11111, 13998, 13997, 10610, 12923, 12924, 14442, 14443, 14441, 
         13284, 14679, 14680, 13957, 10580}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nd019UZx/GbWBkHhIB2nNOCJoAkYQQyUFYCnMphRhL0D4UONQlYPGXI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         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{12085, 15792, 12086, 12636, 12635, 14206, 14205, 13447, 
         11391, 13446, 11390, 12418, 11232, 14783, 11278, 14049, 14050, 10642,
          14874, 10643, 15246, 11776, 15245, 11777, 12611, 12610, 10715, 
         14467, 14468, 14465, 10979, 14466, 11332, 12248, 12247, 14678, 11164,
          15890, 13954, 13953, 10576, 13270, 13271, 14669, 14668, 11163, 
         15092, 15093, 15089, 15091, 15090}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nmQz3Ucx/GPjl02RxS6llVU9nKlPRzdURaT7mkmiyadFqtcK2Edq5xL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         "]],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1FlszXkYxvG3g5tRiQTTnhYTGUs3O8UgYqllklK1hBlmErHEjd2dNVQl
5sYupqSi1IUZ2qoLLrixxZYeSyXctkerwZVtYvmcuPj2+a3P+/zf//+037K1
5WsyIuIXf+aNiBhfGHFlaMSlvIjqYRENNDkhIntwxOIhEYcnRiyiD8dEPMB9
7Pk1ogL7CyK+8DhAv9Iaewnjy8Mjao3P4gym83+LLHvTaAPPEjoZU1FvPoVW
qL1zdMQOzFAzOT7iMR5hpnm2+0+MN421ZryRJuk+ef/GQbUOoZu1ZTIcNT6C
w5jo/g13J6nzjM4yv2D9Iuqwwvn/6L84j2ZnnqKZV9W4iBO4VRxxG9vyI+7Q
7TQp+yM0IW+kPZm24rl7L/WovSgiRdvoUX7HUMp/NkLNufr8RJY2+d97/qXe
wQfabj7PXjkuYyv/Rpppv6vzleaZdL61p/SV8x/d+9P+J9phvtDeAmSoc0re
aixR/w+8kqdNrg7aTl/Imy9/AVp4p9CKodabZP3BeidkoAs648GoiF10N0Z5
/6NRjGE8n8lU434zPaL+Tb3qbt5X//v75n60nmXeYr2X/XVybjRfn35Wz7AF
A53ZZ20QHYBLcufROtqAeuQ6Vyn/XgzxfINRhL/UKOOV0oe3+rEu3Rd3z/H7
nxapWYjV6m+W+bz9FrlP27vrTqU7ud55b+SgL/pglfOVvEv47KEp535Tp8J4
jrplmIuTvHbJVOz8PWer9Cr06ZB+lvg+DtKpdBp+0t8O3lk0Gyl+L5FIv3v+
pbI10qt6V6pOgn8OcpFwLxs/q7NC7pVYnv4WPMcq+o5+QK0M72k5rze8Wu3N
4f/F/DN6qdsTPdBqfYPePlTv93SvzY+r9Q+qkK9vBai3voVvHS3j8ZpvC9+k
Ok2Y6Xec4FGS/j1jOnrLeU0frmOBvs8f8f3/0DdfNtAW
         "]],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10378, 12402, 15458, 15459, 13624, 15883, 11672, 15183, 
         11673, 13617, 13618, 13616, 15447, 15446, 10554, 12491, 12602, 12603,
          13642, 13641, 11757, 12964, 12963, 10690, 14640, 14641, 14637, 
         14639, 14638, 10486, 14631, 11147, 14630, 11148, 14632, 10689, 14106,
          11308, 14834, 10964, 14453, 10965, 14454, 10693, 12604, 12605, 
         11758, 15223, 15225, 15224, 10692, 14985, 10691, 14108, 14107, 11309,
          14835, 11082, 12386, 11199, 13288, 11200, 13289, 14184, 13291, 
         11201, 13290, 14705, 14704, 10477, 12399, 10476}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nd019UZx/ErWKHSCjJjglpJ2CMBZRZUWkVOraOoBBKIitXTWghDhcpS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         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{12299, 12401, 10484, 13380, 13381, 13379, 11305, 13382, 
         14288, 13014, 15675, 10938, 13080, 12809, 12192, 15891, 12191, 14636,
          11149, 13911, 13912, 10552, 14706, 10553, 11674, 15184, 11675, 
         12579, 12578, 10574, 13952, 15683, 11105, 14571, 13875, 14844, 11315,
          14114, 10696, 14574, 11107, 14572, 11106, 14573, 14708, 14707, 
         14652, 14653, 14651, 14655, 14654, 10575, 11676, 12494, 12493, 12492,
          10555, 12572, 12573, 11654, 13553, 11653, 13554, 13700, 10380, 
         10400, 12406}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nmUz2UUx/HHoA1jmUmNsoxiRGQJZWwhNWOU00mqk2ZBG9HG0DaWTsqu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         "]],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1Edsz3EYx/FHOqwSJzNiVIvao9VqzUprHtTeM/YIiQjOhBhtcSHhQCWS
SigHcSCtGaRE7NaMfbFiHRCvfxze/Xyf5/us7/Nr22nh2pI1DSKinR8rB0fs
6hmxjK7AcvzuE3Gob0Rtt4iHBRHZvSJes18hIysilX2H/7j7YXzDUcm3Jyei
FGXI7Bcxt3vEXudyTM2PmIIWztdyI/J6RPwYEvGd/QNHxN7OizhKf7F/4ha7
FtXmqRIf4ue5P6HXNzMvSuTT4e7a0DR2hft2zsdoM3Zb5xr5S9RZin3q7sd8
99PM89t7/6DWTCPUaeWuNQrcDUGh8yj0EX/ZOxvqncLfiI5kj0C93Ily62gJ
fUK72tMbd29xuXfEI/u6ZV+H2X/Mk2yWFCRhvZxUWqzHRr0aq52qx7HsiHzx
X9VqxG7K35A2oUV0N93gjXtoDt6JvaJXmd2/d/6AUv5isWMwGul6zNBrJjrr
1QkdMckMs+xqinoz6Sa5rcV+NfcaNVYnZlJ7m/sUWuh+FJp7S6W4cj1v8N9E
B/kZ/SO6IB0LBtg3/trzQLvJRj8MQH88N8tDu6lR+yKqkSk+A7Xe/lLeYzVf
0Ee0IrEbzBnkdwyfzJFvvgI8Ne8DtWbz3adP2IP5m3nfU/t8hnr+Z3o+pqto
XSIu4UeauDzx9fLu8c9S5y6tY1/3tlx3H/nG6zsO+8yxF1vNmeMt2+ggesms
U52vmHeB91yl53CSvwqnsMXeutPN9IJvcB5pcptirtzd+h1MfF9ao29fOy5N
fF+sc/8z8TeE6+qOZVfRM5gn5zSdjsnOM2ih+1yxX7yjlX6r1WhJP7NXqT1B
TJH3FGM0yr2pDMnYbkc7cNZ8G+Ukq3lPrSR5i52T6U757YdGHLCbCntMkpfC
X61Wetb//zP/ACqOwbk=
         "]],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10443, 12391, 10444, 14692, 14693, 13285, 11184, 13286, 
         14169, 14168, 14909, 14908, 13965, 14691, 11183, 15867, 14532, 11063,
          14533, 14534, 13215, 15833, 15835, 15834, 10665, 11340, 14882, 
         14883, 14477, 14479, 14478, 10666, 14481, 10998, 14480, 10997, 14804,
          14805, 14080, 10663, 14673, 11168, 14670, 14672, 14671, 10449, 
         12393, 10450, 15577, 11976, 12525, 12524, 10664, 14081, 13737, 15881,
          11533, 15114, 13738, 13739, 12415, 12416, 11224, 11735, 15630, 
         10671, 15631, 11736, 13741, 13740, 15857, 11017, 14495, 11018, 13162,
          13893, 13161, 11016, 13160, 11015}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nt0z3Ucx/GPdWWky5Slkk6JSC4rRemeSxfXyW2XJGaYToRCpntTKlSr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         "]],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{12410, 12392, 10448, 13366, 13367, 13365, 11292, 13368, 
         14276, 14275, 14974, 14973, 10931, 14433, 10932, 14434, 13072, 14383,
          14384, 12916, 12915, 10595, 14888, 14489, 14490, 14488, 14492, 
         14491, 10668, 14088, 15682, 11092, 14558, 13859, 14810, 14811, 14089,
          10669, 14562, 11093, 14559, 14561, 14560, 14699, 12395, 10456, 
         15582, 11581, 12530, 12529, 10568, 13950, 13525, 11537, 13524, 13742,
          13743, 12361, 12812, 12811, 11671, 15611, 10571, 15610, 11670, 
         11096, 13166, 11025, 13165, 11026, 13167, 13899, 12904, 14393, 14394,
          10889, 14392, 13695}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1, 15737, 13556, 13961, 13960, 10584, 13106, 13107, 14472, 
         14471, 10981, 15854, 13725, 13726, 13317, 11238, 13316, 11239, 13566,
          11720, 13564, 11719, 13565, 15875, 11467, 15056, 11468, 13497, 
         10953, 12451, 11472, 12752, 13499, 13498, 13684, 12172, 12174, 15800,
          12173, 12257, 12256, 12751, 11932, 12681, 14381, 13457, 11402, 
         13455, 11401, 13456, 12323, 14881, 11338, 13401, 11339, 13402, 10877,
          11627, 15599, 10517, 13839, 13296, 13297, 13041, 13043, 15889, 
         13042, 10565, 13582, 11804, 14170, 14171, 14172, 12626, 10739, 12977,
          12627, 11803, 11806, 15754, 11805, 10628, 15623, 11250, 11249, 
         12419, 12407, 12408, 11219, 14001, 14002, 10613, 14725, 10614, 11244,
          14758, 11245, 14759, 10855, 14364, 11459, 15042, 12040, 15471, 
         12706, 12707, 12146, 15538, 12145, 15539, 12282, 15009, 10731, 14163,
          14162, 11346, 12261, 10646, 14788, 11283, 14787, 14790, 14789, 
         11282, 14786, 11281, 15373, 11916, 10403, 15804, 13598, 13109, 10982,
          13108, 10983, 14582, 11113, 14581, 11112, 11174, 15614, 10585}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15, 13567, 13569, 13568, 10652, 13119, 13120, 13117, 10991, 
         13118, 11287, 13364, 15869, 11247, 14761, 11248, 13363, 11286, 14795,
          11285, 15872, 15873, 15871, 13362, 14760, 11246, 15695, 12975, 
         12976, 11802, 15643, 10738, 12625, 10737, 15642, 12074, 13259, 13258,
          10440, 15574, 13257, 12826, 12893, 12892, 10530, 15172, 11659, 
         15171, 11660, 15173, 11571, 11572, 10442, 13261, 10441, 15807, 13260,
          12827, 12900, 12899, 10545, 12901, 11696, 13973, 13974, 13975, 
         12584, 10593, 12913, 12583, 11693, 11695, 15739, 11694, 10544, 15605,
          11124, 12184, 15900, 12185, 13709, 14428, 10928, 13939, 10566, 
         12512, 12513, 11570, 15573, 10438, 12390, 10439, 14592, 14593, 14591,
          11121, 14594, 10588, 15615, 11178, 13890, 14589, 14590, 14063, 
         14062, 10650, 12598, 10651, 14065, 14064, 11726, 12262, 10647, 11727,
          15745, 11728, 11521, 13729, 13730, 13731, 12345, 10404, 13728, 
         13727, 15855, 10989, 14474, 10990, 14588, 11120, 14587, 11119, 11569,
          15726, 11568}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10985, 13112, 10986, 13113, 13964, 13114, 10988, 14473, 
         10987, 15406, 11968, 15405, 11967, 15151, 11626, 13836, 13837, 13838,
          12507, 10516, 13835, 13834, 15150, 15149, 13546, 14421, 10923, 
         14423, 14422, 12823, 12824, 10433, 14793, 14794, 13773, 13772, 13771,
          10984, 12325, 12324, 12763, 12762, 15262, 11798, 14166, 14167, 
         10733, 15263, 10734, 14530, 14531, 14529, 11062, 13214, 13213, 12822,
          13111, 13110, 13500, 11689, 15738, 11690, 10993, 14475, 10992, 
         14476, 12310, 12427, 10432, 15571, 11562, 11561, 11854, 15763, 11853,
          10526, 11832, 15760, 11833, 11831, 15292, 15293, 15289, 15291, 
         15290, 12414, 10431, 12821, 12152, 10863, 12673, 10864, 11434, 15709,
          11433, 12283, 11912, 15769, 11913, 11558, 12506, 11559, 15722, 
         11560, 10870, 12674, 12675, 11924, 15376, 11923, 10818, 12378, 10817,
          14302, 14301, 11432, 15003, 12182, 12183, 11464, 15048, 15050, 
         15049, 10869, 12736, 10868, 12279, 12444, 12443, 10786, 12273, 11899,
          14345, 14346, 10845, 12666, 10844, 13022, 13023, 12938, 13560, 
         15828, 10626, 13561, 11709, 12039, 15786, 12038, 12705, 11555, 15721,
          12169, 11965, 15404, 11966, 13612, 11556, 13534, 11557, 13535, 
         11469, 15057, 15774, 11933, 15885, 15773}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->531773076]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->610447763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<GrayYellowTones\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588619454],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVUXk81YketY2SF+GiXnZpESmUaugkjfYSMh7KXjRCKI9kulkmy5AoWULT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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137657384]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "12", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66291465],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "10", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[{
      {RGBColor[0.6235294117647059, 0.1450980392156863, 0.12549019607843137`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{1, 0}, Offset[{-1, -1}, {2, 1}]]}, 
      {RGBColor[0.6588235294117647, 0.3058823529411765, 0.17254901960784313`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{2, 0}, Offset[{-1, -1}, {3, 1}]]}, 
      {RGBColor[
       0.24313725490196078`, 0.11764705882352941`, 0.058823529411764705`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{3, 0}, Offset[{-1, -1}, {4, 1}]]}, 
      {RGBColor[0.9450980392156862, 0.7529411764705882, 0.6352941176470588], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{4, 0}, Offset[{-1, -1}, {5, 1}]]}, 
      {RGBColor[0.8392156862745098, 0.4745098039215686, 0.21176470588235294`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{5, 0}, Offset[{-1, -1}, {6, 1}]]}, 
      {RGBColor[0.8274509803921568, 0.7254901960784313, 0.43529411764705883`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{6, 0}, Offset[{-1, -1}, {7, 1}]]}, 
      {RGBColor[0.44313725490196076`, 0.4980392156862745, 0.5490196078431373],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{7, 0}, Offset[{-1, -1}, {8, 1}]]}, 
      {RGBColor[
       0.24705882352941178`, 0.30980392156862746`, 0.37254901960784315`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{8, 0}, Offset[{-1, -1}, {9, 1}]]}, 
      {RGBColor[
       0.16862745098039217`, 0.23921568627450981`, 0.3803921568627451], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{9, 0}, Offset[{-1, -1}, {10, 1}]]}, 
      {RGBColor[
       0.2980392156862745, 0.17647058823529413`, 0.19607843137254902`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{10, 0}, Offset[{-1, -1}, {11, 1}]]}},
     AspectRatio->NCache[
       Rational[1, 10], 0.1],
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{294, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->597745344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->240614921],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", "\<\"AliceBlue\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "146", "\[RightSkeleton]"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[
     {PointSize[
       Rational[1, 20]], {
       {RGBColor[1., 1., 1.], PointBox[{1, 4}]}, 
       {RGBColor[
        0.6980392156862745, 0.13333333333333333`, 0.13333333333333333`], 
        PointBox[{1, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9411764705882353, 0.9019607843137255], 
        PointBox[{1, 2}]}, 
       {RGBColor[1., 0.9803921568627451, 0.803921568627451], 
        PointBox[{1, 1}]}, 
       {RGBColor[0.596078431372549, 0.984313725490196, 0.596078431372549], 
        PointBox[{1, 0}]}}, {
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.9607843137254902], 
        PointBox[{2, 4}]}, 
       {RGBColor[1., 0., 0.], PointBox[{2, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7686274509803922], 
        PointBox[{2, 2}]}, 
       {RGBColor[0.9411764705882353, 0.9019607843137255, 0.5490196078431373], 
        PointBox[{2, 1}]}, 
       {RGBColor[0.5647058823529412, 0.9333333333333333, 0.5647058823529412], 
        PointBox[{2, 0}]}}, {
       {RGBColor[0.8627450980392157, 0.8627450980392157, 0.8627450980392157], 
        PointBox[{3, 4}]}, 
       {RGBColor[0.5450980392156862, 0., 0.], PointBox[{3, 3}]}, 
       {RGBColor[1., 0.5490196078431373, 0.], PointBox[{3, 2}]}, 
       {RGBColor[0.9333333333333333, 0.9098039215686274, 0.6666666666666666], 
        PointBox[{3, 1}]}, 
       {RGBColor[
        0.13333333333333333`, 0.5450980392156862, 0.13333333333333333`], 
        PointBox[{3, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{4, 4}]}, 
       {RGBColor[0.5019607843137255, 0., 0.], PointBox[{4, 3}]}, 
       {RGBColor[0.8705882352941177, 0.7215686274509804, 0.5294117647058824], 
        PointBox[{4, 2}]}, 
       {RGBColor[0.7411764705882353, 0.7176470588235294, 0.4196078431372549], 
        PointBox[{4, 1}]}, 
       {RGBColor[
        0.19607843137254902`, 0.803921568627451, 0.19607843137254902`], 
        PointBox[{4, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{5, 4}]}, 
       {RGBColor[1., 0.8941176470588236, 0.8823529411764706], 
        PointBox[{5, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9215686274509803, 0.8431372549019608], 
        PointBox[{5, 2}]}, 
       {RGBColor[1., 1., 0.9411764705882353], PointBox[{5, 1}]}, 
       {RGBColor[0., 1., 0.], PointBox[{5, 0}]}}, {
       {RGBColor[0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
        PointBox[{6, 4}]}, 
       {RGBColor[0.9803921568627451, 0.5019607843137255, 0.4470588235294118], 
        PointBox[{6, 3}]}, 
       {RGBColor[0.8235294117647058, 0.7058823529411765, 0.5490196078431373], 
        PointBox[{6, 2}]}, 
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.8627450980392157], 
        PointBox[{6, 1}]}, 
       {RGBColor[0., 0.5019607843137255, 0.], PointBox[{6, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{7, 4}]}, 
       {RGBColor[1., 0.38823529411764707`, 0.2784313725490196], 
        PointBox[{7, 3}]}, 
       {RGBColor[1., 0.8705882352941177, 0.6784313725490196], 
        PointBox[{7, 2}]}, 
       {RGBColor[1., 1., 0.8784313725490196], PointBox[{7, 1}]}, 
       {RGBColor[0., 0.39215686274509803`, 0.], PointBox[{7, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{8, 4}]}, 
       {RGBColor[
        0.9137254901960784, 0.5882352941176471, 0.47843137254901963`], 
        PointBox[{8, 3}]}, 
       {RGBColor[1., 0.9215686274509803, 0.803921568627451], 
        PointBox[{8, 2}]}, 
       {RGBColor[0.9803921568627451, 0.9803921568627451, 0.8235294117647058], 
        PointBox[{8, 1}]}, 
       {RGBColor[0.1803921568627451, 0.5450980392156862, 0.3411764705882353], 
        PointBox[{8, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{9, 4}]}, 
       {RGBColor[1., 0.4980392156862745, 0.3137254901960784], 
        PointBox[{9, 3}]}, 
       {RGBColor[1., 0.9372549019607843, 0.8352941176470589], 
        PointBox[{9, 2}]}, 
       {RGBColor[1., 1., 0.], PointBox[{9, 1}]}, 
       {RGBColor[
        0.23529411764705882`, 0.7019607843137254, 0.44313725490196076`], 
        PointBox[{9, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{10, 4}]}, 
       {RGBColor[1., 0.27058823529411763`, 0.], PointBox[{10, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7098039215686275], 
        PointBox[{10, 2}]}, 
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.], 
        PointBox[{10, 1}]}, 
       {RGBColor[0., 1., 0.4980392156862745], PointBox[{10, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{11, 4}]}, 
       {RGBColor[1., 0.6274509803921569, 0.47843137254901963`], 
        PointBox[{11, 3}]}, 
       {RGBColor[1., 0.6470588235294118, 0.], PointBox[{11, 2}]}, 
       {RGBColor[
        0.4196078431372549, 0.5568627450980392, 0.13725490196078433`], 
        PointBox[{11, 1}]}, 
       {RGBColor[0.9607843137254902, 1., 0.9803921568627451], 
        PointBox[{11, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{12, 4}]}, 
       {RGBColor[
        0.6274509803921569, 0.3215686274509804, 0.17647058823529413`], 
        PointBox[{12, 3}]}, 
       {RGBColor[0.9607843137254902, 0.8705882352941177, 0.7019607843137254], 
        PointBox[{12, 2}]}, 
       {RGBColor[0.6039215686274509, 0.803921568627451, 0.19607843137254902`],
         PointBox[{12, 1}]}, 
       {RGBColor[0., 0.9803921568627451, 0.6039215686274509], 
        PointBox[{12, 0}]}}, {
       {RGBColor[0., 0., 0.], PointBox[{13, 4}]}, 
       {RGBColor[1., 0.9607843137254902, 0.9333333333333333], 
        PointBox[{13, 3}]}, 
       {RGBColor[0.9921568627450981, 0.9607843137254902, 0.9019607843137255], 
        PointBox[{13, 2}]}, 
       {RGBColor[0.3333333333333333, 0.4196078431372549, 0.1843137254901961], 
        PointBox[{13, 1}]}, 
       {RGBColor[0.4, 0.803921568627451, 0.6666666666666666], 
        PointBox[{13, 0}]}}, {
       {RGBColor[1., 0.9803921568627451, 0.9803921568627451], 
        PointBox[{14, 4}]}, 
       {RGBColor[
        0.8235294117647058, 0.4117647058823529, 0.11764705882352941`], 
        PointBox[{14, 3}]}, 
       {RGBColor[1., 0.9803921568627451, 0.9411764705882353], 
        PointBox[{14, 2}]}, 
       {RGBColor[0.6784313725490196, 1., 0.1843137254901961], 
        PointBox[{14, 1}]}, 
       {RGBColor[0.4980392156862745, 1., 0.8313725490196079], 
        PointBox[{14, 0}]}}, {
       {RGBColor[0.7372549019607844, 0.5607843137254902, 0.5607843137254902], 
        PointBox[{15, 4}]}, 
       {RGBColor[
        0.5450980392156862, 0.27058823529411763`, 0.07450980392156863], 
        PointBox[{15, 3}]}, 
       {RGBColor[
        0.7215686274509804, 0.5254901960784314, 0.043137254901960784`], 
        PointBox[{15, 2}]}, 
       {RGBColor[0.4980392156862745, 1., 0.], PointBox[{15, 1}]}, 
       {RGBColor[
        0.25098039215686274`, 0.8784313725490196, 0.8156862745098039], 
        PointBox[{15, 0}]}}, {
       {RGBColor[0.9411764705882353, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{16, 4}]}, 
       {RGBColor[0.9568627450980393, 0.6431372549019608, 0.3764705882352941], 
        PointBox[{16, 3}]}, 
       {RGBColor[
        0.8549019607843137, 0.6470588235294118, 0.12549019607843137`], 
        PointBox[{16, 2}]}, 
       {RGBColor[0.48627450980392156`, 0.9882352941176471, 0.], 
        PointBox[{16, 1}]}, 
       {RGBColor[
        0.12549019607843137`, 0.6980392156862745, 0.6666666666666666], 
        PointBox[{16, 0}]}}, {
       {RGBColor[0.803921568627451, 0.3607843137254902, 0.3607843137254902], 
        PointBox[{17, 4}]}, 
       {RGBColor[1., 0.8549019607843137, 0.7254901960784313], 
        PointBox[{17, 3}]}, 
       {RGBColor[1., 0.9725490196078431, 0.8627450980392157], 
        PointBox[{17, 2}]}, 
       {RGBColor[0.9411764705882353, 1., 0.9411764705882353], 
        PointBox[{17, 1}]}, 
       {RGBColor[0.2823529411764706, 0.8196078431372549, 0.8], 
        PointBox[{17, 0}]}}, {
       {RGBColor[
        0.6470588235294118, 0.16470588235294117`, 0.16470588235294117`], 
        PointBox[{18, 4}]}, 
       {RGBColor[0.803921568627451, 0.5215686274509804, 0.24705882352941178`],
         PointBox[{18, 3}]}, 
       {RGBColor[1., 0.8431372549019608, 0.], PointBox[{18, 2}]}, 
       {RGBColor[0.5607843137254902, 0.7372549019607844, 0.5607843137254902], 
        PointBox[{18, 1}]}, 
       {RGBColor[0.9411764705882353, 1., 1.], PointBox[{18, 0}]}}},
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{367, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->245561975]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->765786609],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"400", ",", "700"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzN1X8w22ccB/CvcKgKYo7oaUqrvVPSWbtb3Oo8qblipbRdjRSz6LdjWBBT
oTRqZ211K5mmWtqerdNu1rNSVEmISavERqR+xK+UhCDIdFO6stlVn+zydP/3
c/fcfe/1x+f7/d7zfj6PE5N1EDfEMMxgdeGr69/nIN+aHxLv1QJsre5UePoF
FXSCvF0+G1mHhdDxu/vc3t0iA0rL2NZ30pqh24kYVlurewHB2J1QIxZDb30Y
+4el7wBoVF+krhxpg84tcf/4bVcFkOzp7PqR/xt0QUKZt6f1GIgPNKovj5FC
/8vLwdlnSQUSWLXOJhoZ9IRJN4vmWjWIPlEkiN/dC91/L3ud29ZpEHaGEyI9
2w/d+bs6Iz5vBgTxGXM0+QD0F6UF+EDVYiRxEPF0RyIhl456Pn5s/S026njG
6VL3HLR/0ZJF1igmR1xy/AKjMKsP8fDB/Hye+hHi14mpHBfXLsR7MmtauAOt
iLc1GVAjRELEGQl3pIwvq4GNofNlOqkcvPRHu37V/nz55prX6/lpEEQoZmsD
WqC/7LiCH7wqm5eAfPPh566ds9ALMvNxkU83iNnkuphgOgN9S+vTDLJVH9iz
M+1JBX0aulNOuz19xyCIdHwa7c+ahL5ASbtvOj8MDMX9woKzE7pcRvDq1HIF
uBnbYC//XgU9uFxt2eE5CvZbXEvZLBqDXm+6KO8rGANhxG5T3w2j0LcdMylT
jivBUXOTK3Fshe77f7FN0u4eB8O2qUzHS0PQ3eIWipXfToBUwp+ir+Z0ORuh
CRck1pOg8+jfnkRyD3SeUe6B6lNTwOXBurvn6Lp8r6dozb4enAY1lhTraC8J
dFLX1WxfsxnAMbMx95bpzhv5i8BFzGN2zSuhU2jPP7uHz+ntM4a92TTGJRSi
Dvzbee83ox4srbzO06L+orSvrZsd75ZmH7gPrAJO0m+PzOl5D3AqWuEyG3Xu
d4kS6SRQgJ3KTNEb13QekmV/jnRGCUxiSHRH4//0+aSW/zBxAjSZVETI3XX5
FgQdLs0OnQKcGwEZhUd0+ebnut4+cUMDhMlsRR6ugV4Xlty+3DIDNl34SbZM
1eV+yK1OlTU6C7i1qlbWwqTe/2qBop8ieCxUI74k8WNvIE8gTmpKdjmUpEJ8
e1XJSF7bGOLuXG2pT/tjdA6lVMrSwQjiH6pz8Hg1Os/Iy8ST8yXo3Govs/7g
vS7J/3gD4tgr6/Xx/ZhlyK0e9Jx4GHiGVjNQ30yIZQiGZxE3N+SHi5mod0R5
1y81aBA/L5y132E3jXiwQ3EaM0k/N6t3/cYSr9+l+vnAsO0sXw+qxzjih0Tz
b8VeUSKeE6pRUYn6ucGwZs4pCyOefm5W31tMpsltFYhnp0U0RtGGEE+hWj0p
XtTPE4bFjDZv663Tvx8xLPzi5wzrjB7E2d8wCxLjZIg7VGn8o9hSxMXSVEJw
RifiHz0LtCPHdKD7m743XlTShjjpmZfo064HiE9xaLY2xmLE/wEUMxfS
      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{297, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->761902001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61956046],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " returns RGB colors when applied to values within a specific range:"
}], "ExampleText",
 CellID->329853951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "\"\<GrayYellowTones\>\"", "]"}], "[", ".5", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248007193],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.6918275`", ",", "0.7071305`", ",", "0.7518994999999999`"}], 
  "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143233513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "5", "]"}], "[", "7", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->128973281],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
  "0.9764705882352941`", ",", "0.6901960784313725`", ",", 
   "0.3215686274509804`"}], "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97439188]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}], "[", "\"\<WhiteSmoke\>\"", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->691194735],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
  "0.9607843137254902`", ",", "0.9607843137254902`", ",", 
   "0.9607843137254902`"}], "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->329298331]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}], "[", "550", 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->498012876],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0", ",", "1", ",", "0"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->649790941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324439373],

Cell["\<\
Gradients and physical schemes are defined on continuous intervals:\
\>", "ExampleText",
 CellID->105785776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<GrayYellowTones\>\"", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153854290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171602821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "\"\<GrayYellowTones\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298849200],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVUXk81YketY2SF+GiXnZpESmUaugkjfYSMh7KXjRCKI9kulkmy5AoWULT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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->623170911]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", ".5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->916557427],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.6918275`", ",", "0.7071305`", ",", "0.7518994999999999`"}], 
  "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->837397482]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<VisibleSpectrum\>\"", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25937296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"400", ",", "700"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9259876]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->567744040],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"400", ",", "700"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJzN1X8w22ccB/CvcKgKYo7oaUqrvVPSWbtb3Oo8qblipbRdjRSz6LdjWBBT
oTRqZ211K5mmWtqerdNu1rNSVEmISavERqR+xK+UhCDIdFO6stlVn+zydP/3
c/fcfe/1x+f7/d7zfj6PE5N1EDfEMMxgdeGr69/nIN+aHxLv1QJsre5UePoF
FXSCvF0+G1mHhdDxu/vc3t0iA0rL2NZ30pqh24kYVlurewHB2J1QIxZDb30Y
+4el7wBoVF+krhxpg84tcf/4bVcFkOzp7PqR/xt0QUKZt6f1GIgPNKovj5FC
/8vLwdlnSQUSWLXOJhoZ9IRJN4vmWjWIPlEkiN/dC91/L3ud29ZpEHaGEyI9
2w/d+bs6Iz5vBgTxGXM0+QD0F6UF+EDVYiRxEPF0RyIhl456Pn5s/S026njG
6VL3HLR/0ZJF1igmR1xy/AKjMKsP8fDB/Hye+hHi14mpHBfXLsR7MmtauAOt
iLc1GVAjRELEGQl3pIwvq4GNofNlOqkcvPRHu37V/nz55prX6/lpEEQoZmsD
WqC/7LiCH7wqm5eAfPPh566ds9ALMvNxkU83iNnkuphgOgN9S+vTDLJVH9iz
M+1JBX0aulNOuz19xyCIdHwa7c+ahL5ASbtvOj8MDMX9woKzE7pcRvDq1HIF
uBnbYC//XgU9uFxt2eE5CvZbXEvZLBqDXm+6KO8rGANhxG5T3w2j0LcdMylT
jivBUXOTK3Fshe77f7FN0u4eB8O2qUzHS0PQ3eIWipXfToBUwp+ir+Z0ORuh
CRck1pOg8+jfnkRyD3SeUe6B6lNTwOXBurvn6Lp8r6dozb4enAY1lhTraC8J
dFLX1WxfsxnAMbMx95bpzhv5i8BFzGN2zSuhU2jPP7uHz+ntM4a92TTGJRSi
Dvzbee83ox4srbzO06L+orSvrZsd75ZmH7gPrAJO0m+PzOl5D3AqWuEyG3Xu
d4kS6SRQgJ3KTNEb13QekmV/jnRGCUxiSHRH4//0+aSW/zBxAjSZVETI3XX5
FgQdLs0OnQKcGwEZhUd0+ebnut4+cUMDhMlsRR6ugV4Xlty+3DIDNl34SbZM
1eV+yK1OlTU6C7i1qlbWwqTe/2qBop8ieCxUI74k8WNvIE8gTmpKdjmUpEJ8
e1XJSF7bGOLuXG2pT/tjdA6lVMrSwQjiH6pz8Hg1Os/Iy8ST8yXo3Govs/7g
vS7J/3gD4tgr6/Xx/ZhlyK0e9Jx4GHiGVjNQ30yIZQiGZxE3N+SHi5mod0R5
1y81aBA/L5y132E3jXiwQ3EaM0k/N6t3/cYSr9+l+vnAsO0sXw+qxzjih0Tz
b8VeUSKeE6pRUYn6ucGwZs4pCyOefm5W31tMpsltFYhnp0U0RtGGEE+hWj0p
XtTPE4bFjDZv663Tvx8xLPzi5wzrjB7E2d8wCxLjZIg7VGn8o9hSxMXSVEJw
RifiHz0LtCPHdKD7m743XlTShjjpmZfo064HiE9xaLY2xmLE/wEUMxfS
      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{297, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->5776581]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "600", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->853824738],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"1", ",", "0.375227`", ",", "0"}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->549587142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->525522384],

Cell["Indexed schemes are defined at discrete values:", "ExampleText",
 CellID->247486878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"3", ",", "\"\<Range\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248382279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "10", ",", "1"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425603097]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "@@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151981515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291156159]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->148562173],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "10", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[{
      {RGBColor[0., 0., 0.], EdgeForm[Opacity[0.1]], 
       RectangleBox[{1, 0}, Offset[{-1, -1}, {2, 1}]]}, 
      {RGBColor[0.996078431372549, 0.3607843137254902, 0.027450980392156862`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{2, 0}, Offset[{-1, -1}, {3, 1}]]}, 
      {RGBColor[0.996078431372549, 0.9882352941176471, 0.03529411764705882], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{3, 0}, Offset[{-1, -1}, {4, 1}]]}, 
      {RGBColor[
       0.5411764705882353, 0.7137254901960784, 0.027450980392156862`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{4, 0}, Offset[{-1, -1}, {5, 1}]]}, 
      {RGBColor[0.1450980392156863, 0.43529411764705883`, 0.3843137254901961],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{5, 0}, Offset[{-1, -1}, {6, 1}]]}, 
      {RGBColor[0.00784313725490196, 0.5098039215686274, 0.9294117647058824], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{6, 0}, Offset[{-1, -1}, {7, 1}]]}, 
      {RGBColor[
       0.15294117647058825`, 0.11372549019607843`, 0.49019607843137253`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{7, 0}, Offset[{-1, -1}, {8, 1}]]}, 
      {RGBColor[0.47058823529411764`, 0.2627450980392157, 0.5843137254901961],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{8, 0}, Offset[{-1, -1}, {9, 1}]]}, 
      {RGBColor[
       0.8901960784313725, 0.011764705882352941`, 0.49019607843137253`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{9, 0}, Offset[{-1, -1}, {10, 1}]]}, 
      {RGBColor[
       0.9058823529411765, 0.027450980392156862`, 0.12941176470588237`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{10, 0}, Offset[{-1, -1}, {11, 1}]]}},
     AspectRatio->NCache[
       Rational[1, 10], 0.1],
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{294, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->119098904]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->188173227],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
  "0.1450980392156863`", ",", "0.43529411764705883`", ",", 
   "0.3843137254901961`"}], "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->294415627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->562561292],

Cell["Named schemes are defined at specific sets of values:", "ExampleText",
 CellID->217039168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ColorData", "[", 
   RowBox[{"\"\<HTML\>\"", ",", "\"\<Range\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19996527],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"\<\"AliceBlue\"\>", ",", "\<\"AntiqueWhite\"\>", 
     ",", "\<\"Aqua\"\>", ",", 
     RowBox[{"\[LeftSkeleton]", "142", "\[RightSkeleton]"}], 
     ",", "\<\"Yellow\"\>", ",", "\<\"YellowGreen\"\>"}], "}"}], "}"}],
  Short]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->113548993]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "\"\<HTML\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->561975037],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", "\<\"AliceBlue\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "146", "\[RightSkeleton]"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[
     {PointSize[
       Rational[1, 20]], {
       {RGBColor[1., 1., 1.], PointBox[{1, 4}]}, 
       {RGBColor[
        0.6980392156862745, 0.13333333333333333`, 0.13333333333333333`], 
        PointBox[{1, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9411764705882353, 0.9019607843137255], 
        PointBox[{1, 2}]}, 
       {RGBColor[1., 0.9803921568627451, 0.803921568627451], 
        PointBox[{1, 1}]}, 
       {RGBColor[0.596078431372549, 0.984313725490196, 0.596078431372549], 
        PointBox[{1, 0}]}}, {
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.9607843137254902], 
        PointBox[{2, 4}]}, 
       {RGBColor[1., 0., 0.], PointBox[{2, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7686274509803922], 
        PointBox[{2, 2}]}, 
       {RGBColor[0.9411764705882353, 0.9019607843137255, 0.5490196078431373], 
        PointBox[{2, 1}]}, 
       {RGBColor[0.5647058823529412, 0.9333333333333333, 0.5647058823529412], 
        PointBox[{2, 0}]}}, {
       {RGBColor[0.8627450980392157, 0.8627450980392157, 0.8627450980392157], 
        PointBox[{3, 4}]}, 
       {RGBColor[0.5450980392156862, 0., 0.], PointBox[{3, 3}]}, 
       {RGBColor[1., 0.5490196078431373, 0.], PointBox[{3, 2}]}, 
       {RGBColor[0.9333333333333333, 0.9098039215686274, 0.6666666666666666], 
        PointBox[{3, 1}]}, 
       {RGBColor[
        0.13333333333333333`, 0.5450980392156862, 0.13333333333333333`], 
        PointBox[{3, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{4, 4}]}, 
       {RGBColor[0.5019607843137255, 0., 0.], PointBox[{4, 3}]}, 
       {RGBColor[0.8705882352941177, 0.7215686274509804, 0.5294117647058824], 
        PointBox[{4, 2}]}, 
       {RGBColor[0.7411764705882353, 0.7176470588235294, 0.4196078431372549], 
        PointBox[{4, 1}]}, 
       {RGBColor[
        0.19607843137254902`, 0.803921568627451, 0.19607843137254902`], 
        PointBox[{4, 0}]}}, {
       {RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568], 
        PointBox[{5, 4}]}, 
       {RGBColor[1., 0.8941176470588236, 0.8823529411764706], 
        PointBox[{5, 3}]}, 
       {RGBColor[0.9803921568627451, 0.9215686274509803, 0.8431372549019608], 
        PointBox[{5, 2}]}, 
       {RGBColor[1., 1., 0.9411764705882353], PointBox[{5, 1}]}, 
       {RGBColor[0., 1., 0.], PointBox[{5, 0}]}}, {
       {RGBColor[0.7529411764705882, 0.7529411764705882, 0.7529411764705882], 
        PointBox[{6, 4}]}, 
       {RGBColor[0.9803921568627451, 0.5019607843137255, 0.4470588235294118], 
        PointBox[{6, 3}]}, 
       {RGBColor[0.8235294117647058, 0.7058823529411765, 0.5490196078431373], 
        PointBox[{6, 2}]}, 
       {RGBColor[0.9607843137254902, 0.9607843137254902, 0.8627450980392157], 
        PointBox[{6, 1}]}, 
       {RGBColor[0., 0.5019607843137255, 0.], PointBox[{6, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{7, 4}]}, 
       {RGBColor[1., 0.38823529411764707`, 0.2784313725490196], 
        PointBox[{7, 3}]}, 
       {RGBColor[1., 0.8705882352941177, 0.6784313725490196], 
        PointBox[{7, 2}]}, 
       {RGBColor[1., 1., 0.8784313725490196], PointBox[{7, 1}]}, 
       {RGBColor[0., 0.39215686274509803`, 0.], PointBox[{7, 0}]}}, {
       {RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157], 
        PointBox[{8, 4}]}, 
       {RGBColor[
        0.9137254901960784, 0.5882352941176471, 0.47843137254901963`], 
        PointBox[{8, 3}]}, 
       {RGBColor[1., 0.9215686274509803, 0.803921568627451], 
        PointBox[{8, 2}]}, 
       {RGBColor[0.9803921568627451, 0.9803921568627451, 0.8235294117647058], 
        PointBox[{8, 1}]}, 
       {RGBColor[0.1803921568627451, 0.5450980392156862, 0.3411764705882353], 
        PointBox[{8, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{9, 4}]}, 
       {RGBColor[1., 0.4980392156862745, 0.3137254901960784], 
        PointBox[{9, 3}]}, 
       {RGBColor[1., 0.9372549019607843, 0.8352941176470589], 
        PointBox[{9, 2}]}, 
       {RGBColor[1., 1., 0.], PointBox[{9, 1}]}, 
       {RGBColor[
        0.23529411764705882`, 0.7019607843137254, 0.44313725490196076`], 
        PointBox[{9, 0}]}}, {
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{10, 4}]}, 
       {RGBColor[1., 0.27058823529411763`, 0.], PointBox[{10, 3}]}, 
       {RGBColor[1., 0.8941176470588236, 0.7098039215686275], 
        PointBox[{10, 2}]}, 
       {RGBColor[0.5019607843137255, 0.5019607843137255, 0.], 
        PointBox[{10, 1}]}, 
       {RGBColor[0., 1., 0.4980392156862745], PointBox[{10, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{11, 4}]}, 
       {RGBColor[1., 0.6274509803921569, 0.47843137254901963`], 
        PointBox[{11, 3}]}, 
       {RGBColor[1., 0.6470588235294118, 0.], PointBox[{11, 2}]}, 
       {RGBColor[
        0.4196078431372549, 0.5568627450980392, 0.13725490196078433`], 
        PointBox[{11, 1}]}, 
       {RGBColor[0.9607843137254902, 1., 0.9803921568627451], 
        PointBox[{11, 0}]}}, {
       {RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529], 
        PointBox[{12, 4}]}, 
       {RGBColor[
        0.6274509803921569, 0.3215686274509804, 0.17647058823529413`], 
        PointBox[{12, 3}]}, 
       {RGBColor[0.9607843137254902, 0.8705882352941177, 0.7019607843137254], 
        PointBox[{12, 2}]}, 
       {RGBColor[0.6039215686274509, 0.803921568627451, 0.19607843137254902`],
         PointBox[{12, 1}]}, 
       {RGBColor[0., 0.9803921568627451, 0.6039215686274509], 
        PointBox[{12, 0}]}}, {
       {RGBColor[0., 0., 0.], PointBox[{13, 4}]}, 
       {RGBColor[1., 0.9607843137254902, 0.9333333333333333], 
        PointBox[{13, 3}]}, 
       {RGBColor[0.9921568627450981, 0.9607843137254902, 0.9019607843137255], 
        PointBox[{13, 2}]}, 
       {RGBColor[0.3333333333333333, 0.4196078431372549, 0.1843137254901961], 
        PointBox[{13, 1}]}, 
       {RGBColor[0.4, 0.803921568627451, 0.6666666666666666], 
        PointBox[{13, 0}]}}, {
       {RGBColor[1., 0.9803921568627451, 0.9803921568627451], 
        PointBox[{14, 4}]}, 
       {RGBColor[
        0.8235294117647058, 0.4117647058823529, 0.11764705882352941`], 
        PointBox[{14, 3}]}, 
       {RGBColor[1., 0.9803921568627451, 0.9411764705882353], 
        PointBox[{14, 2}]}, 
       {RGBColor[0.6784313725490196, 1., 0.1843137254901961], 
        PointBox[{14, 1}]}, 
       {RGBColor[0.4980392156862745, 1., 0.8313725490196079], 
        PointBox[{14, 0}]}}, {
       {RGBColor[0.7372549019607844, 0.5607843137254902, 0.5607843137254902], 
        PointBox[{15, 4}]}, 
       {RGBColor[
        0.5450980392156862, 0.27058823529411763`, 0.07450980392156863], 
        PointBox[{15, 3}]}, 
       {RGBColor[
        0.7215686274509804, 0.5254901960784314, 0.043137254901960784`], 
        PointBox[{15, 2}]}, 
       {RGBColor[0.4980392156862745, 1., 0.], PointBox[{15, 1}]}, 
       {RGBColor[
        0.25098039215686274`, 0.8784313725490196, 0.8156862745098039], 
        PointBox[{15, 0}]}}, {
       {RGBColor[0.9411764705882353, 0.5019607843137255, 0.5019607843137255], 
        PointBox[{16, 4}]}, 
       {RGBColor[0.9568627450980393, 0.6431372549019608, 0.3764705882352941], 
        PointBox[{16, 3}]}, 
       {RGBColor[
        0.8549019607843137, 0.6470588235294118, 0.12549019607843137`], 
        PointBox[{16, 2}]}, 
       {RGBColor[0.48627450980392156`, 0.9882352941176471, 0.], 
        PointBox[{16, 1}]}, 
       {RGBColor[
        0.12549019607843137`, 0.6980392156862745, 0.6666666666666666], 
        PointBox[{16, 0}]}}, {
       {RGBColor[0.803921568627451, 0.3607843137254902, 0.3607843137254902], 
        PointBox[{17, 4}]}, 
       {RGBColor[1., 0.8549019607843137, 0.7254901960784313], 
        PointBox[{17, 3}]}, 
       {RGBColor[1., 0.9725490196078431, 0.8627450980392157], 
        PointBox[{17, 2}]}, 
       {RGBColor[0.9411764705882353, 1., 0.9411764705882353], 
        PointBox[{17, 1}]}, 
       {RGBColor[0.2823529411764706, 0.8196078431372549, 0.8], 
        PointBox[{17, 0}]}}, {
       {RGBColor[
        0.6470588235294118, 0.16470588235294117`, 0.16470588235294117`], 
        PointBox[{18, 4}]}, 
       {RGBColor[0.803921568627451, 0.5215686274509804, 0.24705882352941178`],
         PointBox[{18, 3}]}, 
       {RGBColor[1., 0.8431372549019608, 0.], PointBox[{18, 2}]}, 
       {RGBColor[0.5607843137254902, 0.7372549019607844, 0.5607843137254902], 
        PointBox[{18, 1}]}, 
       {RGBColor[0.9411764705882353, 1., 1.], PointBox[{18, 0}]}}},
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{367, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19528827]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "\"\<Maroon\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81370030],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.5019607843137255`", ",", "0.`", ",", "0.`"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->138736000]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " from gradients and physical schemes clips values outside of the ranges:"
}], "ExampleText",
 CellID->383772745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "\"\<WatermelonColors\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->475694484],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJxdVXk41YsWdTVSkgxRqSuSikqKHrGkul2zSzelFA0iJJKII27InMiUsaQM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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85760251]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", "#", "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58709814],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3elLFGEcB/DH3dXETK0X7iqWR0lWS4Ug1QuDhCyCDOqFKGRsW+gitqEL
GYgJImUQVkin0RZdWLBE200WRRHdRVJIpXn+FUPNsaPjMzM7exjhPN+FPZ55
5vr8nmeenZ2fu251+er2Nrh8Hrcrb1Oja3+dx92UV+5t5CdZEwghQf5+x0H4
13/4V+I9yHEcX6F6zOAfrfwMFqEkvODEG7EQqU54tirqiDAvf0/VqItkuXSD
7dF1yuVsOsuJ2yHzqRpxqm2qTEiaasocaplk1Ry2GNYyz3BPMqg5ksKsgWju
hRgHkhKKCt0K6i0mK+M3K2KQZrgGKQZmavd0qqxurdjNiZx0VM6NySovTQuM
jbbQkgv+sU25TErMxnCtEZlV1YcN9kNSy2NmkiLOllAfk1stXH2aQX06VS+N
mXrvCtJjaCbxpjXOC/HyyyZi5NSZolhnKr2NKMuqfYyyTB/PrG1ffUTG2rIO
as12qpwZZX221p5GtF9CP+0JPUehUWzLabfbSZkjy5Gdk5WTm51bkJNfuHBx
0aJCZ97SVfnLigucJUtWri0sXl+0ptxZum11WWXJ5l3rKmpLd3g3VB3YWHNo
y57DFZ7j2/edqvSd33nQv7v1al17b8ORQNOxYPPJh62n+9p7XnReft11/W33
rXdnbn+4cO/jpcefrz37cvPl18Cb/uCnbw/6vz8ZGHj+o//pz/ePfr26O9gX
GLrfOxy4MnLj4qj/3NjZ7vETXRNHOyc6Osbb2sZaWkabm0d8vhGvd7i+/ndt
7ZDbPVRTM1hdvWKwqkqzlyAq2lFRjIDyyEm/S7ARCfqdDmqooYYaaqihhhpq
qKGGOl61oJz6rG52LZttDDXUUEMNNdRQQz2b1Ho5UbHMbp5EN49OEBOxQP+l
B70MizHRyndb5APLLt7IcpPFZfrnW+N4sN5HkIlGJhrnHVBDbR41rvFCDTXU
UEMNNdRQQw011FBDDTXUUEMdV042cXKOUAWbV8qRgYwku2RjN6ekm1eTjxmz
Z2PlNKx008rJylHACMJ8LBTvMnSmns2xlM2zDaihhhpqqKGGGmqooYYaaqih
hhpqqKHGXzqz08ZQs66O5HeSGYwKvseHqMxgVMyeiw73zWBhmhUjCUf/uoDY
UdiMCZWNtjA7drB5zgE11FBDDTXUUEMNNdS4qo02hhpqqKGGGmqooYaaFTWy
0JpRQb4VUYn7266s557ROxAV/C41zjqghtq8alzXhhpqqKGGGmqooYYaaqih
hhpqqKGGOrqMATd5bZwQ+r95snulnI6EOBdyKYhLXHExe45W67eqo+8xPfH0
vGlTHNQydqqcGUu9epv6GcawTtVoO8NlzZ76H8um3B+N3iCcSfgnS0HFI0n4
C7xnQfY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29019670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29462639],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorDataFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorDataFunction"]], "InlineFormula"],
 " from indexed schemes repeat the colors periodically:"
}], "ExampleText",
 CellID->10862340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "32", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314865976],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "9", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[{
      {RGBColor[0.4, 0.10196078431372549`, 0.], EdgeForm[Opacity[0.1]], 
       RectangleBox[{1, 0}, Offset[{-1, -1}, {2, 1}]]}, 
      {RGBColor[0.9803921568627451, 0.807843137254902, 0.7333333333333333], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{2, 0}, Offset[{-1, -1}, {3, 1}]]}, 
      {RGBColor[
       0.7490196078431373, 0.43529411764705883`, 0.24705882352941178`], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{3, 0}, Offset[{-1, -1}, {4, 1}]]}, 
      {RGBColor[0.8235294117647058, 0.6039215686274509, 0.34901960784313724`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{4, 0}, Offset[{-1, -1}, {5, 1}]]}, 
      {RGBColor[0.4745098039215686, 0.3607843137254902, 0.11764705882352941`],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{5, 0}, Offset[{-1, -1}, {6, 1}]]}, 
      {RGBColor[0.8352941176470589, 0.7372549019607844, 0.5058823529411764], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{6, 0}, Offset[{-1, -1}, {7, 1}]]}, 
      {RGBColor[1., 0.9098039215686274, 0.6627450980392157], EdgeForm[Opacity[
       0.1]], RectangleBox[{7, 0}, Offset[{-1, -1}, {8, 1}]]}, 
      {RGBColor[0.8588235294117647, 0.9254901960784314, 0.7764705882352941], 
       EdgeForm[Opacity[0.1]], 
       RectangleBox[{8, 0}, Offset[{-1, -1}, {9, 1}]]}, 
      {RGBColor[0.4588235294117647, 0.25098039215686274`, 0.2901960784313726],
        EdgeForm[Opacity[0.1]], 
       RectangleBox[{9, 0}, Offset[{-1, -1}, {10, 1}]]}},
     AspectRatio->NCache[
       Rational[1, 10], 0.1],
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{287, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6873087]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Range", "[", "40", "]"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "f"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", ".3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504322797],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2jEOQUEQxvF9mDmDKMRNKIRE4gASzUaIVwjhKZSu4QbOQKJTKiQqUegU
TqB55slqdBK6/yazmUy+zP4OsG2fDPsjn8Q9X2lO/WQY92aVxnhqo3zknLta
1YvO+tS6V2UjO/msfx13sSv6wzRnlwxKTh+HjezGVT2uOrLoluW0XWp6W8v5
vpd5raWWkY+MWkZCRi0jIaOWEcto2JNlNOz55q33ngJy5MiRI0eOHDly5MiR
I0eOHDly5MiRI0eOHDly5MiRI0eOHDly5MiRI0eOHDnyr+S//HsafrZGT7Tb
lkA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->745906818]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "In a plot with multiple ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " slots, the first slot is chosen, if not specified:"
}], "ExampleText",
 CellID->172166689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659219022],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[RasterBox[CompressedData["
1:eJwVVHk01AsDRaKiT4RUKusj5VU8IukmirI8XtPykp3X9lVk6aOSLPUQoQUV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      "], {{0, 0}, {1, 1}}],
     AspectRatio->NCache[
       Rational[1, 8], 0.125],
     ImageSize->65,
     PlotRange->{{0, 1}, {0, 1}}],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{269, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7693837]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", " ", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "f"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322159018],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx9WntwVfURjiGMFGhtfaH4ABRpdCxVq6BV+dCKYEet7whqBUSsFtRW7JRW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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxVmgnY1mO6wP/PG0m2lBakVaJG9am073vahJAOLWSmQoPszYwxmHNsMzkh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        "]]]}, {}, {}, {}}, 
    {Hue[0.67, 0.6, 0.6], 
     Line3DBox[{525, 1, 477, 249, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
      166, 181, 196, 381, 545, 211, 523, 454, 212, 213, 214, 215, 216, 217, 
      218, 219, 220, 221, 222, 223, 224, 383, 546, 225, 524, 455, 210, 195, 
      180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 259, 526, 15, 503, 
      389, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 384, 525}]}},
   VertexColors->CompressedData["
1:eJztmetPlFcQxldRQMRiUClarS0XSVGriFKN4IMUBQRvFC8VgYL1lpYgNWIo
UMHV1FABrdqCgKhNrSKRIOCFW1FApKIuLJd1RVhYdl+Wi4XWtFVQ6z8wHyZ5
iZq8XyCZnLxn5ndmnplz9sOwCP+tI2Uymf+rP0av/g94l7hmzmyFS253jpWq
GNqXyefXPNIgyz/Mel6gElusXbwPjL4Bdez0u02lOkSv9NuY+eA+5nwVlpDb
pUCAbVR2qZkB25+6yqsXKfCsZYWTZ4oaGe4NrlV9Bvg16RqLY+uR5oWMytB2
PDt+WmZ+qAt7rBV+ly2b8KuX5cjCDZ2Q5yU4Rx3U4dpQpcccjRpmu9xq0qHH
UHJ7XlZVO1qKjeMM4Ros9baamxAoIEAXs9xmfgt8P6sYUmm1OF99xXzhHQHR
xVmNxjuaMP9MYubsUAHH/1zfbHtUQErqFFurb+rhc1Z1eHxINyy8Uu2UYXp0
73LeZGaiQLj9Jz6Ra3thsmZ167KHWpgEJWxTKmrxwnKeZWtbL+4tmVT47442
WJ36OTEpugad1r4ndrr0wu/bqV4fuzZg7pgTMe7vV6G71s0uNqIHZ9Mcmife
Lkf1l5EvjxrKIXGWOEucJc4SZ4mzxFniLHGWOEucJc4SZ4mzxFniLHGWOEuc
3xzOK8tzj9qZ1iHnhWlFvH0bPB7b+K29ZMD1/hFx7RMa4Dhjd7ijhRZrUi+P
D3YTsE/+T7f2TA8eB8nLnkTpoEgruFDkdQ8W2vyFNkH3keabfSVd04jgrP9y
I/QG0b4fP/XIpx7NvfhoYHFigUUHQiy3L2vwvCPavmWC3M5plAFmgU7T788S
gMA/rjmMrRt2f8TaV6zvT0yas3nTKhW6Dsb6O9qU4oT50iPlX2jJeqR4Uvaa
yG2LatercLJw3R31dh1KjVx3tl/WknbvZSGykLuP0DVWc3GySo/K3xOPDKra
SLuPr67P1KEDVjK7ddYZAnIOzGz/wfkBaX/P8dbTdEUPCp7onUN+qYWqu1+5
d+gmu164+caNl8orSt+o9ZTuieV/RIYy+/MZdZicU+Rr23Ub9e/Kx2h+E9j6
PNz+U/nwTlWWruiiDrvLVDEDVQLOXgttLlzcQNYRVS9icaDi5eY/Ny6ubnD1
hOLD1U9uHVHrKW7UdyieYvEfbp5c3abmH4onNRdRPKl5SSyee0qq9rtn92Jv
5Jldi6apsbn/XEbe19Wk/nM5i9UX3hbO1BzC5SwWH+4czp2vuHFxdYmcW4h7
AZXn1H2BipeKi+JAxSvWnEPlG6m3bxgf7vz5uuISa64Wa16i7hdUvnF1W6z8
5N4jxJpPuO8J1DuJWO8V3LlFrHebt6U/Djef4c5nblzUuxMV13Dfl7lxcd/T
uP6L9Y4n1vvkcO/L5cztp2LV3evqd9T70oiePbWDrg+RcjJ/3wdxJXAz3pFh
Or0D8sERFuanezDX6/vRRYW3oHDIM4z6+wbpJ3Xvc786qSwu/QHqf/RZUazU
IagmOcm9pIO0xwe7PE8NaMMkx8Hwu5MFHPaX9yQbt+KYUdSC6BXtmGmXebM2
RsDLAuWE5nw1uZ6yy44FnEs10kLWki1sKRGwIUB+yT2/mbRTeULZuX5S66k8
oeqLe47U/EP1XyoPuec7ftYhI/vlLSjpqzRs/UmP76xqphQ0aki7WDy55z77
sNNATXUnxlV4VR6/LcC8KH5969pG0i5WvJTuUf1IrHrhcuPyofKQ6w/FjaoX
yn/uvYm7L2Wn4uL6Q3Gm9uX6T+1L8aT0h9t3qPXcuZryn1sX1L7cfkd9h9un
KH3ufz5OfTFFD9X1nc6rKgQsuOqxMcleyV5P2Sn/KTvVXygdoOYZqu9w+xT3
d0Bqrqb02X/W1YIpls0IU4X6PRvsxLQlBs/9FzpJnlQ9UjzF6juUn9S+XP3n
1iNX/7k6wD0v7npuXGLVHcWHymeu/lP1GO1pEpo7rwur7T1jngYLEKL/6jtV
VsfWGa7uUZypc6Hs1L7/A0378bM=
    "],
   VertexNormals->CompressedData["
1:eJx1Wnl8z9fSjqKWWEuUXrSxXvu+xNKnqlX7JSR2tTTqWkqLNkVLFa0UtVxr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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 ImageSize->{184, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86802752,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Specify a pure function so that the plot is colored by height values:\
\>", "ExampleText",
 CellID->650163907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", " ", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"f", "[", "z", "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->381358654],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx9WntwVfURjiGMFGhtfaH4ABRpdCxVq6BV+dCKYEet7whqBUSsFtRW7JRW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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxVmgnY1mO6wP/PG0m2lBakVaJG9am073vahJAOLWSmQoPszYwxmHNsMzkh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        "]]]}, {}, {}, {}}, 
    {Hue[0.67, 0.6, 0.6], 
     Line3DBox[{525, 1, 477, 249, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
      166, 181, 196, 381, 545, 211, 523, 454, 212, 213, 214, 215, 216, 217, 
      218, 219, 220, 221, 222, 223, 224, 383, 546, 225, 524, 455, 210, 195, 
      180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 259, 526, 15, 503, 
      389, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 384, 525}]}},
   VertexColors->CompressedData["
1:eJztWGs01XkX7n5TSrdxq8iEJiSDbngql640SSOpFFK9lFSM0MVEl1GmIpIi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    "],
   VertexNormals->CompressedData["
1:eJx1Wnl8z9fSjqKWWEuUXrSxXvu+xNKnqlX7JSR2tTTqWkqLNkVLFa0UtVxr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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 ImageSize->{184, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->63463047,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["A raster image of the web safe colors:", "ExampleText",
 CellID->242950614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"ColorData", "[", "\"\<WebSafe\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333684531],

Cell[BoxData[
 RowBox[{"ColorDataFunction", "[", 
  RowBox[{"{", "\<\"#FFFFFF\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "215", "\[RightSkeleton]"}], "}"}], ",", 
  PanelBox[
   StyleBox[
    GraphicsBox[
     {PointSize[
       Rational[1, 20]], {
       {RGBColor[1., 1., 1.], PointBox[{1, 4}]}, 
       {RGBColor[1., 0.4, 1.], PointBox[{1, 3}]}, 
       {RGBColor[0.8, 1., 1.], PointBox[{1, 2}]}, 
       {RGBColor[0.8, 0.4, 1.], PointBox[{1, 1}]}, 
       {RGBColor[0.6, 1., 1.], PointBox[{1, 0}]}}, {
       {RGBColor[1., 1., 0.8], PointBox[{2, 4}]}, 
       {RGBColor[1., 0.4, 0.8], PointBox[{2, 3}]}, 
       {RGBColor[0.8, 1., 0.8], PointBox[{2, 2}]}, 
       {RGBColor[0.8, 0.4, 0.8], PointBox[{2, 1}]}, 
       {RGBColor[0.6, 1., 0.8], PointBox[{2, 0}]}}, {
       {RGBColor[1., 1., 0.6], PointBox[{3, 4}]}, 
       {RGBColor[1., 0.4, 0.6], PointBox[{3, 3}]}, 
       {RGBColor[0.8, 1., 0.6], PointBox[{3, 2}]}, 
       {RGBColor[0.8, 0.4, 0.6], PointBox[{3, 1}]}, 
       {RGBColor[0.6, 1., 0.6], PointBox[{3, 0}]}}, {
       {RGBColor[1., 1., 0.4], PointBox[{4, 4}]}, 
       {RGBColor[1., 0.4, 0.4], PointBox[{4, 3}]}, 
       {RGBColor[0.8, 1., 0.4], PointBox[{4, 2}]}, 
       {RGBColor[0.8, 0.4, 0.4], PointBox[{4, 1}]}, 
       {RGBColor[0.6, 1., 0.4], PointBox[{4, 0}]}}, {
       {RGBColor[1., 1., 0.2], PointBox[{5, 4}]}, 
       {RGBColor[1., 0.4, 0.2], PointBox[{5, 3}]}, 
       {RGBColor[0.8, 1., 0.2], PointBox[{5, 2}]}, 
       {RGBColor[0.8, 0.4, 0.2], PointBox[{5, 1}]}, 
       {RGBColor[0.6, 1., 0.2], PointBox[{5, 0}]}}, {
       {RGBColor[1., 1., 0.], PointBox[{6, 4}]}, 
       {RGBColor[1., 0.4, 0.], PointBox[{6, 3}]}, 
       {RGBColor[0.8, 1., 0.], PointBox[{6, 2}]}, 
       {RGBColor[0.8, 0.4, 0.], PointBox[{6, 1}]}, 
       {RGBColor[0.6, 1., 0.], PointBox[{6, 0}]}}, {
       {RGBColor[1., 0.8, 1.], PointBox[{7, 4}]}, 
       {RGBColor[1., 0.2, 1.], PointBox[{7, 3}]}, 
       {RGBColor[0.8, 0.8, 1.], PointBox[{7, 2}]}, 
       {RGBColor[0.8, 0.2, 1.], PointBox[{7, 1}]}, 
       {RGBColor[0.6, 0.8, 1.], PointBox[{7, 0}]}}, {
       {RGBColor[1., 0.8, 0.8], PointBox[{8, 4}]}, 
       {RGBColor[1., 0.2, 0.8], PointBox[{8, 3}]}, 
       {RGBColor[0.8, 0.8, 0.8], PointBox[{8, 2}]}, 
       {RGBColor[0.8, 0.2, 0.8], PointBox[{8, 1}]}, 
       {RGBColor[0.6, 0.8, 0.8], PointBox[{8, 0}]}}, {
       {RGBColor[1., 0.8, 0.6], PointBox[{9, 4}]}, 
       {RGBColor[1., 0.2, 0.6], PointBox[{9, 3}]}, 
       {RGBColor[0.8, 0.8, 0.6], PointBox[{9, 2}]}, 
       {RGBColor[0.8, 0.2, 0.6], PointBox[{9, 1}]}, 
       {RGBColor[0.6, 0.8, 0.6], PointBox[{9, 0}]}}, {
       {RGBColor[1., 0.8, 0.4], PointBox[{10, 4}]}, 
       {RGBColor[1., 0.2, 0.4], PointBox[{10, 3}]}, 
       {RGBColor[0.8, 0.8, 0.4], PointBox[{10, 2}]}, 
       {RGBColor[0.8, 0.2, 0.4], PointBox[{10, 1}]}, 
       {RGBColor[0.6, 0.8, 0.4], PointBox[{10, 0}]}}, {
       {RGBColor[1., 0.8, 0.2], PointBox[{11, 4}]}, 
       {RGBColor[1., 0.2, 0.2], PointBox[{11, 3}]}, 
       {RGBColor[0.8, 0.8, 0.2], PointBox[{11, 2}]}, 
       {RGBColor[0.8, 0.2, 0.2], PointBox[{11, 1}]}, 
       {RGBColor[0.6, 0.8, 0.2], PointBox[{11, 0}]}}, {
       {RGBColor[1., 0.8, 0.], PointBox[{12, 4}]}, 
       {RGBColor[1., 0.2, 0.], PointBox[{12, 3}]}, 
       {RGBColor[0.8, 0.8, 0.], PointBox[{12, 2}]}, 
       {RGBColor[0.8, 0.2, 0.], PointBox[{12, 1}]}, 
       {RGBColor[0.6, 0.8, 0.], PointBox[{12, 0}]}}, {
       {RGBColor[1., 0.6, 1.], PointBox[{13, 4}]}, 
       {RGBColor[1., 0., 1.], PointBox[{13, 3}]}, 
       {RGBColor[0.8, 0.6, 1.], PointBox[{13, 2}]}, 
       {RGBColor[0.8, 0., 1.], PointBox[{13, 1}]}, 
       {RGBColor[0.6, 0.6, 1.], PointBox[{13, 0}]}}, {
       {RGBColor[1., 0.6, 0.8], PointBox[{14, 4}]}, 
       {RGBColor[1., 0., 0.8], PointBox[{14, 3}]}, 
       {RGBColor[0.8, 0.6, 0.8], PointBox[{14, 2}]}, 
       {RGBColor[0.8, 0., 0.8], PointBox[{14, 1}]}, 
       {RGBColor[0.6, 0.6, 0.8], PointBox[{14, 0}]}}, {
       {RGBColor[1., 0.6, 0.6], PointBox[{15, 4}]}, 
       {RGBColor[1., 0., 0.6], PointBox[{15, 3}]}, 
       {RGBColor[0.8, 0.6, 0.6], PointBox[{15, 2}]}, 
       {RGBColor[0.8, 0., 0.6], PointBox[{15, 1}]}, 
       {RGBColor[0.6, 0.6, 0.6], PointBox[{15, 0}]}}, {
       {RGBColor[1., 0.6, 0.4], PointBox[{16, 4}]}, 
       {RGBColor[1., 0., 0.4], PointBox[{16, 3}]}, 
       {RGBColor[0.8, 0.6, 0.4], PointBox[{16, 2}]}, 
       {RGBColor[0.8, 0., 0.4], PointBox[{16, 1}]}, 
       {RGBColor[0.6, 0.6, 0.4], PointBox[{16, 0}]}}, {
       {RGBColor[1., 0.6, 0.2], PointBox[{17, 4}]}, 
       {RGBColor[1., 0., 0.2], PointBox[{17, 3}]}, 
       {RGBColor[0.8, 0.6, 0.2], PointBox[{17, 2}]}, 
       {RGBColor[0.8, 0., 0.2], PointBox[{17, 1}]}, 
       {RGBColor[0.6, 0.6, 0.2], PointBox[{17, 0}]}}, {
       {RGBColor[1., 0.6, 0.], PointBox[{18, 4}]}, 
       {RGBColor[1., 0., 0.], PointBox[{18, 3}]}, 
       {RGBColor[0.8, 0.6, 0.], PointBox[{18, 2}]}, 
       {RGBColor[0.8, 0., 0.], PointBox[{18, 1}]}, 
       {RGBColor[0.6, 0.6, 0.], PointBox[{18, 0}]}}},
     ImageSize->65,
     PlotRangePadding->None],
    StripOnInput->False,
    CacheGraphics->False],
   FrameMargins->5], "]"}]], "Output",
 ImageSize->{353, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137123311]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"First", "@", 
       RowBox[{"ColorData", "[", 
        RowBox[{"\"\<WebSafe\>\"", ",", "\"\<Range\>\""}], "]"}]}], ",", 
      "18"}], "]"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "f"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65231215],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2jFuk2EQBNCNUCrc0FHmDnsHqDiEFWWVFAgUcpm9014iJzHP7qFBSH+x
xTjW6Mt0+yp/O789P30/v708nh++vp5/Pr88/nr48uNV9eEuIt6lP4fvF99u
eb9c/P3T5yefp8tlpKUkJU6X0c98vIx+9KMffevb+9a3vvUd97u2a7v239bu
b2t1jRflRXlRXpT/TH1aTH3qU5/60If3oQ996GMXd3EXj7Q4t4y0lKTEaUgx
pBhSDCmGFEOKIcWQYkgxpBhSTO/iLu7ioRbrGi9IMaQYUgwphhRDiiHFkGJI
MaQYUgwphhRDiiHFxC7u4i4eabFvGWkpSYlTk6JJ0aRoUjQpmhRNiiZFk6JJ
0aTo3sVd3MVDLdY1XpCiSdGkaFI0KZoUTYomRZOiSdGkaFI0KZoUTYqOXdzF
XTzSYt0y0lKSEqciRZGiSFGkKFIUKYoURYoiRZGiSFG9i7u4i/+wWNd44a7L
XZe7Lndd7rrcdbnrctflrstdl7sud13uutx1ueuKXdzFXTzSYt4y0lKSEqck
RZIiSZGkSFIkKZIUSYokRZIiSZG9i7u4i4darGu8IEWSIkmRpEhSJCmSFEmK
JEWSIkmRpEhSJCmSFBm7uIu7eKTFuGWkpSQlTkGKIEWQIkgRpAhSBCmCFEGK
IEWQInoXd3EXD7VY13hBiiBFkCJIEaQIUgQpghRBiiBFkCJIEaQIUgQpInZx
F3fxIIt//+123P0Gb93pWQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->322567560]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColorDataFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 28, 59.5406780}", "context" -> "System`", 
    "keywords" -> {
     "color function", "color data function", "color data", "color map", 
      "color gradient", "color interpolating function"}, "index" -> True, 
    "label" -> "Mathematica Symbol", "language" -> "en", "paclet" -> "", 
    "status" -> "None", "summary" -> 
    "ColorDataFunction[range, ...] is a function that represents a color \
scheme. ", "synonyms" -> {}, "title" -> "ColorDataFunction", "type" -> 
    "Symbol", "uri" -> "ref/ColorDataFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3969, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->612187803]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 597078, 10756}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 905, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1528, 46, 60, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1591, 49, 579, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2207, 71, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2685, 88, 327, 12, 70, "Notes",
 CellID->1067943069],
Cell[3015, 102, 507, 16, 70, "Notes",
 CellID->11074023],
Cell[3525, 120, 407, 14, 70, "Notes",
 CellID->171644141]
}, Closed]],
Cell[CellGroupData[{
Cell[3969, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->612187803],
Cell[CellGroupData[{
Cell[4354, 153, 148, 5, 70, "ExampleSection",
 CellID->190403285],
Cell[4505, 160, 340, 12, 70, "ExampleText",
 CellID->166637215],
Cell[CellGroupData[{
Cell[4870, 176, 131, 3, 28, "Input",
 CellID->124719916],
Cell[5004, 181, 3699, 71, 48, "Output",
 CellID->312481082]
}, Open  ]],
Cell[8718, 255, 125, 3, 70, "ExampleDelimiter",
 CellID->436431886],
Cell[8846, 260, 98, 1, 70, "ExampleText",
 CellID->96747207],
Cell[CellGroupData[{
Cell[8969, 265, 139, 4, 70, "Input",
 CellID->445192393],
Cell[9111, 271, 9201, 194, 70, "Output",
 CellID->556387637]
}, Open  ]],
Cell[CellGroupData[{
Cell[18349, 470, 109, 3, 70, "Input",
 CellID->546472958],
Cell[18461, 475, 247, 7, 36, "Output",
 CellID->33147540]
}, Open  ]],
Cell[18723, 485, 125, 3, 70, "ExampleDelimiter",
 CellID->199419762],
Cell[18851, 490, 80, 1, 70, "ExampleText",
 CellID->487966323],
Cell[CellGroupData[{
Cell[18956, 495, 146, 4, 70, "Input",
 CellID->164649404],
Cell[19105, 501, 3423, 67, 70, "Output",
 CellID->183614342]
}, Open  ]],
Cell[CellGroupData[{
Cell[22565, 573, 483, 16, 70, "Input",
 CellID->272577028],
Cell[23051, 591, 401477, 6645, 70, "Output",
 CellID->531773076]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[424577, 7242, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[424801, 7251, 340, 12, 70, "ExampleText",
 CellID->610447763],
Cell[CellGroupData[{
Cell[425166, 7267, 127, 3, 70, "Input",
 CellID->588619454],
Cell[425296, 7272, 3720, 72, 70, "Output",
 CellID->137657384]
}, Open  ]],
Cell[CellGroupData[{
Cell[429053, 7349, 105, 3, 70, "Input",
 CellID->66291465],
Cell[429161, 7354, 2224, 52, 70, "Output",
 CellID->597745344]
}, Open  ]],
Cell[CellGroupData[{
Cell[431422, 7411, 116, 3, 70, "Input",
 CellID->240614921],
Cell[431541, 7416, 9201, 194, 70, "Output",
 CellID->245561975]
}, Open  ]],
Cell[CellGroupData[{
Cell[440779, 7615, 127, 3, 70, "Input",
 CellID->765786609],
Cell[440909, 7620, 2064, 44, 70, "Output",
 CellID->761902001]
}, Open  ]],
Cell[442988, 7667, 124, 3, 70, "ExampleDelimiter",
 CellID->61956046],
Cell[443115, 7672, 262, 7, 70, "ExampleText",
 CellID->329853951],
Cell[CellGroupData[{
Cell[443402, 7683, 159, 5, 70, "Input",
 CellID->248007193],
Cell[443564, 7690, 265, 8, 36, "Output",
 CellID->143233513]
}, Open  ]],
Cell[CellGroupData[{
Cell[443866, 7703, 133, 4, 70, "Input",
 CellID->128973281],
Cell[444002, 7709, 286, 9, 36, "Output",
 CellID->97439188]
}, Open  ]],
Cell[CellGroupData[{
Cell[444325, 7723, 164, 5, 70, "Input",
 CellID->691194735],
Cell[444492, 7730, 287, 9, 36, "Output",
 CellID->329298331]
}, Open  ]],
Cell[CellGroupData[{
Cell[444816, 7744, 160, 5, 70, "Input",
 CellID->498012876],
Cell[444979, 7751, 226, 7, 36, "Output",
 CellID->649790941]
}, Open  ]],
Cell[445220, 7761, 125, 3, 70, "ExampleDelimiter",
 CellID->324439373],
Cell[445348, 7766, 118, 3, 70, "ExampleText",
 CellID->105785776],
Cell[CellGroupData[{
Cell[445491, 7773, 162, 4, 70, "Input",
 CellID->153854290],
Cell[445656, 7779, 203, 7, 36, "Output",
 CellID->171602821]
}, Open  ]],
Cell[CellGroupData[{
Cell[445896, 7791, 150, 4, 70, "Input",
 CellID->298849200],
Cell[446049, 7797, 3720, 72, 70, "Output",
 CellID->623170911]
}, Open  ]],
Cell[CellGroupData[{
Cell[449806, 7874, 98, 3, 70, "Input",
 CellID->916557427],
Cell[449907, 7879, 265, 8, 36, "Output",
 CellID->837397482]
}, Open  ]],
Cell[CellGroupData[{
Cell[450209, 7892, 161, 4, 70, "Input",
 CellID->25937296],
Cell[450373, 7898, 205, 7, 36, "Output",
 CellID->9259876]
}, Open  ]],
Cell[CellGroupData[{
Cell[450615, 7910, 150, 4, 70, "Input",
 CellID->567744040],
Cell[450768, 7916, 2062, 44, 70, "Output",
 CellID->5776581]
}, Open  ]],
Cell[CellGroupData[{
Cell[452867, 7965, 99, 3, 70, "Input",
 CellID->853824738],
Cell[452969, 7970, 234, 7, 36, "Output",
 CellID->549587142]
}, Open  ]],
Cell[453218, 7980, 125, 3, 70, "ExampleDelimiter",
 CellID->525522384],
Cell[453346, 7985, 90, 1, 70, "ExampleText",
 CellID->247486878],
Cell[CellGroupData[{
Cell[453461, 7990, 140, 4, 70, "Input",
 CellID->248382279],
Cell[453604, 7996, 214, 7, 36, "Output",
 CellID->425603097]
}, Open  ]],
Cell[CellGroupData[{
Cell[453855, 8008, 97, 3, 70, "Input",
 CellID->151981515],
Cell[453955, 8013, 292, 9, 36, "Output",
 CellID->291156159]
}, Open  ]],
Cell[CellGroupData[{
Cell[454284, 8027, 128, 4, 70, "Input",
 CellID->148562173],
Cell[454415, 8033, 2163, 51, 70, "Output",
 CellID->119098904]
}, Open  ]],
Cell[CellGroupData[{
Cell[456615, 8089, 97, 3, 70, "Input",
 CellID->188173227],
Cell[456715, 8094, 288, 9, 36, "Output",
 CellID->294415627]
}, Open  ]],
Cell[457018, 8106, 125, 3, 70, "ExampleDelimiter",
 CellID->562561292],
Cell[457146, 8111, 96, 1, 70, "ExampleText",
 CellID->217039168],
Cell[CellGroupData[{
Cell[457267, 8116, 183, 5, 70, "Input",
 CellID->19996527],
Cell[457453, 8123, 443, 13, 36, "Output",
 CellID->113548993]
}, Open  ]],
Cell[CellGroupData[{
Cell[457933, 8141, 139, 4, 70, "Input",
 CellID->561975037],
Cell[458075, 8147, 9200, 194, 70, "Output",
 CellID->19528827]
}, Open  ]],
Cell[CellGroupData[{
Cell[467312, 8346, 109, 3, 70, "Input",
 CellID->81370030],
Cell[467424, 8351, 248, 7, 36, "Output",
 CellID->138736000]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[467721, 8364, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[467962, 8373, 267, 7, 70, "ExampleText",
 CellID->383772745],
Cell[CellGroupData[{
Cell[468254, 8384, 151, 4, 70, "Input",
 CellID->475694484],
Cell[468408, 8390, 3702, 71, 70, "Output",
 CellID->85760251]
}, Open  ]],
Cell[CellGroupData[{
Cell[472147, 8466, 471, 14, 70, "Input",
 CellID->58709814],
Cell[472621, 8482, 1623, 31, 70, "Output",
 Evaluatable->False,
 CellID->29019670]
}, Open  ]],
Cell[474259, 8516, 124, 3, 70, "ExampleDelimiter",
 CellID->29462639],
Cell[474386, 8521, 247, 7, 70, "ExampleText",
 CellID->10862340],
Cell[CellGroupData[{
Cell[474658, 8532, 129, 4, 70, "Input",
 CellID->314865976],
Cell[474790, 8538, 1945, 44, 70, "Output",
 CellID->6873087]
}, Open  ]],
Cell[CellGroupData[{
Cell[476772, 8587, 343, 9, 70, "Input",
 CellID->504322797],
Cell[477118, 8598, 573, 14, 70, "Output",
 Evaluatable->False,
 CellID->745906818]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[477740, 8618, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[477974, 8627, 267, 8, 70, "ExampleText",
 CellID->172166689],
Cell[CellGroupData[{
Cell[478266, 8639, 142, 4, 70, "Input",
 CellID->659219022],
Cell[478411, 8645, 3722, 72, 70, "Output",
 CellID->7693837]
}, Open  ]],
Cell[CellGroupData[{
Cell[482170, 8722, 583, 17, 70, "Input",
 CellID->322159018],
Cell[482756, 8741, 49775, 828, 175, 20944, 351, "CachedBoxData", "BoxData", \
"Output",
 CellID->86802752]
}, Open  ]],
Cell[532546, 9572, 120, 3, 70, "ExampleText",
 CellID->650163907],
Cell[CellGroupData[{
Cell[532691, 9579, 743, 22, 70, "Input",
 CellID->381358654],
Cell[533437, 9603, 53866, 895, 175, 23205, 388, "CachedBoxData", "BoxData", \
"Output",
 CellID->63463047]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[587352, 10504, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[587583, 10513, 81, 1, 70, "ExampleText",
 CellID->242950614],
Cell[CellGroupData[{
Cell[587689, 10518, 142, 4, 70, "Input",
 CellID->333684531],
Cell[587834, 10524, 5273, 108, 70, "Output",
 CellID->137123311]
}, Open  ]],
Cell[CellGroupData[{
Cell[593144, 10637, 402, 12, 70, "Input",
 CellID->65231215],
Cell[593549, 10651, 1021, 21, 70, "Output",
 Evaluatable->False,
 CellID->322567560]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[594631, 10679, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[594950, 10690, 977, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[595942, 10728, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

