(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57187,       1211]
NotebookOptionsPosition[     53703,       1100]
NotebookOutlinePosition[     55234,       1141]
CellTagsIndexPosition[     55148,       1136]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Density and Contour Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DensityAndContourPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Density and Contour Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ColorFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Plotting Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ColorFunctionScaling", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ColorFunctionScaling",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions which specifies \
whether arguments supplied to a color function should be scaled to lie \
between 0 and 1. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16163]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The usual default setting is ",
 Cell[BoxData[
  RowBox[{"ColorFunctionScaling", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16248],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ColorFunctionScaling", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " original unscaled values are fed to the color function. "
}], "Notes",
 CellID->4290],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ColorFunctionScaling", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " takes ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to specify whether to scale argument ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " of the color function. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30004],

Cell[TextData[{
 "Scaling is done so as to make the minimum and maximum values displayed with \
the current setting for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " be 0 and 1. "
}], "Notes",
 CellID->4442]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145141829],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->208491689],

Cell[TextData[{
 "Parameters to ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are normally scaled to be between 0 and 1:"
}], "ExampleText",
 CellID->357019757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "[", "z", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361746181],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483720449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1072649672],

Cell["Use unscaled coordinates:", "ExampleText",
 CellID->1595066372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Mod", "[", 
        RowBox[{"z", ",", "1"}], "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1242148703],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66412380]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25772],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10536],

Cell[TextData[ButtonBox["Density and Contour Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DensityAndContourPlots"]], "Tutorials",
 CellID->748]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ColorFunctionScaling",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
ColorFunctionScaling"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->372197491],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->24820179]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColorFunctionScaling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 25.7757246}", "context" -> "System`", 
    "keywords" -> {
     "color values", "truncate values", "scaling of color function arguments",
       "scaling of color map arguments", "color function arguments", 
      "color map arguments"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ColorFunctionScaling is an option for graphics functions which specifies \
whether arguments supplied to a color function should be scaled to lie \
between 0 and 1. ", "synonyms" -> {"color function scaling"}, "title" -> 
    "ColorFunctionScaling", "type" -> "Symbol", "uri" -> 
    "ref/ColorFunctionScaling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9234, 259, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->145141829]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55005, 1129}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1762, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2385, 74, 4204, 83, 70, "ObjectNameGrid"],
Cell[6592, 159, 551, 15, 70, "Usage",
 CellID->16163]
}, Open  ]],
Cell[CellGroupData[{
Cell[7180, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7658, 196, 241, 9, 70, "Notes",
 CellID->16248],
Cell[7902, 207, 273, 9, 70, "Notes",
 CellID->4290],
Cell[8178, 218, 728, 25, 70, "Notes",
 CellID->30004],
Cell[8909, 245, 288, 9, 70, "Notes",
 CellID->4442]
}, Closed]],
Cell[CellGroupData[{
Cell[9234, 259, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145141829],
Cell[CellGroupData[{
Cell[9619, 273, 148, 5, 70, "ExampleSection",
 CellID->208491689],
Cell[9770, 280, 249, 8, 70, "ExampleText",
 CellID->357019757],
Cell[CellGroupData[{
Cell[10044, 292, 491, 15, 28, "Input",
 CellID->361746181],
Cell[10538, 309, 16032, 267, 168, "Output",
 Evaluatable->False,
 CellID->483720449]
}, Open  ]],
Cell[26585, 579, 126, 3, 70, "ExampleDelimiter",
 CellID->1072649672],
Cell[26714, 584, 69, 1, 70, "ExampleText",
 CellID->1595066372],
Cell[CellGroupData[{
Cell[26808, 589, 619, 18, 47, "Input",
 CellID->1242148703],
Cell[27430, 609, 23859, 395, 168, "Output",
 Evaluatable->False,
 CellID->66412380]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51350, 1011, 311, 9, 70, "SeeAlsoSection",
 CellID->25772],
Cell[51664, 1022, 206, 6, 70, "SeeAlso",
 CellID->21244]
}, Open  ]],
Cell[CellGroupData[{
Cell[51907, 1033, 314, 9, 70, "TutorialsSection",
 CellID->10536],
Cell[52224, 1044, 156, 3, 70, "Tutorials",
 CellID->748]
}, Open  ]],
Cell[CellGroupData[{
Cell[52417, 1052, 305, 8, 70, "RelatedLinksSection"],
Cell[52725, 1062, 382, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53144, 1079, 319, 9, 70, "MoreAboutSection",
 CellID->372197491],
Cell[53466, 1090, 142, 3, 70, "MoreAbout",
 CellID->24820179]
}, Open  ]],
Cell[53623, 1096, 50, 0, 70, "History"],
Cell[53676, 1098, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

