(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29643,       1000]
NotebookOptionsPosition[     24173,        812]
NotebookOutlinePosition[     25567,        850]
CellTagsIndexPosition[     25482,        845]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ColorFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Image Processing\"\>", 
       3->"\<\"Plotting Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ColorRules", "ObjectName",
 CellID->28984],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ColorRules",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ArrayPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
     " which specifies how colors of cells should be determined from values. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32366]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The rules given by ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " are applied to the value of each cell. "
}], "Notes",
 CellLabel->"",
 CellID->25386],

Cell[TextData[{
 "Rules for ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " can involve patterns."
}], "Notes",
 CellLabel->"",
 CellID->25419],

Cell[TextData[{
 "If the result from applying ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", the background color will be used. "
}], "Notes",
 CellID->7576],

Cell[TextData[{
 "If none of the rules in ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " apply, then ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " is used to determine the color. "
}], "Notes",
 CellID->11667],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ColorRules", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", an explicit setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " is used instead of ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13353]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197355552],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->58044796],

Cell[TextData[{
 "Use color rules for ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1447040662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "Yellow"}], ",", 
      RowBox[{"b", "\[Rule]", "Blue"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3489],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpICwBAOQ/R/IAmOQ
EBAwg9hgwJAAJBiJFNUHMoH4P9Oo7KjsqOyo7KgsvWVBuL6+flR2VHZUdlR2
VHZwySLazdCWNiMAtrx52g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->335682872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72207683],

Cell[TextData[{
 "Use color rules for ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->118595559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "Yellow"}], ",", 
      RowBox[{"_", "\[Rule]", "Blue"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22401735],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtuwjAQHRLTVoIugRA2HKJnaFfd9QIRVIIFapVy/3TGsfMx409RWpHK
EYwz9ptnZxheEr8W58P7qTgfd8X2pSw+D8fd1/b5o8SudAIAe/yWGeB5hWfy
u68qbC/tAm2KgBW2Atul8jM5Sh6QW8lDorSPFtbG+IKNyjw+H8VxJ9aVmWhz
fMlGSV+0vu2K9Nxr1a56WbLl9gHtG9Stsh3muSO3XJZM/B3DCoQC5dOHWHv+
DM0j1QT1ydqoYCb9+vrJ3rPMT2g2EfkHSAJNbWjRoFUN1uGpUR1JwGxERXIx
oXZAFj0K6jqIgCJzDNArThpYYsyZBsxprnPI1V+T/bFUVkS2yFxV5KYpnYge
C5pu2cIV0fufEjqpO9p+H0Nnzq6OQMPl0y0bW7h2katZcjVMyvQzzbatg9Ht
3pOQMzvTbn51Ttx3gdBMt3eG26m3iHajSXB1lfrVN6LHjdYqWh8iMFYrml89
XSy8enJsUj0Vi37yFMHRw67lVthsmuz73XhNHlPN/hf0HC7f3c13/mvf8Yfc
k2j3PWy7I3H/6ff2n2DyDf9Xi+I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->206723461]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " can involve patterns:"
}], "ExampleText",
 CellID->11980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"2", "->", "Yellow"}], ",", 
      RowBox[{"_", "->", "White"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31065],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlkEKgCAURMe8RLvsMrXqDokFuYjCvH99JdoFtXMxH0aHecNfioONy7za
6J01fbD74t1hui1IpBWAKamG+FNcVopkdPJ5MMqhPqaNyMielpSUtEx6mnwD
FRtssMHGrwaQGm+vCykpabl0fNL7p68u5DMfiw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->102719202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17674],

Cell[TextData[{
 "If no explicit color rules apply, the default ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " coloring is used:"
}], "ExampleText",
 CellID->15483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19911],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt1zEKgDAMBdDUXsKtvUk3nbyDRYU6iKLuPbr+itBFQfcfSPmER8dAGr+H
YfL72Hlbr34JY7fZal4x0kpE+tSlIB9IV6cRSqd8lbR41MepiTFa/GOccwUF
BQVFFogWykBRUFBQ/BLHLd43DAUFBcWjyDfLfeWoEzXrvoA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->113624464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1639272478],

Cell["Color rules applied before color function:", "ExampleText",
 CellID->364984700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Red"}], "}"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<IslandColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->582563235],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpICwBAOQ/R/IAmOQ
EBAwg9hgwJAAJBiJFJVfeOWWAtAc+YfvzjCNqhhVMapiVAVCxcoT/gpAVfJA
VaMqRlWMqhhVQZIKoAxYBe4SZlTFqIpRFaMqsKpA9FmgvRxGAEAAuh8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->12146648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1609],

Cell[TextData[{
 "Cases specified as ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " are rendered in the background color:"
}], "ExampleText",
 CellID->22667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "|", "4"}], "\[Rule]", "None"}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15988],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpICwBAOQ/R/IAmOQ
EBAwg8n/IJQAJBiJFJWvr69X2L9/v+Ko7KjsqOxglAUSCkAV8kAVTKMqRlWM
qhhVQYoKoAxIBY7SZVR2VHZUdhDLJsBFoS19RgCQpdwN\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->82299673]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20478],

Cell["Modular operations tables: ", "ExampleText",
 CellID->346767928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"i", ",", "j"}], "]"}], ",", "5"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "40"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "40"}], "}"}]}], "]"}], ",", 
     RowBox[{"ColorRules", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0", "\[Rule]", "White"}], ",", 
        RowBox[{"1", "\[Rule]", "Yellow"}], ",", 
        RowBox[{"2", "\[Rule]", "Orange"}], ",", 
        RowBox[{"3", "\[Rule]", "Pink"}], ",", 
        RowBox[{"4", "\[Rule]", "Red"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Plus", ",", "Subtract", ",", "Times"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10590341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJzt2MFJxVAARNGAlbi0CnuwBMG1Lf8SLEFEV4I6K+HyTiDkERLOXc/98+vT
y911XQ9f98f583p73J7fv7/98f72w/9cLvf/3Eonl8vd3Uonl8vd3Uonl8vd
3Uonl8vd3Uonl8vd3Uonl8u1m3G5J7uVTi6Xu7uVTi6Xu7uVTi6Xu7uVTi6X
azfjck92K51cLnd3K51cLnd3K51cLnd3K51cLtduxuWe7FY6uVzu7lY6uVzu
7lY6uVzu7lY6uVyu3YzLPdmtdHK53N2tdHK53N2tdHK53N2tdHK5XLsZl3uy
W+nkcrm7W+nkcrm7W+nkcrm7W+nkcrl2My73ZLfSyeVyd7fSyeVyd7fSyeVy
d7fSyeVy7WZc7slupZPL5e5upZPL5e5upZPL5f7mvgMgxd4P
     "], {{0, 0}, {41, 41}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztzcEJgDAMBdCAk3h0iu7gCIJnV3aEjlCK9RLQBfo+hIR/yFuPaz+XiNjG
9PtJLf875+3vtHP/9Z/L5XK5XC6Xy+VyuVwul8vlcrlcLpfL5XK5XC6Xy+Vy
uVwul8vlcrlcLpfL5XK5XC6Xy+VyuVwul8vlcrlcLpfL5XK5XC6Xy+VyuVwu
l8vlcrlcLpfL5XK5XC6Xy+VyuVwul8vlcrlcLpfL5XK5XC6Xy+VyuVwul8vl
crlcLpfL5XK5XC6Xy+XO5DZOJ94P
     "], {{0, 0}, {41, 41}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzt2MFpZDEQRdEGR+LlROEcHILBa6c8ITgEY2xtBEUVzGjx3z+C5jai0ane
1vPbx+v70+Px+PP7+f7+cz5fVPVu3c+6/7t1v99/v7/H5XLPu1Urt3q/m386
D5fL/Xe3m2fqVnN2/4vL5f5/t2v1/tTt5udyuedcVc3vftZ96p6By01yq95t
z8DlJrndPFO3mvMqewYuN8ntWr0/dbv5uVzuOVdV87ufdZ+6Z+Byk9yqd9sz
cLlJbjfP1K3mvMqegctNcrtW70/dbn4ul3vOVdX87mfdp+4ZuNwkt+rd9gxc
bpLbzTN1qzmvsmfgcpPcrtX7U7ebn8vlnnNVNb/7WfepewYuN8mterc9A5eb
5HbzTN1qzqvsGbjcJLdr9f7U7ebncrnnXFXN737WfeqegctNcqvebc/A5Sa5
3TxTt5rzKnsGLjfJ7Vq9P3W7+blc7jlXVfO7n3WfumfgcpPcqnfbM3C5SW43
z9St5rzKnoHLTXK7Vu9P3W5+Lpd7zlXV/O5n3afuGbjcJLfq3fYMXG6S280z
das5r7Jn4HKT3K7V+1O3m5/L5Z5zVfXK/QKIxGft
     "], {{0, 0}, {41, 41}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True]}], "}"}]], "Output",
 ImageSize->{491, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7813404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->358439575],

Cell["Highlight cells where the GCD is 1:", "ExampleText",
 CellID->14050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{"i", ",", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{"1", "->", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30088],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWFFqAkEMXfAKXqBn6AFyB48g6G/PozfwCP3ul1ChIAiCH5aKtNiPHqHs
pl8Z32A0O5u1CchbniHzkh12MnkYP40mg6qqhn+/+pnthyphq9favkki8p/P
avsiifzvZ4K28VN/tj2dx9vj5/Wn+drGR/kiQ/7Be+N5XyxIojYO2j+PjZ0S
1O63aWNHkqjVw/m9J9iVHqv6cB7PJFGrB/kHX4bn9/9CEttet+3zURuf8/4g
iX3Rz/GWJLEr/YhH3598nLTfuC6OVk+6rm1eiH+j81i+zshfu3+s/BkPAMvr
Qf5c7zVJ9FZP5B88G/dZG5LoTaeW1/aH2u+/tl9F8W371S1J7Ht9kP+98vwe
diTRm862edvv/+3zq+vOl8vnV/8tX8SX6Xu185x0vhF55Xlv90euU3/vv970
d8Wj+1HotOX7Mn8OPXk9yN+Wv3yuEuuWWdfb+RXxy5y/3vrMiJOPg3hv89Lw
t/UP/j74XxXcmWI=
   "], {{0, 0}, {20, 20}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1477350816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5548],

Cell["Color a cellular automaton pattern:", "ExampleText",
 CellID->6564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1635", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "->", "Black"}], ",", 
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"2", "->", "Yellow"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->559922210]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29736],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->10173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ColorRules",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ColorRules"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->419960167],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->171454485],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->355648191],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->162534189]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColorRules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 27.0726328}", "context" -> "System`", 
    "keywords" -> {
     "color rules", "array colors", "matrix colors", "discrete color rules", 
      "highlighting matrix values", "highlighting array values"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ColorRules is an option for ArrayPlot which specifies how colors of \
cells should be determined from values. ", "synonyms" -> {"color rules"}, 
    "title" -> "ColorRules", "type" -> "Symbol", "uri" -> "ref/ColorRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5060, 184, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->197355552]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25339, 838}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1396, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2019, 62, 48, 1, 70, "ObjectName",
 CellID->28984],
Cell[2070, 65, 623, 19, 70, "Usage",
 CellID->32366]
}, Open  ]],
Cell[CellGroupData[{
Cell[2730, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3208, 106, 251, 9, 70, "Notes",
 CellID->25386],
Cell[3462, 117, 224, 9, 70, "Notes",
 CellID->25419],
Cell[3689, 128, 360, 13, 70, "Notes",
 CellID->7576],
Cell[4052, 143, 380, 13, 70, "Notes",
 CellID->11667],
Cell[4435, 158, 588, 21, 70, "Notes",
 CellID->13353]
}, Closed]],
Cell[CellGroupData[{
Cell[5060, 184, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197355552],
Cell[CellGroupData[{
Cell[5445, 198, 147, 5, 70, "ExampleSection",
 CellID->58044796],
Cell[5595, 205, 207, 8, 70, "ExampleText",
 CellID->1447040662],
Cell[CellGroupData[{
Cell[5827, 217, 442, 15, 28, "Input",
 CellID->3489],
Cell[6272, 234, 411, 11, 121, "Output",
 Evaluatable->False,
 CellID->335682872]
}, Open  ]],
Cell[6698, 248, 124, 3, 70, "ExampleDelimiter",
 CellID->72207683],
Cell[6825, 253, 208, 8, 70, "ExampleText",
 CellID->118595559],
Cell[CellGroupData[{
Cell[7058, 265, 540, 17, 28, "Input",
 CellID->22401735],
Cell[7601, 284, 842, 18, 135, "Output",
 Evaluatable->False,
 CellID->206723461]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8492, 308, 215, 7, 70, "ExampleSection",
 CellID->5565],
Cell[8710, 317, 199, 7, 70, "ExampleText",
 CellID->11980],
Cell[CellGroupData[{
Cell[8934, 328, 562, 18, 70, "Input",
 CellID->31065],
Cell[9499, 348, 427, 11, 70, "Output",
 Evaluatable->False,
 CellID->102719202]
}, Open  ]],
Cell[9941, 362, 121, 3, 70, "ExampleDelimiter",
 CellID->17674],
Cell[10065, 367, 244, 8, 70, "ExampleText",
 CellID->15483],
Cell[CellGroupData[{
Cell[10334, 379, 465, 15, 70, "Input",
 CellID->19911],
Cell[10802, 396, 435, 11, 70, "Output",
 Evaluatable->False,
 CellID->113624464]
}, Open  ]],
Cell[11252, 410, 126, 3, 70, "ExampleDelimiter",
 CellID->1639272478],
Cell[11381, 415, 85, 1, 70, "ExampleText",
 CellID->364984700],
Cell[CellGroupData[{
Cell[11491, 420, 543, 17, 70, "Input",
 CellID->582563235],
Cell[12037, 439, 442, 11, 70, "Output",
 Evaluatable->False,
 CellID->12146648]
}, Open  ]],
Cell[12494, 453, 120, 3, 70, "ExampleDelimiter",
 CellID->1609],
Cell[12617, 458, 227, 8, 70, "ExampleText",
 CellID->22667],
Cell[CellGroupData[{
Cell[12869, 470, 550, 17, 70, "Input",
 CellID->15988],
Cell[13422, 489, 430, 11, 70, "Output",
 Evaluatable->False,
 CellID->82299673]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13901, 506, 223, 7, 70, "ExampleSection",
 CellID->20478],
Cell[14127, 515, 70, 1, 70, "ExampleText",
 CellID->346767928],
Cell[CellGroupData[{
Cell[14222, 520, 972, 29, 70, "Input",
 CellID->10590341],
Cell[15197, 551, 2161, 48, 173, "Output",
 CellID->7813404]
}, Open  ]],
Cell[17373, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->358439575],
Cell[17501, 607, 74, 1, 70, "ExampleText",
 CellID->14050],
Cell[CellGroupData[{
Cell[17600, 612, 448, 15, 70, "Input",
 CellID->30088],
Cell[18051, 629, 860, 20, 201, "Output",
 CellID->1477350816]
}, Open  ]],
Cell[18926, 652, 120, 3, 70, "ExampleDelimiter",
 CellID->5548],
Cell[19049, 657, 73, 1, 70, "ExampleText",
 CellID->6564],
Cell[CellGroupData[{
Cell[19147, 662, 589, 19, 70, "Input",
 CellID->21026],
Cell[19739, 683, 2294, 42, 70, "Output",
 Evaluatable->False,
 CellID->559922210]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22094, 732, 311, 9, 70, "SeeAlsoSection",
 CellID->29736],
Cell[22408, 743, 206, 6, 70, "SeeAlso",
 CellID->10173]
}, Open  ]],
Cell[CellGroupData[{
Cell[22651, 754, 305, 8, 70, "RelatedLinksSection"],
Cell[22959, 764, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23361, 781, 319, 9, 70, "MoreAboutSection",
 CellID->419960167],
Cell[23683, 792, 124, 3, 70, "MoreAbout",
 CellID->171454485],
Cell[23810, 797, 143, 3, 70, "MoreAbout",
 CellID->355648191],
Cell[23956, 802, 143, 3, 70, "MoreAbout",
 CellID->162534189]
}, Open  ]],
Cell[24114, 808, 29, 0, 70, "History"],
Cell[24146, 810, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

