(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32594,       1168]
NotebookOptionsPosition[     25861,        939]
NotebookOutlinePosition[     27593,        982]
CellTagsIndexPosition[     27508,        977]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"], "Locator" :> 
          Documentation`HelpLookup["paclet:ref/Locator"], "SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"], "Setter" :> 
          Documentation`HelpLookup["paclet:ref/Setter"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ColorSlider\"\>", 2->"\<\"Locator\"\>", 
       3->"\<\"SystemDialogInput\"\>", 4->"\<\"Setter\"\>", 
       5->"\<\"Blend\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedInput"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Control Objects\"\>", 
       3->"\<\"Generalized Input\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ColorSetter", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorSetter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorSetter"], "[", 
       StyleBox["color", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a color setter which displays as a swatch of \
the specified color and when clicked brings up a system color picker dialog."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorSetter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorSetter"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["color", "TI"], "]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses the dynamically updated current value of ",
     Cell[BoxData[
      StyleBox["color", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["color", "TI"]], "InlineFormula"],
     " being reset if the color is modified."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ColorSetter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ColorSetter"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a color setter with initial color gray."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26639]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->7213],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the color setter", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the color setter is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed color setter ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed color setter ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->18074],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<ColorSetter\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " can be used to find the color specified by ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26118]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17083154],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->262178235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSetter", "[", "Pink", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481529204],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->673499176]
}, Open  ]],

Cell[TextData[{
 "Dynamically change ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->154360253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSetter", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->520595538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`x], "Swatch"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{184, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->476879727]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6893],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " can be included in graphics:"
}], "ExampleText",
 CellID->605919482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{
       RowBox[{"ColorSetter", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283803229],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Graphics[{
     Inset[
      ColorSetter[
       Dynamic[$CellContext`x]], {-1, 1}], 
     Dynamic[{$CellContext`x, 
       Disk[]}]}], StandardForm],
  ImageSizeCache->{180., {88., 93.}}]], "Output",
 ImageSize->{184, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28966039]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589125299],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->42063939],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " must be clicked to bring up the color dialog:"
}], "ExampleText",
 CellID->585071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSetter", "[", "Pink", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8585423],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77978733]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the color dialog comes up as the mouse moves over the setter area:"
}], "ExampleText",
 CellID->253752656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSetter", "[", 
  RowBox[{"Pink", ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180922905],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
  AutoAction->True]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85636570]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->82294163],

Cell["Align with surrounding text:", "ExampleText",
 CellID->478841241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ColorSetter", "[", 
      RowBox[{"Pink", ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->762763694],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
    BaselinePosition->Top], "xxx", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
    BaselinePosition->Center], "xxx", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
    BaselinePosition->Bottom]}],
  Row[{
    ColorSetter[
     RGBColor[1, 0.5, 0.5], BaselinePosition -> Top], 
    ColorSetter[
     RGBColor[1, 0.5, 0.5], BaselinePosition -> Center], 
    ColorSetter[
     RGBColor[1, 0.5, 0.5], BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{118, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193361131]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->90804034],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->251492019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSetter", "[", "Pink", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58604280],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312544949]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "\[Rule]", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the setter is disabled but visible in its current state:"
}], "ExampleText",
 CellID->398504791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSetter", "[", 
  RowBox[{"Orange", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501746271],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0], "Swatch",
  Enabled->False]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66863085]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->310885241],

Cell["Add margins to the color setter:", "ExampleText",
 CellID->331152349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ColorSetter", "[", 
    RowBox[{"Pink", ",", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->807844111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
    ImageMargins->0], ",", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
    ImageMargins->10], ",", 
   ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
    ImageMargins->20]}], "}"}]], "Output",
 ImageSize->{161, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256311428]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->161425889],

Cell["Control the overall size of the color setter:", "ExampleText",
 CellID->239317942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ColorSetter", "[", 
     RowBox[{"Pink", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "30", ",", "40"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "30", ",", "40"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13756286],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{20, 20}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{30, 20}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{40, 20}]},
    {
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{20, 30}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{30, 30}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{40, 30}]},
    {
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{20, 40}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{30, 40}], 
     ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch",
      ImageSize->{40, 40}]}
   }],
  "Grid"]], "Output",
 ImageSize->{110, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285974574]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->266977768],

Cell["Dynamically use the setting to color graphics elements:", "ExampleText",
 CellID->43864314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSetter", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308800451],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`x], "Swatch"], ",", 
   DynamicBox[ToBoxes[
     Graphics[{$CellContext`x, 
       Disk[]}, ImageSize -> 100], StandardForm],
    ImageSizeCache->{100., {48., 52.}}]}], "}"}]], "Output",
 ImageSize->{150, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377200033]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24416706],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->94036745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSetter", "[", "Pink", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260087383],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651220748]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorSlider", "[", 
  RowBox[{"Pink", ",", 
   RowBox[{"AppearanceElements", "\[Rule]", "\"\<Swatch\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216148994],

Cell[BoxData[
 ColorSetterBox[RGBColor[1, 0.5, 0.5], "Swatch"]], "Output",
 ImageSize->{24, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33325983]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1914],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24107],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->461802019],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->130704586],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->462974723],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "MoreAbout",
 CellID->754717917]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColorSetter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 27.8695282}", "context" -> "System`", 
    "keywords" -> {
     "choose color", "color chooser", "color dialog", "color palette", 
      "color picker", "color picking tool", "color selection dialog", 
      "color selector", "color swatch", "color wheel", "system color picker"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ColorSetter[color] represents a color setter which displays as a swatch \
of the specified color and when clicked brings up a system color picker \
dialog. ColorSetter[Dynamic[color]] uses the dynamically updated current \
value of color, with the value of color being reset if the color is modified. \
ColorSetter[] gives a color setter with initial color gray.", 
    "synonyms" -> {"color setter"}, "title" -> "ColorSetter", "type" -> 
    "Symbol", "uri" -> "ref/ColorSetter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9201, 265, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17083154]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27366, 970}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2362, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2985, 82, 1576, 37, 70, "ObjectNameGrid"],
Cell[4564, 121, 1526, 43, 70, "Usage",
 CellID->26639]
}, Open  ]],
Cell[CellGroupData[{
Cell[6127, 169, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6605, 186, 67, 1, 70, "Notes",
 CellID->7213],
Cell[6675, 189, 1795, 45, 70, "3ColumnTableMod",
 CellID->18074],
Cell[8473, 236, 348, 10, 70, "Notes",
 CellID->307511469],
Cell[8824, 248, 340, 12, 70, "Notes",
 CellID->26118]
}, Closed]],
Cell[CellGroupData[{
Cell[9201, 265, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17083154],
Cell[CellGroupData[{
Cell[9585, 279, 148, 5, 70, "ExampleSection",
 CellID->262178235],
Cell[CellGroupData[{
Cell[9758, 288, 110, 3, 28, "Input",
 CellID->481529204],
Cell[9871, 293, 204, 6, 44, "Output",
 CellID->673499176]
}, Open  ]],
Cell[10090, 302, 147, 6, 70, "ExampleText",
 CellID->154360253],
Cell[CellGroupData[{
Cell[10262, 312, 225, 7, 28, "Input",
 CellID->520595538],
Cell[10490, 321, 345, 10, 44, "Output",
 CellID->476879727]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10884, 337, 215, 7, 70, "ExampleSection",
 CellID->6893],
Cell[11102, 346, 221, 8, 70, "ExampleText",
 CellID->605919482],
Cell[CellGroupData[{
Cell[11348, 358, 541, 18, 70, "Input",
 CellID->283803229],
Cell[11892, 378, 369, 13, 70, "Output",
 CellID->28966039]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12310, 397, 222, 7, 70, "ExampleSection",
 CellID->589125299],
Cell[CellGroupData[{
Cell[12557, 408, 230, 7, 70, "ExampleSubsection",
 CellID->42063939],
Cell[12790, 417, 243, 8, 70, "ExampleText",
 CellID->585071],
Cell[CellGroupData[{
Cell[13058, 429, 108, 3, 70, "Input",
 CellID->8585423],
Cell[13169, 434, 203, 6, 70, "Output",
 CellID->77978733]
}, Open  ]],
Cell[13387, 443, 265, 8, 70, "ExampleText",
 CellID->253752656],
Cell[CellGroupData[{
Cell[13677, 455, 175, 5, 70, "Input",
 CellID->180922905],
Cell[13855, 462, 223, 7, 70, "Output",
 CellID->85636570]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14127, 475, 236, 7, 70, "ExampleSubsection",
 CellID->82294163],
Cell[14366, 484, 71, 1, 70, "ExampleText",
 CellID->478841241],
Cell[CellGroupData[{
Cell[14462, 489, 447, 14, 70, "Input",
 CellID->762763694],
Cell[14912, 505, 686, 20, 70, "Output",
 CellID->193361131]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15647, 531, 227, 7, 70, "ExampleSubsection",
 CellID->90804034],
Cell[15877, 540, 212, 8, 70, "ExampleText",
 CellID->251492019],
Cell[CellGroupData[{
Cell[16114, 552, 109, 3, 70, "Input",
 CellID->58604280],
Cell[16226, 557, 204, 6, 70, "Output",
 CellID->312544949]
}, Open  ]],
Cell[16445, 566, 359, 12, 70, "ExampleText",
 CellID->398504791],
Cell[CellGroupData[{
Cell[16829, 582, 175, 5, 70, "Input",
 CellID->501746271],
Cell[17007, 589, 219, 7, 70, "Output",
 CellID->66863085]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17275, 602, 233, 7, 70, "ExampleSubsection",
 CellID->310885241],
Cell[17511, 611, 75, 1, 70, "ExampleText",
 CellID->331152349],
Cell[CellGroupData[{
Cell[17611, 616, 348, 11, 70, "Input",
 CellID->807844111],
Cell[17962, 629, 423, 13, 70, "Output",
 CellID->256311428]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18434, 648, 230, 7, 70, "ExampleSubsection",
 CellID->161425889],
Cell[18667, 657, 88, 1, 70, "ExampleText",
 CellID->239317942],
Cell[CellGroupData[{
Cell[18780, 662, 573, 19, 70, "Input",
 CellID->13756286],
Cell[19356, 683, 947, 29, 70, "Output",
 CellID->285974574]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20364, 719, 227, 7, 70, "ExampleSection",
 CellID->266977768],
Cell[20594, 728, 97, 1, 70, "ExampleText",
 CellID->43864314],
Cell[CellGroupData[{
Cell[20716, 733, 421, 14, 70, "Input",
 CellID->308800451],
Cell[21140, 749, 397, 12, 70, "Output",
 CellID->377200033]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21586, 767, 236, 7, 70, "ExampleSection",
 CellID->24416706],
Cell[21825, 776, 335, 12, 70, "ExampleText",
 CellID->94036745],
Cell[CellGroupData[{
Cell[22185, 792, 110, 3, 70, "Input",
 CellID->260087383],
Cell[22298, 797, 204, 6, 70, "Output",
 CellID->651220748]
}, Open  ]],
Cell[CellGroupData[{
Cell[22539, 808, 196, 6, 70, "Input",
 CellID->216148994],
Cell[22738, 816, 203, 6, 70, "Output",
 CellID->33325983]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23002, 829, 310, 9, 70, "SeeAlsoSection",
 CellID->1914],
Cell[23315, 840, 1197, 44, 70, "SeeAlso",
 CellID->3756]
}, Open  ]],
Cell[CellGroupData[{
Cell[24549, 889, 314, 9, 70, "TutorialsSection",
 CellID->24107],
Cell[24866, 900, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[25051, 908, 319, 9, 70, "MoreAboutSection",
 CellID->461802019],
Cell[25373, 919, 124, 3, 70, "MoreAbout",
 CellID->130704586],
Cell[25500, 924, 141, 3, 70, "MoreAbout",
 CellID->462974723],
Cell[25644, 929, 145, 3, 70, "MoreAbout",
 CellID->754717917]
}, Open  ]],
Cell[25804, 935, 27, 0, 70, "History"],
Cell[25834, 937, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

