(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11371,        403]
NotebookOptionsPosition[      8724,        317]
NotebookOutlinePosition[     10042,        354]
CellTagsIndexPosition[      9958,        349]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Grid" :> Documentation`HelpLookup["paclet:ref/Grid"], 
         "ColumnWidths" :> 
         Documentation`HelpLookup["paclet:ref/ColumnWidths"], 
         "ColumnAlignments" :> 
         Documentation`HelpLookup["paclet:ref/ColumnAlignments"], 
         "ColumnSpacings" :> 
         Documentation`HelpLookup["paclet:ref/ColumnSpacings"], "RowsEqual" :> 
         Documentation`HelpLookup["paclet:ref/RowsEqual"], "MatrixForm" :> 
         Documentation`HelpLookup["paclet:ref/MatrixForm"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Grid\"\>", 2->"\<\"ColumnWidths\"\>",
       3->"\<\"ColumnAlignments\"\>", 4->"\<\"ColumnSpacings\"\>", 
      5->"\<\"RowsEqual\"\>", 6->"\<\"MatrixForm\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ColumnsEqual", "ObjectName",
 CellID->17188],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ColumnsEqual",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColumnsEqual"]], "InlineFormula"],
     "\[LineSeparator]is an option for the low-level function ",
     Cell[BoxData[
      ButtonBox["GridBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
     " which specifies whether all columns in the grid should be assigned \
equal width. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"ColumnsEqual", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " determines the width of each column from the widest entry in that column. \
"
}], "Notes",
 CellID->27886],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ColumnsEqual", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes all columns the same width, with the width determined by the widest \
entry in the whole ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30232]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->169681422],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->772008061],

Cell["\<\
Create a grid in which columns have different widths depending on their \
contents:\
\>", "ExampleText",
 CellID->102546309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GridBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<xxx\>\"", ",", "\"\<0\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<0\>\"", ",", "\"\<0\>\""}], "}"}]}], "}"}], ",", 
    RowBox[{"ColumnsEqual", "\[Rule]", "False"}], ",", 
    RowBox[{"GridBoxDividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Rows\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}], ",", 
       RowBox[{"\"\<Columns\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}]}], "}"}]}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404268698],

Cell[BoxData[
 TagBox[GridBox[{
    {"xxx", "0"},
    {"0", "0"}
   },
   ColumnsEqual->False,
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  DisplayForm]], "Output",
 ImageSize->{51, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->333766041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93511907],

Cell["Create a grid in which all columns have the same width:", "ExampleText",
 CellID->617049785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GridBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<xxx\>\"", ",", "\"\<0\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<0\>\"", ",", "\"\<0\>\""}], "}"}]}], "}"}], ",", 
    RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
    RowBox[{"GridBoxDividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Rows\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}], ",", 
       RowBox[{"\"\<Columns\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}]}], "}"}]}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151953076],

Cell[BoxData[
 TagBox[GridBox[{
    {"xxx", "0"},
    {"0", "0"}
   },
   ColumnsEqual->True,
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  DisplayForm]], "Output",
 ImageSize->{65, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->305565260]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10884],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnWidths",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColumnWidths"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColumnAlignments"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnSpacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColumnSpacings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowsEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowsEqual"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29202]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColumnsEqual - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 32.8384054}", "context" -> "System`", 
    "keywords" -> {"equal column widths"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ColumnsEqual is an option for the low-level function GridBox which \
specifies whether all columns in the grid should be assigned equal width. ", 
    "synonyms" -> {"columns equal"}, "title" -> "ColumnsEqual", "type" -> 
    "Symbol", "uri" -> "ref/ColumnsEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3728, 125, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->169681422]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9815, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1123, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1746, 50, 50, 1, 70, "ObjectName",
 CellID->17188],
Cell[1799, 53, 656, 19, 70, "Usage",
 CellID->31015]
}, Open  ]],
Cell[CellGroupData[{
Cell[2492, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2970, 94, 301, 10, 70, "Notes",
 CellID->27886],
Cell[3274, 106, 417, 14, 70, "Notes",
 CellID->30232]
}, Closed]],
Cell[CellGroupData[{
Cell[3728, 125, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->169681422],
Cell[CellGroupData[{
Cell[4113, 139, 148, 5, 70, "ExampleSection",
 CellID->772008061],
Cell[4264, 146, 134, 4, 70, "ExampleText",
 CellID->102546309],
Cell[CellGroupData[{
Cell[4423, 154, 730, 22, 47, "Input",
 CellID->404268698],
Cell[5156, 178, 330, 12, 70, "Output",
 CellID->333766041]
}, Open  ]],
Cell[5501, 193, 124, 3, 70, "ExampleDelimiter",
 CellID->93511907],
Cell[5628, 198, 98, 1, 70, "ExampleText",
 CellID->617049785],
Cell[CellGroupData[{
Cell[5751, 203, 729, 22, 70, "Input",
 CellID->151953076],
Cell[6483, 227, 329, 12, 70, "Output",
 CellID->305565260]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6873, 246, 311, 9, 70, "SeeAlsoSection",
 CellID->10884],
Cell[7187, 257, 1465, 53, 70, "SeeAlso",
 CellID->29202]
}, Open  ]],
Cell[8667, 313, 27, 0, 70, "History"],
Cell[8697, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

