(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24901,        884]
NotebookOptionsPosition[     19596,        704]
NotebookOutlinePosition[     20932,        741]
CellTagsIndexPosition[     20847,        736]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tally" :> Documentation`HelpLookup["paclet:ref/Tally"], 
          "Median" :> Documentation`HelpLookup["paclet:ref/Median"], "Mean" :> 
          Documentation`HelpLookup["paclet:ref/Mean"], "Split" :> 
          Documentation`HelpLookup["paclet:ref/Split"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Tally\"\>", 2->"\<\"Median\"\>", 
       3->"\<\"Mean\"\>", 4->"\<\"Split\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Descriptive Statistics\"\>", 
       3->"\<\"Discrete & Integer Data\"\>", 
       4->"\<\"Math & Counting Operations on Lists\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       6->"\<\"New in 6.0: List Manipulation\"\>", 
       7->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       8->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Commonest", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Commonest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Commonest"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the elements that are the most common \
in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Commonest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Commonest"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " most common elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When several elements occur with equal frequency, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Commonest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Commonest"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " picks first the ones that occur first in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Commonest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Commonest"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " returns the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " commonest elements in the order they appear in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->94019807]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78107117],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->822699785],

Cell["Obtain the elements with highest frequency:", "ExampleText",
 CellID->719169033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commonest", "[", 
  RowBox[{"{", 
   RowBox[{
   "b", ",", "a", ",", "c", ",", "2", ",", "a", ",", "b", ",", "1", ",", 
    "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150240649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529254477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89522975],

Cell["Obtain 4 most common elements:", "ExampleText",
 CellID->323070361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commonest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "b", ",", "a", ",", "c", ",", "2", ",", "a", ",", "b", ",", "1", ",", 
     "2"}], "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411300223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a", ",", "c", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42377940]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Elements of the list can be any expressions:", "ExampleText",
 CellID->440648632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commonest", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "E", ",", 
    RowBox[{"Sin", "[", "y", "]"}], ",", "E", ",", "a", ",", "1.5", ",", 
    RowBox[{"N", "[", 
     RowBox[{"3", ",", "20"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170283937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "\[ExponentialE]"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394454826]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Find the mode of a set of random integers:", "ExampleText",
 CellID->764025017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commonest", "[", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"20", ",", "1000"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75879829],

Cell[BoxData[
 RowBox[{"{", "8", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->874431044]
}, Open  ]],

Cell["\<\
Find the most frequently occurring elements in columns of a matrix:\
\>", "ExampleText",
 CellID->254062790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Commonest", ",", 
   RowBox[{"Transpose", "[", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"20", ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "5"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->97926812],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "11", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "12", "}"}], ",", 
   RowBox[{"{", "10", "}"}], ",", 
   RowBox[{"{", "0", "}"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37963421]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Commonest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Commonest"]], "InlineFormula"],
 " gives elements with largest ",
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 " values:"
}], "ExampleText",
 CellID->337605114],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"10", ",", "50"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->946592277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commonest", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211230996],

Cell[BoxData[
 RowBox[{"{", "10", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99912416]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tallies", "=", 
  RowBox[{"Tally", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->124002817],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{568, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->103661481]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"tallies", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "===", 
     RowBox[{"Max", "[", 
      RowBox[{"tallies", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->45293283],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"10", ",", "7"}], "}"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->241100184]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
A message is generated if there are fewer distinct elements than requested:\
\>", "ExampleText",
 CellID->291190225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commonest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "E", ",", 
     RowBox[{"Sin", "[", "y", "]"}], ",", "E", ",", "a", ",", "1.5", ",", 
     RowBox[{"N", "[", 
      RowBox[{"3", ",", "20"}], "]"}]}], "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27707767],

Cell[BoxData[
 RowBox[{
  RowBox[{"Commonest", "::", "\<\"dstlms\"\>"}], ":", 
  " ", "\<\"The requested number of elements \\!\\(10\\) is greater than the \
number of distinct elements \\!\\(5\\). Only \\!\\(5\\) elements will be \
returned.\"\>"}]], "Message", "MSG",
 CellID->340813307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "\[ExponentialE]", ",", 
   RowBox[{"Sin", "[", "y", "]"}], ",", "1.5`", ",", "3.`20."}], 
  "}"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103905195]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Commonest",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Commonest"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->313082269],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->152902931],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->667034087],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->354410232],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->782738190],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->568933045],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->117957902],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->128735431]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Commonest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 38.5573018}", "context" -> "System`", 
    "keywords" -> {"mode", "most frequent value", "statistical mode"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Commonest[list] gives a list of the elements that are the most common in \
list. Commonest[list, n] gives a list of the n most common elements in list.",
     "synonyms" -> {"mode"}, "title" -> "Commonest", "type" -> "Symbol", 
    "uri" -> "ref/Commonest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7469, 220, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->78107117]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20705, 729}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2703, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3326, 84, 1574, 37, 70, "ObjectNameGrid"],
Cell[4903, 123, 1103, 36, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6043, 164, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6521, 181, 447, 15, 70, "Notes",
 CellID->1067943069],
Cell[6971, 198, 461, 17, 70, "Notes",
 CellID->94019807]
}, Closed]],
Cell[CellGroupData[{
Cell[7469, 220, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78107117],
Cell[CellGroupData[{
Cell[7853, 234, 148, 5, 70, "ExampleSection",
 CellID->822699785],
Cell[8004, 241, 86, 1, 70, "ExampleText",
 CellID->719169033],
Cell[CellGroupData[{
Cell[8115, 246, 221, 7, 28, "Input",
 CellID->150240649],
Cell[8339, 255, 213, 7, 36, "Output",
 CellID->529254477]
}, Open  ]],
Cell[8567, 265, 124, 3, 70, "ExampleDelimiter",
 CellID->89522975],
Cell[8694, 270, 73, 1, 70, "ExampleText",
 CellID->323070361],
Cell[CellGroupData[{
Cell[8792, 275, 248, 8, 70, "Input",
 CellID->411300223],
Cell[9043, 285, 222, 7, 36, "Output",
 CellID->42377940]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9314, 298, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9538, 307, 87, 1, 70, "ExampleText",
 CellID->440648632],
Cell[CellGroupData[{
Cell[9650, 312, 293, 8, 70, "Input",
 CellID->170283937],
Cell[9946, 322, 217, 7, 36, "Output",
 CellID->394454826]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10212, 335, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[10442, 344, 85, 1, 70, "ExampleText",
 CellID->764025017],
Cell[CellGroupData[{
Cell[10552, 349, 172, 5, 70, "Input",
 CellID->75879829],
Cell[10727, 356, 180, 6, 36, "Output",
 CellID->874431044]
}, Open  ]],
Cell[10922, 365, 118, 3, 70, "ExampleText",
 CellID->254062790],
Cell[CellGroupData[{
Cell[11065, 372, 293, 9, 70, "Input",
 CellID->97926812],
Cell[11361, 383, 356, 12, 36, "Output",
 CellID->37963421]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11766, 401, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[12007, 410, 334, 12, 70, "ExampleText",
 CellID->337605114],
Cell[12344, 424, 181, 6, 70, "Input",
 CellID->946592277],
Cell[CellGroupData[{
Cell[12550, 434, 108, 3, 70, "Input",
 CellID->211230996],
Cell[12661, 439, 180, 6, 36, "Output",
 CellID->99912416]
}, Open  ]],
Cell[CellGroupData[{
Cell[12878, 450, 133, 4, 70, "Input",
 CellID->124002817],
Cell[13014, 456, 834, 29, 36, "Output",
 CellID->103661481]
}, Open  ]],
Cell[CellGroupData[{
Cell[13885, 490, 367, 13, 70, "Input",
 CellID->45293283],
Cell[14255, 505, 228, 8, 36, "Output",
 CellID->241100184]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14532, 519, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[14766, 528, 126, 3, 70, "ExampleText",
 CellID->291190225],
Cell[CellGroupData[{
Cell[14917, 535, 321, 9, 70, "Input",
 CellID->27707767],
Cell[15241, 546, 289, 6, 70, "Message",
 CellID->340813307],
Cell[15533, 554, 290, 9, 36, "Output",
 CellID->103905195]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15884, 570, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16203, 581, 921, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[17161, 621, 305, 8, 70, "RelatedLinksSection"],
Cell[17469, 631, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17869, 648, 299, 8, 70, "MoreAboutSection"],
Cell[18171, 658, 155, 3, 70, "MoreAbout",
 CellID->313082269],
Cell[18329, 663, 155, 3, 70, "MoreAbout",
 CellID->152902931],
Cell[18487, 668, 157, 3, 70, "MoreAbout",
 CellID->667034087],
Cell[18647, 673, 190, 4, 70, "MoreAbout",
 CellID->354410232],
Cell[18840, 679, 185, 3, 70, "MoreAbout",
 CellID->782738190],
Cell[19028, 684, 164, 3, 70, "MoreAbout",
 CellID->568933045],
Cell[19195, 689, 175, 3, 70, "MoreAbout",
 CellID->117957902],
Cell[19373, 694, 151, 3, 70, "MoreAbout",
 CellID->128735431]
}, Open  ]],
Cell[19539, 700, 27, 0, 70, "History"],
Cell[19569, 702, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

