(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19026,        610]
NotebookOptionsPosition[     15700,        498]
NotebookOutlinePosition[     17074,        537]
CellTagsIndexPosition[     16989,        532]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Compiling Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CompilingMathematicaExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Compiling Mathematica Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindFit" :> Documentation`HelpLookup["paclet:ref/FindFit"], 
          "FindMaximum" :> Documentation`HelpLookup["paclet:ref/FindMaximum"],
           "FindMinimum" :> 
          Documentation`HelpLookup["paclet:ref/FindMinimum"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"], "NDSolve" :> 
          Documentation`HelpLookup["paclet:ref/NDSolve"], "NIntegrate" :> 
          Documentation`HelpLookup["paclet:ref/NIntegrate"], "NProduct" :> 
          Documentation`HelpLookup["paclet:ref/NProduct"], "NSum" :> 
          Documentation`HelpLookup["paclet:ref/NSum"], "Play" :> 
          Documentation`HelpLookup["paclet:ref/Play"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FindFit\"\>", 2->"\<\"FindMaximum\"\>", 
       3->"\<\"FindMinimum\"\>", 4->"\<\"FindRoot\"\>", 5->"\<\"NDSolve\"\>", 
       6->"\<\"NIntegrate\"\>", 7->"\<\"NProduct\"\>", 8->"\<\"NSum\"\>", 
       9->"\<\"Play\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Compiled", "ObjectName",
 CellID->30233],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Compiled",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Compiled"]], "InlineFormula"],
     "\[LineSeparator]is an option for various numerical and plotting \
functions which specifies whether the expressions they work with should \
automatically be compiled. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8842]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Compiled", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " automatically creates compiled functions. "
}], "Notes",
 CellID->26860],

Cell[TextData[{
 "You should set ",
 Cell[BoxData[
  RowBox[{"Compiled", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " if you need to use high\[Hyphen]precision numbers. "
}], "Notes",
 CellID->7383]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151790355],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->323302047],

Cell["\<\
In rare occasions, machine-number compilation may produce unexpected results:\
\
\>", "ExampleText",
 CellID->491941340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", "x"}], "]"}], "\[Equal]", "0."}], ",", "0", ",", 
      RowBox[{"-", "1"}]}], "]"}], "+", 
    RowBox[{"x", "/", "900"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->787494273],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(100\\) iterations. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/cvmit\\\", ButtonNote -> \
\\\"FindRoot::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->195228184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "745.1332191019411`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126887669]
}, Open  ]],

Cell["\<\
Here, the optimization of treating machine underflow as zero affects the \
function:\
\>", "ExampleText",
 CellID->358044558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", "x"}], "]"}], "\[Equal]", "0."}], ",", "0", ",", 
      RowBox[{"-", "1"}]}], "]"}], "+", 
    RowBox[{"x", "/", "900"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111645447],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWG2ITFEYvjt358Owll3fpaZIEUpKqa0tGh9tbNSGRI0hO7RLa6RIrRSR
jyKxm/ixKB8/iEhRomRLlGwJJUr8sCmbH1vqes4595x77rnvzM4dLfPDbebe
e+553ue+5z3v+55z3xWZfOuWtkw+l82klnZkdrbmsrtSS3Z04JFdZVnWHfyz
kyzcO7jj/zuOg6t+juNsoyvCWuzG4YcVwW0PRySMHpudqr22ZUUNRLd4bIsL
OyKyWRrPwMCgx1Pa+xnAsh8+eO/Kng2je0I8efL4w4HOB03LL+7be//e3Tf9
/T/PlGkBbs0Y+A4ferSquWdH++1bN/vAd0rZnFkkpl11ac4We/ni8/FjT3Tp
k1x6ois1wo/Kbrpx/dqrL19+HFMonXMkR797++30qadrWq4AffnSy48fvx8h
0aMluutc74b1V/HDDZqHSPRYjgYZKEEMerwE6IM+fcdzFBSEmgoF9TtJzoka
GgbAADFMoPeT6CkcDRPBUAINw8P8e0n0VInGJGOqMeECvYdEp9gpDrdSaDgJ
HG1w8Je1yzfC6RKJXuFIAokn1k6SewaXAJOSEK7HJNpIiVmaZwG+O38XQ4aZ
tpHoORzd++wTjCdmXfjIVp/e8/y+kWu9KVCbSc75HN33+qvhSRmfb+vRLjOA
6ecLAl528cJzMG3kMrFAlMUNeTOjLJR+CBqQKT9c71D5SISZRk/ys2YD5bng
XVumno1+PuXbLQX4og6dJxYFvF7wrC7CE8gzWjvt51Nx0eybWXmVWi33x0d6
8XkvPppID2oKeL0XJ8tIiZUBCS9O0qQEt4EXJyqjLyLRLRpaZVxMUKNCs5Gu
c7yMq0dTA8lZh1O1u7LKiGDXOv+8EL16W1652fX0LV5tJQvgax1vXaf6bVLn
eu4WKmodN3Y1lNlmt7UBTxtKQqwvukQRuaRuK8MECPZYGC5Nh5pQWss221hV
sStpv3GhLVHjeolIGoFB/JnlNLlqx8vxeq61/7H1mC9OKEEy8G6zf4gx/Int
+NTE1bqCH4yIBZA9joR4/3B43PiQthvt2jyMzewQ+CQfI2yF4MRGosQxDreV
6sqc+bDW4pkwqtoljngUO8VZNi8e/3/LWvUOvWYUX7mklLniiNUBo0PStvhB
rVWF1ij/WsVafKdrCz52O5ccQ65CUGxF6LJkeifXWzNLm55RpH8ofFh52xiD
ueM08ab+iZIsM60sKc/qleYF//UZXq0TTuFvSvMbhubn0Vf0G83Mq5XAw5ql
ysuvsXLtYcqZkU7zyJmR34SlSVWij1aaPsOidRTfy/rm35pNYrezU0zf7wr4
TBLdHkCL6sgMn5YdEqXXULCHnkZy5jlaVEiwi1SVjZTyOrUn1WOG8GNe0yMq
g7wGKGqo5vrniwvTo3lFMW7UDt1qx+QQnAzAa5lu5USvgzCuCWXq18k5g7UV
xllfJudBP2d68Xmv+jKmTM7DfF5UfUbVuGvUDOsVcnNWj3JpvUIuyiFJn8+d
4FJAwdXwGsvr1bm6izy1qn4DO3C57w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29167366]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{"Compiled", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " to prevent this:"
}], "ExampleText",
 CellID->64005286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", "x"}], "]"}], "\[Equal]", "0."}], ",", "0", ",", 
      RowBox[{"-", "1"}]}], "]"}], "+", 
    RowBox[{"x", "/", "900"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1000"}], "}"}], ",", 
   RowBox[{"Compiled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->124382392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "900.`"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->984299330]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", "x"}], "]"}], "\[Equal]", "0."}], ",", "0", ",", 
      RowBox[{"-", "1"}]}], "]"}], "+", 
    RowBox[{"x", "/", "900"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1000"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Compiled", "\[Rule]", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->193307058],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WGuIVVUU3nPPveOoM00zppmWTVARWFb2sgztYWqlZZRZ2YTXmzVj+GAc
K7TCnvaaCitSf9SPHtDjh5EYwQiREAmREAlRQhiE/UiCpB8Dwenba5+1797n
rHPPOdeZy8w5Z5/zrbXXXutbaz+WVgf71qyrDvbXqj2LBqob+/prm3oWbhjA
q6BFKbUX/7WpCs8hnuh/bxji7l7H4RrgU0m39ENIP1XC4/uEaIt9CfSlXG8r
VYkhdpvXgbnpX4mbTejJ178GFMGrCh4Ofvd7bfVnu3YeHBn5T+0sIt1q3kDu
ww8O9a78GJresf7Uo2117qrNyuN37Ng/mwf3Pb1t+Pjxf98mmdMjbJk63D98
BAqhVr1lv7oWEap84sQI7Ib1h3/6c4eIo57Lv/7yV3/fnqFXD0DgDRFnRvz5
nsPoFX2r1z2bJpAWmAqDYfbRo38PiVomEs449L13v4djXhFx7YTDZ4CM314W
cacQzvXVi55dXY6vPv3kR7Xd836cazYSzrsu9uObO76FizCy50lHayLi5Uym
TiIEQgFrDJ2eDaUcMIKOohy6J1MbfFix/CO4Sz2TYmXFYZwWn8KRgwfxh4dt
TY9vKkcXNsASjO+ppnWdwQyw/H3Si52XOY7cdJJDmCyft3qMmBHWefzlvp/V
FpFXM9gr21/4esP6L6DucRHXQ7hDP/xh+fyoiDuHRwMQoBDY7Fl1LluNztAl
Ot4k6jmP2rA74vOAiDrf5yySe6OIu4D5aMobBNZ7Vs1kTqG3A9/8ptaJWmay
r7Zu+QoMQjI+4kUqT5ZdRG0wJ6ppa5vmzSyHN1CGwfWFJ5NjWvUlDqcQHfjp
oabtm80RRI5o/q1poCkQPHUZxxaGmNjWUjTEe463r/CjD5dVvbjxnSvGHGZD
VGFWiWyYw2yw9eQBEXcNR9zUCtUrouYmornSY+g8JzIgO9xyr6hnPrWRMVHW
3yOirmPbbdbfLeJuCOtZbzx3l2fVArYaAwMEg7xT1HMTWw9Hmay/w4sAUbbi
rgqUwIhFzCiMDXVNLUvhQ1yuHGsvZmahbBpm3Rbmz5yywLhbfIZB9ZIU21xb
eIy6uYQ5F1WgW1Pk3VnNtWApR9TUJjzcXFDD7czTqDIt9iI0LsOny9indhZb
6DGFeOGtvhaITCF+6Vkrqho3iqjl3JupDSDW9SJuBcfFrkPme1bd53hdZ/o8
UQuhorWXYe+1Iu7+GD/niqjeBPuu9mxaleDSVV4k3FlGMygQ+FiNsenKBlxw
dcX1rPZZBT9fHubLlKwcfJBeuuvj2Sk2xpmnu9ZNmk+8lcalBTS47YfD0F2T
wOMXp2jKnvX6mQMRf2d5sUtby61lTth6fKHHCb2e1t2WHA7oe7dvj/DVbfO9
K7qrwKaFcr93hvU9sCQfWNsSa/6K5VLEA3cfHW/rx86ER7MkaCfU6krkk+vQ
l4munK5ytOlNtdjK5baQ2/rAoUXfRV+dVnjUHREDDJkTgx9dL0lySP9MuVH2
0uQcGhI2xL9n+OBkfKXlSrF+9CzCzBorH+k+pxT0jWRrlk+CAvhU3vB71Blc
Ma2Z98XyPh9fukcxjo3GSrYnVqtNZ5bzHlezvh8jD00K5YreeB5hqfh80JWi
jeaV/cNHtNL2FEzjueQxssc9ZTvb4rQUnWV4q4ezRD0G556unSniniCcWeFh
qYOOp4k4OuUJsKKKTiXo7Iaq+S7FpVk8n2ywO41/z2oXlR9rfFPyFVML6qfN
8TVZXKpN9O20jPb0jO9U+Z2d/vhcvT4Xhnbnb9jSbXGanXT2WgZL7OngqaIe
g7Mnf1jBdoq4lwjnrk87RBydMEf7D732bPesGmKr7Z5pgqjlNWojONif6Mfx
Imp3g7eq5X/hLIbl\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->111241972]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22396],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMaximum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMaximum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Play",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Play"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17673]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27984],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[{
 ButtonBox["Compiling ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompilingMathematicaExpressions"]
}], "Tutorials",
 CellID->25382]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compiled - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 39.1666924}", "context" -> "System`", 
    "keywords" -> {
     "automatic compiling", "byte-code", "precompiled code", 
      "just-in-time compile"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Compiled is an option for various numerical and plotting functions which \
specifies whether the expressions they work with should automatically be \
compiled. ", "synonyms" -> {}, "title" -> "Compiled", "type" -> "Symbol", 
    "uri" -> "ref/Compiled"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4394, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->151790355]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16846, 525}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2132, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2755, 71, 46, 1, 70, "ObjectName",
 CellID->30233],
Cell[2804, 74, 533, 15, 70, "Usage",
 CellID->8842]
}, Open  ]],
Cell[CellGroupData[{
Cell[3374, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3852, 111, 236, 8, 70, "Notes",
 CellID->26860],
Cell[4091, 121, 266, 9, 70, "Notes",
 CellID->7383]
}, Closed]],
Cell[CellGroupData[{
Cell[4394, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151790355],
Cell[CellGroupData[{
Cell[4779, 149, 148, 5, 70, "ExampleSection",
 CellID->323302047],
Cell[4930, 156, 130, 4, 70, "ExampleText",
 CellID->491941340],
Cell[CellGroupData[{
Cell[5085, 164, 423, 14, 70, "Input",
 CellID->787494273],
Cell[5511, 180, 421, 8, 19, "Message",
 CellID->195228184],
Cell[5935, 190, 226, 7, 36, "Output",
 CellID->126887669]
}, Open  ]],
Cell[6176, 200, 135, 4, 70, "ExampleText",
 CellID->358044558],
Cell[CellGroupData[{
Cell[6336, 208, 419, 14, 28, "Input",
 CellID->111645447],
Cell[6758, 224, 1768, 33, 120, "Output",
 Evaluatable->False,
 CellID->29167366]
}, Open  ]],
Cell[8541, 260, 230, 9, 70, "ExampleText",
 CellID->64005286],
Cell[CellGroupData[{
Cell[8796, 273, 474, 15, 70, "Input",
 CellID->124382392],
Cell[9273, 290, 213, 7, 36, "Output",
 CellID->984299330]
}, Open  ]],
Cell[CellGroupData[{
Cell[9523, 302, 532, 17, 28, "Input",
 CellID->193307058],
Cell[10058, 321, 2119, 39, 120, "Output",
 Evaluatable->False,
 CellID->111241972]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12238, 367, 311, 9, 70, "SeeAlsoSection",
 CellID->22396],
Cell[12552, 378, 2162, 80, 70, "SeeAlso",
 CellID->17673]
}, Open  ]],
Cell[CellGroupData[{
Cell[14751, 463, 314, 9, 70, "TutorialsSection",
 CellID->27984],
Cell[15068, 474, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[15209, 479, 419, 12, 70, "Tutorials",
 CellID->25382]
}, Open  ]],
Cell[15643, 494, 27, 0, 70, "History"],
Cell[15673, 496, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

