(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15806,        572]
NotebookOptionsPosition[     12131,        448]
NotebookOutlinePosition[     13520,        487]
CellTagsIndexPosition[     13435,        482]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions with Heads That Are Not Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"], 
          "Manipulating Compiled Code" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingCompiledCode"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Expressions with Heads That Are Not Symbols\"\>",
        2->"\<\"Manipulating Compiled Code\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compile" :> Documentation`HelpLookup["paclet:ref/Compile"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Compile\"\>", 
       2->"\<\"InterpolatingFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CompiledFunction", "ObjectName",
 CellID->3078],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CompiledFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CompiledFunction"], "[", 
       RowBox[{
        StyleBox["args", "TI"], ",", 
        StyleBox["argregs", "TI"], ",", 
        StyleBox["nregs", "TI"], ",", 
        StyleBox["instr", "TI"], ",", 
        StyleBox["func", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents compiled code for evaluating a compiled \
function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11929]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["args", "TI"]], "InlineFormula"],
 " is a list giving a pattern for the type of each argument to the function. \
The types are specified as in ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6427],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["argregs", "TI"]], "InlineFormula"],
 " is a list of the registers into which actual argument values should be \
placed to evaluate the compiled code. "
}], "Notes",
 CellID->21903],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["nregs", "TI"]], "InlineFormula"],
 " is a list of the numbers of logical, integer, real, complex and tensor \
registers required in evaluating the compiled code. "
}], "Notes",
 CellID->5176],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["instr", "TI"]], "InlineFormula"],
 " is a list of actual compiled code instructions. "
}], "Notes",
 CellID->1120],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["func", "TI"]], "InlineFormula"],
 " is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pure function to be used if no result can be obtained from the compiled \
code for any reason. "
}], "Notes",
 CellID->22255],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " generates a ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " object which can be executed by applying it to appropriate arguments. "
}], "Notes",
 CellID->16350],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " objects that are constructed explicitly can also be executed. Basic \
consistency checks are done when such objects are first evaluated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->17966],

Cell[TextData[{
 "The code in a ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " object is based on an idealized register machine. "
}], "Notes",
 CellID->1817]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->315375353],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->99769217],

Cell[TextData[{
 Cell[BoxData["CcompiledFunction"], "InlineFormula"],
 " objects are generated by ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->135385475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"f", ",", "cf"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}], "]"}], ",", 
    RowBox[{"Compile", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74817170],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     SqrtBox[
      RowBox[{"x", " ", "y"}]]}], "]"}], ",", 
   TagBox[
    RowBox[{"CompiledFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      SqrtBox[
       RowBox[{"x", " ", "y"}]], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{503, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->839760430]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " objects can be used as normal ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->804121763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1.", ",", "2."}], "]"}], ",", 
   RowBox[{"cf", "[", 
    RowBox[{"1.", ",", "2."}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->191614950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.4142135623730951`", ",", "1.4142135623730951`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41955754]
}, Open  ]],

Cell["Arguments are coerced, if possible, to be approximate real:", \
"ExampleText",
 CellID->47194812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"cf", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->200974575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["2"], ",", "1.4142135623730951`"}], "}"}]], "Output",
 ImageSize->{103, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->289585421]
}, Open  ]],

Cell["\<\
When exceptional values are encountered the uncompiled function is used:\
\>", "ExampleText",
 CellID->47747803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2."}], "]"}], ",", 
   RowBox[{"cf", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2."}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2368148],

Cell[BoxData[
 RowBox[{
  RowBox[{"CompiledFunction", "::", "\<\"cfn\"\>"}], ":", 
  " ", "\<\"Numerical error encountered at instruction \\!\\(3\\); proceeding \
with uncompiled evaluation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/CompiledFunction/cfn\\\", ButtonNote -> \\\
\"CompiledFunction::cfn\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->310894594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.4142135623730951`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.4142135623730951`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->139590117]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10142],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13491]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17204],

Cell[TextData[ButtonBox["Expressions with Heads That Are Not Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"]], "Tutorials",
 CellID->25343],

Cell[TextData[ButtonBox["Manipulating Compiled Code",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingCompiledCode"]], "Tutorials",
 CellID->21821]
}, Open  ]],

Cell["New in 2  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompiledFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 38.9010606}", "context" -> "System`", 
    "keywords" -> {
     "auto-compile", "byte-code", "bytecode", "just-in-time", "machine code", 
      "precompile code"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CompiledFunction[args, argregs, nregs, instr, func] represents compiled \
code for evaluating a compiled function. ", 
    "synonyms" -> {"compiled function"}, "title" -> "CompiledFunction", 
    "type" -> "Symbol", "uri" -> "ref/CompiledFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5735, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->315375353]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13292, 475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1547, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2170, 63, 53, 1, 70, "ObjectName",
 CellID->3078],
Cell[2226, 66, 700, 21, 70, "Usage",
 CellID->11929]
}, Open  ]],
Cell[CellGroupData[{
Cell[2963, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3441, 109, 338, 11, 70, "Notes",
 CellID->6427],
Cell[3782, 122, 223, 6, 70, "Notes",
 CellID->21903],
Cell[4008, 130, 234, 6, 70, "Notes",
 CellID->5176],
Cell[4245, 138, 157, 5, 70, "Notes",
 CellID->1120],
Cell[4405, 145, 264, 9, 70, "Notes",
 CellID->22255],
Cell[4672, 156, 389, 12, 70, "Notes",
 CellID->16350],
Cell[5064, 170, 379, 11, 70, "Notes",
 CellID->17966],
Cell[5446, 183, 252, 8, 70, "Notes",
 CellID->1817]
}, Closed]],
Cell[CellGroupData[{
Cell[5735, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->315375353],
Cell[CellGroupData[{
Cell[6120, 210, 147, 5, 70, "ExampleSection",
 CellID->99769217],
Cell[6270, 217, 261, 9, 70, "ExampleText",
 CellID->135385475],
Cell[CellGroupData[{
Cell[6556, 230, 547, 19, 28, "Input",
 CellID->74817170],
Cell[7106, 251, 605, 22, 43, "Output",
 CellID->839760430]
}, Open  ]],
Cell[7726, 276, 357, 12, 70, "ExampleText",
 CellID->804121763],
Cell[CellGroupData[{
Cell[8108, 292, 228, 8, 28, "Input",
 CellID->191614950],
Cell[8339, 302, 242, 8, 36, "Output",
 CellID->41955754]
}, Open  ]],
Cell[8596, 313, 103, 2, 70, "ExampleText",
 CellID->47194812],
Cell[CellGroupData[{
Cell[8724, 319, 224, 8, 70, "Input",
 CellID->200974575],
Cell[8951, 329, 235, 8, 43, "Output",
 CellID->289585421]
}, Open  ]],
Cell[9201, 340, 122, 3, 70, "ExampleText",
 CellID->47747803],
Cell[CellGroupData[{
Cell[9348, 347, 266, 10, 70, "Input",
 CellID->2368148],
Cell[9617, 359, 443, 8, 70, "Message",
 CellID->310894594],
Cell[10063, 369, 411, 12, 36, "Output",
 CellID->139590117]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10535, 388, 311, 9, 70, "SeeAlsoSection",
 CellID->10142],
Cell[10849, 399, 475, 17, 70, "SeeAlso",
 CellID->13491]
}, Open  ]],
Cell[CellGroupData[{
Cell[11361, 421, 314, 9, 70, "TutorialsSection",
 CellID->17204],
Cell[11678, 432, 194, 4, 70, "Tutorials",
 CellID->25343],
Cell[11875, 438, 161, 3, 70, "Tutorials",
 CellID->21821]
}, Open  ]],
Cell[12051, 444, 50, 0, 70, "History"],
Cell[12104, 446, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

