(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    105483,       2799]
NotebookOptionsPosition[     96260,       2495]
NotebookOutlinePosition[     97520,       2531]
CellTagsIndexPosition[     97434,       2526]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Indeterminate and Infinite Results" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IndeterminateAndInfiniteResults"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Indeterminate and Infinite Results\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Infinity" :> Documentation`HelpLookup["paclet:ref/Infinity"], 
          "Indeterminate" :> 
          Documentation`HelpLookup["paclet:ref/Indeterminate"], 
          "DirectedInfinity" :> 
          Documentation`HelpLookup["paclet:ref/DirectedInfinity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Infinity\"\>", 
       2->"\<\"Indeterminate\"\>", 
       3->"\<\"DirectedInfinity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ComplexInfinity", "ObjectName",
 CellID->30509],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ComplexInfinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
     "\[LineSeparator]represents a quantity with infinite magnitude, but \
undetermined complex phase. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->27622],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}]], 
  "InlineFormula"],
 " is printed as ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18816]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->125441214],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->79192633],

Cell["Division by 0:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "0"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Infinite expression \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(1\\/0\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
encountered.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/infy\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->68444985],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18551700]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86264552],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->850191563]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " in numerical functions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Abs", "[", "ComplexInfinity", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " absorbs finite real, complex, and symbolic quantities:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInfinity", "+", "2"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", " ", "ComplexInfinity"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInfinity", " ", "+", " ", 
  RowBox[{"3", " ", "I"}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInfinity", "  ", "x"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->122201217]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInfinity", "+", " ", "x"}]], "Input",
 CellLabel->"In[5]:="],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->376353072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176413975],

Cell[TextData[{
 "Do arithmetic with ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18101453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInfinity", "/", "ComplexInfinity"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4929425],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Indeterminate expression \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(0\\\\ ComplexInfinity\\)\\!\\(\\*StyleBox[\\\"\\\\\\\
\" encountered.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/indet\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->409333853],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91566655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexInfinity", " ", "ComplexInfinity"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151019781],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->406775672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->694064178],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " as an expansion point for series:"
}], "ExampleText",
 CellID->666489110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "ComplexInfinity", ",", "2"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->20766756],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], "3"],
    SeriesData[$CellContext`x, 
     DirectedInfinity[], {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[], {1}, 2, 3, 1],
  Editable->False]], "Output",
 ImageSize->{85, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->944502654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "ComplexInfinity", ",", "1"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->329969026],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"Floor", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Arg", "[", "x", "]"}], "\[Pi]"]}], "]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Arg", "[", "x", "]"}], "\[Pi]"]}], "]"}]}], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"\[Pi]", "+", 
        RowBox[{"Arg", "[", "x", "]"}]}], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"Log", "[", "4", "]"}]}], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", 
           RowBox[{"Log", "[", 
            FractionBox["1", "x"], "]"}]}]}], ")"}]}], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", 
          FractionBox["1", "x"], "]"}], "2"],
        SeriesData[$CellContext`x, 
         DirectedInfinity[], {}, 0, 2, 1],
        Editable->False]}],
      SeriesData[$CellContext`x, 
       DirectedInfinity[], {
       Rational[1, 2] (Pi + Complex[0, -1] Log[4] + 
         Complex[0, 2] Log[$CellContext`x^(-1)])}, 0, 2, 1],
      Editable->False], ")"}]}], ")"}]}]], "Output",
 ImageSize->{547, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71724997]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Set up a seemingly \"analytic\"  function that is infinite in the whole left \
half\[Hyphen]plane:\
\>", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"z", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"z", "^", "2"}], "]"}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "2", "]"}], ",", " ", 
    RowBox[{"w", "[", "Pi", "]"}], ",", " ", 
    RowBox[{"w", "[", 
     RowBox[{"Pi", "+", 
      RowBox[{"2", "I"}]}], "]"}]}], "}"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ComplexInfinity", ",", "ComplexInfinity", ",", "ComplexInfinity"}],
   "}"}]], "Output",
 ImageSize->{356, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105573150]
}, Open  ]],

Cell["Plotting shows details of the numerical calculation: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{"w", "[", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28322594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Asymptotics of the ",
 Cell[BoxData[
  ButtonBox["Factorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial"]], "InlineFormula"],
 " function at ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"a", "!"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "ComplexInfinity", ",", "2"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"-", 
    RowBox[{"Floor", "[", 
     FractionBox[
      RowBox[{"\[Pi]", "+", 
       RowBox[{"Arg", "[", "a", "]"}]}], 
      RowBox[{"2", " ", "\[Pi]"}]], "]"}]}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"\[Pi]", "+", 
        RowBox[{"Arg", "[", "a", "]"}]}], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}]], ")"}], 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "-", 
    RowBox[{"Floor", "[", 
     FractionBox[
      RowBox[{"Arg", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"Floor", "[", 
          FractionBox[
           RowBox[{"\[Pi]", "+", 
            RowBox[{"Arg", "[", "a", "]"}]}], 
           RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
        RowBox[{"(", 
         InterpretationBox[
          RowBox[{
           FractionBox["1", "a"], "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", 
              FractionBox["1", "a"], "]"}], "3"],
            SeriesData[$CellContext`a, 
             DirectedInfinity[], {}, 1, 3, 1],
            Editable->False]}],
          SeriesData[$CellContext`a, 
           DirectedInfinity[], {1}, 1, 3, 1],
          Editable->False], ")"}]}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "]"}]}]], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"\[Pi]", "-", 
        RowBox[{"Arg", "[", "a", "]"}], "-", 
        RowBox[{"Arg", "[", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{"Floor", "[", 
            FractionBox[
             RowBox[{"\[Pi]", "+", 
              RowBox[{"Arg", "[", "a", "]"}]}], 
             RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
          RowBox[{"(", 
           InterpretationBox[
            RowBox[{"1", "+", 
             FractionBox["1", "a"], "+", 
             InterpretationBox[
              SuperscriptBox[
               RowBox[{"O", "[", 
                FractionBox["1", "a"], "]"}], "3"],
              SeriesData[$CellContext`a, 
               DirectedInfinity[], {}, 0, 3, 1],
              Editable->False]}],
            SeriesData[$CellContext`a, 
             DirectedInfinity[], {1, 1}, 0, 3, 1],
            Editable->False], ")"}]}], "]"}]}], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
    RowBox[{
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"\[Pi]", "+", 
        RowBox[{"Arg", "[", "a", "]"}]}], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], 
         FractionBox["1", "a"]], "+", 
        RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "a"], "]"}], "3"],
         SeriesData[$CellContext`a, 
          DirectedInfinity[], {}, -1, 3, 1],
         Editable->False]}],
       SeriesData[$CellContext`a, 
        DirectedInfinity[], {Complex[0, 1] Pi, Complex[0, 1] Pi}, -1, 3, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"Log", "[", 
          FractionBox["1", "a"], "]"}]}], 
        FractionBox["1", "a"]], "-", 
       RowBox[{"Log", "[", 
        FractionBox["1", "a"], "]"}], "+", 
       FractionBox["7", 
        RowBox[{"12", " ", "a"}]], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", 
          FractionBox["1", "a"], "]"}], "2"],
        SeriesData[$CellContext`a, 
         DirectedInfinity[], {}, -1, 2, 1],
        Editable->False]}],
      SeriesData[$CellContext`a, 
       DirectedInfinity[], {-1 - Log[$CellContext`a^(-1)], -
        Log[$CellContext`a^(-1)], 
        Rational[7, 12]}, -1, 2, 1],
      Editable->False], ")"}]}]], " ", 
  SuperscriptBox[
   RowBox[{"Csc", "[", 
    RowBox[{"a", " ", "\[Pi]"}], "]"}], 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"\[Pi]", "+", 
      RowBox[{"Arg", "[", "a", "]"}]}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]], " ", 
      SqrtBox[
       FractionBox["1", "a"]]}], "-", 
     RowBox[{
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "a"], ")"}], 
       RowBox[{"3", "/", "2"}]]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "a"], "]"}], 
       RowBox[{"5", "/", "2"}]],
      SeriesData[$CellContext`a, 
       DirectedInfinity[], {}, 1, 5, 2],
      Editable->False]}],
    SeriesData[$CellContext`a, 
     DirectedInfinity[], {(2 Pi)^Rational[1, 2], 
      0, -(Rational[1, 2] Pi)^Rational[1, 2]}, 1, 5, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{637, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Quiet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quiet"]], "InlineFormula"],
 " to suppress messages:"
}], "ExampleText",
 CellID->19941888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "0"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305876374],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10344503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139188065],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Infinite expression \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(1\\/0\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
encountered.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/infy\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->524334675],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->544277186]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->369846615],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " ",
 "can be generated by ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"E", "+", "1"}], ")"}], "^", "2"}], " ", "-", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"E", "^", "2"}], "+", 
       RowBox[{"2", "E"}], "+", "1"}], ")"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"infd\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Expression \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(1\\/\\(\\(\\(-1\\)\\) - \\(\\(2\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \\((1 + \[ExponentialE])\\)\\^2\
\\)\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" simplified to \\\\\\\"\\\", \\\"MSG\\\"]\
\\)\\!\\(ComplexInfinity\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Simplify/infd\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Pi", "/", "16"}], "]"}], "-", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "-", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "+", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], "]"}], "/", "2"}]}], 
    ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "::", "\<\"infd\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Expression \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(1\\/\\(\\(\\(\\(\\(-\\(\\(1\\/2\\)\\)\\)\\)\\\\ \\@\\(2 \
- \\@\\(Plus[\\(\\(\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) + \
\\(\\(Sin[\\(\\(\[Pi]\\/16\\)\\)]\\)\\)\\)\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
simplified to \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(ComplexInfinity\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\\\\\"\
\\\", \\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " has indeterminate real and imaginary parts:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", "ComplexInfinity", "]"}], ",", " ", 
   RowBox[{"Im", "[", "ComplexInfinity", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Indeterminate", ",", "Indeterminate"}], "}"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Abs", "[", "ComplexInfinity", "]"}], ",", " ", 
   RowBox[{"Arg", "[", "ComplexInfinity", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Arg", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Indeterminate expression \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(Arg[ComplexInfinity]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\"\
 encountered.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/indet\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], "]"}]}], "}"}]], "Output",\

 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " is not a number:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " from limits:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"2", "I"}]}], ")"}]}], "/", "x"}], "]"}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"2", "-", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], "x"]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Output",
 ImageSize->{127, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361723794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " behaves like a constant in differentiation:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"ComplexInfinity", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " is not a numeric quantity:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " is a symbol with infinite precision:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435453239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["DirectedInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullForm", "[", "ComplexInfinity", "]"}], " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"DirectedInfinity", "[", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " with care in boundary conditions of differential equations:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "[", "x", "]"}], "==", 
      RowBox[{
       RowBox[{"-", "2"}], "x", " ", 
       RowBox[{
        RowBox[{"z", "[", "x", "]"}], "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"z", "[", "ComplexInfinity", "]"}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"z", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452767165],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvnr\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, the given boundary \
conditions do not restrict the existing freedom in the general solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/DSolve/bvnr\\\", \
ButtonNote -> \\\"DSolve::bvnr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->2056980377],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvsing\"\>"}], ":", 
  " ", "\<\"Unable to resolve some of the arbitrary constants in the general \
solution using the given boundary conditions. It is possible that some of the \
conditions have been specified at a singular point for the equation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/DSolve/bvsing\\\", \
ButtonNote -> \\\"DSolve::bvsing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->1477446833],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "[", "x", "]"}], "\[Rule]", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"C", "[", "1", "]"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{134, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95511970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Infinite arguments of undetermined phase in all elementary functions:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"HoldForm", "[", 
      RowBox[{"#1", "[", "ComplexInfinity", "]"}], "]"}], "==", 
     RowBox[{"#1", "[", "ComplexInfinity", "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "Exp", ",", " ", "Log", ",", " ", "Sinc", ",", " ", "Sin", ",", " ", 
     "Cos", ",", " ", "Tan", ",", " ", "Cot", ",", " ", "Sec", ",", " ", 
     "Csc", ",", "\[IndentingNewLine]", "         ", "ArcSin", ",", " ", 
     "ArcCos", ",", " ", "ArcTan", ",", " ", "ArcCot", ",", "ArcSec", ",", 
     " ", "ArcCsc", ",", "\[IndentingNewLine]", "         ", "Sinh", ",", " ",
      "Cosh", ",", " ", "Tanh", ",", " ", "Coth", ",", " ", "Sech", ",", " ", 
     "Csch", ",", "\[IndentingNewLine]", "         ", "ArcSinh", ",", " ", 
     "ArcCosh", ",", " ", "ArcTanh", ",", " ", "ArcCoth", ",", "ArcSech", ",",
      " ", "ArcCsch"}], "}"}]}], "//", "Column"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Indeterminate expression \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(\[ExponentialE]\\^ComplexInfinity\\)\\!\\(\\*\
StyleBox[\\\"\\\\\\\" encountered.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/indet\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->201444885],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      TagBox[
       SuperscriptBox["\[ExponentialE]", "ComplexInfinity"],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Log", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "\[Infinity]"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Sinc", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Sin", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Cos", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Tan", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Cot", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Sec", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Csc", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcSin", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "ComplexInfinity"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcCos", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "ComplexInfinity"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcTan", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcCot", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "0"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcSec", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", 
      FractionBox["\[Pi]", "2"]}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcCsc", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "0"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Sinh", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Cosh", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Tanh", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Coth", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Sech", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"Csch", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcSinh", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "ComplexInfinity"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcCosh", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "\[Infinity]"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcTanh", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcCoth", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "0"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcSech", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "Indeterminate"}]},
    {
     RowBox[{
      TagBox[
       RowBox[{"ArcCsch", "[", "ComplexInfinity", "]"}],
       HoldForm], "\[Equal]", "0"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  "Column"]], "Output",
 ImageSize->{294, 413},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170951589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Behavior of the exponential function at ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 " shown on the Riemann sphere:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], "+", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Phi]", "]"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", "2"}], "+", 
        RowBox[{"0.5", " ", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"Re", "[", 
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"Cot", "[", 
               RowBox[{"\[Theta]", "/", "2"}], "]"}], 
              RowBox[{
               RowBox[{"(", " ", 
                RowBox[{
                 RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", "I", " ", 
                 RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ")"}], "/", "0.1"}]}],
              "]"}], "]"}], "]"}], "/", "Pi"}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
    RowBox[{"MaxRecursion", "->", "3"}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271148521]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16940],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Indeterminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Indeterminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28564],

Cell[TextData[ButtonBox["Indeterminate and Infinite Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IndeterminateAndInfiniteResults"]], "Tutorials",\

 CellID->22626]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1483],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ComplexInfinity.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/ComplexInfinity/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ComplexInfinity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 47.0575194}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ComplexInfinity represents a quantity with infinite magnitude, but \
undetermined complex phase. ", "synonyms" -> {"complex infinity"}, "title" -> 
    "ComplexInfinity", "type" -> "Symbol", "uri" -> "ref/ComplexInfinity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4058, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->125441214]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 97291, 2519}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1472, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2095, 64, 53, 1, 70, "ObjectName",
 CellID->30509],
Cell[2151, 67, 478, 14, 70, "Usage",
 CellID->15170]
}, Open  ]],
Cell[CellGroupData[{
Cell[2666, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3144, 103, 369, 14, 70, "Notes",
 CellID->27622],
Cell[3516, 119, 505, 20, 70, "Notes",
 CellID->18816]
}, Closed]],
Cell[CellGroupData[{
Cell[4058, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->125441214],
Cell[CellGroupData[{
Cell[4443, 158, 147, 5, 70, "ExampleSection",
 CellID->79192633],
Cell[4593, 165, 37, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[4655, 169, 72, 2, 70, "Input"],
Cell[4730, 173, 450, 9, 37, "Message",
 CellID->68444985],
Cell[5183, 184, 172, 5, 36, "Output",
 CellID->18551700]
}, Open  ]],
Cell[CellGroupData[{
Cell[5392, 194, 91, 3, 28, "Input",
 CellID->86264552],
Cell[5486, 199, 158, 5, 36, "Output",
 CellID->850191563]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5693, 210, 200, 6, 70, "ExampleSection"],
Cell[5896, 218, 204, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[6125, 229, 93, 2, 70, "Input"],
Cell[6221, 233, 150, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6408, 242, 96, 2, 70, "Input"],
Cell[6507, 246, 162, 5, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6706, 256, 123, 3, 70, "Input"],
Cell[6832, 261, 240, 8, 36, "Output"]
}, Open  ]],
Cell[7087, 272, 105, 2, 70, "ExampleDelimiter"],
Cell[7195, 276, 226, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7446, 286, 86, 2, 70, "Input"],
Cell[7535, 290, 153, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7725, 299, 86, 2, 70, "Input"],
Cell[7814, 303, 153, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8004, 312, 119, 3, 70, "Input"],
Cell[8126, 317, 153, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8316, 326, 87, 2, 70, "Input"],
Cell[8406, 330, 173, 5, 36, "Output",
 CellID->122201217]
}, Open  ]],
Cell[CellGroupData[{
Cell[8616, 340, 91, 2, 70, "Input"],
Cell[8710, 344, 173, 5, 36, "Output",
 CellID->376353072]
}, Open  ]],
Cell[8898, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->176413975],
Cell[9026, 357, 215, 8, 70, "ExampleText",
 CellID->18101453],
Cell[CellGroupData[{
Cell[9266, 369, 118, 3, 70, "Input",
 CellID->4929425],
Cell[9387, 374, 480, 9, 70, "Message",
 CellID->409333853],
Cell[9870, 385, 169, 5, 36, "Output",
 CellID->91566655]
}, Open  ]],
Cell[CellGroupData[{
Cell[10076, 395, 120, 3, 70, "Input",
 CellID->151019781],
Cell[10199, 400, 173, 5, 36, "Output",
 CellID->406775672]
}, Open  ]],
Cell[10387, 408, 125, 3, 70, "ExampleDelimiter",
 CellID->694064178],
Cell[10515, 413, 234, 8, 70, "ExampleText",
 CellID->666489110],
Cell[CellGroupData[{
Cell[10774, 425, 301, 11, 70, "Input",
 CellID->20766756],
Cell[11078, 438, 560, 20, 52, "Output",
 CellID->944502654]
}, Open  ]],
Cell[CellGroupData[{
Cell[11675, 463, 234, 8, 70, "Input",
 CellID->329969026],
Cell[11912, 473, 1606, 50, 77, "Output",
 CellID->71724997]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13567, 529, 207, 6, 70, "ExampleSection"],
Cell[13777, 537, 129, 3, 70, "ExampleText"],
Cell[13909, 542, 259, 9, 70, "Input"],
Cell[CellGroupData[{
Cell[14193, 555, 284, 9, 70, "Input"],
Cell[14480, 566, 259, 8, 36, "Output",
 CellID->105573150]
}, Open  ]],
Cell[14754, 577, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14855, 581, 430, 15, 70, "Input"],
Cell[15288, 598, 20915, 347, 70, "Output",
 Evaluatable->False,
 CellID->28322594]
}, Open  ]],
Cell[36218, 948, 105, 2, 70, "ExampleDelimiter"],
Cell[36326, 952, 335, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[36686, 968, 199, 7, 70, "Input"],
Cell[36888, 977, 5433, 168, 175, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42370, 1151, 217, 6, 70, "ExampleSection"],
Cell[42590, 1159, 201, 8, 70, "ExampleText",
 CellID->19941888],
Cell[CellGroupData[{
Cell[42816, 1171, 120, 4, 70, "Input",
 CellID->305876374],
Cell[42939, 1177, 172, 5, 36, "Output",
 CellID->10344503]
}, Open  ]],
Cell[CellGroupData[{
Cell[43148, 1187, 92, 3, 70, "Input",
 CellID->139188065],
Cell[43243, 1192, 451, 9, 70, "Message",
 CellID->524334675],
Cell[43697, 1203, 173, 5, 36, "Output",
 CellID->544277186]
}, Open  ]],
Cell[43885, 1211, 125, 3, 70, "ExampleDelimiter",
 CellID->369846615],
Cell[44013, 1216, 459, 17, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[44497, 1237, 361, 12, 70, "Input"],
Cell[44861, 1251, 631, 11, 70, "Message"],
Cell[45495, 1264, 153, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45685, 1273, 422, 14, 70, "Input"],
Cell[46110, 1289, 541, 9, 70, "Message"],
Cell[46654, 1300, 153, 4, 36, "Output"]
}, Open  ]],
Cell[46822, 1307, 105, 2, 70, "ExampleDelimiter"],
Cell[46930, 1311, 215, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[47170, 1321, 188, 5, 70, "Input"],
Cell[47361, 1328, 208, 6, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47606, 1339, 190, 5, 70, "Input"],
Cell[47799, 1346, 453, 8, 70, "Message"],
Cell[48255, 1356, 313, 11, 36, "Output"]
}, Open  ]],
Cell[48583, 1370, 105, 2, 70, "ExampleDelimiter"],
Cell[48691, 1374, 188, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[48904, 1384, 97, 2, 70, "Input"],
Cell[49004, 1388, 142, 4, 36, "Output"]
}, Open  ]],
Cell[49161, 1395, 105, 2, 70, "ExampleDelimiter"],
Cell[49269, 1399, 196, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[49490, 1410, 309, 11, 70, "Input"],
Cell[49802, 1423, 370, 12, 49, "Output",
 CellID->361723794]
}, Open  ]],
Cell[50187, 1438, 105, 2, 70, "ExampleDelimiter"],
Cell[50295, 1442, 215, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[50535, 1452, 168, 5, 70, "Input"],
Cell[50706, 1459, 138, 4, 36, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50893, 1469, 210, 6, 70, "ExampleSection"],
Cell[51106, 1477, 198, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[51329, 1487, 98, 2, 70, "Input"],
Cell[51430, 1491, 142, 4, 36, "Output"]
}, Open  ]],
Cell[51587, 1498, 105, 2, 70, "ExampleDelimiter"],
Cell[51695, 1502, 208, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[51928, 1512, 99, 2, 70, "Input"],
Cell[52030, 1516, 168, 5, 36, "Output",
 CellID->435453239]
}, Open  ]],
Cell[52213, 1524, 105, 2, 70, "ExampleDelimiter"],
Cell[52321, 1528, 326, 11, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[52672, 1543, 116, 3, 70, "Input"],
Cell[52791, 1548, 309, 11, 50, "Output"]
}, Open  ]],
Cell[53115, 1562, 105, 2, 70, "ExampleDelimiter"],
Cell[53223, 1566, 240, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[53488, 1577, 485, 16, 70, "Input",
 CellID->452767165],
Cell[53976, 1595, 458, 8, 70, "Message",
 CellID->2056980377],
Cell[54437, 1605, 543, 9, 70, "Message",
 CellID->1477446833],
Cell[54983, 1616, 372, 13, 54, "Output",
 CellID->95511970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55404, 1635, 208, 6, 70, "ExampleSection"],
Cell[55615, 1643, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[55740, 1649, 946, 19, 70, "Input"],
Cell[56689, 1670, 494, 10, 70, "Message",
 CellID->201444885],
Cell[57186, 1682, 4046, 147, 434, "Output",
 CellID->170951589]
}, Open  ]],
Cell[61247, 1832, 105, 2, 70, "ExampleDelimiter"],
Cell[61355, 1836, 245, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[61625, 1847, 1457, 41, 70, "Input"],
Cell[63085, 1890, 30729, 508, 70, "Output",
 Evaluatable->False,
 CellID->271148521]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93875, 2405, 311, 9, 70, "SeeAlsoSection",
 CellID->16940],
Cell[94189, 2416, 721, 26, 70, "SeeAlso",
 CellID->5683]
}, Open  ]],
Cell[CellGroupData[{
Cell[94947, 2447, 314, 9, 70, "TutorialsSection",
 CellID->28564],
Cell[95264, 2458, 178, 4, 70, "Tutorials",
 CellID->22626]
}, Open  ]],
Cell[CellGroupData[{
Cell[95479, 2467, 320, 9, 70, "RelatedLinksSection",
 CellID->1483],
Cell[95802, 2478, 186, 4, 70, "RelatedLinks"],
Cell[95991, 2484, 197, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[96203, 2491, 27, 0, 70, "History"],
Cell[96233, 2493, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

