(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25713,        928]
NotebookOptionsPosition[     20346,        742]
NotebookOutlinePosition[     21678,        780]
CellTagsIndexPosition[     21593,        775]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"], 
          "Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Using Assumptions\"\>", 
       2->"\<\"Equations and Inequalities over Domains\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "NumberQ" :> Documentation`HelpLookup["paclet:ref/NumberQ"], 
          "NumericQ" :> Documentation`HelpLookup["paclet:ref/NumericQ"], 
          "Complex" :> Documentation`HelpLookup["paclet:ref/Complex"], 
          "Reals" :> Documentation`HelpLookup["paclet:ref/Reals"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Simplify\"\>",
        3->"\<\"NumberQ\"\>", 4->"\<\"NumericQ\"\>", 5->"\<\"Complex\"\>", 
       6->"\<\"Reals\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Complexes", "ObjectName",
 CellID->4337],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Complexes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
     "\[LineSeparator]represents the domain of complex numbers, as in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["\[Element]", "TR"], "Complexes"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], "Complexes"}]], "InlineFormula"],
 " evaluates immediately only if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a numeric quantity. "
}], "Notes",
 CellID->13055],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], 
    StyleBox["\[Element]", "TR"], "Complexes"}], "]"}]], "InlineFormula"],
 " can be used to try to determine whether an expression corresponds to a \
complex number. "
}], "Notes",
 CellID->3074],

Cell["\<\
The domain of real numbers is taken to be a subset of the domain of complex \
numbers. \
\>", "Notes",
 CellID->4979],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData["\[DoubleStruckCapitalC]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21029]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213180703],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->50798725],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"sin", "(", "7", ")"}]}]], TraditionalForm]], "InlineMath"],
 " is a complex number:"
}], "ExampleText",
 CellID->38771768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"I", " ", 
      RowBox[{"Sin", "[", "7", "]"}]}], ")"}]}], ",", "Complexes"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372273486],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306412180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->713730961],

Cell["Exponential of a complex number is a complex number:", "ExampleText",
 CellID->49245259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"E", "^", "x"}], ",", "Complexes"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Complexes"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511642687],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498737370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88183990],

Cell[TextData[{
 "Find complex numbers that make an inequality well defined and ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->311965230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "<", "1"}], ",", "x", ",", "Complexes"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269611568],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", 
     RowBox[{"Re", "[", "x", "]"}], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{
   RowBox[{"Re", "[", "x", "]"}], "\[Equal]", "0"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", 
     RowBox[{"Re", "[", "x", "]"}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->703421666]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->112512650],

Cell["\<\
Specify that all variables should be considered complex, even if they appear \
in inequalities:\
\>", "ExampleText",
 CellID->438669102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "\[LessEqual]", "1"}], ",", "x", ",", 
   "Complexes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227622769],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm81u1DAQx9PdTT8ooEILKi1SixBcoAgOSDwBnLhxQlxWFVJ7qECld+Ch
4K14hhAncer+M87YzjjZbbNSd+P4I2N7PB7/Mv04vzj5eja/OD2eH344n38/
OT3+cfj+23l+a7qSJCt/kiT5tJvk11l+Vfypz9/8r7wsr26r76nOzZKt/GuS
Jzer39dM/hGkN6D8DNI7UP4ZpLE8pn8XUm/C3XuQxvwjz/IvmPw1h1621X/K
5E+Z9n8Vo3CryKrv5h9VpFFXj+qVkmqsJ5YxTyG9nn+leTKtypePKLLrNsx7
q1B/UtXXZdQn1UlnqfbE+sfN3kxE3vti8nLpn1mtDTDqhdj1M5LqGWYpaq4M
yapZxxpKSnzerFFz2rizzvTElLn+pkuxMk7rqvpzN9KIcPpEthitl6uRetlB
C5ta0SKJyp/ofoAVmth0qDGa9BhzM+U2MzYJt7PSbjT1PrTPcTSrTX4ZucN1
ZVY9NfWQ22aROA2WsUZtUtE2KKSP/WqC3bKEyC6+fzXu+ttOTA+jO7yc+1FH
YaidaztqryT1Ten0VD/Dy/ejLJT2oEntaXjypk/t5zHSWhPWFycdEZSd1o0w
2d00YdP6RLMsnmzxzIZzvgtpbA/rY5qeQ66W74rm2qNng6vldn412UOx0pPy
nskDtqvffWghNcro38dZuS9hGxyT0Oc9bG/H0p4bo1CXSFv8r5DPIC+JzWee
MOUfQHlfnsPJU1jphn49h/Si854Dh1Fsq9+VF3HeSjnKuCNqm2u7L0Oa1Apb
zUbC5C/vTiUvN7upyNP641nc6NHaSvtva5UMa2RudyqC9os8+4xUjOjVIlAx
TkbMv57kTnK9aQu+0ZCqCwOzei4j9xOSv6+1MTx7jLW7hJAxvVrQnxvJpazs
fVr/xWCqklreZnkvS0kyScrej0Q2C14toUR2KP9oWD4suXa2yLthNJM7a4yU
uStldtL3JWXdblrtxsLpMyNHhW8SIfe1nMNweDcuWDDohtYry0bR8SGJ/cPM
j4hJEX83iq0u5d8IIPH/AulHnrL+y2o7YNzlCPpnJh/XOjdDpRSxIhw1OdU7
Jseb1ZhrPm3y6m5EFVvztdjGGLF+SHeKlGbU+YXmqi7Ucwva57wbKd/SidjK
zIIIz6Atvw/90nrmetLqds5t5XUi4xpKWly1lzsvoObaKE63cbS1Gt1KCJyw
aJ31Hddu+hlOGmKOcJhvT48nnvecLKrg6SWOJZWJxqFH7ABK4YnE9wSDUrl5
NS5xL9qTPajS6smUx6q9bV+PtJREXcp7pC9BxjeQjx4rxozEjlHBmJiu3n2x
0tkYFMx/BWnOw+ZiQIaOUeFiaLqeRctRRiur5gZ9aJkzAvX/LSqpd41hYlTk
ojCuY4yKXARPV5pGayuuCSqyKsbZTf/vDP0eLG3UHy5GxcdPH2NUqD4sZ7RQ
nPWmbS6119TrQeSUrn3xdXJ8UnJOhopVGWNUwmWQjfPpZ5cxdTOEnbTvHlyf
4saq2PeLMVZlUSKA+tHydi2VIltuHls/a2LoOIoxVkVdxo0HWqRzSBi7pCNg
9Cm6r1gVyUiLmxmrIhntI6PVnBbTmscxXroWvkX3jVUJi99YzliVsLgcGT6I
LFp7BYqu2qJVVHGXaBVbdMhQ0Sq26BkZnq0uu78bwP0M2f87Jr/ruwFp1n9W
9Arvcuz+rWf52Kw/NqsvR6nJbqeJBJul3v3pdwAjmXd9yuKwckNbLP55dSuR
Yr7U2/KRgrt6GTeTMLdoqQgLNP9zkqIrI0O+fvzWrlOh9JKybCOhDZV9sTio
9z4pwJ/Q17rDjPdIOiV7tdhs0UcfwzgRUpeRGi4nrzNOzZ0jO1EnrgeZG4aZ
lfNi2oXCkiRNprSXXTKnK7t7Ep+TxeJcZe/VpQvJSlb+A4WHoXI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{437, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->555021064]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " considers all variables that appear in inequalities to be real:"
}], "ExampleText",
 CellID->2701364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "\[LessEqual]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->42670547],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->704545229]
}, Open  ]],

Cell[TextData[{
 "For every real number ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " there exists a complex number whose square is real and less than ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->218578346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "<", "y"}]}], "]"}], ",", "Complexes"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->105360712],

Cell[BoxData[
 RowBox[{"y", "\[Element]", "Reals"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144102737]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " considers all variables that appear in inequalities to be real:"
}], "ExampleText",
 CellID->127673232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "<", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14374894],

Cell[BoxData[
 RowBox[{"y", ">", "0"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->606077012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51010884],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " of formatting:"
}], "ExampleText",
 CellID->2113989541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complexes", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1852759619],

Cell[BoxData[
 FormBox[
  TagBox["\[DoubleStruckCapitalC]",
   Function[{}, Complexes]], TraditionalForm]], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->194359495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8531461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 " contains ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->112558139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Complexes"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "#"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "Reals", ",", "Algebraics", ",", "Rationals", ",", "Integers", ",", 
    "Primes"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155047900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123809087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350572424],

Cell[TextData[{
 "Infinite quantities are not considered part of the ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->70410547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"Infinity", ",", "Complexes"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"ComplexInfinity", ",", "Complexes"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48621932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414962604]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18113],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reals"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27676]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12716],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->12341],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "Tutorials",
 CellID->19824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->90648033],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->90132176],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->76574940]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complexes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 40.2292196}", "context" -> "System`", 
    "keywords" -> {
     "complex domain", "complex number", "complex range", "complex solution", 
      "complex space", "complex variable"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Complexes represents the domain of complex numbers, as in x \\[Element] \
Complexes. ", "synonyms" -> {}, "title" -> "Complexes", "type" -> "Symbol", 
    "uri" -> "ref/Complexes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5538, 178, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->213180703]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21450, 768}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2553, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3176, 84, 46, 1, 70, "ObjectName",
 CellID->4337],
Cell[3225, 87, 577, 18, 70, "Usage",
 CellID->9765]
}, Open  ]],
Cell[CellGroupData[{
Cell[3839, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4317, 127, 283, 10, 70, "Notes",
 CellID->13055],
Cell[4603, 139, 373, 12, 70, "Notes",
 CellID->3074],
Cell[4979, 153, 127, 4, 70, "Notes",
 CellID->4979],
Cell[5109, 159, 392, 14, 70, "Notes",
 CellID->21029]
}, Closed]],
Cell[CellGroupData[{
Cell[5538, 178, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213180703],
Cell[CellGroupData[{
Cell[5923, 192, 147, 5, 70, "ExampleSection",
 CellID->50798725],
Cell[6073, 199, 251, 8, 70, "ExampleText",
 CellID->38771768],
Cell[CellGroupData[{
Cell[6349, 211, 246, 9, 28, "Input",
 CellID->372273486],
Cell[6598, 222, 161, 5, 36, "Output",
 CellID->306412180]
}, Open  ]],
Cell[6774, 230, 125, 3, 70, "ExampleDelimiter",
 CellID->713730961],
Cell[6902, 235, 94, 1, 70, "ExampleText",
 CellID->49245259],
Cell[CellGroupData[{
Cell[7021, 240, 289, 9, 70, "Input",
 CellID->511642687],
Cell[7313, 251, 161, 5, 36, "Output",
 CellID->498737370]
}, Open  ]],
Cell[7489, 259, 124, 3, 70, "ExampleDelimiter",
 CellID->88183990],
Cell[7616, 264, 237, 8, 70, "ExampleText",
 CellID->311965230],
Cell[CellGroupData[{
Cell[7878, 276, 195, 7, 70, "Input",
 CellID->269611568],
Cell[8076, 285, 632, 21, 36, "Output",
 CellID->703421666]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8757, 312, 220, 7, 70, "ExampleSection",
 CellID->112512650],
Cell[8980, 321, 146, 4, 70, "ExampleText",
 CellID->438669102],
Cell[CellGroupData[{
Cell[9151, 329, 207, 7, 70, "Input",
 CellID->227622769],
Cell[9361, 338, 2155, 39, 70, "Output",
 Evaluatable->False,
 CellID->555021064]
}, Open  ]],
Cell[11531, 380, 252, 8, 70, "ExampleText",
 CellID->2701364],
Cell[CellGroupData[{
Cell[11808, 392, 187, 7, 70, "Input",
 CellID->42670547],
Cell[11998, 401, 230, 7, 36, "Output",
 CellID->704545229]
}, Open  ]],
Cell[12243, 411, 271, 9, 70, "ExampleText",
 CellID->218578346],
Cell[CellGroupData[{
Cell[12539, 424, 249, 9, 70, "Input",
 CellID->105360712],
Cell[12791, 435, 193, 6, 36, "Output",
 CellID->144102737]
}, Open  ]],
Cell[12999, 444, 256, 8, 70, "ExampleText",
 CellID->127673232],
Cell[CellGroupData[{
Cell[13280, 456, 210, 7, 70, "Input",
 CellID->14374894],
Cell[13493, 465, 180, 6, 36, "Output",
 CellID->606077012]
}, Open  ]],
Cell[13688, 474, 124, 3, 70, "ExampleDelimiter",
 CellID->51010884],
Cell[13815, 479, 207, 7, 70, "ExampleText",
 CellID->2113989541],
Cell[CellGroupData[{
Cell[14047, 490, 116, 3, 70, "Input",
 CellID->1852759619],
Cell[14166, 495, 264, 8, 50, "Output",
 CellID->194359495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14479, 509, 235, 7, 70, "ExampleSection",
 CellID->8531461],
Cell[14717, 518, 818, 32, 70, "ExampleText",
 CellID->112558139],
Cell[CellGroupData[{
Cell[15560, 554, 425, 14, 70, "Input",
 CellID->155047900],
Cell[15988, 570, 252, 8, 36, "Output",
 CellID->123809087]
}, Open  ]],
Cell[16255, 581, 125, 3, 70, "ExampleDelimiter",
 CellID->350572424],
Cell[16383, 586, 235, 8, 70, "ExampleText",
 CellID->70410547],
Cell[CellGroupData[{
Cell[16643, 598, 271, 8, 70, "Input",
 CellID->48621932],
Cell[16917, 608, 212, 7, 36, "Output",
 CellID->414962604]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17190, 622, 311, 9, 70, "SeeAlsoSection",
 CellID->18113],
Cell[17504, 633, 1419, 53, 70, "SeeAlso",
 CellID->27676]
}, Open  ]],
Cell[CellGroupData[{
Cell[18960, 691, 314, 9, 70, "TutorialsSection",
 CellID->12716],
Cell[19277, 702, 144, 3, 70, "Tutorials",
 CellID->12341],
Cell[19424, 707, 188, 4, 70, "Tutorials",
 CellID->19824]
}, Open  ]],
Cell[CellGroupData[{
Cell[19649, 716, 318, 9, 70, "MoreAboutSection",
 CellID->90648033],
Cell[19970, 727, 155, 3, 70, "MoreAbout",
 CellID->90132176],
Cell[20128, 732, 146, 3, 70, "MoreAbout",
 CellID->76574940]
}, Open  ]],
Cell[20289, 738, 27, 0, 70, "History"],
Cell[20319, 740, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

