(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14013,        496]
NotebookOptionsPosition[     11138,        399]
NotebookOutlinePosition[     12422,        435]
CellTagsIndexPosition[     12337,        430]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Building Lists from Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BuildingListsFromFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Building Lists from Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Composition" :> 
          Documentation`HelpLookup["paclet:ref/Composition"], "NestList" :> 
          Documentation`HelpLookup["paclet:ref/NestList"], "FoldList" :> 
          Documentation`HelpLookup["paclet:ref/FoldList"], "NestWhileList" :> 
          Documentation`HelpLookup["paclet:ref/NestWhileList"], 
          "FixedPointList" :> 
          Documentation`HelpLookup["paclet:ref/FixedPointList"], 
          "ComposeSeries" :> 
          Documentation`HelpLookup["paclet:ref/ComposeSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Composition\"\>", 
       2->"\<\"NestList\"\>", 3->"\<\"FoldList\"\>", 
       4->"\<\"NestWhileList\"\>", 5->"\<\"FixedPointList\"\>", 
       6->"\<\"ComposeSeries\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/ApplyingFunctionsToLists"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Applying Functions to Lists\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ComposeList", "ObjectName",
 CellID->24084],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ComposeList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ComposeList"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of the form ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["1", "TR"]], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["2", "TR"]], "[", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], "[", 
          StyleBox["x", "TI"], "]"}], "]"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19954]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->298121366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"a", "[", "x", "]"}], ",", 
   RowBox[{"b", "[", 
    RowBox[{"a", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"c", "[", 
    RowBox[{"b", "[", 
     RowBox[{"a", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"d", "[", 
    RowBox[{"c", "[", 
     RowBox[{"b", "[", 
      RowBox[{"a", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5537]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16541],

Cell["Specify a sequence of function applications:", "ExampleText",
 CellID->4833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "g"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}], 
    "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"g", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"g", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"g", "[", 
       RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29658],

Cell["Apply two operations that generate a group:", "ExampleText",
 CellID->22704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", "#"}], "&"}], ",", 
      RowBox[{
       RowBox[{"1", "/", "#"}], "&"}]}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "1"}], "}"}], 
     "]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FractionBox["1", "x"], ",", "x", ",", 
   RowBox[{"1", "-", "x"}], ",", 
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   RowBox[{"1", "-", "x"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{202, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13977]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13931],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Composition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Composition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPointList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPointList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeSeries"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26308]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18756],

Cell[TextData[ButtonBox["Building Lists from Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BuildingListsFromFunctions"]], "Tutorials",
 CellID->11840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->412627324]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ComposeList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 49.8388406}", "context" -> "System`", 
    "keywords" -> {"composition of functions", "functional composition"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ComposeList[{f_1, f_2, ...}, x] generates a list of the form {x, f_1[x], \
f_2[f_1[x]], ...}. ", "synonyms" -> {"compose list"}, "title" -> 
    "ComposeList", "type" -> "Symbol", "uri" -> "ref/ComposeList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4474, 137, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12202, 423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2382, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3005, 84, 49, 1, 70, "ObjectName",
 CellID->24084],
Cell[3057, 87, 1380, 45, 70, "Usage",
 CellID->19954]
}, Open  ]],
Cell[CellGroupData[{
Cell[4474, 137, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4851, 151, 148, 5, 70, "ExampleSection",
 CellID->298121366],
Cell[CellGroupData[{
Cell[5024, 160, 198, 7, 28, "Input",
 CellID->11323],
Cell[5225, 169, 529, 17, 36, "Output",
 CellID->5537]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5803, 192, 223, 7, 70, "ExampleSection",
 CellID->16541],
Cell[6029, 201, 82, 1, 70, "ExampleText",
 CellID->4833],
Cell[CellGroupData[{
Cell[6136, 206, 319, 11, 70, "Input",
 CellID->31115],
Cell[6458, 219, 697, 23, 36, "Output",
 CellID->4639]
}, Open  ]],
Cell[7170, 245, 121, 3, 70, "ExampleDelimiter",
 CellID->29658],
Cell[7294, 250, 82, 1, 70, "ExampleText",
 CellID->22704],
Cell[CellGroupData[{
Cell[7401, 255, 429, 15, 70, "Input",
 CellID->9930],
Cell[7833, 272, 367, 12, 51, "Output",
 CellID->13977]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8261, 291, 311, 9, 70, "SeeAlsoSection",
 CellID->13931],
Cell[8575, 302, 1469, 53, 70, "SeeAlso",
 CellID->26308]
}, Open  ]],
Cell[CellGroupData[{
Cell[10081, 360, 314, 9, 70, "TutorialsSection",
 CellID->18756],
Cell[10398, 371, 166, 3, 70, "Tutorials",
 CellID->11840]
}, Open  ]],
Cell[CellGroupData[{
Cell[10601, 379, 299, 8, 70, "MoreAboutSection"],
Cell[10903, 389, 163, 3, 70, "MoreAbout",
 CellID->412627324]
}, Open  ]],
Cell[11081, 395, 27, 0, 70, "History"],
Cell[11111, 397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

